package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserAuthenticateOptions invokes the idaas_doraemon.CreateUserAuthenticateOptions API synchronously
func (client *Client) CreateUserAuthenticateOptions(request *CreateUserAuthenticateOptionsRequest) (response *CreateUserAuthenticateOptionsResponse, err error) {
	response = CreateCreateUserAuthenticateOptionsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserAuthenticateOptionsWithChan invokes the idaas_doraemon.CreateUserAuthenticateOptions API asynchronously
func (client *Client) CreateUserAuthenticateOptionsWithChan(request *CreateUserAuthenticateOptionsRequest) (<-chan *CreateUserAuthenticateOptionsResponse, <-chan error) {
	responseChan := make(chan *CreateUserAuthenticateOptionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserAuthenticateOptions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserAuthenticateOptionsWithCallback invokes the idaas_doraemon.CreateUserAuthenticateOptions API asynchronously
func (client *Client) CreateUserAuthenticateOptionsWithCallback(request *CreateUserAuthenticateOptionsRequest, callback func(response *CreateUserAuthenticateOptionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserAuthenticateOptionsResponse
		var err error
		defer close(result)
		response, err = client.CreateUserAuthenticateOptions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserAuthenticateOptionsRequest is the request struct for api CreateUserAuthenticateOptions
type CreateUserAuthenticateOptionsRequest struct {
	*requests.RpcRequest
	ClientExtendParamsJson     string `position:"Query" name:"ClientExtendParamsJson"`
	UserId                     string `position:"Query" name:"UserId"`
	BindHashBase64             string `position:"Query" name:"BindHashBase64"`
	ServerExtendParamsJson     string `position:"Query" name:"ServerExtendParamsJson"`
	AuthenticatorType          string `position:"Query" name:"AuthenticatorType"`
	ClientExtendParamsJsonSign string `position:"Query" name:"ClientExtendParamsJsonSign"`
	ApplicationExternalId      string `position:"Query" name:"ApplicationExternalId"`
}

// CreateUserAuthenticateOptionsResponse is the response struct for api CreateUserAuthenticateOptions
type CreateUserAuthenticateOptionsResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ChallengeBase64 string `json:"ChallengeBase64" xml:"ChallengeBase64"`
	Options         string `json:"Options" xml:"Options"`
}

// CreateCreateUserAuthenticateOptionsRequest creates a request to invoke CreateUserAuthenticateOptions API
func CreateCreateUserAuthenticateOptionsRequest() (request *CreateUserAuthenticateOptionsRequest) {
	request = &CreateUserAuthenticateOptionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "CreateUserAuthenticateOptions", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateUserAuthenticateOptionsResponse creates a response to parse from CreateUserAuthenticateOptions response
func CreateCreateUserAuthenticateOptionsResponse() (response *CreateUserAuthenticateOptionsResponse) {
	response = &CreateUserAuthenticateOptionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
