package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateConsumerGroup invokes the iot.UpdateConsumerGroup API synchronously
func (client *Client) UpdateConsumerGroup(request *UpdateConsumerGroupRequest) (response *UpdateConsumerGroupResponse, err error) {
	response = CreateUpdateConsumerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateConsumerGroupWithChan invokes the iot.UpdateConsumerGroup API asynchronously
func (client *Client) UpdateConsumerGroupWithChan(request *UpdateConsumerGroupRequest) (<-chan *UpdateConsumerGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateConsumerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateConsumerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateConsumerGroupWithCallback invokes the iot.UpdateConsumerGroup API asynchronously
func (client *Client) UpdateConsumerGroupWithCallback(request *UpdateConsumerGroupRequest, callback func(response *UpdateConsumerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateConsumerGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateConsumerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateConsumerGroupRequest is the request struct for api UpdateConsumerGroup
type UpdateConsumerGroupRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	GroupId       string `position:"Query" name:"GroupId"`
	NewGroupName  string `position:"Query" name:"NewGroupName"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// UpdateConsumerGroupResponse is the response struct for api UpdateConsumerGroup
type UpdateConsumerGroupResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
}

// CreateUpdateConsumerGroupRequest creates a request to invoke UpdateConsumerGroup API
func CreateUpdateConsumerGroupRequest() (request *UpdateConsumerGroupRequest) {
	request = &UpdateConsumerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateConsumerGroup", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateConsumerGroupResponse creates a response to parse from UpdateConsumerGroup response
func CreateUpdateConsumerGroupResponse() (response *UpdateConsumerGroupResponse) {
	response = &UpdateConsumerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
