package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateSSLCert invokes the mse.UpdateSSLCert API synchronously
func (client *Client) UpdateSSLCert(request *UpdateSSLCertRequest) (response *UpdateSSLCertResponse, err error) {
	response = CreateUpdateSSLCertResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateSSLCertWithChan invokes the mse.UpdateSSLCert API asynchronously
func (client *Client) UpdateSSLCertWithChan(request *UpdateSSLCertRequest) (<-chan *UpdateSSLCertResponse, <-chan error) {
	responseChan := make(chan *UpdateSSLCertResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateSSLCert(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateSSLCertWithCallback invokes the mse.UpdateSSLCert API asynchronously
func (client *Client) UpdateSSLCertWithCallback(request *UpdateSSLCertRequest, callback func(response *UpdateSSLCertResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateSSLCertResponse
		var err error
		defer close(result)
		response, err = client.UpdateSSLCert(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateSSLCertRequest is the request struct for api UpdateSSLCert
type UpdateSSLCertRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	DomainId        requests.Integer `position:"Query" name:"DomainId"`
	CertIdentifier  string           `position:"Query" name:"CertIdentifier"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// UpdateSSLCertResponse is the response struct for api UpdateSSLCert
type UpdateSSLCertResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateUpdateSSLCertRequest creates a request to invoke UpdateSSLCert API
func CreateUpdateSSLCertRequest() (request *UpdateSSLCertRequest) {
	request = &UpdateSSLCertRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "UpdateSSLCert", "mse", "openAPI")
	request.Method = requests.GET
	return
}

// CreateUpdateSSLCertResponse creates a response to parse from UpdateSSLCert response
func CreateUpdateSSLCertResponse() (response *UpdateSSLCertResponse) {
	response = &UpdateSSLCertResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
