package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInferenceServer invokes the mts.CreateInferenceServer API synchronously
func (client *Client) CreateInferenceServer(request *CreateInferenceServerRequest) (response *CreateInferenceServerResponse, err error) {
	response = CreateCreateInferenceServerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInferenceServerWithChan invokes the mts.CreateInferenceServer API asynchronously
func (client *Client) CreateInferenceServerWithChan(request *CreateInferenceServerRequest) (<-chan *CreateInferenceServerResponse, <-chan error) {
	responseChan := make(chan *CreateInferenceServerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInferenceServer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInferenceServerWithCallback invokes the mts.CreateInferenceServer API asynchronously
func (client *Client) CreateInferenceServerWithCallback(request *CreateInferenceServerRequest, callback func(response *CreateInferenceServerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInferenceServerResponse
		var err error
		defer close(result)
		response, err = client.CreateInferenceServer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInferenceServerRequest is the request struct for api CreateInferenceServer
type CreateInferenceServerRequest struct {
	*requests.RpcRequest
	PipelineId   string `position:"Query" name:"PipelineId"`
	UserData     string `position:"Query" name:"UserData"`
	ModelType    string `position:"Query" name:"ModelType"`
	FunctionName string `position:"Query" name:"FunctionName"`
	TestId       string `position:"Query" name:"TestId"`
	ModelPath    string `position:"Query" name:"ModelPath"`
}

// CreateInferenceServerResponse is the response struct for api CreateInferenceServer
type CreateInferenceServerResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateCreateInferenceServerRequest creates a request to invoke CreateInferenceServer API
func CreateCreateInferenceServerRequest() (request *CreateInferenceServerRequest) {
	request = &CreateInferenceServerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "CreateInferenceServer", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateInferenceServerResponse creates a response to parse from CreateInferenceServer response
func CreateCreateInferenceServerResponse() (response *CreateInferenceServerResponse) {
	response = &CreateInferenceServerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
