package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsMqttGroupIdDelete invokes the ons.OnsMqttGroupIdDelete API synchronously
func (client *Client) OnsMqttGroupIdDelete(request *OnsMqttGroupIdDeleteRequest) (response *OnsMqttGroupIdDeleteResponse, err error) {
	response = CreateOnsMqttGroupIdDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// OnsMqttGroupIdDeleteWithChan invokes the ons.OnsMqttGroupIdDelete API asynchronously
func (client *Client) OnsMqttGroupIdDeleteWithChan(request *OnsMqttGroupIdDeleteRequest) (<-chan *OnsMqttGroupIdDeleteResponse, <-chan error) {
	responseChan := make(chan *OnsMqttGroupIdDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsMqttGroupIdDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsMqttGroupIdDeleteWithCallback invokes the ons.OnsMqttGroupIdDelete API asynchronously
func (client *Client) OnsMqttGroupIdDeleteWithCallback(request *OnsMqttGroupIdDeleteRequest, callback func(response *OnsMqttGroupIdDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsMqttGroupIdDeleteResponse
		var err error
		defer close(result)
		response, err = client.OnsMqttGroupIdDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsMqttGroupIdDeleteRequest is the request struct for api OnsMqttGroupIdDelete
type OnsMqttGroupIdDeleteRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// OnsMqttGroupIdDeleteResponse is the response struct for api OnsMqttGroupIdDelete
type OnsMqttGroupIdDeleteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
}

// CreateOnsMqttGroupIdDeleteRequest creates a request to invoke OnsMqttGroupIdDelete API
func CreateOnsMqttGroupIdDeleteRequest() (request *OnsMqttGroupIdDeleteRequest) {
	request = &OnsMqttGroupIdDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsMqttGroupIdDelete", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsMqttGroupIdDeleteResponse creates a response to parse from OnsMqttGroupIdDelete response
func CreateOnsMqttGroupIdDeleteResponse() (response *OnsMqttGroupIdDeleteResponse) {
	response = &OnsMqttGroupIdDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
