package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaxTypeForAli invokes the companyreg.GetTaxTypeForAli API synchronously
func (client *Client) GetTaxTypeForAli(request *GetTaxTypeForAliRequest) (response *GetTaxTypeForAliResponse, err error) {
	response = CreateGetTaxTypeForAliResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaxTypeForAliWithChan invokes the companyreg.GetTaxTypeForAli API asynchronously
func (client *Client) GetTaxTypeForAliWithChan(request *GetTaxTypeForAliRequest) (<-chan *GetTaxTypeForAliResponse, <-chan error) {
	responseChan := make(chan *GetTaxTypeForAliResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaxTypeForAli(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaxTypeForAliWithCallback invokes the companyreg.GetTaxTypeForAli API asynchronously
func (client *Client) GetTaxTypeForAliWithCallback(request *GetTaxTypeForAliRequest, callback func(response *GetTaxTypeForAliResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaxTypeForAliResponse
		var err error
		defer close(result)
		response, err = client.GetTaxTypeForAli(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaxTypeForAliRequest is the request struct for api GetTaxTypeForAli
type GetTaxTypeForAliRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetTaxTypeForAliResponse is the response struct for api GetTaxTypeForAli
type GetTaxTypeForAliResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	TaxTypeList []TaxTypeListItem `json:"TaxTypeList" xml:"TaxTypeList"`
}

// CreateGetTaxTypeForAliRequest creates a request to invoke GetTaxTypeForAli API
func CreateGetTaxTypeForAliRequest() (request *GetTaxTypeForAliRequest) {
	request = &GetTaxTypeForAliRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetTaxTypeForAli", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTaxTypeForAliResponse creates a response to parse from GetTaxTypeForAli response
func CreateGetTaxTypeForAliResponse() (response *GetTaxTypeForAliResponse) {
	response = &GetTaxTypeForAliResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
