package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTaxationInfo invokes the companyreg.GetTaxationInfo API synchronously
func (client *Client) GetTaxationInfo(request *GetTaxationInfoRequest) (response *GetTaxationInfoResponse, err error) {
	response = CreateGetTaxationInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetTaxationInfoWithChan invokes the companyreg.GetTaxationInfo API asynchronously
func (client *Client) GetTaxationInfoWithChan(request *GetTaxationInfoRequest) (<-chan *GetTaxationInfoResponse, <-chan error) {
	responseChan := make(chan *GetTaxationInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTaxationInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTaxationInfoWithCallback invokes the companyreg.GetTaxationInfo API asynchronously
func (client *Client) GetTaxationInfoWithCallback(request *GetTaxationInfoRequest, callback func(response *GetTaxationInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTaxationInfoResponse
		var err error
		defer close(result)
		response, err = client.GetTaxationInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTaxationInfoRequest is the request struct for api GetTaxationInfo
type GetTaxationInfoRequest struct {
	*requests.RpcRequest
	Period string `position:"Query" name:"Period"`
	BizId  string `position:"Query" name:"BizId"`
}

// GetTaxationInfoResponse is the response struct for api GetTaxationInfo
type GetTaxationInfoResponse struct {
	*responses.BaseResponse
	DeclareProcessType string                  `json:"DeclareProcessType" xml:"DeclareProcessType"`
	RequestId          string                  `json:"RequestId" xml:"RequestId"`
	TaxItemDetailList  []TaxItemDetailListItem `json:"TaxItemDetailList" xml:"TaxItemDetailList"`
}

// CreateGetTaxationInfoRequest creates a request to invoke GetTaxationInfo API
func CreateGetTaxationInfoRequest() (request *GetTaxationInfoRequest) {
	request = &GetTaxationInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetTaxationInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTaxationInfoResponse creates a response to parse from GetTaxationInfo response
func CreateGetTaxationInfoResponse() (response *GetTaxationInfoResponse) {
	response = &GetTaxationInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
