package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTypeList invokes the companyreg.GetTypeList API synchronously
func (client *Client) GetTypeList(request *GetTypeListRequest) (response *GetTypeListResponse, err error) {
	response = CreateGetTypeListResponse()
	err = client.DoAction(request, response)
	return
}

// GetTypeListWithChan invokes the companyreg.GetTypeList API asynchronously
func (client *Client) GetTypeListWithChan(request *GetTypeListRequest) (<-chan *GetTypeListResponse, <-chan error) {
	responseChan := make(chan *GetTypeListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTypeList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTypeListWithCallback invokes the companyreg.GetTypeList API asynchronously
func (client *Client) GetTypeListWithCallback(request *GetTypeListRequest, callback func(response *GetTypeListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTypeListResponse
		var err error
		defer close(result)
		response, err = client.GetTypeList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTypeListRequest is the request struct for api GetTypeList
type GetTypeListRequest struct {
	*requests.RpcRequest
	BizId string `position:"Query" name:"BizId"`
}

// GetTypeListResponse is the response struct for api GetTypeList
type GetTypeListResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Fee        Fee        `json:"Fee" xml:"Fee"`
	InInvoice  InInvoice  `json:"InInvoice" xml:"InInvoice"`
	OutInvoice OutInvoice `json:"OutInvoice" xml:"OutInvoice"`
}

// CreateGetTypeListRequest creates a request to invoke GetTypeList API
func CreateGetTypeListRequest() (request *GetTypeListRequest) {
	request = &GetTypeListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-10-22", "GetTypeList", "", "")
	request.Method = requests.GET
	return
}

// CreateGetTypeListResponse creates a response to parse from GetTypeList response
func CreateGetTypeListResponse() (response *GetTypeListResponse) {
	response = &GetTypeListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
