package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchBindProductsIntoProject invokes the iot.BatchBindProductsIntoProject API synchronously
func (client *Client) BatchBindProductsIntoProject(request *BatchBindProductsIntoProjectRequest) (response *BatchBindProductsIntoProjectResponse, err error) {
	response = CreateBatchBindProductsIntoProjectResponse()
	err = client.DoAction(request, response)
	return
}

// BatchBindProductsIntoProjectWithChan invokes the iot.BatchBindProductsIntoProject API asynchronously
func (client *Client) BatchBindProductsIntoProjectWithChan(request *BatchBindProductsIntoProjectRequest) (<-chan *BatchBindProductsIntoProjectResponse, <-chan error) {
	responseChan := make(chan *BatchBindProductsIntoProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchBindProductsIntoProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchBindProductsIntoProjectWithCallback invokes the iot.BatchBindProductsIntoProject API asynchronously
func (client *Client) BatchBindProductsIntoProjectWithCallback(request *BatchBindProductsIntoProjectRequest, callback func(response *BatchBindProductsIntoProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchBindProductsIntoProjectResponse
		var err error
		defer close(result)
		response, err = client.BatchBindProductsIntoProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchBindProductsIntoProjectRequest is the request struct for api BatchBindProductsIntoProject
type BatchBindProductsIntoProjectRequest struct {
	*requests.RpcRequest
	ProductKeys   *[]string `position:"Body" name:"ProductKeys"  type:"Repeated"`
	IotInstanceId string    `position:"Body" name:"IotInstanceId"`
	ProjectId     string    `position:"Body" name:"ProjectId"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
}

// BatchBindProductsIntoProjectResponse is the response struct for api BatchBindProductsIntoProject
type BatchBindProductsIntoProjectResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         bool   `json:"Data" xml:"Data"`
}

// CreateBatchBindProductsIntoProjectRequest creates a request to invoke BatchBindProductsIntoProject API
func CreateBatchBindProductsIntoProjectRequest() (request *BatchBindProductsIntoProjectRequest) {
	request = &BatchBindProductsIntoProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "BatchBindProductsIntoProject", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchBindProductsIntoProjectResponse creates a response to parse from BatchBindProductsIntoProject response
func CreateBatchBindProductsIntoProjectResponse() (response *BatchBindProductsIntoProjectResponse) {
	response = &BatchBindProductsIntoProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
