package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGatewayDomain invokes the mse.AddGatewayDomain API synchronously
func (client *Client) AddGatewayDomain(request *AddGatewayDomainRequest) (response *AddGatewayDomainResponse, err error) {
	response = CreateAddGatewayDomainResponse()
	err = client.DoAction(request, response)
	return
}

// AddGatewayDomainWithChan invokes the mse.AddGatewayDomain API asynchronously
func (client *Client) AddGatewayDomainWithChan(request *AddGatewayDomainRequest) (<-chan *AddGatewayDomainResponse, <-chan error) {
	responseChan := make(chan *AddGatewayDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGatewayDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGatewayDomainWithCallback invokes the mse.AddGatewayDomain API asynchronously
func (client *Client) AddGatewayDomainWithCallback(request *AddGatewayDomainRequest, callback func(response *AddGatewayDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGatewayDomainResponse
		var err error
		defer close(result)
		response, err = client.AddGatewayDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGatewayDomainRequest is the request struct for api AddGatewayDomain
type AddGatewayDomainRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	Protocol        string           `position:"Query" name:"Protocol"`
	MustHttps       requests.Boolean `position:"Query" name:"MustHttps"`
	CertIdentifier  string           `position:"Query" name:"CertIdentifier"`
	Name            string           `position:"Query" name:"Name"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// AddGatewayDomainResponse is the response struct for api AddGatewayDomain
type AddGatewayDomainResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateAddGatewayDomainRequest creates a request to invoke AddGatewayDomain API
func CreateAddGatewayDomainRequest() (request *AddGatewayDomainRequest) {
	request = &AddGatewayDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddGatewayDomain", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddGatewayDomainResponse creates a response to parse from AddGatewayDomain response
func CreateAddGatewayDomainResponse() (response *AddGatewayDomainResponse) {
	response = &AddGatewayDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
