package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAppMonitors invokes the retailcloud.CreateAppMonitors API synchronously
func (client *Client) CreateAppMonitors(request *CreateAppMonitorsRequest) (response *CreateAppMonitorsResponse, err error) {
	response = CreateCreateAppMonitorsResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAppMonitorsWithChan invokes the retailcloud.CreateAppMonitors API asynchronously
func (client *Client) CreateAppMonitorsWithChan(request *CreateAppMonitorsRequest) (<-chan *CreateAppMonitorsResponse, <-chan error) {
	responseChan := make(chan *CreateAppMonitorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAppMonitors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAppMonitorsWithCallback invokes the retailcloud.CreateAppMonitors API asynchronously
func (client *Client) CreateAppMonitorsWithCallback(request *CreateAppMonitorsRequest, callback func(response *CreateAppMonitorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAppMonitorsResponse
		var err error
		defer close(result)
		response, err = client.CreateAppMonitors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAppMonitorsRequest is the request struct for api CreateAppMonitors
type CreateAppMonitorsRequest struct {
	*requests.RpcRequest
	AppIds          *[]string        `position:"Body" name:"AppIds"  type:"Repeated"`
	MainUserId      requests.Integer `position:"Query" name:"MainUserId"`
	EnvType         requests.Integer `position:"Query" name:"EnvType"`
	AlarmTemplateId requests.Integer `position:"Query" name:"AlarmTemplateId"`
	SilenceTime     string           `position:"Query" name:"SilenceTime"`
}

// CreateAppMonitorsResponse is the response struct for api CreateAppMonitors
type CreateAppMonitorsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateAppMonitorsRequest creates a request to invoke CreateAppMonitors API
func CreateCreateAppMonitorsRequest() (request *CreateAppMonitorsRequest) {
	request = &CreateAppMonitorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "CreateAppMonitors", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAppMonitorsResponse creates a response to parse from CreateAppMonitors response
func CreateCreateAppMonitorsResponse() (response *CreateAppMonitorsResponse) {
	response = &CreateAppMonitorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
