package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePropertyProcDetail invokes the sas.DescribePropertyProcDetail API synchronously
func (client *Client) DescribePropertyProcDetail(request *DescribePropertyProcDetailRequest) (response *DescribePropertyProcDetailResponse, err error) {
	response = CreateDescribePropertyProcDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePropertyProcDetailWithChan invokes the sas.DescribePropertyProcDetail API asynchronously
func (client *Client) DescribePropertyProcDetailWithChan(request *DescribePropertyProcDetailRequest) (<-chan *DescribePropertyProcDetailResponse, <-chan error) {
	responseChan := make(chan *DescribePropertyProcDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePropertyProcDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePropertyProcDetailWithCallback invokes the sas.DescribePropertyProcDetail API asynchronously
func (client *Client) DescribePropertyProcDetailWithCallback(request *DescribePropertyProcDetailRequest, callback func(response *DescribePropertyProcDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePropertyProcDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribePropertyProcDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePropertyProcDetailRequest is the request struct for api DescribePropertyProcDetail
type DescribePropertyProcDetailRequest struct {
	*requests.RpcRequest
	Remark      string           `position:"Query" name:"Remark"`
	Uuid        string           `position:"Query" name:"Uuid"`
	Cmdline     string           `position:"Query" name:"Cmdline"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Name        string           `position:"Query" name:"Name"`
	User        string           `position:"Query" name:"User"`
}

// DescribePropertyProcDetailResponse is the response struct for api DescribePropertyProcDetail
type DescribePropertyProcDetailResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo       `json:"PageInfo" xml:"PageInfo"`
	Propertys []PropertyProc `json:"Propertys" xml:"Propertys"`
}

// CreateDescribePropertyProcDetailRequest creates a request to invoke DescribePropertyProcDetail API
func CreateDescribePropertyProcDetailRequest() (request *DescribePropertyProcDetailRequest) {
	request = &DescribePropertyProcDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribePropertyProcDetail", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePropertyProcDetailResponse creates a response to parse from DescribePropertyProcDetail response
func CreateDescribePropertyProcDetailResponse() (response *DescribePropertyProcDetailResponse) {
	response = &DescribePropertyProcDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
