package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySlot invokes the unimkt.QuerySlot API synchronously
func (client *Client) QuerySlot(request *QuerySlotRequest) (response *QuerySlotResponse, err error) {
	response = CreateQuerySlotResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySlotWithChan invokes the unimkt.QuerySlot API asynchronously
func (client *Client) QuerySlotWithChan(request *QuerySlotRequest) (<-chan *QuerySlotResponse, <-chan error) {
	responseChan := make(chan *QuerySlotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySlot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySlotWithCallback invokes the unimkt.QuerySlot API asynchronously
func (client *Client) QuerySlotWithCallback(request *QuerySlotRequest, callback func(response *QuerySlotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySlotResponse
		var err error
		defer close(result)
		response, err = client.QuerySlot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySlotRequest is the request struct for api QuerySlot
type QuerySlotRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	AdSlotId         string `position:"Query" name:"AdSlotId"`
	UserSite         string `position:"Query" name:"UserSite"`
}

// QuerySlotResponse is the response struct for api QuerySlot
type QuerySlotResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateQuerySlotRequest creates a request to invoke QuerySlot API
func CreateQuerySlotRequest() (request *QuerySlotRequest) {
	request = &QuerySlotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QuerySlot", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQuerySlotResponse creates a response to parse from QuerySlot response
func CreateQuerySlotResponse() (response *QuerySlotResponse) {
	response = &QuerySlotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
