package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveUsersFromSkillGroup invokes the ccc.RemoveUsersFromSkillGroup API synchronously
func (client *Client) RemoveUsersFromSkillGroup(request *RemoveUsersFromSkillGroupRequest) (response *RemoveUsersFromSkillGroupResponse, err error) {
	response = CreateRemoveUsersFromSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveUsersFromSkillGroupWithChan invokes the ccc.RemoveUsersFromSkillGroup API asynchronously
func (client *Client) RemoveUsersFromSkillGroupWithChan(request *RemoveUsersFromSkillGroupRequest) (<-chan *RemoveUsersFromSkillGroupResponse, <-chan error) {
	responseChan := make(chan *RemoveUsersFromSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveUsersFromSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveUsersFromSkillGroupWithCallback invokes the ccc.RemoveUsersFromSkillGroup API asynchronously
func (client *Client) RemoveUsersFromSkillGroupWithCallback(request *RemoveUsersFromSkillGroupRequest, callback func(response *RemoveUsersFromSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveUsersFromSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.RemoveUsersFromSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveUsersFromSkillGroupRequest is the request struct for api RemoveUsersFromSkillGroup
type RemoveUsersFromSkillGroupRequest struct {
	*requests.RpcRequest
	UserId       *[]string `position:"Query" name:"UserId"  type:"Repeated"`
	InstanceId   string    `position:"Query" name:"InstanceId"`
	SkillGroupId string    `position:"Query" name:"SkillGroupId"`
}

// RemoveUsersFromSkillGroupResponse is the response struct for api RemoveUsersFromSkillGroup
type RemoveUsersFromSkillGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateRemoveUsersFromSkillGroupRequest creates a request to invoke RemoveUsersFromSkillGroup API
func CreateRemoveUsersFromSkillGroupRequest() (request *RemoveUsersFromSkillGroupRequest) {
	request = &RemoveUsersFromSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "RemoveUsersFromSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateRemoveUsersFromSkillGroupResponse creates a response to parse from RemoveUsersFromSkillGroup response
func CreateRemoveUsersFromSkillGroupResponse() (response *RemoveUsersFromSkillGroupResponse) {
	response = &RemoveUsersFromSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
