package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRecordOssUploadParam invokes the cloudcallcenter.GetRecordOssUploadParam API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getrecordossuploadparam.html
func (client *Client) GetRecordOssUploadParam(request *GetRecordOssUploadParamRequest) (response *GetRecordOssUploadParamResponse, err error) {
	response = CreateGetRecordOssUploadParamResponse()
	err = client.DoAction(request, response)
	return
}

// GetRecordOssUploadParamWithChan invokes the cloudcallcenter.GetRecordOssUploadParam API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getrecordossuploadparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRecordOssUploadParamWithChan(request *GetRecordOssUploadParamRequest) (<-chan *GetRecordOssUploadParamResponse, <-chan error) {
	responseChan := make(chan *GetRecordOssUploadParamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRecordOssUploadParam(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRecordOssUploadParamWithCallback invokes the cloudcallcenter.GetRecordOssUploadParam API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getrecordossuploadparam.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRecordOssUploadParamWithCallback(request *GetRecordOssUploadParamRequest, callback func(response *GetRecordOssUploadParamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRecordOssUploadParamResponse
		var err error
		defer close(result)
		response, err = client.GetRecordOssUploadParam(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRecordOssUploadParamRequest is the request struct for api GetRecordOssUploadParam
type GetRecordOssUploadParamRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	FileName   string `position:"Query" name:"FileName"`
}

// GetRecordOssUploadParamResponse is the response struct for api GetRecordOssUploadParam
type GetRecordOssUploadParamResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	OssAccessKeyId string `json:"OssAccessKeyId" xml:"OssAccessKeyId"`
	Policy         string `json:"Policy" xml:"Policy"`
	Signature      string `json:"Signature" xml:"Signature"`
	Expires        string `json:"Expires" xml:"Expires"`
	Dir            string `json:"Dir" xml:"Dir"`
	Host           string `json:"Host" xml:"Host"`
	OssFileName    string `json:"OssFileName" xml:"OssFileName"`
}

// CreateGetRecordOssUploadParamRequest creates a request to invoke GetRecordOssUploadParam API
func CreateGetRecordOssUploadParamRequest() (request *GetRecordOssUploadParamRequest) {
	request = &GetRecordOssUploadParamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetRecordOssUploadParam", "", "")
	request.Method = requests.POST
	return
}

// CreateGetRecordOssUploadParamResponse creates a response to parse from GetRecordOssUploadParam response
func CreateGetRecordOssUploadParamResponse() (response *GetRecordOssUploadParamResponse) {
	response = &GetRecordOssUploadParamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
