package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitSparkJob invokes the dms_enterprise.SubmitSparkJob API synchronously
func (client *Client) SubmitSparkJob(request *SubmitSparkJobRequest) (response *SubmitSparkJobResponse, err error) {
	response = CreateSubmitSparkJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitSparkJobWithChan invokes the dms_enterprise.SubmitSparkJob API asynchronously
func (client *Client) SubmitSparkJobWithChan(request *SubmitSparkJobRequest) (<-chan *SubmitSparkJobResponse, <-chan error) {
	responseChan := make(chan *SubmitSparkJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitSparkJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitSparkJobWithCallback invokes the dms_enterprise.SubmitSparkJob API asynchronously
func (client *Client) SubmitSparkJobWithCallback(request *SubmitSparkJobRequest, callback func(response *SubmitSparkJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitSparkJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitSparkJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitSparkJobRequest is the request struct for api SubmitSparkJob
type SubmitSparkJobRequest struct {
	*requests.RpcRequest
	MainClass     string                `position:"Body" name:"MainClass"`
	Configuration map[string]string     `position:"Body" name:"Configuration"  type:"Map"`
	OssInfo       SubmitSparkJobOssInfo `position:"Body" name:"OssInfo"  type:"Struct"`
	Tid           requests.Integer      `position:"Query" name:"Tid"`
	MainFile      string                `position:"Body" name:"MainFile"`
	Name          string                `position:"Body" name:"Name"`
	Files         *[]string             `position:"Body" name:"Files"  type:"Json"`
	AppCode       string                `position:"Body" name:"AppCode"`
	Arguments     *[]string             `position:"Body" name:"Arguments"  type:"Json"`
}

// SubmitSparkJobOssInfo is a repeated param struct in SubmitSparkJobRequest
type SubmitSparkJobOssInfo struct {
	Endpoint        string `name:"Endpoint"`
	AccessKeySecret string `name:"AccessKeySecret"`
	AccessKeyId     string `name:"AccessKeyId"`
}

// SubmitSparkJobResponse is the response struct for api SubmitSparkJob
type SubmitSparkJobResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	JobId        int64  `json:"JobId" xml:"JobId"`
}

// CreateSubmitSparkJobRequest creates a request to invoke SubmitSparkJob API
func CreateSubmitSparkJobRequest() (request *SubmitSparkJobRequest) {
	request = &SubmitSparkJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "SubmitSparkJob", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitSparkJobResponse creates a response to parse from SubmitSparkJob response
func CreateSubmitSparkJobResponse() (response *SubmitSparkJobResponse) {
	response = &SubmitSparkJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
