package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMockRuleByConsumerAppId invokes the edas.GetMockRuleByConsumerAppId API synchronously
func (client *Client) GetMockRuleByConsumerAppId(request *GetMockRuleByConsumerAppIdRequest) (response *GetMockRuleByConsumerAppIdResponse, err error) {
	response = CreateGetMockRuleByConsumerAppIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetMockRuleByConsumerAppIdWithChan invokes the edas.GetMockRuleByConsumerAppId API asynchronously
func (client *Client) GetMockRuleByConsumerAppIdWithChan(request *GetMockRuleByConsumerAppIdRequest) (<-chan *GetMockRuleByConsumerAppIdResponse, <-chan error) {
	responseChan := make(chan *GetMockRuleByConsumerAppIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMockRuleByConsumerAppId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMockRuleByConsumerAppIdWithCallback invokes the edas.GetMockRuleByConsumerAppId API asynchronously
func (client *Client) GetMockRuleByConsumerAppIdWithCallback(request *GetMockRuleByConsumerAppIdRequest, callback func(response *GetMockRuleByConsumerAppIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMockRuleByConsumerAppIdResponse
		var err error
		defer close(result)
		response, err = client.GetMockRuleByConsumerAppId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMockRuleByConsumerAppIdRequest is the request struct for api GetMockRuleByConsumerAppId
type GetMockRuleByConsumerAppIdRequest struct {
	*requests.RoaRequest
	ConsumerAppId string `position:"Query" name:"ConsumerAppId"`
	Region        string `position:"Query" name:"Region"`
}

// GetMockRuleByConsumerAppIdResponse is the response struct for api GetMockRuleByConsumerAppId
type GetMockRuleByConsumerAppIdResponse struct {
	*responses.BaseResponse
	Code      string         `json:"Code" xml:"Code"`
	Message   string         `json:"Message" xml:"Message"`
	RequestId string         `json:"RequestId" xml:"RequestId"`
	HttpCode  string         `json:"HttpCode" xml:"HttpCode"`
	Success   bool           `json:"Success" xml:"Success"`
	Data      []RuleItemList `json:"Data" xml:"Data"`
}

// CreateGetMockRuleByConsumerAppIdRequest creates a request to invoke GetMockRuleByConsumerAppId API
func CreateGetMockRuleByConsumerAppIdRequest() (request *GetMockRuleByConsumerAppIdRequest) {
	request = &GetMockRuleByConsumerAppIdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetMockRuleByConsumerAppId", "/pop/sp/api/mock/getMockRuleByConsumerAppId", "edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMockRuleByConsumerAppIdResponse creates a response to parse from GetMockRuleByConsumerAppId response
func CreateGetMockRuleByConsumerAppIdResponse() (response *GetMockRuleByConsumerAppIdResponse) {
	response = &GetMockRuleByConsumerAppIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
