package ocr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePoiName invokes the ocr.RecognizePoiName API synchronously
func (client *Client) RecognizePoiName(request *RecognizePoiNameRequest) (response *RecognizePoiNameResponse, err error) {
	response = CreateRecognizePoiNameResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePoiNameWithChan invokes the ocr.RecognizePoiName API asynchronously
func (client *Client) RecognizePoiNameWithChan(request *RecognizePoiNameRequest) (<-chan *RecognizePoiNameResponse, <-chan error) {
	responseChan := make(chan *RecognizePoiNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePoiName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePoiNameWithCallback invokes the ocr.RecognizePoiName API asynchronously
func (client *Client) RecognizePoiNameWithCallback(request *RecognizePoiNameRequest, callback func(response *RecognizePoiNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePoiNameResponse
		var err error
		defer close(result)
		response, err = client.RecognizePoiName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePoiNameRequest is the request struct for api RecognizePoiName
type RecognizePoiNameRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// RecognizePoiNameResponse is the response struct for api RecognizePoiName
type RecognizePoiNameResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateRecognizePoiNameRequest creates a request to invoke RecognizePoiName API
func CreateRecognizePoiNameRequest() (request *RecognizePoiNameRequest) {
	request = &RecognizePoiNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ocr", "2019-12-30", "RecognizePoiName", "ocr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizePoiNameResponse creates a response to parse from RecognizePoiName response
func CreateRecognizePoiNameResponse() (response *RecognizePoiNameResponse) {
	response = &RecognizePoiNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
