// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chimesdkmeetings

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchCreateAttendee = "BatchCreateAttendee"

// BatchCreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateAttendee for more information on using the BatchCreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateAttendeeRequest method.
//    req, resp := client.BatchCreateAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchCreateAttendee
func (c *ChimeSDKMeetings) BatchCreateAttendeeRequest(input *BatchCreateAttendeeInput) (req *request.Request, output *BatchCreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opBatchCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/attendees?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateAttendeeInput{}
	}

	output = &BatchCreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateAttendee API operation for Amazon Chime SDK Meetings.
//
// Creates up to 100 attendees for an active Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation BatchCreateAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * LimitExceededException
//   The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/BatchCreateAttendee
func (c *ChimeSDKMeetings) BatchCreateAttendee(input *BatchCreateAttendeeInput) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	return out, req.Send()
}

// BatchCreateAttendeeWithContext is the same as BatchCreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) BatchCreateAttendeeWithContext(ctx aws.Context, input *BatchCreateAttendeeInput, opts ...request.Option) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAttendee = "CreateAttendee"

// CreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the CreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAttendee for more information on using the CreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAttendeeRequest method.
//    req, resp := client.CreateAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateAttendee
func (c *ChimeSDKMeetings) CreateAttendeeRequest(input *CreateAttendeeInput) (req *request.Request, output *CreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/attendees",
	}

	if input == nil {
		input = &CreateAttendeeInput{}
	}

	output = &CreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAttendee API operation for Amazon Chime SDK Meetings.
//
// Creates a new attendee for an active Amazon Chime SDK meeting. For more information
// about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * UnprocessableEntityException
//   The request was well-formed but was unable to be followed due to semantic
//   errors.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * LimitExceededException
//   The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateAttendee
func (c *ChimeSDKMeetings) CreateAttendee(input *CreateAttendeeInput) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	return out, req.Send()
}

// CreateAttendeeWithContext is the same as CreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateAttendeeWithContext(ctx aws.Context, input *CreateAttendeeInput, opts ...request.Option) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeeting = "CreateMeeting"

// CreateMeetingRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeeting for more information on using the CreateMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMeetingRequest method.
//    req, resp := client.CreateMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeeting
func (c *ChimeSDKMeetings) CreateMeetingRequest(input *CreateMeetingInput) (req *request.Request, output *CreateMeetingOutput) {
	op := &request.Operation{
		Name:       opCreateMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings",
	}

	if input == nil {
		input = &CreateMeetingInput{}
	}

	output = &CreateMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeeting API operation for Amazon Chime SDK Meetings.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region with
// no initial attendees. For more information about specifying media Regions,
// see Amazon Chime SDK Media Regions (https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime Developer Guide. For more information about the Amazon
// Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateMeeting for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * LimitExceededException
//   The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeeting
func (c *ChimeSDKMeetings) CreateMeeting(input *CreateMeetingInput) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	return out, req.Send()
}

// CreateMeetingWithContext is the same as CreateMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateMeetingWithContext(ctx aws.Context, input *CreateMeetingInput, opts ...request.Option) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeetingWithAttendees = "CreateMeetingWithAttendees"

// CreateMeetingWithAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeetingWithAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeetingWithAttendees for more information on using the CreateMeetingWithAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMeetingWithAttendeesRequest method.
//    req, resp := client.CreateMeetingWithAttendeesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeetingWithAttendees
func (c *ChimeSDKMeetings) CreateMeetingWithAttendeesRequest(input *CreateMeetingWithAttendeesInput) (req *request.Request, output *CreateMeetingWithAttendeesOutput) {
	op := &request.Operation{
		Name:       opCreateMeetingWithAttendees,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings?operation=create-attendees",
	}

	if input == nil {
		input = &CreateMeetingWithAttendeesInput{}
	}

	output = &CreateMeetingWithAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeetingWithAttendees API operation for Amazon Chime SDK Meetings.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region, with
// attendees. For more information about specifying media Regions, see Amazon
// Chime SDK Media Regions (https://docs.aws.amazon.com/chime/latest/dg/chime-sdk-meetings-regions.html)
// in the Amazon Chime Developer Guide. For more information about the Amazon
// Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation CreateMeetingWithAttendees for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * LimitExceededException
//   The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/CreateMeetingWithAttendees
func (c *ChimeSDKMeetings) CreateMeetingWithAttendees(input *CreateMeetingWithAttendeesInput) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	return out, req.Send()
}

// CreateMeetingWithAttendeesWithContext is the same as CreateMeetingWithAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeetingWithAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) CreateMeetingWithAttendeesWithContext(ctx aws.Context, input *CreateMeetingWithAttendeesInput, opts ...request.Option) (*CreateMeetingWithAttendeesOutput, error) {
	req, out := c.CreateMeetingWithAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttendee = "DeleteAttendee"

// DeleteAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttendee for more information on using the DeleteAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAttendeeRequest method.
//    req, resp := client.DeleteAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteAttendee
func (c *ChimeSDKMeetings) DeleteAttendeeRequest(input *DeleteAttendeeInput) (req *request.Request, output *DeleteAttendeeOutput) {
	op := &request.Operation{
		Name:       opDeleteAttendee,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{MeetingId}/attendees/{AttendeeId}",
	}

	if input == nil {
		input = &DeleteAttendeeInput{}
	}

	output = &DeleteAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAttendee API operation for Amazon Chime SDK Meetings.
//
// Deletes an attendee from the specified Amazon Chime SDK meeting and deletes
// their JoinToken. Attendees are automatically deleted when a Amazon Chime
// SDK meeting is deleted. For more information about the Amazon Chime SDK,
// see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation DeleteAttendee for usage and error information.
//
// Returned Error Types:
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteAttendee
func (c *ChimeSDKMeetings) DeleteAttendee(input *DeleteAttendeeInput) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	return out, req.Send()
}

// DeleteAttendeeWithContext is the same as DeleteAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) DeleteAttendeeWithContext(ctx aws.Context, input *DeleteAttendeeInput, opts ...request.Option) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMeeting = "DeleteMeeting"

// DeleteMeetingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMeeting for more information on using the DeleteMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMeetingRequest method.
//    req, resp := client.DeleteMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteMeeting
func (c *ChimeSDKMeetings) DeleteMeetingRequest(input *DeleteMeetingInput) (req *request.Request, output *DeleteMeetingOutput) {
	op := &request.Operation{
		Name:       opDeleteMeeting,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{MeetingId}",
	}

	if input == nil {
		input = &DeleteMeetingInput{}
	}

	output = &DeleteMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMeeting API operation for Amazon Chime SDK Meetings.
//
// Deletes the specified Amazon Chime SDK meeting. The operation deletes all
// attendees, disconnects all clients, and prevents new clients from joining
// the meeting. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation DeleteMeeting for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/DeleteMeeting
func (c *ChimeSDKMeetings) DeleteMeeting(input *DeleteMeetingInput) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	return out, req.Send()
}

// DeleteMeetingWithContext is the same as DeleteMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) DeleteMeetingWithContext(ctx aws.Context, input *DeleteMeetingInput, opts ...request.Option) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttendee = "GetAttendee"

// GetAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the GetAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttendee for more information on using the GetAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAttendeeRequest method.
//    req, resp := client.GetAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetAttendee
func (c *ChimeSDKMeetings) GetAttendeeRequest(input *GetAttendeeInput) (req *request.Request, output *GetAttendeeOutput) {
	op := &request.Operation{
		Name:       opGetAttendee,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}/attendees/{AttendeeId}",
	}

	if input == nil {
		input = &GetAttendeeInput{}
	}

	output = &GetAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttendee API operation for Amazon Chime SDK Meetings.
//
// Gets the Amazon Chime SDK attendee details for a specified meeting ID and
// attendee ID. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation GetAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetAttendee
func (c *ChimeSDKMeetings) GetAttendee(input *GetAttendeeInput) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	return out, req.Send()
}

// GetAttendeeWithContext is the same as GetAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) GetAttendeeWithContext(ctx aws.Context, input *GetAttendeeInput, opts ...request.Option) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMeeting = "GetMeeting"

// GetMeetingRequest generates a "aws/request.Request" representing the
// client's request for the GetMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMeeting for more information on using the GetMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMeetingRequest method.
//    req, resp := client.GetMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetMeeting
func (c *ChimeSDKMeetings) GetMeetingRequest(input *GetMeetingInput) (req *request.Request, output *GetMeetingOutput) {
	op := &request.Operation{
		Name:       opGetMeeting,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}",
	}

	if input == nil {
		input = &GetMeetingInput{}
	}

	output = &GetMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMeeting API operation for Amazon Chime SDK Meetings.
//
// Gets the Amazon Chime SDK meeting details for the specified meeting ID. For
// more information about the Amazon Chime SDK, see Using the Amazon Chime SDK
// (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the Amazon
// Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation GetMeeting for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/GetMeeting
func (c *ChimeSDKMeetings) GetMeeting(input *GetMeetingInput) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	return out, req.Send()
}

// GetMeetingWithContext is the same as GetMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See GetMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) GetMeetingWithContext(ctx aws.Context, input *GetMeetingInput, opts ...request.Option) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAttendees = "ListAttendees"

// ListAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttendees for more information on using the ListAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttendeesRequest method.
//    req, resp := client.ListAttendeesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListAttendees
func (c *ChimeSDKMeetings) ListAttendeesRequest(input *ListAttendeesInput) (req *request.Request, output *ListAttendeesOutput) {
	op := &request.Operation{
		Name:       opListAttendees,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{MeetingId}/attendees",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttendeesInput{}
	}

	output = &ListAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttendees API operation for Amazon Chime SDK Meetings.
//
// Lists the attendees for the specified Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation ListAttendees for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/ListAttendees
func (c *ChimeSDKMeetings) ListAttendees(input *ListAttendeesInput) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	return out, req.Send()
}

// ListAttendeesWithContext is the same as ListAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) ListAttendeesWithContext(ctx aws.Context, input *ListAttendeesInput, opts ...request.Option) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttendeesPages iterates over the pages of a ListAttendees operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttendees method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttendees operation.
//    pageNum := 0
//    err := client.ListAttendeesPages(params,
//        func(page *chimesdkmeetings.ListAttendeesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ChimeSDKMeetings) ListAttendeesPages(input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool) error {
	return c.ListAttendeesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttendeesPagesWithContext same as ListAttendeesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) ListAttendeesPagesWithContext(ctx aws.Context, input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttendeesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttendeesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttendeesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartMeetingTranscription = "StartMeetingTranscription"

// StartMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StartMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMeetingTranscription for more information on using the StartMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMeetingTranscriptionRequest method.
//    req, resp := client.StartMeetingTranscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StartMeetingTranscription
func (c *ChimeSDKMeetings) StartMeetingTranscriptionRequest(input *StartMeetingTranscriptionInput) (req *request.Request, output *StartMeetingTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStartMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/transcription?operation=start",
	}

	if input == nil {
		input = &StartMeetingTranscriptionInput{}
	}

	output = &StartMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartMeetingTranscription API operation for Amazon Chime SDK Meetings.
//
// Starts transcription for the specified meetingId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation StartMeetingTranscription for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * LimitExceededException
//   The request exceeds the resource limit.
//
//   * UnprocessableEntityException
//   The request was well-formed but was unable to be followed due to semantic
//   errors.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StartMeetingTranscription
func (c *ChimeSDKMeetings) StartMeetingTranscription(input *StartMeetingTranscriptionInput) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StartMeetingTranscriptionWithContext is the same as StartMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StartMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) StartMeetingTranscriptionWithContext(ctx aws.Context, input *StartMeetingTranscriptionInput, opts ...request.Option) (*StartMeetingTranscriptionOutput, error) {
	req, out := c.StartMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopMeetingTranscription = "StopMeetingTranscription"

// StopMeetingTranscriptionRequest generates a "aws/request.Request" representing the
// client's request for the StopMeetingTranscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopMeetingTranscription for more information on using the StopMeetingTranscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopMeetingTranscriptionRequest method.
//    req, resp := client.StopMeetingTranscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StopMeetingTranscription
func (c *ChimeSDKMeetings) StopMeetingTranscriptionRequest(input *StopMeetingTranscriptionInput) (req *request.Request, output *StopMeetingTranscriptionOutput) {
	op := &request.Operation{
		Name:       opStopMeetingTranscription,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{MeetingId}/transcription?operation=stop",
	}

	if input == nil {
		input = &StopMeetingTranscriptionInput{}
	}

	output = &StopMeetingTranscriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopMeetingTranscription API operation for Amazon Chime SDK Meetings.
//
// Stops transcription for the specified meetingId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime SDK Meetings's
// API operation StopMeetingTranscription for usage and error information.
//
// Returned Error Types:
//   * ForbiddenException
//   The client is permanently forbidden from making the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedException
//   The user isn't authorized to request a resource.
//
//   * UnprocessableEntityException
//   The request was well-formed but was unable to be followed due to semantic
//   errors.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-sdk-meetings-2021-07-15/StopMeetingTranscription
func (c *ChimeSDKMeetings) StopMeetingTranscription(input *StopMeetingTranscriptionInput) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	return out, req.Send()
}

// StopMeetingTranscriptionWithContext is the same as StopMeetingTranscription with the addition of
// the ability to pass a context and additional request options.
//
// See StopMeetingTranscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ChimeSDKMeetings) StopMeetingTranscriptionWithContext(ctx aws.Context, input *StopMeetingTranscriptionInput, opts ...request.Option) (*StopMeetingTranscriptionOutput, error) {
	req, out := c.StopMeetingTranscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken.
// The JoinToken allows a client to authenticate and join as the specified attendee.
// The JoinToken expires when the meeting ends, or when DeleteAttendee is called.
// After that, the attendee is unable to join the meeting.
//
// We recommend securely transferring each JoinToken from your server application
// to the client so that no other client has access to the token except for
// the one authorized to represent the attendee.
type Attendee struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string `type:"string"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`

	// The join token used by the Amazon Chime SDK attendee.
	//
	// JoinToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Attendee's
	// String and GoString methods.
	JoinToken *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attendee) GoString() string {
	return s.String()
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *Attendee) SetAttendeeId(v string) *Attendee {
	s.AttendeeId = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *Attendee) SetExternalUserId(v string) *Attendee {
	s.ExternalUserId = &v
	return s
}

// SetJoinToken sets the JoinToken field's value.
func (s *Attendee) SetJoinToken(v string) *Attendee {
	s.JoinToken = &v
	return s
}

// An optional category of meeting features that contains audio-specific configurations,
// such as operating parameters for Amazon Voice Focus.
type AudioFeatures struct {
	_ struct{} `type:"structure"`

	// Makes echo reduction available to clients who connect to the meeting.
	EchoReduction *string `type:"string" enum:"MeetingFeatureStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioFeatures) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudioFeatures) GoString() string {
	return s.String()
}

// SetEchoReduction sets the EchoReduction field's value.
func (s *AudioFeatures) SetEchoReduction(v string) *AudioFeatures {
	s.EchoReduction = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type BatchCreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `min:"1" type:"list" required:"true"`

	// The Amazon Chime SDK ID of the meeting to which you're adding attendees.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateAttendeeInput"}
	if s.Attendees == nil {
		invalidParams.Add(request.NewErrParamRequired("Attendees"))
	}
	if s.Attendees != nil && len(s.Attendees) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attendees", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeInput) SetAttendees(v []*CreateAttendeeRequestItem) *BatchCreateAttendeeInput {
	s.Attendees = v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *BatchCreateAttendeeInput) SetMeetingId(v string) *BatchCreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type BatchCreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	Attendees []*Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []*CreateAttendeeError `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchCreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeOutput) SetAttendees(v []*Attendee) *BatchCreateAttendeeOutput {
	s.Attendees = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateAttendeeOutput) SetErrors(v []*CreateAttendeeError) *BatchCreateAttendeeOutput {
	s.Errors = v
	return s
}

// The list of errors returned when errors are encountered during the BatchCreateAttendee
// and CreateAttendee actions. This includes external user IDs, error codes,
// and error messages.
type CreateAttendeeError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeError's
	// String and GoString methods.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CreateAttendeeError) SetErrorCode(v string) *CreateAttendeeError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateAttendeeError) SetErrorMessage(v string) *CreateAttendeeError {
	s.ErrorMessage = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeError) SetExternalUserId(v string) *CreateAttendeeError {
	s.ExternalUserId = &v
	return s
}

type CreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeInput's
	// String and GoString methods.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The unique ID of the meeting.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeInput"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeInput) SetExternalUserId(v string) *CreateAttendeeInput {
	s.ExternalUserId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *CreateAttendeeInput) SetMeetingId(v string) *CreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type CreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendee ID and join token.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *CreateAttendeeOutput) SetAttendee(v *Attendee) *CreateAttendeeOutput {
	s.Attendee = v
	return s
}

// The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee
// action.
type CreateAttendeeRequestItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. An idempotency token. Links the attendee
	// to an identity managed by a builder application.
	//
	// ExternalUserId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAttendeeRequestItem's
	// String and GoString methods.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttendeeRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeRequestItem"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeRequestItem) SetExternalUserId(v string) *CreateAttendeeRequestItem {
	s.ExternalUserId = &v
	return s
}

type CreateMeetingInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The external meeting ID.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	//
	// ExternalMeetingId is a required field
	ExternalMeetingId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Region in which to create the meeting.
	//
	// Available values: af-south-1 , ap-northeast-1 , ap-northeast-2 , ap-south-1
	// , ap-southeast-1 , ap-southeast-2 , ca-central-1 , eu-central-1 , eu-north-1
	// , eu-south-1 , eu-west-1 , eu-west-2 , eu-west-3 , sa-east-1 , us-east-1
	// , us-east-2 , us-west-1 , us-west-2 .
	//
	// MediaRegion is a required field
	MediaRegion *string `min:"2" type:"string" required:"true"`

	// Lists the audio and video features enabled for a meeting, such as echo reduction.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingInput's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when meeting
	// and attendee events occur.
	NotificationsConfiguration *NotificationsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.ExternalMeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalMeetingId"))
	}
	if s.ExternalMeetingId != nil && len(*s.ExternalMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalMeetingId", 2))
	}
	if s.MediaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaRegion"))
	}
	if s.MediaRegion != nil && len(*s.MediaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediaRegion", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMeetingInput) SetClientRequestToken(v string) *CreateMeetingInput {
	s.ClientRequestToken = &v
	return s
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *CreateMeetingInput) SetExternalMeetingId(v string) *CreateMeetingInput {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *CreateMeetingInput) SetMediaRegion(v string) *CreateMeetingInput {
	s.MediaRegion = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *CreateMeetingInput) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *CreateMeetingInput {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *CreateMeetingInput) SetMeetingHostId(v string) *CreateMeetingInput {
	s.MeetingHostId = &v
	return s
}

// SetNotificationsConfiguration sets the NotificationsConfiguration field's value.
func (s *CreateMeetingInput) SetNotificationsConfiguration(v *NotificationsConfiguration) *CreateMeetingInput {
	s.NotificationsConfiguration = v
	return s
}

type CreateMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The meeting information, including the meeting ID and MediaPlacement.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *CreateMeetingOutput) SetMeeting(v *Meeting) *CreateMeetingOutput {
	s.Meeting = v
	return s
}

type CreateMeetingWithAttendeesInput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `min:"1" type:"list" required:"true"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	//
	// ClientRequestToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The external meeting ID.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	//
	// ExternalMeetingId is a required field
	ExternalMeetingId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Region in which to create the meeting.
	//
	// MediaRegion is a required field
	MediaRegion *string `min:"2" type:"string" required:"true"`

	// Lists the audio and video features enabled for a meeting, such as echo reduction.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateMeetingWithAttendeesInput's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when meeting
	// and attendee events occur.
	NotificationsConfiguration *NotificationsConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingWithAttendeesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingWithAttendeesInput"}
	if s.Attendees == nil {
		invalidParams.Add(request.NewErrParamRequired("Attendees"))
	}
	if s.Attendees != nil && len(s.Attendees) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attendees", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.ExternalMeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalMeetingId"))
	}
	if s.ExternalMeetingId != nil && len(*s.ExternalMeetingId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalMeetingId", 2))
	}
	if s.MediaRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaRegion"))
	}
	if s.MediaRegion != nil && len(*s.MediaRegion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MediaRegion", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendees sets the Attendees field's value.
func (s *CreateMeetingWithAttendeesInput) SetAttendees(v []*CreateAttendeeRequestItem) *CreateMeetingWithAttendeesInput {
	s.Attendees = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMeetingWithAttendeesInput) SetClientRequestToken(v string) *CreateMeetingWithAttendeesInput {
	s.ClientRequestToken = &v
	return s
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *CreateMeetingWithAttendeesInput) SetExternalMeetingId(v string) *CreateMeetingWithAttendeesInput {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *CreateMeetingWithAttendeesInput) SetMediaRegion(v string) *CreateMeetingWithAttendeesInput {
	s.MediaRegion = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *CreateMeetingWithAttendeesInput) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *CreateMeetingWithAttendeesInput {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *CreateMeetingWithAttendeesInput) SetMeetingHostId(v string) *CreateMeetingWithAttendeesInput {
	s.MeetingHostId = &v
	return s
}

// SetNotificationsConfiguration sets the NotificationsConfiguration field's value.
func (s *CreateMeetingWithAttendeesInput) SetNotificationsConfiguration(v *NotificationsConfiguration) *CreateMeetingWithAttendeesInput {
	s.NotificationsConfiguration = v
	return s
}

type CreateMeetingWithAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees' IDs and join tokens.
	Attendees []*Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []*CreateAttendeeError `type:"list"`

	// The meeting information, including the meeting ID and MediaPlacement.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMeetingWithAttendeesOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *CreateMeetingWithAttendeesOutput) SetAttendees(v []*Attendee) *CreateMeetingWithAttendeesOutput {
	s.Attendees = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *CreateMeetingWithAttendeesOutput) SetErrors(v []*CreateAttendeeError) *CreateMeetingWithAttendeesOutput {
	s.Errors = v
	return s
}

// SetMeeting sets the Meeting field's value.
func (s *CreateMeetingWithAttendeesOutput) SetMeeting(v *Meeting) *CreateMeetingWithAttendeesOutput {
	s.Meeting = v
	return s
}

type DeleteAttendeeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"AttendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *DeleteAttendeeInput) SetAttendeeId(v string) *DeleteAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteAttendeeInput) SetMeetingId(v string) *DeleteAttendeeInput {
	s.MeetingId = &v
	return s
}

type DeleteAttendeeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttendeeOutput) GoString() string {
	return s.String()
}

type DeleteMeetingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteMeetingInput) SetMeetingId(v string) *DeleteMeetingInput {
	s.MeetingId = &v
	return s
}

type DeleteMeetingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeetingOutput) GoString() string {
	return s.String()
}

// Settings specific to the Amazon Transcribe Medical engine.
type EngineTranscribeMedicalSettings struct {
	_ struct{} `type:"structure"`

	// Set this field to PHI to identify personal health information in the transcription
	// output.
	ContentIdentificationType *string `type:"string" enum:"TranscribeMedicalContentIdentificationType"`

	// The language code specified for the Amazon Transcribe Medical engine.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"TranscribeMedicalLanguageCode"`

	// The AWS Region passed to Amazon Transcribe Medical. If you don't specify
	// a Region, Amazon Chime uses the meeting's Region.
	Region *string `type:"string" enum:"TranscribeMedicalRegion"`

	// The specialty specified for the Amazon Transcribe Medical engine.
	//
	// Specialty is a required field
	Specialty *string `type:"string" required:"true" enum:"TranscribeMedicalSpecialty"`

	// The type of transcription.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"TranscribeMedicalType"`

	// The name of the vocabulary passed to Amazon Transcribe Medical.
	VocabularyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeMedicalSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeMedicalSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EngineTranscribeMedicalSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EngineTranscribeMedicalSettings"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *EngineTranscribeMedicalSettings) SetContentIdentificationType(v string) *EngineTranscribeMedicalSettings {
	s.ContentIdentificationType = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EngineTranscribeMedicalSettings) SetLanguageCode(v string) *EngineTranscribeMedicalSettings {
	s.LanguageCode = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EngineTranscribeMedicalSettings) SetRegion(v string) *EngineTranscribeMedicalSettings {
	s.Region = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *EngineTranscribeMedicalSettings) SetSpecialty(v string) *EngineTranscribeMedicalSettings {
	s.Specialty = &v
	return s
}

// SetType sets the Type field's value.
func (s *EngineTranscribeMedicalSettings) SetType(v string) *EngineTranscribeMedicalSettings {
	s.Type = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *EngineTranscribeMedicalSettings) SetVocabularyName(v string) *EngineTranscribeMedicalSettings {
	s.VocabularyName = &v
	return s
}

// Settings specific to the Amazon Transcribe engine.
type EngineTranscribeSettings struct {
	_ struct{} `type:"structure"`

	// Set this field to PII to identify personally identifiable information in
	// the transcription output.
	ContentIdentificationType *string `type:"string" enum:"TranscribeContentIdentificationType"`

	// Set this field to PII to redact personally identifiable information in the
	// transcription output. Content redaction is performed only upon complete transcription
	// of the audio segments.
	//
	// You can’t set ContentRedactionType and ContentIdentificationType in the
	// same request. If you set both, your request returns a BadRequestException.
	ContentRedactionType *string `type:"string" enum:"TranscribeContentRedactionType"`

	// Generates partial transcription results that are less likely to change as
	// meeting attendees speak. It does so by only allowing the last few words from
	// the partial results to change.
	EnablePartialResultsStabilization *bool `type:"boolean"`

	// The language code specified for the Amazon Transcribe engine.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"TranscribeLanguageCode"`

	// The name of the language model used during transcription.
	LanguageModelName *string `min:"1" type:"string"`

	// The stabity level of a partial results transcription. Determines how stable
	// you want the transcription results to be. A higher level means the transcription
	// results are less likely to change.
	PartialResultsStability *string `type:"string" enum:"TranscribePartialResultsStability"`

	// Lists the PII entity types you want to identify or redact. To specify entity
	// types, you must enable ContentIdentificationType or ContentRedactionType.
	//
	// PIIEntityTypes must be comma-separated. The available values are: BANK_ACCOUNT_NUMBER,
	// BANK_ROUTING, CREDIT_DEBIT_NUMBER, CREDIT_DEBIT_CVV, CREDIT_DEBIT_EXPIRY,
	// PIN, EMAIL, ADDRESS, NAME, PHONE, SSN, and ALL.
	//
	// PiiEntityTypes is an optional parameter with a default value of ALL.
	PiiEntityTypes *string `min:"1" type:"string"`

	// The AWS Region passed to Amazon Transcribe. If you don't specify a Region,
	// Amazon Chime uses the meeting's Region.
	Region *string `type:"string" enum:"TranscribeRegion"`

	// The filtering method passed to Amazon Transcribe.
	VocabularyFilterMethod *string `type:"string" enum:"TranscribeVocabularyFilterMethod"`

	// The name of the vocabulary filter passed to Amazon Transcribe.
	VocabularyFilterName *string `type:"string"`

	// The name of the vocabulary passed to Amazon Transcribe.
	VocabularyName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EngineTranscribeSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EngineTranscribeSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EngineTranscribeSettings"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.PiiEntityTypes != nil && len(*s.PiiEntityTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PiiEntityTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *EngineTranscribeSettings) SetContentIdentificationType(v string) *EngineTranscribeSettings {
	s.ContentIdentificationType = &v
	return s
}

// SetContentRedactionType sets the ContentRedactionType field's value.
func (s *EngineTranscribeSettings) SetContentRedactionType(v string) *EngineTranscribeSettings {
	s.ContentRedactionType = &v
	return s
}

// SetEnablePartialResultsStabilization sets the EnablePartialResultsStabilization field's value.
func (s *EngineTranscribeSettings) SetEnablePartialResultsStabilization(v bool) *EngineTranscribeSettings {
	s.EnablePartialResultsStabilization = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EngineTranscribeSettings) SetLanguageCode(v string) *EngineTranscribeSettings {
	s.LanguageCode = &v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *EngineTranscribeSettings) SetLanguageModelName(v string) *EngineTranscribeSettings {
	s.LanguageModelName = &v
	return s
}

// SetPartialResultsStability sets the PartialResultsStability field's value.
func (s *EngineTranscribeSettings) SetPartialResultsStability(v string) *EngineTranscribeSettings {
	s.PartialResultsStability = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *EngineTranscribeSettings) SetPiiEntityTypes(v string) *EngineTranscribeSettings {
	s.PiiEntityTypes = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *EngineTranscribeSettings) SetRegion(v string) *EngineTranscribeSettings {
	s.Region = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *EngineTranscribeSettings) SetVocabularyFilterMethod(v string) *EngineTranscribeSettings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *EngineTranscribeSettings) SetVocabularyFilterName(v string) *EngineTranscribeSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *EngineTranscribeSettings) SetVocabularyName(v string) *EngineTranscribeSettings {
	s.VocabularyName = &v
	return s
}

// The client is permanently forbidden from making the request.
type ForbiddenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s *ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ForbiddenException) OrigErr() error {
	return nil
}

func (s *ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ForbiddenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ForbiddenException) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetAttendeeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"AttendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *GetAttendeeInput) SetAttendeeId(v string) *GetAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetAttendeeInput) SetMeetingId(v string) *GetAttendeeInput {
	s.MeetingId = &v
	return s
}

type GetAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *GetAttendeeOutput) SetAttendee(v *Attendee) *GetAttendeeOutput {
	s.Attendee = v
	return s
}

type GetMeetingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetMeetingInput) SetMeetingId(v string) *GetMeetingInput {
	s.MeetingId = &v
	return s
}

type GetMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting information.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *GetMeetingOutput) SetMeeting(v *Meeting) *GetMeetingOutput {
	s.Meeting = v
	return s
}

// The request exceeds the resource limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAttendeesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttendeesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttendeesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttendeesInput) SetMaxResults(v int64) *ListAttendeesInput {
	s.MaxResults = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *ListAttendeesInput) SetMeetingId(v string) *ListAttendeesInput {
	s.MeetingId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesInput) SetNextToken(v string) *ListAttendeesInput {
	s.NextToken = &v
	return s
}

type ListAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendees []*Attendee `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttendeesOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *ListAttendeesOutput) SetAttendees(v []*Attendee) *ListAttendeesOutput {
	s.Attendees = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesOutput) SetNextToken(v string) *ListAttendeesOutput {
	s.NextToken = &v
	return s
}

// A set of endpoints used by clients to connect to the media service group
// for an Amazon Chime SDK meeting.
type MediaPlacement struct {
	_ struct{} `type:"structure"`

	// The audio fallback URL.
	AudioFallbackUrl *string `type:"string"`

	// The audio host URL.
	AudioHostUrl *string `type:"string"`

	// The event ingestion URL.
	EventIngestionUrl *string `type:"string"`

	// The screen data URL.
	ScreenDataUrl *string `type:"string"`

	// The screen sharing URL.
	ScreenSharingUrl *string `type:"string"`

	// The screen viewing URL.
	ScreenViewingUrl *string `type:"string"`

	// The signaling URL.
	SignalingUrl *string `type:"string"`

	// The turn control URL.
	TurnControlUrl *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MediaPlacement) GoString() string {
	return s.String()
}

// SetAudioFallbackUrl sets the AudioFallbackUrl field's value.
func (s *MediaPlacement) SetAudioFallbackUrl(v string) *MediaPlacement {
	s.AudioFallbackUrl = &v
	return s
}

// SetAudioHostUrl sets the AudioHostUrl field's value.
func (s *MediaPlacement) SetAudioHostUrl(v string) *MediaPlacement {
	s.AudioHostUrl = &v
	return s
}

// SetEventIngestionUrl sets the EventIngestionUrl field's value.
func (s *MediaPlacement) SetEventIngestionUrl(v string) *MediaPlacement {
	s.EventIngestionUrl = &v
	return s
}

// SetScreenDataUrl sets the ScreenDataUrl field's value.
func (s *MediaPlacement) SetScreenDataUrl(v string) *MediaPlacement {
	s.ScreenDataUrl = &v
	return s
}

// SetScreenSharingUrl sets the ScreenSharingUrl field's value.
func (s *MediaPlacement) SetScreenSharingUrl(v string) *MediaPlacement {
	s.ScreenSharingUrl = &v
	return s
}

// SetScreenViewingUrl sets the ScreenViewingUrl field's value.
func (s *MediaPlacement) SetScreenViewingUrl(v string) *MediaPlacement {
	s.ScreenViewingUrl = &v
	return s
}

// SetSignalingUrl sets the SignalingUrl field's value.
func (s *MediaPlacement) SetSignalingUrl(v string) *MediaPlacement {
	s.SignalingUrl = &v
	return s
}

// SetTurnControlUrl sets the TurnControlUrl field's value.
func (s *MediaPlacement) SetTurnControlUrl(v string) *MediaPlacement {
	s.TurnControlUrl = &v
	return s
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {
	_ struct{} `type:"structure"`

	// The external meeting ID.
	//
	// ExternalMeetingId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Meeting's
	// String and GoString methods.
	ExternalMeetingId *string `min:"2" type:"string" sensitive:"true"`

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement `type:"structure"`

	// The Region in which you create the meeting. Available values: af-south-1,
	// ap-northeast-1, ap-northeast-2, ap-south-1, ap-southeast-1, ap-southeast-2,
	// ca-central-1, eu-central-1, eu-north-1, eu-south-1, eu-west-1, eu-west-2,
	// eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2.
	MediaRegion *string `min:"2" type:"string"`

	// The features available to a meeting, such as Amazon Voice Focus.
	MeetingFeatures *MeetingFeaturesConfiguration `type:"structure"`

	// Reserved.
	//
	// MeetingHostId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Meeting's
	// String and GoString methods.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The Amazon Chime SDK meeting ID.
	MeetingId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Meeting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Meeting) GoString() string {
	return s.String()
}

// SetExternalMeetingId sets the ExternalMeetingId field's value.
func (s *Meeting) SetExternalMeetingId(v string) *Meeting {
	s.ExternalMeetingId = &v
	return s
}

// SetMediaPlacement sets the MediaPlacement field's value.
func (s *Meeting) SetMediaPlacement(v *MediaPlacement) *Meeting {
	s.MediaPlacement = v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *Meeting) SetMediaRegion(v string) *Meeting {
	s.MediaRegion = &v
	return s
}

// SetMeetingFeatures sets the MeetingFeatures field's value.
func (s *Meeting) SetMeetingFeatures(v *MeetingFeaturesConfiguration) *Meeting {
	s.MeetingFeatures = v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *Meeting) SetMeetingHostId(v string) *Meeting {
	s.MeetingHostId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *Meeting) SetMeetingId(v string) *Meeting {
	s.MeetingId = &v
	return s
}

// The configuration settings of the features available to a meeting.
type MeetingFeaturesConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration settings for the audio features available to a meeting.
	Audio *AudioFeatures `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingFeaturesConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeetingFeaturesConfiguration) GoString() string {
	return s.String()
}

// SetAudio sets the Audio field's value.
func (s *MeetingFeaturesConfiguration) SetAudio(v *AudioFeatures) *MeetingFeaturesConfiguration {
	s.Audio = v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration for resource targets to receive notifications when meeting
// and attendee events occur.
type NotificationsConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda function in the notifications configuration.
	//
	// LambdaFunctionArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	LambdaFunctionArn *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the SNS topic.
	//
	// SnsTopicArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	SnsTopicArn *string `min:"1" type:"string" sensitive:"true"`

	// The ARN of the SQS queue.
	//
	// SqsQueueArn is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotificationsConfiguration's
	// String and GoString methods.
	SqsQueueArn *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationsConfiguration"}
	if s.LambdaFunctionArn != nil && len(*s.LambdaFunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LambdaFunctionArn", 1))
	}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopicArn", 1))
	}
	if s.SqsQueueArn != nil && len(*s.SqsQueueArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqsQueueArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *NotificationsConfiguration) SetLambdaFunctionArn(v string) *NotificationsConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *NotificationsConfiguration) SetSnsTopicArn(v string) *NotificationsConfiguration {
	s.SnsTopicArn = &v
	return s
}

// SetSqsQueueArn sets the SqsQueueArn field's value.
func (s *NotificationsConfiguration) SetSqsQueueArn(v string) *NotificationsConfiguration {
	s.SqsQueueArn = &v
	return s
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`

	// The number of seconds the caller should wait before retrying.
	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartMeetingTranscriptionInput struct {
	_ struct{} `type:"structure"`

	// The unique ID of the meeting being transcribed.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`

	// The configuration for the current transcription operation. Must contain EngineTranscribeSettings
	// or EngineTranscribeMedicalSettings.
	//
	// TranscriptionConfiguration is a required field
	TranscriptionConfiguration *TranscriptionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMeetingTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMeetingTranscriptionInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.TranscriptionConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionConfiguration"))
	}
	if s.TranscriptionConfiguration != nil {
		if err := s.TranscriptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TranscriptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *StartMeetingTranscriptionInput) SetMeetingId(v string) *StartMeetingTranscriptionInput {
	s.MeetingId = &v
	return s
}

// SetTranscriptionConfiguration sets the TranscriptionConfiguration field's value.
func (s *StartMeetingTranscriptionInput) SetTranscriptionConfiguration(v *TranscriptionConfiguration) *StartMeetingTranscriptionInput {
	s.TranscriptionConfiguration = v
	return s
}

type StartMeetingTranscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMeetingTranscriptionOutput) GoString() string {
	return s.String()
}

type StopMeetingTranscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique ID of the meeting for which you stop transcription.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"MeetingId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopMeetingTranscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopMeetingTranscriptionInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *StopMeetingTranscriptionInput) SetMeetingId(v string) *StopMeetingTranscriptionInput {
	s.MeetingId = &v
	return s
}

type StopMeetingTranscriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopMeetingTranscriptionOutput) GoString() string {
	return s.String()
}

// The configuration for the current transcription operation. Must contain EngineTranscribeSettings
// or EngineTranscribeMedicalSettings.
type TranscriptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The transcription configuration settings passed to Amazon Transcribe Medical.
	EngineTranscribeMedicalSettings *EngineTranscribeMedicalSettings `type:"structure"`

	// The transcription configuration settings passed to Amazon Transcribe.
	EngineTranscribeSettings *EngineTranscribeSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranscriptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranscriptionConfiguration"}
	if s.EngineTranscribeMedicalSettings != nil {
		if err := s.EngineTranscribeMedicalSettings.Validate(); err != nil {
			invalidParams.AddNested("EngineTranscribeMedicalSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.EngineTranscribeSettings != nil {
		if err := s.EngineTranscribeSettings.Validate(); err != nil {
			invalidParams.AddNested("EngineTranscribeSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineTranscribeMedicalSettings sets the EngineTranscribeMedicalSettings field's value.
func (s *TranscriptionConfiguration) SetEngineTranscribeMedicalSettings(v *EngineTranscribeMedicalSettings) *TranscriptionConfiguration {
	s.EngineTranscribeMedicalSettings = v
	return s
}

// SetEngineTranscribeSettings sets the EngineTranscribeSettings field's value.
func (s *TranscriptionConfiguration) SetEngineTranscribeSettings(v *EngineTranscribeSettings) *TranscriptionConfiguration {
	s.EngineTranscribeSettings = v
	return s
}

// The user isn't authorized to request a resource.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request was well-formed but was unable to be followed due to semantic
// errors.
type UnprocessableEntityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The request id associated with the call responsible for the exception.
	RequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s *UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s *UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnprocessableEntityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnprocessableEntityException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// MeetingFeatureStatusAvailable is a MeetingFeatureStatus enum value
	MeetingFeatureStatusAvailable = "AVAILABLE"

	// MeetingFeatureStatusUnavailable is a MeetingFeatureStatus enum value
	MeetingFeatureStatusUnavailable = "UNAVAILABLE"
)

// MeetingFeatureStatus_Values returns all elements of the MeetingFeatureStatus enum
func MeetingFeatureStatus_Values() []string {
	return []string{
		MeetingFeatureStatusAvailable,
		MeetingFeatureStatusUnavailable,
	}
}

const (
	// TranscribeContentIdentificationTypePii is a TranscribeContentIdentificationType enum value
	TranscribeContentIdentificationTypePii = "PII"
)

// TranscribeContentIdentificationType_Values returns all elements of the TranscribeContentIdentificationType enum
func TranscribeContentIdentificationType_Values() []string {
	return []string{
		TranscribeContentIdentificationTypePii,
	}
}

const (
	// TranscribeContentRedactionTypePii is a TranscribeContentRedactionType enum value
	TranscribeContentRedactionTypePii = "PII"
)

// TranscribeContentRedactionType_Values returns all elements of the TranscribeContentRedactionType enum
func TranscribeContentRedactionType_Values() []string {
	return []string{
		TranscribeContentRedactionTypePii,
	}
}

const (
	// TranscribeLanguageCodeEnUs is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnUs = "en-US"

	// TranscribeLanguageCodeEnGb is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnGb = "en-GB"

	// TranscribeLanguageCodeEsUs is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEsUs = "es-US"

	// TranscribeLanguageCodeFrCa is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeFrCa = "fr-CA"

	// TranscribeLanguageCodeFrFr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeFrFr = "fr-FR"

	// TranscribeLanguageCodeEnAu is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeEnAu = "en-AU"

	// TranscribeLanguageCodeItIt is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeItIt = "it-IT"

	// TranscribeLanguageCodeDeDe is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeDeDe = "de-DE"

	// TranscribeLanguageCodePtBr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodePtBr = "pt-BR"

	// TranscribeLanguageCodeJaJp is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeJaJp = "ja-JP"

	// TranscribeLanguageCodeKoKr is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeKoKr = "ko-KR"

	// TranscribeLanguageCodeZhCn is a TranscribeLanguageCode enum value
	TranscribeLanguageCodeZhCn = "zh-CN"
)

// TranscribeLanguageCode_Values returns all elements of the TranscribeLanguageCode enum
func TranscribeLanguageCode_Values() []string {
	return []string{
		TranscribeLanguageCodeEnUs,
		TranscribeLanguageCodeEnGb,
		TranscribeLanguageCodeEsUs,
		TranscribeLanguageCodeFrCa,
		TranscribeLanguageCodeFrFr,
		TranscribeLanguageCodeEnAu,
		TranscribeLanguageCodeItIt,
		TranscribeLanguageCodeDeDe,
		TranscribeLanguageCodePtBr,
		TranscribeLanguageCodeJaJp,
		TranscribeLanguageCodeKoKr,
		TranscribeLanguageCodeZhCn,
	}
}

const (
	// TranscribeMedicalContentIdentificationTypePhi is a TranscribeMedicalContentIdentificationType enum value
	TranscribeMedicalContentIdentificationTypePhi = "PHI"
)

// TranscribeMedicalContentIdentificationType_Values returns all elements of the TranscribeMedicalContentIdentificationType enum
func TranscribeMedicalContentIdentificationType_Values() []string {
	return []string{
		TranscribeMedicalContentIdentificationTypePhi,
	}
}

const (
	// TranscribeMedicalLanguageCodeEnUs is a TranscribeMedicalLanguageCode enum value
	TranscribeMedicalLanguageCodeEnUs = "en-US"
)

// TranscribeMedicalLanguageCode_Values returns all elements of the TranscribeMedicalLanguageCode enum
func TranscribeMedicalLanguageCode_Values() []string {
	return []string{
		TranscribeMedicalLanguageCodeEnUs,
	}
}

const (
	// TranscribeMedicalRegionUsEast1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsEast1 = "us-east-1"

	// TranscribeMedicalRegionUsEast2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsEast2 = "us-east-2"

	// TranscribeMedicalRegionUsWest2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionUsWest2 = "us-west-2"

	// TranscribeMedicalRegionApSoutheast2 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionApSoutheast2 = "ap-southeast-2"

	// TranscribeMedicalRegionCaCentral1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionCaCentral1 = "ca-central-1"

	// TranscribeMedicalRegionEuWest1 is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionEuWest1 = "eu-west-1"

	// TranscribeMedicalRegionAuto is a TranscribeMedicalRegion enum value
	TranscribeMedicalRegionAuto = "auto"
)

// TranscribeMedicalRegion_Values returns all elements of the TranscribeMedicalRegion enum
func TranscribeMedicalRegion_Values() []string {
	return []string{
		TranscribeMedicalRegionUsEast1,
		TranscribeMedicalRegionUsEast2,
		TranscribeMedicalRegionUsWest2,
		TranscribeMedicalRegionApSoutheast2,
		TranscribeMedicalRegionCaCentral1,
		TranscribeMedicalRegionEuWest1,
		TranscribeMedicalRegionAuto,
	}
}

const (
	// TranscribeMedicalSpecialtyPrimarycare is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyPrimarycare = "PRIMARYCARE"

	// TranscribeMedicalSpecialtyCardiology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyCardiology = "CARDIOLOGY"

	// TranscribeMedicalSpecialtyNeurology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyNeurology = "NEUROLOGY"

	// TranscribeMedicalSpecialtyOncology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyOncology = "ONCOLOGY"

	// TranscribeMedicalSpecialtyRadiology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyRadiology = "RADIOLOGY"

	// TranscribeMedicalSpecialtyUrology is a TranscribeMedicalSpecialty enum value
	TranscribeMedicalSpecialtyUrology = "UROLOGY"
)

// TranscribeMedicalSpecialty_Values returns all elements of the TranscribeMedicalSpecialty enum
func TranscribeMedicalSpecialty_Values() []string {
	return []string{
		TranscribeMedicalSpecialtyPrimarycare,
		TranscribeMedicalSpecialtyCardiology,
		TranscribeMedicalSpecialtyNeurology,
		TranscribeMedicalSpecialtyOncology,
		TranscribeMedicalSpecialtyRadiology,
		TranscribeMedicalSpecialtyUrology,
	}
}

const (
	// TranscribeMedicalTypeConversation is a TranscribeMedicalType enum value
	TranscribeMedicalTypeConversation = "CONVERSATION"

	// TranscribeMedicalTypeDictation is a TranscribeMedicalType enum value
	TranscribeMedicalTypeDictation = "DICTATION"
)

// TranscribeMedicalType_Values returns all elements of the TranscribeMedicalType enum
func TranscribeMedicalType_Values() []string {
	return []string{
		TranscribeMedicalTypeConversation,
		TranscribeMedicalTypeDictation,
	}
}

const (
	// TranscribePartialResultsStabilityLow is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityLow = "low"

	// TranscribePartialResultsStabilityMedium is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityMedium = "medium"

	// TranscribePartialResultsStabilityHigh is a TranscribePartialResultsStability enum value
	TranscribePartialResultsStabilityHigh = "high"
)

// TranscribePartialResultsStability_Values returns all elements of the TranscribePartialResultsStability enum
func TranscribePartialResultsStability_Values() []string {
	return []string{
		TranscribePartialResultsStabilityLow,
		TranscribePartialResultsStabilityMedium,
		TranscribePartialResultsStabilityHigh,
	}
}

const (
	// TranscribeRegionUsEast2 is a TranscribeRegion enum value
	TranscribeRegionUsEast2 = "us-east-2"

	// TranscribeRegionUsEast1 is a TranscribeRegion enum value
	TranscribeRegionUsEast1 = "us-east-1"

	// TranscribeRegionUsWest2 is a TranscribeRegion enum value
	TranscribeRegionUsWest2 = "us-west-2"

	// TranscribeRegionApNortheast2 is a TranscribeRegion enum value
	TranscribeRegionApNortheast2 = "ap-northeast-2"

	// TranscribeRegionApSoutheast2 is a TranscribeRegion enum value
	TranscribeRegionApSoutheast2 = "ap-southeast-2"

	// TranscribeRegionApNortheast1 is a TranscribeRegion enum value
	TranscribeRegionApNortheast1 = "ap-northeast-1"

	// TranscribeRegionCaCentral1 is a TranscribeRegion enum value
	TranscribeRegionCaCentral1 = "ca-central-1"

	// TranscribeRegionEuCentral1 is a TranscribeRegion enum value
	TranscribeRegionEuCentral1 = "eu-central-1"

	// TranscribeRegionEuWest1 is a TranscribeRegion enum value
	TranscribeRegionEuWest1 = "eu-west-1"

	// TranscribeRegionEuWest2 is a TranscribeRegion enum value
	TranscribeRegionEuWest2 = "eu-west-2"

	// TranscribeRegionSaEast1 is a TranscribeRegion enum value
	TranscribeRegionSaEast1 = "sa-east-1"

	// TranscribeRegionAuto is a TranscribeRegion enum value
	TranscribeRegionAuto = "auto"
)

// TranscribeRegion_Values returns all elements of the TranscribeRegion enum
func TranscribeRegion_Values() []string {
	return []string{
		TranscribeRegionUsEast2,
		TranscribeRegionUsEast1,
		TranscribeRegionUsWest2,
		TranscribeRegionApNortheast2,
		TranscribeRegionApSoutheast2,
		TranscribeRegionApNortheast1,
		TranscribeRegionCaCentral1,
		TranscribeRegionEuCentral1,
		TranscribeRegionEuWest1,
		TranscribeRegionEuWest2,
		TranscribeRegionSaEast1,
		TranscribeRegionAuto,
	}
}

const (
	// TranscribeVocabularyFilterMethodRemove is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodRemove = "remove"

	// TranscribeVocabularyFilterMethodMask is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodMask = "mask"

	// TranscribeVocabularyFilterMethodTag is a TranscribeVocabularyFilterMethod enum value
	TranscribeVocabularyFilterMethodTag = "tag"
)

// TranscribeVocabularyFilterMethod_Values returns all elements of the TranscribeVocabularyFilterMethod enum
func TranscribeVocabularyFilterMethod_Values() []string {
	return []string{
		TranscribeVocabularyFilterMethodRemove,
		TranscribeVocabularyFilterMethodMask,
		TranscribeVocabularyFilterMethodTag,
	}
}
