This test checks that flags passed to the external linker with -extldflags
through gc_linkopts are correctly combined with other flags passed through
-extldflags.

`go tool link` only uses the last set of flags passed with -extldflags. If more
than one set of flags is passed, the last set is passed to the external linker,
and the rest are silently ignored.

`go_binary` and `go_test` should look for -extldflags in gc_linkopts and
combine the flags into a single list passed to `go tool link`. This includes
flags generated by the rules themselves.

This test checks this behavior by adding extra rpaths, which has an observable
effect on a `go_binary` linked with the external linker. The shell script checks
that these paths are present.
