// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha1/api.proto

package v1alpha1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type AuthenticationType int32

const (
	// No authentication is used
	AuthenticationType_NONE AuthenticationType = 0
	// One way CHAP authentication. The target authenticates the initiator.
	AuthenticationType_ONE_WAY_CHAP AuthenticationType = 1
	// Mutual CHAP authentication. The target and initiator authenticate each
	// other.
	AuthenticationType_MUTUAL_CHAP AuthenticationType = 2
)

var AuthenticationType_name = map[int32]string{
	0: "NONE",
	1: "ONE_WAY_CHAP",
	2: "MUTUAL_CHAP",
}

var AuthenticationType_value = map[string]int32{
	"NONE":         0,
	"ONE_WAY_CHAP": 1,
	"MUTUAL_CHAP":  2,
}

func (x AuthenticationType) String() string {
	return proto.EnumName(AuthenticationType_name, int32(x))
}

func (AuthenticationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{0}
}

// TargetPortal is an address and port pair for a specific iSCSI storage
// target.
type TargetPortal struct {
	// iSCSI Target (server) address
	TargetAddress string `protobuf:"bytes,1,opt,name=target_address,json=targetAddress,proto3" json:"target_address,omitempty"`
	// iSCSI Target port (default iSCSI port is 3260)
	TargetPort           uint32   `protobuf:"varint,2,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TargetPortal) Reset()         { *m = TargetPortal{} }
func (m *TargetPortal) String() string { return proto.CompactTextString(m) }
func (*TargetPortal) ProtoMessage()    {}
func (*TargetPortal) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{0}
}

func (m *TargetPortal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetPortal.Unmarshal(m, b)
}
func (m *TargetPortal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetPortal.Marshal(b, m, deterministic)
}
func (m *TargetPortal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetPortal.Merge(m, src)
}
func (m *TargetPortal) XXX_Size() int {
	return xxx_messageInfo_TargetPortal.Size(m)
}
func (m *TargetPortal) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetPortal.DiscardUnknown(m)
}

var xxx_messageInfo_TargetPortal proto.InternalMessageInfo

func (m *TargetPortal) GetTargetAddress() string {
	if m != nil {
		return m.TargetAddress
	}
	return ""
}

func (m *TargetPortal) GetTargetPort() uint32 {
	if m != nil {
		return m.TargetPort
	}
	return 0
}

type AddTargetPortalRequest struct {
	// iSCSI Target Portal to register in the initiator
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AddTargetPortalRequest) Reset()         { *m = AddTargetPortalRequest{} }
func (m *AddTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*AddTargetPortalRequest) ProtoMessage()    {}
func (*AddTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{1}
}

func (m *AddTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetPortalRequest.Unmarshal(m, b)
}
func (m *AddTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *AddTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetPortalRequest.Merge(m, src)
}
func (m *AddTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_AddTargetPortalRequest.Size(m)
}
func (m *AddTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetPortalRequest proto.InternalMessageInfo

func (m *AddTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type AddTargetPortalResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddTargetPortalResponse) Reset()         { *m = AddTargetPortalResponse{} }
func (m *AddTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*AddTargetPortalResponse) ProtoMessage()    {}
func (*AddTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{2}
}

func (m *AddTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetPortalResponse.Unmarshal(m, b)
}
func (m *AddTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *AddTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetPortalResponse.Merge(m, src)
}
func (m *AddTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_AddTargetPortalResponse.Size(m)
}
func (m *AddTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetPortalResponse proto.InternalMessageInfo

type DiscoverTargetPortalRequest struct {
	// iSCSI Target Portal on which to initiate discovery
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DiscoverTargetPortalRequest) Reset()         { *m = DiscoverTargetPortalRequest{} }
func (m *DiscoverTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*DiscoverTargetPortalRequest) ProtoMessage()    {}
func (*DiscoverTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{3}
}

func (m *DiscoverTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Unmarshal(m, b)
}
func (m *DiscoverTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *DiscoverTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiscoverTargetPortalRequest.Merge(m, src)
}
func (m *DiscoverTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Size(m)
}
func (m *DiscoverTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiscoverTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiscoverTargetPortalRequest proto.InternalMessageInfo

func (m *DiscoverTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type DiscoverTargetPortalResponse struct {
	// List of discovered IQN addresses
	// follows IQN format: iqn.yyyy-mm.naming-authority:unique-name
	Iqns                 []string `protobuf:"bytes,1,rep,name=iqns,proto3" json:"iqns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiscoverTargetPortalResponse) Reset()         { *m = DiscoverTargetPortalResponse{} }
func (m *DiscoverTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*DiscoverTargetPortalResponse) ProtoMessage()    {}
func (*DiscoverTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{4}
}

func (m *DiscoverTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Unmarshal(m, b)
}
func (m *DiscoverTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *DiscoverTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiscoverTargetPortalResponse.Merge(m, src)
}
func (m *DiscoverTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Size(m)
}
func (m *DiscoverTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DiscoverTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DiscoverTargetPortalResponse proto.InternalMessageInfo

func (m *DiscoverTargetPortalResponse) GetIqns() []string {
	if m != nil {
		return m.Iqns
	}
	return nil
}

type RemoveTargetPortalRequest struct {
	// iSCSI Target Portal
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *RemoveTargetPortalRequest) Reset()         { *m = RemoveTargetPortalRequest{} }
func (m *RemoveTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetPortalRequest) ProtoMessage()    {}
func (*RemoveTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{5}
}

func (m *RemoveTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetPortalRequest.Unmarshal(m, b)
}
func (m *RemoveTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *RemoveTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetPortalRequest.Merge(m, src)
}
func (m *RemoveTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetPortalRequest.Size(m)
}
func (m *RemoveTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetPortalRequest proto.InternalMessageInfo

func (m *RemoveTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type RemoveTargetPortalResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveTargetPortalResponse) Reset()         { *m = RemoveTargetPortalResponse{} }
func (m *RemoveTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetPortalResponse) ProtoMessage()    {}
func (*RemoveTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{6}
}

func (m *RemoveTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetPortalResponse.Unmarshal(m, b)
}
func (m *RemoveTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *RemoveTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetPortalResponse.Merge(m, src)
}
func (m *RemoveTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetPortalResponse.Size(m)
}
func (m *RemoveTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetPortalResponse proto.InternalMessageInfo

type ListTargetPortalsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetPortalsRequest) Reset()         { *m = ListTargetPortalsRequest{} }
func (m *ListTargetPortalsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTargetPortalsRequest) ProtoMessage()    {}
func (*ListTargetPortalsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{7}
}

func (m *ListTargetPortalsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetPortalsRequest.Unmarshal(m, b)
}
func (m *ListTargetPortalsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetPortalsRequest.Marshal(b, m, deterministic)
}
func (m *ListTargetPortalsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetPortalsRequest.Merge(m, src)
}
func (m *ListTargetPortalsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTargetPortalsRequest.Size(m)
}
func (m *ListTargetPortalsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetPortalsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetPortalsRequest proto.InternalMessageInfo

type ListTargetPortalsResponse struct {
	// A list of Target Portals currently registered in the initiator
	TargetPortals        []*TargetPortal `protobuf:"bytes,1,rep,name=target_portals,json=targetPortals,proto3" json:"target_portals,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListTargetPortalsResponse) Reset()         { *m = ListTargetPortalsResponse{} }
func (m *ListTargetPortalsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTargetPortalsResponse) ProtoMessage()    {}
func (*ListTargetPortalsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{8}
}

func (m *ListTargetPortalsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetPortalsResponse.Unmarshal(m, b)
}
func (m *ListTargetPortalsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetPortalsResponse.Marshal(b, m, deterministic)
}
func (m *ListTargetPortalsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetPortalsResponse.Merge(m, src)
}
func (m *ListTargetPortalsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTargetPortalsResponse.Size(m)
}
func (m *ListTargetPortalsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetPortalsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetPortalsResponse proto.InternalMessageInfo

func (m *ListTargetPortalsResponse) GetTargetPortals() []*TargetPortal {
	if m != nil {
		return m.TargetPortals
	}
	return nil
}

type ConnectTargetRequest struct {
	// Target portal to which the initiator will connect
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn string `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	// Connection authentication type, None by default
	//
	// One Way Chap uses the chap_username and chap_secret
	// fields mentioned below to authenticate the initiator.
	//
	// Mutual Chap uses both the user/secret mentioned below
	// and the Initiator Chap Secret to authenticate the target and initiator.
	AuthType AuthenticationType `protobuf:"varint,3,opt,name=auth_type,json=authType,proto3,enum=v1alpha1.AuthenticationType" json:"auth_type,omitempty"`
	// CHAP Username used to authenticate the initiator
	ChapUsername string `protobuf:"bytes,4,opt,name=chap_username,json=chapUsername,proto3" json:"chap_username,omitempty"`
	// CHAP password used to authenticate the initiator
	ChapSecret           string   `protobuf:"bytes,5,opt,name=chap_secret,json=chapSecret,proto3" json:"chap_secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectTargetRequest) Reset()         { *m = ConnectTargetRequest{} }
func (m *ConnectTargetRequest) String() string { return proto.CompactTextString(m) }
func (*ConnectTargetRequest) ProtoMessage()    {}
func (*ConnectTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{9}
}

func (m *ConnectTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectTargetRequest.Unmarshal(m, b)
}
func (m *ConnectTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectTargetRequest.Marshal(b, m, deterministic)
}
func (m *ConnectTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectTargetRequest.Merge(m, src)
}
func (m *ConnectTargetRequest) XXX_Size() int {
	return xxx_messageInfo_ConnectTargetRequest.Size(m)
}
func (m *ConnectTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectTargetRequest proto.InternalMessageInfo

func (m *ConnectTargetRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *ConnectTargetRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

func (m *ConnectTargetRequest) GetAuthType() AuthenticationType {
	if m != nil {
		return m.AuthType
	}
	return AuthenticationType_NONE
}

func (m *ConnectTargetRequest) GetChapUsername() string {
	if m != nil {
		return m.ChapUsername
	}
	return ""
}

func (m *ConnectTargetRequest) GetChapSecret() string {
	if m != nil {
		return m.ChapSecret
	}
	return ""
}

type ConnectTargetResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectTargetResponse) Reset()         { *m = ConnectTargetResponse{} }
func (m *ConnectTargetResponse) String() string { return proto.CompactTextString(m) }
func (*ConnectTargetResponse) ProtoMessage()    {}
func (*ConnectTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{10}
}

func (m *ConnectTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectTargetResponse.Unmarshal(m, b)
}
func (m *ConnectTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectTargetResponse.Marshal(b, m, deterministic)
}
func (m *ConnectTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectTargetResponse.Merge(m, src)
}
func (m *ConnectTargetResponse) XXX_Size() int {
	return xxx_messageInfo_ConnectTargetResponse.Size(m)
}
func (m *ConnectTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectTargetResponse proto.InternalMessageInfo

type GetTargetDisksRequest struct {
	// Target portal whose disks will be queried
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn                  string   `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetDisksRequest) Reset()         { *m = GetTargetDisksRequest{} }
func (m *GetTargetDisksRequest) String() string { return proto.CompactTextString(m) }
func (*GetTargetDisksRequest) ProtoMessage()    {}
func (*GetTargetDisksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{11}
}

func (m *GetTargetDisksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetDisksRequest.Unmarshal(m, b)
}
func (m *GetTargetDisksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetDisksRequest.Marshal(b, m, deterministic)
}
func (m *GetTargetDisksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetDisksRequest.Merge(m, src)
}
func (m *GetTargetDisksRequest) XXX_Size() int {
	return xxx_messageInfo_GetTargetDisksRequest.Size(m)
}
func (m *GetTargetDisksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetDisksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetDisksRequest proto.InternalMessageInfo

func (m *GetTargetDisksRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *GetTargetDisksRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

type GetTargetDisksResponse struct {
	// List composed of disk ids (numbers) that are associated with the
	// iSCSI target
	DiskIDs              []string `protobuf:"bytes,1,rep,name=diskIDs,proto3" json:"diskIDs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetDisksResponse) Reset()         { *m = GetTargetDisksResponse{} }
func (m *GetTargetDisksResponse) String() string { return proto.CompactTextString(m) }
func (*GetTargetDisksResponse) ProtoMessage()    {}
func (*GetTargetDisksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{12}
}

func (m *GetTargetDisksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetDisksResponse.Unmarshal(m, b)
}
func (m *GetTargetDisksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetDisksResponse.Marshal(b, m, deterministic)
}
func (m *GetTargetDisksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetDisksResponse.Merge(m, src)
}
func (m *GetTargetDisksResponse) XXX_Size() int {
	return xxx_messageInfo_GetTargetDisksResponse.Size(m)
}
func (m *GetTargetDisksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetDisksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetDisksResponse proto.InternalMessageInfo

func (m *GetTargetDisksResponse) GetDiskIDs() []string {
	if m != nil {
		return m.DiskIDs
	}
	return nil
}

type DisconnectTargetRequest struct {
	// Target portal from which initiator will disconnect
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn                  string   `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisconnectTargetRequest) Reset()         { *m = DisconnectTargetRequest{} }
func (m *DisconnectTargetRequest) String() string { return proto.CompactTextString(m) }
func (*DisconnectTargetRequest) ProtoMessage()    {}
func (*DisconnectTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{13}
}

func (m *DisconnectTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisconnectTargetRequest.Unmarshal(m, b)
}
func (m *DisconnectTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisconnectTargetRequest.Marshal(b, m, deterministic)
}
func (m *DisconnectTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisconnectTargetRequest.Merge(m, src)
}
func (m *DisconnectTargetRequest) XXX_Size() int {
	return xxx_messageInfo_DisconnectTargetRequest.Size(m)
}
func (m *DisconnectTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DisconnectTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DisconnectTargetRequest proto.InternalMessageInfo

func (m *DisconnectTargetRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *DisconnectTargetRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

type DisconnectTargetResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisconnectTargetResponse) Reset()         { *m = DisconnectTargetResponse{} }
func (m *DisconnectTargetResponse) String() string { return proto.CompactTextString(m) }
func (*DisconnectTargetResponse) ProtoMessage()    {}
func (*DisconnectTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0438d9bfe30f1df4, []int{14}
}

func (m *DisconnectTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisconnectTargetResponse.Unmarshal(m, b)
}
func (m *DisconnectTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisconnectTargetResponse.Marshal(b, m, deterministic)
}
func (m *DisconnectTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisconnectTargetResponse.Merge(m, src)
}
func (m *DisconnectTargetResponse) XXX_Size() int {
	return xxx_messageInfo_DisconnectTargetResponse.Size(m)
}
func (m *DisconnectTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DisconnectTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DisconnectTargetResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("v1alpha1.AuthenticationType", AuthenticationType_name, AuthenticationType_value)
	proto.RegisterType((*TargetPortal)(nil), "v1alpha1.TargetPortal")
	proto.RegisterType((*AddTargetPortalRequest)(nil), "v1alpha1.AddTargetPortalRequest")
	proto.RegisterType((*AddTargetPortalResponse)(nil), "v1alpha1.AddTargetPortalResponse")
	proto.RegisterType((*DiscoverTargetPortalRequest)(nil), "v1alpha1.DiscoverTargetPortalRequest")
	proto.RegisterType((*DiscoverTargetPortalResponse)(nil), "v1alpha1.DiscoverTargetPortalResponse")
	proto.RegisterType((*RemoveTargetPortalRequest)(nil), "v1alpha1.RemoveTargetPortalRequest")
	proto.RegisterType((*RemoveTargetPortalResponse)(nil), "v1alpha1.RemoveTargetPortalResponse")
	proto.RegisterType((*ListTargetPortalsRequest)(nil), "v1alpha1.ListTargetPortalsRequest")
	proto.RegisterType((*ListTargetPortalsResponse)(nil), "v1alpha1.ListTargetPortalsResponse")
	proto.RegisterType((*ConnectTargetRequest)(nil), "v1alpha1.ConnectTargetRequest")
	proto.RegisterType((*ConnectTargetResponse)(nil), "v1alpha1.ConnectTargetResponse")
	proto.RegisterType((*GetTargetDisksRequest)(nil), "v1alpha1.GetTargetDisksRequest")
	proto.RegisterType((*GetTargetDisksResponse)(nil), "v1alpha1.GetTargetDisksResponse")
	proto.RegisterType((*DisconnectTargetRequest)(nil), "v1alpha1.DisconnectTargetRequest")
	proto.RegisterType((*DisconnectTargetResponse)(nil), "v1alpha1.DisconnectTargetResponse")
}

func init() {
	proto.RegisterFile("github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha1/api.proto", fileDescriptor_0438d9bfe30f1df4)
}

var fileDescriptor_0438d9bfe30f1df4 = []byte{
	// 649 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x6d, 0x4f, 0xd3, 0x50,
	0x14, 0xa6, 0xbc, 0x28, 0x3b, 0xac, 0x30, 0x6f, 0x78, 0x29, 0x95, 0xc8, 0xb8, 0x88, 0x59, 0x4c,
	0xd8, 0xc2, 0xfc, 0x64, 0x0c, 0x31, 0x15, 0x08, 0x92, 0x20, 0x90, 0xca, 0x14, 0x67, 0xe2, 0x72,
	0xd7, 0x5d, 0xd7, 0x9b, 0x6d, 0x6d, 0xd7, 0x7b, 0xbb, 0xb8, 0x1f, 0xe2, 0x5f, 0xf4, 0x77, 0x98,
	0xbe, 0xac, 0xeb, 0xb6, 0x6e, 0x7e, 0x70, 0x7c, 0xeb, 0x7d, 0xee, 0x73, 0x9e, 0x73, 0xee, 0x79,
	0x2b, 0x5c, 0x36, 0x99, 0x30, 0xbd, 0x7a, 0xd1, 0xb0, 0x3b, 0xa5, 0x96, 0x57, 0xa7, 0xae, 0x45,
	0x05, 0xe5, 0xc7, 0x06, 0x67, 0x25, 0x83, 0xb3, 0x63, 0xc7, 0xb5, 0x7f, 0xf5, 0x4b, 0x46, 0x9b,
	0x51, 0x4b, 0x94, 0x88, 0xc3, 0x4a, 0x8c, 0xfb, 0x57, 0xbd, 0x13, 0xd2, 0x76, 0x4c, 0x72, 0xe2,
	0x43, 0x45, 0xc7, 0xb5, 0x85, 0x8d, 0x56, 0x07, 0x18, 0xfe, 0x02, 0xd9, 0x7b, 0xe2, 0x36, 0xa9,
	0xb8, 0xb3, 0x5d, 0x41, 0xda, 0xe8, 0x08, 0xd6, 0x45, 0x70, 0xae, 0x91, 0x46, 0xc3, 0xa5, 0x9c,
	0x2b, 0x52, 0x5e, 0x2a, 0x64, 0x74, 0x39, 0x44, 0xb5, 0x10, 0x44, 0xfb, 0xb0, 0x16, 0xd1, 0x1c,
	0xdb, 0x15, 0xca, 0x62, 0x5e, 0x2a, 0xc8, 0x3a, 0x88, 0x58, 0x09, 0x57, 0x60, 0x5b, 0x6b, 0x34,
	0x92, 0xd2, 0x3a, 0xed, 0x7a, 0x94, 0x0b, 0xf4, 0x0e, 0xe4, 0x84, 0x29, 0x69, 0x07, 0x0e, 0xd6,
	0xca, 0xdb, 0xc5, 0x41, 0x4c, 0xc5, 0x11, 0xab, 0xac, 0x48, 0x9c, 0xf0, 0x2e, 0xec, 0x4c, 0xc8,
	0x72, 0xc7, 0xb6, 0x38, 0xc5, 0x55, 0x78, 0x7e, 0xce, 0xb8, 0x61, 0xf7, 0xa8, 0x3b, 0x77, 0xb7,
	0x65, 0xd8, 0x4b, 0xd7, 0x0e, 0x7d, 0x23, 0x04, 0xcb, 0xac, 0x6b, 0xf9, 0xb9, 0x5a, 0x2a, 0x64,
	0xf4, 0xe0, 0x1b, 0x3f, 0xc0, 0xae, 0x4e, 0x3b, 0x76, 0x8f, 0xce, 0x3d, 0x9a, 0x3d, 0x50, 0xd3,
	0x94, 0xa3, 0x3c, 0xa8, 0xa0, 0x5c, 0x33, 0x2e, 0x92, 0x77, 0x3c, 0x72, 0x8b, 0xab, 0xb0, 0x9b,
	0x72, 0x17, 0x3d, 0xe2, 0x34, 0x2e, 0x7d, 0x18, 0x53, 0xf8, 0x9c, 0xe9, 0x41, 0xc9, 0xc9, 0xa0,
	0x38, 0xfe, 0x23, 0xc1, 0xe6, 0x99, 0x6d, 0x59, 0xd4, 0x88, 0xf4, 0xe7, 0xf1, 0x56, 0x94, 0x83,
	0x25, 0xd6, 0xb5, 0x82, 0x06, 0xcb, 0xe8, 0xfe, 0x27, 0x7a, 0x0b, 0x19, 0xe2, 0x09, 0xb3, 0x26,
	0xfa, 0x0e, 0x55, 0x96, 0xf2, 0x52, 0x61, 0xbd, 0xbc, 0x37, 0x94, 0xd2, 0x3c, 0x61, 0x52, 0x4b,
	0x30, 0x83, 0x08, 0x66, 0x5b, 0xf7, 0x7d, 0x87, 0xea, 0xab, 0x3e, 0xdd, 0xff, 0x42, 0x87, 0x20,
	0x1b, 0x26, 0x71, 0x6a, 0x1e, 0xa7, 0xae, 0x45, 0x3a, 0x54, 0x59, 0x0e, 0x64, 0xb3, 0x3e, 0x58,
	0x89, 0x30, 0xbf, 0xb5, 0x03, 0x12, 0xa7, 0x86, 0x4b, 0x85, 0xb2, 0x12, 0x50, 0xc0, 0x87, 0x3e,
	0x07, 0x08, 0xde, 0x81, 0xad, 0xb1, 0x77, 0x46, 0x99, 0xff, 0x09, 0x5b, 0x97, 0x34, 0x02, 0xcf,
	0x19, 0x6f, 0xf1, 0xc7, 0xc9, 0x00, 0x2e, 0xc3, 0xf6, 0xb8, 0x9f, 0xa8, 0x84, 0x0a, 0x3c, 0x6d,
	0x30, 0xde, 0xba, 0x3a, 0x1f, 0xb4, 0xe2, 0xe0, 0x88, 0x4d, 0xd8, 0x09, 0x3a, 0xf8, 0xd1, 0xeb,
	0xe3, 0xf7, 0xdf, 0xa4, 0xa7, 0x30, 0xbe, 0xd7, 0x1a, 0xa0, 0xc9, 0x02, 0xa1, 0x55, 0x58, 0xbe,
	0xb9, 0xbd, 0xb9, 0xc8, 0x2d, 0xa0, 0x1c, 0x64, 0x6f, 0x6f, 0x2e, 0x6a, 0x5f, 0xb5, 0x6f, 0xb5,
	0xb3, 0x8f, 0xda, 0x5d, 0x4e, 0x42, 0x1b, 0xb0, 0xf6, 0xa9, 0x72, 0x5f, 0xd1, 0xae, 0x43, 0x60,
	0xb1, 0xfc, 0x7b, 0x05, 0x56, 0xae, 0xfc, 0xbd, 0x86, 0x1e, 0x60, 0x63, 0x6c, 0x17, 0xa0, 0x7c,
	0xa2, 0x11, 0x52, 0xb7, 0x8f, 0x7a, 0x30, 0x83, 0x11, 0x95, 0x71, 0x01, 0x35, 0x61, 0x33, 0x6d,
	0xdc, 0xd1, 0xd1, 0xd0, 0x78, 0xc6, 0xaa, 0x51, 0x5f, 0xfd, 0x8b, 0x16, 0x3b, 0x22, 0x80, 0x26,
	0x27, 0x19, 0x1d, 0x0e, 0xed, 0xa7, 0x6e, 0x10, 0xf5, 0xe5, 0x6c, 0x52, 0xec, 0xe2, 0x07, 0x3c,
	0x9b, 0x18, 0x79, 0x84, 0x87, 0xc6, 0xd3, 0x76, 0x85, 0x7a, 0x38, 0x93, 0x13, 0xeb, 0xeb, 0x20,
	0x8f, 0x4c, 0x03, 0x7a, 0x31, 0xb4, 0x4b, 0x5b, 0x07, 0xea, 0xfe, 0xd4, 0xfb, 0x58, 0xf3, 0x3b,
	0xe4, 0xc6, 0x5b, 0x08, 0x1d, 0x8c, 0x25, 0x35, 0x45, 0x19, 0xcf, 0xa2, 0xc4, 0xe2, 0x15, 0x58,
	0x1f, 0x9d, 0x1e, 0x94, 0x88, 0x28, 0x75, 0x7e, 0xd5, 0xfc, 0x74, 0xc2, 0x40, 0xf6, 0xc3, 0xfb,
	0xea, 0xe9, 0x7f, 0xfd, 0x9d, 0xeb, 0x4f, 0x82, 0x5f, 0xf3, 0x9b, 0xbf, 0x01, 0x00, 0x00, 0xff,
	0xff, 0xbb, 0x3d, 0x8f, 0x5c, 0xe5, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IscsiClient is the client API for Iscsi service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IscsiClient interface {
	// AddTargetPortal registers an iSCSI target network address for later
	// discovery.
	// AddTargetPortal currently does not support selecting different NICs or
	// a different iSCSI initiator (e.g a hardware initiator). This means that
	// Windows will select the initiator NIC and instance on its own.
	AddTargetPortal(ctx context.Context, in *AddTargetPortalRequest, opts ...grpc.CallOption) (*AddTargetPortalResponse, error)
	// DiscoverTargetPortal initiates discovery on an iSCSI target network address
	// and returns discovered IQNs.
	DiscoverTargetPortal(ctx context.Context, in *DiscoverTargetPortalRequest, opts ...grpc.CallOption) (*DiscoverTargetPortalResponse, error)
	// RemoveTargetPortal removes an iSCSI target network address registration.
	RemoveTargetPortal(ctx context.Context, in *RemoveTargetPortalRequest, opts ...grpc.CallOption) (*RemoveTargetPortalResponse, error)
	// ListTargetPortal lists all currently registered iSCSI target network
	// addresses.
	ListTargetPortals(ctx context.Context, in *ListTargetPortalsRequest, opts ...grpc.CallOption) (*ListTargetPortalsResponse, error)
	// ConnectTarget connects to an iSCSI Target
	ConnectTarget(ctx context.Context, in *ConnectTargetRequest, opts ...grpc.CallOption) (*ConnectTargetResponse, error)
	// DisconnectTarget disconnects from an iSCSI Target
	DisconnectTarget(ctx context.Context, in *DisconnectTargetRequest, opts ...grpc.CallOption) (*DisconnectTargetResponse, error)
	// GetTargetDisks returns the disk addresses that correspond to an iSCSI
	// target
	GetTargetDisks(ctx context.Context, in *GetTargetDisksRequest, opts ...grpc.CallOption) (*GetTargetDisksResponse, error)
}

type iscsiClient struct {
	cc grpc.ClientConnInterface
}

func NewIscsiClient(cc grpc.ClientConnInterface) IscsiClient {
	return &iscsiClient{cc}
}

func (c *iscsiClient) AddTargetPortal(ctx context.Context, in *AddTargetPortalRequest, opts ...grpc.CallOption) (*AddTargetPortalResponse, error) {
	out := new(AddTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/AddTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) DiscoverTargetPortal(ctx context.Context, in *DiscoverTargetPortalRequest, opts ...grpc.CallOption) (*DiscoverTargetPortalResponse, error) {
	out := new(DiscoverTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/DiscoverTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) RemoveTargetPortal(ctx context.Context, in *RemoveTargetPortalRequest, opts ...grpc.CallOption) (*RemoveTargetPortalResponse, error) {
	out := new(RemoveTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/RemoveTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) ListTargetPortals(ctx context.Context, in *ListTargetPortalsRequest, opts ...grpc.CallOption) (*ListTargetPortalsResponse, error) {
	out := new(ListTargetPortalsResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/ListTargetPortals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) ConnectTarget(ctx context.Context, in *ConnectTargetRequest, opts ...grpc.CallOption) (*ConnectTargetResponse, error) {
	out := new(ConnectTargetResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/ConnectTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) DisconnectTarget(ctx context.Context, in *DisconnectTargetRequest, opts ...grpc.CallOption) (*DisconnectTargetResponse, error) {
	out := new(DisconnectTargetResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/DisconnectTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) GetTargetDisks(ctx context.Context, in *GetTargetDisksRequest, opts ...grpc.CallOption) (*GetTargetDisksResponse, error) {
	out := new(GetTargetDisksResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.Iscsi/GetTargetDisks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IscsiServer is the server API for Iscsi service.
type IscsiServer interface {
	// AddTargetPortal registers an iSCSI target network address for later
	// discovery.
	// AddTargetPortal currently does not support selecting different NICs or
	// a different iSCSI initiator (e.g a hardware initiator). This means that
	// Windows will select the initiator NIC and instance on its own.
	AddTargetPortal(context.Context, *AddTargetPortalRequest) (*AddTargetPortalResponse, error)
	// DiscoverTargetPortal initiates discovery on an iSCSI target network address
	// and returns discovered IQNs.
	DiscoverTargetPortal(context.Context, *DiscoverTargetPortalRequest) (*DiscoverTargetPortalResponse, error)
	// RemoveTargetPortal removes an iSCSI target network address registration.
	RemoveTargetPortal(context.Context, *RemoveTargetPortalRequest) (*RemoveTargetPortalResponse, error)
	// ListTargetPortal lists all currently registered iSCSI target network
	// addresses.
	ListTargetPortals(context.Context, *ListTargetPortalsRequest) (*ListTargetPortalsResponse, error)
	// ConnectTarget connects to an iSCSI Target
	ConnectTarget(context.Context, *ConnectTargetRequest) (*ConnectTargetResponse, error)
	// DisconnectTarget disconnects from an iSCSI Target
	DisconnectTarget(context.Context, *DisconnectTargetRequest) (*DisconnectTargetResponse, error)
	// GetTargetDisks returns the disk addresses that correspond to an iSCSI
	// target
	GetTargetDisks(context.Context, *GetTargetDisksRequest) (*GetTargetDisksResponse, error)
}

// UnimplementedIscsiServer can be embedded to have forward compatible implementations.
type UnimplementedIscsiServer struct {
}

func (*UnimplementedIscsiServer) AddTargetPortal(ctx context.Context, req *AddTargetPortalRequest) (*AddTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) DiscoverTargetPortal(ctx context.Context, req *DiscoverTargetPortalRequest) (*DiscoverTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscoverTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) RemoveTargetPortal(ctx context.Context, req *RemoveTargetPortalRequest) (*RemoveTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) ListTargetPortals(ctx context.Context, req *ListTargetPortalsRequest) (*ListTargetPortalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargetPortals not implemented")
}
func (*UnimplementedIscsiServer) ConnectTarget(ctx context.Context, req *ConnectTargetRequest) (*ConnectTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConnectTarget not implemented")
}
func (*UnimplementedIscsiServer) DisconnectTarget(ctx context.Context, req *DisconnectTargetRequest) (*DisconnectTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisconnectTarget not implemented")
}
func (*UnimplementedIscsiServer) GetTargetDisks(ctx context.Context, req *GetTargetDisksRequest) (*GetTargetDisksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTargetDisks not implemented")
}

func RegisterIscsiServer(s *grpc.Server, srv IscsiServer) {
	s.RegisterService(&_Iscsi_serviceDesc, srv)
}

func _Iscsi_AddTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).AddTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/AddTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).AddTargetPortal(ctx, req.(*AddTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_DiscoverTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoverTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).DiscoverTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/DiscoverTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).DiscoverTargetPortal(ctx, req.(*DiscoverTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_RemoveTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).RemoveTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/RemoveTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).RemoveTargetPortal(ctx, req.(*RemoveTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_ListTargetPortals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetPortalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).ListTargetPortals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/ListTargetPortals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).ListTargetPortals(ctx, req.(*ListTargetPortalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_ConnectTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConnectTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).ConnectTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/ConnectTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).ConnectTarget(ctx, req.(*ConnectTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_DisconnectTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisconnectTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).DisconnectTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/DisconnectTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).DisconnectTarget(ctx, req.(*DisconnectTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_GetTargetDisks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetDisksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).GetTargetDisks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.Iscsi/GetTargetDisks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).GetTargetDisks(ctx, req.(*GetTargetDisksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Iscsi_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha1.Iscsi",
	HandlerType: (*IscsiServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddTargetPortal",
			Handler:    _Iscsi_AddTargetPortal_Handler,
		},
		{
			MethodName: "DiscoverTargetPortal",
			Handler:    _Iscsi_DiscoverTargetPortal_Handler,
		},
		{
			MethodName: "RemoveTargetPortal",
			Handler:    _Iscsi_RemoveTargetPortal_Handler,
		},
		{
			MethodName: "ListTargetPortals",
			Handler:    _Iscsi_ListTargetPortals_Handler,
		},
		{
			MethodName: "ConnectTarget",
			Handler:    _Iscsi_ConnectTarget_Handler,
		},
		{
			MethodName: "DisconnectTarget",
			Handler:    _Iscsi_DisconnectTarget_Handler,
		},
		{
			MethodName: "GetTargetDisks",
			Handler:    _Iscsi_GetTargetDisks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha1/api.proto",
}
