// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha2/api.proto

package v1alpha2

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// iSCSI logon authentication type
type AuthenticationType int32

const (
	// No authentication is used
	AuthenticationType_NONE AuthenticationType = 0
	// One way CHAP authentication. The target authenticates the initiator.
	AuthenticationType_ONE_WAY_CHAP AuthenticationType = 1
	// Mutual CHAP authentication. The target and initiator authenticate each
	// other.
	AuthenticationType_MUTUAL_CHAP AuthenticationType = 2
)

var AuthenticationType_name = map[int32]string{
	0: "NONE",
	1: "ONE_WAY_CHAP",
	2: "MUTUAL_CHAP",
}

var AuthenticationType_value = map[string]int32{
	"NONE":         0,
	"ONE_WAY_CHAP": 1,
	"MUTUAL_CHAP":  2,
}

func (x AuthenticationType) String() string {
	return proto.EnumName(AuthenticationType_name, int32(x))
}

func (AuthenticationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{0}
}

// TargetPortal is an address and port pair for a specific iSCSI storage
// target.
type TargetPortal struct {
	// iSCSI Target (server) address
	TargetAddress string `protobuf:"bytes,1,opt,name=target_address,json=targetAddress,proto3" json:"target_address,omitempty"`
	// iSCSI Target port (default iSCSI port is 3260)
	TargetPort           uint32   `protobuf:"varint,2,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TargetPortal) Reset()         { *m = TargetPortal{} }
func (m *TargetPortal) String() string { return proto.CompactTextString(m) }
func (*TargetPortal) ProtoMessage()    {}
func (*TargetPortal) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{0}
}

func (m *TargetPortal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TargetPortal.Unmarshal(m, b)
}
func (m *TargetPortal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TargetPortal.Marshal(b, m, deterministic)
}
func (m *TargetPortal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetPortal.Merge(m, src)
}
func (m *TargetPortal) XXX_Size() int {
	return xxx_messageInfo_TargetPortal.Size(m)
}
func (m *TargetPortal) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetPortal.DiscardUnknown(m)
}

var xxx_messageInfo_TargetPortal proto.InternalMessageInfo

func (m *TargetPortal) GetTargetAddress() string {
	if m != nil {
		return m.TargetAddress
	}
	return ""
}

func (m *TargetPortal) GetTargetPort() uint32 {
	if m != nil {
		return m.TargetPort
	}
	return 0
}

type AddTargetPortalRequest struct {
	// iSCSI Target Portal to register in the initiator
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *AddTargetPortalRequest) Reset()         { *m = AddTargetPortalRequest{} }
func (m *AddTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*AddTargetPortalRequest) ProtoMessage()    {}
func (*AddTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{1}
}

func (m *AddTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetPortalRequest.Unmarshal(m, b)
}
func (m *AddTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *AddTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetPortalRequest.Merge(m, src)
}
func (m *AddTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_AddTargetPortalRequest.Size(m)
}
func (m *AddTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetPortalRequest proto.InternalMessageInfo

func (m *AddTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type AddTargetPortalResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AddTargetPortalResponse) Reset()         { *m = AddTargetPortalResponse{} }
func (m *AddTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*AddTargetPortalResponse) ProtoMessage()    {}
func (*AddTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{2}
}

func (m *AddTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AddTargetPortalResponse.Unmarshal(m, b)
}
func (m *AddTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AddTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *AddTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AddTargetPortalResponse.Merge(m, src)
}
func (m *AddTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_AddTargetPortalResponse.Size(m)
}
func (m *AddTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AddTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AddTargetPortalResponse proto.InternalMessageInfo

type DiscoverTargetPortalRequest struct {
	// iSCSI Target Portal on which to initiate discovery
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *DiscoverTargetPortalRequest) Reset()         { *m = DiscoverTargetPortalRequest{} }
func (m *DiscoverTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*DiscoverTargetPortalRequest) ProtoMessage()    {}
func (*DiscoverTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{3}
}

func (m *DiscoverTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Unmarshal(m, b)
}
func (m *DiscoverTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *DiscoverTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiscoverTargetPortalRequest.Merge(m, src)
}
func (m *DiscoverTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_DiscoverTargetPortalRequest.Size(m)
}
func (m *DiscoverTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DiscoverTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DiscoverTargetPortalRequest proto.InternalMessageInfo

func (m *DiscoverTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type DiscoverTargetPortalResponse struct {
	// List of discovered IQN addresses
	// follows IQN format: iqn.yyyy-mm.naming-authority:unique-name
	Iqns                 []string `protobuf:"bytes,1,rep,name=iqns,proto3" json:"iqns,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DiscoverTargetPortalResponse) Reset()         { *m = DiscoverTargetPortalResponse{} }
func (m *DiscoverTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*DiscoverTargetPortalResponse) ProtoMessage()    {}
func (*DiscoverTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{4}
}

func (m *DiscoverTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Unmarshal(m, b)
}
func (m *DiscoverTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *DiscoverTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiscoverTargetPortalResponse.Merge(m, src)
}
func (m *DiscoverTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_DiscoverTargetPortalResponse.Size(m)
}
func (m *DiscoverTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DiscoverTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DiscoverTargetPortalResponse proto.InternalMessageInfo

func (m *DiscoverTargetPortalResponse) GetIqns() []string {
	if m != nil {
		return m.Iqns
	}
	return nil
}

type RemoveTargetPortalRequest struct {
	// iSCSI Target Portal
	TargetPortal         *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *RemoveTargetPortalRequest) Reset()         { *m = RemoveTargetPortalRequest{} }
func (m *RemoveTargetPortalRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetPortalRequest) ProtoMessage()    {}
func (*RemoveTargetPortalRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{5}
}

func (m *RemoveTargetPortalRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetPortalRequest.Unmarshal(m, b)
}
func (m *RemoveTargetPortalRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetPortalRequest.Marshal(b, m, deterministic)
}
func (m *RemoveTargetPortalRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetPortalRequest.Merge(m, src)
}
func (m *RemoveTargetPortalRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetPortalRequest.Size(m)
}
func (m *RemoveTargetPortalRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetPortalRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetPortalRequest proto.InternalMessageInfo

func (m *RemoveTargetPortalRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

type RemoveTargetPortalResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveTargetPortalResponse) Reset()         { *m = RemoveTargetPortalResponse{} }
func (m *RemoveTargetPortalResponse) String() string { return proto.CompactTextString(m) }
func (*RemoveTargetPortalResponse) ProtoMessage()    {}
func (*RemoveTargetPortalResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{6}
}

func (m *RemoveTargetPortalResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveTargetPortalResponse.Unmarshal(m, b)
}
func (m *RemoveTargetPortalResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveTargetPortalResponse.Marshal(b, m, deterministic)
}
func (m *RemoveTargetPortalResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveTargetPortalResponse.Merge(m, src)
}
func (m *RemoveTargetPortalResponse) XXX_Size() int {
	return xxx_messageInfo_RemoveTargetPortalResponse.Size(m)
}
func (m *RemoveTargetPortalResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveTargetPortalResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveTargetPortalResponse proto.InternalMessageInfo

type ListTargetPortalsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTargetPortalsRequest) Reset()         { *m = ListTargetPortalsRequest{} }
func (m *ListTargetPortalsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTargetPortalsRequest) ProtoMessage()    {}
func (*ListTargetPortalsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{7}
}

func (m *ListTargetPortalsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetPortalsRequest.Unmarshal(m, b)
}
func (m *ListTargetPortalsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetPortalsRequest.Marshal(b, m, deterministic)
}
func (m *ListTargetPortalsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetPortalsRequest.Merge(m, src)
}
func (m *ListTargetPortalsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTargetPortalsRequest.Size(m)
}
func (m *ListTargetPortalsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetPortalsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetPortalsRequest proto.InternalMessageInfo

type ListTargetPortalsResponse struct {
	// A list of Target Portals currently registered in the initiator
	TargetPortals        []*TargetPortal `protobuf:"bytes,1,rep,name=target_portals,json=targetPortals,proto3" json:"target_portals,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListTargetPortalsResponse) Reset()         { *m = ListTargetPortalsResponse{} }
func (m *ListTargetPortalsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTargetPortalsResponse) ProtoMessage()    {}
func (*ListTargetPortalsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{8}
}

func (m *ListTargetPortalsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTargetPortalsResponse.Unmarshal(m, b)
}
func (m *ListTargetPortalsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTargetPortalsResponse.Marshal(b, m, deterministic)
}
func (m *ListTargetPortalsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTargetPortalsResponse.Merge(m, src)
}
func (m *ListTargetPortalsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTargetPortalsResponse.Size(m)
}
func (m *ListTargetPortalsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTargetPortalsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTargetPortalsResponse proto.InternalMessageInfo

func (m *ListTargetPortalsResponse) GetTargetPortals() []*TargetPortal {
	if m != nil {
		return m.TargetPortals
	}
	return nil
}

type ConnectTargetRequest struct {
	// Target portal to which the initiator will connect
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn string `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	// Connection authentication type, None by default
	//
	// One Way Chap uses the chap_username and chap_secret
	// fields mentioned below to authenticate the initiator.
	//
	// Mutual Chap uses both the user/secret mentioned below
	// and the Initiator Chap Secret (See `SetMutualChapSecret`)
	// to authenticate the target and initiator.
	AuthType AuthenticationType `protobuf:"varint,3,opt,name=auth_type,json=authType,proto3,enum=v1alpha2.AuthenticationType" json:"auth_type,omitempty"`
	// CHAP Username used to authenticate the initiator
	ChapUsername string `protobuf:"bytes,4,opt,name=chap_username,json=chapUsername,proto3" json:"chap_username,omitempty"`
	// CHAP password used to authenticate the initiator
	ChapSecret           string   `protobuf:"bytes,5,opt,name=chap_secret,json=chapSecret,proto3" json:"chap_secret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectTargetRequest) Reset()         { *m = ConnectTargetRequest{} }
func (m *ConnectTargetRequest) String() string { return proto.CompactTextString(m) }
func (*ConnectTargetRequest) ProtoMessage()    {}
func (*ConnectTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{9}
}

func (m *ConnectTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectTargetRequest.Unmarshal(m, b)
}
func (m *ConnectTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectTargetRequest.Marshal(b, m, deterministic)
}
func (m *ConnectTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectTargetRequest.Merge(m, src)
}
func (m *ConnectTargetRequest) XXX_Size() int {
	return xxx_messageInfo_ConnectTargetRequest.Size(m)
}
func (m *ConnectTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectTargetRequest proto.InternalMessageInfo

func (m *ConnectTargetRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *ConnectTargetRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

func (m *ConnectTargetRequest) GetAuthType() AuthenticationType {
	if m != nil {
		return m.AuthType
	}
	return AuthenticationType_NONE
}

func (m *ConnectTargetRequest) GetChapUsername() string {
	if m != nil {
		return m.ChapUsername
	}
	return ""
}

func (m *ConnectTargetRequest) GetChapSecret() string {
	if m != nil {
		return m.ChapSecret
	}
	return ""
}

type ConnectTargetResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnectTargetResponse) Reset()         { *m = ConnectTargetResponse{} }
func (m *ConnectTargetResponse) String() string { return proto.CompactTextString(m) }
func (*ConnectTargetResponse) ProtoMessage()    {}
func (*ConnectTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{10}
}

func (m *ConnectTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnectTargetResponse.Unmarshal(m, b)
}
func (m *ConnectTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnectTargetResponse.Marshal(b, m, deterministic)
}
func (m *ConnectTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnectTargetResponse.Merge(m, src)
}
func (m *ConnectTargetResponse) XXX_Size() int {
	return xxx_messageInfo_ConnectTargetResponse.Size(m)
}
func (m *ConnectTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnectTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConnectTargetResponse proto.InternalMessageInfo

type GetTargetDisksRequest struct {
	// Target portal whose disks will be queried
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn                  string   `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetDisksRequest) Reset()         { *m = GetTargetDisksRequest{} }
func (m *GetTargetDisksRequest) String() string { return proto.CompactTextString(m) }
func (*GetTargetDisksRequest) ProtoMessage()    {}
func (*GetTargetDisksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{11}
}

func (m *GetTargetDisksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetDisksRequest.Unmarshal(m, b)
}
func (m *GetTargetDisksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetDisksRequest.Marshal(b, m, deterministic)
}
func (m *GetTargetDisksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetDisksRequest.Merge(m, src)
}
func (m *GetTargetDisksRequest) XXX_Size() int {
	return xxx_messageInfo_GetTargetDisksRequest.Size(m)
}
func (m *GetTargetDisksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetDisksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetDisksRequest proto.InternalMessageInfo

func (m *GetTargetDisksRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *GetTargetDisksRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

type GetTargetDisksResponse struct {
	// List composed of disk ids (numbers) that are associated with the
	// iSCSI target
	DiskIDs              []string `protobuf:"bytes,1,rep,name=diskIDs,proto3" json:"diskIDs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTargetDisksResponse) Reset()         { *m = GetTargetDisksResponse{} }
func (m *GetTargetDisksResponse) String() string { return proto.CompactTextString(m) }
func (*GetTargetDisksResponse) ProtoMessage()    {}
func (*GetTargetDisksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{12}
}

func (m *GetTargetDisksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTargetDisksResponse.Unmarshal(m, b)
}
func (m *GetTargetDisksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTargetDisksResponse.Marshal(b, m, deterministic)
}
func (m *GetTargetDisksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTargetDisksResponse.Merge(m, src)
}
func (m *GetTargetDisksResponse) XXX_Size() int {
	return xxx_messageInfo_GetTargetDisksResponse.Size(m)
}
func (m *GetTargetDisksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTargetDisksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetTargetDisksResponse proto.InternalMessageInfo

func (m *GetTargetDisksResponse) GetDiskIDs() []string {
	if m != nil {
		return m.DiskIDs
	}
	return nil
}

type DisconnectTargetRequest struct {
	// Target portal from which initiator will disconnect
	TargetPortal *TargetPortal `protobuf:"bytes,1,opt,name=target_portal,json=targetPortal,proto3" json:"target_portal,omitempty"`
	// IQN of the iSCSI Target
	Iqn                  string   `protobuf:"bytes,2,opt,name=iqn,proto3" json:"iqn,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisconnectTargetRequest) Reset()         { *m = DisconnectTargetRequest{} }
func (m *DisconnectTargetRequest) String() string { return proto.CompactTextString(m) }
func (*DisconnectTargetRequest) ProtoMessage()    {}
func (*DisconnectTargetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{13}
}

func (m *DisconnectTargetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisconnectTargetRequest.Unmarshal(m, b)
}
func (m *DisconnectTargetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisconnectTargetRequest.Marshal(b, m, deterministic)
}
func (m *DisconnectTargetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisconnectTargetRequest.Merge(m, src)
}
func (m *DisconnectTargetRequest) XXX_Size() int {
	return xxx_messageInfo_DisconnectTargetRequest.Size(m)
}
func (m *DisconnectTargetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DisconnectTargetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DisconnectTargetRequest proto.InternalMessageInfo

func (m *DisconnectTargetRequest) GetTargetPortal() *TargetPortal {
	if m != nil {
		return m.TargetPortal
	}
	return nil
}

func (m *DisconnectTargetRequest) GetIqn() string {
	if m != nil {
		return m.Iqn
	}
	return ""
}

type DisconnectTargetResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisconnectTargetResponse) Reset()         { *m = DisconnectTargetResponse{} }
func (m *DisconnectTargetResponse) String() string { return proto.CompactTextString(m) }
func (*DisconnectTargetResponse) ProtoMessage()    {}
func (*DisconnectTargetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{14}
}

func (m *DisconnectTargetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisconnectTargetResponse.Unmarshal(m, b)
}
func (m *DisconnectTargetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisconnectTargetResponse.Marshal(b, m, deterministic)
}
func (m *DisconnectTargetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisconnectTargetResponse.Merge(m, src)
}
func (m *DisconnectTargetResponse) XXX_Size() int {
	return xxx_messageInfo_DisconnectTargetResponse.Size(m)
}
func (m *DisconnectTargetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DisconnectTargetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DisconnectTargetResponse proto.InternalMessageInfo

type SetMutualChapSecretRequest struct {
	// the default CHAP secret that all initiators on this machine (node) use to
	// authenticate the target on mutual CHAP authentication.
	// Must be at least 12 byte long for non-Ipsec connections, at least one
	// byte long for Ipsec connections, and at most 16 bytes long.
	MutualChapSecret     string   `protobuf:"bytes,1,opt,name=MutualChapSecret,proto3" json:"MutualChapSecret,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMutualChapSecretRequest) Reset()         { *m = SetMutualChapSecretRequest{} }
func (m *SetMutualChapSecretRequest) String() string { return proto.CompactTextString(m) }
func (*SetMutualChapSecretRequest) ProtoMessage()    {}
func (*SetMutualChapSecretRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{15}
}

func (m *SetMutualChapSecretRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMutualChapSecretRequest.Unmarshal(m, b)
}
func (m *SetMutualChapSecretRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMutualChapSecretRequest.Marshal(b, m, deterministic)
}
func (m *SetMutualChapSecretRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMutualChapSecretRequest.Merge(m, src)
}
func (m *SetMutualChapSecretRequest) XXX_Size() int {
	return xxx_messageInfo_SetMutualChapSecretRequest.Size(m)
}
func (m *SetMutualChapSecretRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMutualChapSecretRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetMutualChapSecretRequest proto.InternalMessageInfo

func (m *SetMutualChapSecretRequest) GetMutualChapSecret() string {
	if m != nil {
		return m.MutualChapSecret
	}
	return ""
}

type SetMutualChapSecretResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetMutualChapSecretResponse) Reset()         { *m = SetMutualChapSecretResponse{} }
func (m *SetMutualChapSecretResponse) String() string { return proto.CompactTextString(m) }
func (*SetMutualChapSecretResponse) ProtoMessage()    {}
func (*SetMutualChapSecretResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_3d2a5b20b77faa63, []int{16}
}

func (m *SetMutualChapSecretResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetMutualChapSecretResponse.Unmarshal(m, b)
}
func (m *SetMutualChapSecretResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetMutualChapSecretResponse.Marshal(b, m, deterministic)
}
func (m *SetMutualChapSecretResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetMutualChapSecretResponse.Merge(m, src)
}
func (m *SetMutualChapSecretResponse) XXX_Size() int {
	return xxx_messageInfo_SetMutualChapSecretResponse.Size(m)
}
func (m *SetMutualChapSecretResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SetMutualChapSecretResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SetMutualChapSecretResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("v1alpha2.AuthenticationType", AuthenticationType_name, AuthenticationType_value)
	proto.RegisterType((*TargetPortal)(nil), "v1alpha2.TargetPortal")
	proto.RegisterType((*AddTargetPortalRequest)(nil), "v1alpha2.AddTargetPortalRequest")
	proto.RegisterType((*AddTargetPortalResponse)(nil), "v1alpha2.AddTargetPortalResponse")
	proto.RegisterType((*DiscoverTargetPortalRequest)(nil), "v1alpha2.DiscoverTargetPortalRequest")
	proto.RegisterType((*DiscoverTargetPortalResponse)(nil), "v1alpha2.DiscoverTargetPortalResponse")
	proto.RegisterType((*RemoveTargetPortalRequest)(nil), "v1alpha2.RemoveTargetPortalRequest")
	proto.RegisterType((*RemoveTargetPortalResponse)(nil), "v1alpha2.RemoveTargetPortalResponse")
	proto.RegisterType((*ListTargetPortalsRequest)(nil), "v1alpha2.ListTargetPortalsRequest")
	proto.RegisterType((*ListTargetPortalsResponse)(nil), "v1alpha2.ListTargetPortalsResponse")
	proto.RegisterType((*ConnectTargetRequest)(nil), "v1alpha2.ConnectTargetRequest")
	proto.RegisterType((*ConnectTargetResponse)(nil), "v1alpha2.ConnectTargetResponse")
	proto.RegisterType((*GetTargetDisksRequest)(nil), "v1alpha2.GetTargetDisksRequest")
	proto.RegisterType((*GetTargetDisksResponse)(nil), "v1alpha2.GetTargetDisksResponse")
	proto.RegisterType((*DisconnectTargetRequest)(nil), "v1alpha2.DisconnectTargetRequest")
	proto.RegisterType((*DisconnectTargetResponse)(nil), "v1alpha2.DisconnectTargetResponse")
	proto.RegisterType((*SetMutualChapSecretRequest)(nil), "v1alpha2.SetMutualChapSecretRequest")
	proto.RegisterType((*SetMutualChapSecretResponse)(nil), "v1alpha2.SetMutualChapSecretResponse")
}

func init() {
	proto.RegisterFile("github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha2/api.proto", fileDescriptor_3d2a5b20b77faa63)
}

var fileDescriptor_3d2a5b20b77faa63 = []byte{
	// 697 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0x5b, 0x4f, 0xdb, 0x4c,
	0x10, 0x25, 0x5c, 0xbe, 0x8f, 0x0c, 0x09, 0xa4, 0x53, 0x2e, 0xc6, 0xd0, 0x12, 0x96, 0x52, 0x45,
	0x48, 0x24, 0x6a, 0xfa, 0x54, 0x55, 0xa8, 0x72, 0x01, 0x01, 0x12, 0x37, 0x19, 0xd2, 0x52, 0x2a,
	0x35, 0x5a, 0x9c, 0x2d, 0x59, 0x11, 0x6c, 0xe3, 0x5d, 0xa3, 0xf2, 0x87, 0xfb, 0x27, 0xfa, 0x52,
	0xd9, 0xde, 0x38, 0x26, 0x71, 0xc2, 0x43, 0xc3, 0x9b, 0xf7, 0xec, 0x99, 0x33, 0xb3, 0xb3, 0xb3,
	0x47, 0x86, 0xbd, 0x6b, 0x2e, 0x9b, 0xfe, 0x55, 0xd9, 0x72, 0x6e, 0x2b, 0x37, 0xfe, 0x15, 0xf3,
	0x6c, 0x26, 0x99, 0xd8, 0xb4, 0x04, 0xaf, 0x58, 0x82, 0x6f, 0xba, 0x9e, 0xf3, 0xeb, 0xa1, 0x62,
	0xb5, 0x38, 0xb3, 0x65, 0x85, 0xba, 0xbc, 0xc2, 0x45, 0xb0, 0x75, 0xff, 0x8e, 0xb6, 0xdc, 0x26,
	0xad, 0x06, 0x50, 0xd9, 0xf5, 0x1c, 0xe9, 0xe0, 0x64, 0x1b, 0x23, 0x5f, 0x20, 0x77, 0x4e, 0xbd,
	0x6b, 0x26, 0x4f, 0x1d, 0x4f, 0xd2, 0x16, 0xae, 0xc3, 0xb4, 0x0c, 0xd7, 0x75, 0xda, 0x68, 0x78,
	0x4c, 0x08, 0x2d, 0x53, 0xcc, 0x94, 0xb2, 0x66, 0x3e, 0x42, 0x8d, 0x08, 0xc4, 0x15, 0x98, 0x52,
	0x34, 0xd7, 0xf1, 0xa4, 0x36, 0x5a, 0xcc, 0x94, 0xf2, 0x26, 0xc8, 0x58, 0x89, 0xd4, 0x60, 0xde,
	0x68, 0x34, 0x92, 0xd2, 0x26, 0xbb, 0xf3, 0x99, 0x90, 0xf8, 0x11, 0xf2, 0x89, 0x50, 0xda, 0x0a,
	0x13, 0x4c, 0x55, 0xe7, 0xcb, 0xed, 0x9a, 0xca, 0x8f, 0xa2, 0x72, 0x32, 0xb1, 0x22, 0x8b, 0xb0,
	0xd0, 0x23, 0x2b, 0x5c, 0xc7, 0x16, 0x8c, 0x5c, 0xc2, 0xd2, 0x0e, 0x17, 0x96, 0x73, 0xcf, 0xbc,
	0xa1, 0xa7, 0xad, 0xc2, 0x72, 0xba, 0x76, 0x94, 0x1b, 0x11, 0xc6, 0xf9, 0x9d, 0x1d, 0xf4, 0x6a,
	0xac, 0x94, 0x35, 0xc3, 0x6f, 0x72, 0x01, 0x8b, 0x26, 0xbb, 0x75, 0xee, 0xd9, 0xd0, 0xab, 0x59,
	0x06, 0x3d, 0x4d, 0x59, 0xf5, 0x41, 0x07, 0xed, 0x90, 0x0b, 0x99, 0xdc, 0x13, 0x2a, 0x2d, 0xb9,
	0x84, 0xc5, 0x94, 0x3d, 0x75, 0x88, 0xad, 0xf8, 0xea, 0xa3, 0x9a, 0xa2, 0xe3, 0xf4, 0x2f, 0x2a,
	0x9f, 0x2c, 0x4a, 0x90, 0xdf, 0x19, 0x98, 0xdd, 0x76, 0x6c, 0x9b, 0x59, 0x4a, 0x7f, 0x18, 0x67,
	0xc5, 0x02, 0x8c, 0xf1, 0x3b, 0x3b, 0x1c, 0xb0, 0xac, 0x19, 0x7c, 0xe2, 0x07, 0xc8, 0x52, 0x5f,
	0x36, 0xeb, 0xf2, 0xc1, 0x65, 0xda, 0x58, 0x31, 0x53, 0x9a, 0xae, 0x2e, 0x77, 0xa4, 0x0c, 0x5f,
	0x36, 0x99, 0x2d, 0xb9, 0x45, 0x25, 0x77, 0xec, 0xf3, 0x07, 0x97, 0x99, 0x93, 0x01, 0x3d, 0xf8,
	0xc2, 0x35, 0xc8, 0x5b, 0x4d, 0xea, 0xd6, 0x7d, 0xc1, 0x3c, 0x9b, 0xde, 0x32, 0x6d, 0x3c, 0x94,
	0xcd, 0x05, 0x60, 0x4d, 0x61, 0xc1, 0x68, 0x87, 0x24, 0xc1, 0x2c, 0x8f, 0x49, 0x6d, 0x22, 0xa4,
	0x40, 0x00, 0x9d, 0x85, 0x08, 0x59, 0x80, 0xb9, 0xae, 0x73, 0xaa, 0xce, 0xff, 0x84, 0xb9, 0x3d,
	0xa6, 0xc0, 0x1d, 0x2e, 0x6e, 0xc4, 0xf3, 0x74, 0x80, 0x54, 0x61, 0xbe, 0x3b, 0x8f, 0xba, 0x42,
	0x0d, 0xfe, 0x6f, 0x70, 0x71, 0x73, 0xb0, 0xd3, 0x1e, 0xc5, 0xf6, 0x92, 0x34, 0x61, 0x21, 0x9c,
	0xe0, 0x67, 0xbf, 0x9f, 0x60, 0xfe, 0x7a, 0x33, 0xa9, 0x0e, 0xed, 0x83, 0x7e, 0xc6, 0xe4, 0x91,
	0x2f, 0x7d, 0xda, 0xda, 0x8e, 0x3b, 0xda, 0x2e, 0x64, 0x03, 0x0a, 0xdd, 0x5b, 0xca, 0x7d, 0x7a,
	0x70, 0xf2, 0x0a, 0x96, 0x52, 0x95, 0xa2, 0x44, 0x1b, 0x06, 0x60, 0xef, 0x24, 0xe0, 0x24, 0x8c,
	0x1f, 0x9f, 0x1c, 0xef, 0x16, 0x46, 0xb0, 0x00, 0xb9, 0x93, 0xe3, 0xdd, 0xfa, 0x57, 0xe3, 0x5b,
	0x7d, 0x7b, 0xdf, 0x38, 0x2d, 0x64, 0x70, 0x06, 0xa6, 0x8e, 0x6a, 0xe7, 0x35, 0xe3, 0x30, 0x02,
	0x46, 0xab, 0x7f, 0x26, 0x60, 0xe2, 0x20, 0x30, 0x50, 0xbc, 0x80, 0x99, 0x2e, 0xd3, 0xc1, 0x62,
	0x62, 0xe2, 0x52, 0x6d, 0x4e, 0x5f, 0x1d, 0xc0, 0x50, 0xdd, 0x18, 0xc1, 0x6b, 0x98, 0x4d, 0xf3,
	0x15, 0x5c, 0xef, 0x04, 0x0f, 0xf0, 0x34, 0xfd, 0xed, 0x53, 0xb4, 0x38, 0x11, 0x05, 0xec, 0xb5,
	0x0c, 0x5c, 0xeb, 0xc4, 0xf7, 0xb5, 0x2a, 0xfd, 0xcd, 0x60, 0x52, 0x9c, 0xe2, 0x07, 0xbc, 0xe8,
	0xf1, 0x16, 0x24, 0x9d, 0xe0, 0x7e, 0xa6, 0xa4, 0xaf, 0x0d, 0xe4, 0xc4, 0xfa, 0x26, 0xe4, 0x1f,
	0x3d, 0x3b, 0x7c, 0xdd, 0x89, 0x4b, 0xf3, 0x1d, 0x7d, 0xa5, 0xef, 0x7e, 0xac, 0xf9, 0x1d, 0x0a,
	0xdd, 0xb3, 0x8a, 0xab, 0x5d, 0x4d, 0x4d, 0x51, 0x26, 0x83, 0x28, 0xb1, 0x78, 0x0d, 0xa6, 0x1f,
	0x3f, 0x53, 0x4c, 0x54, 0x94, 0x6a, 0x14, 0x7a, 0xb1, 0x3f, 0x21, 0x96, 0x6d, 0xc0, 0xcb, 0x94,
	0xc9, 0xc7, 0xc4, 0x35, 0xf5, 0x7f, 0x62, 0xfa, 0xfa, 0x13, 0xac, 0x76, 0x96, 0xcf, 0x9f, 0x2e,
	0xb7, 0xfe, 0xe9, 0x67, 0xe3, 0xea, 0xbf, 0xf0, 0x4f, 0xe3, 0xfd, 0xdf, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xaf, 0xbf, 0xa1, 0x93, 0xb4, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// IscsiClient is the client API for Iscsi service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IscsiClient interface {
	// AddTargetPortal registers an iSCSI target network address for later
	// discovery.
	// AddTargetPortal currently does not support selecting different NICs or
	// a different iSCSI initiator (e.g a hardware initiator). This means that
	// Windows will select the initiator NIC and instance on its own.
	AddTargetPortal(ctx context.Context, in *AddTargetPortalRequest, opts ...grpc.CallOption) (*AddTargetPortalResponse, error)
	// DiscoverTargetPortal initiates discovery on an iSCSI target network address
	// and returns discovered IQNs.
	DiscoverTargetPortal(ctx context.Context, in *DiscoverTargetPortalRequest, opts ...grpc.CallOption) (*DiscoverTargetPortalResponse, error)
	// RemoveTargetPortal removes an iSCSI target network address registration.
	RemoveTargetPortal(ctx context.Context, in *RemoveTargetPortalRequest, opts ...grpc.CallOption) (*RemoveTargetPortalResponse, error)
	// ListTargetPortal lists all currently registered iSCSI target network
	// addresses.
	ListTargetPortals(ctx context.Context, in *ListTargetPortalsRequest, opts ...grpc.CallOption) (*ListTargetPortalsResponse, error)
	// ConnectTarget connects to an iSCSI Target
	ConnectTarget(ctx context.Context, in *ConnectTargetRequest, opts ...grpc.CallOption) (*ConnectTargetResponse, error)
	// DisconnectTarget disconnects from an iSCSI Target
	DisconnectTarget(ctx context.Context, in *DisconnectTargetRequest, opts ...grpc.CallOption) (*DisconnectTargetResponse, error)
	// GetTargetDisks returns the disk addresses that correspond to an iSCSI
	// target
	GetTargetDisks(ctx context.Context, in *GetTargetDisksRequest, opts ...grpc.CallOption) (*GetTargetDisksResponse, error)
	// SetMutualChapSecret sets the default CHAP secret that all initiators on
	// this machine (node) use to authenticate the target on mutual CHAP
	// authentication.
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	SetMutualChapSecret(ctx context.Context, in *SetMutualChapSecretRequest, opts ...grpc.CallOption) (*SetMutualChapSecretResponse, error)
}

type iscsiClient struct {
	cc grpc.ClientConnInterface
}

func NewIscsiClient(cc grpc.ClientConnInterface) IscsiClient {
	return &iscsiClient{cc}
}

func (c *iscsiClient) AddTargetPortal(ctx context.Context, in *AddTargetPortalRequest, opts ...grpc.CallOption) (*AddTargetPortalResponse, error) {
	out := new(AddTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/AddTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) DiscoverTargetPortal(ctx context.Context, in *DiscoverTargetPortalRequest, opts ...grpc.CallOption) (*DiscoverTargetPortalResponse, error) {
	out := new(DiscoverTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/DiscoverTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) RemoveTargetPortal(ctx context.Context, in *RemoveTargetPortalRequest, opts ...grpc.CallOption) (*RemoveTargetPortalResponse, error) {
	out := new(RemoveTargetPortalResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/RemoveTargetPortal", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) ListTargetPortals(ctx context.Context, in *ListTargetPortalsRequest, opts ...grpc.CallOption) (*ListTargetPortalsResponse, error) {
	out := new(ListTargetPortalsResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/ListTargetPortals", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) ConnectTarget(ctx context.Context, in *ConnectTargetRequest, opts ...grpc.CallOption) (*ConnectTargetResponse, error) {
	out := new(ConnectTargetResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/ConnectTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) DisconnectTarget(ctx context.Context, in *DisconnectTargetRequest, opts ...grpc.CallOption) (*DisconnectTargetResponse, error) {
	out := new(DisconnectTargetResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/DisconnectTarget", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) GetTargetDisks(ctx context.Context, in *GetTargetDisksRequest, opts ...grpc.CallOption) (*GetTargetDisksResponse, error) {
	out := new(GetTargetDisksResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/GetTargetDisks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iscsiClient) SetMutualChapSecret(ctx context.Context, in *SetMutualChapSecretRequest, opts ...grpc.CallOption) (*SetMutualChapSecretResponse, error) {
	out := new(SetMutualChapSecretResponse)
	err := c.cc.Invoke(ctx, "/v1alpha2.Iscsi/SetMutualChapSecret", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IscsiServer is the server API for Iscsi service.
type IscsiServer interface {
	// AddTargetPortal registers an iSCSI target network address for later
	// discovery.
	// AddTargetPortal currently does not support selecting different NICs or
	// a different iSCSI initiator (e.g a hardware initiator). This means that
	// Windows will select the initiator NIC and instance on its own.
	AddTargetPortal(context.Context, *AddTargetPortalRequest) (*AddTargetPortalResponse, error)
	// DiscoverTargetPortal initiates discovery on an iSCSI target network address
	// and returns discovered IQNs.
	DiscoverTargetPortal(context.Context, *DiscoverTargetPortalRequest) (*DiscoverTargetPortalResponse, error)
	// RemoveTargetPortal removes an iSCSI target network address registration.
	RemoveTargetPortal(context.Context, *RemoveTargetPortalRequest) (*RemoveTargetPortalResponse, error)
	// ListTargetPortal lists all currently registered iSCSI target network
	// addresses.
	ListTargetPortals(context.Context, *ListTargetPortalsRequest) (*ListTargetPortalsResponse, error)
	// ConnectTarget connects to an iSCSI Target
	ConnectTarget(context.Context, *ConnectTargetRequest) (*ConnectTargetResponse, error)
	// DisconnectTarget disconnects from an iSCSI Target
	DisconnectTarget(context.Context, *DisconnectTargetRequest) (*DisconnectTargetResponse, error)
	// GetTargetDisks returns the disk addresses that correspond to an iSCSI
	// target
	GetTargetDisks(context.Context, *GetTargetDisksRequest) (*GetTargetDisksResponse, error)
	// SetMutualChapSecret sets the default CHAP secret that all initiators on
	// this machine (node) use to authenticate the target on mutual CHAP
	// authentication.
	// NOTE: This method affects global node state and should only be used
	//       with consideration to other CSI drivers that run concurrently.
	SetMutualChapSecret(context.Context, *SetMutualChapSecretRequest) (*SetMutualChapSecretResponse, error)
}

// UnimplementedIscsiServer can be embedded to have forward compatible implementations.
type UnimplementedIscsiServer struct {
}

func (*UnimplementedIscsiServer) AddTargetPortal(ctx context.Context, req *AddTargetPortalRequest) (*AddTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) DiscoverTargetPortal(ctx context.Context, req *DiscoverTargetPortalRequest) (*DiscoverTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DiscoverTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) RemoveTargetPortal(ctx context.Context, req *RemoveTargetPortalRequest) (*RemoveTargetPortalResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveTargetPortal not implemented")
}
func (*UnimplementedIscsiServer) ListTargetPortals(ctx context.Context, req *ListTargetPortalsRequest) (*ListTargetPortalsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargetPortals not implemented")
}
func (*UnimplementedIscsiServer) ConnectTarget(ctx context.Context, req *ConnectTargetRequest) (*ConnectTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ConnectTarget not implemented")
}
func (*UnimplementedIscsiServer) DisconnectTarget(ctx context.Context, req *DisconnectTargetRequest) (*DisconnectTargetResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisconnectTarget not implemented")
}
func (*UnimplementedIscsiServer) GetTargetDisks(ctx context.Context, req *GetTargetDisksRequest) (*GetTargetDisksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTargetDisks not implemented")
}
func (*UnimplementedIscsiServer) SetMutualChapSecret(ctx context.Context, req *SetMutualChapSecretRequest) (*SetMutualChapSecretResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMutualChapSecret not implemented")
}

func RegisterIscsiServer(s *grpc.Server, srv IscsiServer) {
	s.RegisterService(&_Iscsi_serviceDesc, srv)
}

func _Iscsi_AddTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).AddTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/AddTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).AddTargetPortal(ctx, req.(*AddTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_DiscoverTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoverTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).DiscoverTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/DiscoverTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).DiscoverTargetPortal(ctx, req.(*DiscoverTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_RemoveTargetPortal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveTargetPortalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).RemoveTargetPortal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/RemoveTargetPortal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).RemoveTargetPortal(ctx, req.(*RemoveTargetPortalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_ListTargetPortals_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetPortalsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).ListTargetPortals(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/ListTargetPortals",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).ListTargetPortals(ctx, req.(*ListTargetPortalsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_ConnectTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConnectTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).ConnectTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/ConnectTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).ConnectTarget(ctx, req.(*ConnectTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_DisconnectTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisconnectTargetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).DisconnectTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/DisconnectTarget",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).DisconnectTarget(ctx, req.(*DisconnectTargetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_GetTargetDisks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetDisksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).GetTargetDisks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/GetTargetDisks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).GetTargetDisks(ctx, req.(*GetTargetDisksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Iscsi_SetMutualChapSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMutualChapSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IscsiServer).SetMutualChapSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha2.Iscsi/SetMutualChapSecret",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IscsiServer).SetMutualChapSecret(ctx, req.(*SetMutualChapSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Iscsi_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha2.Iscsi",
	HandlerType: (*IscsiServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddTargetPortal",
			Handler:    _Iscsi_AddTargetPortal_Handler,
		},
		{
			MethodName: "DiscoverTargetPortal",
			Handler:    _Iscsi_DiscoverTargetPortal_Handler,
		},
		{
			MethodName: "RemoveTargetPortal",
			Handler:    _Iscsi_RemoveTargetPortal_Handler,
		},
		{
			MethodName: "ListTargetPortals",
			Handler:    _Iscsi_ListTargetPortals_Handler,
		},
		{
			MethodName: "ConnectTarget",
			Handler:    _Iscsi_ConnectTarget_Handler,
		},
		{
			MethodName: "DisconnectTarget",
			Handler:    _Iscsi_DisconnectTarget_Handler,
		},
		{
			MethodName: "GetTargetDisks",
			Handler:    _Iscsi_GetTargetDisks_Handler,
		},
		{
			MethodName: "SetMutualChapSecret",
			Handler:    _Iscsi_SetMutualChapSecret_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/kubernetes-csi/csi-proxy/client/api/iscsi/v1alpha2/api.proto",
}
