// Code generated by protoc-gen-go. DO NOT EDIT.
// source: github.com/kubernetes-csi/csi-proxy/client/api/smb/v1beta1/api.proto

package v1beta1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type NewSmbGlobalMappingRequest struct {
	// A remote SMB share to mount
	// All unicode characters allowed in SMB server name specifications are
	// permitted except for restrictions below
	//
	// Restrictions:
	// SMB remote path specified in the format: \\server-name\sharename, \\server.fqdn\sharename or \\a.b.c.d\sharename
	// If not an IP address, share name has to be a valid DNS name.
	// UNC specifications to local paths or prefix: \\?\ is not allowed.
	// Characters: + [ ] " / : ; | < > , ? * = $ are not allowed.
	RemotePath string `protobuf:"bytes,1,opt,name=remote_path,json=remotePath,proto3" json:"remote_path,omitempty"`
	// Optional local path to mount the smb on
	LocalPath string `protobuf:"bytes,2,opt,name=local_path,json=localPath,proto3" json:"local_path,omitempty"`
	// Username credential associated with the share
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Password credential associated with the share
	Password             string   `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NewSmbGlobalMappingRequest) Reset()         { *m = NewSmbGlobalMappingRequest{} }
func (m *NewSmbGlobalMappingRequest) String() string { return proto.CompactTextString(m) }
func (*NewSmbGlobalMappingRequest) ProtoMessage()    {}
func (*NewSmbGlobalMappingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_795681d29a954457, []int{0}
}

func (m *NewSmbGlobalMappingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NewSmbGlobalMappingRequest.Unmarshal(m, b)
}
func (m *NewSmbGlobalMappingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NewSmbGlobalMappingRequest.Marshal(b, m, deterministic)
}
func (m *NewSmbGlobalMappingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewSmbGlobalMappingRequest.Merge(m, src)
}
func (m *NewSmbGlobalMappingRequest) XXX_Size() int {
	return xxx_messageInfo_NewSmbGlobalMappingRequest.Size(m)
}
func (m *NewSmbGlobalMappingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NewSmbGlobalMappingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NewSmbGlobalMappingRequest proto.InternalMessageInfo

func (m *NewSmbGlobalMappingRequest) GetRemotePath() string {
	if m != nil {
		return m.RemotePath
	}
	return ""
}

func (m *NewSmbGlobalMappingRequest) GetLocalPath() string {
	if m != nil {
		return m.LocalPath
	}
	return ""
}

func (m *NewSmbGlobalMappingRequest) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *NewSmbGlobalMappingRequest) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type NewSmbGlobalMappingResponse struct {
	// Windows error code
	// Success is represented as 0
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NewSmbGlobalMappingResponse) Reset()         { *m = NewSmbGlobalMappingResponse{} }
func (m *NewSmbGlobalMappingResponse) String() string { return proto.CompactTextString(m) }
func (*NewSmbGlobalMappingResponse) ProtoMessage()    {}
func (*NewSmbGlobalMappingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_795681d29a954457, []int{1}
}

func (m *NewSmbGlobalMappingResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NewSmbGlobalMappingResponse.Unmarshal(m, b)
}
func (m *NewSmbGlobalMappingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NewSmbGlobalMappingResponse.Marshal(b, m, deterministic)
}
func (m *NewSmbGlobalMappingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NewSmbGlobalMappingResponse.Merge(m, src)
}
func (m *NewSmbGlobalMappingResponse) XXX_Size() int {
	return xxx_messageInfo_NewSmbGlobalMappingResponse.Size(m)
}
func (m *NewSmbGlobalMappingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NewSmbGlobalMappingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NewSmbGlobalMappingResponse proto.InternalMessageInfo

func (m *NewSmbGlobalMappingResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type RemoveSmbGlobalMappingRequest struct {
	// A remote SMB share mapping to remove
	// All unicode characters allowed in SMB server name specifications are
	// permitted except for restrictions below
	//
	// Restrictions:
	// SMB share specified in the format: \\server-name\sharename, \\server.fqdn\sharename or \\a.b.c.d\sharename
	// If not an IP address, share name has to be a valid DNS name.
	// UNC specifications to local paths or prefix: \\?\ is not allowed.
	// Characters: + [ ] " / : ; | < > , ? * = $ are not allowed.
	RemotePath           string   `protobuf:"bytes,1,opt,name=remote_path,json=remotePath,proto3" json:"remote_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveSmbGlobalMappingRequest) Reset()         { *m = RemoveSmbGlobalMappingRequest{} }
func (m *RemoveSmbGlobalMappingRequest) String() string { return proto.CompactTextString(m) }
func (*RemoveSmbGlobalMappingRequest) ProtoMessage()    {}
func (*RemoveSmbGlobalMappingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_795681d29a954457, []int{2}
}

func (m *RemoveSmbGlobalMappingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveSmbGlobalMappingRequest.Unmarshal(m, b)
}
func (m *RemoveSmbGlobalMappingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveSmbGlobalMappingRequest.Marshal(b, m, deterministic)
}
func (m *RemoveSmbGlobalMappingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSmbGlobalMappingRequest.Merge(m, src)
}
func (m *RemoveSmbGlobalMappingRequest) XXX_Size() int {
	return xxx_messageInfo_RemoveSmbGlobalMappingRequest.Size(m)
}
func (m *RemoveSmbGlobalMappingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSmbGlobalMappingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSmbGlobalMappingRequest proto.InternalMessageInfo

func (m *RemoveSmbGlobalMappingRequest) GetRemotePath() string {
	if m != nil {
		return m.RemotePath
	}
	return ""
}

type RemoveSmbGlobalMappingResponse struct {
	// Windows error code
	// Success is represented as 0
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoveSmbGlobalMappingResponse) Reset()         { *m = RemoveSmbGlobalMappingResponse{} }
func (m *RemoveSmbGlobalMappingResponse) String() string { return proto.CompactTextString(m) }
func (*RemoveSmbGlobalMappingResponse) ProtoMessage()    {}
func (*RemoveSmbGlobalMappingResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_795681d29a954457, []int{3}
}

func (m *RemoveSmbGlobalMappingResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoveSmbGlobalMappingResponse.Unmarshal(m, b)
}
func (m *RemoveSmbGlobalMappingResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoveSmbGlobalMappingResponse.Marshal(b, m, deterministic)
}
func (m *RemoveSmbGlobalMappingResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoveSmbGlobalMappingResponse.Merge(m, src)
}
func (m *RemoveSmbGlobalMappingResponse) XXX_Size() int {
	return xxx_messageInfo_RemoveSmbGlobalMappingResponse.Size(m)
}
func (m *RemoveSmbGlobalMappingResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoveSmbGlobalMappingResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoveSmbGlobalMappingResponse proto.InternalMessageInfo

func (m *RemoveSmbGlobalMappingResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func init() {
	proto.RegisterType((*NewSmbGlobalMappingRequest)(nil), "v1beta1.NewSmbGlobalMappingRequest")
	proto.RegisterType((*NewSmbGlobalMappingResponse)(nil), "v1beta1.NewSmbGlobalMappingResponse")
	proto.RegisterType((*RemoveSmbGlobalMappingRequest)(nil), "v1beta1.RemoveSmbGlobalMappingRequest")
	proto.RegisterType((*RemoveSmbGlobalMappingResponse)(nil), "v1beta1.RemoveSmbGlobalMappingResponse")
}

func init() {
	proto.RegisterFile("github.com/kubernetes-csi/csi-proxy/client/api/smb/v1beta1/api.proto", fileDescriptor_795681d29a954457)
}

var fileDescriptor_795681d29a954457 = []byte{
	// 296 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x92, 0x4d, 0x4e, 0xc3, 0x30,
	0x10, 0x85, 0x09, 0xe5, 0xaf, 0xc3, 0xce, 0x20, 0x54, 0x05, 0x15, 0x50, 0x40, 0xc0, 0xa6, 0xb1,
	0x4a, 0x25, 0xd6, 0x2c, 0x90, 0x58, 0x81, 0x50, 0x7b, 0x00, 0x64, 0x87, 0x51, 0x63, 0x35, 0xce,
	0x18, 0xdb, 0x69, 0xe1, 0x1e, 0x9c, 0x8d, 0xf3, 0xa0, 0x26, 0x69, 0x57, 0x69, 0x90, 0x58, 0xbe,
	0xf9, 0x46, 0xf3, 0x9e, 0x9f, 0x0c, 0x8f, 0x53, 0xe5, 0xd3, 0x42, 0xc6, 0x09, 0x69, 0x3e, 0x2b,
	0x24, 0xda, 0x1c, 0x3d, 0xba, 0x41, 0xe2, 0x14, 0x4f, 0x9c, 0x1a, 0x18, 0x4b, 0x9f, 0x5f, 0x3c,
	0xc9, 0x14, 0xe6, 0x9e, 0x0b, 0xa3, 0xb8, 0xd3, 0x92, 0xcf, 0x87, 0x12, 0xbd, 0x18, 0x2e, 0x75,
	0x6c, 0x2c, 0x79, 0x62, 0xfb, 0xf5, 0x28, 0xfa, 0x0e, 0x20, 0x7c, 0xc1, 0xc5, 0x44, 0xcb, 0xa7,
	0x8c, 0xa4, 0xc8, 0x9e, 0x85, 0x31, 0x2a, 0x9f, 0x8e, 0xf1, 0xa3, 0x40, 0xe7, 0xd9, 0x39, 0x1c,
	0x5a, 0xd4, 0xe4, 0xf1, 0xcd, 0x08, 0x9f, 0xf6, 0x82, 0x8b, 0xe0, 0xb6, 0x3b, 0x86, 0x6a, 0xf4,
	0x2a, 0x7c, 0xca, 0xfa, 0x00, 0x19, 0x25, 0x22, 0xab, 0xf8, 0x76, 0xc9, 0xbb, 0xe5, 0xa4, 0xc4,
	0x21, 0x1c, 0x14, 0x0e, 0x6d, 0x2e, 0x34, 0xf6, 0x3a, 0x25, 0x5c, 0xeb, 0x25, 0x33, 0xc2, 0xb9,
	0x05, 0xd9, 0xf7, 0xde, 0x4e, 0xc5, 0x56, 0x3a, 0x1a, 0xc1, 0x69, 0x63, 0x2a, 0x67, 0x28, 0x77,
	0xc8, 0x8e, 0x61, 0x17, 0xad, 0x25, 0x5b, 0x07, 0xaa, 0x44, 0xf4, 0x00, 0xfd, 0x31, 0x6a, 0x9a,
	0xe3, 0x7f, 0x5f, 0x13, 0xdd, 0xc3, 0xd9, 0xa6, 0x0b, 0x6d, 0xce, 0x77, 0x3f, 0x01, 0x74, 0x26,
	0x5a, 0x32, 0x09, 0x47, 0x0d, 0xb1, 0xd9, 0x65, 0x5c, 0xd7, 0x1d, 0x6f, 0xae, 0x3a, 0xbc, 0x6a,
	0x5f, 0xaa, 0xfc, 0xa3, 0x2d, 0x36, 0x83, 0x93, 0xe6, 0x8c, 0xec, 0x7a, 0x7d, 0xa1, 0xb5, 0x86,
	0xf0, 0xe6, 0xcf, 0xbd, 0x95, 0x99, 0xdc, 0x2b, 0xbf, 0xcb, 0xe8, 0x37, 0x00, 0x00, 0xff, 0xff,
	0xbe, 0xd0, 0x14, 0x1b, 0x76, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SmbClient is the client API for Smb service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SmbClient interface {
	// NewSmbGlobalMapping creates an SMB mapping on the SMB client to an SMB share.
	NewSmbGlobalMapping(ctx context.Context, in *NewSmbGlobalMappingRequest, opts ...grpc.CallOption) (*NewSmbGlobalMappingResponse, error)
	// RemoveSmbGlobalMapping removes the SMB mapping to an SMB share.
	RemoveSmbGlobalMapping(ctx context.Context, in *RemoveSmbGlobalMappingRequest, opts ...grpc.CallOption) (*RemoveSmbGlobalMappingResponse, error)
}

type smbClient struct {
	cc *grpc.ClientConn
}

func NewSmbClient(cc *grpc.ClientConn) SmbClient {
	return &smbClient{cc}
}

func (c *smbClient) NewSmbGlobalMapping(ctx context.Context, in *NewSmbGlobalMappingRequest, opts ...grpc.CallOption) (*NewSmbGlobalMappingResponse, error) {
	out := new(NewSmbGlobalMappingResponse)
	err := c.cc.Invoke(ctx, "/v1beta1.Smb/NewSmbGlobalMapping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *smbClient) RemoveSmbGlobalMapping(ctx context.Context, in *RemoveSmbGlobalMappingRequest, opts ...grpc.CallOption) (*RemoveSmbGlobalMappingResponse, error) {
	out := new(RemoveSmbGlobalMappingResponse)
	err := c.cc.Invoke(ctx, "/v1beta1.Smb/RemoveSmbGlobalMapping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SmbServer is the server API for Smb service.
type SmbServer interface {
	// NewSmbGlobalMapping creates an SMB mapping on the SMB client to an SMB share.
	NewSmbGlobalMapping(context.Context, *NewSmbGlobalMappingRequest) (*NewSmbGlobalMappingResponse, error)
	// RemoveSmbGlobalMapping removes the SMB mapping to an SMB share.
	RemoveSmbGlobalMapping(context.Context, *RemoveSmbGlobalMappingRequest) (*RemoveSmbGlobalMappingResponse, error)
}

// UnimplementedSmbServer can be embedded to have forward compatible implementations.
type UnimplementedSmbServer struct {
}

func (*UnimplementedSmbServer) NewSmbGlobalMapping(ctx context.Context, req *NewSmbGlobalMappingRequest) (*NewSmbGlobalMappingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NewSmbGlobalMapping not implemented")
}
func (*UnimplementedSmbServer) RemoveSmbGlobalMapping(ctx context.Context, req *RemoveSmbGlobalMappingRequest) (*RemoveSmbGlobalMappingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveSmbGlobalMapping not implemented")
}

func RegisterSmbServer(s *grpc.Server, srv SmbServer) {
	s.RegisterService(&_Smb_serviceDesc, srv)
}

func _Smb_NewSmbGlobalMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NewSmbGlobalMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmbServer).NewSmbGlobalMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1beta1.Smb/NewSmbGlobalMapping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmbServer).NewSmbGlobalMapping(ctx, req.(*NewSmbGlobalMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Smb_RemoveSmbGlobalMapping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveSmbGlobalMappingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SmbServer).RemoveSmbGlobalMapping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1beta1.Smb/RemoveSmbGlobalMapping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SmbServer).RemoveSmbGlobalMapping(ctx, req.(*RemoveSmbGlobalMappingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Smb_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1beta1.Smb",
	HandlerType: (*SmbServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NewSmbGlobalMapping",
			Handler:    _Smb_NewSmbGlobalMapping_Handler,
		},
		{
			MethodName: "RemoveSmbGlobalMapping",
			Handler:    _Smb_RemoveSmbGlobalMapping_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "github.com/kubernetes-csi/csi-proxy/client/api/smb/v1beta1/api.proto",
}
