// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package billing

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/billing/mgmt/2020-05-01-preview/billing"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AcceptanceMode = original.AcceptanceMode

const (
	ClickToAccept AcceptanceMode = original.ClickToAccept
	ESignEmbedded AcceptanceMode = original.ESignEmbedded
	ESignOffline  AcceptanceMode = original.ESignOffline
)

type AccountStatus = original.AccountStatus

const (
	Active      AccountStatus = original.Active
	Deleted     AccountStatus = original.Deleted
	Disabled    AccountStatus = original.Disabled
	Expired     AccountStatus = original.Expired
	Extended    AccountStatus = original.Extended
	Terminated  AccountStatus = original.Terminated
	Transferred AccountStatus = original.Transferred
)

type AccountType = original.AccountType

const (
	Enterprise AccountType = original.Enterprise
	Individual AccountType = original.Individual
	Partner    AccountType = original.Partner
)

type AddressValidationStatus = original.AddressValidationStatus

const (
	Invalid AddressValidationStatus = original.Invalid
	Valid   AddressValidationStatus = original.Valid
)

type AgreementType = original.AgreementType

const (
	EnterpriseAgreement            AgreementType = original.EnterpriseAgreement
	MicrosoftCustomerAgreement     AgreementType = original.MicrosoftCustomerAgreement
	MicrosoftOnlineServicesProgram AgreementType = original.MicrosoftOnlineServicesProgram
	MicrosoftPartnerAgreement      AgreementType = original.MicrosoftPartnerAgreement
)

type AutoRenew = original.AutoRenew

const (
	Off AutoRenew = original.Off
	On  AutoRenew = original.On
)

type Category = original.Category

const (
	CategoryAffiliatePurchaseTerms     Category = original.CategoryAffiliatePurchaseTerms
	CategoryMicrosoftCustomerAgreement Category = original.CategoryMicrosoftCustomerAgreement
	CategoryOther                      Category = original.CategoryOther
)

type DocumentSource = original.DocumentSource

const (
	DRS DocumentSource = original.DRS
	ENF DocumentSource = original.ENF
)

type DocumentType = original.DocumentType

const (
	DocumentTypeCreditNote DocumentType = original.DocumentTypeCreditNote
	DocumentTypeInvoice    DocumentType = original.DocumentTypeInvoice
	DocumentTypeTaxReceipt DocumentType = original.DocumentTypeTaxReceipt
	DocumentTypeVoidNote   DocumentType = original.DocumentTypeVoidNote
)

type Frequency = original.Frequency

const (
	Monthly    Frequency = original.Monthly
	OneTime    Frequency = original.OneTime
	UsageBased Frequency = original.UsageBased
)

type InvoiceSectionState = original.InvoiceSectionState

const (
	InvoiceSectionStateActive     InvoiceSectionState = original.InvoiceSectionStateActive
	InvoiceSectionStateRestricted InvoiceSectionState = original.InvoiceSectionStateRestricted
)

type InvoiceStatus = original.InvoiceStatus

const (
	Due     InvoiceStatus = original.Due
	OverDue InvoiceStatus = original.OverDue
	Paid    InvoiceStatus = original.Paid
)

type InvoiceType = original.InvoiceType

const (
	AzureMarketplace InvoiceType = original.AzureMarketplace
	AzureService     InvoiceType = original.AzureService
	AzureSupport     InvoiceType = original.AzureSupport
)

type MarketplacePurchasesPolicy = original.MarketplacePurchasesPolicy

const (
	AllAllowed      MarketplacePurchasesPolicy = original.AllAllowed
	NotAllowed      MarketplacePurchasesPolicy = original.NotAllowed
	OnlyFreeAllowed MarketplacePurchasesPolicy = original.OnlyFreeAllowed
)

type PaymentMethodFamily = original.PaymentMethodFamily

const (
	CheckWire  PaymentMethodFamily = original.CheckWire
	CreditCard PaymentMethodFamily = original.CreditCard
	Credits    PaymentMethodFamily = original.Credits
	None       PaymentMethodFamily = original.None
)

type ProductStatusType = original.ProductStatusType

const (
	ProductStatusTypeActive    ProductStatusType = original.ProductStatusTypeActive
	ProductStatusTypeAutoRenew ProductStatusType = original.ProductStatusTypeAutoRenew
	ProductStatusTypeCancelled ProductStatusType = original.ProductStatusTypeCancelled
	ProductStatusTypeDisabled  ProductStatusType = original.ProductStatusTypeDisabled
	ProductStatusTypeExpired   ProductStatusType = original.ProductStatusTypeExpired
	ProductStatusTypeExpiring  ProductStatusType = original.ProductStatusTypeExpiring
	ProductStatusTypeInactive  ProductStatusType = original.ProductStatusTypeInactive
	ProductStatusTypePastDue   ProductStatusType = original.ProductStatusTypePastDue
)

type ProductTransferValidationErrorCode = original.ProductTransferValidationErrorCode

const (
	CrossBillingAccountNotAllowed            ProductTransferValidationErrorCode = original.CrossBillingAccountNotAllowed
	DestinationBillingProfilePastDue         ProductTransferValidationErrorCode = original.DestinationBillingProfilePastDue
	InsufficientPermissionOnDestination      ProductTransferValidationErrorCode = original.InsufficientPermissionOnDestination
	InsufficientPermissionOnSource           ProductTransferValidationErrorCode = original.InsufficientPermissionOnSource
	InvalidSource                            ProductTransferValidationErrorCode = original.InvalidSource
	NotAvailableForDestinationMarket         ProductTransferValidationErrorCode = original.NotAvailableForDestinationMarket
	OneTimePurchaseProductTransferNotAllowed ProductTransferValidationErrorCode = original.OneTimePurchaseProductTransferNotAllowed
	ProductNotActive                         ProductTransferValidationErrorCode = original.ProductNotActive
	ProductTypeNotSupported                  ProductTransferValidationErrorCode = original.ProductTypeNotSupported
)

type ProfileSpendingLimit = original.ProfileSpendingLimit

const (
	ProfileSpendingLimitOff ProfileSpendingLimit = original.ProfileSpendingLimitOff
	ProfileSpendingLimitOn  ProfileSpendingLimit = original.ProfileSpendingLimitOn
)

type ProfileStatus = original.ProfileStatus

const (
	ProfileStatusActive   ProfileStatus = original.ProfileStatusActive
	ProfileStatusDisabled ProfileStatus = original.ProfileStatusDisabled
	ProfileStatusWarned   ProfileStatus = original.ProfileStatusWarned
)

type ProfileStatusReasonCode = original.ProfileStatusReasonCode

const (
	PastDue              ProfileStatusReasonCode = original.PastDue
	SpendingLimitExpired ProfileStatusReasonCode = original.SpendingLimitExpired
	SpendingLimitReached ProfileStatusReasonCode = original.SpendingLimitReached
)

type RelationshipType = original.RelationshipType

const (
	CSPPartner       RelationshipType = original.CSPPartner
	Direct           RelationshipType = original.Direct
	IndirectCustomer RelationshipType = original.IndirectCustomer
	IndirectPartner  RelationshipType = original.IndirectPartner
)

type ReservationPurchasesPolicy = original.ReservationPurchasesPolicy

const (
	ReservationPurchasesPolicyAllowed    ReservationPurchasesPolicy = original.ReservationPurchasesPolicyAllowed
	ReservationPurchasesPolicyNotAllowed ReservationPurchasesPolicy = original.ReservationPurchasesPolicyNotAllowed
)

type ReservationType = original.ReservationType

const (
	Purchase    ReservationType = original.Purchase
	UsageCharge ReservationType = original.UsageCharge
)

type SpendingLimit = original.SpendingLimit

const (
	SpendingLimitOff SpendingLimit = original.SpendingLimitOff
	SpendingLimitOn  SpendingLimit = original.SpendingLimitOn
)

type SpendingLimitForBillingProfile = original.SpendingLimitForBillingProfile

const (
	SpendingLimitForBillingProfileOff SpendingLimitForBillingProfile = original.SpendingLimitForBillingProfileOff
	SpendingLimitForBillingProfileOn  SpendingLimitForBillingProfile = original.SpendingLimitForBillingProfileOn
)

type StatusReasonCode = original.StatusReasonCode

const (
	StatusReasonCodePastDue              StatusReasonCode = original.StatusReasonCodePastDue
	StatusReasonCodeSpendingLimitExpired StatusReasonCode = original.StatusReasonCodeSpendingLimitExpired
	StatusReasonCodeSpendingLimitReached StatusReasonCode = original.StatusReasonCodeSpendingLimitReached
)

type StatusReasonCodeForBillingProfile = original.StatusReasonCodeForBillingProfile

const (
	StatusReasonCodeForBillingProfilePastDue              StatusReasonCodeForBillingProfile = original.StatusReasonCodeForBillingProfilePastDue
	StatusReasonCodeForBillingProfileSpendingLimitExpired StatusReasonCodeForBillingProfile = original.StatusReasonCodeForBillingProfileSpendingLimitExpired
	StatusReasonCodeForBillingProfileSpendingLimitReached StatusReasonCodeForBillingProfile = original.StatusReasonCodeForBillingProfileSpendingLimitReached
)

type SubscriptionStatusType = original.SubscriptionStatusType

const (
	SubscriptionStatusTypeAbandoned SubscriptionStatusType = original.SubscriptionStatusTypeAbandoned
	SubscriptionStatusTypeActive    SubscriptionStatusType = original.SubscriptionStatusTypeActive
	SubscriptionStatusTypeDeleted   SubscriptionStatusType = original.SubscriptionStatusTypeDeleted
	SubscriptionStatusTypeInactive  SubscriptionStatusType = original.SubscriptionStatusTypeInactive
	SubscriptionStatusTypeWarning   SubscriptionStatusType = original.SubscriptionStatusTypeWarning
)

type SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCode

const (
	SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed       SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeCrossBillingAccountNotAllowed
	SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue    SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeDestinationBillingProfilePastDue
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeInsufficientPermissionOnDestination
	SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource      SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeInsufficientPermissionOnSource
	SubscriptionTransferValidationErrorCodeInvalidSource                       SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeInvalidSource
	SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket    SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeNotAvailableForDestinationMarket
	SubscriptionTransferValidationErrorCodeSubscriptionNotActive               SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeSubscriptionNotActive
	SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported        SubscriptionTransferValidationErrorCode = original.SubscriptionTransferValidationErrorCodeSubscriptionTypeNotSupported
)

type TargetCloud = original.TargetCloud

const (
	USGov TargetCloud = original.USGov
	USNat TargetCloud = original.USNat
	USSec TargetCloud = original.USSec
)

type TransactionTypeKind = original.TransactionTypeKind

const (
	All         TransactionTypeKind = original.All
	Reservation TransactionTypeKind = original.Reservation
)

type ViewCharges = original.ViewCharges

const (
	ViewChargesAllowed    ViewCharges = original.ViewChargesAllowed
	ViewChargesNotAllowed ViewCharges = original.ViewChargesNotAllowed
)

type ViewChargesPolicy = original.ViewChargesPolicy

const (
	ViewChargesPolicyAllowed    ViewChargesPolicy = original.ViewChargesPolicyAllowed
	ViewChargesPolicyNotAllowed ViewChargesPolicy = original.ViewChargesPolicyNotAllowed
)

type Account = original.Account
type AccountListResult = original.AccountListResult
type AccountListResultIterator = original.AccountListResultIterator
type AccountListResultPage = original.AccountListResultPage
type AccountProperties = original.AccountProperties
type AccountUpdateRequest = original.AccountUpdateRequest
type AccountsClient = original.AccountsClient
type AccountsUpdateFuture = original.AccountsUpdateFuture
type AddressClient = original.AddressClient
type AddressDetails = original.AddressDetails
type Agreement = original.Agreement
type AgreementListResult = original.AgreementListResult
type AgreementListResultIterator = original.AgreementListResultIterator
type AgreementListResultPage = original.AgreementListResultPage
type AgreementProperties = original.AgreementProperties
type AgreementsClient = original.AgreementsClient
type Amount = original.Amount
type AvailableBalance = original.AvailableBalance
type AvailableBalanceProperties = original.AvailableBalanceProperties
type AvailableBalancesClient = original.AvailableBalancesClient
type AzurePlan = original.AzurePlan
type BaseClient = original.BaseClient
type Customer = original.Customer
type CustomerListResult = original.CustomerListResult
type CustomerListResultIterator = original.CustomerListResultIterator
type CustomerListResultPage = original.CustomerListResultPage
type CustomerPolicy = original.CustomerPolicy
type CustomerPolicyProperties = original.CustomerPolicyProperties
type CustomerProperties = original.CustomerProperties
type CustomersClient = original.CustomersClient
type Department = original.Department
type DepartmentProperties = original.DepartmentProperties
type Document = original.Document
type DownloadURL = original.DownloadURL
type Enrollment = original.Enrollment
type EnrollmentAccount = original.EnrollmentAccount
type EnrollmentAccountContext = original.EnrollmentAccountContext
type EnrollmentAccountListResult = original.EnrollmentAccountListResult
type EnrollmentAccountListResultIterator = original.EnrollmentAccountListResultIterator
type EnrollmentAccountListResultPage = original.EnrollmentAccountListResultPage
type EnrollmentAccountProperties = original.EnrollmentAccountProperties
type EnrollmentAccountSummary = original.EnrollmentAccountSummary
type EnrollmentAccountSummaryProperties = original.EnrollmentAccountSummaryProperties
type EnrollmentAccountsClient = original.EnrollmentAccountsClient
type EnrollmentPolicies = original.EnrollmentPolicies
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type IndirectRelationshipInfo = original.IndirectRelationshipInfo
type Instruction = original.Instruction
type InstructionListResult = original.InstructionListResult
type InstructionListResultIterator = original.InstructionListResultIterator
type InstructionListResultPage = original.InstructionListResultPage
type InstructionProperties = original.InstructionProperties
type InstructionsClient = original.InstructionsClient
type Invoice = original.Invoice
type InvoiceListResult = original.InvoiceListResult
type InvoiceListResultIterator = original.InvoiceListResultIterator
type InvoiceListResultPage = original.InvoiceListResultPage
type InvoiceProperties = original.InvoiceProperties
type InvoiceSection = original.InvoiceSection
type InvoiceSectionCreationRequest = original.InvoiceSectionCreationRequest
type InvoiceSectionListResult = original.InvoiceSectionListResult
type InvoiceSectionListResultIterator = original.InvoiceSectionListResultIterator
type InvoiceSectionListResultPage = original.InvoiceSectionListResultPage
type InvoiceSectionListWithCreateSubPermissionResult = original.InvoiceSectionListWithCreateSubPermissionResult
type InvoiceSectionListWithCreateSubPermissionResultIterator = original.InvoiceSectionListWithCreateSubPermissionResultIterator
type InvoiceSectionListWithCreateSubPermissionResultPage = original.InvoiceSectionListWithCreateSubPermissionResultPage
type InvoiceSectionProperties = original.InvoiceSectionProperties
type InvoiceSectionWithCreateSubPermission = original.InvoiceSectionWithCreateSubPermission
type InvoiceSectionsClient = original.InvoiceSectionsClient
type InvoiceSectionsCreateOrUpdateFuture = original.InvoiceSectionsCreateOrUpdateFuture
type InvoiceSectionsOnExpand = original.InvoiceSectionsOnExpand
type InvoicesClient = original.InvoicesClient
type InvoicesDownloadBillingSubscriptionInvoiceFuture = original.InvoicesDownloadBillingSubscriptionInvoiceFuture
type InvoicesDownloadInvoiceFuture = original.InvoicesDownloadInvoiceFuture
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type Participants = original.Participants
type PaymentProperties = original.PaymentProperties
type Period = original.Period
type PeriodProperties = original.PeriodProperties
type PeriodsClient = original.PeriodsClient
type PeriodsListResult = original.PeriodsListResult
type PeriodsListResultIterator = original.PeriodsListResultIterator
type PeriodsListResultPage = original.PeriodsListResultPage
type PermissionsClient = original.PermissionsClient
type PermissionsListResult = original.PermissionsListResult
type PermissionsListResultIterator = original.PermissionsListResultIterator
type PermissionsListResultPage = original.PermissionsListResultPage
type PermissionsProperties = original.PermissionsProperties
type PoliciesClient = original.PoliciesClient
type Policy = original.Policy
type PolicyProperties = original.PolicyProperties
type Product = original.Product
type ProductProperties = original.ProductProperties
type ProductsClient = original.ProductsClient
type ProductsListResult = original.ProductsListResult
type ProductsListResultIterator = original.ProductsListResultIterator
type ProductsListResultPage = original.ProductsListResultPage
type Profile = original.Profile
type ProfileCreationRequest = original.ProfileCreationRequest
type ProfileListResult = original.ProfileListResult
type ProfileListResultIterator = original.ProfileListResultIterator
type ProfileListResultPage = original.ProfileListResultPage
type ProfileProperties = original.ProfileProperties
type ProfilesClient = original.ProfilesClient
type ProfilesCreateOrUpdateFuture = original.ProfilesCreateOrUpdateFuture
type ProfilesOnExpand = original.ProfilesOnExpand
type Property = original.Property
type PropertyClient = original.PropertyClient
type PropertyProperties = original.PropertyProperties
type Reseller = original.Reseller
type Resource = original.Resource
type RoleAssignment = original.RoleAssignment
type RoleAssignmentListResult = original.RoleAssignmentListResult
type RoleAssignmentListResultIterator = original.RoleAssignmentListResultIterator
type RoleAssignmentListResultPage = original.RoleAssignmentListResultPage
type RoleAssignmentProperties = original.RoleAssignmentProperties
type RoleAssignmentsClient = original.RoleAssignmentsClient
type RoleDefinition = original.RoleDefinition
type RoleDefinitionListResult = original.RoleDefinitionListResult
type RoleDefinitionListResultIterator = original.RoleDefinitionListResultIterator
type RoleDefinitionListResultPage = original.RoleDefinitionListResultPage
type RoleDefinitionProperties = original.RoleDefinitionProperties
type RoleDefinitionsClient = original.RoleDefinitionsClient
type Subscription = original.Subscription
type SubscriptionProperties = original.SubscriptionProperties
type SubscriptionsClient = original.SubscriptionsClient
type SubscriptionsListResult = original.SubscriptionsListResult
type SubscriptionsListResultIterator = original.SubscriptionsListResultIterator
type SubscriptionsListResultPage = original.SubscriptionsListResultPage
type SubscriptionsMoveFuture = original.SubscriptionsMoveFuture
type Transaction = original.Transaction
type TransactionListResult = original.TransactionListResult
type TransactionListResultIterator = original.TransactionListResultIterator
type TransactionListResultPage = original.TransactionListResultPage
type TransactionProperties = original.TransactionProperties
type TransactionsClient = original.TransactionsClient
type TransferBillingSubscriptionRequestProperties = original.TransferBillingSubscriptionRequestProperties
type TransferProductRequestProperties = original.TransferProductRequestProperties
type ValidateAddressResponse = original.ValidateAddressResponse
type ValidateProductTransferEligibilityError = original.ValidateProductTransferEligibilityError
type ValidateProductTransferEligibilityResult = original.ValidateProductTransferEligibilityResult
type ValidateSubscriptionTransferEligibilityError = original.ValidateSubscriptionTransferEligibilityError
type ValidateSubscriptionTransferEligibilityResult = original.ValidateSubscriptionTransferEligibilityResult

func New(subscriptionID string, subscriptionID1 string) BaseClient {
	return original.New(subscriptionID, subscriptionID1)
}
func NewAccountListResultIterator(page AccountListResultPage) AccountListResultIterator {
	return original.NewAccountListResultIterator(page)
}
func NewAccountListResultPage(getNextPage func(context.Context, AccountListResult) (AccountListResult, error)) AccountListResultPage {
	return original.NewAccountListResultPage(getNextPage)
}
func NewAccountsClient(subscriptionID string, subscriptionID1 string) AccountsClient {
	return original.NewAccountsClient(subscriptionID, subscriptionID1)
}
func NewAccountsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) AccountsClient {
	return original.NewAccountsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewAddressClient(subscriptionID string, subscriptionID1 string) AddressClient {
	return original.NewAddressClient(subscriptionID, subscriptionID1)
}
func NewAddressClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) AddressClient {
	return original.NewAddressClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewAgreementListResultIterator(page AgreementListResultPage) AgreementListResultIterator {
	return original.NewAgreementListResultIterator(page)
}
func NewAgreementListResultPage(getNextPage func(context.Context, AgreementListResult) (AgreementListResult, error)) AgreementListResultPage {
	return original.NewAgreementListResultPage(getNextPage)
}
func NewAgreementsClient(subscriptionID string, subscriptionID1 string) AgreementsClient {
	return original.NewAgreementsClient(subscriptionID, subscriptionID1)
}
func NewAgreementsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) AgreementsClient {
	return original.NewAgreementsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewAvailableBalancesClient(subscriptionID string, subscriptionID1 string) AvailableBalancesClient {
	return original.NewAvailableBalancesClient(subscriptionID, subscriptionID1)
}
func NewAvailableBalancesClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) AvailableBalancesClient {
	return original.NewAvailableBalancesClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewCustomerListResultIterator(page CustomerListResultPage) CustomerListResultIterator {
	return original.NewCustomerListResultIterator(page)
}
func NewCustomerListResultPage(getNextPage func(context.Context, CustomerListResult) (CustomerListResult, error)) CustomerListResultPage {
	return original.NewCustomerListResultPage(getNextPage)
}
func NewCustomersClient(subscriptionID string, subscriptionID1 string) CustomersClient {
	return original.NewCustomersClient(subscriptionID, subscriptionID1)
}
func NewCustomersClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) CustomersClient {
	return original.NewCustomersClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewEnrollmentAccountListResultIterator(page EnrollmentAccountListResultPage) EnrollmentAccountListResultIterator {
	return original.NewEnrollmentAccountListResultIterator(page)
}
func NewEnrollmentAccountListResultPage(getNextPage func(context.Context, EnrollmentAccountListResult) (EnrollmentAccountListResult, error)) EnrollmentAccountListResultPage {
	return original.NewEnrollmentAccountListResultPage(getNextPage)
}
func NewEnrollmentAccountsClient(subscriptionID string, subscriptionID1 string) EnrollmentAccountsClient {
	return original.NewEnrollmentAccountsClient(subscriptionID, subscriptionID1)
}
func NewEnrollmentAccountsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) EnrollmentAccountsClient {
	return original.NewEnrollmentAccountsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewInstructionListResultIterator(page InstructionListResultPage) InstructionListResultIterator {
	return original.NewInstructionListResultIterator(page)
}
func NewInstructionListResultPage(getNextPage func(context.Context, InstructionListResult) (InstructionListResult, error)) InstructionListResultPage {
	return original.NewInstructionListResultPage(getNextPage)
}
func NewInstructionsClient(subscriptionID string, subscriptionID1 string) InstructionsClient {
	return original.NewInstructionsClient(subscriptionID, subscriptionID1)
}
func NewInstructionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) InstructionsClient {
	return original.NewInstructionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewInvoiceListResultIterator(page InvoiceListResultPage) InvoiceListResultIterator {
	return original.NewInvoiceListResultIterator(page)
}
func NewInvoiceListResultPage(getNextPage func(context.Context, InvoiceListResult) (InvoiceListResult, error)) InvoiceListResultPage {
	return original.NewInvoiceListResultPage(getNextPage)
}
func NewInvoiceSectionListResultIterator(page InvoiceSectionListResultPage) InvoiceSectionListResultIterator {
	return original.NewInvoiceSectionListResultIterator(page)
}
func NewInvoiceSectionListResultPage(getNextPage func(context.Context, InvoiceSectionListResult) (InvoiceSectionListResult, error)) InvoiceSectionListResultPage {
	return original.NewInvoiceSectionListResultPage(getNextPage)
}
func NewInvoiceSectionListWithCreateSubPermissionResultIterator(page InvoiceSectionListWithCreateSubPermissionResultPage) InvoiceSectionListWithCreateSubPermissionResultIterator {
	return original.NewInvoiceSectionListWithCreateSubPermissionResultIterator(page)
}
func NewInvoiceSectionListWithCreateSubPermissionResultPage(getNextPage func(context.Context, InvoiceSectionListWithCreateSubPermissionResult) (InvoiceSectionListWithCreateSubPermissionResult, error)) InvoiceSectionListWithCreateSubPermissionResultPage {
	return original.NewInvoiceSectionListWithCreateSubPermissionResultPage(getNextPage)
}
func NewInvoiceSectionsClient(subscriptionID string, subscriptionID1 string) InvoiceSectionsClient {
	return original.NewInvoiceSectionsClient(subscriptionID, subscriptionID1)
}
func NewInvoiceSectionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) InvoiceSectionsClient {
	return original.NewInvoiceSectionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewInvoicesClient(subscriptionID string, subscriptionID1 string) InvoicesClient {
	return original.NewInvoicesClient(subscriptionID, subscriptionID1)
}
func NewInvoicesClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) InvoicesClient {
	return original.NewInvoicesClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOperationsClient(subscriptionID string, subscriptionID1 string) OperationsClient {
	return original.NewOperationsClient(subscriptionID, subscriptionID1)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewPeriodsClient(subscriptionID string, subscriptionID1 string) PeriodsClient {
	return original.NewPeriodsClient(subscriptionID, subscriptionID1)
}
func NewPeriodsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) PeriodsClient {
	return original.NewPeriodsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewPeriodsListResultIterator(page PeriodsListResultPage) PeriodsListResultIterator {
	return original.NewPeriodsListResultIterator(page)
}
func NewPeriodsListResultPage(getNextPage func(context.Context, PeriodsListResult) (PeriodsListResult, error)) PeriodsListResultPage {
	return original.NewPeriodsListResultPage(getNextPage)
}
func NewPermissionsClient(subscriptionID string, subscriptionID1 string) PermissionsClient {
	return original.NewPermissionsClient(subscriptionID, subscriptionID1)
}
func NewPermissionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) PermissionsClient {
	return original.NewPermissionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewPermissionsListResultIterator(page PermissionsListResultPage) PermissionsListResultIterator {
	return original.NewPermissionsListResultIterator(page)
}
func NewPermissionsListResultPage(getNextPage func(context.Context, PermissionsListResult) (PermissionsListResult, error)) PermissionsListResultPage {
	return original.NewPermissionsListResultPage(getNextPage)
}
func NewPoliciesClient(subscriptionID string, subscriptionID1 string) PoliciesClient {
	return original.NewPoliciesClient(subscriptionID, subscriptionID1)
}
func NewPoliciesClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) PoliciesClient {
	return original.NewPoliciesClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewProductsClient(subscriptionID string, subscriptionID1 string) ProductsClient {
	return original.NewProductsClient(subscriptionID, subscriptionID1)
}
func NewProductsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) ProductsClient {
	return original.NewProductsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewProductsListResultIterator(page ProductsListResultPage) ProductsListResultIterator {
	return original.NewProductsListResultIterator(page)
}
func NewProductsListResultPage(getNextPage func(context.Context, ProductsListResult) (ProductsListResult, error)) ProductsListResultPage {
	return original.NewProductsListResultPage(getNextPage)
}
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return original.NewProfileListResultIterator(page)
}
func NewProfileListResultPage(getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return original.NewProfileListResultPage(getNextPage)
}
func NewProfilesClient(subscriptionID string, subscriptionID1 string) ProfilesClient {
	return original.NewProfilesClient(subscriptionID, subscriptionID1)
}
func NewProfilesClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) ProfilesClient {
	return original.NewProfilesClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewPropertyClient(subscriptionID string, subscriptionID1 string) PropertyClient {
	return original.NewPropertyClient(subscriptionID, subscriptionID1)
}
func NewPropertyClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) PropertyClient {
	return original.NewPropertyClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewRoleAssignmentListResultIterator(page RoleAssignmentListResultPage) RoleAssignmentListResultIterator {
	return original.NewRoleAssignmentListResultIterator(page)
}
func NewRoleAssignmentListResultPage(getNextPage func(context.Context, RoleAssignmentListResult) (RoleAssignmentListResult, error)) RoleAssignmentListResultPage {
	return original.NewRoleAssignmentListResultPage(getNextPage)
}
func NewRoleAssignmentsClient(subscriptionID string, subscriptionID1 string) RoleAssignmentsClient {
	return original.NewRoleAssignmentsClient(subscriptionID, subscriptionID1)
}
func NewRoleAssignmentsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) RoleAssignmentsClient {
	return original.NewRoleAssignmentsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewRoleDefinitionListResultIterator(page RoleDefinitionListResultPage) RoleDefinitionListResultIterator {
	return original.NewRoleDefinitionListResultIterator(page)
}
func NewRoleDefinitionListResultPage(getNextPage func(context.Context, RoleDefinitionListResult) (RoleDefinitionListResult, error)) RoleDefinitionListResultPage {
	return original.NewRoleDefinitionListResultPage(getNextPage)
}
func NewRoleDefinitionsClient(subscriptionID string, subscriptionID1 string) RoleDefinitionsClient {
	return original.NewRoleDefinitionsClient(subscriptionID, subscriptionID1)
}
func NewRoleDefinitionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) RoleDefinitionsClient {
	return original.NewRoleDefinitionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewSubscriptionsClient(subscriptionID string, subscriptionID1 string) SubscriptionsClient {
	return original.NewSubscriptionsClient(subscriptionID, subscriptionID1)
}
func NewSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) SubscriptionsClient {
	return original.NewSubscriptionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewSubscriptionsListResultIterator(page SubscriptionsListResultPage) SubscriptionsListResultIterator {
	return original.NewSubscriptionsListResultIterator(page)
}
func NewSubscriptionsListResultPage(getNextPage func(context.Context, SubscriptionsListResult) (SubscriptionsListResult, error)) SubscriptionsListResultPage {
	return original.NewSubscriptionsListResultPage(getNextPage)
}
func NewTransactionListResultIterator(page TransactionListResultPage) TransactionListResultIterator {
	return original.NewTransactionListResultIterator(page)
}
func NewTransactionListResultPage(getNextPage func(context.Context, TransactionListResult) (TransactionListResult, error)) TransactionListResultPage {
	return original.NewTransactionListResultPage(getNextPage)
}
func NewTransactionsClient(subscriptionID string, subscriptionID1 string) TransactionsClient {
	return original.NewTransactionsClient(subscriptionID, subscriptionID1)
}
func NewTransactionsClientWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) TransactionsClient {
	return original.NewTransactionsClientWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func NewWithBaseURI(baseURI string, subscriptionID string, subscriptionID1 string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID, subscriptionID1)
}
func PossibleAcceptanceModeValues() []AcceptanceMode {
	return original.PossibleAcceptanceModeValues()
}
func PossibleAccountStatusValues() []AccountStatus {
	return original.PossibleAccountStatusValues()
}
func PossibleAccountTypeValues() []AccountType {
	return original.PossibleAccountTypeValues()
}
func PossibleAddressValidationStatusValues() []AddressValidationStatus {
	return original.PossibleAddressValidationStatusValues()
}
func PossibleAgreementTypeValues() []AgreementType {
	return original.PossibleAgreementTypeValues()
}
func PossibleAutoRenewValues() []AutoRenew {
	return original.PossibleAutoRenewValues()
}
func PossibleCategoryValues() []Category {
	return original.PossibleCategoryValues()
}
func PossibleDocumentSourceValues() []DocumentSource {
	return original.PossibleDocumentSourceValues()
}
func PossibleDocumentTypeValues() []DocumentType {
	return original.PossibleDocumentTypeValues()
}
func PossibleFrequencyValues() []Frequency {
	return original.PossibleFrequencyValues()
}
func PossibleInvoiceSectionStateValues() []InvoiceSectionState {
	return original.PossibleInvoiceSectionStateValues()
}
func PossibleInvoiceStatusValues() []InvoiceStatus {
	return original.PossibleInvoiceStatusValues()
}
func PossibleInvoiceTypeValues() []InvoiceType {
	return original.PossibleInvoiceTypeValues()
}
func PossibleMarketplacePurchasesPolicyValues() []MarketplacePurchasesPolicy {
	return original.PossibleMarketplacePurchasesPolicyValues()
}
func PossiblePaymentMethodFamilyValues() []PaymentMethodFamily {
	return original.PossiblePaymentMethodFamilyValues()
}
func PossibleProductStatusTypeValues() []ProductStatusType {
	return original.PossibleProductStatusTypeValues()
}
func PossibleProductTransferValidationErrorCodeValues() []ProductTransferValidationErrorCode {
	return original.PossibleProductTransferValidationErrorCodeValues()
}
func PossibleProfileSpendingLimitValues() []ProfileSpendingLimit {
	return original.PossibleProfileSpendingLimitValues()
}
func PossibleProfileStatusReasonCodeValues() []ProfileStatusReasonCode {
	return original.PossibleProfileStatusReasonCodeValues()
}
func PossibleProfileStatusValues() []ProfileStatus {
	return original.PossibleProfileStatusValues()
}
func PossibleRelationshipTypeValues() []RelationshipType {
	return original.PossibleRelationshipTypeValues()
}
func PossibleReservationPurchasesPolicyValues() []ReservationPurchasesPolicy {
	return original.PossibleReservationPurchasesPolicyValues()
}
func PossibleReservationTypeValues() []ReservationType {
	return original.PossibleReservationTypeValues()
}
func PossibleSpendingLimitForBillingProfileValues() []SpendingLimitForBillingProfile {
	return original.PossibleSpendingLimitForBillingProfileValues()
}
func PossibleSpendingLimitValues() []SpendingLimit {
	return original.PossibleSpendingLimitValues()
}
func PossibleStatusReasonCodeForBillingProfileValues() []StatusReasonCodeForBillingProfile {
	return original.PossibleStatusReasonCodeForBillingProfileValues()
}
func PossibleStatusReasonCodeValues() []StatusReasonCode {
	return original.PossibleStatusReasonCodeValues()
}
func PossibleSubscriptionStatusTypeValues() []SubscriptionStatusType {
	return original.PossibleSubscriptionStatusTypeValues()
}
func PossibleSubscriptionTransferValidationErrorCodeValues() []SubscriptionTransferValidationErrorCode {
	return original.PossibleSubscriptionTransferValidationErrorCodeValues()
}
func PossibleTargetCloudValues() []TargetCloud {
	return original.PossibleTargetCloudValues()
}
func PossibleTransactionTypeKindValues() []TransactionTypeKind {
	return original.PossibleTransactionTypeKindValues()
}
func PossibleViewChargesPolicyValues() []ViewChargesPolicy {
	return original.PossibleViewChargesPolicyValues()
}
func PossibleViewChargesValues() []ViewCharges {
	return original.PossibleViewChargesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
