---
title: "v0.7.0"
linkTitle: "v0.7.0"
date: 2021-01-06
description: >
  Cloud Provider Azure v0.7.0
---

## Major changes since v0.6.0

Cloud Provider Azure v0.7.0 updates Kubernetes vendor to v1.20 and moves to **beta**. The images are available at

- `mcr.microsoft.com/oss/kubernetes/azure-cloud-node-manager:v0.7.0`
- `mcr.microsoft.com/oss/kubernetes/azure-cloud-controller-manager:v0.7.0`

## Enhancements

- Features inherited from in-tree Azure cloud provider
  - Multiple standard load balancers in the same cluster.
  - Multiple load balancer typed services sharing one IP address.
  - Customized load balancer health probe.
  - Tagging resources managed by provider azure.
- Code improvements inherited from in-tree Azure cloud provider
  - Add metrics for cloud provider operations like “EnsureLoadBalancer”.
  - Improve the unit/E2E test coverage in provider azure.
- Upgrade Azure compute API version to 2020-06-30: ([#444](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/444), [@andyzhangx](https://github.com/andyzhangx))
- Use batch operation for azure disk attach/detach: ([#453](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/453), [@andyzhangx](https://github.com/andyzhangx))


## Bug Fixes

- Fix nil VMSS name when setting service to auto mode ([#439](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/439), [@nilo19](https://github.com/nilo19))
- Fix readyz probe ([#394](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/394), [@nilo19](https://github.com/nilo19))
- Ignore in-cluster config when `--master` or `--kubeconfig` is set explicitly ([#397](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/397), [@nilo19](https://github.com/nilo19))
- Support change the LB selection mode on the existing services ([#445](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/445), [@nilo19](https://github.com/nilo19))
- Use network.Interface.VirtualMachine.ID to get the VM ([#443](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/443), [@nilo19](https://github.com/nilo19))
- Skip the exclude LB test on multi node pool cluster ([#455](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/455), [@nilo19](https://github.com/nilo19))

## Cleanups

- Duplicate the in-tree cloud provider code to the out-of-tree repo ([#433](https://github.com/kubernetes-sigs/cloud-provider-azure/pull/433), [@nilo19](https://github.com/nilo19))

## Dependencies

### Added

- cloud.google.com/go/bigquery: v1.4.0
- cloud.google.com/go/datastore: v1.1.0
- cloud.google.com/go/firestore: v1.1.0
- cloud.google.com/go/pubsub: v1.2.0
- cloud.google.com/go/storage: v1.6.0
- dmitri.shuralyov.com/gpu/mtl: 666a987
- github.com/armon/go-metrics: [f0300d1](https://github.com/armon/go-metrics/tree/f0300d1)
- github.com/armon/go-radix: [7fddfc3](https://github.com/armon/go-radix/tree/7fddfc3)
- github.com/bketelsen/crypt: [5cbc8cc](https://github.com/bketelsen/crypt/tree/5cbc8cc)
- github.com/checkpoint-restore/go-criu/v4: [v4.1.0](https://github.com/checkpoint-restore/go-criu/v4/tree/v4.1.0)
- github.com/chzyer/logex: [v1.1.10](https://github.com/chzyer/logex/tree/v1.1.10)
- github.com/chzyer/readline: [2972be2](https://github.com/chzyer/readline/tree/2972be2)
- github.com/chzyer/test: [a1ea475](https://github.com/chzyer/test/tree/a1ea475)
- github.com/cilium/ebpf: [1c8d4c9](https://github.com/cilium/ebpf/tree/1c8d4c9)
- github.com/containerd/cgroups: [0dbf7f0](https://github.com/containerd/cgroups/tree/0dbf7f0)
- github.com/containerd/console: [v1.0.0](https://github.com/containerd/console/tree/v1.0.0)
- github.com/containerd/containerd: [v1.4.1](https://github.com/containerd/containerd/tree/v1.4.1)
- github.com/containerd/continuity: [aaeac12](https://github.com/containerd/continuity/tree/aaeac12)
- github.com/containerd/fifo: [a9fb20d](https://github.com/containerd/fifo/tree/a9fb20d)
- github.com/containerd/go-runc: [5a6d9f3](https://github.com/containerd/go-runc/tree/5a6d9f3)
- github.com/containerd/ttrpc: [v1.0.2](https://github.com/containerd/ttrpc/tree/v1.0.2)
- github.com/containerd/typeurl: [v1.0.1](https://github.com/containerd/typeurl/tree/v1.0.1)
- github.com/coreos/bbolt: [v1.3.2](https://github.com/coreos/bbolt/tree/v1.3.2)
- github.com/coreos/go-systemd/v22: [v22.1.0](https://github.com/coreos/go-systemd/v22/tree/v22.1.0)
- github.com/cyphar/filepath-securejoin: [v0.2.2](https://github.com/cyphar/filepath-securejoin/tree/v0.2.2)
- github.com/euank/go-kmsg-parser: [v2.0.0+incompatible](https://github.com/euank/go-kmsg-parser/tree/v2.0.0)
- github.com/fvbommel/sortorder: [v1.0.1](https://github.com/fvbommel/sortorder/tree/v1.0.1)
- github.com/globalsign/mgo: [eeefdec](https://github.com/globalsign/mgo/tree/eeefdec)
- github.com/go-gl/glfw/v3.3/glfw: [6f7a984](https://github.com/go-gl/glfw/v3.3/glfw/tree/6f7a984)
- github.com/go-gl/glfw: [e6da0ac](https://github.com/go-gl/glfw/tree/e6da0ac)
- github.com/godbus/dbus/v5: [v5.0.3](https://github.com/godbus/dbus/v5/tree/v5.0.3)
- github.com/gopherjs/gopherjs: [0766667](https://github.com/gopherjs/gopherjs/tree/0766667)
- github.com/gorilla/mux: [v1.8.0](https://github.com/gorilla/mux/tree/v1.8.0)
- github.com/hashicorp/consul/api: [v1.1.0](https://github.com/hashicorp/consul/api/tree/v1.1.0)
- github.com/hashicorp/consul/sdk: [v0.1.1](https://github.com/hashicorp/consul/sdk/tree/v0.1.1)
- github.com/hashicorp/errwrap: [v1.0.0](https://github.com/hashicorp/errwrap/tree/v1.0.0)
- github.com/hashicorp/go-cleanhttp: [v0.5.1](https://github.com/hashicorp/go-cleanhttp/tree/v0.5.1)
- github.com/hashicorp/go-immutable-radix: [v1.0.0](https://github.com/hashicorp/go-immutable-radix/tree/v1.0.0)
- github.com/hashicorp/go-msgpack: [v0.5.3](https://github.com/hashicorp/go-msgpack/tree/v0.5.3)
- github.com/hashicorp/go-multierror: [v1.0.0](https://github.com/hashicorp/go-multierror/tree/v1.0.0)
- github.com/hashicorp/go-rootcerts: [v1.0.0](https://github.com/hashicorp/go-rootcerts/tree/v1.0.0)
- github.com/hashicorp/go-sockaddr: [v1.0.0](https://github.com/hashicorp/go-sockaddr/tree/v1.0.0)
- github.com/hashicorp/go-uuid: [v1.0.1](https://github.com/hashicorp/go-uuid/tree/v1.0.1)
- github.com/hashicorp/go.net: [v0.0.1](https://github.com/hashicorp/go.net/tree/v0.0.1)
- github.com/hashicorp/logutils: [v1.0.0](https://github.com/hashicorp/logutils/tree/v1.0.0)
- github.com/hashicorp/mdns: [v1.0.0](https://github.com/hashicorp/mdns/tree/v1.0.0)
- github.com/hashicorp/memberlist: [v0.1.3](https://github.com/hashicorp/memberlist/tree/v0.1.3)
- github.com/hashicorp/serf: [v0.8.2](https://github.com/hashicorp/serf/tree/v0.8.2)
- github.com/ianlancetaylor/demangle: [5e5cf60](https://github.com/ianlancetaylor/demangle/tree/5e5cf60)
- github.com/jmespath/go-jmespath/internal/testify: [v1.5.1](https://github.com/jmespath/go-jmespath/internal/testify/tree/v1.5.1)
- github.com/jtolds/gls: [v4.20.0+incompatible](https://github.com/jtolds/gls/tree/v4.20.0)
- github.com/karrick/godirwalk: [v1.16.1](https://github.com/karrick/godirwalk/tree/v1.16.1)
- github.com/kr/logfmt: [b84e30a](https://github.com/kr/logfmt/tree/b84e30a)
- github.com/mindprince/gonvml: [9ebdce4](https://github.com/mindprince/gonvml/tree/9ebdce4)
- github.com/mistifyio/go-zfs: [f784269](https://github.com/mistifyio/go-zfs/tree/f784269)
- github.com/mitchellh/cli: [v1.0.0](https://github.com/mitchellh/cli/tree/v1.0.0)
- github.com/mitchellh/go-testing-interface: [v1.0.0](https://github.com/mitchellh/go-testing-interface/tree/v1.0.0)
- github.com/mitchellh/gox: [v0.4.0](https://github.com/mitchellh/gox/tree/v0.4.0)
- github.com/mitchellh/iochan: [v1.0.0](https://github.com/mitchellh/iochan/tree/v1.0.0)
- github.com/moby/sys/mountinfo: [v0.1.3](https://github.com/moby/sys/mountinfo/tree/v0.1.3)
- github.com/modocache/gover: [b58185e](https://github.com/modocache/gover/tree/b58185e)
- github.com/morikuni/aec: [v1.0.0](https://github.com/morikuni/aec/tree/v1.0.0)
- github.com/niemeyer/pretty: [a10e7ca](https://github.com/niemeyer/pretty/tree/a10e7ca)
- github.com/opencontainers/image-spec: [v1.0.1](https://github.com/opencontainers/image-spec/tree/v1.0.1)
- github.com/opencontainers/runtime-spec: [4d89ac9](https://github.com/opencontainers/runtime-spec/tree/4d89ac9)
- github.com/pascaldekloe/goe: [57f6aae](https://github.com/pascaldekloe/goe/tree/57f6aae)
- github.com/pborman/uuid: [v1.2.0](https://github.com/pborman/uuid/tree/v1.2.0)
- github.com/posener/complete: [v1.1.1](https://github.com/posener/complete/tree/v1.1.1)
- github.com/ryanuber/columnize: [9b3edd6](https://github.com/ryanuber/columnize/tree/9b3edd6)
- github.com/sean-/seed: [e2103e2](https://github.com/sean-/seed/tree/e2103e2)
- github.com/seccomp/libseccomp-golang: [v0.9.1](https://github.com/seccomp/libseccomp-golang/tree/v0.9.1)
- github.com/smartystreets/assertions: [b2de0cb](https://github.com/smartystreets/assertions/tree/b2de0cb)
- github.com/smartystreets/goconvey: [v1.6.4](https://github.com/smartystreets/goconvey/tree/v1.6.4)
- github.com/subosito/gotenv: [v1.2.0](https://github.com/subosito/gotenv/tree/v1.2.0)
- github.com/syndtr/gocapability: [d983527](https://github.com/syndtr/gocapability/tree/d983527)
- github.com/willf/bitset: [d5bec33](https://github.com/willf/bitset/tree/d5bec33)
- github.com/yuin/goldmark: [v1.1.27](https://github.com/yuin/goldmark/tree/v1.1.27)
- golang.org/x/term: 7de9c90
- gopkg.in/ini.v1: v1.51.0
- k8s.io/api: fcac651
- k8s.io/apiextensions-apiserver: a7ee1ef
- k8s.io/apimachinery: 15c5dba
- k8s.io/apiserver: aed7ab0
- k8s.io/cli-runtime: 2e4b259
- k8s.io/client-go: e24efdc
- k8s.io/cluster-bootstrap: 614b98e
- k8s.io/code-generator: v0.21.0-alpha.0
- k8s.io/component-base: 1e84b32
- k8s.io/component-helpers: 7cb42b6
- k8s.io/controller-manager: b2c380a
- k8s.io/cri-api: v0.21.0-alpha.0
- k8s.io/csi-translation-lib: 8333033
- k8s.io/kube-aggregator: 6c47de4
- k8s.io/kube-controller-manager: 18c28a4
- k8s.io/kube-proxy: deb12d4
- k8s.io/kube-scheduler: 0f62d39
- k8s.io/kubectl: 5cfbd40
- k8s.io/kubelet: 92ded5e
- k8s.io/legacy-cloud-providers: 716c3da
- k8s.io/metrics: d70c0e0
- k8s.io/mount-utils: v0.21.0-alpha.0
- k8s.io/sample-apiserver: 1f4e6a9
- rsc.io/binaryregexp: v0.2.0

### Updated

- cloud.google.com/go: v0.38.0 → v0.54.0
- github.com/Azure/azure-sdk-for-go: [8277be3 → v49.1.0+incompatible](https://github.com/Azure/azure-sdk-for-go/compare/8277be3...v49.1.0)
- github.com/GoogleCloudPlatform/k8s-cloud-provider: [27a4ced → 7901bc8](https://github.com/GoogleCloudPlatform/k8s-cloud-provider/compare/27a4ced...7901bc8)
- github.com/Microsoft/go-winio: [v0.4.14 → v0.4.15](https://github.com/Microsoft/go-winio/compare/v0.4.14...v0.4.15)
- github.com/Microsoft/hcsshim: [672e52e → 5eafd15](https://github.com/Microsoft/hcsshim/compare/672e52e...5eafd15)
- github.com/alecthomas/template: [a0175ee → fb15b89](https://github.com/alecthomas/template/compare/a0175ee...fb15b89)
- github.com/alecthomas/units: [2efee85 → c3de453](https://github.com/alecthomas/units/compare/2efee85...c3de453)
- github.com/aws/aws-sdk-go: [v1.28.2 → v1.35.24](https://github.com/aws/aws-sdk-go/compare/v1.28.2...v1.35.24)
- github.com/containernetworking/cni: [v0.7.1 → v0.8.0](https://github.com/containernetworking/cni/compare/v0.7.1...v0.8.0)
- github.com/coredns/corefile-migration: [v1.0.6 → v1.0.10](https://github.com/coredns/corefile-migration/compare/v1.0.6...v1.0.10)
- github.com/coreos/etcd: [v3.3.10+incompatible → v3.3.13+incompatible](https://github.com/coreos/etcd/compare/v3.3.10...v3.3.13)
- github.com/creack/pty: [v1.1.7 → v1.1.9](https://github.com/creack/pty/compare/v1.1.7...v1.1.9)
- github.com/dnaeon/go-vcr: [v1.0.1 → v1.1.0](https://github.com/dnaeon/go-vcr/compare/v1.0.1...v1.1.0)
- github.com/docker/docker: [be7ac8b → bd33bbf](https://github.com/docker/docker/compare/be7ac8b...bd33bbf)
- github.com/docker/go-connections: [v0.3.0 → v0.4.0](https://github.com/docker/go-connections/compare/v0.3.0...v0.4.0)
- github.com/fsnotify/fsnotify: [v1.4.7 → v1.4.9](https://github.com/fsnotify/fsnotify/compare/v1.4.7...v1.4.9)
- github.com/go-kit/kit: [v0.8.0 → v0.9.0](https://github.com/go-kit/kit/compare/v0.8.0...v0.9.0)
- github.com/go-logfmt/logfmt: [v0.3.0 → v0.4.0](https://github.com/go-logfmt/logfmt/compare/v0.3.0...v0.4.0)
- github.com/google/cadvisor: [v0.35.0 → v0.38.5](https://github.com/google/cadvisor/compare/v0.35.0...v0.38.5)
- github.com/google/pprof: [3ea8567 → 1ebb73c](https://github.com/google/pprof/compare/3ea8567...1ebb73c)
- github.com/googleapis/gax-go/v2: [v2.0.4 → v2.0.5](https://github.com/googleapis/gax-go/v2/compare/v2.0.4...v2.0.5)
- github.com/gorilla/websocket: [v1.4.0 → v1.4.2](https://github.com/gorilla/websocket/compare/v1.4.0...v1.4.2)
- github.com/jmespath/go-jmespath: [c2b33e8 → v0.4.0](https://github.com/jmespath/go-jmespath/compare/c2b33e8...v0.4.0)
- github.com/jstemmer/go-junit-report: [af01ea7 → v0.9.1](https://github.com/jstemmer/go-junit-report/compare/af01ea7...v0.9.1)
- github.com/kr/pretty: [v0.1.0 → v0.2.0](https://github.com/kr/pretty/compare/v0.1.0...v0.2.0)
- github.com/kr/text: [v0.1.0 → v0.2.0](https://github.com/kr/text/compare/v0.1.0...v0.2.0)
- github.com/mattn/go-isatty: [v0.0.9 → v0.0.4](https://github.com/mattn/go-isatty/compare/v0.0.9...v0.0.4)
- github.com/moby/ipvs: [v1.0.0 → v1.0.1](https://github.com/moby/ipvs/compare/v1.0.0...v1.0.1)
- github.com/mrunalp/fileutils: [7d4729f → abd8a0e](https://github.com/mrunalp/fileutils/compare/7d4729f...abd8a0e)
- github.com/opencontainers/runc: [v1.0.0-rc10 → v1.0.0-rc92](https://github.com/opencontainers/runc/compare/v1.0.0-rc10...v1.0.0-rc92)
- github.com/opencontainers/selinux: [5215b18 → v1.6.0](https://github.com/opencontainers/selinux/compare/5215b18...v1.6.0)
- github.com/quobyte/api: [v0.1.2 → v0.1.8](https://github.com/quobyte/api/compare/v0.1.2...v0.1.8)
- github.com/spf13/viper: [v1.3.2 → v1.7.0](https://github.com/spf13/viper/compare/v1.3.2...v1.7.0)
- github.com/storageos/go-api: [343b3ef → v2.2.0+incompatible](https://github.com/storageos/go-api/compare/343b3ef...v2.2.0)
- github.com/tmc/grpc-websocket-proxy: [89b8d40 → 0ad062e](https://github.com/tmc/grpc-websocket-proxy/compare/89b8d40...0ad062e)
- github.com/urfave/cli: [v1.20.0 → v1.22.2](https://github.com/urfave/cli/compare/v1.20.0...v1.22.2)
- github.com/vishvananda/netlink: [v1.0.0 → v1.1.0](https://github.com/vishvananda/netlink/compare/v1.0.0...v1.1.0)
- github.com/vishvananda/netns: [be1fbed → db3c7e5](https://github.com/vishvananda/netns/compare/be1fbed...db3c7e5)
- go.etcd.io/bbolt: v1.3.3 → v1.3.5
- go.opencensus.io: v0.21.0 → v0.22.3
- golang.org/x/exp: 4b39c73 → 6cc2880
- golang.org/x/image: 0694c2d → cff245a
- golang.org/x/lint: 959b441 → 738671d
- golang.org/x/mobile: d3739f8 → d2bd2a2
- golang.org/x/mod: 4bf6d31 → v0.3.0
- golang.org/x/net: 13f9640 → ac852fb
- golang.org/x/tools: 5eefd05 → c1934b7
- golang.org/x/xerrors: a985d34 → 5ec99f8
- google.golang.org/api: 5213b80 → v0.20.0
- google.golang.org/protobuf: v1.24.0 → v1.25.0
- gopkg.in/check.v1: 788fd78 → 8fa4692
- honnef.co/go/tools: v0.0.1-2019.2.2 → v0.0.1-2020.1.3
- k8s.io/cloud-provider: 52e5381 → 82fca6d
- k8s.io/klog/v2: v2.2.0 → v2.4.0
- k8s.io/kube-openapi: 6aeccd4 → d219536
- k8s.io/kubernetes: bb8a5d2 → f58c4d8
- k8s.io/system-validators: v1.1.2 → v1.2.0
- sigs.k8s.io/structured-merge-diff/v4: v4.0.1 → v4.0.2

### Removed

- github.com/xlab/handysort: [fb3537e](https://github.com/xlab/handysort/tree/fb3537e)
- k8s.io/kubernetes/staging/src/k8s.io/api: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/apiextensions-apiserver: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/apimachinery: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/apiserver: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/cli-runtime: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/client-go: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/cluster-bootstrap: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/code-generator: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/component-base: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/cri-api: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/csi-translation-lib: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kube-aggregator: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kube-controller-manager: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kube-proxy: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kube-scheduler: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kubectl: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/kubelet: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/legacy-cloud-providers: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/metrics: 70a6823
- k8s.io/kubernetes/staging/src/k8s.io/sample-apiserver: 70a6823
- vbom.ml/util: db5cfe1
