package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// LongTermRetentionBackupsClient is the the Azure SQL Database management API provides a RESTful set of web services
// that interact with Azure SQL Database services to manage your databases. The API enables you to create, retrieve,
// update, and delete databases.
type LongTermRetentionBackupsClient struct {
	BaseClient
}

// NewLongTermRetentionBackupsClient creates an instance of the LongTermRetentionBackupsClient client.
func NewLongTermRetentionBackupsClient(subscriptionID string) LongTermRetentionBackupsClient {
	return NewLongTermRetentionBackupsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLongTermRetentionBackupsClientWithBaseURI creates an instance of the LongTermRetentionBackupsClient client using
// a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewLongTermRetentionBackupsClientWithBaseURI(baseURI string, subscriptionID string) LongTermRetentionBackupsClient {
	return LongTermRetentionBackupsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Copy copy an existing long term retention backup.
// Parameters:
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
// parameters - the parameters needed for long term retention copy request
func (client LongTermRetentionBackupsClient) Copy(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters CopyLongTermRetentionBackupParameters) (result LongTermRetentionBackupsCopyFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.Copy")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CopyPreparer(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Copy", nil, "Failure preparing request")
		return
	}

	result, err = client.CopySender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Copy", nil, "Failure sending request")
		return
	}

	return
}

// CopyPreparer prepares the Copy request.
func (client LongTermRetentionBackupsClient) CopyPreparer(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters CopyLongTermRetentionBackupParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CopySender sends the Copy request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) CopySender(req *http.Request) (future LongTermRetentionBackupsCopyFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CopyResponder handles the response to the Copy request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) CopyResponder(resp *http.Response) (result LongTermRetentionBackupOperationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CopyByResourceGroup copy an existing long term retention backup to a different server.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
// parameters - the parameters needed for long term retention copy request
func (client LongTermRetentionBackupsClient) CopyByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters CopyLongTermRetentionBackupParameters) (result LongTermRetentionBackupsCopyByResourceGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.CopyByResourceGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CopyByResourceGroupPreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "CopyByResourceGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.CopyByResourceGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "CopyByResourceGroup", nil, "Failure sending request")
		return
	}

	return
}

// CopyByResourceGroupPreparer prepares the CopyByResourceGroup request.
func (client LongTermRetentionBackupsClient) CopyByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters CopyLongTermRetentionBackupParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/copy", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CopyByResourceGroupSender sends the CopyByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) CopyByResourceGroupSender(req *http.Request) (future LongTermRetentionBackupsCopyByResourceGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CopyByResourceGroupResponder handles the response to the CopyByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) CopyByResourceGroupResponder(resp *http.Response) (result LongTermRetentionBackupOperationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a long term retention backup.
// Parameters:
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
func (client LongTermRetentionBackupsClient) Delete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result LongTermRetentionBackupsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Delete", nil, "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client LongTermRetentionBackupsClient) DeletePreparer(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) DeleteSender(req *http.Request) (future LongTermRetentionBackupsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteByResourceGroup deletes a long term retention backup.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
func (client LongTermRetentionBackupsClient) DeleteByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result LongTermRetentionBackupsDeleteByResourceGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.DeleteByResourceGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteByResourceGroupPreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "DeleteByResourceGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteByResourceGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "DeleteByResourceGroup", nil, "Failure sending request")
		return
	}

	return
}

// DeleteByResourceGroupPreparer prepares the DeleteByResourceGroup request.
func (client LongTermRetentionBackupsClient) DeleteByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteByResourceGroupSender sends the DeleteByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) DeleteByResourceGroupSender(req *http.Request) (future LongTermRetentionBackupsDeleteByResourceGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteByResourceGroupResponder handles the response to the DeleteByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) DeleteByResourceGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a long term retention backup.
// Parameters:
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
func (client LongTermRetentionBackupsClient) Get(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result LongTermRetentionBackup, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client LongTermRetentionBackupsClient) GetPreparer(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) GetResponder(resp *http.Response) (result LongTermRetentionBackup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByResourceGroup gets a long term retention backup.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
func (client LongTermRetentionBackupsClient) GetByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (result LongTermRetentionBackup, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.GetByResourceGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetByResourceGroupPreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "GetByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "GetByResourceGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "GetByResourceGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetByResourceGroupPreparer prepares the GetByResourceGroup request.
func (client LongTermRetentionBackupsClient) GetByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByResourceGroupSender sends the GetByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) GetByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetByResourceGroupResponder handles the response to the GetByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) GetByResourceGroupResponder(resp *http.Response) (result LongTermRetentionBackup, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDatabase lists all long term retention backups for a database.
// Parameters:
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByDatabase(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByDatabaseNextResults
	req, err := client.ListByDatabasePreparer(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByDatabase", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByDatabase", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByDatabasePreparer prepares the ListByDatabase request.
func (client LongTermRetentionBackupsClient) ListByDatabasePreparer(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDatabaseSender sends the ListByDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByDatabaseResponder handles the response to the ListByDatabase request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByDatabaseResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDatabaseNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByDatabaseNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByDatabaseNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByDatabaseNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByDatabaseNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDatabaseComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByDatabaseComplete(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByDatabase")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDatabase(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByLocation lists the long term retention backups for a given location.
// Parameters:
// locationName - the location of the database
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByLocation(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByLocation")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByLocationNextResults
	req, err := client.ListByLocationPreparer(ctx, locationName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByLocation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByLocation", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByLocation", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLocationPreparer prepares the ListByLocation request.
func (client LongTermRetentionBackupsClient) ListByLocationPreparer(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLocationSender sends the ListByLocation request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByLocationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLocationResponder handles the response to the ListByLocation request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByLocationResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLocationNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByLocationNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByLocationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByLocationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByLocationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLocationComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByLocationComplete(ctx context.Context, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByLocation")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLocation(ctx, locationName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupDatabase lists all long term retention backups for a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByResourceGroupDatabase(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupDatabase")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupDatabaseNextResults
	req, err := client.ListByResourceGroupDatabasePreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupDatabase", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupDatabaseSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupDatabase", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByResourceGroupDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupDatabase", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupDatabasePreparer prepares the ListByResourceGroupDatabase request.
func (client LongTermRetentionBackupsClient) ListByResourceGroupDatabasePreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupDatabaseSender sends the ListByResourceGroupDatabase request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByResourceGroupDatabaseSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupDatabaseResponder handles the response to the ListByResourceGroupDatabase request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByResourceGroupDatabaseResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupDatabaseNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByResourceGroupDatabaseNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupDatabaseNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupDatabaseSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupDatabaseNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupDatabaseResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupDatabaseNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupDatabaseComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByResourceGroupDatabaseComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupDatabase")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupDatabase(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupLocation lists the long term retention backups for a given location.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByResourceGroupLocation(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupLocation")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupLocationNextResults
	req, err := client.ListByResourceGroupLocationPreparer(ctx, resourceGroupName, locationName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupLocation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupLocationSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupLocation", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByResourceGroupLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupLocation", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupLocationPreparer prepares the ListByResourceGroupLocation request.
func (client LongTermRetentionBackupsClient) ListByResourceGroupLocationPreparer(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":      autorest.Encode("path", locationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupLocationSender sends the ListByResourceGroupLocation request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByResourceGroupLocationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupLocationResponder handles the response to the ListByResourceGroupLocation request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByResourceGroupLocationResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupLocationNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByResourceGroupLocationNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupLocationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupLocationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupLocationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupLocationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupLocationComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByResourceGroupLocationComplete(ctx context.Context, resourceGroupName string, locationName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupLocation")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupLocation(ctx, resourceGroupName, locationName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByResourceGroupServer lists the long term retention backups for a given server.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByResourceGroupServer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupServer")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceGroupServerNextResults
	req, err := client.ListByResourceGroupServerPreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupServer", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupServerSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupServer", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByResourceGroupServerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByResourceGroupServer", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupServerPreparer prepares the ListByResourceGroupServer request.
func (client LongTermRetentionBackupsClient) ListByResourceGroupServerPreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":                autorest.Encode("path", locationName),
		"longTermRetentionServerName": autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupServerSender sends the ListByResourceGroupServer request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByResourceGroupServerSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupServerResponder handles the response to the ListByResourceGroupServer request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByResourceGroupServerResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupServerNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByResourceGroupServerNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupServerNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupServerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupServerNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupServerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByResourceGroupServerNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupServerComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByResourceGroupServerComplete(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByResourceGroupServer")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupServer(ctx, resourceGroupName, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState)
	return
}

// ListByServer lists the long term retention backups for a given server.
// Parameters:
// locationName - the location of the database
// longTermRetentionServerName - the name of the server
// onlyLatestPerDatabase - whether or not to only get the latest backup for each database.
// databaseState - whether to query against just live databases, just deleted databases, or all databases.
func (client LongTermRetentionBackupsClient) ListByServer(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByServer")
		defer func() {
			sc := -1
			if result.ltrblr.Response.Response != nil {
				sc = result.ltrblr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByServerNextResults
	req, err := client.ListByServerPreparer(ctx, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByServer", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByServerSender(req)
	if err != nil {
		result.ltrblr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByServer", resp, "Failure sending request")
		return
	}

	result.ltrblr, err = client.ListByServerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "ListByServer", resp, "Failure responding to request")
		return
	}
	if result.ltrblr.hasNextLink() && result.ltrblr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByServerPreparer prepares the ListByServer request.
func (client LongTermRetentionBackupsClient) ListByServerPreparer(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":                autorest.Encode("path", locationName),
		"longTermRetentionServerName": autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if onlyLatestPerDatabase != nil {
		queryParameters["onlyLatestPerDatabase"] = autorest.Encode("query", *onlyLatestPerDatabase)
	}
	if len(string(databaseState)) > 0 {
		queryParameters["databaseState"] = autorest.Encode("query", databaseState)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionBackups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByServerSender sends the ListByServer request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) ListByServerSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByServerResponder handles the response to the ListByServer request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) ListByServerResponder(resp *http.Response) (result LongTermRetentionBackupListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByServerNextResults retrieves the next set of results, if any.
func (client LongTermRetentionBackupsClient) listByServerNextResults(ctx context.Context, lastResults LongTermRetentionBackupListResult) (result LongTermRetentionBackupListResult, err error) {
	req, err := lastResults.longTermRetentionBackupListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByServerNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByServerSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByServerNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByServerResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "listByServerNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByServerComplete enumerates all values, automatically crossing page boundaries as required.
func (client LongTermRetentionBackupsClient) ListByServerComplete(ctx context.Context, locationName string, longTermRetentionServerName string, onlyLatestPerDatabase *bool, databaseState DatabaseState) (result LongTermRetentionBackupListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.ListByServer")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByServer(ctx, locationName, longTermRetentionServerName, onlyLatestPerDatabase, databaseState)
	return
}

// Update updates an existing long term retention backup.
// Parameters:
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
// parameters - the requested backup resource state
func (client LongTermRetentionBackupsClient) Update(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters UpdateLongTermRetentionBackupParameters) (result LongTermRetentionBackupsUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.Update")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdatePreparer(ctx, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "Update", nil, "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client LongTermRetentionBackupsClient) UpdatePreparer(ctx context.Context, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters UpdateLongTermRetentionBackupParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) UpdateSender(req *http.Request) (future LongTermRetentionBackupsUpdateFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) UpdateResponder(resp *http.Response) (result LongTermRetentionBackupOperationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateByResourceGroup updates an existing long term retention backup.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// locationName - the location of the database.
// longTermRetentionServerName - the name of the server
// longTermRetentionDatabaseName - the name of the database
// backupName - the backup name.
// parameters - the requested backup resource state
func (client LongTermRetentionBackupsClient) UpdateByResourceGroup(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters UpdateLongTermRetentionBackupParameters) (result LongTermRetentionBackupsUpdateByResourceGroupFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LongTermRetentionBackupsClient.UpdateByResourceGroup")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateByResourceGroupPreparer(ctx, resourceGroupName, locationName, longTermRetentionServerName, longTermRetentionDatabaseName, backupName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "UpdateByResourceGroup", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateByResourceGroupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.LongTermRetentionBackupsClient", "UpdateByResourceGroup", nil, "Failure sending request")
		return
	}

	return
}

// UpdateByResourceGroupPreparer prepares the UpdateByResourceGroup request.
func (client LongTermRetentionBackupsClient) UpdateByResourceGroupPreparer(ctx context.Context, resourceGroupName string, locationName string, longTermRetentionServerName string, longTermRetentionDatabaseName string, backupName string, parameters UpdateLongTermRetentionBackupParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupName":                    autorest.Encode("path", backupName),
		"locationName":                  autorest.Encode("path", locationName),
		"longTermRetentionDatabaseName": autorest.Encode("path", longTermRetentionDatabaseName),
		"longTermRetentionServerName":   autorest.Encode("path", longTermRetentionServerName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/locations/{locationName}/longTermRetentionServers/{longTermRetentionServerName}/longTermRetentionDatabases/{longTermRetentionDatabaseName}/longTermRetentionBackups/{backupName}/update", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateByResourceGroupSender sends the UpdateByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client LongTermRetentionBackupsClient) UpdateByResourceGroupSender(req *http.Request) (future LongTermRetentionBackupsUpdateByResourceGroupFuture, err error) {
	var resp *http.Response
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// UpdateByResourceGroupResponder handles the response to the UpdateByResourceGroup request. The method always
// closes the http.Response Body.
func (client LongTermRetentionBackupsClient) UpdateByResourceGroupResponder(resp *http.Response) (result LongTermRetentionBackupOperationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
