/*
Copyright 2021 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package optimization

var (
	DiskSkuMap = map[string]map[string]DiskSkuInfo{
		"premium_lrs": {
			"p40": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P40", MaxAllowedShares: 5, MaxBurstIops: 7500, MaxIops: 7500, MaxBwMbps: 250, MaxBurstBwMbps: 250, MaxSizeGiB: 2048},
			"p2":  {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P2", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 8},
			"p3":  {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P3", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 16},
			"p4":  {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P4", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 32},
			"p10": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P10", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 500, MaxBwMbps: 100, MaxBurstBwMbps: 170, MaxSizeGiB: 128},
			"p20": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P20", MaxAllowedShares: 2, MaxBurstIops: 3500, MaxIops: 2300, MaxBwMbps: 150, MaxBurstBwMbps: 170, MaxSizeGiB: 512},
			"p80": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P80", MaxAllowedShares: 10, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 900, MaxBurstBwMbps: 900, MaxSizeGiB: 32767},
			"p6":  {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P6", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 240, MaxBwMbps: 50, MaxBurstBwMbps: 170, MaxSizeGiB: 64},
			"p15": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P15", MaxAllowedShares: 2, MaxBurstIops: 3500, MaxIops: 1100, MaxBwMbps: 125, MaxBurstBwMbps: 170, MaxSizeGiB: 256},
			"p30": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P30", MaxAllowedShares: 5, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 200, MaxBurstBwMbps: 200, MaxSizeGiB: 1024},
			"p50": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P50", MaxAllowedShares: 5, MaxBurstIops: 7500, MaxIops: 7500, MaxBwMbps: 250, MaxBurstBwMbps: 250, MaxSizeGiB: 4096},
			"p70": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P70", MaxAllowedShares: 10, MaxBurstIops: 18000, MaxIops: 18000, MaxBwMbps: 750, MaxBurstBwMbps: 750, MaxSizeGiB: 16384},
			"p1":  {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P1", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 4},
			"p60": {StorageAccountType: "Premium_LRS", StorageTier: "Premium", DiskSize: "P60", MaxAllowedShares: 10, MaxBurstIops: 16000, MaxIops: 16000, MaxBwMbps: 500, MaxBurstBwMbps: 500, MaxSizeGiB: 8192},
		},
		"standardssd_lrs": {
			"e70": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E70", MaxAllowedShares: 5, MaxBurstIops: 4000, MaxIops: 4000, MaxBwMbps: 600, MaxBurstBwMbps: 600, MaxSizeGiB: 16384},
			"e2":  {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E2", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 8},
			"e10": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E10", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 128},
			"e80": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E80", MaxAllowedShares: 5, MaxBurstIops: 6000, MaxIops: 6000, MaxBwMbps: 750, MaxBurstBwMbps: 750, MaxSizeGiB: 32767},
			"e15": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E15", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 256},
			"e20": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E20", MaxAllowedShares: 2, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 512},
			"e4":  {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E4", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 32},
			"e30": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E30", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 1024},
			"e40": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E40", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 2048},
			"e60": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E60", MaxAllowedShares: 5, MaxBurstIops: 2000, MaxIops: 2000, MaxBwMbps: 400, MaxBurstBwMbps: 400, MaxSizeGiB: 8192},
			"e1":  {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E1", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 4},
			"e3":  {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E3", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 16},
			"e6":  {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E6", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 64},
			"e50": {StorageAccountType: "StandardSSD_LRS", StorageTier: "Standard", DiskSize: "E50", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 4096},
		},
		"ultrassd_lrs": {
			"u": {StorageAccountType: "UltraSSD_LRS", StorageTier: "Ultra", DiskSize: "U", MaxAllowedShares: 5, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0, MaxSizeGiB: 65536},
		},
		"standardssd_zrs": {
			"e1":  {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E1", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 4},
			"e10": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E10", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 128},
			"e30": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E30", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 1024},
			"e40": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E40", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 2048},
			"e50": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E50", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 4096},
			"e2":  {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E2", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 8},
			"e3":  {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E3", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 16},
			"e4":  {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E4", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 32},
			"e6":  {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E6", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 64},
			"e20": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E20", MaxAllowedShares: 2, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 512},
			"e80": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E80", MaxAllowedShares: 5, MaxBurstIops: 6000, MaxIops: 6000, MaxBwMbps: 750, MaxBurstBwMbps: 750, MaxSizeGiB: 32767},
			"e15": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E15", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 256},
			"e60": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E60", MaxAllowedShares: 5, MaxBurstIops: 2000, MaxIops: 2000, MaxBwMbps: 400, MaxBurstBwMbps: 400, MaxSizeGiB: 8192},
			"e70": {StorageAccountType: "StandardSSD_ZRS", StorageTier: "Standard", DiskSize: "E70", MaxAllowedShares: 5, MaxBurstIops: 4000, MaxIops: 4000, MaxBwMbps: 600, MaxBurstBwMbps: 600, MaxSizeGiB: 16384},
		},
		"premium_zrs": {
			"p2":  {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P2", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 8},
			"p40": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P40", MaxAllowedShares: 5, MaxBurstIops: 7500, MaxIops: 7500, MaxBwMbps: 250, MaxBurstBwMbps: 250, MaxSizeGiB: 2048},
			"p80": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P80", MaxAllowedShares: 10, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 900, MaxBurstBwMbps: 900, MaxSizeGiB: 32767},
			"p70": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P70", MaxAllowedShares: 10, MaxBurstIops: 18000, MaxIops: 18000, MaxBwMbps: 750, MaxBurstBwMbps: 750, MaxSizeGiB: 16384},
			"p3":  {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P3", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 16},
			"p15": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P15", MaxAllowedShares: 2, MaxBurstIops: 3500, MaxIops: 1100, MaxBwMbps: 125, MaxBurstBwMbps: 170, MaxSizeGiB: 256},
			"p50": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P50", MaxAllowedShares: 5, MaxBurstIops: 7500, MaxIops: 7500, MaxBwMbps: 250, MaxBurstBwMbps: 250, MaxSizeGiB: 4096},
			"p60": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P60", MaxAllowedShares: 10, MaxBurstIops: 16000, MaxIops: 16000, MaxBwMbps: 500, MaxBurstBwMbps: 500, MaxSizeGiB: 8192},
			"p20": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P20", MaxAllowedShares: 2, MaxBurstIops: 3500, MaxIops: 2300, MaxBwMbps: 150, MaxBurstBwMbps: 170, MaxSizeGiB: 512},
			"p1":  {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P1", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 4},
			"p4":  {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P4", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 120, MaxBwMbps: 25, MaxBurstBwMbps: 170, MaxSizeGiB: 32},
			"p6":  {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P6", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 240, MaxBwMbps: 50, MaxBurstBwMbps: 170, MaxSizeGiB: 64},
			"p10": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P10", MaxAllowedShares: 1, MaxBurstIops: 3500, MaxIops: 500, MaxBwMbps: 100, MaxBurstBwMbps: 170, MaxSizeGiB: 128},
			"p30": {StorageAccountType: "Premium_ZRS", StorageTier: "Premium", DiskSize: "P30", MaxAllowedShares: 5, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 200, MaxBurstBwMbps: 200, MaxSizeGiB: 1024},
		},
		"standard_lrs": {
			"s30": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S30", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 1024},
			"s60": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S60", MaxAllowedShares: 5, MaxBurstIops: 1300, MaxIops: 1300, MaxBwMbps: 300, MaxBurstBwMbps: 300, MaxSizeGiB: 8192},
			"s40": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S40", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 2048},
			"s50": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S50", MaxAllowedShares: 5, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 4096},
			"s70": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S70", MaxAllowedShares: 5, MaxBurstIops: 2000, MaxIops: 2000, MaxBwMbps: 500, MaxBurstBwMbps: 500, MaxSizeGiB: 16384},
			"s4":  {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S4", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 32},
			"s6":  {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S6", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 64},
			"s10": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S10", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 128},
			"s15": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S15", MaxAllowedShares: 1, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 256},
			"s20": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S20", MaxAllowedShares: 2, MaxBurstIops: 500, MaxIops: 500, MaxBwMbps: 60, MaxBurstBwMbps: 60, MaxSizeGiB: 512},
			"s80": {StorageAccountType: "Standard_LRS", StorageTier: "Standard", DiskSize: "S80", MaxAllowedShares: 5, MaxBurstIops: 2000, MaxIops: 2000, MaxBwMbps: 500, MaxBurstBwMbps: 500, MaxSizeGiB: 32767},
		},
	}

	NodeInfoMap = map[string]NodeInfo{
		"standard_ds11_v2":       {SkuName: "Standard_DS11_v2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e48a_v4":       {SkuName: "Standard_E48a_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64-16as_v4":   {SkuName: "Standard_E64-16as_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e48s_v4":       {SkuName: "Standard_E48s_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_d64_v4":        {SkuName: "Standard_D64_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_hb120-16rs_v3": {SkuName: "Standard_HB120-16rs_v3", MaxDataDiskCount: 32, VCpus: 120, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_m8-2ms":        {SkuName: "Standard_M8-2ms", MaxDataDiskCount: 8, VCpus: 8, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 125, MaxBurstBwMbps: 125},
		"standard_e8-4as_v4":     {SkuName: "Standard_E8-4as_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_f16s_v2":       {SkuName: "Standard_F16s_v2", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 380, MaxBurstBwMbps: 380},
		"standard_e16_v4":        {SkuName: "Standard_E16_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d4":            {SkuName: "Standard_D4", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32a_v4":       {SkuName: "Standard_E32a_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64-16s_v3":    {SkuName: "Standard_E64-16s_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d2ds_v4":       {SkuName: "Standard_D2ds_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_d16s_v4":       {SkuName: "Standard_D16s_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_b2s":           {SkuName: "Standard_B2s", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 1280, MaxIops: 1280, MaxBwMbps: 15, MaxBurstBwMbps: 15},
		"standard_d4a_v4":        {SkuName: "Standard_D4a_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a1_v2":         {SkuName: "Standard_A1_v2", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32s_v4":       {SkuName: "Standard_E32s_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_m16-8ms":       {SkuName: "Standard_M16-8ms", MaxDataDiskCount: 16, VCpus: 16, MaxBurstIops: 10000, MaxIops: 10000, MaxBwMbps: 250, MaxBurstBwMbps: 250},
		"standard_m128s":         {SkuName: "Standard_M128s", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_b20ms":         {SkuName: "Standard_B20ms", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 4320, MaxIops: 4320, MaxBwMbps: 50, MaxBurstBwMbps: 50},
		"standard_a8_v2":         {SkuName: "Standard_A8_v2", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32-8ds_v4":    {SkuName: "Standard_E32-8ds_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d48_v4":        {SkuName: "Standard_D48_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_hb120-64rs_v3": {SkuName: "Standard_HB120-64rs_v3", MaxDataDiskCount: 32, VCpus: 120, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_nc12s_v3":      {SkuName: "Standard_NC12s_v3", MaxDataDiskCount: 24, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_hb60rs":        {SkuName: "Standard_HB60rs", MaxDataDiskCount: 4, VCpus: 60, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m416ms_v2":     {SkuName: "Standard_M416ms_v2", MaxDataDiskCount: 64, VCpus: 416, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f2s":           {SkuName: "Standard_F2s", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_d2as_v4":       {SkuName: "Standard_D2as_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_d4_v2":         {SkuName: "Standard_D4_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d2d_v4":        {SkuName: "Standard_D2d_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m32dms_v2":     {SkuName: "Standard_M32dms_v2", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 476, MaxBurstBwMbps: 476},
		"standard_m208s_v2":      {SkuName: "Standard_M208s_v2", MaxDataDiskCount: 64, VCpus: 208, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nv32as_v4":     {SkuName: "Standard_NV32as_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a2":            {SkuName: "Standard_A2", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d5_v2":         {SkuName: "Standard_D5_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e2d_v4":        {SkuName: "Standard_E2d_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e8ds_v4":       {SkuName: "Standard_E8ds_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_nv12":          {SkuName: "Standard_NV12", MaxDataDiskCount: 48, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_l32s":          {SkuName: "Standard_L32s", MaxDataDiskCount: 64, VCpus: 32, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"basic_a0":               {SkuName: "Basic_A0", MaxDataDiskCount: 1, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds14":          {SkuName: "Standard_DS14", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 512, MaxBurstBwMbps: 512},
		"standard_b1ls":          {SkuName: "Standard_B1ls", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 160, MaxIops: 160, MaxBwMbps: 10, MaxBurstBwMbps: 10},
		"standard_d16_v3":        {SkuName: "Standard_D16_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e2_v3":         {SkuName: "Standard_E2_v3", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16s_v4":       {SkuName: "Standard_E16s_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d4s_v4":        {SkuName: "Standard_D4s_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_m8-4ms":        {SkuName: "Standard_M8-4ms", MaxDataDiskCount: 8, VCpus: 8, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 125, MaxBurstBwMbps: 125},
		"standard_e96-24as_v4":   {SkuName: "Standard_E96-24as_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_f16":           {SkuName: "Standard_F16", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d64_v3":        {SkuName: "Standard_D64_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e20s_v3":       {SkuName: "Standard_E20s_v3", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 32000, MaxIops: 32000, MaxBwMbps: 480, MaxBurstBwMbps: 480},
		"standard_e4_v4":         {SkuName: "Standard_E4_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_d16_v4":        {SkuName: "Standard_D16_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_hc44rs":        {SkuName: "Standard_HC44rs", MaxDataDiskCount: 4, VCpus: 44, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_g3":            {SkuName: "Standard_G3", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f1s":           {SkuName: "Standard_F1s", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_e64a_v4":       {SkuName: "Standard_E64a_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32as_v4":      {SkuName: "Standard_E32as_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_l8s":           {SkuName: "Standard_L8s", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 10000, MaxIops: 10000, MaxBwMbps: 250, MaxBurstBwMbps: 250},
		"standard_d11_v2_promo":  {SkuName: "Standard_D11_v2_Promo", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e2a_v4":        {SkuName: "Standard_E2a_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64s_v4":       {SkuName: "Standard_E64s_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_m64dms_v2":     {SkuName: "Standard_M64dms_v2", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 953, MaxBurstBwMbps: 953},
		"standard_nv6s_v2":       {SkuName: "Standard_NV6s_v2", MaxDataDiskCount: 12, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nv24":          {SkuName: "Standard_NV24", MaxDataDiskCount: 64, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m8ms":          {SkuName: "Standard_M8ms", MaxDataDiskCount: 8, VCpus: 8, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 125, MaxBurstBwMbps: 125},
		"standard_m128":          {SkuName: "Standard_M128", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_a3":            {SkuName: "Standard_A3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a6":            {SkuName: "Standard_A6", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d32as_v4":      {SkuName: "Standard_D32as_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_a2_v2":         {SkuName: "Standard_A2_v2", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_l4s":           {SkuName: "Standard_L4s", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 125, MaxBurstBwMbps: 125},
		"standard_d2a_v4":        {SkuName: "Standard_D2a_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64as_v4":      {SkuName: "Standard_E64as_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e96as_v4":      {SkuName: "Standard_E96as_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e64_v3":        {SkuName: "Standard_E64_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_g4":            {SkuName: "Standard_G4", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"basic_a2":               {SkuName: "Basic_A2", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds13":          {SkuName: "Standard_DS13", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 256, MaxBurstBwMbps: 256},
		"standard_ds14-8_v2":     {SkuName: "Standard_DS14-8_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e48as_v4":      {SkuName: "Standard_E48as_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_e64is_v3":      {SkuName: "Standard_E64is_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_hb120rs_v2":    {SkuName: "Standard_HB120rs_v2", MaxDataDiskCount: 8, VCpus: 120, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16-4ds_v4":    {SkuName: "Standard_E16-4ds_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_m128-32ms":     {SkuName: "Standard_M128-32ms", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_h16":           {SkuName: "Standard_H16", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a1":            {SkuName: "Standard_A1", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e2as_v4":       {SkuName: "Standard_E2as_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_d2_v2":         {SkuName: "Standard_D2_v2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f1":            {SkuName: "Standard_F1", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a8m_v2":        {SkuName: "Standard_A8m_v2", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d8ds_v4":       {SkuName: "Standard_D8ds_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_l80s_v2":       {SkuName: "Standard_L80s_v2", MaxDataDiskCount: 32, VCpus: 80, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16mr":         {SkuName: "Standard_H16mr", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs5":           {SkuName: "Standard_GS5", MaxDataDiskCount: 64, VCpus: 32, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_d16s_v3":       {SkuName: "Standard_D16s_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d48_v3":        {SkuName: "Standard_D48_v3", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e8-2s_v3":      {SkuName: "Standard_E8-2s_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e8_v4":         {SkuName: "Standard_E8_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e2s_v4":        {SkuName: "Standard_E2s_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_d8_v4":         {SkuName: "Standard_D8_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_nc24s_v3":      {SkuName: "Standard_NC24s_v3", MaxDataDiskCount: 32, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16_promo":     {SkuName: "Standard_H16_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"basic_a1":               {SkuName: "Basic_A1", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d14":           {SkuName: "Standard_D14", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e4as_v4":       {SkuName: "Standard_E4as_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_dc1s_v2":       {SkuName: "Standard_DC1s_v2", MaxDataDiskCount: 1, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc8as_t4_v3":   {SkuName: "Standard_NC8as_T4_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 24480, MaxIops: 24480, MaxBwMbps: 351, MaxBurstBwMbps: 351},
		"standard_ds15_v2":       {SkuName: "Standard_DS15_v2", MaxDataDiskCount: 64, VCpus: 20, MaxBurstIops: 64000, MaxIops: 64000, MaxBwMbps: 960, MaxBurstBwMbps: 960},
		"standard_ds4_v2":        {SkuName: "Standard_DS4_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e8as_v4":       {SkuName: "Standard_E8as_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e32-8as_v4":    {SkuName: "Standard_E32-8as_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d14_v2":        {SkuName: "Standard_D14_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_hb120rs_v3":    {SkuName: "Standard_HB120rs_v3", MaxDataDiskCount: 32, VCpus: 120, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_h8":            {SkuName: "Standard_H8", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds12-2_v2":     {SkuName: "Standard_DS12-2_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e2s_v3":        {SkuName: "Standard_E2s_v3", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_e2ds_v4":       {SkuName: "Standard_E2ds_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_m192is_v2":     {SkuName: "Standard_M192is_v2", MaxDataDiskCount: 64, VCpus: 192, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_nv48s_v3":      {SkuName: "Standard_NV48s_v3", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_l48s_v2":       {SkuName: "Standard_L48s_v2", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds2":           {SkuName: "Standard_DS2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 64, MaxBurstBwMbps: 64},
		"standard_f8s_v2":        {SkuName: "Standard_F8s_v2", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 190, MaxBurstBwMbps: 190},
		"standard_e64d_v4":       {SkuName: "Standard_E64d_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d48ds_v4":      {SkuName: "Standard_D48ds_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_d15_v2":        {SkuName: "Standard_D15_v2", MaxDataDiskCount: 64, VCpus: 20, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a5":            {SkuName: "Standard_A5", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds4":           {SkuName: "Standard_DS4", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 256, MaxBurstBwMbps: 256},
		"standard_e16-4s_v3":     {SkuName: "Standard_E16-4s_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_m128-64ms":     {SkuName: "Standard_M128-64ms", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_e4-2as_v4":     {SkuName: "Standard_E4-2as_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e20_v3":        {SkuName: "Standard_E20_v3", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m128ms_v2":     {SkuName: "Standard_M128ms_v2", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_m192ids_v2":    {SkuName: "Standard_M192ids_v2", MaxDataDiskCount: 64, VCpus: 192, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_d13_v2_promo":  {SkuName: "Standard_D13_v2_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds12_v2":       {SkuName: "Standard_DS12_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_d13_v2":        {SkuName: "Standard_D13_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a4_v2":         {SkuName: "Standard_A4_v2", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d64s_v3":       {SkuName: "Standard_D64s_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d64d_v4":       {SkuName: "Standard_D64d_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nv16as_v4":     {SkuName: "Standard_NV16as_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d14_v2_promo":  {SkuName: "Standard_D14_v2_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds3_v2_promo":  {SkuName: "Standard_DS3_v2_Promo", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_ds11-1_v2":     {SkuName: "Standard_DS11-1_v2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e16as_v4":      {SkuName: "Standard_E16as_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e20_v4":        {SkuName: "Standard_E20_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 32000, MaxIops: 32000, MaxBwMbps: 480, MaxBurstBwMbps: 480},
		"standard_e80is_v4":      {SkuName: "Standard_E80is_v4", MaxDataDiskCount: 32, VCpus: 80, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d8d_v4":        {SkuName: "Standard_D8d_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds14_v2_promo": {SkuName: "Standard_DS14_v2_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_a4":            {SkuName: "Standard_A4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d64as_v4":      {SkuName: "Standard_D64as_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_dc2s_v2":       {SkuName: "Standard_DC2s_v2", MaxDataDiskCount: 2, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_g5":            {SkuName: "Standard_G5", MaxDataDiskCount: 64, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds1":           {SkuName: "Standard_DS1", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 32, MaxBurstBwMbps: 32},
		"standard_f4":            {SkuName: "Standard_F4", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32-8s_v4":     {SkuName: "Standard_E32-8s_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_nc16as_t4_v3":  {SkuName: "Standard_NC16as_T4_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 24480, MaxIops: 24480, MaxBwMbps: 351, MaxBurstBwMbps: 351},
		"standard_d48a_v4":       {SkuName: "Standard_D48a_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d4as_v4":       {SkuName: "Standard_D4as_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e32-16s_v4":    {SkuName: "Standard_E32-16s_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_m64ms_v2":      {SkuName: "Standard_M64ms_v2", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 953, MaxBurstBwMbps: 953},
		"standard_hb120-96rs_v3": {SkuName: "Standard_HB120-96rs_v3", MaxDataDiskCount: 32, VCpus: 120, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_m128ms":        {SkuName: "Standard_M128ms", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_nv4as_v4":      {SkuName: "Standard_NV4as_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs5-16":        {SkuName: "Standard_GS5-16", MaxDataDiskCount: 64, VCpus: 32, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_b12ms":         {SkuName: "Standard_B12ms", MaxDataDiskCount: 16, VCpus: 12, MaxBurstIops: 4320, MaxIops: 4320, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds14-4_v2":     {SkuName: "Standard_DS14-4_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d48as_v4":      {SkuName: "Standard_D48as_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_d1_v2":         {SkuName: "Standard_D1_v2", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16-4s_v4":     {SkuName: "Standard_E16-4s_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e20s_v4":       {SkuName: "Standard_E20s_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 32000, MaxIops: 32000, MaxBwMbps: 480, MaxBurstBwMbps: 480},
		"standard_e20ds_v4":      {SkuName: "Standard_E20ds_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 32000, MaxIops: 32000, MaxBwMbps: 480, MaxBurstBwMbps: 480},
		"standard_d4_v4":         {SkuName: "Standard_D4_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_m64-32ms":      {SkuName: "Standard_M64-32ms", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_nc24_promo":    {SkuName: "Standard_NC24_Promo", MaxDataDiskCount: 64, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs4-4":         {SkuName: "Standard_GS4-4", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_l16s_v2":       {SkuName: "Standard_L16s_v2", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc6":           {SkuName: "Standard_NC6", MaxDataDiskCount: 24, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc6s_v2":       {SkuName: "Standard_NC6s_v2", MaxDataDiskCount: 12, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d13":           {SkuName: "Standard_D13", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d4s_v3":        {SkuName: "Standard_D4s_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_d48s_v3":       {SkuName: "Standard_D48s_v3", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_f48s_v2":       {SkuName: "Standard_F48s_v2", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1100, MaxBurstBwMbps: 1100},
		"standard_e4d_v4":        {SkuName: "Standard_E4d_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d4d_v4":        {SkuName: "Standard_D4d_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m64ms":         {SkuName: "Standard_M64ms", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_l16s":          {SkuName: "Standard_L16s", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_b16ms":         {SkuName: "Standard_B16ms", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 4320, MaxIops: 4320, MaxBwMbps: 50, MaxBurstBwMbps: 50},
		"standard_ds13_v2":       {SkuName: "Standard_DS13_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e16-8as_v4":    {SkuName: "Standard_E16-8as_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_f8":            {SkuName: "Standard_F8", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_hb120-32rs_v3": {SkuName: "Standard_HB120-32rs_v3", MaxDataDiskCount: 32, VCpus: 120, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_l8s_v2":        {SkuName: "Standard_L8s_v2", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc6_promo":     {SkuName: "Standard_NC6_Promo", MaxDataDiskCount: 24, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d11_v2":        {SkuName: "Standard_D11_v2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f2":            {SkuName: "Standard_F2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d32_v3":        {SkuName: "Standard_D32_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e8-4s_v3":      {SkuName: "Standard_E8-4s_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e64s_v3":       {SkuName: "Standard_E64s_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e4-2s_v4":      {SkuName: "Standard_E4-2s_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_m64s_v2":       {SkuName: "Standard_M64s_v2", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 953, MaxBurstBwMbps: 953},
		"standard_nc24rs_v3":     {SkuName: "Standard_NC24rs_v3", MaxDataDiskCount: 32, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m32-16ms":      {SkuName: "Standard_M32-16ms", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_m32ls":         {SkuName: "Standard_M32ls", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_d2":            {SkuName: "Standard_D2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_b4ms":          {SkuName: "Standard_B4ms", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 2880, MaxIops: 2880, MaxBwMbps: 35, MaxBurstBwMbps: 35},
		"standard_ds5_v2":        {SkuName: "Standard_DS5_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e48s_v3":       {SkuName: "Standard_E48s_v3", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_e48ds_v4":      {SkuName: "Standard_E48ds_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_m128m":         {SkuName: "Standard_M128m", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_nv8as_v4":      {SkuName: "Standard_NV8as_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16_v3":        {SkuName: "Standard_E16_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f64s_v2":       {SkuName: "Standard_F64s_v2", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1100, MaxBurstBwMbps: 1100},
		"standard_d2_v4":         {SkuName: "Standard_D2_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_m64":           {SkuName: "Standard_M64", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_m416s_v2":      {SkuName: "Standard_M416s_v2", MaxDataDiskCount: 64, VCpus: 416, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs3":           {SkuName: "Standard_GS3", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_d12_v2_promo":  {SkuName: "Standard_D12_v2_Promo", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds11_v2_promo": {SkuName: "Standard_DS11_v2_Promo", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_d64a_v4":       {SkuName: "Standard_D64a_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d96a_v4":       {SkuName: "Standard_D96a_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e96-48as_v4":   {SkuName: "Standard_E96-48as_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e32-16s_v3":    {SkuName: "Standard_E32-16s_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e4s_v4":        {SkuName: "Standard_E4s_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_gs4":           {SkuName: "Standard_GS4", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_ds11":          {SkuName: "Standard_DS11", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 64, MaxBurstBwMbps: 64},
		"standard_f8s":           {SkuName: "Standard_F8s", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e8-2as_v4":     {SkuName: "Standard_E8-2as_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e4_v3":         {SkuName: "Standard_E4_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16s_v3":       {SkuName: "Standard_E16s_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_m32-8ms":       {SkuName: "Standard_M32-8ms", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_m64m":          {SkuName: "Standard_M64m", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_nc12":          {SkuName: "Standard_NC12", MaxDataDiskCount: 48, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32ds_v4":      {SkuName: "Standard_E32ds_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_m64ds_v2":      {SkuName: "Standard_M64ds_v2", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 953, MaxBurstBwMbps: 953},
		"standard_m16ms":         {SkuName: "Standard_M16ms", MaxDataDiskCount: 16, VCpus: 16, MaxBurstIops: 10000, MaxIops: 10000, MaxBwMbps: 250, MaxBurstBwMbps: 250},
		"standard_g1":            {SkuName: "Standard_G1", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs4-8":         {SkuName: "Standard_GS4-8", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_d3_v2_promo":   {SkuName: "Standard_D3_v2_Promo", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_b1s":           {SkuName: "Standard_B1s", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 320, MaxIops: 320, MaxBwMbps: 10, MaxBurstBwMbps: 10},
		"standard_e32-16as_v4":   {SkuName: "Standard_E32-16as_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e32-16ds_v4":   {SkuName: "Standard_E32-16ds_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"basic_a4":               {SkuName: "Basic_A4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d11":           {SkuName: "Standard_D11", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f2s_v2":        {SkuName: "Standard_F2s_v2", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 47, MaxBurstBwMbps: 47},
		"standard_e20d_v4":       {SkuName: "Standard_E20d_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d12":           {SkuName: "Standard_D12", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_b2ms":          {SkuName: "Standard_B2ms", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 1920, MaxIops: 1920, MaxBwMbps: 22, MaxBurstBwMbps: 22},
		"standard_ds2_v2":        {SkuName: "Standard_DS2_v2", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_ds3_v2":        {SkuName: "Standard_DS3_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e64i_v3":       {SkuName: "Standard_E64i_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d64s_v4":       {SkuName: "Standard_D64s_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_h8_promo":      {SkuName: "Standard_H8_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a7":            {SkuName: "Standard_A7", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds12":          {SkuName: "Standard_DS12", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 128, MaxBurstBwMbps: 128},
		"standard_d8as_v4":       {SkuName: "Standard_D8as_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e16-8s_v3":     {SkuName: "Standard_E16-8s_v3", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e8-4ds_v4":     {SkuName: "Standard_E8-4ds_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e64-32ds_v4":   {SkuName: "Standard_E64-32ds_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_gs5-8":         {SkuName: "Standard_GS5-8", MaxDataDiskCount: 64, VCpus: 32, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 2000, MaxBurstBwMbps: 2000},
		"standard_d96as_v4":      {SkuName: "Standard_D96as_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e20as_v4":      {SkuName: "Standard_E20as_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 32000, MaxIops: 32000, MaxBwMbps: 480, MaxBurstBwMbps: 480},
		"standard_nc64as_t4_v3":  {SkuName: "Standard_NC64as_T4_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 24480, MaxIops: 24480, MaxBwMbps: 351, MaxBurstBwMbps: 351},
		"standard_nv24s_v2":      {SkuName: "Standard_NV24s_v2", MaxDataDiskCount: 32, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64-32s_v4":    {SkuName: "Standard_E64-32s_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e64ds_v4":      {SkuName: "Standard_E64ds_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e96a_v4":       {SkuName: "Standard_E96a_v4", MaxDataDiskCount: 32, VCpus: 96, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16-4as_v4":    {SkuName: "Standard_E16-4as_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e64-32as_v4":   {SkuName: "Standard_E64-32as_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e48d_v4":       {SkuName: "Standard_E48d_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64-16s_v4":    {SkuName: "Standard_E64-16s_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e4ds_v4":       {SkuName: "Standard_E4ds_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e16ds_v4":      {SkuName: "Standard_E16ds_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d8s_v4":        {SkuName: "Standard_D8s_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_h16r_promo":    {SkuName: "Standard_H16r_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds5_v2_promo":  {SkuName: "Standard_DS5_v2_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d32s_v3":       {SkuName: "Standard_D32s_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_m192ims_v2":    {SkuName: "Standard_M192ims_v2", MaxDataDiskCount: 64, VCpus: 192, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_h8m_promo":     {SkuName: "Standard_H8m_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds3":           {SkuName: "Standard_DS3", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 128, MaxBurstBwMbps: 128},
		"standard_f4s":           {SkuName: "Standard_F4s", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_d12_v2":        {SkuName: "Standard_D12_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e2_v4":         {SkuName: "Standard_E2_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_d48s_v4":       {SkuName: "Standard_D48s_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_m32ms_v2":      {SkuName: "Standard_M32ms_v2", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 476, MaxBurstBwMbps: 476},
		"standard_m64ls":         {SkuName: "Standard_M64ls", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_d5_v2_promo":   {SkuName: "Standard_D5_v2_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds2_v2_promo":  {SkuName: "Standard_DS2_v2_Promo", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_d1":            {SkuName: "Standard_D1", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nv24s_v3":      {SkuName: "Standard_NV24s_v3", MaxDataDiskCount: 24, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc6s_v3":       {SkuName: "Standard_NC6s_v3", MaxDataDiskCount: 12, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16mr_promo":   {SkuName: "Standard_H16mr_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc12s_v2":      {SkuName: "Standard_NC12s_v2", MaxDataDiskCount: 24, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_f16s":          {SkuName: "Standard_F16s", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d3_v2":         {SkuName: "Standard_D3_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d8_v3":         {SkuName: "Standard_D8_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e64-32s_v3":    {SkuName: "Standard_E64-32s_v3", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_e16d_v4":       {SkuName: "Standard_E16d_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d2s_v4":        {SkuName: "Standard_D2s_v4", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_a0":            {SkuName: "Standard_A0", MaxDataDiskCount: 1, VCpus: 1, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds12-1_v2":     {SkuName: "Standard_DS12-1_v2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_d8s_v3":        {SkuName: "Standard_D8s_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e16a_v4":       {SkuName: "Standard_E16a_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nv12s_v2":      {SkuName: "Standard_NV12s_v2", MaxDataDiskCount: 24, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m32ts":         {SkuName: "Standard_M32ts", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_m208ms_v2":     {SkuName: "Standard_M208ms_v2", MaxDataDiskCount: 64, VCpus: 208, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc24r_promo":   {SkuName: "Standard_NC24r_Promo", MaxDataDiskCount: 64, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h8m":           {SkuName: "Standard_H8m", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16m":          {SkuName: "Standard_H16m", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds13-2_v2":     {SkuName: "Standard_DS13-2_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d2_v3":         {SkuName: "Standard_D2_v3", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m128dms_v2":    {SkuName: "Standard_M128dms_v2", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_d4_v2_promo":   {SkuName: "Standard_D4_v2_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds4_v2_promo":  {SkuName: "Standard_DS4_v2_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e8_v3":         {SkuName: "Standard_E8_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32-8s_v3":     {SkuName: "Standard_E32-8s_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e8-2s_v4":      {SkuName: "Standard_E8-2s_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e8-2ds_v4":     {SkuName: "Standard_E8-2ds_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_d32ds_v4":      {SkuName: "Standard_D32ds_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d64ds_v4":      {SkuName: "Standard_D64ds_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d4_v3":         {SkuName: "Standard_D4_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e48_v3":        {SkuName: "Standard_E48_v3", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e8s_v4":        {SkuName: "Standard_E8s_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_d32d_v4":       {SkuName: "Standard_D32d_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m128ds_v2":     {SkuName: "Standard_M128ds_v2", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_nd40rs_v2":     {SkuName: "Standard_ND40rs_v2", MaxDataDiskCount: 8, VCpus: 40, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_b8ms":          {SkuName: "Standard_B8ms", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 4320, MaxIops: 4320, MaxBwMbps: 50, MaxBurstBwMbps: 50},
		"standard_d8a_v4":        {SkuName: "Standard_D8a_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_a4m_v2":        {SkuName: "Standard_A4m_v2", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d32_v4":        {SkuName: "Standard_D32_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_d16ds_v4":      {SkuName: "Standard_D16ds_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_dc4s_v2":       {SkuName: "Standard_DC4s_v2", MaxDataDiskCount: 4, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m416-208s_v2":  {SkuName: "Standard_M416-208s_v2", MaxDataDiskCount: 64, VCpus: 416, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_nc24rs_v2":     {SkuName: "Standard_NC24rs_v2", MaxDataDiskCount: 32, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds13-4_v2":     {SkuName: "Standard_DS13-4_v2", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_d2s_v3":        {SkuName: "Standard_D2s_v3", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_e4-2s_v3":      {SkuName: "Standard_E4-2s_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e64-16ds_v4":   {SkuName: "Standard_E64-16ds_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d48d_v4":       {SkuName: "Standard_D48d_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d4ds_v4":       {SkuName: "Standard_D4ds_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e32_v3":        {SkuName: "Standard_E32_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e16-8s_v4":     {SkuName: "Standard_E16-8s_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_l64s_v2":       {SkuName: "Standard_L64s_v2", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16m_promo":    {SkuName: "Standard_H16m_Promo", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"basic_a3":               {SkuName: "Basic_A3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d32a_v4":       {SkuName: "Standard_D32a_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d16as_v4":      {SkuName: "Standard_D16as_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_f32s_v2":       {SkuName: "Standard_F32s_v2", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 750, MaxBurstBwMbps: 750},
		"standard_e8d_v4":        {SkuName: "Standard_E8d_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_b1ms":          {SkuName: "Standard_B1ms", MaxDataDiskCount: 2, VCpus: 1, MaxBurstIops: 640, MaxIops: 640, MaxBwMbps: 10, MaxBurstBwMbps: 10},
		"standard_e8a_v4":        {SkuName: "Standard_E8a_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32s_v3":       {SkuName: "Standard_E32s_v3", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e64_v4":        {SkuName: "Standard_E64_v4", MaxDataDiskCount: 32, VCpus: 64, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d32s_v4":       {SkuName: "Standard_D32s_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_m192idms_v2":   {SkuName: "Standard_M192idms_v2", MaxDataDiskCount: 64, VCpus: 192, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_m32ms":         {SkuName: "Standard_M32ms", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 20000, MaxIops: 20000, MaxBwMbps: 500, MaxBurstBwMbps: 500},
		"standard_d2_v2_promo":   {SkuName: "Standard_D2_v2_Promo", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds1_v2":        {SkuName: "Standard_DS1_v2", MaxDataDiskCount: 4, VCpus: 1, MaxBurstIops: 3200, MaxIops: 3200, MaxBwMbps: 48, MaxBurstBwMbps: 48},
		"standard_e20a_v4":       {SkuName: "Standard_E20a_v4", MaxDataDiskCount: 32, VCpus: 20, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e4s_v3":        {SkuName: "Standard_E4s_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_e16-8ds_v4":    {SkuName: "Standard_E16-8ds_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_nv12s_v3":      {SkuName: "Standard_NV12s_v3", MaxDataDiskCount: 12, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m64s":          {SkuName: "Standard_M64s", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_nc24r":         {SkuName: "Standard_NC24r", MaxDataDiskCount: 64, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_h16r":          {SkuName: "Standard_H16r", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_d16a_v4":       {SkuName: "Standard_D16a_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m128s_v2":      {SkuName: "Standard_M128s_v2", MaxDataDiskCount: 64, VCpus: 128, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_nc12_promo":    {SkuName: "Standard_NC12_Promo", MaxDataDiskCount: 48, VCpus: 12, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc24s_v2":      {SkuName: "Standard_NC24s_v2", MaxDataDiskCount: 32, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds14_v2":       {SkuName: "Standard_DS14_v2", MaxDataDiskCount: 64, VCpus: 16, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e4a_v4":        {SkuName: "Standard_E4a_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e32d_v4":       {SkuName: "Standard_E32d_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m16-4ms":       {SkuName: "Standard_M16-4ms", MaxDataDiskCount: 16, VCpus: 16, MaxBurstIops: 10000, MaxIops: 10000, MaxBwMbps: 250, MaxBurstBwMbps: 250},
		"standard_m64-16ms":      {SkuName: "Standard_M64-16ms", MaxDataDiskCount: 64, VCpus: 64, MaxBurstIops: 40000, MaxIops: 40000, MaxBwMbps: 1000, MaxBurstBwMbps: 1000},
		"standard_nc24":          {SkuName: "Standard_NC24", MaxDataDiskCount: 64, VCpus: 24, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs1":           {SkuName: "Standard_GS1", MaxDataDiskCount: 8, VCpus: 2, MaxBurstIops: 5000, MaxIops: 5000, MaxBwMbps: 125, MaxBurstBwMbps: 125},
		"standard_a2m_v2":        {SkuName: "Standard_A2m_v2", MaxDataDiskCount: 4, VCpus: 2, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_e8-4s_v4":      {SkuName: "Standard_E8-4s_v4", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_l32s_v2":       {SkuName: "Standard_L32s_v2", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_m416-208ms_v2": {SkuName: "Standard_M416-208ms_v2", MaxDataDiskCount: 64, VCpus: 416, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1907, MaxBurstBwMbps: 1907},
		"standard_ds12_v2_promo": {SkuName: "Standard_DS12_v2_Promo", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_e8s_v3":        {SkuName: "Standard_E8s_v3", MaxDataDiskCount: 16, VCpus: 8, MaxBurstIops: 12800, MaxIops: 12800, MaxBwMbps: 192, MaxBurstBwMbps: 192},
		"standard_f4s_v2":        {SkuName: "Standard_F4s_v2", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 47, MaxBurstBwMbps: 47},
		"standard_f72s_v2":       {SkuName: "Standard_F72s_v2", MaxDataDiskCount: 32, VCpus: 72, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1100, MaxBurstBwMbps: 1100},
		"standard_e48_v4":        {SkuName: "Standard_E48_v4", MaxDataDiskCount: 32, VCpus: 48, MaxBurstIops: 76800, MaxIops: 76800, MaxBwMbps: 1152, MaxBurstBwMbps: 1152},
		"standard_e80ids_v4":     {SkuName: "Standard_E80ids_v4", MaxDataDiskCount: 32, VCpus: 80, MaxBurstIops: 80000, MaxIops: 80000, MaxBwMbps: 1200, MaxBurstBwMbps: 1200},
		"standard_d16d_v4":       {SkuName: "Standard_D16d_v4", MaxDataDiskCount: 32, VCpus: 16, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_dc8_v2":        {SkuName: "Standard_DC8_v2", MaxDataDiskCount: 8, VCpus: 8, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_nc4as_t4_v3":   {SkuName: "Standard_NC4as_T4_v3", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 24480, MaxIops: 24480, MaxBwMbps: 351, MaxBurstBwMbps: 351},
		"standard_nv6":           {SkuName: "Standard_NV6", MaxDataDiskCount: 24, VCpus: 6, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_ds13_v2_promo": {SkuName: "Standard_DS13_v2_Promo", MaxDataDiskCount: 32, VCpus: 8, MaxBurstIops: 25600, MaxIops: 25600, MaxBwMbps: 384, MaxBurstBwMbps: 384},
		"standard_e32_v4":        {SkuName: "Standard_E32_v4", MaxDataDiskCount: 32, VCpus: 32, MaxBurstIops: 51200, MaxIops: 51200, MaxBwMbps: 768, MaxBurstBwMbps: 768},
		"standard_e4-2ds_v4":     {SkuName: "Standard_E4-2ds_v4", MaxDataDiskCount: 8, VCpus: 4, MaxBurstIops: 6400, MaxIops: 6400, MaxBwMbps: 96, MaxBurstBwMbps: 96},
		"standard_g2":            {SkuName: "Standard_G2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
		"standard_gs2":           {SkuName: "Standard_GS2", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 10000, MaxIops: 10000, MaxBwMbps: 250, MaxBurstBwMbps: 250},
		"standard_d3":            {SkuName: "Standard_D3", MaxDataDiskCount: 16, VCpus: 4, MaxBurstIops: 0, MaxIops: 0, MaxBwMbps: 0, MaxBurstBwMbps: 0},
	}
)
