package workloadmonitor

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/workloadmonitor/mgmt/2020-01-13-preview/workloadmonitor"

// ErrorDetails ...
type ErrorDetails struct {
	// Code - Error code identifying the specific error.
	Code *string `json:"code,omitempty"`
	// Message - A human-readable error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse ...
type ErrorResponse struct {
	// Error - Error info.
	Error *ErrorResponseError `json:"error,omitempty"`
}

// ErrorResponseError error info.
type ErrorResponseError struct {
	// Code - Service-defined error code. This code serves as a sub-status for the HTTP error code specified in the response.
	Code *string `json:"code,omitempty"`
	// Message - Human-readable representation of the error.
	Message *string `json:"message,omitempty"`
	// Details - Error details.
	Details *[]ErrorDetails `json:"details,omitempty"`
}

// HealthMonitor ...
type HealthMonitor struct {
	autorest.Response `json:"-"`
	// HealthMonitorProperties - Properties of the monitor's health status.
	*HealthMonitorProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthMonitor.
func (hm HealthMonitor) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hm.HealthMonitorProperties != nil {
		objectMap["properties"] = hm.HealthMonitorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HealthMonitor struct.
func (hm *HealthMonitor) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var healthMonitorProperties HealthMonitorProperties
				err = json.Unmarshal(*v, &healthMonitorProperties)
				if err != nil {
					return err
				}
				hm.HealthMonitorProperties = &healthMonitorProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hm.Type = &typeVar
			}
		}
	}

	return nil
}

// HealthMonitorList ...
type HealthMonitorList struct {
	autorest.Response `json:"-"`
	// Value - Array of health monitors of the virtual machine.
	Value *[]HealthMonitor `json:"value,omitempty"`
	// NextLink - Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`
}

// HealthMonitorListIterator provides access to a complete listing of HealthMonitor values.
type HealthMonitorListIterator struct {
	i    int
	page HealthMonitorListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HealthMonitorListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthMonitorListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HealthMonitorListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HealthMonitorListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HealthMonitorListIterator) Response() HealthMonitorList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HealthMonitorListIterator) Value() HealthMonitor {
	if !iter.page.NotDone() {
		return HealthMonitor{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HealthMonitorListIterator type.
func NewHealthMonitorListIterator(page HealthMonitorListPage) HealthMonitorListIterator {
	return HealthMonitorListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hml HealthMonitorList) IsEmpty() bool {
	return hml.Value == nil || len(*hml.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hml HealthMonitorList) hasNextLink() bool {
	return hml.NextLink != nil && len(*hml.NextLink) != 0
}

// healthMonitorListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hml HealthMonitorList) healthMonitorListPreparer(ctx context.Context) (*http.Request, error) {
	if !hml.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hml.NextLink)))
}

// HealthMonitorListPage contains a page of HealthMonitor values.
type HealthMonitorListPage struct {
	fn  func(context.Context, HealthMonitorList) (HealthMonitorList, error)
	hml HealthMonitorList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HealthMonitorListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthMonitorListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hml)
		if err != nil {
			return err
		}
		page.hml = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HealthMonitorListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HealthMonitorListPage) NotDone() bool {
	return !page.hml.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HealthMonitorListPage) Response() HealthMonitorList {
	return page.hml
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HealthMonitorListPage) Values() []HealthMonitor {
	if page.hml.IsEmpty() {
		return nil
	}
	return *page.hml.Value
}

// Creates a new instance of the HealthMonitorListPage type.
func NewHealthMonitorListPage(getNextPage func(context.Context, HealthMonitorList) (HealthMonitorList, error)) HealthMonitorListPage {
	return HealthMonitorListPage{fn: getNextPage}
}

// HealthMonitorProperties properties of the monitor.
type HealthMonitorProperties struct {
	// MonitorName - Human-readable name of the monitor.
	MonitorName *string `json:"monitorName,omitempty"`
	// MonitorType - Type of the monitor.
	MonitorType *string `json:"monitorType,omitempty"`
	// MonitoredObject - Dynamic monitored object of the monitor.
	MonitoredObject *string `json:"monitoredObject,omitempty"`
	// ParentMonitorName - Name of the parent monitor.
	ParentMonitorName *string `json:"parentMonitorName,omitempty"`
	// PreviousMonitorState - Previous health state of the monitor. Possible values include: 'Healthy', 'Critical', 'Warning', 'Unknown', 'Disabled', 'None'
	PreviousMonitorState HealthState `json:"previousMonitorState,omitempty"`
	// CurrentMonitorState - Current health state of the monitor. Possible values include: 'Healthy', 'Critical', 'Warning', 'Unknown', 'Disabled', 'None'
	CurrentMonitorState HealthState `json:"currentMonitorState,omitempty"`
	// EvaluationTimestamp - Timestamp of the monitor's last health evaluation.
	EvaluationTimestamp *string `json:"evaluationTimestamp,omitempty"`
	// CurrentStateFirstObservedTimestamp - Timestamp of the monitor's last health state change.
	CurrentStateFirstObservedTimestamp *string `json:"currentStateFirstObservedTimestamp,omitempty"`
	// LastReportedTimestamp - Timestamp of the monitor's last reported health state.
	LastReportedTimestamp *string `json:"lastReportedTimestamp,omitempty"`
	// Evidence - Evidence validating the monitor's current health state.
	Evidence interface{} `json:"evidence,omitempty"`
	// MonitorConfiguration - The configuration settings at the time of the monitor's health evaluation.
	MonitorConfiguration interface{} `json:"monitorConfiguration,omitempty"`
}

// HealthMonitorStateChange ...
type HealthMonitorStateChange struct {
	autorest.Response `json:"-"`
	// HealthMonitorStateChangeProperties - Properties of the monitor's state change.
	*HealthMonitorStateChangeProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for HealthMonitorStateChange.
func (hmsc HealthMonitorStateChange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if hmsc.HealthMonitorStateChangeProperties != nil {
		objectMap["properties"] = hmsc.HealthMonitorStateChangeProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for HealthMonitorStateChange struct.
func (hmsc *HealthMonitorStateChange) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var healthMonitorStateChangeProperties HealthMonitorStateChangeProperties
				err = json.Unmarshal(*v, &healthMonitorStateChangeProperties)
				if err != nil {
					return err
				}
				hmsc.HealthMonitorStateChangeProperties = &healthMonitorStateChangeProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				hmsc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				hmsc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				hmsc.Type = &typeVar
			}
		}
	}

	return nil
}

// HealthMonitorStateChangeList ...
type HealthMonitorStateChangeList struct {
	autorest.Response `json:"-"`
	// Value - Array of health state changes within the specified time window.
	Value *[]HealthMonitorStateChange `json:"value,omitempty"`
	// NextLink - Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`
}

// HealthMonitorStateChangeListIterator provides access to a complete listing of HealthMonitorStateChange
// values.
type HealthMonitorStateChangeListIterator struct {
	i    int
	page HealthMonitorStateChangeListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *HealthMonitorStateChangeListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthMonitorStateChangeListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *HealthMonitorStateChangeListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter HealthMonitorStateChangeListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter HealthMonitorStateChangeListIterator) Response() HealthMonitorStateChangeList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter HealthMonitorStateChangeListIterator) Value() HealthMonitorStateChange {
	if !iter.page.NotDone() {
		return HealthMonitorStateChange{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the HealthMonitorStateChangeListIterator type.
func NewHealthMonitorStateChangeListIterator(page HealthMonitorStateChangeListPage) HealthMonitorStateChangeListIterator {
	return HealthMonitorStateChangeListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (hmscl HealthMonitorStateChangeList) IsEmpty() bool {
	return hmscl.Value == nil || len(*hmscl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (hmscl HealthMonitorStateChangeList) hasNextLink() bool {
	return hmscl.NextLink != nil && len(*hmscl.NextLink) != 0
}

// healthMonitorStateChangeListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (hmscl HealthMonitorStateChangeList) healthMonitorStateChangeListPreparer(ctx context.Context) (*http.Request, error) {
	if !hmscl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(hmscl.NextLink)))
}

// HealthMonitorStateChangeListPage contains a page of HealthMonitorStateChange values.
type HealthMonitorStateChangeListPage struct {
	fn    func(context.Context, HealthMonitorStateChangeList) (HealthMonitorStateChangeList, error)
	hmscl HealthMonitorStateChangeList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *HealthMonitorStateChangeListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/HealthMonitorStateChangeListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.hmscl)
		if err != nil {
			return err
		}
		page.hmscl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *HealthMonitorStateChangeListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page HealthMonitorStateChangeListPage) NotDone() bool {
	return !page.hmscl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page HealthMonitorStateChangeListPage) Response() HealthMonitorStateChangeList {
	return page.hmscl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page HealthMonitorStateChangeListPage) Values() []HealthMonitorStateChange {
	if page.hmscl.IsEmpty() {
		return nil
	}
	return *page.hmscl.Value
}

// Creates a new instance of the HealthMonitorStateChangeListPage type.
func NewHealthMonitorStateChangeListPage(getNextPage func(context.Context, HealthMonitorStateChangeList) (HealthMonitorStateChangeList, error)) HealthMonitorStateChangeListPage {
	return HealthMonitorStateChangeListPage{fn: getNextPage}
}

// HealthMonitorStateChangeProperties properties of the monitor.
type HealthMonitorStateChangeProperties struct {
	// MonitorName - Human-readable name of the monitor.
	MonitorName *string `json:"monitorName,omitempty"`
	// MonitorType - Type of the monitor.
	MonitorType *string `json:"monitorType,omitempty"`
	// MonitoredObject - Dynamic monitored object of the monitor.
	MonitoredObject *string `json:"monitoredObject,omitempty"`
	// EvaluationTimestamp - Timestamp of the monitor's last health evaluation.
	EvaluationTimestamp *string `json:"evaluationTimestamp,omitempty"`
	// CurrentStateFirstObservedTimestamp - Timestamp of the monitor's last health state change.
	CurrentStateFirstObservedTimestamp *string `json:"currentStateFirstObservedTimestamp,omitempty"`
	// PreviousMonitorState - Previous health state of the monitor. Possible values include: 'Healthy', 'Critical', 'Warning', 'Unknown', 'Disabled', 'None'
	PreviousMonitorState HealthState `json:"previousMonitorState,omitempty"`
	// CurrentMonitorState - Current health state of the monitor. Possible values include: 'Healthy', 'Critical', 'Warning', 'Unknown', 'Disabled', 'None'
	CurrentMonitorState HealthState `json:"currentMonitorState,omitempty"`
	// Evidence - Evidence validating the monitor's current health state.
	Evidence interface{} `json:"evidence,omitempty"`
	// MonitorConfiguration - The configuration settings at the time of the monitor's health evaluation.
	MonitorConfiguration interface{} `json:"monitorConfiguration,omitempty"`
}

// Operation ...
type Operation struct {
	// Name - The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty"`
	// Display - The localized display information for this particular operation or action.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay the localized display information for this particular operation or action.
type OperationDisplay struct {
	// Provider - Operation resource provider name.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - Human-readable, friendly name for the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationList ...
type OperationList struct {
	autorest.Response `json:"-"`
	// Value - Array of available REST API operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - Link to next page if the list is too long.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListIterator provides access to a complete listing of Operation values.
type OperationListIterator struct {
	i    int
	page OperationListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListIterator) Response() OperationList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListIterator type.
func NewOperationListIterator(page OperationListPage) OperationListIterator {
	return OperationListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ol OperationList) IsEmpty() bool {
	return ol.Value == nil || len(*ol.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ol OperationList) hasNextLink() bool {
	return ol.NextLink != nil && len(*ol.NextLink) != 0
}

// operationListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ol OperationList) operationListPreparer(ctx context.Context) (*http.Request, error) {
	if !ol.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ol.NextLink)))
}

// OperationListPage contains a page of Operation values.
type OperationListPage struct {
	fn func(context.Context, OperationList) (OperationList, error)
	ol OperationList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ol)
		if err != nil {
			return err
		}
		page.ol = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListPage) NotDone() bool {
	return !page.ol.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListPage) Response() OperationList {
	return page.ol
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListPage) Values() []Operation {
	if page.ol.IsEmpty() {
		return nil
	}
	return *page.ol.Value
}

// Creates a new instance of the OperationListPage type.
func NewOperationListPage(getNextPage func(context.Context, OperationList) (OperationList, error)) OperationListPage {
	return OperationListPage{fn: getNextPage}
}

// Resource the resource model definition for the ARM proxy resource, 'microsoft.workloadmonitor/monitors'.
type Resource struct {
	// ID - READ-ONLY; The resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type.
	Type *string `json:"type,omitempty"`
}
