package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetCreditLabelAction invokes the bssopenapi.SetCreditLabelAction API synchronously
func (client *Client) SetCreditLabelAction(request *SetCreditLabelActionRequest) (response *SetCreditLabelActionResponse, err error) {
	response = CreateSetCreditLabelActionResponse()
	err = client.DoAction(request, response)
	return
}

// SetCreditLabelActionWithChan invokes the bssopenapi.SetCreditLabelAction API asynchronously
func (client *Client) SetCreditLabelActionWithChan(request *SetCreditLabelActionRequest) (<-chan *SetCreditLabelActionResponse, <-chan error) {
	responseChan := make(chan *SetCreditLabelActionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetCreditLabelAction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetCreditLabelActionWithCallback invokes the bssopenapi.SetCreditLabelAction API asynchronously
func (client *Client) SetCreditLabelActionWithCallback(request *SetCreditLabelActionRequest, callback func(response *SetCreditLabelActionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetCreditLabelActionResponse
		var err error
		defer close(result)
		response, err = client.SetCreditLabelAction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetCreditLabelActionRequest is the request struct for api SetCreditLabelAction
type SetCreditLabelActionRequest struct {
	*requests.RpcRequest
	ActionType                string           `position:"Query" name:"ActionType"`
	IsNeedSaveNotifyRule      string           `position:"Query" name:"IsNeedSaveNotifyRule"`
	IsNeedAdjustCreditAccount string           `position:"Query" name:"IsNeedAdjustCreditAccount"`
	NewCreateMode             requests.Boolean `position:"Query" name:"NewCreateMode"`
	Description               string           `position:"Query" name:"Description"`
	Source                    string           `position:"Query" name:"Source"`
	CurrencyCode              string           `position:"Query" name:"CurrencyCode"`
	DailyCycle                string           `position:"Query" name:"DailyCycle"`
	Operator                  string           `position:"Query" name:"Operator"`
	Uid                       string           `position:"Query" name:"Uid"`
	SiteCode                  string           `position:"Query" name:"SiteCode"`
	ClearCycle                string           `position:"Query" name:"ClearCycle"`
	NeedNotice                requests.Boolean `position:"Query" name:"NeedNotice"`
	RequestId                 string           `position:"Query" name:"RequestId"`
	IsNeedSetCreditAmount     string           `position:"Query" name:"IsNeedSetCreditAmount"`
	CreditAmount              string           `position:"Query" name:"CreditAmount"`
	IsNeedAddSettleLabel      string           `position:"Query" name:"IsNeedAddSettleLabel"`
}

// SetCreditLabelActionResponse is the response struct for api SetCreditLabelAction
type SetCreditLabelActionResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetCreditLabelActionRequest creates a request to invoke SetCreditLabelAction API
func CreateSetCreditLabelActionRequest() (request *SetCreditLabelActionRequest) {
	request = &SetCreditLabelActionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "SetCreditLabelAction", "", "")
	request.Method = requests.POST
	return
}

// CreateSetCreditLabelActionResponse creates a response to parse from SetCreditLabelAction response
func CreateSetCreditLabelActionResponse() (response *SetCreditLabelActionResponse) {
	response = &SetCreditLabelActionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
