package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachSceneDefenseObject invokes the ddoscoo.AttachSceneDefenseObject API synchronously
func (client *Client) AttachSceneDefenseObject(request *AttachSceneDefenseObjectRequest) (response *AttachSceneDefenseObjectResponse, err error) {
	response = CreateAttachSceneDefenseObjectResponse()
	err = client.DoAction(request, response)
	return
}

// AttachSceneDefenseObjectWithChan invokes the ddoscoo.AttachSceneDefenseObject API asynchronously
func (client *Client) AttachSceneDefenseObjectWithChan(request *AttachSceneDefenseObjectRequest) (<-chan *AttachSceneDefenseObjectResponse, <-chan error) {
	responseChan := make(chan *AttachSceneDefenseObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachSceneDefenseObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachSceneDefenseObjectWithCallback invokes the ddoscoo.AttachSceneDefenseObject API asynchronously
func (client *Client) AttachSceneDefenseObjectWithCallback(request *AttachSceneDefenseObjectRequest, callback func(response *AttachSceneDefenseObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachSceneDefenseObjectResponse
		var err error
		defer close(result)
		response, err = client.AttachSceneDefenseObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachSceneDefenseObjectRequest is the request struct for api AttachSceneDefenseObject
type AttachSceneDefenseObjectRequest struct {
	*requests.RpcRequest
	Objects    string `position:"Query" name:"Objects"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	PolicyId   string `position:"Query" name:"PolicyId"`
	ObjectType string `position:"Query" name:"ObjectType"`
}

// AttachSceneDefenseObjectResponse is the response struct for api AttachSceneDefenseObject
type AttachSceneDefenseObjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAttachSceneDefenseObjectRequest creates a request to invoke AttachSceneDefenseObject API
func CreateAttachSceneDefenseObjectRequest() (request *AttachSceneDefenseObjectRequest) {
	request = &AttachSceneDefenseObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "AttachSceneDefenseObject", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachSceneDefenseObjectResponse creates a response to parse from AttachSceneDefenseObject response
func CreateAttachSceneDefenseObjectResponse() (response *AttachSceneDefenseObjectResponse) {
	response = &AttachSceneDefenseObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
