package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfigWebIpSet invokes the ddoscoo.ConfigWebIpSet API synchronously
func (client *Client) ConfigWebIpSet(request *ConfigWebIpSetRequest) (response *ConfigWebIpSetResponse, err error) {
	response = CreateConfigWebIpSetResponse()
	err = client.DoAction(request, response)
	return
}

// ConfigWebIpSetWithChan invokes the ddoscoo.ConfigWebIpSet API asynchronously
func (client *Client) ConfigWebIpSetWithChan(request *ConfigWebIpSetRequest) (<-chan *ConfigWebIpSetResponse, <-chan error) {
	responseChan := make(chan *ConfigWebIpSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfigWebIpSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfigWebIpSetWithCallback invokes the ddoscoo.ConfigWebIpSet API asynchronously
func (client *Client) ConfigWebIpSetWithCallback(request *ConfigWebIpSetRequest, callback func(response *ConfigWebIpSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfigWebIpSetResponse
		var err error
		defer close(result)
		response, err = client.ConfigWebIpSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfigWebIpSetRequest is the request struct for api ConfigWebIpSet
type ConfigWebIpSetRequest struct {
	*requests.RpcRequest
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
	BlackList       *[]string `position:"Query" name:"BlackList"  type:"Repeated"`
	WhiteList       *[]string `position:"Query" name:"WhiteList"  type:"Repeated"`
	Domain          string    `position:"Query" name:"Domain"`
}

// ConfigWebIpSetResponse is the response struct for api ConfigWebIpSet
type ConfigWebIpSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfigWebIpSetRequest creates a request to invoke ConfigWebIpSet API
func CreateConfigWebIpSetRequest() (request *ConfigWebIpSetRequest) {
	request = &ConfigWebIpSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ConfigWebIpSet", "", "")
	request.Method = requests.POST
	return
}

// CreateConfigWebIpSetResponse creates a response to parse from ConfigWebIpSet response
func CreateConfigWebIpSetResponse() (response *ConfigWebIpSetResponse) {
	response = &ConfigWebIpSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
