package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHealthCheckConfig invokes the ddoscoo.ModifyHealthCheckConfig API synchronously
func (client *Client) ModifyHealthCheckConfig(request *ModifyHealthCheckConfigRequest) (response *ModifyHealthCheckConfigResponse, err error) {
	response = CreateModifyHealthCheckConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHealthCheckConfigWithChan invokes the ddoscoo.ModifyHealthCheckConfig API asynchronously
func (client *Client) ModifyHealthCheckConfigWithChan(request *ModifyHealthCheckConfigRequest) (<-chan *ModifyHealthCheckConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyHealthCheckConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHealthCheckConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHealthCheckConfigWithCallback invokes the ddoscoo.ModifyHealthCheckConfig API asynchronously
func (client *Client) ModifyHealthCheckConfigWithCallback(request *ModifyHealthCheckConfigRequest, callback func(response *ModifyHealthCheckConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHealthCheckConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyHealthCheckConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHealthCheckConfigRequest is the request struct for api ModifyHealthCheckConfig
type ModifyHealthCheckConfigRequest struct {
	*requests.RpcRequest
	HealthCheck     string           `position:"Query" name:"HealthCheck"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	FrontendPort    requests.Integer `position:"Query" name:"FrontendPort"`
	ForwardProtocol string           `position:"Query" name:"ForwardProtocol"`
}

// ModifyHealthCheckConfigResponse is the response struct for api ModifyHealthCheckConfig
type ModifyHealthCheckConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyHealthCheckConfigRequest creates a request to invoke ModifyHealthCheckConfig API
func CreateModifyHealthCheckConfigRequest() (request *ModifyHealthCheckConfigRequest) {
	request = &ModifyHealthCheckConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyHealthCheckConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyHealthCheckConfigResponse creates a response to parse from ModifyHealthCheckConfig response
func CreateModifyHealthCheckConfigResponse() (response *ModifyHealthCheckConfigResponse) {
	response = &ModifyHealthCheckConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
