package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetDisk invokes the ecs.ResetDisk API synchronously
func (client *Client) ResetDisk(request *ResetDiskRequest) (response *ResetDiskResponse, err error) {
	response = CreateResetDiskResponse()
	err = client.DoAction(request, response)
	return
}

// ResetDiskWithChan invokes the ecs.ResetDisk API asynchronously
func (client *Client) ResetDiskWithChan(request *ResetDiskRequest) (<-chan *ResetDiskResponse, <-chan error) {
	responseChan := make(chan *ResetDiskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetDisk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetDiskWithCallback invokes the ecs.ResetDisk API asynchronously
func (client *Client) ResetDiskWithCallback(request *ResetDiskRequest, callback func(response *ResetDiskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetDiskResponse
		var err error
		defer close(result)
		response, err = client.ResetDisk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetDiskRequest is the request struct for api ResetDisk
type ResetDiskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SnapshotId           string           `position:"Query" name:"SnapshotId"`
	DiskId               string           `position:"Query" name:"DiskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ResetDiskResponse is the response struct for api ResetDisk
type ResetDiskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetDiskRequest creates a request to invoke ResetDisk API
func CreateResetDiskRequest() (request *ResetDiskRequest) {
	request = &ResetDiskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ResetDisk", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetDiskResponse creates a response to parse from ResetDisk response
func CreateResetDiskResponse() (response *ResetDiskResponse) {
	response = &ResetDiskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
