package parse

// NOTE: this file is generated via 'go:generate' - manual changes will be overwritten

import (
	"fmt"
	"strings"

	"github.com/terraform-providers/terraform-provider-azurerm/azurerm/helpers/azure"
)

type ServerVulnerabilityAssessmentId struct {
	SubscriptionId              string
	ResourceGroup               string
	ServerName                  string
	VulnerabilityAssessmentName string
}

func NewServerVulnerabilityAssessmentID(subscriptionId, resourceGroup, serverName, vulnerabilityAssessmentName string) ServerVulnerabilityAssessmentId {
	return ServerVulnerabilityAssessmentId{
		SubscriptionId:              subscriptionId,
		ResourceGroup:               resourceGroup,
		ServerName:                  serverName,
		VulnerabilityAssessmentName: vulnerabilityAssessmentName,
	}
}

func (id ServerVulnerabilityAssessmentId) String() string {
	segments := []string{
		fmt.Sprintf("Vulnerability Assessment Name %q", id.VulnerabilityAssessmentName),
		fmt.Sprintf("Server Name %q", id.ServerName),
		fmt.Sprintf("Resource Group %q", id.ResourceGroup),
	}
	segmentsStr := strings.Join(segments, " / ")
	return fmt.Sprintf("%s: (%s)", "Server Vulnerability Assessment", segmentsStr)
}

func (id ServerVulnerabilityAssessmentId) ID() string {
	fmtString := "/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Sql/servers/%s/vulnerabilityAssessments/%s"
	return fmt.Sprintf(fmtString, id.SubscriptionId, id.ResourceGroup, id.ServerName, id.VulnerabilityAssessmentName)
}

// ServerVulnerabilityAssessmentID parses a ServerVulnerabilityAssessment ID into an ServerVulnerabilityAssessmentId struct
func ServerVulnerabilityAssessmentID(input string) (*ServerVulnerabilityAssessmentId, error) {
	id, err := azure.ParseAzureResourceID(input)
	if err != nil {
		return nil, err
	}

	resourceId := ServerVulnerabilityAssessmentId{
		SubscriptionId: id.SubscriptionID,
		ResourceGroup:  id.ResourceGroup,
	}

	if resourceId.SubscriptionId == "" {
		return nil, fmt.Errorf("ID was missing the 'subscriptions' element")
	}

	if resourceId.ResourceGroup == "" {
		return nil, fmt.Errorf("ID was missing the 'resourceGroups' element")
	}

	if resourceId.ServerName, err = id.PopSegment("servers"); err != nil {
		return nil, err
	}
	if resourceId.VulnerabilityAssessmentName, err = id.PopSegment("vulnerabilityAssessments"); err != nil {
		return nil, err
	}

	if err := id.ValidateNoEmptySegments(input); err != nil {
		return nil, err
	}

	return &resourceId, nil
}
