// Code generated by go-swagger; DO NOT EDIT.

package authentication

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/swag"

	strfmt "github.com/go-openapi/strfmt"

	models "github.com/IBM-Cloud/power-go-client/power/models"
)

// ServiceBrokerAuthDeviceTokenPostReader is a Reader for the ServiceBrokerAuthDeviceTokenPost structure.
type ServiceBrokerAuthDeviceTokenPostReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServiceBrokerAuthDeviceTokenPostReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 200:
		result := NewServiceBrokerAuthDeviceTokenPostOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewServiceBrokerAuthDeviceTokenPostBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 403:
		result := NewServiceBrokerAuthDeviceTokenPostForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 429:
		result := NewServiceBrokerAuthDeviceTokenPostTooManyRequests()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	case 500:
		result := NewServiceBrokerAuthDeviceTokenPostInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		return nil, runtime.NewAPIError("unknown error", response, response.Code())
	}
}

// NewServiceBrokerAuthDeviceTokenPostOK creates a ServiceBrokerAuthDeviceTokenPostOK with default headers values
func NewServiceBrokerAuthDeviceTokenPostOK() *ServiceBrokerAuthDeviceTokenPostOK {
	return &ServiceBrokerAuthDeviceTokenPostOK{}
}

/*ServiceBrokerAuthDeviceTokenPostOK handles this case with default header values.

OK
*/
type ServiceBrokerAuthDeviceTokenPostOK struct {
	Payload *models.Token
}

func (o *ServiceBrokerAuthDeviceTokenPostOK) Error() string {
	return fmt.Sprintf("[POST /auth/v1/device/token][%d] serviceBrokerAuthDeviceTokenPostOK  %+v", 200, o.Payload)
}

func (o *ServiceBrokerAuthDeviceTokenPostOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Token)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceBrokerAuthDeviceTokenPostBadRequest creates a ServiceBrokerAuthDeviceTokenPostBadRequest with default headers values
func NewServiceBrokerAuthDeviceTokenPostBadRequest() *ServiceBrokerAuthDeviceTokenPostBadRequest {
	return &ServiceBrokerAuthDeviceTokenPostBadRequest{}
}

/*ServiceBrokerAuthDeviceTokenPostBadRequest handles this case with default header values.

Authorization pending
*/
type ServiceBrokerAuthDeviceTokenPostBadRequest struct {
	Payload *models.Error
}

func (o *ServiceBrokerAuthDeviceTokenPostBadRequest) Error() string {
	return fmt.Sprintf("[POST /auth/v1/device/token][%d] serviceBrokerAuthDeviceTokenPostBadRequest  %+v", 400, o.Payload)
}

func (o *ServiceBrokerAuthDeviceTokenPostBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceBrokerAuthDeviceTokenPostForbidden creates a ServiceBrokerAuthDeviceTokenPostForbidden with default headers values
func NewServiceBrokerAuthDeviceTokenPostForbidden() *ServiceBrokerAuthDeviceTokenPostForbidden {
	return &ServiceBrokerAuthDeviceTokenPostForbidden{}
}

/*ServiceBrokerAuthDeviceTokenPostForbidden handles this case with default header values.

User refused grant
*/
type ServiceBrokerAuthDeviceTokenPostForbidden struct {
	Payload *models.Error
}

func (o *ServiceBrokerAuthDeviceTokenPostForbidden) Error() string {
	return fmt.Sprintf("[POST /auth/v1/device/token][%d] serviceBrokerAuthDeviceTokenPostForbidden  %+v", 403, o.Payload)
}

func (o *ServiceBrokerAuthDeviceTokenPostForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceBrokerAuthDeviceTokenPostTooManyRequests creates a ServiceBrokerAuthDeviceTokenPostTooManyRequests with default headers values
func NewServiceBrokerAuthDeviceTokenPostTooManyRequests() *ServiceBrokerAuthDeviceTokenPostTooManyRequests {
	return &ServiceBrokerAuthDeviceTokenPostTooManyRequests{}
}

/*ServiceBrokerAuthDeviceTokenPostTooManyRequests handles this case with default header values.

Polling too frequently
*/
type ServiceBrokerAuthDeviceTokenPostTooManyRequests struct {
	Payload *models.Error
}

func (o *ServiceBrokerAuthDeviceTokenPostTooManyRequests) Error() string {
	return fmt.Sprintf("[POST /auth/v1/device/token][%d] serviceBrokerAuthDeviceTokenPostTooManyRequests  %+v", 429, o.Payload)
}

func (o *ServiceBrokerAuthDeviceTokenPostTooManyRequests) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServiceBrokerAuthDeviceTokenPostInternalServerError creates a ServiceBrokerAuthDeviceTokenPostInternalServerError with default headers values
func NewServiceBrokerAuthDeviceTokenPostInternalServerError() *ServiceBrokerAuthDeviceTokenPostInternalServerError {
	return &ServiceBrokerAuthDeviceTokenPostInternalServerError{}
}

/*ServiceBrokerAuthDeviceTokenPostInternalServerError handles this case with default header values.

Internal Server Error
*/
type ServiceBrokerAuthDeviceTokenPostInternalServerError struct {
	Payload *models.Error
}

func (o *ServiceBrokerAuthDeviceTokenPostInternalServerError) Error() string {
	return fmt.Sprintf("[POST /auth/v1/device/token][%d] serviceBrokerAuthDeviceTokenPostInternalServerError  %+v", 500, o.Payload)
}

func (o *ServiceBrokerAuthDeviceTokenPostInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*ServiceBrokerAuthDeviceTokenPostBody service broker auth device token post body
swagger:model ServiceBrokerAuthDeviceTokenPostBody
*/
type ServiceBrokerAuthDeviceTokenPostBody struct {

	// The deviceCode that the authorization server returned
	DeviceCode string `json:"deviceCode,omitempty"`
}

// Validate validates this service broker auth device token post body
func (o *ServiceBrokerAuthDeviceTokenPostBody) Validate(formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ServiceBrokerAuthDeviceTokenPostBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ServiceBrokerAuthDeviceTokenPostBody) UnmarshalBinary(b []byte) error {
	var res ServiceBrokerAuthDeviceTokenPostBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
