// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Token token
// swagger:model Token
type Token struct {

	// AccessToken
	// Required: true
	AccessToken *string `json:"accessToken"`

	// Token Expires
	// Required: true
	// Format: date-time
	Expires *strfmt.DateTime `json:"expires"`

	// Refresh Token
	// Required: true
	RefreshToken *string `json:"refreshToken"`

	// Token Type
	// Required: true
	Type *string `json:"type"`
}

// Validate validates this token
func (m *Token) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpires(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRefreshToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Token) validateAccessToken(formats strfmt.Registry) error {

	if err := validate.Required("accessToken", "body", m.AccessToken); err != nil {
		return err
	}

	return nil
}

func (m *Token) validateExpires(formats strfmt.Registry) error {

	if err := validate.Required("expires", "body", m.Expires); err != nil {
		return err
	}

	if err := validate.FormatOf("expires", "body", "date-time", m.Expires.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Token) validateRefreshToken(formats strfmt.Registry) error {

	if err := validate.Required("refreshToken", "body", m.RefreshToken); err != nil {
		return err
	}

	return nil
}

func (m *Token) validateType(formats strfmt.Registry) error {

	if err := validate.Required("type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Token) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Token) UnmarshalBinary(b []byte) error {
	var res Token
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
