package bootkube

import (
	"os"
	"path/filepath"

	"github.com/openshift/installer/pkg/asset"
	"github.com/openshift/installer/pkg/asset/templates/content"
)

const (
	hostEtcdServiceEndpointsKubeSystemFileName = "host-etcd-service-endpoints.yaml.template"
)

var _ asset.WritableAsset = (*HostEtcdServiceEndpointsKubeSystem)(nil)

// HostEtcdServiceEndpointsKubeSystem is the constant to represent contents of etcd-service-endpoints.yaml.template file.
type HostEtcdServiceEndpointsKubeSystem struct {
	FileList []*asset.File
}

// Dependencies returns all of the dependencies directly needed by the asset
func (t *HostEtcdServiceEndpointsKubeSystem) Dependencies() []asset.Asset {
	return []asset.Asset{}
}

// Name returns the human-friendly name of the asset.
func (t *HostEtcdServiceEndpointsKubeSystem) Name() string {
	return "HostEtcdServiceEndpointsKubeSystem"
}

// Generate generates the actual files by this asset
func (t *HostEtcdServiceEndpointsKubeSystem) Generate(parents asset.Parents) error {
	fileName := hostEtcdServiceEndpointsKubeSystemFileName
	data, err := content.GetBootkubeTemplate(fileName)
	if err != nil {
		return err
	}
	t.FileList = []*asset.File{
		{
			Filename: filepath.Join(content.TemplateDir, fileName),
			Data:     []byte(data),
		},
	}
	return nil
}

// Files returns the files generated by the asset.
func (t *HostEtcdServiceEndpointsKubeSystem) Files() []*asset.File {
	return t.FileList
}

// Load returns the asset from disk.
func (t *HostEtcdServiceEndpointsKubeSystem) Load(f asset.FileFetcher) (bool, error) {
	file, err := f.FetchByName(filepath.Join(content.TemplateDir, hostEtcdServiceEndpointsKubeSystemFileName))
	if err != nil {
		if os.IsNotExist(err) {
			return false, nil
		}
		return false, err
	}
	t.FileList = []*asset.File{file}
	return true, nil
}
