// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/apiserver/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// APIRequestCountLister helps list APIRequestCounts.
// All objects returned here must be treated as read-only.
type APIRequestCountLister interface {
	// List lists all APIRequestCounts in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.APIRequestCount, err error)
	// Get retrieves the APIRequestCount from the index for a given name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.APIRequestCount, error)
	APIRequestCountListerExpansion
}

// aPIRequestCountLister implements the APIRequestCountLister interface.
type aPIRequestCountLister struct {
	indexer cache.Indexer
}

// NewAPIRequestCountLister returns a new APIRequestCountLister.
func NewAPIRequestCountLister(indexer cache.Indexer) APIRequestCountLister {
	return &aPIRequestCountLister{indexer: indexer}
}

// List lists all APIRequestCounts in the indexer.
func (s *aPIRequestCountLister) List(selector labels.Selector) (ret []*v1.APIRequestCount, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.APIRequestCount))
	})
	return ret, err
}

// Get retrieves the APIRequestCount from the index for a given name.
func (s *aPIRequestCountLister) Get(name string) (*v1.APIRequestCount, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("apirequestcount"), name)
	}
	return obj.(*v1.APIRequestCount), nil
}
