package ram

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLoginProfile invokes the ram.DeleteLoginProfile API synchronously
// api document: https://help.aliyun.com/api/ram/deleteloginprofile.html
func (client *Client) DeleteLoginProfile(request *DeleteLoginProfileRequest) (response *DeleteLoginProfileResponse, err error) {
	response = CreateDeleteLoginProfileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLoginProfileWithChan invokes the ram.DeleteLoginProfile API asynchronously
// api document: https://help.aliyun.com/api/ram/deleteloginprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLoginProfileWithChan(request *DeleteLoginProfileRequest) (<-chan *DeleteLoginProfileResponse, <-chan error) {
	responseChan := make(chan *DeleteLoginProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLoginProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLoginProfileWithCallback invokes the ram.DeleteLoginProfile API asynchronously
// api document: https://help.aliyun.com/api/ram/deleteloginprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLoginProfileWithCallback(request *DeleteLoginProfileRequest, callback func(response *DeleteLoginProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLoginProfileResponse
		var err error
		defer close(result)
		response, err = client.DeleteLoginProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLoginProfileRequest is the request struct for api DeleteLoginProfile
type DeleteLoginProfileRequest struct {
	*requests.RpcRequest
	UserName string `position:"Query" name:"UserName"`
}

// DeleteLoginProfileResponse is the response struct for api DeleteLoginProfile
type DeleteLoginProfileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLoginProfileRequest creates a request to invoke DeleteLoginProfile API
func CreateDeleteLoginProfileRequest() (request *DeleteLoginProfileRequest) {
	request = &DeleteLoginProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ram", "2015-05-01", "DeleteLoginProfile", "Ram", "openAPI")
	return
}

// CreateDeleteLoginProfileResponse creates a response to parse from DeleteLoginProfile response
func CreateDeleteLoginProfileResponse() (response *DeleteLoginProfileResponse) {
	response = &DeleteLoginProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
