// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchCreateVariable = "BatchCreateVariable"

// BatchCreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateVariable for more information on using the BatchCreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateVariableRequest method.
//    req, resp := client.BatchCreateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariableRequest(input *BatchCreateVariableInput) (req *request.Request, output *BatchCreateVariableOutput) {
	op := &request.Operation{
		Name:       opBatchCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchCreateVariableInput{}
	}

	output = &BatchCreateVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateVariable API operation for Amazon Fraud Detector.
//
// Creates a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchCreateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable
func (c *FraudDetector) BatchCreateVariable(input *BatchCreateVariableInput) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	return out, req.Send()
}

// BatchCreateVariableWithContext is the same as BatchCreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchCreateVariableWithContext(ctx aws.Context, input *BatchCreateVariableInput, opts ...request.Option) (*BatchCreateVariableOutput, error) {
	req, out := c.BatchCreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetVariable = "BatchGetVariable"

// BatchGetVariableRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetVariable for more information on using the BatchGetVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetVariableRequest method.
//    req, resp := client.BatchGetVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariableRequest(input *BatchGetVariableInput) (req *request.Request, output *BatchGetVariableOutput) {
	op := &request.Operation{
		Name:       opBatchGetVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetVariableInput{}
	}

	output = &BatchGetVariableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetVariable API operation for Amazon Fraud Detector.
//
// Gets a batch of variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation BatchGetVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable
func (c *FraudDetector) BatchGetVariable(input *BatchGetVariableInput) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	return out, req.Send()
}

// BatchGetVariableWithContext is the same as BatchGetVariable with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) BatchGetVariableWithContext(ctx aws.Context, input *BatchGetVariableInput, opts ...request.Option) (*BatchGetVariableOutput, error) {
	req, out := c.BatchGetVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDetectorVersion = "CreateDetectorVersion"

// CreateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDetectorVersion for more information on using the CreateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDetectorVersionRequest method.
//    req, resp := client.CreateDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersionRequest(input *CreateDetectorVersionInput) (req *request.Request, output *CreateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opCreateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDetectorVersionInput{}
	}

	output = &CreateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDetectorVersion API operation for Amazon Fraud Detector.
//
// Creates a detector version. The detector version starts in a DRAFT status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion
func (c *FraudDetector) CreateDetectorVersion(input *CreateDetectorVersionInput) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	return out, req.Send()
}

// CreateDetectorVersionWithContext is the same as CreateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateDetectorVersionWithContext(ctx aws.Context, input *CreateDetectorVersionInput, opts ...request.Option) (*CreateDetectorVersionOutput, error) {
	req, out := c.CreateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModelVersion = "CreateModelVersion"

// CreateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModelVersion for more information on using the CreateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelVersionRequest method.
//    req, resp := client.CreateModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersionRequest(input *CreateModelVersionInput) (req *request.Request, output *CreateModelVersionOutput) {
	op := &request.Operation{
		Name:       opCreateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateModelVersionInput{}
	}

	output = &CreateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModelVersion API operation for Amazon Fraud Detector.
//
// Creates a version of the model using the specified model type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion
func (c *FraudDetector) CreateModelVersion(input *CreateModelVersionInput) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	return out, req.Send()
}

// CreateModelVersionWithContext is the same as CreateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateModelVersionWithContext(ctx aws.Context, input *CreateModelVersionInput, opts ...request.Option) (*CreateModelVersionOutput, error) {
	req, out := c.CreateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon Fraud Detector.
//
// Creates a rule for use with the specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule
func (c *FraudDetector) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVariable = "CreateVariable"

// CreateVariableRequest generates a "aws/request.Request" representing the
// client's request for the CreateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVariable for more information on using the CreateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVariableRequest method.
//    req, resp := client.CreateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariableRequest(input *CreateVariableInput) (req *request.Request, output *CreateVariableOutput) {
	op := &request.Operation{
		Name:       opCreateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVariableInput{}
	}

	output = &CreateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateVariable API operation for Amazon Fraud Detector.
//
// Creates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation CreateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable
func (c *FraudDetector) CreateVariable(input *CreateVariableInput) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	return out, req.Send()
}

// CreateVariableWithContext is the same as CreateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) CreateVariableWithContext(ctx aws.Context, input *CreateVariableInput, opts ...request.Option) (*CreateVariableOutput, error) {
	req, out := c.CreateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDetectorVersion = "DeleteDetectorVersion"

// DeleteDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDetectorVersion for more information on using the DeleteDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDetectorVersionRequest method.
//    req, resp := client.DeleteDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersionRequest(input *DeleteDetectorVersionInput) (req *request.Request, output *DeleteDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDetectorVersionInput{}
	}

	output = &DeleteDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDetectorVersion API operation for Amazon Fraud Detector.
//
// Deletes the detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion
func (c *FraudDetector) DeleteDetectorVersion(input *DeleteDetectorVersionInput) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	return out, req.Send()
}

// DeleteDetectorVersionWithContext is the same as DeleteDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteDetectorVersionWithContext(ctx aws.Context, input *DeleteDetectorVersionInput, opts ...request.Option) (*DeleteDetectorVersionOutput, error) {
	req, out := c.DeleteDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvent = "DeleteEvent"

// DeleteEventRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvent for more information on using the DeleteEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventRequest method.
//    req, resp := client.DeleteEventRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEventRequest(input *DeleteEventInput) (req *request.Request, output *DeleteEventOutput) {
	op := &request.Operation{
		Name:       opDeleteEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventInput{}
	}

	output = &DeleteEventOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvent API operation for Amazon Fraud Detector.
//
// Deletes the specified event.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DeleteEvent for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent
func (c *FraudDetector) DeleteEvent(input *DeleteEventInput) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	return out, req.Send()
}

// DeleteEventWithContext is the same as DeleteEvent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DeleteEventWithContext(ctx aws.Context, input *DeleteEventInput, opts ...request.Option) (*DeleteEventOutput, error) {
	req, out := c.DeleteEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDetector = "DescribeDetector"

// DescribeDetectorRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDetector for more information on using the DescribeDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDetectorRequest method.
//    req, resp := client.DescribeDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetectorRequest(input *DescribeDetectorInput) (req *request.Request, output *DescribeDetectorOutput) {
	op := &request.Operation{
		Name:       opDescribeDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDetectorInput{}
	}

	output = &DescribeDetectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDetector API operation for Amazon Fraud Detector.
//
// Gets all versions for a specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector
func (c *FraudDetector) DescribeDetector(input *DescribeDetectorInput) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	return out, req.Send()
}

// DescribeDetectorWithContext is the same as DescribeDetector with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeDetectorWithContext(ctx aws.Context, input *DescribeDetectorInput, opts ...request.Option) (*DescribeDetectorOutput, error) {
	req, out := c.DescribeDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeModelVersions = "DescribeModelVersions"

// DescribeModelVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeModelVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeModelVersions for more information on using the DescribeModelVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeModelVersionsRequest method.
//    req, resp := client.DescribeModelVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersionsRequest(input *DescribeModelVersionsInput) (req *request.Request, output *DescribeModelVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeModelVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeModelVersionsInput{}
	}

	output = &DescribeModelVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeModelVersions API operation for Amazon Fraud Detector.
//
// Gets all of the model versions for the specified model type or for the specified
// model type and model ID. You can also get details for a single, specified
// model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation DescribeModelVersions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions
func (c *FraudDetector) DescribeModelVersions(input *DescribeModelVersionsInput) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	return out, req.Send()
}

// DescribeModelVersionsWithContext is the same as DescribeModelVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeModelVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsWithContext(ctx aws.Context, input *DescribeModelVersionsInput, opts ...request.Option) (*DescribeModelVersionsOutput, error) {
	req, out := c.DescribeModelVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeModelVersionsPages iterates over the pages of a DescribeModelVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeModelVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeModelVersions operation.
//    pageNum := 0
//    err := client.DescribeModelVersionsPages(params,
//        func(page *frauddetector.DescribeModelVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) DescribeModelVersionsPages(input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool) error {
	return c.DescribeModelVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeModelVersionsPagesWithContext same as DescribeModelVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) DescribeModelVersionsPagesWithContext(ctx aws.Context, input *DescribeModelVersionsInput, fn func(*DescribeModelVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeModelVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeModelVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeModelVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDetectorVersion = "GetDetectorVersion"

// GetDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectorVersion for more information on using the GetDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorVersionRequest method.
//    req, resp := client.GetDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersionRequest(input *GetDetectorVersionInput) (req *request.Request, output *GetDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opGetDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDetectorVersionInput{}
	}

	output = &GetDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectorVersion API operation for Amazon Fraud Detector.
//
// Gets a particular detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion
func (c *FraudDetector) GetDetectorVersion(input *GetDetectorVersionInput) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	return out, req.Send()
}

// GetDetectorVersionWithContext is the same as GetDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorVersionWithContext(ctx aws.Context, input *GetDetectorVersionInput, opts ...request.Option) (*GetDetectorVersionOutput, error) {
	req, out := c.GetDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDetectors = "GetDetectors"

// GetDetectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetDetectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDetectors for more information on using the GetDetectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDetectorsRequest method.
//    req, resp := client.GetDetectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectorsRequest(input *GetDetectorsInput) (req *request.Request, output *GetDetectorsOutput) {
	op := &request.Operation{
		Name:       opGetDetectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDetectorsInput{}
	}

	output = &GetDetectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDetectors API operation for Amazon Fraud Detector.
//
// Gets all of detectors. This is a paginated API. If you provide a null maxSizePerPage,
// this actions retrieves a maximum of 10 records per page. If you provide a
// maxSizePerPage, the value must be between 5 and 10. To get the next page
// results, provide the pagination token from the GetEventTypesResponse as part
// of your request. A null pagination token fetches the records from the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetDetectors for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors
func (c *FraudDetector) GetDetectors(input *GetDetectorsInput) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	return out, req.Send()
}

// GetDetectorsWithContext is the same as GetDetectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetDetectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsWithContext(ctx aws.Context, input *GetDetectorsInput, opts ...request.Option) (*GetDetectorsOutput, error) {
	req, out := c.GetDetectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDetectorsPages iterates over the pages of a GetDetectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDetectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDetectors operation.
//    pageNum := 0
//    err := client.GetDetectorsPages(params,
//        func(page *frauddetector.GetDetectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetDetectorsPages(input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool) error {
	return c.GetDetectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDetectorsPagesWithContext same as GetDetectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetDetectorsPagesWithContext(ctx aws.Context, input *GetDetectorsInput, fn func(*GetDetectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDetectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDetectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDetectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetExternalModels = "GetExternalModels"

// GetExternalModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetExternalModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExternalModels for more information on using the GetExternalModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExternalModelsRequest method.
//    req, resp := client.GetExternalModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModelsRequest(input *GetExternalModelsInput) (req *request.Request, output *GetExternalModelsOutput) {
	op := &request.Operation{
		Name:       opGetExternalModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetExternalModelsInput{}
	}

	output = &GetExternalModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExternalModels API operation for Amazon Fraud Detector.
//
// Gets the details for one or more Amazon SageMaker models that have been imported
// into the service. This is a paginated API. If you provide a null maxSizePerPage,
// this actions retrieves a maximum of 10 records per page. If you provide a
// maxSizePerPage, the value must be between 5 and 10. To get the next page
// results, provide the pagination token from the GetExternalModelsResult as
// part of your request. A null pagination token fetches the records from the
// beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetExternalModels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels
func (c *FraudDetector) GetExternalModels(input *GetExternalModelsInput) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	return out, req.Send()
}

// GetExternalModelsWithContext is the same as GetExternalModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetExternalModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsWithContext(ctx aws.Context, input *GetExternalModelsInput, opts ...request.Option) (*GetExternalModelsOutput, error) {
	req, out := c.GetExternalModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetExternalModelsPages iterates over the pages of a GetExternalModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetExternalModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetExternalModels operation.
//    pageNum := 0
//    err := client.GetExternalModelsPages(params,
//        func(page *frauddetector.GetExternalModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetExternalModelsPages(input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool) error {
	return c.GetExternalModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetExternalModelsPagesWithContext same as GetExternalModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetExternalModelsPagesWithContext(ctx aws.Context, input *GetExternalModelsInput, fn func(*GetExternalModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetExternalModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetExternalModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetExternalModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetModelVersion = "GetModelVersion"

// GetModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelVersion for more information on using the GetModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelVersionRequest method.
//    req, resp := client.GetModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersionRequest(input *GetModelVersionInput) (req *request.Request, output *GetModelVersionOutput) {
	op := &request.Operation{
		Name:       opGetModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetModelVersionInput{}
	}

	output = &GetModelVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelVersion API operation for Amazon Fraud Detector.
//
// Gets a model version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion
func (c *FraudDetector) GetModelVersion(input *GetModelVersionInput) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	return out, req.Send()
}

// GetModelVersionWithContext is the same as GetModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelVersionWithContext(ctx aws.Context, input *GetModelVersionInput, opts ...request.Option) (*GetModelVersionOutput, error) {
	req, out := c.GetModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModels = "GetModels"

// GetModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModels for more information on using the GetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelsRequest method.
//    req, resp := client.GetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	output = &GetModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModels API operation for Amazon Fraud Detector.
//
// Gets all of the models for the AWS account, or the specified model type,
// or gets a single model for the specified model type, model ID combination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetModels for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels
func (c *FraudDetector) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	return out, req.Send()
}

// GetModelsWithContext is the same as GetModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsWithContext(ctx aws.Context, input *GetModelsInput, opts ...request.Option) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetModelsPages iterates over the pages of a GetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetModels operation.
//    pageNum := 0
//    err := client.GetModelsPages(params,
//        func(page *frauddetector.GetModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetModelsPages(input *GetModelsInput, fn func(*GetModelsOutput, bool) bool) error {
	return c.GetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetModelsPagesWithContext same as GetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetModelsPagesWithContext(ctx aws.Context, input *GetModelsInput, fn func(*GetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetOutcomes = "GetOutcomes"

// GetOutcomesRequest generates a "aws/request.Request" representing the
// client's request for the GetOutcomes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutcomes for more information on using the GetOutcomes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutcomesRequest method.
//    req, resp := client.GetOutcomesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomesRequest(input *GetOutcomesInput) (req *request.Request, output *GetOutcomesOutput) {
	op := &request.Operation{
		Name:       opGetOutcomes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetOutcomesInput{}
	}

	output = &GetOutcomesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutcomes API operation for Amazon Fraud Detector.
//
// Gets one or more outcomes. This is a paginated API. If you provide a null
// maxSizePerPage, this actions retrieves a maximum of 10 records per page.
// If you provide a maxSizePerPage, the value must be between 50 and 100. To
// get the next page results, provide the pagination token from the GetOutcomesResult
// as part of your request. A null pagination token fetches the records from
// the beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetOutcomes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes
func (c *FraudDetector) GetOutcomes(input *GetOutcomesInput) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	return out, req.Send()
}

// GetOutcomesWithContext is the same as GetOutcomes with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutcomes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesWithContext(ctx aws.Context, input *GetOutcomesInput, opts ...request.Option) (*GetOutcomesOutput, error) {
	req, out := c.GetOutcomesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetOutcomesPages iterates over the pages of a GetOutcomes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetOutcomes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetOutcomes operation.
//    pageNum := 0
//    err := client.GetOutcomesPages(params,
//        func(page *frauddetector.GetOutcomesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetOutcomesPages(input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool) error {
	return c.GetOutcomesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetOutcomesPagesWithContext same as GetOutcomesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetOutcomesPagesWithContext(ctx aws.Context, input *GetOutcomesInput, fn func(*GetOutcomesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetOutcomesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetOutcomesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetOutcomesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetPrediction = "GetPrediction"

// GetPredictionRequest generates a "aws/request.Request" representing the
// client's request for the GetPrediction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPrediction for more information on using the GetPrediction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPredictionRequest method.
//    req, resp := client.GetPredictionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetPrediction
func (c *FraudDetector) GetPredictionRequest(input *GetPredictionInput) (req *request.Request, output *GetPredictionOutput) {
	op := &request.Operation{
		Name:       opGetPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPredictionInput{}
	}

	output = &GetPredictionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPrediction API operation for Amazon Fraud Detector.
//
// Evaluates an event against a detector version. If a version ID is not provided,
// the detector’s (ACTIVE) version is used.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetPrediction for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetPrediction
func (c *FraudDetector) GetPrediction(input *GetPredictionInput) (*GetPredictionOutput, error) {
	req, out := c.GetPredictionRequest(input)
	return out, req.Send()
}

// GetPredictionWithContext is the same as GetPrediction with the addition of
// the ability to pass a context and additional request options.
//
// See GetPrediction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetPredictionWithContext(ctx aws.Context, input *GetPredictionInput, opts ...request.Option) (*GetPredictionOutput, error) {
	req, out := c.GetPredictionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRules = "GetRules"

// GetRulesRequest generates a "aws/request.Request" representing the
// client's request for the GetRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRules for more information on using the GetRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRulesRequest method.
//    req, resp := client.GetRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRulesRequest(input *GetRulesInput) (req *request.Request, output *GetRulesOutput) {
	op := &request.Operation{
		Name:       opGetRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRulesInput{}
	}

	output = &GetRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRules API operation for Amazon Fraud Detector.
//
// Gets all rules available for the specified detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetRules for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules
func (c *FraudDetector) GetRules(input *GetRulesInput) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	return out, req.Send()
}

// GetRulesWithContext is the same as GetRules with the addition of
// the ability to pass a context and additional request options.
//
// See GetRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesWithContext(ctx aws.Context, input *GetRulesInput, opts ...request.Option) (*GetRulesOutput, error) {
	req, out := c.GetRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetRulesPages iterates over the pages of a GetRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetRules operation.
//    pageNum := 0
//    err := client.GetRulesPages(params,
//        func(page *frauddetector.GetRulesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetRulesPages(input *GetRulesInput, fn func(*GetRulesOutput, bool) bool) error {
	return c.GetRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetRulesPagesWithContext same as GetRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetRulesPagesWithContext(ctx aws.Context, input *GetRulesInput, fn func(*GetRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetVariables = "GetVariables"

// GetVariablesRequest generates a "aws/request.Request" representing the
// client's request for the GetVariables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVariables for more information on using the GetVariables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVariablesRequest method.
//    req, resp := client.GetVariablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariablesRequest(input *GetVariablesInput) (req *request.Request, output *GetVariablesOutput) {
	op := &request.Operation{
		Name:       opGetVariables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVariablesInput{}
	}

	output = &GetVariablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVariables API operation for Amazon Fraud Detector.
//
// Gets all of the variables or the specific variable. This is a paginated API.
// Providing null maxSizePerPage results in retrieving maximum of 100 records
// per page. If you provide maxSizePerPage the value must be between 50 and
// 100. To get the next page result, a provide a pagination token from GetVariablesResult
// as part of your request. Null pagination token fetches the records from the
// beginning.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation GetVariables for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables
func (c *FraudDetector) GetVariables(input *GetVariablesInput) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	return out, req.Send()
}

// GetVariablesWithContext is the same as GetVariables with the addition of
// the ability to pass a context and additional request options.
//
// See GetVariables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesWithContext(ctx aws.Context, input *GetVariablesInput, opts ...request.Option) (*GetVariablesOutput, error) {
	req, out := c.GetVariablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetVariablesPages iterates over the pages of a GetVariables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetVariables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetVariables operation.
//    pageNum := 0
//    err := client.GetVariablesPages(params,
//        func(page *frauddetector.GetVariablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *FraudDetector) GetVariablesPages(input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool) error {
	return c.GetVariablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetVariablesPagesWithContext same as GetVariablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) GetVariablesPagesWithContext(ctx aws.Context, input *GetVariablesInput, fn func(*GetVariablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetVariablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVariablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetVariablesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutDetector = "PutDetector"

// PutDetectorRequest generates a "aws/request.Request" representing the
// client's request for the PutDetector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutDetector for more information on using the PutDetector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutDetectorRequest method.
//    req, resp := client.PutDetectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetectorRequest(input *PutDetectorInput) (req *request.Request, output *PutDetectorOutput) {
	op := &request.Operation{
		Name:       opPutDetector,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutDetectorInput{}
	}

	output = &PutDetectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutDetector API operation for Amazon Fraud Detector.
//
// Creates or updates a detector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutDetector for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector
func (c *FraudDetector) PutDetector(input *PutDetectorInput) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	return out, req.Send()
}

// PutDetectorWithContext is the same as PutDetector with the addition of
// the ability to pass a context and additional request options.
//
// See PutDetector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutDetectorWithContext(ctx aws.Context, input *PutDetectorInput, opts ...request.Option) (*PutDetectorOutput, error) {
	req, out := c.PutDetectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutExternalModel = "PutExternalModel"

// PutExternalModelRequest generates a "aws/request.Request" representing the
// client's request for the PutExternalModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutExternalModel for more information on using the PutExternalModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutExternalModelRequest method.
//    req, resp := client.PutExternalModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModelRequest(input *PutExternalModelInput) (req *request.Request, output *PutExternalModelOutput) {
	op := &request.Operation{
		Name:       opPutExternalModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutExternalModelInput{}
	}

	output = &PutExternalModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutExternalModel API operation for Amazon Fraud Detector.
//
// Creates or updates an Amazon SageMaker model endpoint. You can also use this
// action to update the configuration of the model endpoint, including the IAM
// role and/or the mapped variables.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutExternalModel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel
func (c *FraudDetector) PutExternalModel(input *PutExternalModelInput) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	return out, req.Send()
}

// PutExternalModelWithContext is the same as PutExternalModel with the addition of
// the ability to pass a context and additional request options.
//
// See PutExternalModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutExternalModelWithContext(ctx aws.Context, input *PutExternalModelInput, opts ...request.Option) (*PutExternalModelOutput, error) {
	req, out := c.PutExternalModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutModel = "PutModel"

// PutModelRequest generates a "aws/request.Request" representing the
// client's request for the PutModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutModel for more information on using the PutModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutModelRequest method.
//    req, resp := client.PutModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutModel
func (c *FraudDetector) PutModelRequest(input *PutModelInput) (req *request.Request, output *PutModelOutput) {
	op := &request.Operation{
		Name:       opPutModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutModelInput{}
	}

	output = &PutModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutModel API operation for Amazon Fraud Detector.
//
// Creates or updates a model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutModel for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutModel
func (c *FraudDetector) PutModel(input *PutModelInput) (*PutModelOutput, error) {
	req, out := c.PutModelRequest(input)
	return out, req.Send()
}

// PutModelWithContext is the same as PutModel with the addition of
// the ability to pass a context and additional request options.
//
// See PutModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutModelWithContext(ctx aws.Context, input *PutModelInput, opts ...request.Option) (*PutModelOutput, error) {
	req, out := c.PutModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutOutcome = "PutOutcome"

// PutOutcomeRequest generates a "aws/request.Request" representing the
// client's request for the PutOutcome operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutOutcome for more information on using the PutOutcome
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutOutcomeRequest method.
//    req, resp := client.PutOutcomeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcomeRequest(input *PutOutcomeInput) (req *request.Request, output *PutOutcomeOutput) {
	op := &request.Operation{
		Name:       opPutOutcome,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutOutcomeInput{}
	}

	output = &PutOutcomeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutOutcome API operation for Amazon Fraud Detector.
//
// Creates or updates an outcome.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation PutOutcome for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome
func (c *FraudDetector) PutOutcome(input *PutOutcomeInput) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	return out, req.Send()
}

// PutOutcomeWithContext is the same as PutOutcome with the addition of
// the ability to pass a context and additional request options.
//
// See PutOutcome for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) PutOutcomeWithContext(ctx aws.Context, input *PutOutcomeInput, opts ...request.Option) (*PutOutcomeOutput, error) {
	req, out := c.PutOutcomeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersion = "UpdateDetectorVersion"

// UpdateDetectorVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersion for more information on using the UpdateDetectorVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionRequest method.
//    req, resp := client.UpdateDetectorVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersionRequest(input *UpdateDetectorVersionInput) (req *request.Request, output *UpdateDetectorVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionInput{}
	}

	output = &UpdateDetectorVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersion API operation for Amazon Fraud Detector.
//
// Updates a detector version. The detector version attributes that you can
// update include models, external model endpoints, rules, and description.
// You can only update a DRAFT detector version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion
func (c *FraudDetector) UpdateDetectorVersion(input *UpdateDetectorVersionInput) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionWithContext is the same as UpdateDetectorVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionWithContext(ctx aws.Context, input *UpdateDetectorVersionInput, opts ...request.Option) (*UpdateDetectorVersionOutput, error) {
	req, out := c.UpdateDetectorVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionMetadata = "UpdateDetectorVersionMetadata"

// UpdateDetectorVersionMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionMetadata for more information on using the UpdateDetectorVersionMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionMetadataRequest method.
//    req, resp := client.UpdateDetectorVersionMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadataRequest(input *UpdateDetectorVersionMetadataInput) (req *request.Request, output *UpdateDetectorVersionMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionMetadataInput{}
	}

	output = &UpdateDetectorVersionMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionMetadata API operation for Amazon Fraud Detector.
//
// Updates the detector version's description. You can update the metadata for
// any detector version (DRAFT, ACTIVE, or INACTIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionMetadata for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata
func (c *FraudDetector) UpdateDetectorVersionMetadata(input *UpdateDetectorVersionMetadataInput) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionMetadataWithContext is the same as UpdateDetectorVersionMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionMetadataWithContext(ctx aws.Context, input *UpdateDetectorVersionMetadataInput, opts ...request.Option) (*UpdateDetectorVersionMetadataOutput, error) {
	req, out := c.UpdateDetectorVersionMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDetectorVersionStatus = "UpdateDetectorVersionStatus"

// UpdateDetectorVersionStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDetectorVersionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDetectorVersionStatus for more information on using the UpdateDetectorVersionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDetectorVersionStatusRequest method.
//    req, resp := client.UpdateDetectorVersionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatusRequest(input *UpdateDetectorVersionStatusInput) (req *request.Request, output *UpdateDetectorVersionStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateDetectorVersionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDetectorVersionStatusInput{}
	}

	output = &UpdateDetectorVersionStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDetectorVersionStatus API operation for Amazon Fraud Detector.
//
// Updates the detector version’s status. You can perform the following promotions
// or demotions using UpdateDetectorVersionStatus: DRAFT to ACTIVE, ACTIVE to
// INACTIVE, and INACTIVE to ACTIVE.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateDetectorVersionStatus for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus
func (c *FraudDetector) UpdateDetectorVersionStatus(input *UpdateDetectorVersionStatusInput) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	return out, req.Send()
}

// UpdateDetectorVersionStatusWithContext is the same as UpdateDetectorVersionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDetectorVersionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateDetectorVersionStatusWithContext(ctx aws.Context, input *UpdateDetectorVersionStatusInput, opts ...request.Option) (*UpdateDetectorVersionStatusOutput, error) {
	req, out := c.UpdateDetectorVersionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModelVersion = "UpdateModelVersion"

// UpdateModelVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModelVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModelVersion for more information on using the UpdateModelVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelVersionRequest method.
//    req, resp := client.UpdateModelVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersionRequest(input *UpdateModelVersionInput) (req *request.Request, output *UpdateModelVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionInput{}
	}

	output = &UpdateModelVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateModelVersion API operation for Amazon Fraud Detector.
//
// Updates a model version. You can update the description and status attributes
// using this action. You can perform the following status updates:
//
// Change the TRAINING_COMPLETE status to ACTIVE
//
// Change ACTIVE back to TRAINING_COMPLETE
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateModelVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *FraudDetector) UpdateModelVersion(input *UpdateModelVersionInput) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	return out, req.Send()
}

// UpdateModelVersionWithContext is the same as UpdateModelVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModelVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateModelVersionWithContext(ctx aws.Context, input *UpdateModelVersionInput, opts ...request.Option) (*UpdateModelVersionOutput, error) {
	req, out := c.UpdateModelVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleMetadata = "UpdateRuleMetadata"

// UpdateRuleMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleMetadata for more information on using the UpdateRuleMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleMetadataRequest method.
//    req, resp := client.UpdateRuleMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadataRequest(input *UpdateRuleMetadataInput) (req *request.Request, output *UpdateRuleMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleMetadataInput{}
	}

	output = &UpdateRuleMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRuleMetadata API operation for Amazon Fraud Detector.
//
// Updates a rule's metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleMetadata for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata
func (c *FraudDetector) UpdateRuleMetadata(input *UpdateRuleMetadataInput) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	return out, req.Send()
}

// UpdateRuleMetadataWithContext is the same as UpdateRuleMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleMetadataWithContext(ctx aws.Context, input *UpdateRuleMetadataInput, opts ...request.Option) (*UpdateRuleMetadataOutput, error) {
	req, out := c.UpdateRuleMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleVersion = "UpdateRuleVersion"

// UpdateRuleVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleVersion for more information on using the UpdateRuleVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleVersionRequest method.
//    req, resp := client.UpdateRuleVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersionRequest(input *UpdateRuleVersionInput) (req *request.Request, output *UpdateRuleVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleVersionInput{}
	}

	output = &UpdateRuleVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleVersion API operation for Amazon Fraud Detector.
//
// Updates a rule version resulting in a new rule version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateRuleVersion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion
func (c *FraudDetector) UpdateRuleVersion(input *UpdateRuleVersionInput) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	return out, req.Send()
}

// UpdateRuleVersionWithContext is the same as UpdateRuleVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateRuleVersionWithContext(ctx aws.Context, input *UpdateRuleVersionInput, opts ...request.Option) (*UpdateRuleVersionOutput, error) {
	req, out := c.UpdateRuleVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVariable = "UpdateVariable"

// UpdateVariableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVariable operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVariable for more information on using the UpdateVariable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVariableRequest method.
//    req, resp := client.UpdateVariableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariableRequest(input *UpdateVariableInput) (req *request.Request, output *UpdateVariableOutput) {
	op := &request.Operation{
		Name:       opUpdateVariable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVariableInput{}
	}

	output = &UpdateVariableOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateVariable API operation for Amazon Fraud Detector.
//
// Updates a variable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Fraud Detector's
// API operation UpdateVariable for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   An exception indicating a specified value is not allowed.
//
//   * ResourceNotFoundException
//   An exception indicating the specified resource was not found.
//
//   * InternalServerException
//   An exception indicating an internal server error.
//
//   * ThrottlingException
//   An exception indicating a throttling error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable
func (c *FraudDetector) UpdateVariable(input *UpdateVariableInput) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	return out, req.Send()
}

// UpdateVariableWithContext is the same as UpdateVariable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVariable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FraudDetector) UpdateVariableWithContext(ctx aws.Context, input *UpdateVariableInput, opts ...request.Option) (*UpdateVariableOutput, error) {
	req, out := c.UpdateVariableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Provides the error of the batch create variable API.
type BatchCreateVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchCreateVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchCreateVariableError) SetCode(v int64) *BatchCreateVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchCreateVariableError) SetMessage(v string) *BatchCreateVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchCreateVariableError) SetName(v string) *BatchCreateVariableError {
	s.Name = &v
	return s
}

type BatchCreateVariableInput struct {
	_ struct{} `type:"structure"`

	// The list of variables for the batch create variable request.
	//
	// VariableEntries is a required field
	VariableEntries []*VariableEntry `locationName:"variableEntries" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchCreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateVariableInput"}
	if s.VariableEntries == nil {
		invalidParams.Add(request.NewErrParamRequired("VariableEntries"))
	}
	if s.VariableEntries != nil && len(s.VariableEntries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VariableEntries", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVariableEntries sets the VariableEntries field's value.
func (s *BatchCreateVariableInput) SetVariableEntries(v []*VariableEntry) *BatchCreateVariableInput {
	s.VariableEntries = v
	return s
}

type BatchCreateVariableOutput struct {
	_ struct{} `type:"structure"`

	// Provides the errors for the BatchCreateVariable request.
	Errors []*BatchCreateVariableError `locationName:"errors" type:"list"`
}

// String returns the string representation
func (s BatchCreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateVariableOutput) SetErrors(v []*BatchCreateVariableError) *BatchCreateVariableOutput {
	s.Errors = v
	return s
}

// Provides the error of the batch get variable API.
type BatchGetVariableError struct {
	_ struct{} `type:"structure"`

	// The error code.
	Code *int64 `locationName:"code" type:"integer"`

	// The error message.
	Message *string `locationName:"message" type:"string"`

	// The error name.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s BatchGetVariableError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *BatchGetVariableError) SetCode(v int64) *BatchGetVariableError {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *BatchGetVariableError) SetMessage(v string) *BatchGetVariableError {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *BatchGetVariableError) SetName(v string) *BatchGetVariableError {
	s.Name = &v
	return s
}

type BatchGetVariableInput struct {
	_ struct{} `type:"structure"`

	// The list of variable names to get.
	//
	// Names is a required field
	Names []*string `locationName:"names" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetVariableInput"}
	if s.Names == nil {
		invalidParams.Add(request.NewErrParamRequired("Names"))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Names", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNames sets the Names field's value.
func (s *BatchGetVariableInput) SetNames(v []*string) *BatchGetVariableInput {
	s.Names = v
	return s
}

type BatchGetVariableOutput struct {
	_ struct{} `type:"structure"`

	// The errors from the request.
	Errors []*BatchGetVariableError `locationName:"errors" type:"list"`

	// The returned variables.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s BatchGetVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetVariableOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetVariableOutput) SetErrors(v []*BatchGetVariableError) *BatchGetVariableOutput {
	s.Errors = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *BatchGetVariableOutput) SetVariables(v []*Variable) *BatchGetVariableOutput {
	s.Variables = v
	return s
}

type CreateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The ID of the detector under which you want to create a new version.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The Amazon Sagemaker model endpoints to include in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDetectorVersionInput) SetDescription(v string) *CreateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionInput) SetDetectorId(v string) *CreateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *CreateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *CreateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *CreateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *CreateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateDetectorVersionInput) SetRules(v []*Rule) *CreateDetectorVersionInput {
	s.Rules = v
	return s
}

type CreateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The ID for the created version's parent detector.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The ID for the created detector.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s CreateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorId(v string) *CreateDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *CreateDetectorVersionOutput) SetDetectorVersionId(v string) *CreateDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDetectorVersionOutput) SetStatus(v string) *CreateDetectorVersionOutput {
	s.Status = &v
	return s
}

type CreateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`
}

// String returns the string representation
func (s CreateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateModelVersionInput) SetDescription(v string) *CreateModelVersionInput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionInput) SetModelId(v string) *CreateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionInput) SetModelType(v string) *CreateModelVersionInput {
	s.ModelType = &v
	return s
}

type CreateModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The version of the model.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s CreateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateModelVersionOutput) GoString() string {
	return s.String()
}

// SetModelId sets the ModelId field's value.
func (s *CreateModelVersionOutput) SetModelId(v string) *CreateModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *CreateModelVersionOutput) SetModelType(v string) *CreateModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *CreateModelVersionOutput) SetModelVersionNumber(v string) *CreateModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateModelVersionOutput) SetStatus(v string) *CreateModelVersionOutput {
	s.Status = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID for the rule's parent detector.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The language of the rule.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcome or outcomes returned when the rule expression matches.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateRuleInput) SetDescription(v string) *CreateRuleInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *CreateRuleInput) SetDetectorId(v string) *CreateRuleInput {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CreateRuleInput) SetExpression(v string) *CreateRuleInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *CreateRuleInput) SetLanguage(v string) *CreateRuleInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *CreateRuleInput) SetOutcomes(v []*string) *CreateRuleInput {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CreateRuleInput) SetRuleId(v string) *CreateRuleInput {
	s.RuleId = &v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The created rule.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *CreateRuleOutput) SetRule(v *Rule) *CreateRuleOutput {
	s.Rule = v
	return s
}

type CreateVariableInput struct {
	_ struct{} `type:"structure"`

	// The source of the data.
	//
	// DataSource is a required field
	DataSource *string `locationName:"dataSource" type:"string" required:"true" enum:"DataSource"`

	// The data type.
	//
	// DataType is a required field
	DataType *string `locationName:"dataType" type:"string" required:"true" enum:"DataType"`

	// The default value for the variable when no value is received.
	//
	// DefaultValue is a required field
	DefaultValue *string `locationName:"defaultValue" type:"string" required:"true"`

	// The description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The variable type.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s CreateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVariableInput"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.DataType == nil {
		invalidParams.Add(request.NewErrParamRequired("DataType"))
	}
	if s.DefaultValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultValue"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *CreateVariableInput) SetDataSource(v string) *CreateVariableInput {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *CreateVariableInput) SetDataType(v string) *CreateVariableInput {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *CreateVariableInput) SetDefaultValue(v string) *CreateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateVariableInput) SetDescription(v string) *CreateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVariableInput) SetName(v string) *CreateVariableInput {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *CreateVariableInput) SetVariableType(v string) *CreateVariableInput {
	s.VariableType = &v
	return s
}

type CreateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVariableOutput) GoString() string {
	return s.String()
}

type DeleteDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the parent detector for the detector version to delete.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The ID of the detector version to delete.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorId(v string) *DeleteDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DeleteDetectorVersionInput) SetDetectorVersionId(v string) *DeleteDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type DeleteDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDetectorVersionOutput) GoString() string {
	return s.String()
}

type DeleteEventInput struct {
	_ struct{} `type:"structure"`

	// The ID of the event to delete.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventInput"}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventId sets the EventId field's value.
func (s *DeleteEventInput) SetEventId(v string) *DeleteEventInput {
	s.EventId = &v
	return s
}

type DeleteEventOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventOutput) GoString() string {
	return s.String()
}

type DescribeDetectorInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of results to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1000" type:"integer"`

	// The next token from the previous response.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDetectorInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorInput) SetDetectorId(v string) *DescribeDetectorInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDetectorInput) SetMaxResults(v int64) *DescribeDetectorInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorInput) SetNextToken(v string) *DescribeDetectorInput {
	s.NextToken = &v
	return s
}

type DescribeDetectorOutput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The status and description for each detector version.
	DetectorVersionSummaries []*DetectorVersionSummary `locationName:"detectorVersionSummaries" type:"list"`

	// The next token to be used for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDetectorOutput) GoString() string {
	return s.String()
}

// SetDetectorId sets the DetectorId field's value.
func (s *DescribeDetectorOutput) SetDetectorId(v string) *DescribeDetectorOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionSummaries sets the DetectorVersionSummaries field's value.
func (s *DescribeDetectorOutput) SetDetectorVersionSummaries(v []*DetectorVersionSummary) *DescribeDetectorOutput {
	s.DetectorVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDetectorOutput) SetNextToken(v string) *DescribeDetectorOutput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The next token from the previous results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeModelVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeModelVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeModelVersionsInput) SetMaxResults(v int64) *DescribeModelVersionsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *DescribeModelVersionsInput) SetModelId(v string) *DescribeModelVersionsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *DescribeModelVersionsInput) SetModelType(v string) *DescribeModelVersionsInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *DescribeModelVersionsInput) SetModelVersionNumber(v string) *DescribeModelVersionsInput {
	s.ModelVersionNumber = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsInput) SetNextToken(v string) *DescribeModelVersionsInput {
	s.NextToken = &v
	return s
}

type DescribeModelVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The model version details.
	ModelVersionDetails []*ModelVersionDetail `locationName:"modelVersionDetails" type:"list"`

	// The next token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeModelVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeModelVersionsOutput) GoString() string {
	return s.String()
}

// SetModelVersionDetails sets the ModelVersionDetails field's value.
func (s *DescribeModelVersionsOutput) SetModelVersionDetails(v []*ModelVersionDetail) *DescribeModelVersionsOutput {
	s.ModelVersionDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeModelVersionsOutput) SetNextToken(v string) *DescribeModelVersionsOutput {
	s.NextToken = &v
	return s
}

// The detector.
type Detector struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the detector was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The detector description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// Timestamp of when the detector was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Detector) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Detector) SetCreatedTime(v string) *Detector {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Detector) SetDescription(v string) *Detector {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *Detector) SetDetectorId(v string) *Detector {
	s.DetectorId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Detector) SetLastUpdatedTime(v string) *Detector {
	s.LastUpdatedTime = &v
	return s
}

// The summary of the detector version.
type DetectorVersionSummary struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// Timestamp of when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The detector version status.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s DetectorVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectorVersionSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DetectorVersionSummary) SetDescription(v string) *DetectorVersionSummary {
	s.Description = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *DetectorVersionSummary) SetDetectorVersionId(v string) *DetectorVersionSummary {
	s.DetectorVersionId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *DetectorVersionSummary) SetLastUpdatedTime(v string) *DetectorVersionSummary {
	s.LastUpdatedTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DetectorVersionSummary) SetStatus(v string) *DetectorVersionSummary {
	s.Status = &v
	return s
}

// The Amazon SageMaker model.
type ExternalModel struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the model was last created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The input configuration.
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure"`

	// Timestamp of when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The Amazon SageMaker model endpoints.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The Amazon Fraud Detector status for the external model endpoint
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" enum:"ModelEndpointStatus"`

	// The source of the model.
	ModelSource *string `locationName:"modelSource" type:"string" enum:"ModelSource"`

	// The output configuration.
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure"`

	// The role used to invoke the model.
	Role *Role `locationName:"role" type:"structure"`
}

// String returns the string representation
func (s ExternalModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExternalModel) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ExternalModel) SetCreatedTime(v string) *ExternalModel {
	s.CreatedTime = &v
	return s
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *ExternalModel) SetInputConfiguration(v *ModelInputConfiguration) *ExternalModel {
	s.InputConfiguration = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ExternalModel) SetLastUpdatedTime(v string) *ExternalModel {
	s.LastUpdatedTime = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *ExternalModel) SetModelEndpoint(v string) *ExternalModel {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *ExternalModel) SetModelEndpointStatus(v string) *ExternalModel {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *ExternalModel) SetModelSource(v string) *ExternalModel {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *ExternalModel) SetOutputConfiguration(v *ModelOutputConfiguration) *ExternalModel {
	s.OutputConfiguration = v
	return s
}

// SetRole sets the Role field's value.
func (s *ExternalModel) SetRole(v *Role) *ExternalModel {
	s.Role = v
	return s
}

type GetDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorVersionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionInput) SetDetectorId(v string) *GetDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionInput) SetDetectorVersionId(v string) *GetDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

type GetDetectorVersionOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp when the detector version was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string"`

	// The Amazon SageMaker model endpoints included in the detector version.
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list"`

	// The timestamp when the detector version was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model versions included in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rules included in the detector version.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The status of the detector version.
	Status *string `locationName:"status" type:"string" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s GetDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorVersionOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *GetDetectorVersionOutput) SetCreatedTime(v string) *GetDetectorVersionOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDetectorVersionOutput) SetDescription(v string) *GetDetectorVersionOutput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorVersionOutput) SetDetectorId(v string) *GetDetectorVersionOutput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetDetectorVersionOutput) SetDetectorVersionId(v string) *GetDetectorVersionOutput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *GetDetectorVersionOutput) SetExternalModelEndpoints(v []*string) *GetDetectorVersionOutput {
	s.ExternalModelEndpoints = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetDetectorVersionOutput) SetLastUpdatedTime(v string) *GetDetectorVersionOutput {
	s.LastUpdatedTime = &v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *GetDetectorVersionOutput) SetModelVersions(v []*ModelVersion) *GetDetectorVersionOutput {
	s.ModelVersions = v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetDetectorVersionOutput) SetRules(v []*Rule) *GetDetectorVersionOutput {
	s.Rules = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetDetectorVersionOutput) SetStatus(v string) *GetDetectorVersionOutput {
	s.Status = &v
	return s
}

type GetDetectorsInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The next token for the subsequent request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDetectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDetectorsInput"}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetDetectorsInput) SetDetectorId(v string) *GetDetectorsInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDetectorsInput) SetMaxResults(v int64) *GetDetectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsInput) SetNextToken(v string) *GetDetectorsInput {
	s.NextToken = &v
	return s
}

type GetDetectorsOutput struct {
	_ struct{} `type:"structure"`

	// The detectors.
	Detectors []*Detector `locationName:"detectors" type:"list"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetDetectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDetectorsOutput) GoString() string {
	return s.String()
}

// SetDetectors sets the Detectors field's value.
func (s *GetDetectorsOutput) SetDetectors(v []*Detector) *GetDetectorsOutput {
	s.Detectors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDetectorsOutput) SetNextToken(v string) *GetDetectorsOutput {
	s.NextToken = &v
	return s
}

type GetExternalModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"5" type:"integer"`

	// The Amazon SageMaker model endpoint.
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExternalModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExternalModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExternalModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExternalModelsInput) SetMaxResults(v int64) *GetExternalModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *GetExternalModelsInput) SetModelEndpoint(v string) *GetExternalModelsInput {
	s.ModelEndpoint = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsInput) SetNextToken(v string) *GetExternalModelsInput {
	s.NextToken = &v
	return s
}

type GetExternalModelsOutput struct {
	_ struct{} `type:"structure"`

	// Gets the Amazon SageMaker models.
	ExternalModels []*ExternalModel `locationName:"externalModels" type:"list"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetExternalModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetExternalModelsOutput) GoString() string {
	return s.String()
}

// SetExternalModels sets the ExternalModels field's value.
func (s *GetExternalModelsOutput) SetExternalModels(v []*ExternalModel) *GetExternalModelsOutput {
	s.ExternalModels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExternalModelsOutput) SetNextToken(v string) *GetExternalModelsOutput {
	s.NextToken = &v
	return s
}

type GetModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelVersionInput"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionInput) SetModelId(v string) *GetModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionInput) SetModelType(v string) *GetModelVersionInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionInput) SetModelVersionNumber(v string) *GetModelVersionInput {
	s.ModelVersionNumber = &v
	return s
}

type GetModelVersionOutput struct {
	_ struct{} `type:"structure"`

	// The model version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model version.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The model version status.
	Status *string `locationName:"status" type:"string"`
}

// String returns the string representation
func (s GetModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelVersionOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetModelVersionOutput) SetDescription(v string) *GetModelVersionOutput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelVersionOutput) SetModelId(v string) *GetModelVersionOutput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelVersionOutput) SetModelType(v string) *GetModelVersionOutput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *GetModelVersionOutput) SetModelVersionNumber(v string) *GetModelVersionOutput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetModelVersionOutput) SetStatus(v string) *GetModelVersionOutput {
	s.Status = &v
	return s
}

type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum results to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The next token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetModelsInput) SetMaxResults(v int64) *GetModelsInput {
	s.MaxResults = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *GetModelsInput) SetModelId(v string) *GetModelsInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *GetModelsInput) SetModelType(v string) *GetModelsInput {
	s.ModelType = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsInput) SetNextToken(v string) *GetModelsInput {
	s.NextToken = &v
	return s
}

type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// The returned models.
	Models []*Model `locationName:"models" type:"list"`

	// The next token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *GetModelsOutput) SetModels(v []*Model) *GetModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetModelsOutput) SetNextToken(v string) *GetModelsOutput {
	s.NextToken = &v
	return s
}

type GetOutcomesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the outcome or outcomes to get.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The next page token for the request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetOutcomesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutcomesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutcomesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutcomesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetOutcomesInput) SetMaxResults(v int64) *GetOutcomesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetOutcomesInput) SetName(v string) *GetOutcomesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesInput) SetNextToken(v string) *GetOutcomesInput {
	s.NextToken = &v
	return s
}

type GetOutcomesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token for subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The outcomes.
	Outcomes []*Outcome `locationName:"outcomes" type:"list"`
}

// String returns the string representation
func (s GetOutcomesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutcomesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutcomesOutput) SetNextToken(v string) *GetOutcomesOutput {
	s.NextToken = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *GetOutcomesOutput) SetOutcomes(v []*Outcome) *GetOutcomesOutput {
	s.Outcomes = v
	return s
}

type GetPredictionInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" type:"string" required:"true"`

	// The detector version ID.
	DetectorVersionId *string `locationName:"detectorVersionId" type:"string"`

	// Names of variables you defined in Amazon Fraud Detector to represent event
	// data elements and their corresponding values for the event you are sending
	// for evaluation.
	EventAttributes map[string]*string `locationName:"eventAttributes" type:"map"`

	// The unique ID used to identify the event.
	//
	// EventId is a required field
	EventId *string `locationName:"eventId" type:"string" required:"true"`

	// The Amazon SageMaker model endpoint input data blobs.
	ExternalModelEndpointDataBlobs map[string]*ModelEndpointDataBlob `locationName:"externalModelEndpointDataBlobs" type:"map" sensitive:"true"`
}

// String returns the string representation
func (s GetPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPredictionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPredictionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPredictionInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.EventId == nil {
		invalidParams.Add(request.NewErrParamRequired("EventId"))
	}
	if s.ExternalModelEndpointDataBlobs != nil {
		for i, v := range s.ExternalModelEndpointDataBlobs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExternalModelEndpointDataBlobs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetPredictionInput) SetDetectorId(v string) *GetPredictionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *GetPredictionInput) SetDetectorVersionId(v string) *GetPredictionInput {
	s.DetectorVersionId = &v
	return s
}

// SetEventAttributes sets the EventAttributes field's value.
func (s *GetPredictionInput) SetEventAttributes(v map[string]*string) *GetPredictionInput {
	s.EventAttributes = v
	return s
}

// SetEventId sets the EventId field's value.
func (s *GetPredictionInput) SetEventId(v string) *GetPredictionInput {
	s.EventId = &v
	return s
}

// SetExternalModelEndpointDataBlobs sets the ExternalModelEndpointDataBlobs field's value.
func (s *GetPredictionInput) SetExternalModelEndpointDataBlobs(v map[string]*ModelEndpointDataBlob) *GetPredictionInput {
	s.ExternalModelEndpointDataBlobs = v
	return s
}

type GetPredictionOutput struct {
	_ struct{} `type:"structure"`

	// The model scores for models used in the detector version.
	ModelScores []*ModelScores `locationName:"modelScores" type:"list"`

	// The prediction outcomes.
	Outcomes []*string `locationName:"outcomes" type:"list"`
}

// String returns the string representation
func (s GetPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPredictionOutput) GoString() string {
	return s.String()
}

// SetModelScores sets the ModelScores field's value.
func (s *GetPredictionOutput) SetModelScores(v []*ModelScores) *GetPredictionOutput {
	s.ModelScores = v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *GetPredictionOutput) SetOutcomes(v []*string) *GetPredictionOutput {
	s.Outcomes = v
	return s
}

type GetRulesInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The maximum number of rules to return for the request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The next page token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s GetRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRulesInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *GetRulesInput) SetDetectorId(v string) *GetRulesInput {
	s.DetectorId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetRulesInput) SetMaxResults(v int64) *GetRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesInput) SetNextToken(v string) *GetRulesInput {
	s.NextToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRulesInput) SetRuleId(v string) *GetRulesInput {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *GetRulesInput) SetRuleVersion(v string) *GetRulesInput {
	s.RuleVersion = &v
	return s
}

type GetRulesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The details of the requested rule.
	RuleDetails []*RuleDetail `locationName:"ruleDetails" type:"list"`
}

// String returns the string representation
func (s GetRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRulesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetRulesOutput) SetNextToken(v string) *GetRulesOutput {
	s.NextToken = &v
	return s
}

// SetRuleDetails sets the RuleDetails field's value.
func (s *GetRulesOutput) SetRuleDetails(v []*RuleDetail) *GetRulesOutput {
	s.RuleDetails = v
	return s
}

type GetVariablesInput struct {
	_ struct{} `type:"structure"`

	// The max size per page determined for the get variable request.
	MaxResults *int64 `locationName:"maxResults" min:"50" type:"integer"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The next page token of the get variable request.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetVariablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVariablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVariablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVariablesInput"}
	if s.MaxResults != nil && *s.MaxResults < 50 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 50))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetVariablesInput) SetMaxResults(v int64) *GetVariablesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetVariablesInput) SetName(v string) *GetVariablesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesInput) SetNextToken(v string) *GetVariablesInput {
	s.NextToken = &v
	return s
}

type GetVariablesOutput struct {
	_ struct{} `type:"structure"`

	// The next page token to be used in subsequent requests.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The names of the variables returned.
	Variables []*Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s GetVariablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVariablesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetVariablesOutput) SetNextToken(v string) *GetVariablesOutput {
	s.NextToken = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *GetVariablesOutput) SetVariables(v []*Variable) *GetVariablesOutput {
	s.Variables = v
	return s
}

// An exception indicating an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The label schema.
type LabelSchema struct {
	_ struct{} `type:"structure"`

	// The label key.
	//
	// LabelKey is a required field
	LabelKey *string `locationName:"labelKey" type:"string" required:"true"`

	// The label mapper maps the Amazon Fraud Detector supported label to the appropriate
	// source labels. For example, if "FRAUD" and "LEGIT" are Amazon Fraud Detector
	// supported labels, this mapper could be: {"FRAUD" => ["0"], "LEGIT" => ["1"]}
	// or {"FRAUD" => ["false"], "LEGIT" => ["true"]} or {"FRAUD" => ["fraud", "abuse"],
	// "LEGIT" => ["legit", "safe"]}. The value part of the mapper is a list, because
	// you may have multiple variants for a single Amazon Fraud Detector label.
	//
	// LabelMapper is a required field
	LabelMapper map[string][]*string `locationName:"labelMapper" type:"map" required:"true"`
}

// String returns the string representation
func (s LabelSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LabelSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LabelSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LabelSchema"}
	if s.LabelKey == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelKey"))
	}
	if s.LabelMapper == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelMapper"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLabelKey sets the LabelKey field's value.
func (s *LabelSchema) SetLabelKey(v string) *LabelSchema {
	s.LabelKey = &v
	return s
}

// SetLabelMapper sets the LabelMapper field's value.
func (s *LabelSchema) SetLabelMapper(v map[string][]*string) *LabelSchema {
	s.LabelMapper = v
	return s
}

// The model.
type Model struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model label schema.
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure"`

	// Timestamp of last time the model was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model input variables.
	ModelVariables []*ModelVariable `locationName:"modelVariables" type:"list"`

	// The model training data source in Amazon S3.
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure"`
}

// String returns the string representation
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Model) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Model) SetCreatedTime(v string) *Model {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Model) SetDescription(v string) *Model {
	s.Description = &v
	return s
}

// SetLabelSchema sets the LabelSchema field's value.
func (s *Model) SetLabelSchema(v *LabelSchema) *Model {
	s.LabelSchema = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Model) SetLastUpdatedTime(v string) *Model {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *Model) SetModelId(v string) *Model {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *Model) SetModelType(v string) *Model {
	s.ModelType = &v
	return s
}

// SetModelVariables sets the ModelVariables field's value.
func (s *Model) SetModelVariables(v []*ModelVariable) *Model {
	s.ModelVariables = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *Model) SetTrainingDataSource(v *TrainingDataSource) *Model {
	s.TrainingDataSource = v
	return s
}

// A pre-formed Amazon SageMaker model input you can include if your detector
// version includes an imported Amazon SageMaker model endpoint with pass-through
// input configuration.
type ModelEndpointDataBlob struct {
	_ struct{} `type:"structure"`

	// The byte buffer of the Amazon SageMaker model endpoint input data blob.
	//
	// ByteBuffer is automatically base64 encoded/decoded by the SDK.
	ByteBuffer []byte `locationName:"byteBuffer" type:"blob"`

	// The content type of the Amazon SageMaker model endpoint input data blob.
	ContentType *string `locationName:"contentType" min:"1" type:"string"`
}

// String returns the string representation
func (s ModelEndpointDataBlob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelEndpointDataBlob) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelEndpointDataBlob) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelEndpointDataBlob"}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteBuffer sets the ByteBuffer field's value.
func (s *ModelEndpointDataBlob) SetByteBuffer(v []byte) *ModelEndpointDataBlob {
	s.ByteBuffer = v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ModelEndpointDataBlob) SetContentType(v string) *ModelEndpointDataBlob {
	s.ContentType = &v
	return s
}

// The model input configuration.
type ModelInputConfiguration struct {
	_ struct{} `type:"structure"`

	// Template for constructing the CSV input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable-names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	CsvInputTemplate *string `locationName:"csvInputTemplate" type:"string"`

	// The format of the model input configuration. The format differs depending
	// on if it is passed through to SageMaker or constructed by Amazon Fraud Detector.
	Format *string `locationName:"format" type:"string" enum:"ModelInputDataFormat"`

	// For an opaque-model, the input to the model will be a ByteBuffer blob provided
	// in the getPrediction request, and will be passed to SageMaker as-is. For
	// non-opaque models, the input will be constructed by Amazon Fraud Detector
	// based on the model-configuration.
	//
	// IsOpaque is a required field
	IsOpaque *bool `locationName:"isOpaque" type:"boolean" required:"true"`

	// Template for constructing the JSON input-data sent to SageMaker. At event-evaluation,
	// the placeholders for variable names in the template will be replaced with
	// the variable values before being sent to SageMaker.
	JsonInputTemplate *string `locationName:"jsonInputTemplate" type:"string"`
}

// String returns the string representation
func (s ModelInputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelInputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelInputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelInputConfiguration"}
	if s.IsOpaque == nil {
		invalidParams.Add(request.NewErrParamRequired("IsOpaque"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvInputTemplate sets the CsvInputTemplate field's value.
func (s *ModelInputConfiguration) SetCsvInputTemplate(v string) *ModelInputConfiguration {
	s.CsvInputTemplate = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelInputConfiguration) SetFormat(v string) *ModelInputConfiguration {
	s.Format = &v
	return s
}

// SetIsOpaque sets the IsOpaque field's value.
func (s *ModelInputConfiguration) SetIsOpaque(v bool) *ModelInputConfiguration {
	s.IsOpaque = &v
	return s
}

// SetJsonInputTemplate sets the JsonInputTemplate field's value.
func (s *ModelInputConfiguration) SetJsonInputTemplate(v string) *ModelInputConfiguration {
	s.JsonInputTemplate = &v
	return s
}

// Provides the model output configuration.
type ModelOutputConfiguration struct {
	_ struct{} `type:"structure"`

	// A map of CSV index values in the SageMaker response to the Amazon Fraud Detector
	// variables.
	CsvIndexToVariableMap map[string]*string `locationName:"csvIndexToVariableMap" type:"map"`

	// The format of the model output configuration.
	//
	// Format is a required field
	Format *string `locationName:"format" type:"string" required:"true" enum:"ModelOutputDataFormat"`

	// A map of JSON keys in response from SageMaker to the Amazon Fraud Detector
	// variables.
	JsonKeyToVariableMap map[string]*string `locationName:"jsonKeyToVariableMap" type:"map"`
}

// String returns the string representation
func (s ModelOutputConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelOutputConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelOutputConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelOutputConfiguration"}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCsvIndexToVariableMap sets the CsvIndexToVariableMap field's value.
func (s *ModelOutputConfiguration) SetCsvIndexToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.CsvIndexToVariableMap = v
	return s
}

// SetFormat sets the Format field's value.
func (s *ModelOutputConfiguration) SetFormat(v string) *ModelOutputConfiguration {
	s.Format = &v
	return s
}

// SetJsonKeyToVariableMap sets the JsonKeyToVariableMap field's value.
func (s *ModelOutputConfiguration) SetJsonKeyToVariableMap(v map[string]*string) *ModelOutputConfiguration {
	s.JsonKeyToVariableMap = v
	return s
}

// The fraud prediction scores.
type ModelScores struct {
	_ struct{} `type:"structure"`

	// The model version.
	ModelVersion *ModelVersion `locationName:"modelVersion" type:"structure"`

	// The model's fraud prediction scores.
	Scores map[string]*float64 `locationName:"scores" type:"map"`
}

// String returns the string representation
func (s ModelScores) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelScores) GoString() string {
	return s.String()
}

// SetModelVersion sets the ModelVersion field's value.
func (s *ModelScores) SetModelVersion(v *ModelVersion) *ModelScores {
	s.ModelVersion = v
	return s
}

// SetScores sets the Scores field's value.
func (s *ModelScores) SetScores(v map[string]*float64) *ModelScores {
	s.Scores = v
	return s
}

// The model variable.>
type ModelVariable struct {
	_ struct{} `type:"structure"`

	// The model variable's index.>
	Index *int64 `locationName:"index" type:"integer"`

	// The model variable's name.>
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelVariable"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndex sets the Index field's value.
func (s *ModelVariable) SetIndex(v int64) *ModelVariable {
	s.Index = &v
	return s
}

// SetName sets the Name field's value.
func (s *ModelVariable) SetName(v string) *ModelVariable {
	s.Name = &v
	return s
}

// The model version.
type ModelVersion struct {
	_ struct{} `type:"structure"`

	// The parent model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ModelVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelVersion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelVersion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelVersion"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersion) SetModelId(v string) *ModelVersion {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersion) SetModelType(v string) *ModelVersion {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersion) SetModelVersionNumber(v string) *ModelVersion {
	s.ModelVersionNumber = &v
	return s
}

// Provides the model version details.
type ModelVersionDetail struct {
	_ struct{} `type:"structure"`

	// The timestamp when the model was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The model label schema.
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure"`

	// The timestamp when the model was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The model ID.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The model type.
	ModelType *string `locationName:"modelType" type:"string" enum:"ModelTypeEnum"`

	// The model variables.
	ModelVariables []*ModelVariable `locationName:"modelVariables" type:"list"`

	// The model version.
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string"`

	// The model status.
	Status *string `locationName:"status" type:"string"`

	// The model training data source.
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure"`

	// The model training metrics.
	TrainingMetrics map[string]*string `locationName:"trainingMetrics" type:"map"`

	// The model validation metrics.
	ValidationMetrics map[string]*string `locationName:"validationMetrics" type:"map"`
}

// String returns the string representation
func (s ModelVersionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModelVersionDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *ModelVersionDetail) SetCreatedTime(v string) *ModelVersionDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ModelVersionDetail) SetDescription(v string) *ModelVersionDetail {
	s.Description = &v
	return s
}

// SetLabelSchema sets the LabelSchema field's value.
func (s *ModelVersionDetail) SetLabelSchema(v *LabelSchema) *ModelVersionDetail {
	s.LabelSchema = v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *ModelVersionDetail) SetLastUpdatedTime(v string) *ModelVersionDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *ModelVersionDetail) SetModelId(v string) *ModelVersionDetail {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *ModelVersionDetail) SetModelType(v string) *ModelVersionDetail {
	s.ModelType = &v
	return s
}

// SetModelVariables sets the ModelVariables field's value.
func (s *ModelVersionDetail) SetModelVariables(v []*ModelVariable) *ModelVersionDetail {
	s.ModelVariables = v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *ModelVersionDetail) SetModelVersionNumber(v string) *ModelVersionDetail {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ModelVersionDetail) SetStatus(v string) *ModelVersionDetail {
	s.Status = &v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *ModelVersionDetail) SetTrainingDataSource(v *TrainingDataSource) *ModelVersionDetail {
	s.TrainingDataSource = v
	return s
}

// SetTrainingMetrics sets the TrainingMetrics field's value.
func (s *ModelVersionDetail) SetTrainingMetrics(v map[string]*string) *ModelVersionDetail {
	s.TrainingMetrics = v
	return s
}

// SetValidationMetrics sets the ValidationMetrics field's value.
func (s *ModelVersionDetail) SetValidationMetrics(v map[string]*string) *ModelVersionDetail {
	s.ValidationMetrics = v
	return s
}

// The outcome.
type Outcome struct {
	_ struct{} `type:"structure"`

	// The timestamp when the outcome was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The timestamp when the outcome was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The outcome name.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Outcome) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Outcome) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Outcome) SetCreatedTime(v string) *Outcome {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Outcome) SetDescription(v string) *Outcome {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Outcome) SetLastUpdatedTime(v string) *Outcome {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Outcome) SetName(v string) *Outcome {
	s.Name = &v
	return s
}

type PutDetectorInput struct {
	_ struct{} `type:"structure"`

	// The description of the detector.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutDetectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDetectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutDetectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutDetectorInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutDetectorInput) SetDescription(v string) *PutDetectorInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *PutDetectorInput) SetDetectorId(v string) *PutDetectorInput {
	s.DetectorId = &v
	return s
}

type PutDetectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutDetectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutDetectorOutput) GoString() string {
	return s.String()
}

type PutExternalModelInput struct {
	_ struct{} `type:"structure"`

	// The model endpoint input configuration.
	//
	// InputConfiguration is a required field
	InputConfiguration *ModelInputConfiguration `locationName:"inputConfiguration" type:"structure" required:"true"`

	// The model endpoints name.
	//
	// ModelEndpoint is a required field
	ModelEndpoint *string `locationName:"modelEndpoint" type:"string" required:"true"`

	// The model endpoint’s status in Amazon Fraud Detector.
	//
	// ModelEndpointStatus is a required field
	ModelEndpointStatus *string `locationName:"modelEndpointStatus" type:"string" required:"true" enum:"ModelEndpointStatus"`

	// The source of the model.
	//
	// ModelSource is a required field
	ModelSource *string `locationName:"modelSource" type:"string" required:"true" enum:"ModelSource"`

	// The model endpoint output configuration.
	//
	// OutputConfiguration is a required field
	OutputConfiguration *ModelOutputConfiguration `locationName:"outputConfiguration" type:"structure" required:"true"`

	// The IAM role used to invoke the model endpoint.
	//
	// Role is a required field
	Role *Role `locationName:"role" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutExternalModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutExternalModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutExternalModelInput"}
	if s.InputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfiguration"))
	}
	if s.ModelEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpoint"))
	}
	if s.ModelEndpointStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelEndpointStatus"))
	}
	if s.ModelSource == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelSource"))
	}
	if s.OutputConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfiguration"))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.InputConfiguration != nil {
		if err := s.InputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfiguration != nil {
		if err := s.OutputConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Role != nil {
		if err := s.Role.Validate(); err != nil {
			invalidParams.AddNested("Role", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputConfiguration sets the InputConfiguration field's value.
func (s *PutExternalModelInput) SetInputConfiguration(v *ModelInputConfiguration) *PutExternalModelInput {
	s.InputConfiguration = v
	return s
}

// SetModelEndpoint sets the ModelEndpoint field's value.
func (s *PutExternalModelInput) SetModelEndpoint(v string) *PutExternalModelInput {
	s.ModelEndpoint = &v
	return s
}

// SetModelEndpointStatus sets the ModelEndpointStatus field's value.
func (s *PutExternalModelInput) SetModelEndpointStatus(v string) *PutExternalModelInput {
	s.ModelEndpointStatus = &v
	return s
}

// SetModelSource sets the ModelSource field's value.
func (s *PutExternalModelInput) SetModelSource(v string) *PutExternalModelInput {
	s.ModelSource = &v
	return s
}

// SetOutputConfiguration sets the OutputConfiguration field's value.
func (s *PutExternalModelInput) SetOutputConfiguration(v *ModelOutputConfiguration) *PutExternalModelInput {
	s.OutputConfiguration = v
	return s
}

// SetRole sets the Role field's value.
func (s *PutExternalModelInput) SetRole(v *Role) *PutExternalModelInput {
	s.Role = v
	return s
}

type PutExternalModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutExternalModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutExternalModelOutput) GoString() string {
	return s.String()
}

type PutModelInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The label schema.
	//
	// LabelSchema is a required field
	LabelSchema *LabelSchema `locationName:"labelSchema" type:"structure" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model input variables.
	//
	// ModelVariables is a required field
	ModelVariables []*ModelVariable `locationName:"modelVariables" type:"list" required:"true"`

	// The training data source location in Amazon S3.
	//
	// TrainingDataSource is a required field
	TrainingDataSource *TrainingDataSource `locationName:"trainingDataSource" type:"structure" required:"true"`
}

// String returns the string representation
func (s PutModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutModelInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.LabelSchema == nil {
		invalidParams.Add(request.NewErrParamRequired("LabelSchema"))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVariables == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVariables"))
	}
	if s.TrainingDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDataSource"))
	}
	if s.LabelSchema != nil {
		if err := s.LabelSchema.Validate(); err != nil {
			invalidParams.AddNested("LabelSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.ModelVariables != nil {
		for i, v := range s.ModelVariables {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVariables", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrainingDataSource != nil {
		if err := s.TrainingDataSource.Validate(); err != nil {
			invalidParams.AddNested("TrainingDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutModelInput) SetDescription(v string) *PutModelInput {
	s.Description = &v
	return s
}

// SetLabelSchema sets the LabelSchema field's value.
func (s *PutModelInput) SetLabelSchema(v *LabelSchema) *PutModelInput {
	s.LabelSchema = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *PutModelInput) SetModelId(v string) *PutModelInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *PutModelInput) SetModelType(v string) *PutModelInput {
	s.ModelType = &v
	return s
}

// SetModelVariables sets the ModelVariables field's value.
func (s *PutModelInput) SetModelVariables(v []*ModelVariable) *PutModelInput {
	s.ModelVariables = v
	return s
}

// SetTrainingDataSource sets the TrainingDataSource field's value.
func (s *PutModelInput) SetTrainingDataSource(v *TrainingDataSource) *PutModelInput {
	s.TrainingDataSource = v
	return s
}

type PutModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutModelOutput) GoString() string {
	return s.String()
}

type PutOutcomeInput struct {
	_ struct{} `type:"structure"`

	// The outcome description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The name of the outcome.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutOutcomeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOutcomeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutOutcomeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutOutcomeInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *PutOutcomeInput) SetDescription(v string) *PutOutcomeInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutOutcomeInput) SetName(v string) *PutOutcomeInput {
	s.Name = &v
	return s
}

type PutOutcomeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutOutcomeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutOutcomeOutput) GoString() string {
	return s.String()
}

// An exception indicating the specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The role used to invoke external model endpoints.
type Role struct {
	_ struct{} `type:"structure"`

	// The role ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The role name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Role) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Role) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Role"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *Role) SetArn(v string) *Role {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Role) SetName(v string) *Role {
	s.Name = &v
	return s
}

// A rule.
type Rule struct {
	_ struct{} `type:"structure"`

	// The detector for which the rule is associated.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The rule ID.
	//
	// RuleId is a required field
	RuleId *string `locationName:"ruleId" min:"1" type:"string" required:"true"`

	// The rule version.
	//
	// RuleVersion is a required field
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.RuleVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleVersion"))
	}
	if s.RuleVersion != nil && len(*s.RuleVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *Rule) SetDetectorId(v string) *Rule {
	s.DetectorId = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Rule) SetRuleId(v string) *Rule {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *Rule) SetRuleVersion(v string) *Rule {
	s.RuleVersion = &v
	return s
}

// The details of the rule.
type RuleDetail struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the rule was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The rule description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detector for which the rule is associated.
	DetectorId *string `locationName:"detectorId" min:"1" type:"string"`

	// The rule expression.
	Expression *string `locationName:"expression" min:"1" type:"string"`

	// The rule language.
	Language *string `locationName:"language" type:"string" enum:"Language"`

	// Timestamp of the last time the rule was updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The rule outcomes.
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list"`

	// The rule ID.
	RuleId *string `locationName:"ruleId" min:"1" type:"string"`

	// The rule version.
	RuleVersion *string `locationName:"ruleVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s RuleDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleDetail) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *RuleDetail) SetCreatedTime(v string) *RuleDetail {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuleDetail) SetDescription(v string) *RuleDetail {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *RuleDetail) SetDetectorId(v string) *RuleDetail {
	s.DetectorId = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *RuleDetail) SetExpression(v string) *RuleDetail {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *RuleDetail) SetLanguage(v string) *RuleDetail {
	s.Language = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *RuleDetail) SetLastUpdatedTime(v string) *RuleDetail {
	s.LastUpdatedTime = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *RuleDetail) SetOutcomes(v []*string) *RuleDetail {
	s.Outcomes = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleDetail) SetRuleId(v string) *RuleDetail {
	s.RuleId = &v
	return s
}

// SetRuleVersion sets the RuleVersion field's value.
func (s *RuleDetail) SetRuleVersion(v string) *RuleDetail {
	s.RuleVersion = &v
	return s
}

// An exception indicating a throttling error.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The training data source.
type TrainingDataSource struct {
	_ struct{} `type:"structure"`

	// The data access role ARN for the training data source.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `locationName:"dataAccessRoleArn" min:"1" type:"string" required:"true"`

	// The data location of the training data source.
	//
	// DataLocation is a required field
	DataLocation *string `locationName:"dataLocation" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TrainingDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrainingDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrainingDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrainingDataSource"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 1))
	}
	if s.DataLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DataLocation"))
	}
	if s.DataLocation != nil && len(*s.DataLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataLocation", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *TrainingDataSource) SetDataAccessRoleArn(v string) *TrainingDataSource {
	s.DataAccessRoleArn = &v
	return s
}

// SetDataLocation sets the DataLocation field's value.
func (s *TrainingDataSource) SetDataLocation(v string) *TrainingDataSource {
	s.DataLocation = &v
	return s
}

type UpdateDetectorVersionInput struct {
	_ struct{} `type:"structure"`

	// The detector version description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The parent detector ID for the detector version you want to update.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The Amazon SageMaker model endpoints to include in the detector version.
	//
	// ExternalModelEndpoints is a required field
	ExternalModelEndpoints []*string `locationName:"externalModelEndpoints" type:"list" required:"true"`

	// The model versions to include in the detector version.
	ModelVersions []*ModelVersion `locationName:"modelVersions" type:"list"`

	// The rules to include in the detector version.
	//
	// Rules is a required field
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.ExternalModelEndpoints == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalModelEndpoints"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.ModelVersions != nil {
		for i, v := range s.ModelVersions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ModelVersions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionInput) SetDescription(v string) *UpdateDetectorVersionInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorId(v string) *UpdateDetectorVersionInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionInput) SetDetectorVersionId(v string) *UpdateDetectorVersionInput {
	s.DetectorVersionId = &v
	return s
}

// SetExternalModelEndpoints sets the ExternalModelEndpoints field's value.
func (s *UpdateDetectorVersionInput) SetExternalModelEndpoints(v []*string) *UpdateDetectorVersionInput {
	s.ExternalModelEndpoints = v
	return s
}

// SetModelVersions sets the ModelVersions field's value.
func (s *UpdateDetectorVersionInput) SetModelVersions(v []*ModelVersion) *UpdateDetectorVersionInput {
	s.ModelVersions = v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateDetectorVersionInput) SetRules(v []*Rule) *UpdateDetectorVersionInput {
	s.Rules = v
	return s
}

type UpdateDetectorVersionMetadataInput struct {
	_ struct{} `type:"structure"`

	// The description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDescription(v string) *UpdateDetectorVersionMetadataInput {
	s.Description = &v
	return s
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionMetadataInput) SetDetectorVersionId(v string) *UpdateDetectorVersionMetadataInput {
	s.DetectorVersionId = &v
	return s
}

type UpdateDetectorVersionMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionMetadataOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionOutput) GoString() string {
	return s.String()
}

type UpdateDetectorVersionStatusInput struct {
	_ struct{} `type:"structure"`

	// The detector ID.
	//
	// DetectorId is a required field
	DetectorId *string `locationName:"detectorId" min:"1" type:"string" required:"true"`

	// The detector version ID.
	//
	// DetectorVersionId is a required field
	DetectorVersionId *string `locationName:"detectorVersionId" min:"1" type:"string" required:"true"`

	// The new status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DetectorVersionStatus"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorVersionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDetectorVersionStatusInput"}
	if s.DetectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorId"))
	}
	if s.DetectorId != nil && len(*s.DetectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorId", 1))
	}
	if s.DetectorVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("DetectorVersionId"))
	}
	if s.DetectorVersionId != nil && len(*s.DetectorVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetectorVersionId", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetectorId sets the DetectorId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorId = &v
	return s
}

// SetDetectorVersionId sets the DetectorVersionId field's value.
func (s *UpdateDetectorVersionStatusInput) SetDetectorVersionId(v string) *UpdateDetectorVersionStatusInput {
	s.DetectorVersionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateDetectorVersionStatusInput) SetStatus(v string) *UpdateDetectorVersionStatusInput {
	s.Status = &v
	return s
}

type UpdateDetectorVersionStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDetectorVersionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDetectorVersionStatusOutput) GoString() string {
	return s.String()
}

type UpdateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType *string `locationName:"modelType" type:"string" required:"true" enum:"ModelTypeEnum"`

	// The model version.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`

	// The new model status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ModelVersionStatus"`
}

// String returns the string representation
func (s UpdateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelVersionInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.ModelType == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelType"))
	}
	if s.ModelVersionNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelVersionNumber", 1))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateModelVersionInput) SetDescription(v string) *UpdateModelVersionInput {
	s.Description = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *UpdateModelVersionInput) SetModelId(v string) *UpdateModelVersionInput {
	s.ModelId = &v
	return s
}

// SetModelType sets the ModelType field's value.
func (s *UpdateModelVersionInput) SetModelType(v string) *UpdateModelVersionInput {
	s.ModelType = &v
	return s
}

// SetModelVersionNumber sets the ModelVersionNumber field's value.
func (s *UpdateModelVersionInput) SetModelVersionNumber(v string) *UpdateModelVersionInput {
	s.ModelVersionNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateModelVersionInput) SetStatus(v string) *UpdateModelVersionInput {
	s.Status = &v
	return s
}

type UpdateModelVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateModelVersionOutput) GoString() string {
	return s.String()
}

type UpdateRuleMetadataInput struct {
	_ struct{} `type:"structure"`

	// The rule description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleMetadataInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleMetadataInput) SetDescription(v string) *UpdateRuleMetadataInput {
	s.Description = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleMetadataInput) SetRule(v *Rule) *UpdateRuleMetadataInput {
	s.Rule = v
	return s
}

type UpdateRuleMetadataOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRuleMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleMetadataOutput) GoString() string {
	return s.String()
}

type UpdateRuleVersionInput struct {
	_ struct{} `type:"structure"`

	// The description.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The rule expression.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true"`

	// The language.
	//
	// Language is a required field
	Language *string `locationName:"language" type:"string" required:"true" enum:"Language"`

	// The outcomes.
	//
	// Outcomes is a required field
	Outcomes []*string `locationName:"outcomes" min:"1" type:"list" required:"true"`

	// The rule to update.
	//
	// Rule is a required field
	Rule *Rule `locationName:"rule" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateRuleVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleVersionInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Language == nil {
		invalidParams.Add(request.NewErrParamRequired("Language"))
	}
	if s.Outcomes == nil {
		invalidParams.Add(request.NewErrParamRequired("Outcomes"))
	}
	if s.Outcomes != nil && len(s.Outcomes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Outcomes", 1))
	}
	if s.Rule == nil {
		invalidParams.Add(request.NewErrParamRequired("Rule"))
	}
	if s.Rule != nil {
		if err := s.Rule.Validate(); err != nil {
			invalidParams.AddNested("Rule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateRuleVersionInput) SetDescription(v string) *UpdateRuleVersionInput {
	s.Description = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *UpdateRuleVersionInput) SetExpression(v string) *UpdateRuleVersionInput {
	s.Expression = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *UpdateRuleVersionInput) SetLanguage(v string) *UpdateRuleVersionInput {
	s.Language = &v
	return s
}

// SetOutcomes sets the Outcomes field's value.
func (s *UpdateRuleVersionInput) SetOutcomes(v []*string) *UpdateRuleVersionInput {
	s.Outcomes = v
	return s
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionInput) SetRule(v *Rule) *UpdateRuleVersionInput {
	s.Rule = v
	return s
}

type UpdateRuleVersionOutput struct {
	_ struct{} `type:"structure"`

	// The new rule version that was created.
	Rule *Rule `locationName:"rule" type:"structure"`
}

// String returns the string representation
func (s UpdateRuleVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleVersionOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *UpdateRuleVersionOutput) SetRule(v *Rule) *UpdateRuleVersionOutput {
	s.Rule = v
	return s
}

type UpdateVariableInput struct {
	_ struct{} `type:"structure"`

	// The new default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The new description.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The variable type.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s UpdateVariableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVariableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVariableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVariableInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *UpdateVariableInput) SetDefaultValue(v string) *UpdateVariableInput {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateVariableInput) SetDescription(v string) *UpdateVariableInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVariableInput) SetName(v string) *UpdateVariableInput {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *UpdateVariableInput) SetVariableType(v string) *UpdateVariableInput {
	s.VariableType = &v
	return s
}

type UpdateVariableOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateVariableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVariableOutput) GoString() string {
	return s.String()
}

// An exception indicating a specified value is not allowed.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The time when the variable was created.
	CreatedTime *string `locationName:"createdTime" type:"string"`

	// The data source of the variable.
	DataSource *string `locationName:"dataSource" type:"string" enum:"DataSource"`

	// The data type of the variable.
	DataType *string `locationName:"dataType" type:"string" enum:"DataType"`

	// The default value of the variable.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable.
	Description *string `locationName:"description" type:"string"`

	// The time when variable was last updated.
	LastUpdatedTime *string `locationName:"lastUpdatedTime" type:"string"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`

	// The variable type of the variable.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Variable) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *Variable) SetCreatedTime(v string) *Variable {
	s.CreatedTime = &v
	return s
}

// SetDataSource sets the DataSource field's value.
func (s *Variable) SetDataSource(v string) *Variable {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Variable) SetDataType(v string) *Variable {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *Variable) SetDefaultValue(v string) *Variable {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Variable) SetDescription(v string) *Variable {
	s.Description = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *Variable) SetLastUpdatedTime(v string) *Variable {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Variable) SetName(v string) *Variable {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *Variable) SetVariableType(v string) *Variable {
	s.VariableType = &v
	return s
}

// The variable entry in a list.
type VariableEntry struct {
	_ struct{} `type:"structure"`

	// The data source of the variable entry.
	DataSource *string `locationName:"dataSource" type:"string"`

	// The data type of the variable entry.
	DataType *string `locationName:"dataType" type:"string"`

	// The default value of the variable entry.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of the variable entry.
	Description *string `locationName:"description" type:"string"`

	// The name of the variable entry.
	Name *string `locationName:"name" type:"string"`

	// The type of the variable entry.
	VariableType *string `locationName:"variableType" type:"string"`
}

// String returns the string representation
func (s VariableEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VariableEntry) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *VariableEntry) SetDataSource(v string) *VariableEntry {
	s.DataSource = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *VariableEntry) SetDataType(v string) *VariableEntry {
	s.DataType = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *VariableEntry) SetDefaultValue(v string) *VariableEntry {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *VariableEntry) SetDescription(v string) *VariableEntry {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *VariableEntry) SetName(v string) *VariableEntry {
	s.Name = &v
	return s
}

// SetVariableType sets the VariableType field's value.
func (s *VariableEntry) SetVariableType(v string) *VariableEntry {
	s.VariableType = &v
	return s
}

const (
	// DataSourceEvent is a DataSource enum value
	DataSourceEvent = "EVENT"

	// DataSourceModelScore is a DataSource enum value
	DataSourceModelScore = "MODEL_SCORE"

	// DataSourceExternalModelScore is a DataSource enum value
	DataSourceExternalModelScore = "EXTERNAL_MODEL_SCORE"
)

const (
	// DataTypeString is a DataType enum value
	DataTypeString = "STRING"

	// DataTypeInteger is a DataType enum value
	DataTypeInteger = "INTEGER"

	// DataTypeFloat is a DataType enum value
	DataTypeFloat = "FLOAT"

	// DataTypeBoolean is a DataType enum value
	DataTypeBoolean = "BOOLEAN"
)

const (
	// DetectorVersionStatusDraft is a DetectorVersionStatus enum value
	DetectorVersionStatusDraft = "DRAFT"

	// DetectorVersionStatusActive is a DetectorVersionStatus enum value
	DetectorVersionStatusActive = "ACTIVE"

	// DetectorVersionStatusInactive is a DetectorVersionStatus enum value
	DetectorVersionStatusInactive = "INACTIVE"
)

const (
	// LanguageDetectorpl is a Language enum value
	LanguageDetectorpl = "DETECTORPL"
)

const (
	// ModelEndpointStatusAssociated is a ModelEndpointStatus enum value
	ModelEndpointStatusAssociated = "ASSOCIATED"

	// ModelEndpointStatusDissociated is a ModelEndpointStatus enum value
	ModelEndpointStatusDissociated = "DISSOCIATED"
)

const (
	// ModelInputDataFormatTextCsv is a ModelInputDataFormat enum value
	ModelInputDataFormatTextCsv = "TEXT_CSV"

	// ModelInputDataFormatApplicationJson is a ModelInputDataFormat enum value
	ModelInputDataFormatApplicationJson = "APPLICATION_JSON"
)

const (
	// ModelOutputDataFormatTextCsv is a ModelOutputDataFormat enum value
	ModelOutputDataFormatTextCsv = "TEXT_CSV"

	// ModelOutputDataFormatApplicationJsonlines is a ModelOutputDataFormat enum value
	ModelOutputDataFormatApplicationJsonlines = "APPLICATION_JSONLINES"
)

const (
	// ModelSourceSagemaker is a ModelSource enum value
	ModelSourceSagemaker = "SAGEMAKER"
)

const (
	// ModelTypeEnumOnlineFraudInsights is a ModelTypeEnum enum value
	ModelTypeEnumOnlineFraudInsights = "ONLINE_FRAUD_INSIGHTS"
)

const (
	// ModelVersionStatusTrainingInProgress is a ModelVersionStatus enum value
	ModelVersionStatusTrainingInProgress = "TRAINING_IN_PROGRESS"

	// ModelVersionStatusTrainingComplete is a ModelVersionStatus enum value
	ModelVersionStatusTrainingComplete = "TRAINING_COMPLETE"

	// ModelVersionStatusActivateRequested is a ModelVersionStatus enum value
	ModelVersionStatusActivateRequested = "ACTIVATE_REQUESTED"

	// ModelVersionStatusActivateInProgress is a ModelVersionStatus enum value
	ModelVersionStatusActivateInProgress = "ACTIVATE_IN_PROGRESS"

	// ModelVersionStatusActive is a ModelVersionStatus enum value
	ModelVersionStatusActive = "ACTIVE"

	// ModelVersionStatusInactivateInProgress is a ModelVersionStatus enum value
	ModelVersionStatusInactivateInProgress = "INACTIVATE_IN_PROGRESS"

	// ModelVersionStatusInactive is a ModelVersionStatus enum value
	ModelVersionStatusInactive = "INACTIVE"

	// ModelVersionStatusError is a ModelVersionStatus enum value
	ModelVersionStatusError = "ERROR"
)
