// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelCluster = "CancelCluster"

// CancelClusterRequest generates a "aws/request.Request" representing the
// client's request for the CancelCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelCluster for more information on using the CancelCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelClusterRequest method.
//    req, resp := client.CancelClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster
func (c *Snowball) CancelClusterRequest(input *CancelClusterInput) (req *request.Request, output *CancelClusterOutput) {
	op := &request.Operation{
		Name:       opCancelCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelClusterInput{}
	}

	output = &CancelClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelCluster API operation for Amazon Import/Export Snowball.
//
// Cancels a cluster job. You can only cancel a cluster job while it's in the
// AwaitingQuorum status. You'll have at least an hour after creating a cluster
// job to cancel it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CancelCluster for usage and error information.
//
// Returned Error Types:
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelCluster
func (c *Snowball) CancelCluster(input *CancelClusterInput) (*CancelClusterOutput, error) {
	req, out := c.CancelClusterRequest(input)
	return out, req.Send()
}

// CancelClusterWithContext is the same as CancelCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CancelCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CancelClusterWithContext(ctx aws.Context, input *CancelClusterInput, opts ...request.Option) (*CancelClusterOutput, error) {
	req, out := c.CancelClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelJob = "CancelJob"

// CancelJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelJob for more information on using the CancelJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelJobRequest method.
//    req, resp := client.CancelJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob
func (c *Snowball) CancelJobRequest(input *CancelJobInput) (req *request.Request, output *CancelJobOutput) {
	op := &request.Operation{
		Name:       opCancelJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelJobInput{}
	}

	output = &CancelJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelJob API operation for Amazon Import/Export Snowball.
//
// Cancels the specified job. You can only cancel a job before its JobState
// value changes to PreparingAppliance. Requesting the ListJobs or DescribeJob
// action returns a job's JobState as part of the response element data returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CancelJob for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CancelJob
func (c *Snowball) CancelJob(input *CancelJobInput) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	return out, req.Send()
}

// CancelJobWithContext is the same as CancelJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CancelJobWithContext(ctx aws.Context, input *CancelJobInput, opts ...request.Option) (*CancelJobOutput, error) {
	req, out := c.CancelJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddress = "CreateAddress"

// CreateAddressRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddress for more information on using the CreateAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAddressRequest method.
//    req, resp := client.CreateAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress
func (c *Snowball) CreateAddressRequest(input *CreateAddressInput) (req *request.Request, output *CreateAddressOutput) {
	op := &request.Operation{
		Name:       opCreateAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAddressInput{}
	}

	output = &CreateAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddress API operation for Amazon Import/Export Snowball.
//
// Creates an address for a Snowball to be shipped to. In most regions, addresses
// are validated at the time of creation. The address you provide must be located
// within the serviceable area of your region. If the address is invalid or
// unsupported, then an exception is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateAddress for usage and error information.
//
// Returned Error Types:
//   * InvalidAddressException
//   The address provided was invalid. Check the address with your region's carrier,
//   and try again.
//
//   * UnsupportedAddressException
//   The address is either outside the serviceable area for your region, or an
//   error occurred. Check the address with your region's carrier and try again.
//   If the issue persists, contact AWS Support.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress
func (c *Snowball) CreateAddress(input *CreateAddressInput) (*CreateAddressOutput, error) {
	req, out := c.CreateAddressRequest(input)
	return out, req.Send()
}

// CreateAddressWithContext is the same as CreateAddress with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateAddressWithContext(ctx aws.Context, input *CreateAddressInput, opts ...request.Option) (*CreateAddressOutput, error) {
	req, out := c.CreateAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster
func (c *Snowball) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Import/Export Snowball.
//
// Creates an empty cluster. Each cluster supports five nodes. You use the CreateJob
// action separately to create the jobs for each of these nodes. The cluster
// does not ship until these five node jobs have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
//   * InvalidInputCombinationException
//   Job or cluster creation failed. One ore more inputs were invalid. Confirm
//   that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//   and try again.
//
//   * Ec2RequestFailedException
//   Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateCluster
func (c *Snowball) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateJobRequest method.
//    req, resp := client.CreateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob
func (c *Snowball) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateJob API operation for Amazon Import/Export Snowball.
//
// Creates a job to import or export data between Amazon S3 and your on-premises
// data center. Your AWS account must have the right trust policies and permissions
// in place to create a job for Snowball. If you're creating a job for a node
// in a cluster, you only need to provide the clusterId value; the other job
// attributes are inherited from the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
//   * InvalidInputCombinationException
//   Job or cluster creation failed. One ore more inputs were invalid. Confirm
//   that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//   and try again.
//
//   * ClusterLimitExceededException
//   Job creation failed. Currently, clusters support five nodes. If you have
//   less than five nodes for your cluster and you have more nodes to create for
//   this cluster, try again and create jobs until your cluster has exactly five
//   notes.
//
//   * Ec2RequestFailedException
//   Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateJob
func (c *Snowball) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddress = "DescribeAddress"

// DescribeAddressRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddress for more information on using the DescribeAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddressRequest method.
//    req, resp := client.DescribeAddressRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress
func (c *Snowball) DescribeAddressRequest(input *DescribeAddressInput) (req *request.Request, output *DescribeAddressOutput) {
	op := &request.Operation{
		Name:       opDescribeAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressInput{}
	}

	output = &DescribeAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddress API operation for Amazon Import/Export Snowball.
//
// Takes an AddressId and returns specific details about that address in the
// form of an Address object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddress for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddress
func (c *Snowball) DescribeAddress(input *DescribeAddressInput) (*DescribeAddressOutput, error) {
	req, out := c.DescribeAddressRequest(input)
	return out, req.Send()
}

// DescribeAddressWithContext is the same as DescribeAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressWithContext(ctx aws.Context, input *DescribeAddressInput, opts ...request.Option) (*DescribeAddressOutput, error) {
	req, out := c.DescribeAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddresses = "DescribeAddresses"

// DescribeAddressesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddresses for more information on using the DescribeAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAddressesRequest method.
//    req, resp := client.DescribeAddressesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses
func (c *Snowball) DescribeAddressesRequest(input *DescribeAddressesInput) (req *request.Request, output *DescribeAddressesOutput) {
	op := &request.Operation{
		Name:       opDescribeAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddressesInput{}
	}

	output = &DescribeAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddresses API operation for Amazon Import/Export Snowball.
//
// Returns a specified number of ADDRESS objects. Calling this API in one of
// the US regions will return addresses from the list of all addresses associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeAddresses for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidNextTokenException
//   The NextToken string was altered unexpectedly, and the operation has stopped.
//   Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeAddresses
func (c *Snowball) DescribeAddresses(input *DescribeAddressesInput) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	return out, req.Send()
}

// DescribeAddressesWithContext is the same as DescribeAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressesWithContext(ctx aws.Context, input *DescribeAddressesInput, opts ...request.Option) (*DescribeAddressesOutput, error) {
	req, out := c.DescribeAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddressesPages iterates over the pages of a DescribeAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAddresses operation.
//    pageNum := 0
//    err := client.DescribeAddressesPages(params,
//        func(page *snowball.DescribeAddressesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Snowball) DescribeAddressesPages(input *DescribeAddressesInput, fn func(*DescribeAddressesOutput, bool) bool) error {
	return c.DescribeAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddressesPagesWithContext same as DescribeAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeAddressesPagesWithContext(ctx aws.Context, input *DescribeAddressesInput, fn func(*DescribeAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddressesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster
func (c *Snowball) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Import/Export Snowball.
//
// Returns information about a specific cluster including shipping information,
// cluster status, and other important metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeCluster
func (c *Snowball) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeJob for more information on using the DescribeJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeJobRequest method.
//    req, resp := client.DescribeJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob
func (c *Snowball) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *DescribeJobOutput) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	output = &DescribeJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeJob API operation for Amazon Import/Export Snowball.
//
// Returns information about a specific job including shipping information,
// job status, and other important metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation DescribeJob for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/DescribeJob
func (c *Snowball) DescribeJob(input *DescribeJobInput) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	return out, req.Send()
}

// DescribeJobWithContext is the same as DescribeJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) DescribeJobWithContext(ctx aws.Context, input *DescribeJobInput, opts ...request.Option) (*DescribeJobOutput, error) {
	req, out := c.DescribeJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobManifest = "GetJobManifest"

// GetJobManifestRequest generates a "aws/request.Request" representing the
// client's request for the GetJobManifest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobManifest for more information on using the GetJobManifest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobManifestRequest method.
//    req, resp := client.GetJobManifestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest
func (c *Snowball) GetJobManifestRequest(input *GetJobManifestInput) (req *request.Request, output *GetJobManifestOutput) {
	op := &request.Operation{
		Name:       opGetJobManifest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobManifestInput{}
	}

	output = &GetJobManifestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobManifest API operation for Amazon Import/Export Snowball.
//
// Returns a link to an Amazon S3 presigned URL for the manifest file associated
// with the specified JobId value. You can access the manifest file for up to
// 60 minutes after this request has been made. To access the manifest file
// after 60 minutes have passed, you'll have to make another call to the GetJobManifest
// action.
//
// The manifest is an encrypted file that you can download after your job enters
// the WithCustomer status. The manifest is decrypted by using the UnlockCode
// code value, when you pass both values to the Snowball through the Snowball
// client when the client is started for the first time.
//
// As a best practice, we recommend that you don't save a copy of an UnlockCode
// value in the same location as the manifest file for that job. Saving these
// separately helps prevent unauthorized parties from gaining access to the
// Snowball associated with that job.
//
// The credentials of a given job, including its manifest file and unlock code,
// expire 90 days after the job is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobManifest for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobManifest
func (c *Snowball) GetJobManifest(input *GetJobManifestInput) (*GetJobManifestOutput, error) {
	req, out := c.GetJobManifestRequest(input)
	return out, req.Send()
}

// GetJobManifestWithContext is the same as GetJobManifest with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobManifest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetJobManifestWithContext(ctx aws.Context, input *GetJobManifestInput, opts ...request.Option) (*GetJobManifestOutput, error) {
	req, out := c.GetJobManifestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJobUnlockCode = "GetJobUnlockCode"

// GetJobUnlockCodeRequest generates a "aws/request.Request" representing the
// client's request for the GetJobUnlockCode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJobUnlockCode for more information on using the GetJobUnlockCode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetJobUnlockCodeRequest method.
//    req, resp := client.GetJobUnlockCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode
func (c *Snowball) GetJobUnlockCodeRequest(input *GetJobUnlockCodeInput) (req *request.Request, output *GetJobUnlockCodeOutput) {
	op := &request.Operation{
		Name:       opGetJobUnlockCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobUnlockCodeInput{}
	}

	output = &GetJobUnlockCodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetJobUnlockCode API operation for Amazon Import/Export Snowball.
//
// Returns the UnlockCode code value for the specified job. A particular UnlockCode
// value can be accessed for up to 90 days after the associated job has been
// created.
//
// The UnlockCode value is a 29-character code with 25 alphanumeric characters
// and 4 hyphens. This code is used to decrypt the manifest file when it is
// passed along with the manifest to the Snowball through the Snowball client
// when the client is started for the first time.
//
// As a best practice, we recommend that you don't save a copy of the UnlockCode
// in the same location as the manifest file for that job. Saving these separately
// helps prevent unauthorized parties from gaining access to the Snowball associated
// with that job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetJobUnlockCode for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetJobUnlockCode
func (c *Snowball) GetJobUnlockCode(input *GetJobUnlockCodeInput) (*GetJobUnlockCodeOutput, error) {
	req, out := c.GetJobUnlockCodeRequest(input)
	return out, req.Send()
}

// GetJobUnlockCodeWithContext is the same as GetJobUnlockCode with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobUnlockCode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetJobUnlockCodeWithContext(ctx aws.Context, input *GetJobUnlockCodeInput, opts ...request.Option) (*GetJobUnlockCodeOutput, error) {
	req, out := c.GetJobUnlockCodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnowballUsage = "GetSnowballUsage"

// GetSnowballUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetSnowballUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnowballUsage for more information on using the GetSnowballUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSnowballUsageRequest method.
//    req, resp := client.GetSnowballUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage
func (c *Snowball) GetSnowballUsageRequest(input *GetSnowballUsageInput) (req *request.Request, output *GetSnowballUsageOutput) {
	op := &request.Operation{
		Name:       opGetSnowballUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnowballUsageInput{}
	}

	output = &GetSnowballUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnowballUsage API operation for Amazon Import/Export Snowball.
//
// Returns information about the Snowball service limit for your account, and
// also the number of Snowballs your account has in use.
//
// The default service limit for the number of Snowballs that you can have at
// one time is 1. If you want to increase your service limit, contact AWS Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetSnowballUsage for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSnowballUsage
func (c *Snowball) GetSnowballUsage(input *GetSnowballUsageInput) (*GetSnowballUsageOutput, error) {
	req, out := c.GetSnowballUsageRequest(input)
	return out, req.Send()
}

// GetSnowballUsageWithContext is the same as GetSnowballUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnowballUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetSnowballUsageWithContext(ctx aws.Context, input *GetSnowballUsageInput, opts ...request.Option) (*GetSnowballUsageOutput, error) {
	req, out := c.GetSnowballUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSoftwareUpdates = "GetSoftwareUpdates"

// GetSoftwareUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the GetSoftwareUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSoftwareUpdates for more information on using the GetSoftwareUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSoftwareUpdatesRequest method.
//    req, resp := client.GetSoftwareUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates
func (c *Snowball) GetSoftwareUpdatesRequest(input *GetSoftwareUpdatesInput) (req *request.Request, output *GetSoftwareUpdatesOutput) {
	op := &request.Operation{
		Name:       opGetSoftwareUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSoftwareUpdatesInput{}
	}

	output = &GetSoftwareUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSoftwareUpdates API operation for Amazon Import/Export Snowball.
//
// Returns an Amazon S3 presigned URL for an update file associated with a specified
// JobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation GetSoftwareUpdates for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates
func (c *Snowball) GetSoftwareUpdates(input *GetSoftwareUpdatesInput) (*GetSoftwareUpdatesOutput, error) {
	req, out := c.GetSoftwareUpdatesRequest(input)
	return out, req.Send()
}

// GetSoftwareUpdatesWithContext is the same as GetSoftwareUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See GetSoftwareUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) GetSoftwareUpdatesWithContext(ctx aws.Context, input *GetSoftwareUpdatesInput, opts ...request.Option) (*GetSoftwareUpdatesOutput, error) {
	req, out := c.GetSoftwareUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusterJobs = "ListClusterJobs"

// ListClusterJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListClusterJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterJobs for more information on using the ListClusterJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClusterJobsRequest method.
//    req, resp := client.ListClusterJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs
func (c *Snowball) ListClusterJobsRequest(input *ListClusterJobsInput) (req *request.Request, output *ListClusterJobsOutput) {
	op := &request.Operation{
		Name:       opListClusterJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListClusterJobsInput{}
	}

	output = &ListClusterJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterJobs API operation for Amazon Import/Export Snowball.
//
// Returns an array of JobListEntry objects of the specified length. Each JobListEntry
// object is for a job in the specified cluster and contains a job's state,
// a job's ID, and other information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListClusterJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidNextTokenException
//   The NextToken string was altered unexpectedly, and the operation has stopped.
//   Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusterJobs
func (c *Snowball) ListClusterJobs(input *ListClusterJobsInput) (*ListClusterJobsOutput, error) {
	req, out := c.ListClusterJobsRequest(input)
	return out, req.Send()
}

// ListClusterJobsWithContext is the same as ListClusterJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClusterJobsWithContext(ctx aws.Context, input *ListClusterJobsInput, opts ...request.Option) (*ListClusterJobsOutput, error) {
	req, out := c.ListClusterJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters
func (c *Snowball) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Import/Export Snowball.
//
// Returns an array of ClusterListEntry objects of the specified length. Each
// ClusterListEntry object contains a cluster's state, a cluster's ID, and other
// important status information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken string was altered unexpectedly, and the operation has stopped.
//   Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListClusters
func (c *Snowball) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCompatibleImages = "ListCompatibleImages"

// ListCompatibleImagesRequest generates a "aws/request.Request" representing the
// client's request for the ListCompatibleImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCompatibleImages for more information on using the ListCompatibleImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListCompatibleImagesRequest method.
//    req, resp := client.ListCompatibleImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages
func (c *Snowball) ListCompatibleImagesRequest(input *ListCompatibleImagesInput) (req *request.Request, output *ListCompatibleImagesOutput) {
	op := &request.Operation{
		Name:       opListCompatibleImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListCompatibleImagesInput{}
	}

	output = &ListCompatibleImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCompatibleImages API operation for Amazon Import/Export Snowball.
//
// This action returns a list of the different Amazon EC2 Amazon Machine Images
// (AMIs) that are owned by your AWS account that would be supported for use
// on a Snowball Edge device. Currently, supported AMIs are based on the CentOS
// 7 (x86_64) - with Updates HVM, Ubuntu Server 14.04 LTS (HVM), and Ubuntu
// 16.04 LTS - Xenial (HVM) images, available on the AWS Marketplace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListCompatibleImages for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken string was altered unexpectedly, and the operation has stopped.
//   Run the operation without changing the NextToken string, and try again.
//
//   * Ec2RequestFailedException
//   Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListCompatibleImages
func (c *Snowball) ListCompatibleImages(input *ListCompatibleImagesInput) (*ListCompatibleImagesOutput, error) {
	req, out := c.ListCompatibleImagesRequest(input)
	return out, req.Send()
}

// ListCompatibleImagesWithContext is the same as ListCompatibleImages with the addition of
// the ability to pass a context and additional request options.
//
// See ListCompatibleImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListCompatibleImagesWithContext(ctx aws.Context, input *ListCompatibleImagesInput, opts ...request.Option) (*ListCompatibleImagesOutput, error) {
	req, out := c.ListCompatibleImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListJobsRequest method.
//    req, resp := client.ListJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs
func (c *Snowball) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListJobs API operation for Amazon Import/Export Snowball.
//
// Returns an array of JobListEntry objects of the specified length. Each JobListEntry
// object contains a job's state, a job's ID, and a value that indicates whether
// the job is a job part, in the case of export jobs. Calling this API action
// in one of the US regions will return jobs from the list of all jobs associated
// with this account in all US regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidNextTokenException
//   The NextToken string was altered unexpectedly, and the operation has stopped.
//   Run the operation without changing the NextToken string, and try again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/ListJobs
func (c *Snowball) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListJobs operation.
//    pageNum := 0
//    err := client.ListJobsPages(params,
//        func(page *snowball.ListJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Snowball) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterRequest method.
//    req, resp := client.UpdateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster
func (c *Snowball) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCluster API operation for Amazon Import/Export Snowball.
//
// While a cluster's ClusterState value is in the AwaitingQuorum state, you
// can update some of the information associated with a cluster. Once the cluster
// changes to a different job state, usually 60 minutes after the cluster being
// created, this action is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateCluster for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
//   * InvalidInputCombinationException
//   Job or cluster creation failed. One ore more inputs were invalid. Confirm
//   that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//   and try again.
//
//   * Ec2RequestFailedException
//   Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateCluster
func (c *Snowball) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateJobRequest method.
//    req, resp := client.UpdateJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob
func (c *Snowball) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateJob API operation for Amazon Import/Export Snowball.
//
// While a job's JobState value is New, you can update some of the information
// associated with a job. Once the job changes to a different job state, usually
// within 60 minutes of the job being created, this action is no longer available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Import/Export Snowball's
// API operation UpdateJob for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceException
//   The specified resource can't be found. Check the information you provided
//   in your last request, and try again.
//
//   * InvalidJobStateException
//   The action can't be performed because the job's current state doesn't allow
//   that action to be performed.
//
//   * KMSRequestFailedException
//   The provided AWS Key Management Service key lacks the permissions to perform
//   the specified CreateJob or UpdateJob action.
//
//   * InvalidInputCombinationException
//   Job or cluster creation failed. One ore more inputs were invalid. Confirm
//   that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
//   and try again.
//
//   * ClusterLimitExceededException
//   Job creation failed. Currently, clusters support five nodes. If you have
//   less than five nodes for your cluster and you have more nodes to create for
//   this cluster, try again and create jobs until your cluster has exactly five
//   notes.
//
//   * Ec2RequestFailedException
//   Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/UpdateJob
func (c *Snowball) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Snowball) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The address that you want the Snowball or Snowballs associated with a specific
// job to be shipped to. Addresses are validated at the time of creation. The
// address you provide must be located within the serviceable area of your region.
// Although no individual elements of the Address are required, if the address
// is invalid or unsupported, then an exception is thrown.
type Address struct {
	_ struct{} `type:"structure"`

	// The unique ID for an address.
	AddressId *string `min:"40" type:"string"`

	// The city in an address that a Snowball is to be delivered to.
	City *string `min:"1" type:"string"`

	// The name of the company to receive a Snowball at an address.
	Company *string `min:"1" type:"string"`

	// The country in an address that a Snowball is to be delivered to.
	Country *string `min:"1" type:"string"`

	// If the address you are creating is a primary address, then set this option
	// to true. This field is not supported in most regions.
	IsRestricted *bool `type:"boolean"`

	// This field is no longer used and the value is ignored.
	Landmark *string `min:"1" type:"string"`

	// The name of a person to receive a Snowball at an address.
	Name *string `min:"1" type:"string"`

	// The phone number associated with an address that a Snowball is to be delivered
	// to.
	PhoneNumber *string `min:"1" type:"string"`

	// The postal code in an address that a Snowball is to be delivered to.
	PostalCode *string `min:"1" type:"string"`

	// This field is no longer used and the value is ignored.
	PrefectureOrDistrict *string `min:"1" type:"string"`

	// The state or province in an address that a Snowball is to be delivered to.
	StateOrProvince *string `min:"1" type:"string"`

	// The first line in a street address that a Snowball is to be delivered to.
	Street1 *string `min:"1" type:"string"`

	// The second line in a street address that a Snowball is to be delivered to.
	Street2 *string `min:"1" type:"string"`

	// The third line in a street address that a Snowball is to be delivered to.
	Street3 *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Company != nil && len(*s.Company) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Company", 1))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.Landmark != nil && len(*s.Landmark) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Landmark", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.PrefectureOrDistrict != nil && len(*s.PrefectureOrDistrict) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrefectureOrDistrict", 1))
	}
	if s.StateOrProvince != nil && len(*s.StateOrProvince) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StateOrProvince", 1))
	}
	if s.Street1 != nil && len(*s.Street1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street1", 1))
	}
	if s.Street2 != nil && len(*s.Street2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street2", 1))
	}
	if s.Street3 != nil && len(*s.Street3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Street3", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *Address) SetAddressId(v string) *Address {
	s.AddressId = &v
	return s
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCompany sets the Company field's value.
func (s *Address) SetCompany(v string) *Address {
	s.Company = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetIsRestricted sets the IsRestricted field's value.
func (s *Address) SetIsRestricted(v bool) *Address {
	s.IsRestricted = &v
	return s
}

// SetLandmark sets the Landmark field's value.
func (s *Address) SetLandmark(v string) *Address {
	s.Landmark = &v
	return s
}

// SetName sets the Name field's value.
func (s *Address) SetName(v string) *Address {
	s.Name = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Address) SetPhoneNumber(v string) *Address {
	s.PhoneNumber = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetPrefectureOrDistrict sets the PrefectureOrDistrict field's value.
func (s *Address) SetPrefectureOrDistrict(v string) *Address {
	s.PrefectureOrDistrict = &v
	return s
}

// SetStateOrProvince sets the StateOrProvince field's value.
func (s *Address) SetStateOrProvince(v string) *Address {
	s.StateOrProvince = &v
	return s
}

// SetStreet1 sets the Street1 field's value.
func (s *Address) SetStreet1(v string) *Address {
	s.Street1 = &v
	return s
}

// SetStreet2 sets the Street2 field's value.
func (s *Address) SetStreet2(v string) *Address {
	s.Street2 = &v
	return s
}

// SetStreet3 sets the Street3 field's value.
func (s *Address) SetStreet3(v string) *Address {
	s.Street3 = &v
	return s
}

type CancelClusterInput struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to cancel, for example
	// CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *CancelClusterInput) SetClusterId(v string) *CancelClusterInput {
	s.ClusterId = &v
	return s
}

type CancelClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelClusterOutput) GoString() string {
	return s.String()
}

type CancelJobInput struct {
	_ struct{} `type:"structure"`

	// The 39-character job ID for the job that you want to cancel, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *CancelJobInput) SetJobId(v string) *CancelJobInput {
	s.JobId = &v
	return s
}

type CancelJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelJobOutput) GoString() string {
	return s.String()
}

// Job creation failed. Currently, clusters support five nodes. If you have
// less than five nodes for your cluster and you have more nodes to create for
// this cluster, try again and create jobs until your cluster has exactly five
// notes.
type ClusterLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ClusterLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterLimitExceededException) GoString() string {
	return s.String()
}

func newErrorClusterLimitExceededException(v protocol.ResponseMetadata) error {
	return &ClusterLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClusterLimitExceededException) Code() string {
	return "ClusterLimitExceededException"
}

// Message returns the exception's message.
func (s *ClusterLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClusterLimitExceededException) OrigErr() error {
	return nil
}

func (s *ClusterLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClusterLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClusterLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a cluster's state, a cluster's ID, and other important information.
type ClusterListEntry struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to list, for example CID123e4567-e89b-12d3-a456-426655440000.
	ClusterId *string `min:"1" type:"string"`

	// The current state of this cluster. For information about the state of a specific
	// node, see JobListEntry$JobState.
	ClusterState *string `type:"string" enum:"ClusterState"`

	// The creation date for this cluster.
	CreationDate *time.Time `type:"timestamp"`

	// Defines an optional description of the cluster, for example Environmental
	// Data Cluster-01.
	Description *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ClusterListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterListEntry) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *ClusterListEntry) SetClusterId(v string) *ClusterListEntry {
	s.ClusterId = &v
	return s
}

// SetClusterState sets the ClusterState field's value.
func (s *ClusterListEntry) SetClusterState(v string) *ClusterListEntry {
	s.ClusterState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ClusterListEntry) SetCreationDate(v time.Time) *ClusterListEntry {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterListEntry) SetDescription(v string) *ClusterListEntry {
	s.Description = &v
	return s
}

// Contains metadata about a specific cluster.
type ClusterMetadata struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	AddressId *string `min:"40" type:"string"`

	// The automatically generated ID for a cluster.
	ClusterId *string `min:"1" type:"string"`

	// The current status of the cluster.
	ClusterState *string `type:"string" enum:"ClusterState"`

	// The creation date for this cluster.
	CreationDate *time.Time `type:"timestamp"`

	// The optional description of the cluster.
	Description *string `min:"1" type:"string"`

	// The ID of the address that you want a cluster shipped to, after it will be
	// shipped to its primary address. This field is not supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The type of job for this cluster. Currently, the only job type supported
	// for clusters is LOCAL_USE.
	JobType *string `type:"string" enum:"JobType"`

	// The KmsKeyARN Amazon Resource Name (ARN) associated with this cluster. This
	// ARN was created using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in AWS Key Management Service (AWS KMS).
	KmsKeyARN *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// for this cluster.
	Notification *Notification `type:"structure"`

	// The arrays of JobResource objects that can include updated S3Resource objects
	// or LambdaResource objects.
	Resources *JobResource `type:"structure"`

	// The role ARN associated with this cluster. This ARN was created using the
	// CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in AWS Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// The shipping speed for each node in this cluster. This speed doesn't dictate
	// how soon you'll get each Snowball Edge device, rather it represents how quickly
	// each device moves to its destination while in transit. Regional shipping
	// speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowball Edges shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowball Edges are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// The type of AWS Snowball device to use for this cluster. Currently, the only
	// supported device type for cluster jobs is EDGE.
	//
	// For more information, see Snowball Edge Device Options (https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html)
	// in the Snowball Edge Developer Guide.
	SnowballType *string `type:"string" enum:"Type"`

	// The tax documents required in your AWS Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation
func (s ClusterMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterMetadata) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *ClusterMetadata) SetAddressId(v string) *ClusterMetadata {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ClusterMetadata) SetClusterId(v string) *ClusterMetadata {
	s.ClusterId = &v
	return s
}

// SetClusterState sets the ClusterState field's value.
func (s *ClusterMetadata) SetClusterState(v string) *ClusterMetadata {
	s.ClusterState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *ClusterMetadata) SetCreationDate(v time.Time) *ClusterMetadata {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClusterMetadata) SetDescription(v string) *ClusterMetadata {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *ClusterMetadata) SetForwardingAddressId(v string) *ClusterMetadata {
	s.ForwardingAddressId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *ClusterMetadata) SetJobType(v string) *ClusterMetadata {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *ClusterMetadata) SetKmsKeyARN(v string) *ClusterMetadata {
	s.KmsKeyARN = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *ClusterMetadata) SetNotification(v *Notification) *ClusterMetadata {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *ClusterMetadata) SetResources(v *JobResource) *ClusterMetadata {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ClusterMetadata) SetRoleARN(v string) *ClusterMetadata {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *ClusterMetadata) SetShippingOption(v string) *ClusterMetadata {
	s.ShippingOption = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *ClusterMetadata) SetSnowballType(v string) *ClusterMetadata {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *ClusterMetadata) SetTaxDocuments(v *TaxDocuments) *ClusterMetadata {
	s.TaxDocuments = v
	return s
}

// A JSON-formatted object that describes a compatible Amazon Machine Image
// (AMI), including the ID and name for a Snowball Edge AMI. This AMI is compatible
// with the device's physical hardware requirements, and it should be able to
// be run in an SBE1 instance on the device.
type CompatibleImage struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an individual Snowball Edge AMI.
	AmiId *string `min:"1" type:"string"`

	// The optional name of a compatible image.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CompatibleImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompatibleImage) GoString() string {
	return s.String()
}

// SetAmiId sets the AmiId field's value.
func (s *CompatibleImage) SetAmiId(v string) *CompatibleImage {
	s.AmiId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CompatibleImage) SetName(v string) *CompatibleImage {
	s.Name = &v
	return s
}

type CreateAddressInput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball shipped to.
	//
	// Address is a required field
	Address *Address `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddressInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CreateAddressInput) SetAddress(v *Address) *CreateAddressInput {
	s.Address = v
	return s
}

type CreateAddressOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address. You'll use this ID
	// when you create a job to specify which address you want the Snowball for
	// that job shipped to.
	AddressId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAddressOutput) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *CreateAddressOutput) SetAddressId(v string) *CreateAddressOutput {
	s.AddressId = &v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the cluster shipped to.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`

	// An optional description of this specific cluster, for example Environmental
	// Data Cluster-01.
	Description *string `min:"1" type:"string"`

	// The forwarding address ID for a cluster. This field is not supported in most
	// regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The type of job for this cluster. Currently, the only job type supported
	// for clusters is LOCAL_USE.
	//
	// JobType is a required field
	JobType *string `type:"string" required:"true" enum:"JobType"`

	// The KmsKeyARN value that you want to associate with this cluster. KmsKeyARN
	// values are created by using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in AWS Key Management Service (AWS KMS).
	KmsKeyARN *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// for this cluster.
	Notification *Notification `type:"structure"`

	// The resources associated with the cluster job. These resources include Amazon
	// S3 buckets and optional AWS Lambda functions written in the Python language.
	//
	// Resources is a required field
	Resources *JobResource `type:"structure" required:"true"`

	// The RoleARN that you want to associate with this cluster. RoleArn values
	// are created by using the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in AWS Identity and Access Management (IAM).
	//
	// RoleARN is a required field
	RoleARN *string `type:"string" required:"true"`

	// The shipping speed for each node in this cluster. This speed doesn't dictate
	// how soon you'll get each Snowball Edge device, rather it represents how quickly
	// each device moves to its destination while in transit. Regional shipping
	// speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, devices
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowball Edges shipped express are delivered in about a day. In addition,
	//    most countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowball Edges are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	//
	// ShippingOption is a required field
	ShippingOption *string `type:"string" required:"true" enum:"ShippingOption"`

	// The type of AWS Snowball device to use for this cluster. Currently, the only
	// supported device type for cluster jobs is EDGE.
	//
	// For more information, see Snowball Edge Device Options (https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html)
	// in the Snowball Edge Developer Guide.
	SnowballType *string `type:"string" enum:"Type"`

	// The tax documents required in your AWS Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.JobType == nil {
		invalidParams.Add(request.NewErrParamRequired("JobType"))
	}
	if s.Resources == nil {
		invalidParams.Add(request.NewErrParamRequired("Resources"))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.ShippingOption == nil {
		invalidParams.Add(request.NewErrParamRequired("ShippingOption"))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *CreateClusterInput) SetAddressId(v string) *CreateClusterInput {
	s.AddressId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterInput) SetDescription(v string) *CreateClusterInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *CreateClusterInput) SetForwardingAddressId(v string) *CreateClusterInput {
	s.ForwardingAddressId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateClusterInput) SetJobType(v string) *CreateClusterInput {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *CreateClusterInput) SetKmsKeyARN(v string) *CreateClusterInput {
	s.KmsKeyARN = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateClusterInput) SetNotification(v *Notification) *CreateClusterInput {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateClusterInput) SetResources(v *JobResource) *CreateClusterInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateClusterInput) SetRoleARN(v string) *CreateClusterInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *CreateClusterInput) SetShippingOption(v string) *CreateClusterInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *CreateClusterInput) SetSnowballType(v string) *CreateClusterInput {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *CreateClusterInput) SetTaxDocuments(v *TaxDocuments) *CreateClusterInput {
	s.TaxDocuments = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a cluster.
	ClusterId *string `min:"39" type:"string"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateClusterOutput) SetClusterId(v string) *CreateClusterOutput {
	s.ClusterId = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snowball shipped to.
	AddressId *string `min:"40" type:"string"`

	// The ID of a cluster. If you're creating a job for a node in a cluster, you
	// need to provide only this clusterId value. The other job attributes are inherited
	// from the cluster.
	ClusterId *string `min:"39" type:"string"`

	// Defines an optional description of this specific job, for example Important
	// Photos 2016-08-11.
	Description *string `min:"1" type:"string"`

	// The forwarding address ID for a job. This field is not supported in most
	// regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// Defines the type of job that you're creating.
	JobType *string `type:"string" enum:"JobType"`

	// The KmsKeyARN that you want to associate with this job. KmsKeyARNs are created
	// using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// AWS Key Management Service (KMS) API action.
	KmsKeyARN *string `type:"string"`

	// Defines the Amazon Simple Notification Service (Amazon SNS) notification
	// settings for this job.
	Notification *Notification `type:"structure"`

	// Defines the Amazon S3 buckets associated with this job.
	//
	// With IMPORT jobs, you specify the bucket or buckets that your transferred
	// data will be imported into.
	//
	// With EXPORT jobs, you specify the bucket or buckets that your transferred
	// data will be exported from. Optionally, you can also specify a KeyRange value.
	// If you choose to export a range, you define the length of the range by providing
	// either an inclusive BeginMarker value, an inclusive EndMarker value, or both.
	// Ranges are UTF-8 binary sorted.
	Resources *JobResource `type:"structure"`

	// The RoleARN that you want to associate with this job. RoleArns are created
	// using the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// AWS Identity and Access Management (IAM) API action.
	RoleARN *string `type:"string"`

	// The shipping speed for this job. This speed doesn't dictate how soon you'll
	// get the Snowball, rather it represents how quickly the Snowball moves to
	// its destination while in transit. Regional shipping speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snowballs
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowballs shipped express are delivered in about a day. In addition, most
	//    countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowballs are delivered in one to seven days.
	//
	//    * In the US, you have access to one-day shipping and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// If your job is being created in one of the US regions, you have the option
	// of specifying what size Snowball you'd like for this job. In all other regions,
	// Snowballs come with 80 TB in storage capacity.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`

	// The type of AWS Snowball device to use for this job. Currently, the only
	// supported device type for cluster jobs is EDGE.
	//
	// For more information, see Snowball Edge Device Options (https://docs.aws.amazon.com/snowball/latest/developer-guide/device-differences.html)
	// in the Snowball Edge Developer Guide.
	SnowballType *string `type:"string" enum:"Type"`

	// The tax documents required in your AWS Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *CreateJobInput) SetAddressId(v string) *CreateJobInput {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *CreateJobInput) SetClusterId(v string) *CreateJobInput {
	s.ClusterId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateJobInput) SetDescription(v string) *CreateJobInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *CreateJobInput) SetForwardingAddressId(v string) *CreateJobInput {
	s.ForwardingAddressId = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *CreateJobInput) SetJobType(v string) *CreateJobInput {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *CreateJobInput) SetKmsKeyARN(v string) *CreateJobInput {
	s.KmsKeyARN = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *CreateJobInput) SetNotification(v *Notification) *CreateJobInput {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *CreateJobInput) SetResources(v *JobResource) *CreateJobInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *CreateJobInput) SetRoleARN(v string) *CreateJobInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *CreateJobInput) SetShippingOption(v string) *CreateJobInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *CreateJobInput) SetSnowballCapacityPreference(v string) *CreateJobInput {
	s.SnowballCapacityPreference = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *CreateJobInput) SetSnowballType(v string) *CreateJobInput {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *CreateJobInput) SetTaxDocuments(v *TaxDocuments) *CreateJobInput {
	s.TaxDocuments = v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"39" type:"string"`
}

// String returns the string representation
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

// Defines the real-time status of a Snowball's data transfer while the device
// is at AWS. This data is only available while a job has a JobState value of
// InProgress, for both import and export jobs.
type DataTransfer struct {
	_ struct{} `type:"structure"`

	// The number of bytes transferred between a Snowball and Amazon S3.
	BytesTransferred *int64 `type:"long"`

	// The number of objects transferred between a Snowball and Amazon S3.
	ObjectsTransferred *int64 `type:"long"`

	// The total bytes of data for a transfer between a Snowball and Amazon S3.
	// This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalBytes *int64 `type:"long"`

	// The total number of objects for a transfer between a Snowball and Amazon
	// S3. This value is set to 0 (zero) until all the keys that will be transferred
	// have been listed.
	TotalObjects *int64 `type:"long"`
}

// String returns the string representation
func (s DataTransfer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataTransfer) GoString() string {
	return s.String()
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *DataTransfer) SetBytesTransferred(v int64) *DataTransfer {
	s.BytesTransferred = &v
	return s
}

// SetObjectsTransferred sets the ObjectsTransferred field's value.
func (s *DataTransfer) SetObjectsTransferred(v int64) *DataTransfer {
	s.ObjectsTransferred = &v
	return s
}

// SetTotalBytes sets the TotalBytes field's value.
func (s *DataTransfer) SetTotalBytes(v int64) *DataTransfer {
	s.TotalBytes = &v
	return s
}

// SetTotalObjects sets the TotalObjects field's value.
func (s *DataTransfer) SetTotalObjects(v int64) *DataTransfer {
	s.TotalObjects = &v
	return s
}

type DescribeAddressInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a specific address.
	//
	// AddressId is a required field
	AddressId *string `min:"40" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressInput"}
	if s.AddressId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressId"))
	}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *DescribeAddressInput) SetAddressId(v string) *DescribeAddressInput {
	s.AddressId = &v
	return s
}

type DescribeAddressOutput struct {
	_ struct{} `type:"structure"`

	// The address that you want the Snowball or Snowballs associated with a specific
	// job to be shipped to.
	Address *Address `type:"structure"`
}

// String returns the string representation
func (s DescribeAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *DescribeAddressOutput) SetAddress(v *Address) *DescribeAddressOutput {
	s.Address = v
	return s
}

type DescribeAddressesInput struct {
	_ struct{} `type:"structure"`

	// The number of ADDRESS objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ADDRESS objects, you have the option of specifying a value for NextToken
	// as the starting point for your list of returned addresses.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAddressesInput) SetMaxResults(v int64) *DescribeAddressesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddressesInput) SetNextToken(v string) *DescribeAddressesInput {
	s.NextToken = &v
	return s
}

type DescribeAddressesOutput struct {
	_ struct{} `type:"structure"`

	// The Snowball shipping addresses that were created for this account.
	Addresses []*Address `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next DescribeAddresses call, your list of returned addresses
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressesOutput) GoString() string {
	return s.String()
}

// SetAddresses sets the Addresses field's value.
func (s *DescribeAddressesOutput) SetAddresses(v []*Address) *DescribeAddressesOutput {
	s.Addresses = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddressesOutput) SetNextToken(v string) *DescribeAddressesOutput {
	s.NextToken = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a cluster.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *DescribeClusterInput) SetClusterId(v string) *DescribeClusterInput {
	s.ClusterId = &v
	return s
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// Information about a specific cluster, including shipping information, cluster
	// status, and other important metadata.
	ClusterMetadata *ClusterMetadata `type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetClusterMetadata sets the ClusterMetadata field's value.
func (s *DescribeClusterOutput) SetClusterMetadata(v *ClusterMetadata) *DescribeClusterOutput {
	s.ClusterMetadata = v
	return s
}

type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeJobInput) SetJobId(v string) *DescribeJobInput {
	s.JobId = &v
	return s
}

type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Information about a specific job, including shipping information, job status,
	// and other important metadata.
	JobMetadata *JobMetadata `type:"structure"`

	// Information about a specific job part (in the case of an export job), including
	// shipping information, job status, and other important metadata.
	SubJobMetadata []*JobMetadata `type:"list"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobOutput) GoString() string {
	return s.String()
}

// SetJobMetadata sets the JobMetadata field's value.
func (s *DescribeJobOutput) SetJobMetadata(v *JobMetadata) *DescribeJobOutput {
	s.JobMetadata = v
	return s
}

// SetSubJobMetadata sets the SubJobMetadata field's value.
func (s *DescribeJobOutput) SetSubJobMetadata(v []*JobMetadata) *DescribeJobOutput {
	s.SubJobMetadata = v
	return s
}

// A JSON-formatted object that contains the IDs for an Amazon Machine Image
// (AMI), including the Amazon EC2 AMI ID and the Snowball Edge AMI ID. Each
// AMI has these two IDs to simplify identifying the AMI in both the AWS Cloud
// and on the device.
type Ec2AmiResource struct {
	_ struct{} `type:"structure"`

	// The ID of the AMI in Amazon EC2.
	//
	// AmiId is a required field
	AmiId *string `min:"12" type:"string" required:"true"`

	// The ID of the AMI on the Snowball Edge device.
	SnowballAmiId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Ec2AmiResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2AmiResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2AmiResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2AmiResource"}
	if s.AmiId == nil {
		invalidParams.Add(request.NewErrParamRequired("AmiId"))
	}
	if s.AmiId != nil && len(*s.AmiId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AmiId", 12))
	}
	if s.SnowballAmiId != nil && len(*s.SnowballAmiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnowballAmiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiId sets the AmiId field's value.
func (s *Ec2AmiResource) SetAmiId(v string) *Ec2AmiResource {
	s.AmiId = &v
	return s
}

// SetSnowballAmiId sets the SnowballAmiId field's value.
func (s *Ec2AmiResource) SetSnowballAmiId(v string) *Ec2AmiResource {
	s.SnowballAmiId = &v
	return s
}

// Your IAM user lacks the necessary Amazon EC2 permissions to perform the attempted
// action.
type Ec2RequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s Ec2RequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2RequestFailedException) GoString() string {
	return s.String()
}

func newErrorEc2RequestFailedException(v protocol.ResponseMetadata) error {
	return &Ec2RequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *Ec2RequestFailedException) Code() string {
	return "Ec2RequestFailedException"
}

// Message returns the exception's message.
func (s *Ec2RequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *Ec2RequestFailedException) OrigErr() error {
	return nil
}

func (s *Ec2RequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *Ec2RequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *Ec2RequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The container for the EventTriggerDefinition$EventResourceARN.
type EventTriggerDefinition struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for any local Amazon S3 resource that is an
	// AWS Lambda function's event trigger associated with this job.
	EventResourceARN *string `type:"string"`
}

// String returns the string representation
func (s EventTriggerDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventTriggerDefinition) GoString() string {
	return s.String()
}

// SetEventResourceARN sets the EventResourceARN field's value.
func (s *EventTriggerDefinition) SetEventResourceARN(v string) *EventTriggerDefinition {
	s.EventResourceARN = &v
	return s
}

type GetJobManifestInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the manifest file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobManifestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobManifestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobManifestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobManifestInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobManifestInput) SetJobId(v string) *GetJobManifestInput {
	s.JobId = &v
	return s
}

type GetJobManifestOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the manifest file associated with the specified
	// JobId value.
	ManifestURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetJobManifestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobManifestOutput) GoString() string {
	return s.String()
}

// SetManifestURI sets the ManifestURI field's value.
func (s *GetJobManifestOutput) SetManifestURI(v string) *GetJobManifestOutput {
	s.ManifestURI = &v
	return s
}

type GetJobUnlockCodeInput struct {
	_ struct{} `type:"structure"`

	// The ID for the job that you want to get the UnlockCode value for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetJobUnlockCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobUnlockCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobUnlockCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobUnlockCodeInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetJobUnlockCodeInput) SetJobId(v string) *GetJobUnlockCodeInput {
	s.JobId = &v
	return s
}

type GetJobUnlockCodeOutput struct {
	_ struct{} `type:"structure"`

	// The UnlockCode value for the specified job. The UnlockCode value can be accessed
	// for up to 90 days after the job has been created.
	UnlockCode *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetJobUnlockCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobUnlockCodeOutput) GoString() string {
	return s.String()
}

// SetUnlockCode sets the UnlockCode field's value.
func (s *GetJobUnlockCodeOutput) SetUnlockCode(v string) *GetJobUnlockCodeOutput {
	s.UnlockCode = &v
	return s
}

type GetSnowballUsageInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetSnowballUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnowballUsageInput) GoString() string {
	return s.String()
}

type GetSnowballUsageOutput struct {
	_ struct{} `type:"structure"`

	// The service limit for number of Snowballs this account can have at once.
	// The default service limit is 1 (one).
	SnowballLimit *int64 `type:"integer"`

	// The number of Snowballs that this account is currently using.
	SnowballsInUse *int64 `type:"integer"`
}

// String returns the string representation
func (s GetSnowballUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnowballUsageOutput) GoString() string {
	return s.String()
}

// SetSnowballLimit sets the SnowballLimit field's value.
func (s *GetSnowballUsageOutput) SetSnowballLimit(v int64) *GetSnowballUsageOutput {
	s.SnowballLimit = &v
	return s
}

// SetSnowballsInUse sets the SnowballsInUse field's value.
func (s *GetSnowballUsageOutput) SetSnowballsInUse(v int64) *GetSnowballUsageOutput {
	s.SnowballsInUse = &v
	return s
}

type GetSoftwareUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the software update file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSoftwareUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSoftwareUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSoftwareUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSoftwareUpdatesInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetSoftwareUpdatesInput) SetJobId(v string) *GetSoftwareUpdatesInput {
	s.JobId = &v
	return s
}

type GetSoftwareUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the update file associated with the specified
	// JobId value. The software update will be available for 2 days after this
	// request is made. To access an update after the 2 days have passed, you'll
	// have to make another call to GetSoftwareUpdates.
	UpdatesURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetSoftwareUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSoftwareUpdatesOutput) GoString() string {
	return s.String()
}

// SetUpdatesURI sets the UpdatesURI field's value.
func (s *GetSoftwareUpdatesOutput) SetUpdatesURI(v string) *GetSoftwareUpdatesOutput {
	s.UpdatesURI = &v
	return s
}

// The tax documents required in AWS Regions in India.
type INDTaxDocuments struct {
	_ struct{} `type:"structure"`

	// The Goods and Services Tax (GST) documents required in AWS Regions in India.
	GSTIN *string `type:"string"`
}

// String returns the string representation
func (s INDTaxDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s INDTaxDocuments) GoString() string {
	return s.String()
}

// SetGSTIN sets the GSTIN field's value.
func (s *INDTaxDocuments) SetGSTIN(v string) *INDTaxDocuments {
	s.GSTIN = &v
	return s
}

// The address provided was invalid. Check the address with your region's carrier,
// and try again.
type InvalidAddressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidAddressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidAddressException) GoString() string {
	return s.String()
}

func newErrorInvalidAddressException(v protocol.ResponseMetadata) error {
	return &InvalidAddressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidAddressException) Code() string {
	return "InvalidAddressException"
}

// Message returns the exception's message.
func (s *InvalidAddressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidAddressException) OrigErr() error {
	return nil
}

func (s *InvalidAddressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidAddressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidAddressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Job or cluster creation failed. One ore more inputs were invalid. Confirm
// that the CreateClusterRequest$SnowballType value supports your CreateJobRequest$JobType,
// and try again.
type InvalidInputCombinationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidInputCombinationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInputCombinationException) GoString() string {
	return s.String()
}

func newErrorInvalidInputCombinationException(v protocol.ResponseMetadata) error {
	return &InvalidInputCombinationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInputCombinationException) Code() string {
	return "InvalidInputCombinationException"
}

// Message returns the exception's message.
func (s *InvalidInputCombinationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInputCombinationException) OrigErr() error {
	return nil
}

func (s *InvalidInputCombinationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInputCombinationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInputCombinationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The action can't be performed because the job's current state doesn't allow
// that action to be performed.
type InvalidJobStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidJobStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidJobStateException) GoString() string {
	return s.String()
}

func newErrorInvalidJobStateException(v protocol.ResponseMetadata) error {
	return &InvalidJobStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidJobStateException) Code() string {
	return "InvalidJobStateException"
}

// Message returns the exception's message.
func (s *InvalidJobStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidJobStateException) OrigErr() error {
	return nil
}

func (s *InvalidJobStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidJobStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidJobStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken string was altered unexpectedly, and the operation has stopped.
// Run the operation without changing the NextToken string, and try again.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource can't be found. Check the information you provided
// in your last request, and try again.
type InvalidResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`

	// The provided resource value is invalid.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResourceException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceException(v protocol.ResponseMetadata) error {
	return &InvalidResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceException) Code() string {
	return "InvalidResourceException"
}

// Message returns the exception's message.
func (s *InvalidResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceException) OrigErr() error {
	return nil
}

func (s *InvalidResourceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Each JobListEntry object contains a job's state, a job's ID, and a value
// that indicates whether the job is a job part, in the case of an export job.
type JobListEntry struct {
	_ struct{} `type:"structure"`

	// The creation date for this job.
	CreationDate *time.Time `type:"timestamp"`

	// The optional description of this specific job, for example Important Photos
	// 2016-08-11.
	Description *string `min:"1" type:"string"`

	// A value that indicates that this job is a master job. A master job represents
	// a successful request to create an export job. Master jobs aren't associated
	// with any Snowballs. Instead, each master job will have at least one job part,
	// and each job part is associated with a Snowball. It might take some time
	// before the job parts associated with a particular master job are listed,
	// because they are created after the master job is created.
	IsMaster *bool `type:"boolean"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// The current state of this job.
	JobState *string `type:"string" enum:"JobState"`

	// The type of job.
	JobType *string `type:"string" enum:"JobType"`

	// The type of device used with this job.
	SnowballType *string `type:"string" enum:"Type"`
}

// String returns the string representation
func (s JobListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobListEntry) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *JobListEntry) SetCreationDate(v time.Time) *JobListEntry {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobListEntry) SetDescription(v string) *JobListEntry {
	s.Description = &v
	return s
}

// SetIsMaster sets the IsMaster field's value.
func (s *JobListEntry) SetIsMaster(v bool) *JobListEntry {
	s.IsMaster = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobListEntry) SetJobId(v string) *JobListEntry {
	s.JobId = &v
	return s
}

// SetJobState sets the JobState field's value.
func (s *JobListEntry) SetJobState(v string) *JobListEntry {
	s.JobState = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobListEntry) SetJobType(v string) *JobListEntry {
	s.JobType = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *JobListEntry) SetSnowballType(v string) *JobListEntry {
	s.SnowballType = &v
	return s
}

// Contains job logs. Whenever Snowball is used to import data into or export
// data out of Amazon S3, you'll have the option of downloading a PDF job report.
// Job logs are returned as a part of the response syntax of the DescribeJob
// action in the JobMetadata data type. The job logs can be accessed for up
// to 60 minutes after this request has been made. To access any of the job
// logs after 60 minutes have passed, you'll have to make another call to the
// DescribeJob action.
//
// For import jobs, the PDF job report becomes available at the end of the import
// process. For export jobs, your job report typically becomes available while
// the Snowball for your job part is being delivered to you.
//
// The job report provides you insight into the state of your Amazon S3 data
// transfer. The report includes details about your job or job part for your
// records.
//
// For deeper visibility into the status of your transferred objects, you can
// look at the two associated logs: a success log and a failure log. The logs
// are saved in comma-separated value (CSV) format, and the name of each log
// includes the ID of the job or job part that the log describes.
type JobLogs struct {
	_ struct{} `type:"structure"`

	// A link to an Amazon S3 presigned URL where the job completion report is located.
	JobCompletionReportURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job failure log is located.
	JobFailureLogURI *string `min:"1" type:"string"`

	// A link to an Amazon S3 presigned URL where the job success log is located.
	JobSuccessLogURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s JobLogs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobLogs) GoString() string {
	return s.String()
}

// SetJobCompletionReportURI sets the JobCompletionReportURI field's value.
func (s *JobLogs) SetJobCompletionReportURI(v string) *JobLogs {
	s.JobCompletionReportURI = &v
	return s
}

// SetJobFailureLogURI sets the JobFailureLogURI field's value.
func (s *JobLogs) SetJobFailureLogURI(v string) *JobLogs {
	s.JobFailureLogURI = &v
	return s
}

// SetJobSuccessLogURI sets the JobSuccessLogURI field's value.
func (s *JobLogs) SetJobSuccessLogURI(v string) *JobLogs {
	s.JobSuccessLogURI = &v
	return s
}

// Contains information about a specific job including shipping information,
// job status, and other important metadata. This information is returned as
// a part of the response syntax of the DescribeJob action.
type JobMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for the address that you want the Snowball shipped to.
	AddressId *string `min:"40" type:"string"`

	// The 39-character ID for the cluster, for example CID123e4567-e89b-12d3-a456-426655440000.
	ClusterId *string `min:"1" type:"string"`

	// The creation date for this job.
	CreationDate *time.Time `type:"timestamp"`

	// A value that defines the real-time status of a Snowball's data transfer while
	// the device is at AWS. This data is only available while a job has a JobState
	// value of InProgress, for both import and export jobs.
	DataTransferProgress *DataTransfer `type:"structure"`

	// The description of the job, provided at job creation.
	Description *string `min:"1" type:"string"`

	// The ID of the address that you want a job shipped to, after it will be shipped
	// to its primary address. This field is not supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The automatically generated ID for a job, for example JID123e4567-e89b-12d3-a456-426655440000.
	JobId *string `min:"1" type:"string"`

	// Links to Amazon S3 presigned URLs for the job report and logs. For import
	// jobs, the PDF job report becomes available at the end of the import process.
	// For export jobs, your job report typically becomes available while the Snowball
	// for your job part is being delivered to you.
	JobLogInfo *JobLogs `type:"structure"`

	// The current status of the jobs.
	JobState *string `type:"string" enum:"JobState"`

	// The type of job.
	JobType *string `type:"string" enum:"JobType"`

	// The Amazon Resource Name (ARN) for the AWS Key Management Service (AWS KMS)
	// key associated with this job. This ARN was created using the CreateKey (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateKey.html)
	// API action in AWS KMS.
	KmsKeyARN *string `type:"string"`

	// The Amazon Simple Notification Service (Amazon SNS) notification settings
	// associated with a specific job. The Notification object is returned as a
	// part of the response syntax of the DescribeJob action in the JobMetadata
	// data type.
	Notification *Notification `type:"structure"`

	// An array of S3Resource objects. Each S3Resource object represents an Amazon
	// S3 bucket that your transferred data will be exported from or imported into.
	Resources *JobResource `type:"structure"`

	// The role ARN associated with this job. This ARN was created using the CreateRole
	// (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in AWS Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// A job's shipping information, including inbound and outbound tracking numbers
	// and shipping speed options.
	ShippingDetails *ShippingDetails `type:"structure"`

	// The Snowball capacity preference for this job, specified at job creation.
	// In US regions, you can choose between 50 TB and 80 TB Snowballs. All other
	// regions use 80 TB capacity Snowballs.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`

	// The type of device used with this job.
	SnowballType *string `type:"string" enum:"Type"`

	// The metadata associated with the tax documents required in your AWS Region.
	TaxDocuments *TaxDocuments `type:"structure"`
}

// String returns the string representation
func (s JobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobMetadata) GoString() string {
	return s.String()
}

// SetAddressId sets the AddressId field's value.
func (s *JobMetadata) SetAddressId(v string) *JobMetadata {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *JobMetadata) SetClusterId(v string) *JobMetadata {
	s.ClusterId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *JobMetadata) SetCreationDate(v time.Time) *JobMetadata {
	s.CreationDate = &v
	return s
}

// SetDataTransferProgress sets the DataTransferProgress field's value.
func (s *JobMetadata) SetDataTransferProgress(v *DataTransfer) *JobMetadata {
	s.DataTransferProgress = v
	return s
}

// SetDescription sets the Description field's value.
func (s *JobMetadata) SetDescription(v string) *JobMetadata {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *JobMetadata) SetForwardingAddressId(v string) *JobMetadata {
	s.ForwardingAddressId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobMetadata) SetJobId(v string) *JobMetadata {
	s.JobId = &v
	return s
}

// SetJobLogInfo sets the JobLogInfo field's value.
func (s *JobMetadata) SetJobLogInfo(v *JobLogs) *JobMetadata {
	s.JobLogInfo = v
	return s
}

// SetJobState sets the JobState field's value.
func (s *JobMetadata) SetJobState(v string) *JobMetadata {
	s.JobState = &v
	return s
}

// SetJobType sets the JobType field's value.
func (s *JobMetadata) SetJobType(v string) *JobMetadata {
	s.JobType = &v
	return s
}

// SetKmsKeyARN sets the KmsKeyARN field's value.
func (s *JobMetadata) SetKmsKeyARN(v string) *JobMetadata {
	s.KmsKeyARN = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *JobMetadata) SetNotification(v *Notification) *JobMetadata {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *JobMetadata) SetResources(v *JobResource) *JobMetadata {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *JobMetadata) SetRoleARN(v string) *JobMetadata {
	s.RoleARN = &v
	return s
}

// SetShippingDetails sets the ShippingDetails field's value.
func (s *JobMetadata) SetShippingDetails(v *ShippingDetails) *JobMetadata {
	s.ShippingDetails = v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *JobMetadata) SetSnowballCapacityPreference(v string) *JobMetadata {
	s.SnowballCapacityPreference = &v
	return s
}

// SetSnowballType sets the SnowballType field's value.
func (s *JobMetadata) SetSnowballType(v string) *JobMetadata {
	s.SnowballType = &v
	return s
}

// SetTaxDocuments sets the TaxDocuments field's value.
func (s *JobMetadata) SetTaxDocuments(v *TaxDocuments) *JobMetadata {
	s.TaxDocuments = v
	return s
}

// Contains an array of AWS resource objects. Each object represents an Amazon
// S3 bucket, an AWS Lambda function, or an Amazon Machine Image (AMI) based
// on Amazon EC2 that is associated with a particular job.
type JobResource struct {
	_ struct{} `type:"structure"`

	// The Amazon Machine Images (AMIs) associated with this job.
	Ec2AmiResources []*Ec2AmiResource `type:"list"`

	// The Python-language Lambda functions for this job.
	LambdaResources []*LambdaResource `type:"list"`

	// An array of S3Resource objects.
	S3Resources []*S3Resource `type:"list"`
}

// String returns the string representation
func (s JobResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobResource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobResource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobResource"}
	if s.Ec2AmiResources != nil {
		for i, v := range s.Ec2AmiResources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Ec2AmiResources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.S3Resources != nil {
		for i, v := range s.S3Resources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "S3Resources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2AmiResources sets the Ec2AmiResources field's value.
func (s *JobResource) SetEc2AmiResources(v []*Ec2AmiResource) *JobResource {
	s.Ec2AmiResources = v
	return s
}

// SetLambdaResources sets the LambdaResources field's value.
func (s *JobResource) SetLambdaResources(v []*LambdaResource) *JobResource {
	s.LambdaResources = v
	return s
}

// SetS3Resources sets the S3Resources field's value.
func (s *JobResource) SetS3Resources(v []*S3Resource) *JobResource {
	s.S3Resources = v
	return s
}

// The provided AWS Key Management Service key lacks the permissions to perform
// the specified CreateJob or UpdateJob action.
type KMSRequestFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s KMSRequestFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSRequestFailedException) GoString() string {
	return s.String()
}

func newErrorKMSRequestFailedException(v protocol.ResponseMetadata) error {
	return &KMSRequestFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSRequestFailedException) Code() string {
	return "KMSRequestFailedException"
}

// Message returns the exception's message.
func (s *KMSRequestFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSRequestFailedException) OrigErr() error {
	return nil
}

func (s *KMSRequestFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSRequestFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSRequestFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains a key range. For export jobs, a S3Resource object can have an optional
// KeyRange value. The length of the range is defined at job creation, and has
// either an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges
// are UTF-8 binary sorted.
type KeyRange struct {
	_ struct{} `type:"structure"`

	// The key that starts an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	BeginMarker *string `min:"1" type:"string"`

	// The key that ends an optional key range for an export job. Ranges are inclusive
	// and UTF-8 binary sorted.
	EndMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyRange"}
	if s.BeginMarker != nil && len(*s.BeginMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BeginMarker", 1))
	}
	if s.EndMarker != nil && len(*s.EndMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBeginMarker sets the BeginMarker field's value.
func (s *KeyRange) SetBeginMarker(v string) *KeyRange {
	s.BeginMarker = &v
	return s
}

// SetEndMarker sets the EndMarker field's value.
func (s *KeyRange) SetEndMarker(v string) *KeyRange {
	s.EndMarker = &v
	return s
}

// Identifies
type LambdaResource struct {
	_ struct{} `type:"structure"`

	// The array of ARNs for S3Resource objects to trigger the LambdaResource objects
	// associated with this job.
	EventTriggers []*EventTriggerDefinition `type:"list"`

	// An Amazon Resource Name (ARN) that represents an AWS Lambda function to be
	// triggered by PUT object actions on the associated local Amazon S3 resource.
	LambdaArn *string `type:"string"`
}

// String returns the string representation
func (s LambdaResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaResource) GoString() string {
	return s.String()
}

// SetEventTriggers sets the EventTriggers field's value.
func (s *LambdaResource) SetEventTriggers(v []*EventTriggerDefinition) *LambdaResource {
	s.EventTriggers = v
	return s
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *LambdaResource) SetLambdaArn(v string) *LambdaResource {
	s.LambdaArn = &v
	return s
}

type ListClusterJobsInput struct {
	_ struct{} `type:"structure"`

	// The 39-character ID for the cluster that you want to list, for example CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`

	// The number of JobListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of JobListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClusterJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClusterJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterJobsInput"}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterId sets the ClusterId field's value.
func (s *ListClusterJobsInput) SetClusterId(v string) *ListClusterJobsInput {
	s.ClusterId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterJobsInput) SetMaxResults(v int64) *ListClusterJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterJobsInput) SetNextToken(v string) *ListClusterJobsInput {
	s.NextToken = &v
	return s
}

type ListClusterJobsOutput struct {
	_ struct{} `type:"structure"`

	// Each JobListEntry object contains a job's state, a job's ID, and a value
	// that indicates whether the job is a job part, in the case of export jobs.
	JobListEntries []*JobListEntry `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next ListClusterJobsResult call, your list of returned jobs
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClusterJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClusterJobsOutput) GoString() string {
	return s.String()
}

// SetJobListEntries sets the JobListEntries field's value.
func (s *ListClusterJobsOutput) SetJobListEntries(v []*JobListEntry) *ListClusterJobsOutput {
	s.JobListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterJobsOutput) SetNextToken(v string) *ListClusterJobsOutput {
	s.NextToken = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The number of ClusterListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of ClusterListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// Each ClusterListEntry object contains a cluster's state, a cluster's ID,
	// and other important status information.
	ClusterListEntries []*ClusterListEntry `type:"list"`

	// HTTP requests are stateless. If you use the automatically generated NextToken
	// value in your next ClusterListEntry call, your list of returned clusters
	// will start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusterListEntries sets the ClusterListEntries field's value.
func (s *ListClustersOutput) SetClusterListEntries(v []*ClusterListEntry) *ListClustersOutput {
	s.ClusterListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListCompatibleImagesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results for the list of compatible images. Currently,
	// a Snowball Edge device can store 10 AMIs.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of compatible images, you can specify a value for NextToken as the starting
	// point for your list of returned images.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCompatibleImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCompatibleImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCompatibleImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCompatibleImagesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCompatibleImagesInput) SetMaxResults(v int64) *ListCompatibleImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompatibleImagesInput) SetNextToken(v string) *ListCompatibleImagesInput {
	s.NextToken = &v
	return s
}

type ListCompatibleImagesOutput struct {
	_ struct{} `type:"structure"`

	// A JSON-formatted object that describes a compatible AMI, including the ID
	// and name for a Snowball Edge AMI.
	CompatibleImages []*CompatibleImage `type:"list"`

	// Because HTTP requests are stateless, this is the starting point for your
	// next list of returned images.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListCompatibleImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListCompatibleImagesOutput) GoString() string {
	return s.String()
}

// SetCompatibleImages sets the CompatibleImages field's value.
func (s *ListCompatibleImagesOutput) SetCompatibleImages(v []*CompatibleImage) *ListCompatibleImagesOutput {
	s.CompatibleImages = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCompatibleImagesOutput) SetNextToken(v string) *ListCompatibleImagesOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure"`

	// The number of JobListEntry objects to return.
	MaxResults *int64 `type:"integer"`

	// HTTP requests are stateless. To identify what object comes "next" in the
	// list of JobListEntry objects, you have the option of specifying NextToken
	// as the starting point for your returned list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// Each JobListEntry object contains a job's state, a job's ID, and a value
	// that indicates whether the job is a job part, in the case of export jobs.
	JobListEntries []*JobListEntry `type:"list"`

	// HTTP requests are stateless. If you use this automatically generated NextToken
	// value in your next ListJobs call, your returned JobListEntry objects will
	// start from this point in the array.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobListEntries sets the JobListEntries field's value.
func (s *ListJobsOutput) SetJobListEntries(v []*JobListEntry) *ListJobsOutput {
	s.JobListEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

// The Amazon Simple Notification Service (Amazon SNS) notification settings
// associated with a specific job. The Notification object is returned as a
// part of the response syntax of the DescribeJob action in the JobMetadata
// data type.
//
// When the notification settings are defined during job creation, you can choose
// to notify based on a specific set of job states using the JobStatesToNotify
// array of strings, or you can specify that you want to have Amazon SNS notifications
// sent out for all job states with NotifyAll set to true.
type Notification struct {
	_ struct{} `type:"structure"`

	// The list of job states that will trigger a notification for this job.
	JobStatesToNotify []*string `type:"list"`

	// Any change in job state will trigger a notification for this job.
	NotifyAll *bool `type:"boolean"`

	// The new SNS TopicArn that you want to associate with this job. You can create
	// Amazon Resource Names (ARNs) for topics by using the CreateTopic (https://docs.aws.amazon.com/sns/latest/api/API_CreateTopic.html)
	// Amazon SNS API action.
	//
	// You can subscribe email addresses to an Amazon SNS topic through the AWS
	// Management Console, or by using the Subscribe (https://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html)
	// AWS Simple Notification Service (SNS) API action.
	SnsTopicARN *string `type:"string"`
}

// String returns the string representation
func (s Notification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Notification) GoString() string {
	return s.String()
}

// SetJobStatesToNotify sets the JobStatesToNotify field's value.
func (s *Notification) SetJobStatesToNotify(v []*string) *Notification {
	s.JobStatesToNotify = v
	return s
}

// SetNotifyAll sets the NotifyAll field's value.
func (s *Notification) SetNotifyAll(v bool) *Notification {
	s.NotifyAll = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *Notification) SetSnsTopicARN(v string) *Notification {
	s.SnsTopicARN = &v
	return s
}

// Each S3Resource object represents an Amazon S3 bucket that your transferred
// data will be exported from or imported into. For export jobs, this object
// can have an optional KeyRange value. The length of the range is defined at
// job creation, and has either an inclusive BeginMarker, an inclusive EndMarker,
// or both. Ranges are UTF-8 binary sorted.
type S3Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon S3 bucket.
	BucketArn *string `type:"string"`

	// For export jobs, you can provide an optional KeyRange within a specific Amazon
	// S3 bucket. The length of the range is defined at job creation, and has either
	// an inclusive BeginMarker, an inclusive EndMarker, or both. Ranges are UTF-8
	// binary sorted.
	KeyRange *KeyRange `type:"structure"`
}

// String returns the string representation
func (s S3Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Resource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Resource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Resource"}
	if s.KeyRange != nil {
		if err := s.KeyRange.Validate(); err != nil {
			invalidParams.AddNested("KeyRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3Resource) SetBucketArn(v string) *S3Resource {
	s.BucketArn = &v
	return s
}

// SetKeyRange sets the KeyRange field's value.
func (s *S3Resource) SetKeyRange(v *KeyRange) *S3Resource {
	s.KeyRange = v
	return s
}

// The Status and TrackingNumber information for an inbound or outbound shipment.
type Shipment struct {
	_ struct{} `type:"structure"`

	// Status information for a shipment.
	Status *string `min:"1" type:"string"`

	// The tracking number for this job. Using this tracking number with your region's
	// carrier's website, you can track a Snowball as the carrier transports it.
	//
	// For India, the carrier is Amazon Logistics. For all other regions, UPS is
	// the carrier.
	TrackingNumber *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Shipment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Shipment) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *Shipment) SetStatus(v string) *Shipment {
	s.Status = &v
	return s
}

// SetTrackingNumber sets the TrackingNumber field's value.
func (s *Shipment) SetTrackingNumber(v string) *Shipment {
	s.TrackingNumber = &v
	return s
}

// A job's shipping information, including inbound and outbound tracking numbers
// and shipping speed options.
type ShippingDetails struct {
	_ struct{} `type:"structure"`

	// The Status and TrackingNumber values for a Snowball being returned to AWS
	// for a particular job.
	InboundShipment *Shipment `type:"structure"`

	// The Status and TrackingNumber values for a Snowball being delivered to the
	// address that you specified for a particular job.
	OutboundShipment *Shipment `type:"structure"`

	// The shipping speed for a particular job. This speed doesn't dictate how soon
	// you'll get the Snowball from the job's creation date. This speed represents
	// how quickly it moves to its destination while in transit. Regional shipping
	// speeds are as follows:
	//
	//    * In Australia, you have access to express shipping. Typically, Snowballs
	//    shipped express are delivered in about a day.
	//
	//    * In the European Union (EU), you have access to express shipping. Typically,
	//    Snowballs shipped express are delivered in about a day. In addition, most
	//    countries in the EU have access to standard shipping, which typically
	//    takes less than a week, one way.
	//
	//    * In India, Snowballs are delivered in one to seven days.
	//
	//    * In the United States of America (US), you have access to one-day shipping
	//    and two-day shipping.
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation
func (s ShippingDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShippingDetails) GoString() string {
	return s.String()
}

// SetInboundShipment sets the InboundShipment field's value.
func (s *ShippingDetails) SetInboundShipment(v *Shipment) *ShippingDetails {
	s.InboundShipment = v
	return s
}

// SetOutboundShipment sets the OutboundShipment field's value.
func (s *ShippingDetails) SetOutboundShipment(v *Shipment) *ShippingDetails {
	s.OutboundShipment = v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *ShippingDetails) SetShippingOption(v string) *ShippingDetails {
	s.ShippingOption = &v
	return s
}

// The tax documents required in your AWS Region.
type TaxDocuments struct {
	_ struct{} `type:"structure"`

	// The tax documents required in AWS Regions in India.
	IND *INDTaxDocuments `type:"structure"`
}

// String returns the string representation
func (s TaxDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TaxDocuments) GoString() string {
	return s.String()
}

// SetIND sets the IND field's value.
func (s *TaxDocuments) SetIND(v *INDTaxDocuments) *TaxDocuments {
	s.IND = v
	return s
}

// The address is either outside the serviceable area for your region, or an
// error occurred. Check the address with your region's carrier and try again.
// If the issue persists, contact AWS Support.
type UnsupportedAddressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s UnsupportedAddressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedAddressException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAddressException(v protocol.ResponseMetadata) error {
	return &UnsupportedAddressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAddressException) Code() string {
	return "UnsupportedAddressException"
}

// Message returns the exception's message.
func (s *UnsupportedAddressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAddressException) OrigErr() error {
	return nil
}

func (s *UnsupportedAddressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAddressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAddressException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The ID of the updated Address object.
	AddressId *string `min:"40" type:"string"`

	// The cluster ID of the cluster that you want to update, for example CID123e4567-e89b-12d3-a456-426655440000.
	//
	// ClusterId is a required field
	ClusterId *string `min:"39" type:"string" required:"true"`

	// The updated description of this cluster.
	Description *string `min:"1" type:"string"`

	// The updated ID for the forwarding address for a cluster. This field is not
	// supported in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The new or updated Notification object.
	Notification *Notification `type:"structure"`

	// The updated arrays of JobResource objects that can include updated S3Resource
	// objects or LambdaResource objects.
	Resources *JobResource `type:"structure"`

	// The new role Amazon Resource Name (ARN) that you want to associate with this
	// cluster. To create a role ARN, use the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)
	// API action in AWS Identity and Access Management (IAM).
	RoleARN *string `type:"string"`

	// The updated shipping option value of this cluster's ShippingDetails object.
	ShippingOption *string `type:"string" enum:"ShippingOption"`
}

// String returns the string representation
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.ClusterId != nil && len(*s.ClusterId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterId", 39))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *UpdateClusterInput) SetAddressId(v string) *UpdateClusterInput {
	s.AddressId = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *UpdateClusterInput) SetClusterId(v string) *UpdateClusterInput {
	s.ClusterId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateClusterInput) SetDescription(v string) *UpdateClusterInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *UpdateClusterInput) SetForwardingAddressId(v string) *UpdateClusterInput {
	s.ForwardingAddressId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateClusterInput) SetNotification(v *Notification) *UpdateClusterInput {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateClusterInput) SetResources(v *JobResource) *UpdateClusterInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateClusterInput) SetRoleARN(v string) *UpdateClusterInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *UpdateClusterInput) SetShippingOption(v string) *UpdateClusterInput {
	s.ShippingOption = &v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

type UpdateJobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the updated Address object.
	AddressId *string `min:"40" type:"string"`

	// The updated description of this job's JobMetadata object.
	Description *string `min:"1" type:"string"`

	// The updated ID for the forwarding address for a job. This field is not supported
	// in most regions.
	ForwardingAddressId *string `min:"40" type:"string"`

	// The job ID of the job that you want to update, for example JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`

	// The new or updated Notification object.
	Notification *Notification `type:"structure"`

	// The updated JobResource object, or the updated JobResource object.
	Resources *JobResource `type:"structure"`

	// The new role Amazon Resource Name (ARN) that you want to associate with this
	// job. To create a role ARN, use the CreateRole (https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html)AWS
	// Identity and Access Management (IAM) API action.
	RoleARN *string `type:"string"`

	// The updated shipping option value of this job's ShippingDetails object.
	ShippingOption *string `type:"string" enum:"ShippingOption"`

	// The updated SnowballCapacityPreference of this job's JobMetadata object.
	// The 50 TB Snowballs are only available in the US regions.
	SnowballCapacityPreference *string `type:"string" enum:"Capacity"`
}

// String returns the string representation
func (s UpdateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateJobInput"}
	if s.AddressId != nil && len(*s.AddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("AddressId", 40))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ForwardingAddressId != nil && len(*s.ForwardingAddressId) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("ForwardingAddressId", 40))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 39))
	}
	if s.Resources != nil {
		if err := s.Resources.Validate(); err != nil {
			invalidParams.AddNested("Resources", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressId sets the AddressId field's value.
func (s *UpdateJobInput) SetAddressId(v string) *UpdateJobInput {
	s.AddressId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateJobInput) SetDescription(v string) *UpdateJobInput {
	s.Description = &v
	return s
}

// SetForwardingAddressId sets the ForwardingAddressId field's value.
func (s *UpdateJobInput) SetForwardingAddressId(v string) *UpdateJobInput {
	s.ForwardingAddressId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *UpdateJobInput) SetJobId(v string) *UpdateJobInput {
	s.JobId = &v
	return s
}

// SetNotification sets the Notification field's value.
func (s *UpdateJobInput) SetNotification(v *Notification) *UpdateJobInput {
	s.Notification = v
	return s
}

// SetResources sets the Resources field's value.
func (s *UpdateJobInput) SetResources(v *JobResource) *UpdateJobInput {
	s.Resources = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *UpdateJobInput) SetRoleARN(v string) *UpdateJobInput {
	s.RoleARN = &v
	return s
}

// SetShippingOption sets the ShippingOption field's value.
func (s *UpdateJobInput) SetShippingOption(v string) *UpdateJobInput {
	s.ShippingOption = &v
	return s
}

// SetSnowballCapacityPreference sets the SnowballCapacityPreference field's value.
func (s *UpdateJobInput) SetSnowballCapacityPreference(v string) *UpdateJobInput {
	s.SnowballCapacityPreference = &v
	return s
}

type UpdateJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateJobOutput) GoString() string {
	return s.String()
}

const (
	// CapacityT50 is a Capacity enum value
	CapacityT50 = "T50"

	// CapacityT80 is a Capacity enum value
	CapacityT80 = "T80"

	// CapacityT100 is a Capacity enum value
	CapacityT100 = "T100"

	// CapacityT42 is a Capacity enum value
	CapacityT42 = "T42"

	// CapacityNoPreference is a Capacity enum value
	CapacityNoPreference = "NoPreference"
)

const (
	// ClusterStateAwaitingQuorum is a ClusterState enum value
	ClusterStateAwaitingQuorum = "AwaitingQuorum"

	// ClusterStatePending is a ClusterState enum value
	ClusterStatePending = "Pending"

	// ClusterStateInUse is a ClusterState enum value
	ClusterStateInUse = "InUse"

	// ClusterStateComplete is a ClusterState enum value
	ClusterStateComplete = "Complete"

	// ClusterStateCancelled is a ClusterState enum value
	ClusterStateCancelled = "Cancelled"
)

const (
	// JobStateNew is a JobState enum value
	JobStateNew = "New"

	// JobStatePreparingAppliance is a JobState enum value
	JobStatePreparingAppliance = "PreparingAppliance"

	// JobStatePreparingShipment is a JobState enum value
	JobStatePreparingShipment = "PreparingShipment"

	// JobStateInTransitToCustomer is a JobState enum value
	JobStateInTransitToCustomer = "InTransitToCustomer"

	// JobStateWithCustomer is a JobState enum value
	JobStateWithCustomer = "WithCustomer"

	// JobStateInTransitToAws is a JobState enum value
	JobStateInTransitToAws = "InTransitToAWS"

	// JobStateWithAwssortingFacility is a JobState enum value
	JobStateWithAwssortingFacility = "WithAWSSortingFacility"

	// JobStateWithAws is a JobState enum value
	JobStateWithAws = "WithAWS"

	// JobStateInProgress is a JobState enum value
	JobStateInProgress = "InProgress"

	// JobStateComplete is a JobState enum value
	JobStateComplete = "Complete"

	// JobStateCancelled is a JobState enum value
	JobStateCancelled = "Cancelled"

	// JobStateListing is a JobState enum value
	JobStateListing = "Listing"

	// JobStatePending is a JobState enum value
	JobStatePending = "Pending"
)

const (
	// JobTypeImport is a JobType enum value
	JobTypeImport = "IMPORT"

	// JobTypeExport is a JobType enum value
	JobTypeExport = "EXPORT"

	// JobTypeLocalUse is a JobType enum value
	JobTypeLocalUse = "LOCAL_USE"
)

const (
	// ShippingOptionSecondDay is a ShippingOption enum value
	ShippingOptionSecondDay = "SECOND_DAY"

	// ShippingOptionNextDay is a ShippingOption enum value
	ShippingOptionNextDay = "NEXT_DAY"

	// ShippingOptionExpress is a ShippingOption enum value
	ShippingOptionExpress = "EXPRESS"

	// ShippingOptionStandard is a ShippingOption enum value
	ShippingOptionStandard = "STANDARD"
)

const (
	// TypeStandard is a Type enum value
	TypeStandard = "STANDARD"

	// TypeEdge is a Type enum value
	TypeEdge = "EDGE"

	// TypeEdgeC is a Type enum value
	TypeEdgeC = "EDGE_C"

	// TypeEdgeCg is a Type enum value
	TypeEdgeCg = "EDGE_CG"
)
