package avsapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/avs/mgmt/2021-06-01/avs"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result avs.OperationListPage, err error)
	ListComplete(ctx context.Context) (result avs.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*avs.OperationsClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	CheckQuotaAvailability(ctx context.Context, location string) (result avs.Quota, err error)
	CheckTrialAvailability(ctx context.Context, location string) (result avs.Trial, err error)
}

var _ LocationsClientAPI = (*avs.LocationsClient)(nil)

// PrivateCloudsClientAPI contains the set of methods on the PrivateCloudsClient type.
type PrivateCloudsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, privateCloud avs.PrivateCloud) (result avs.PrivateCloudsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.PrivateCloudsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.PrivateCloud, err error)
	List(ctx context.Context, resourceGroupName string) (result avs.PrivateCloudListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string) (result avs.PrivateCloudListIterator, err error)
	ListAdminCredentials(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.AdminCredentials, err error)
	ListInSubscription(ctx context.Context) (result avs.PrivateCloudListPage, err error)
	ListInSubscriptionComplete(ctx context.Context) (result avs.PrivateCloudListIterator, err error)
	RotateNsxtPassword(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.PrivateCloudsRotateNsxtPasswordFuture, err error)
	RotateVcenterPassword(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.PrivateCloudsRotateVcenterPasswordFuture, err error)
	Update(ctx context.Context, resourceGroupName string, privateCloudName string, privateCloudUpdate avs.PrivateCloudUpdate) (result avs.PrivateCloudsUpdateFuture, err error)
}

var _ PrivateCloudsClientAPI = (*avs.PrivateCloudsClient)(nil)

// ClustersClientAPI contains the set of methods on the ClustersClient type.
type ClustersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, cluster avs.Cluster) (result avs.ClustersCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result avs.ClustersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result avs.Cluster, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ClusterListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ClusterListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, clusterUpdate avs.ClusterUpdate) (result avs.ClustersUpdateFuture, err error)
}

var _ ClustersClientAPI = (*avs.ClustersClient)(nil)

// DatastoresClientAPI contains the set of methods on the DatastoresClient type.
type DatastoresClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, datastoreName string, datastore avs.Datastore) (result avs.DatastoresCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, datastoreName string) (result avs.DatastoresDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string, datastoreName string) (result avs.Datastore, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result avs.DatastoreListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string, clusterName string) (result avs.DatastoreListIterator, err error)
}

var _ DatastoresClientAPI = (*avs.DatastoresClient)(nil)

// HcxEnterpriseSitesClientAPI contains the set of methods on the HcxEnterpriseSitesClient type.
type HcxEnterpriseSitesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, hcxEnterpriseSiteName string, hcxEnterpriseSite avs.HcxEnterpriseSite) (result avs.HcxEnterpriseSite, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, hcxEnterpriseSiteName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, hcxEnterpriseSiteName string) (result avs.HcxEnterpriseSite, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.HcxEnterpriseSiteListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.HcxEnterpriseSiteListIterator, err error)
}

var _ HcxEnterpriseSitesClientAPI = (*avs.HcxEnterpriseSitesClient)(nil)

// AuthorizationsClientAPI contains the set of methods on the AuthorizationsClient type.
type AuthorizationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, authorizationName string, authorization avs.ExpressRouteAuthorization) (result avs.AuthorizationsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, authorizationName string) (result avs.AuthorizationsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, authorizationName string) (result avs.ExpressRouteAuthorization, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ExpressRouteAuthorizationListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ExpressRouteAuthorizationListIterator, err error)
}

var _ AuthorizationsClientAPI = (*avs.AuthorizationsClient)(nil)

// GlobalReachConnectionsClientAPI contains the set of methods on the GlobalReachConnectionsClient type.
type GlobalReachConnectionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, globalReachConnectionName string, globalReachConnection avs.GlobalReachConnection) (result avs.GlobalReachConnectionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, globalReachConnectionName string) (result avs.GlobalReachConnectionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, globalReachConnectionName string) (result avs.GlobalReachConnection, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.GlobalReachConnectionListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.GlobalReachConnectionListIterator, err error)
}

var _ GlobalReachConnectionsClientAPI = (*avs.GlobalReachConnectionsClient)(nil)

// WorkloadNetworksClientAPI contains the set of methods on the WorkloadNetworksClient type.
type WorkloadNetworksClientAPI interface {
	CreateDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp avs.WorkloadNetworkDhcp) (result avs.WorkloadNetworksCreateDhcpFuture, err error)
	CreateDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService avs.WorkloadNetworkDNSService) (result avs.WorkloadNetworksCreateDNSServiceFuture, err error)
	CreateDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone avs.WorkloadNetworkDNSZone) (result avs.WorkloadNetworksCreateDNSZoneFuture, err error)
	CreatePortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring avs.WorkloadNetworkPortMirroring) (result avs.WorkloadNetworksCreatePortMirroringFuture, err error)
	CreatePublicIP(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string, workloadNetworkPublicIP avs.WorkloadNetworkPublicIP) (result avs.WorkloadNetworksCreatePublicIPFuture, err error)
	CreateSegments(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment avs.WorkloadNetworkSegment) (result avs.WorkloadNetworksCreateSegmentsFuture, err error)
	CreateVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup avs.WorkloadNetworkVMGroup) (result avs.WorkloadNetworksCreateVMGroupFuture, err error)
	DeleteDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string) (result avs.WorkloadNetworksDeleteDhcpFuture, err error)
	DeleteDNSService(ctx context.Context, resourceGroupName string, DNSServiceID string, privateCloudName string) (result avs.WorkloadNetworksDeleteDNSServiceFuture, err error)
	DeleteDNSZone(ctx context.Context, resourceGroupName string, DNSZoneID string, privateCloudName string) (result avs.WorkloadNetworksDeleteDNSZoneFuture, err error)
	DeletePortMirroring(ctx context.Context, resourceGroupName string, portMirroringID string, privateCloudName string) (result avs.WorkloadNetworksDeletePortMirroringFuture, err error)
	DeletePublicIP(ctx context.Context, resourceGroupName string, publicIPID string, privateCloudName string) (result avs.WorkloadNetworksDeletePublicIPFuture, err error)
	DeleteSegment(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (result avs.WorkloadNetworksDeleteSegmentFuture, err error)
	DeleteVMGroup(ctx context.Context, resourceGroupName string, VMGroupID string, privateCloudName string) (result avs.WorkloadNetworksDeleteVMGroupFuture, err error)
	GetDhcp(ctx context.Context, resourceGroupName string, dhcpID string, privateCloudName string) (result avs.WorkloadNetworkDhcp, err error)
	GetDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string) (result avs.WorkloadNetworkDNSService, err error)
	GetDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string) (result avs.WorkloadNetworkDNSZone, err error)
	GetGateway(ctx context.Context, resourceGroupName string, privateCloudName string, gatewayID string) (result avs.WorkloadNetworkGateway, err error)
	GetPortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string) (result avs.WorkloadNetworkPortMirroring, err error)
	GetPublicIP(ctx context.Context, resourceGroupName string, privateCloudName string, publicIPID string) (result avs.WorkloadNetworkPublicIP, err error)
	GetSegment(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string) (result avs.WorkloadNetworkSegment, err error)
	GetVirtualMachine(ctx context.Context, resourceGroupName string, privateCloudName string, virtualMachineID string) (result avs.WorkloadNetworkVirtualMachine, err error)
	GetVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string) (result avs.WorkloadNetworkVMGroup, err error)
	ListDhcp(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDhcpListPage, err error)
	ListDhcpComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDhcpListIterator, err error)
	ListDNSServices(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDNSServicesListPage, err error)
	ListDNSServicesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDNSServicesListIterator, err error)
	ListDNSZones(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDNSZonesListPage, err error)
	ListDNSZonesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkDNSZonesListIterator, err error)
	ListGateways(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkGatewayListPage, err error)
	ListGatewaysComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkGatewayListIterator, err error)
	ListPortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkPortMirroringListPage, err error)
	ListPortMirroringComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkPortMirroringListIterator, err error)
	ListPublicIPs(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkPublicIPsListPage, err error)
	ListPublicIPsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkPublicIPsListIterator, err error)
	ListSegments(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkSegmentsListPage, err error)
	ListSegmentsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkSegmentsListIterator, err error)
	ListVirtualMachines(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkVirtualMachinesListPage, err error)
	ListVirtualMachinesComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkVirtualMachinesListIterator, err error)
	ListVMGroups(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkVMGroupsListPage, err error)
	ListVMGroupsComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.WorkloadNetworkVMGroupsListIterator, err error)
	UpdateDhcp(ctx context.Context, resourceGroupName string, privateCloudName string, dhcpID string, workloadNetworkDhcp avs.WorkloadNetworkDhcp) (result avs.WorkloadNetworksUpdateDhcpFuture, err error)
	UpdateDNSService(ctx context.Context, resourceGroupName string, privateCloudName string, DNSServiceID string, workloadNetworkDNSService avs.WorkloadNetworkDNSService) (result avs.WorkloadNetworksUpdateDNSServiceFuture, err error)
	UpdateDNSZone(ctx context.Context, resourceGroupName string, privateCloudName string, DNSZoneID string, workloadNetworkDNSZone avs.WorkloadNetworkDNSZone) (result avs.WorkloadNetworksUpdateDNSZoneFuture, err error)
	UpdatePortMirroring(ctx context.Context, resourceGroupName string, privateCloudName string, portMirroringID string, workloadNetworkPortMirroring avs.WorkloadNetworkPortMirroring) (result avs.WorkloadNetworksUpdatePortMirroringFuture, err error)
	UpdateSegments(ctx context.Context, resourceGroupName string, privateCloudName string, segmentID string, workloadNetworkSegment avs.WorkloadNetworkSegment) (result avs.WorkloadNetworksUpdateSegmentsFuture, err error)
	UpdateVMGroup(ctx context.Context, resourceGroupName string, privateCloudName string, VMGroupID string, workloadNetworkVMGroup avs.WorkloadNetworkVMGroup) (result avs.WorkloadNetworksUpdateVMGroupFuture, err error)
}

var _ WorkloadNetworksClientAPI = (*avs.WorkloadNetworksClient)(nil)

// CloudLinksClientAPI contains the set of methods on the CloudLinksClient type.
type CloudLinksClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, cloudLinkName string, cloudLink avs.CloudLink) (result avs.CloudLinksCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, cloudLinkName string) (result avs.CloudLinksDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, cloudLinkName string) (result avs.CloudLink, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.CloudLinkListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.CloudLinkListIterator, err error)
}

var _ CloudLinksClientAPI = (*avs.CloudLinksClient)(nil)

// AddonsClientAPI contains the set of methods on the AddonsClient type.
type AddonsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, addonName string, addon avs.Addon) (result avs.AddonsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, addonName string) (result avs.AddonsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, addonName string) (result avs.Addon, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.AddonListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.AddonListIterator, err error)
}

var _ AddonsClientAPI = (*avs.AddonsClient)(nil)

// ScriptPackagesClientAPI contains the set of methods on the ScriptPackagesClient type.
type ScriptPackagesClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, scriptPackageName string) (result avs.ScriptPackage, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ScriptPackagesListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ScriptPackagesListIterator, err error)
}

var _ ScriptPackagesClientAPI = (*avs.ScriptPackagesClient)(nil)

// ScriptCmdletsClientAPI contains the set of methods on the ScriptCmdletsClient type.
type ScriptCmdletsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, scriptPackageName string, scriptCmdletName string) (result avs.ScriptCmdlet, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string, scriptPackageName string) (result avs.ScriptCmdletsListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string, scriptPackageName string) (result avs.ScriptCmdletsListIterator, err error)
}

var _ ScriptCmdletsClientAPI = (*avs.ScriptCmdletsClient)(nil)

// ScriptExecutionsClientAPI contains the set of methods on the ScriptExecutionsClient type.
type ScriptExecutionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, privateCloudName string, scriptExecutionName string, scriptExecution avs.ScriptExecution) (result avs.ScriptExecutionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, privateCloudName string, scriptExecutionName string) (result avs.ScriptExecutionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, privateCloudName string, scriptExecutionName string) (result avs.ScriptExecution, err error)
	GetExecutionLogs(ctx context.Context, resourceGroupName string, privateCloudName string, scriptExecutionName string, scriptOutputStreamType []avs.ScriptOutputStreamType) (result avs.ScriptExecution, err error)
	List(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ScriptExecutionsListPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, privateCloudName string) (result avs.ScriptExecutionsListIterator, err error)
}

var _ ScriptExecutionsClientAPI = (*avs.ScriptExecutionsClient)(nil)
