package confluent

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ValidationsClient is the client for the Validations methods of the Confluent service.
type ValidationsClient struct {
	BaseClient
}

// NewValidationsClient creates an instance of the ValidationsClient client.
func NewValidationsClient(subscriptionID string) ValidationsClient {
	return NewValidationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewValidationsClientWithBaseURI creates an instance of the ValidationsClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewValidationsClientWithBaseURI(baseURI string, subscriptionID string) ValidationsClient {
	return ValidationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ValidateOrganization sends the validate organization request.
// Parameters:
// resourceGroupName - resource group name
// organizationName - organization resource name
// body - organization resource model
func (client ValidationsClient) ValidateOrganization(ctx context.Context, resourceGroupName string, organizationName string, body OrganizationResource) (result OrganizationResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ValidationsClient.ValidateOrganization")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.OrganizationResourceProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.PublisherID", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.PublisherID", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
						{Target: "body.OrganizationResourceProperties.OfferDetail.ID", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.ID", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
						{Target: "body.OrganizationResourceProperties.OfferDetail.PlanID", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.PlanID", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
						{Target: "body.OrganizationResourceProperties.OfferDetail.PlanName", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.PlanName", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
						{Target: "body.OrganizationResourceProperties.OfferDetail.TermUnit", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.OfferDetail.TermUnit", Name: validation.MaxLength, Rule: 25, Chain: nil}}},
					}},
					{Target: "body.OrganizationResourceProperties.UserDetail", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.UserDetail.FirstName", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.UserDetail.FirstName", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
							{Target: "body.OrganizationResourceProperties.UserDetail.LastName", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.UserDetail.LastName", Name: validation.MaxLength, Rule: 50, Chain: nil}}},
							{Target: "body.OrganizationResourceProperties.UserDetail.EmailAddress", Name: validation.Null, Rule: true,
								Chain: []validation.Constraint{{Target: "body.OrganizationResourceProperties.UserDetail.EmailAddress", Name: validation.Pattern, Rule: `^\S+@\S+\.\S+$`, Chain: nil}}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("confluent.ValidationsClient", "ValidateOrganization", err.Error())
	}

	req, err := client.ValidateOrganizationPreparer(ctx, resourceGroupName, organizationName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confluent.ValidationsClient", "ValidateOrganization", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateOrganizationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "confluent.ValidationsClient", "ValidateOrganization", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateOrganizationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "confluent.ValidationsClient", "ValidateOrganization", resp, "Failure responding to request")
		return
	}

	return
}

// ValidateOrganizationPreparer prepares the ValidateOrganization request.
func (client ValidationsClient) ValidateOrganizationPreparer(ctx context.Context, resourceGroupName string, organizationName string, body OrganizationResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"organizationName":  autorest.Encode("path", organizationName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Name = nil
	body.Type = nil
	body.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/validations/{organizationName}/orgvalidate", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateOrganizationSender sends the ValidateOrganization request. The method will close the
// http.Response Body if it receives an error.
func (client ValidationsClient) ValidateOrganizationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateOrganizationResponder handles the response to the ValidateOrganization request. The method always
// closes the http.Response Body.
func (client ValidationsClient) ValidateOrganizationResponder(resp *http.Response) (result OrganizationResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
