package documentdb

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/cosmos-db/mgmt/2019-08-01/documentdb"

// ARMProxyResource the resource model definition for a ARM proxy resource. It will have everything other
// than required location and tags
type ARMProxyResource struct {
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// ARMResourceProperties the core properties of ARM resources.
type ARMResourceProperties struct {
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ARMResourceProperties.
func (arp ARMResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if arp.Location != nil {
		objectMap["location"] = arp.Location
	}
	if arp.Tags != nil {
		objectMap["tags"] = arp.Tags
	}
	return json.Marshal(objectMap)
}

// Capability cosmos DB capability object
type Capability struct {
	// Name - Name of the Cosmos DB capability. For example, "name": "EnableCassandra". Current values also include "EnableTable" and "EnableGremlin".
	Name *string `json:"name,omitempty"`
}

// CassandraKeyspaceCreateUpdateParameters parameters to create and update Cosmos DB Cassandra keyspace.
type CassandraKeyspaceCreateUpdateParameters struct {
	// CassandraKeyspaceCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra keyspace.
	*CassandraKeyspaceCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceCreateUpdateParameters.
func (ckcup CassandraKeyspaceCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckcup.CassandraKeyspaceCreateUpdateProperties != nil {
		objectMap["properties"] = ckcup.CassandraKeyspaceCreateUpdateProperties
	}
	if ckcup.Location != nil {
		objectMap["location"] = ckcup.Location
	}
	if ckcup.Tags != nil {
		objectMap["tags"] = ckcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspaceCreateUpdateParameters struct.
func (ckcup *CassandraKeyspaceCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceCreateUpdateProperties CassandraKeyspaceCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceCreateUpdateProperties)
				if err != nil {
					return err
				}
				ckcup.CassandraKeyspaceCreateUpdateProperties = &cassandraKeyspaceCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ckcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ckcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ckcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ckcup.Tags = tags
			}
		}
	}

	return nil
}

// CassandraKeyspaceCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra
// keyspace.
type CassandraKeyspaceCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra keyspace
	Resource *CassandraKeyspaceResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceCreateUpdateProperties.
func (ckcup CassandraKeyspaceCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckcup.Resource != nil {
		objectMap["resource"] = ckcup.Resource
	}
	if ckcup.Options != nil {
		objectMap["options"] = ckcup.Options
	}
	return json.Marshal(objectMap)
}

// CassandraKeyspaceGetProperties the properties of an Azure Cosmos DB Cassandra keyspace
type CassandraKeyspaceGetProperties struct {
	Resource *CassandraKeyspaceGetPropertiesResource `json:"resource,omitempty"`
}

// CassandraKeyspaceGetPropertiesResource ...
type CassandraKeyspaceGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceGetPropertiesResource.
func (ckgp CassandraKeyspaceGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckgp.ID != nil {
		objectMap["id"] = ckgp.ID
	}
	return json.Marshal(objectMap)
}

// CassandraKeyspaceGetResults an Azure Cosmos DB Cassandra keyspace.
type CassandraKeyspaceGetResults struct {
	autorest.Response `json:"-"`
	// CassandraKeyspaceGetProperties - The properties of an Azure Cosmos DB Cassandra keyspace
	*CassandraKeyspaceGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraKeyspaceGetResults.
func (ckgr CassandraKeyspaceGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckgr.CassandraKeyspaceGetProperties != nil {
		objectMap["properties"] = ckgr.CassandraKeyspaceGetProperties
	}
	if ckgr.Location != nil {
		objectMap["location"] = ckgr.Location
	}
	if ckgr.Tags != nil {
		objectMap["tags"] = ckgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraKeyspaceGetResults struct.
func (ckgr *CassandraKeyspaceGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraKeyspaceGetProperties CassandraKeyspaceGetProperties
				err = json.Unmarshal(*v, &cassandraKeyspaceGetProperties)
				if err != nil {
					return err
				}
				ckgr.CassandraKeyspaceGetProperties = &cassandraKeyspaceGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ckgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ckgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ckgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ckgr.Tags = tags
			}
		}
	}

	return nil
}

// CassandraKeyspaceListResult the List operation response, that contains the Cassandra keyspaces and their
// properties.
type CassandraKeyspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra keyspaces and their properties.
	Value *[]CassandraKeyspaceGetResults `json:"value,omitempty"`
}

// CassandraKeyspaceResource cosmos DB Cassandra keyspace resource object
type CassandraKeyspaceResource struct {
	// ID - Name of the Cosmos DB Cassandra keyspace
	ID *string `json:"id,omitempty"`
}

// CassandraPartitionKey cosmos DB Cassandra table partition key
type CassandraPartitionKey struct {
	// Name - Name of the Cosmos DB Cassandra table partition key
	Name *string `json:"name,omitempty"`
}

// CassandraResourcesCreateUpdateCassandraKeyspaceFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesCreateUpdateCassandraKeyspaceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (CassandraKeyspaceGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesCreateUpdateCassandraKeyspaceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesCreateUpdateCassandraKeyspaceFuture.Result.
func (future *CassandraResourcesCreateUpdateCassandraKeyspaceFuture) result(client CassandraResourcesClient) (ckgr CassandraKeyspaceGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ckgr.Response.Response, err = future.GetResult(sender); err == nil && ckgr.Response.Response.StatusCode != http.StatusNoContent {
		ckgr, err = client.CreateUpdateCassandraKeyspaceResponder(ckgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraKeyspaceFuture", "Result", ckgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesCreateUpdateCassandraTableFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesCreateUpdateCassandraTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (CassandraTableGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesCreateUpdateCassandraTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesCreateUpdateCassandraTableFuture.Result.
func (future *CassandraResourcesCreateUpdateCassandraTableFuture) result(client CassandraResourcesClient) (ctgr CassandraTableGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesCreateUpdateCassandraTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ctgr.Response.Response, err = future.GetResult(sender); err == nil && ctgr.Response.Response.StatusCode != http.StatusNoContent {
		ctgr, err = client.CreateUpdateCassandraTableResponder(ctgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesCreateUpdateCassandraTableFuture", "Result", ctgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesDeleteCassandraKeyspaceFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type CassandraResourcesDeleteCassandraKeyspaceFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesDeleteCassandraKeyspaceFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesDeleteCassandraKeyspaceFuture.Result.
func (future *CassandraResourcesDeleteCassandraKeyspaceFuture) result(client CassandraResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesDeleteCassandraKeyspaceFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesDeleteCassandraKeyspaceFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CassandraResourcesDeleteCassandraTableFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type CassandraResourcesDeleteCassandraTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesDeleteCassandraTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesDeleteCassandraTableFuture.Result.
func (future *CassandraResourcesDeleteCassandraTableFuture) result(client CassandraResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesDeleteCassandraTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesDeleteCassandraTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// CassandraResourcesUpdateCassandraKeyspaceThroughputFuture an abstraction for monitoring and retrieving
// the results of a long-running operation.
type CassandraResourcesUpdateCassandraKeyspaceThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesUpdateCassandraKeyspaceThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesUpdateCassandraKeyspaceThroughputFuture.Result.
func (future *CassandraResourcesUpdateCassandraKeyspaceThroughputFuture) result(client CassandraResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateCassandraKeyspaceThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraKeyspaceThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraResourcesUpdateCassandraTableThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type CassandraResourcesUpdateCassandraTableThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(CassandraResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CassandraResourcesUpdateCassandraTableThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CassandraResourcesUpdateCassandraTableThroughputFuture.Result.
func (future *CassandraResourcesUpdateCassandraTableThroughputFuture) result(client CassandraResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateCassandraTableThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.CassandraResourcesUpdateCassandraTableThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CassandraSchema cosmos DB Cassandra table schema
type CassandraSchema struct {
	// Columns - List of Cassandra table columns.
	Columns *[]Column `json:"columns,omitempty"`
	// PartitionKeys - List of partition key.
	PartitionKeys *[]CassandraPartitionKey `json:"partitionKeys,omitempty"`
	// ClusterKeys - List of cluster key.
	ClusterKeys *[]ClusterKey `json:"clusterKeys,omitempty"`
}

// CassandraTableCreateUpdateParameters parameters to create and update Cosmos DB Cassandra table.
type CassandraTableCreateUpdateParameters struct {
	// CassandraTableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Cassandra table.
	*CassandraTableCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraTableCreateUpdateParameters.
func (ctcup CassandraTableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcup.CassandraTableCreateUpdateProperties != nil {
		objectMap["properties"] = ctcup.CassandraTableCreateUpdateProperties
	}
	if ctcup.Location != nil {
		objectMap["location"] = ctcup.Location
	}
	if ctcup.Tags != nil {
		objectMap["tags"] = ctcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableCreateUpdateParameters struct.
func (ctcup *CassandraTableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableCreateUpdateProperties CassandraTableCreateUpdateProperties
				err = json.Unmarshal(*v, &cassandraTableCreateUpdateProperties)
				if err != nil {
					return err
				}
				ctcup.CassandraTableCreateUpdateProperties = &cassandraTableCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ctcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ctcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ctcup.Tags = tags
			}
		}
	}

	return nil
}

// CassandraTableCreateUpdateProperties properties to create and update Azure Cosmos DB Cassandra table.
type CassandraTableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Cassandra table
	Resource *CassandraTableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for CassandraTableCreateUpdateProperties.
func (ctcup CassandraTableCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctcup.Resource != nil {
		objectMap["resource"] = ctcup.Resource
	}
	if ctcup.Options != nil {
		objectMap["options"] = ctcup.Options
	}
	return json.Marshal(objectMap)
}

// CassandraTableGetProperties the properties of an Azure Cosmos DB Cassandra table
type CassandraTableGetProperties struct {
	Resource *CassandraTableGetPropertiesResource `json:"resource,omitempty"`
}

// CassandraTableGetPropertiesResource ...
type CassandraTableGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for CassandraTableGetPropertiesResource.
func (ctgp CassandraTableGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctgp.ID != nil {
		objectMap["id"] = ctgp.ID
	}
	if ctgp.DefaultTTL != nil {
		objectMap["defaultTtl"] = ctgp.DefaultTTL
	}
	if ctgp.Schema != nil {
		objectMap["schema"] = ctgp.Schema
	}
	return json.Marshal(objectMap)
}

// CassandraTableGetResults an Azure Cosmos DB Cassandra table.
type CassandraTableGetResults struct {
	autorest.Response `json:"-"`
	// CassandraTableGetProperties - The properties of an Azure Cosmos DB Cassandra table
	*CassandraTableGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for CassandraTableGetResults.
func (ctgr CassandraTableGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ctgr.CassandraTableGetProperties != nil {
		objectMap["properties"] = ctgr.CassandraTableGetProperties
	}
	if ctgr.Location != nil {
		objectMap["location"] = ctgr.Location
	}
	if ctgr.Tags != nil {
		objectMap["tags"] = ctgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for CassandraTableGetResults struct.
func (ctgr *CassandraTableGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var cassandraTableGetProperties CassandraTableGetProperties
				err = json.Unmarshal(*v, &cassandraTableGetProperties)
				if err != nil {
					return err
				}
				ctgr.CassandraTableGetProperties = &cassandraTableGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ctgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ctgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ctgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ctgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ctgr.Tags = tags
			}
		}
	}

	return nil
}

// CassandraTableListResult the List operation response, that contains the Cassandra tables and their
// properties.
type CassandraTableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Cassandra tables and their properties.
	Value *[]CassandraTableGetResults `json:"value,omitempty"`
}

// CassandraTableResource cosmos DB Cassandra table resource object
type CassandraTableResource struct {
	// ID - Name of the Cosmos DB Cassandra table
	ID *string `json:"id,omitempty"`
	// DefaultTTL - Time to live of the Cosmos DB Cassandra table
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// Schema - Schema of the Cosmos DB Cassandra table
	Schema *CassandraSchema `json:"schema,omitempty"`
}

// ClusterKey cosmos DB Cassandra table cluster key
type ClusterKey struct {
	// Name - Name of the Cosmos DB Cassandra table cluster key
	Name *string `json:"name,omitempty"`
	// OrderBy - Order of the Cosmos DB Cassandra table cluster key, only support "Asc" and "Desc"
	OrderBy *string `json:"orderBy,omitempty"`
}

// Column cosmos DB Cassandra table column
type Column struct {
	// Name - Name of the Cosmos DB Cassandra table column
	Name *string `json:"name,omitempty"`
	// Type - Type of the Cosmos DB Cassandra table column
	Type *string `json:"type,omitempty"`
}

// CompositePath ...
type CompositePath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Order - Sort order for composite paths. Possible values include: 'Ascending', 'Descending'
	Order CompositePathSortOrder `json:"order,omitempty"`
}

// ConflictResolutionPolicy the conflict resolution policy for the container.
type ConflictResolutionPolicy struct {
	// Mode - Indicates the conflict resolution mode. Possible values include: 'LastWriterWins', 'Custom'
	Mode ConflictResolutionMode `json:"mode,omitempty"`
	// ConflictResolutionPath - The conflict resolution path in the case of LastWriterWins mode.
	ConflictResolutionPath *string `json:"conflictResolutionPath,omitempty"`
	// ConflictResolutionProcedure - The procedure to resolve conflicts in the case of custom mode.
	ConflictResolutionProcedure *string `json:"conflictResolutionProcedure,omitempty"`
}

// ConsistencyPolicy the consistency policy for the Cosmos DB database account.
type ConsistencyPolicy struct {
	// DefaultConsistencyLevel - The default consistency level and configuration settings of the Cosmos DB account. Possible values include: 'Eventual', 'Session', 'BoundedStaleness', 'Strong', 'ConsistentPrefix'
	DefaultConsistencyLevel DefaultConsistencyLevel `json:"defaultConsistencyLevel,omitempty"`
	// MaxStalenessPrefix - When used with the Bounded Staleness consistency level, this value represents the number of stale requests tolerated. Accepted range for this value is 1 – 2,147,483,647. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxStalenessPrefix *int64 `json:"maxStalenessPrefix,omitempty"`
	// MaxIntervalInSeconds - When used with the Bounded Staleness consistency level, this value represents the time amount of staleness (in seconds) tolerated. Accepted range for this value is 5 - 86400. Required when defaultConsistencyPolicy is set to 'BoundedStaleness'.
	MaxIntervalInSeconds *int32 `json:"maxIntervalInSeconds,omitempty"`
}

// ContainerPartitionKey the configuration of the partition key to be used for partitioning data into
// multiple partitions
type ContainerPartitionKey struct {
	// Paths - List of paths using which data within the container can be partitioned
	Paths *[]string `json:"paths,omitempty"`
	// Kind - Indicates the kind of algorithm used for partitioning. Possible values include: 'PartitionKindHash', 'PartitionKindRange'
	Kind PartitionKind `json:"kind,omitempty"`
	// Version - Indicates the version of the partition key definition
	Version *int32 `json:"version,omitempty"`
}

// DatabaseAccountConnectionString connection string for the Cosmos DB account
type DatabaseAccountConnectionString struct {
	// ConnectionString - READ-ONLY; Value of the connection string
	ConnectionString *string `json:"connectionString,omitempty"`
	// Description - READ-ONLY; Description of the connection string
	Description *string `json:"description,omitempty"`
}

// DatabaseAccountCreateUpdateParameters parameters to create and update Cosmos DB database accounts.
type DatabaseAccountCreateUpdateParameters struct {
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                                   DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountCreateUpdateParameters.
func (dacup DatabaseAccountCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dacup.Kind != "" {
		objectMap["kind"] = dacup.Kind
	}
	if dacup.DatabaseAccountCreateUpdateProperties != nil {
		objectMap["properties"] = dacup.DatabaseAccountCreateUpdateProperties
	}
	if dacup.Location != nil {
		objectMap["location"] = dacup.Location
	}
	if dacup.Tags != nil {
		objectMap["tags"] = dacup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountCreateUpdateParameters struct.
func (dacup *DatabaseAccountCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dacup.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountCreateUpdateProperties DatabaseAccountCreateUpdateProperties
				err = json.Unmarshal(*v, &databaseAccountCreateUpdateProperties)
				if err != nil {
					return err
				}
				dacup.DatabaseAccountCreateUpdateProperties = &databaseAccountCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dacup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dacup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dacup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dacup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dacup.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountCreateUpdateProperties properties to create and update Azure Cosmos DB database accounts.
type DatabaseAccountCreateUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// DatabaseAccountOfferType - The offer type for the database
	DatabaseAccountOfferType *string `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
}

// DatabaseAccountGetProperties properties for the database account.
type DatabaseAccountGetProperties struct {
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the Cosmos DB database account.
	DocumentEndpoint *string `json:"documentEndpoint,omitempty"`
	// DatabaseAccountOfferType - READ-ONLY; The offer type for the Cosmos DB database account. Default value: Standard. Possible values include: 'Standard'
	DatabaseAccountOfferType DatabaseAccountOfferType `json:"databaseAccountOfferType,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// ConsistencyPolicy - The consistency policy for the Cosmos DB database account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// WriteLocations - READ-ONLY; An array that contains the write location for the Cosmos DB account.
	WriteLocations *[]Location `json:"writeLocations,omitempty"`
	// ReadLocations - READ-ONLY; An array that contains of the read locations enabled for the Cosmos DB account.
	ReadLocations *[]Location `json:"readLocations,omitempty"`
	// Locations - READ-ONLY; An array that contains all of the locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// FailoverPolicies - READ-ONLY; An array that contains the regions ordered by their failover priorities.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountGetProperties.
func (dagp DatabaseAccountGetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dagp.ProvisioningState != nil {
		objectMap["provisioningState"] = dagp.ProvisioningState
	}
	if dagp.IPRangeFilter != nil {
		objectMap["ipRangeFilter"] = dagp.IPRangeFilter
	}
	if dagp.IsVirtualNetworkFilterEnabled != nil {
		objectMap["isVirtualNetworkFilterEnabled"] = dagp.IsVirtualNetworkFilterEnabled
	}
	if dagp.EnableAutomaticFailover != nil {
		objectMap["enableAutomaticFailover"] = dagp.EnableAutomaticFailover
	}
	if dagp.ConsistencyPolicy != nil {
		objectMap["consistencyPolicy"] = dagp.ConsistencyPolicy
	}
	if dagp.Capabilities != nil {
		objectMap["capabilities"] = dagp.Capabilities
	}
	if dagp.VirtualNetworkRules != nil {
		objectMap["virtualNetworkRules"] = dagp.VirtualNetworkRules
	}
	if dagp.EnableMultipleWriteLocations != nil {
		objectMap["enableMultipleWriteLocations"] = dagp.EnableMultipleWriteLocations
	}
	if dagp.EnableCassandraConnector != nil {
		objectMap["enableCassandraConnector"] = dagp.EnableCassandraConnector
	}
	if dagp.ConnectorOffer != "" {
		objectMap["connectorOffer"] = dagp.ConnectorOffer
	}
	if dagp.DisableKeyBasedMetadataWriteAccess != nil {
		objectMap["disableKeyBasedMetadataWriteAccess"] = dagp.DisableKeyBasedMetadataWriteAccess
	}
	return json.Marshal(objectMap)
}

// DatabaseAccountGetResults an Azure Cosmos DB database account.
type DatabaseAccountGetResults struct {
	autorest.Response `json:"-"`
	// Kind - Indicates the type of database account. This can only be set at database account creation. Possible values include: 'GlobalDocumentDB', 'MongoDB', 'Parse'
	Kind                          DatabaseAccountKind `json:"kind,omitempty"`
	*DatabaseAccountGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountGetResults.
func (dagr DatabaseAccountGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dagr.Kind != "" {
		objectMap["kind"] = dagr.Kind
	}
	if dagr.DatabaseAccountGetProperties != nil {
		objectMap["properties"] = dagr.DatabaseAccountGetProperties
	}
	if dagr.Location != nil {
		objectMap["location"] = dagr.Location
	}
	if dagr.Tags != nil {
		objectMap["tags"] = dagr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountGetResults struct.
func (dagr *DatabaseAccountGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind DatabaseAccountKind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				dagr.Kind = kind
			}
		case "properties":
			if v != nil {
				var databaseAccountGetProperties DatabaseAccountGetProperties
				err = json.Unmarshal(*v, &databaseAccountGetProperties)
				if err != nil {
					return err
				}
				dagr.DatabaseAccountGetProperties = &databaseAccountGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dagr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dagr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dagr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dagr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dagr.Tags = tags
			}
		}
	}

	return nil
}

// DatabaseAccountListConnectionStringsResult the connection strings for the given database account.
type DatabaseAccountListConnectionStringsResult struct {
	autorest.Response `json:"-"`
	// ConnectionStrings - An array that contains the connection strings for the Cosmos DB account.
	ConnectionStrings *[]DatabaseAccountConnectionString `json:"connectionStrings,omitempty"`
}

// DatabaseAccountListKeysResult the access keys for the given database account.
type DatabaseAccountListKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryMasterKey - READ-ONLY; Base 64 encoded value of the primary read-write key.
	PrimaryMasterKey *string `json:"primaryMasterKey,omitempty"`
	// SecondaryMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-write key.
	SecondaryMasterKey *string `json:"secondaryMasterKey,omitempty"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountListReadOnlyKeysResult the read-only access keys for the given database account.
type DatabaseAccountListReadOnlyKeysResult struct {
	autorest.Response `json:"-"`
	// PrimaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the primary read-only key.
	PrimaryReadonlyMasterKey *string `json:"primaryReadonlyMasterKey,omitempty"`
	// SecondaryReadonlyMasterKey - READ-ONLY; Base 64 encoded value of the secondary read-only key.
	SecondaryReadonlyMasterKey *string `json:"secondaryReadonlyMasterKey,omitempty"`
}

// DatabaseAccountRegenerateKeyParameters parameters to regenerate the keys within the database account.
type DatabaseAccountRegenerateKeyParameters struct {
	// KeyKind - The access key to regenerate. Possible values include: 'Primary', 'Secondary', 'PrimaryReadonly', 'SecondaryReadonly'
	KeyKind KeyKind `json:"keyKind,omitempty"`
}

// DatabaseAccountsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (DatabaseAccountGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsCreateOrUpdateFuture.Result.
func (future *DatabaseAccountsCreateOrUpdateFuture) result(client DatabaseAccountsClient) (dagr DatabaseAccountGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dagr.Response.Response, err = future.GetResult(sender); err == nil && dagr.Response.Response.StatusCode != http.StatusNoContent {
		dagr, err = client.CreateOrUpdateResponder(dagr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsCreateOrUpdateFuture", "Result", dagr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsDeleteFuture.Result.
func (future *DatabaseAccountsDeleteFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsFailoverPriorityChangeFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DatabaseAccountsFailoverPriorityChangeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsFailoverPriorityChangeFuture.Result.
func (future *DatabaseAccountsFailoverPriorityChangeFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsFailoverPriorityChangeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsFailoverPriorityChangeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsListResult the List operation response, that contains the database accounts and their
// properties.
type DatabaseAccountsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of database account and their properties.
	Value *[]DatabaseAccountGetResults `json:"value,omitempty"`
}

// DatabaseAccountsOfflineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOfflineRegionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsOfflineRegionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsOfflineRegionFuture.Result.
func (future *DatabaseAccountsOfflineRegionFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOfflineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOfflineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsOnlineRegionFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsOnlineRegionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsOnlineRegionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsOnlineRegionFuture.Result.
func (future *DatabaseAccountsOnlineRegionFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsOnlineRegionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsOnlineRegionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsRegenerateKeyFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DatabaseAccountsRegenerateKeyFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsRegenerateKeyFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsRegenerateKeyFuture.Result.
func (future *DatabaseAccountsRegenerateKeyFuture) result(client DatabaseAccountsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsRegenerateKeyFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsRegenerateKeyFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DatabaseAccountsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DatabaseAccountsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DatabaseAccountsClient) (DatabaseAccountGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DatabaseAccountsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DatabaseAccountsUpdateFuture.Result.
func (future *DatabaseAccountsUpdateFuture) result(client DatabaseAccountsClient) (dagr DatabaseAccountGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.DatabaseAccountsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dagr.Response.Response, err = future.GetResult(sender); err == nil && dagr.Response.Response.StatusCode != http.StatusNoContent {
		dagr, err = client.UpdateResponder(dagr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.DatabaseAccountsUpdateFuture", "Result", dagr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DatabaseAccountUpdateParameters parameters for patching Azure Cosmos DB database account properties.
type DatabaseAccountUpdateParameters struct {
	Tags map[string]*string `json:"tags"`
	// Location - The location of the resource group to which the resource belongs.
	Location                         *string `json:"location,omitempty"`
	*DatabaseAccountUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DatabaseAccountUpdateParameters.
func (daup DatabaseAccountUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if daup.Tags != nil {
		objectMap["tags"] = daup.Tags
	}
	if daup.Location != nil {
		objectMap["location"] = daup.Location
	}
	if daup.DatabaseAccountUpdateProperties != nil {
		objectMap["properties"] = daup.DatabaseAccountUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DatabaseAccountUpdateParameters struct.
func (daup *DatabaseAccountUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				daup.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				daup.Location = &location
			}
		case "properties":
			if v != nil {
				var databaseAccountUpdateProperties DatabaseAccountUpdateProperties
				err = json.Unmarshal(*v, &databaseAccountUpdateProperties)
				if err != nil {
					return err
				}
				daup.DatabaseAccountUpdateProperties = &databaseAccountUpdateProperties
			}
		}
	}

	return nil
}

// DatabaseAccountUpdateProperties properties to update Azure Cosmos DB database accounts.
type DatabaseAccountUpdateProperties struct {
	// ConsistencyPolicy - The consistency policy for the Cosmos DB account.
	ConsistencyPolicy *ConsistencyPolicy `json:"consistencyPolicy,omitempty"`
	// Locations - An array that contains the georeplication locations enabled for the Cosmos DB account.
	Locations *[]Location `json:"locations,omitempty"`
	// IPRangeFilter - Cosmos DB Firewall Support: This value specifies the set of IP addresses or IP address ranges in CIDR form to be included as the allowed list of client IPs for a given database account. IP addresses/ranges must be comma separated and must not contain any spaces.
	IPRangeFilter *string `json:"ipRangeFilter,omitempty"`
	// IsVirtualNetworkFilterEnabled - Flag to indicate whether to enable/disable Virtual Network ACL rules.
	IsVirtualNetworkFilterEnabled *bool `json:"isVirtualNetworkFilterEnabled,omitempty"`
	// EnableAutomaticFailover - Enables automatic failover of the write region in the rare event that the region is unavailable due to an outage. Automatic failover will result in a new write region for the account and is chosen based on the failover priorities configured for the account.
	EnableAutomaticFailover *bool `json:"enableAutomaticFailover,omitempty"`
	// Capabilities - List of Cosmos DB capabilities for the account
	Capabilities *[]Capability `json:"capabilities,omitempty"`
	// VirtualNetworkRules - List of Virtual Network ACL rules configured for the Cosmos DB account.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// EnableMultipleWriteLocations - Enables the account to write in multiple locations
	EnableMultipleWriteLocations *bool `json:"enableMultipleWriteLocations,omitempty"`
	// EnableCassandraConnector - Enables the cassandra connector on the Cosmos DB C* account
	EnableCassandraConnector *bool `json:"enableCassandraConnector,omitempty"`
	// ConnectorOffer - The cassandra connector offer type for the Cosmos DB database C* account. Possible values include: 'Small'
	ConnectorOffer ConnectorOffer `json:"connectorOffer,omitempty"`
	// DisableKeyBasedMetadataWriteAccess - Disable write operations on metadata resources (databases, containers, throughput) via account keys
	DisableKeyBasedMetadataWriteAccess *bool `json:"disableKeyBasedMetadataWriteAccess,omitempty"`
}

// ErrorResponse error Response.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// ExcludedPath ...
type ExcludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
}

// ExtendedResourceProperties the system generated resource properties associated with SQL databases, SQL
// containers, Gremlin databases and Gremlin graphs.
type ExtendedResourceProperties struct {
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// FailoverPolicies the list of new failover policies for the failover priority change.
type FailoverPolicies struct {
	// FailoverPolicies - List of failover policies.
	FailoverPolicies *[]FailoverPolicy `json:"failoverPolicies,omitempty"`
}

// FailoverPolicy the failover policy for a given region of a database account.
type FailoverPolicy struct {
	// ID - READ-ONLY; The unique identifier of the region in which the database account replicates to. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region in which the database account exists.
	LocationName *string `json:"locationName,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
}

// MarshalJSON is the custom marshaler for FailoverPolicy.
func (fp FailoverPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if fp.LocationName != nil {
		objectMap["locationName"] = fp.LocationName
	}
	if fp.FailoverPriority != nil {
		objectMap["failoverPriority"] = fp.FailoverPriority
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseCreateUpdateParameters parameters to create and update Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateParameters struct {
	// GremlinDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin database.
	*GremlinDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseCreateUpdateParameters.
func (gdcup GremlinDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdcup.GremlinDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = gdcup.GremlinDatabaseCreateUpdateProperties
	}
	if gdcup.Location != nil {
		objectMap["location"] = gdcup.Location
	}
	if gdcup.Tags != nil {
		objectMap["tags"] = gdcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabaseCreateUpdateParameters struct.
func (gdcup *GremlinDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseCreateUpdateProperties GremlinDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				gdcup.GremlinDatabaseCreateUpdateProperties = &gremlinDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gdcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gdcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gdcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gdcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gdcup.Tags = tags
			}
		}
	}

	return nil
}

// GremlinDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin database.
type GremlinDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin database
	Resource *GremlinDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseCreateUpdateProperties.
func (gdcup GremlinDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdcup.Resource != nil {
		objectMap["resource"] = gdcup.Resource
	}
	if gdcup.Options != nil {
		objectMap["options"] = gdcup.Options
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseGetProperties the properties of an Azure Cosmos DB SQL database
type GremlinDatabaseGetProperties struct {
	Resource *GremlinDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

// GremlinDatabaseGetPropertiesResource ...
type GremlinDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseGetPropertiesResource.
func (gdgp GremlinDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdgp.ID != nil {
		objectMap["id"] = gdgp.ID
	}
	return json.Marshal(objectMap)
}

// GremlinDatabaseGetResults an Azure Cosmos DB Gremlin database.
type GremlinDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// GremlinDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
	*GremlinDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinDatabaseGetResults.
func (gdgr GremlinDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gdgr.GremlinDatabaseGetProperties != nil {
		objectMap["properties"] = gdgr.GremlinDatabaseGetProperties
	}
	if gdgr.Location != nil {
		objectMap["location"] = gdgr.Location
	}
	if gdgr.Tags != nil {
		objectMap["tags"] = gdgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinDatabaseGetResults struct.
func (gdgr *GremlinDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinDatabaseGetProperties GremlinDatabaseGetProperties
				err = json.Unmarshal(*v, &gremlinDatabaseGetProperties)
				if err != nil {
					return err
				}
				gdgr.GremlinDatabaseGetProperties = &gremlinDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gdgr.Tags = tags
			}
		}
	}

	return nil
}

// GremlinDatabaseListResult the List operation response, that contains the Gremlin databases and their
// properties.
type GremlinDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Gremlin databases and their properties.
	Value *[]GremlinDatabaseGetResults `json:"value,omitempty"`
}

// GremlinDatabaseResource cosmos DB Gremlin database resource object
type GremlinDatabaseResource struct {
	// ID - Name of the Cosmos DB Gremlin database
	ID *string `json:"id,omitempty"`
}

// GremlinGraphCreateUpdateParameters parameters to create and update Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateParameters struct {
	// GremlinGraphCreateUpdateProperties - Properties to create and update Azure Cosmos DB Gremlin graph.
	*GremlinGraphCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinGraphCreateUpdateParameters.
func (ggcup GremlinGraphCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggcup.GremlinGraphCreateUpdateProperties != nil {
		objectMap["properties"] = ggcup.GremlinGraphCreateUpdateProperties
	}
	if ggcup.Location != nil {
		objectMap["location"] = ggcup.Location
	}
	if ggcup.Tags != nil {
		objectMap["tags"] = ggcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraphCreateUpdateParameters struct.
func (ggcup *GremlinGraphCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphCreateUpdateProperties GremlinGraphCreateUpdateProperties
				err = json.Unmarshal(*v, &gremlinGraphCreateUpdateProperties)
				if err != nil {
					return err
				}
				ggcup.GremlinGraphCreateUpdateProperties = &gremlinGraphCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ggcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ggcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ggcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ggcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ggcup.Tags = tags
			}
		}
	}

	return nil
}

// GremlinGraphCreateUpdateProperties properties to create and update Azure Cosmos DB Gremlin graph.
type GremlinGraphCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Gremlin graph
	Resource *GremlinGraphResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for GremlinGraphCreateUpdateProperties.
func (ggcup GremlinGraphCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggcup.Resource != nil {
		objectMap["resource"] = ggcup.Resource
	}
	if ggcup.Options != nil {
		objectMap["options"] = ggcup.Options
	}
	return json.Marshal(objectMap)
}

// GremlinGraphGetProperties the properties of an Azure Cosmos DB Gremlin graph
type GremlinGraphGetProperties struct {
	Resource *GremlinGraphGetPropertiesResource `json:"resource,omitempty"`
}

// GremlinGraphGetPropertiesResource ...
type GremlinGraphGetPropertiesResource struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for GremlinGraphGetPropertiesResource.
func (gggp GremlinGraphGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gggp.ID != nil {
		objectMap["id"] = gggp.ID
	}
	if gggp.IndexingPolicy != nil {
		objectMap["indexingPolicy"] = gggp.IndexingPolicy
	}
	if gggp.PartitionKey != nil {
		objectMap["partitionKey"] = gggp.PartitionKey
	}
	if gggp.DefaultTTL != nil {
		objectMap["defaultTtl"] = gggp.DefaultTTL
	}
	if gggp.UniqueKeyPolicy != nil {
		objectMap["uniqueKeyPolicy"] = gggp.UniqueKeyPolicy
	}
	if gggp.ConflictResolutionPolicy != nil {
		objectMap["conflictResolutionPolicy"] = gggp.ConflictResolutionPolicy
	}
	return json.Marshal(objectMap)
}

// GremlinGraphGetResults an Azure Cosmos DB Gremlin graph.
type GremlinGraphGetResults struct {
	autorest.Response `json:"-"`
	// GremlinGraphGetProperties - The properties of an Azure Cosmos DB Gremlin graph
	*GremlinGraphGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GremlinGraphGetResults.
func (gggr GremlinGraphGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gggr.GremlinGraphGetProperties != nil {
		objectMap["properties"] = gggr.GremlinGraphGetProperties
	}
	if gggr.Location != nil {
		objectMap["location"] = gggr.Location
	}
	if gggr.Tags != nil {
		objectMap["tags"] = gggr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for GremlinGraphGetResults struct.
func (gggr *GremlinGraphGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var gremlinGraphGetProperties GremlinGraphGetProperties
				err = json.Unmarshal(*v, &gremlinGraphGetProperties)
				if err != nil {
					return err
				}
				gggr.GremlinGraphGetProperties = &gremlinGraphGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gggr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gggr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gggr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				gggr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				gggr.Tags = tags
			}
		}
	}

	return nil
}

// GremlinGraphListResult the List operation response, that contains the graphs and their properties.
type GremlinGraphListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of graphs and their properties.
	Value *[]GremlinGraphGetResults `json:"value,omitempty"`
}

// GremlinGraphResource cosmos DB Gremlin graph resource object
type GremlinGraphResource struct {
	// ID - Name of the Cosmos DB Gremlin graph
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the graph.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// GremlinResourcesCreateUpdateGremlinDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesCreateUpdateGremlinDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (GremlinDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesCreateUpdateGremlinDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesCreateUpdateGremlinDatabaseFuture.Result.
func (future *GremlinResourcesCreateUpdateGremlinDatabaseFuture) result(client GremlinResourcesClient) (gdgr GremlinDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gdgr.Response.Response, err = future.GetResult(sender); err == nil && gdgr.Response.Response.StatusCode != http.StatusNoContent {
		gdgr, err = client.CreateUpdateGremlinDatabaseResponder(gdgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinDatabaseFuture", "Result", gdgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesCreateUpdateGremlinGraphFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type GremlinResourcesCreateUpdateGremlinGraphFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (GremlinGraphGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesCreateUpdateGremlinGraphFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesCreateUpdateGremlinGraphFuture.Result.
func (future *GremlinResourcesCreateUpdateGremlinGraphFuture) result(client GremlinResourcesClient) (gggr GremlinGraphGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gggr.Response.Response, err = future.GetResult(sender); err == nil && gggr.Response.Response.StatusCode != http.StatusNoContent {
		gggr, err = client.CreateUpdateGremlinGraphResponder(gggr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesCreateUpdateGremlinGraphFuture", "Result", gggr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesDeleteGremlinDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type GremlinResourcesDeleteGremlinDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesDeleteGremlinDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesDeleteGremlinDatabaseFuture.Result.
func (future *GremlinResourcesDeleteGremlinDatabaseFuture) result(client GremlinResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesDeleteGremlinDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesDeleteGremlinDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GremlinResourcesDeleteGremlinGraphFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type GremlinResourcesDeleteGremlinGraphFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesDeleteGremlinGraphFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesDeleteGremlinGraphFuture.Result.
func (future *GremlinResourcesDeleteGremlinGraphFuture) result(client GremlinResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesDeleteGremlinGraphFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesDeleteGremlinGraphFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GremlinResourcesUpdateGremlinDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesUpdateGremlinDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesUpdateGremlinDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesUpdateGremlinDatabaseThroughputFuture.Result.
func (future *GremlinResourcesUpdateGremlinDatabaseThroughputFuture) result(client GremlinResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateGremlinDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// GremlinResourcesUpdateGremlinGraphThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type GremlinResourcesUpdateGremlinGraphThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GremlinResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GremlinResourcesUpdateGremlinGraphThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GremlinResourcesUpdateGremlinGraphThroughputFuture.Result.
func (future *GremlinResourcesUpdateGremlinGraphThroughputFuture) result(client GremlinResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateGremlinGraphThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.GremlinResourcesUpdateGremlinGraphThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// IncludedPath the paths that are included in indexing
type IncludedPath struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Indexes - List of indexes for this path
	Indexes *[]Indexes `json:"indexes,omitempty"`
}

// Indexes the indexes for the path.
type Indexes struct {
	// DataType - The datatype for which the indexing behavior is applied to. Possible values include: 'String', 'Number', 'Point', 'Polygon', 'LineString', 'MultiPolygon'
	DataType DataType `json:"dataType,omitempty"`
	// Precision - The precision of the index. -1 is maximum precision.
	Precision *int32 `json:"precision,omitempty"`
	// Kind - Indicates the type of index. Possible values include: 'Hash', 'Range', 'Spatial'
	Kind IndexKind `json:"kind,omitempty"`
}

// IndexingPolicy cosmos DB indexing policy
type IndexingPolicy struct {
	// Automatic - Indicates if the indexing policy is automatic
	Automatic *bool `json:"automatic,omitempty"`
	// IndexingMode - Indicates the indexing mode. Possible values include: 'Consistent', 'Lazy', 'None'
	IndexingMode IndexingMode `json:"indexingMode,omitempty"`
	// IncludedPaths - List of paths to include in the indexing
	IncludedPaths *[]IncludedPath `json:"includedPaths,omitempty"`
	// ExcludedPaths - List of paths to exclude from indexing
	ExcludedPaths *[]ExcludedPath `json:"excludedPaths,omitempty"`
	// CompositeIndexes - List of composite path list
	CompositeIndexes *[][]CompositePath `json:"compositeIndexes,omitempty"`
	// SpatialIndexes - List of spatial specifics
	SpatialIndexes *[]SpatialSpec `json:"spatialIndexes,omitempty"`
}

// Location a region in which the Azure Cosmos DB database account is deployed.
type Location struct {
	// ID - READ-ONLY; The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
	ID *string `json:"id,omitempty"`
	// LocationName - The name of the region.
	LocationName *string `json:"locationName,omitempty"`
	// DocumentEndpoint - READ-ONLY; The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
	DocumentEndpoint  *string `json:"documentEndpoint,omitempty"`
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// FailoverPriority - The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
	FailoverPriority *int32 `json:"failoverPriority,omitempty"`
	// IsZoneRedundant - Flag to indicate whether or not this region is an AvailabilityZone region
	IsZoneRedundant *bool `json:"isZoneRedundant,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.LocationName != nil {
		objectMap["locationName"] = l.LocationName
	}
	if l.ProvisioningState != nil {
		objectMap["provisioningState"] = l.ProvisioningState
	}
	if l.FailoverPriority != nil {
		objectMap["failoverPriority"] = l.FailoverPriority
	}
	if l.IsZoneRedundant != nil {
		objectMap["isZoneRedundant"] = l.IsZoneRedundant
	}
	return json.Marshal(objectMap)
}

// Metric metric data
type Metric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for Metric.
func (mVar Metric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Unit != "" {
		objectMap["unit"] = mVar.Unit
	}
	return json.Marshal(objectMap)
}

// MetricAvailability the availability of the metric.
type MetricAvailability struct {
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Retention - READ-ONLY; The retention for the metric values.
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition the definition of a metric.
type MetricDefinition struct {
	// MetricAvailabilities - READ-ONLY; The list of metric availabilities for the account.
	MetricAvailabilities *[]MetricAvailability `json:"metricAvailabilities,omitempty"`
	// PrimaryAggregationType - READ-ONLY; The primary aggregation type of the metric. Possible values include: 'PrimaryAggregationTypeNone', 'PrimaryAggregationTypeAverage', 'PrimaryAggregationTypeTotal', 'PrimaryAggregationTypeMinimum', 'PrimaryAggregationTypeMaximum', 'PrimaryAggregationTypeLast'
	PrimaryAggregationType PrimaryAggregationType `json:"primaryAggregationType,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// ResourceURI - READ-ONLY; The resource uri of the database.
	ResourceURI *string `json:"resourceUri,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricDefinition.
func (md MetricDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if md.Unit != "" {
		objectMap["unit"] = md.Unit
	}
	return json.Marshal(objectMap)
}

// MetricDefinitionsListResult the response to a list metric definitions request.
type MetricDefinitionsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metric definitions for the account.
	Value *[]MetricDefinition `json:"value,omitempty"`
}

// MetricListResult the response to a list metrics request.
type MetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of metrics for the account.
	Value *[]Metric `json:"value,omitempty"`
}

// MetricName a metric name.
type MetricName struct {
	// Value - READ-ONLY; The name of the metric.
	Value *string `json:"value,omitempty"`
	// LocalizedValue - READ-ONLY; The friendly name of the metric.
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// MetricValue represents metrics values.
type MetricValue struct {
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// MongoDBCollectionCreateUpdateParameters parameters to create and update Cosmos DB MongoDB collection.
type MongoDBCollectionCreateUpdateParameters struct {
	// MongoDBCollectionCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB collection.
	*MongoDBCollectionCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionCreateUpdateParameters.
func (mdccup MongoDBCollectionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdccup.MongoDBCollectionCreateUpdateProperties != nil {
		objectMap["properties"] = mdccup.MongoDBCollectionCreateUpdateProperties
	}
	if mdccup.Location != nil {
		objectMap["location"] = mdccup.Location
	}
	if mdccup.Tags != nil {
		objectMap["tags"] = mdccup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollectionCreateUpdateParameters struct.
func (mdccup *MongoDBCollectionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionCreateUpdateProperties MongoDBCollectionCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBCollectionCreateUpdateProperties)
				if err != nil {
					return err
				}
				mdccup.MongoDBCollectionCreateUpdateProperties = &mongoDBCollectionCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdccup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdccup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdccup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdccup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdccup.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBCollectionCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB
// collection.
type MongoDBCollectionCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB collection
	Resource *MongoDBCollectionResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionCreateUpdateProperties.
func (mdccup MongoDBCollectionCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdccup.Resource != nil {
		objectMap["resource"] = mdccup.Resource
	}
	if mdccup.Options != nil {
		objectMap["options"] = mdccup.Options
	}
	return json.Marshal(objectMap)
}

// MongoDBCollectionGetProperties the properties of an Azure Cosmos DB MongoDB collection
type MongoDBCollectionGetProperties struct {
	Resource *MongoDBCollectionGetPropertiesResource `json:"resource,omitempty"`
}

// MongoDBCollectionGetPropertiesResource ...
type MongoDBCollectionGetPropertiesResource struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionGetPropertiesResource.
func (mdcgp MongoDBCollectionGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcgp.ID != nil {
		objectMap["id"] = mdcgp.ID
	}
	if mdcgp.ShardKey != nil {
		objectMap["shardKey"] = mdcgp.ShardKey
	}
	if mdcgp.Indexes != nil {
		objectMap["indexes"] = mdcgp.Indexes
	}
	return json.Marshal(objectMap)
}

// MongoDBCollectionGetResults an Azure Cosmos DB MongoDB collection.
type MongoDBCollectionGetResults struct {
	autorest.Response `json:"-"`
	// MongoDBCollectionGetProperties - The properties of an Azure Cosmos DB MongoDB collection
	*MongoDBCollectionGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionGetResults.
func (mdcgr MongoDBCollectionGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcgr.MongoDBCollectionGetProperties != nil {
		objectMap["properties"] = mdcgr.MongoDBCollectionGetProperties
	}
	if mdcgr.Location != nil {
		objectMap["location"] = mdcgr.Location
	}
	if mdcgr.Tags != nil {
		objectMap["tags"] = mdcgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBCollectionGetResults struct.
func (mdcgr *MongoDBCollectionGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBCollectionGetProperties MongoDBCollectionGetProperties
				err = json.Unmarshal(*v, &mongoDBCollectionGetProperties)
				if err != nil {
					return err
				}
				mdcgr.MongoDBCollectionGetProperties = &mongoDBCollectionGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mdcgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mdcgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mdcgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mdcgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mdcgr.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBCollectionListResult the List operation response, that contains the MongoDB collections and their
// properties.
type MongoDBCollectionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB collections and their properties.
	Value *[]MongoDBCollectionGetResults `json:"value,omitempty"`
}

// MongoDBCollectionResource cosmos DB MongoDB collection resource object
type MongoDBCollectionResource struct {
	// ID - Name of the Cosmos DB MongoDB collection
	ID *string `json:"id,omitempty"`
	// ShardKey - A key-value pair of shard keys to be applied for the request.
	ShardKey map[string]*string `json:"shardKey"`
	// Indexes - List of index keys
	Indexes *[]MongoIndex `json:"indexes,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBCollectionResource.
func (mdcr MongoDBCollectionResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mdcr.ID != nil {
		objectMap["id"] = mdcr.ID
	}
	if mdcr.ShardKey != nil {
		objectMap["shardKey"] = mdcr.ShardKey
	}
	if mdcr.Indexes != nil {
		objectMap["indexes"] = mdcr.Indexes
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseCreateUpdateParameters parameters to create and update Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateParameters struct {
	// MongoDBDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB MongoDB database.
	*MongoDBDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseCreateUpdateParameters.
func (mddcup MongoDBDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddcup.MongoDBDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = mddcup.MongoDBDatabaseCreateUpdateProperties
	}
	if mddcup.Location != nil {
		objectMap["location"] = mddcup.Location
	}
	if mddcup.Tags != nil {
		objectMap["tags"] = mddcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabaseCreateUpdateParameters struct.
func (mddcup *MongoDBDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseCreateUpdateProperties MongoDBDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				mddcup.MongoDBDatabaseCreateUpdateProperties = &mongoDBDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mddcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mddcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mddcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mddcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mddcup.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB MongoDB database.
type MongoDBDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a MongoDB database
	Resource *MongoDBDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseCreateUpdateProperties.
func (mddcup MongoDBDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddcup.Resource != nil {
		objectMap["resource"] = mddcup.Resource
	}
	if mddcup.Options != nil {
		objectMap["options"] = mddcup.Options
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseGetProperties the properties of an Azure Cosmos DB MongoDB database
type MongoDBDatabaseGetProperties struct {
	Resource *MongoDBDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

// MongoDBDatabaseGetPropertiesResource ...
type MongoDBDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseGetPropertiesResource.
func (mddgp MongoDBDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddgp.ID != nil {
		objectMap["id"] = mddgp.ID
	}
	return json.Marshal(objectMap)
}

// MongoDBDatabaseGetResults an Azure Cosmos DB MongoDB database.
type MongoDBDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// MongoDBDatabaseGetProperties - The properties of an Azure Cosmos DB MongoDB database
	*MongoDBDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for MongoDBDatabaseGetResults.
func (mddgr MongoDBDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mddgr.MongoDBDatabaseGetProperties != nil {
		objectMap["properties"] = mddgr.MongoDBDatabaseGetProperties
	}
	if mddgr.Location != nil {
		objectMap["location"] = mddgr.Location
	}
	if mddgr.Tags != nil {
		objectMap["tags"] = mddgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MongoDBDatabaseGetResults struct.
func (mddgr *MongoDBDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mongoDBDatabaseGetProperties MongoDBDatabaseGetProperties
				err = json.Unmarshal(*v, &mongoDBDatabaseGetProperties)
				if err != nil {
					return err
				}
				mddgr.MongoDBDatabaseGetProperties = &mongoDBDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mddgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mddgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mddgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mddgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mddgr.Tags = tags
			}
		}
	}

	return nil
}

// MongoDBDatabaseListResult the List operation response, that contains the MongoDB databases and their
// properties.
type MongoDBDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of MongoDB databases and their properties.
	Value *[]MongoDBDatabaseGetResults `json:"value,omitempty"`
}

// MongoDBDatabaseResource cosmos DB MongoDB database resource object
type MongoDBDatabaseResource struct {
	// ID - Name of the Cosmos DB MongoDB database
	ID *string `json:"id,omitempty"`
}

// MongoDBResourcesCreateUpdateMongoDBCollectionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesCreateUpdateMongoDBCollectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (MongoDBCollectionGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesCreateUpdateMongoDBCollectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesCreateUpdateMongoDBCollectionFuture.Result.
func (future *MongoDBResourcesCreateUpdateMongoDBCollectionFuture) result(client MongoDBResourcesClient) (mdcgr MongoDBCollectionGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mdcgr.Response.Response, err = future.GetResult(sender); err == nil && mdcgr.Response.Response.StatusCode != http.StatusNoContent {
		mdcgr, err = client.CreateUpdateMongoDBCollectionResponder(mdcgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBCollectionFuture", "Result", mdcgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesCreateUpdateMongoDBDatabaseFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesCreateUpdateMongoDBDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (MongoDBDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesCreateUpdateMongoDBDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesCreateUpdateMongoDBDatabaseFuture.Result.
func (future *MongoDBResourcesCreateUpdateMongoDBDatabaseFuture) result(client MongoDBResourcesClient) (mddgr MongoDBDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mddgr.Response.Response, err = future.GetResult(sender); err == nil && mddgr.Response.Response.StatusCode != http.StatusNoContent {
		mddgr, err = client.CreateUpdateMongoDBDatabaseResponder(mddgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesCreateUpdateMongoDBDatabaseFuture", "Result", mddgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesDeleteMongoDBCollectionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type MongoDBResourcesDeleteMongoDBCollectionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesDeleteMongoDBCollectionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesDeleteMongoDBCollectionFuture.Result.
func (future *MongoDBResourcesDeleteMongoDBCollectionFuture) result(client MongoDBResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesDeleteMongoDBCollectionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesDeleteMongoDBCollectionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MongoDBResourcesDeleteMongoDBDatabaseFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type MongoDBResourcesDeleteMongoDBDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesDeleteMongoDBDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesDeleteMongoDBDatabaseFuture.Result.
func (future *MongoDBResourcesDeleteMongoDBDatabaseFuture) result(client MongoDBResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesDeleteMongoDBDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesDeleteMongoDBDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MongoDBResourcesUpdateMongoDBCollectionThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesUpdateMongoDBCollectionThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesUpdateMongoDBCollectionThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesUpdateMongoDBCollectionThroughputFuture.Result.
func (future *MongoDBResourcesUpdateMongoDBCollectionThroughputFuture) result(client MongoDBResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateMongoDBCollectionThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBCollectionThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MongoDBResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture.Result.
func (future *MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture) result(client MongoDBResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateMongoDBDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.MongoDBResourcesUpdateMongoDBDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MongoIndex cosmos DB MongoDB collection index key
type MongoIndex struct {
	// Key - Cosmos DB MongoDB collection index keys
	Key *MongoIndexKeys `json:"key,omitempty"`
	// Options - Cosmos DB MongoDB collection index key options
	Options *MongoIndexOptions `json:"options,omitempty"`
}

// MongoIndexKeys cosmos DB MongoDB collection resource object
type MongoIndexKeys struct {
	// Keys - List of keys for each MongoDB collection in the Azure Cosmos DB service
	Keys *[]string `json:"keys,omitempty"`
}

// MongoIndexOptions cosmos DB MongoDB collection index options
type MongoIndexOptions struct {
	// ExpireAfterSeconds - Expire after seconds
	ExpireAfterSeconds *int32 `json:"expireAfterSeconds,omitempty"`
	// Unique - Is unique or not
	Unique *bool `json:"unique,omitempty"`
}

// NotebookWorkspace a notebook workspace resource
type NotebookWorkspace struct {
	autorest.Response `json:"-"`
	// NotebookWorkspaceProperties - Resource properties.
	*NotebookWorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for NotebookWorkspace.
func (nw NotebookWorkspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if nw.NotebookWorkspaceProperties != nil {
		objectMap["properties"] = nw.NotebookWorkspaceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for NotebookWorkspace struct.
func (nw *NotebookWorkspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var notebookWorkspaceProperties NotebookWorkspaceProperties
				err = json.Unmarshal(*v, &notebookWorkspaceProperties)
				if err != nil {
					return err
				}
				nw.NotebookWorkspaceProperties = &notebookWorkspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				nw.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				nw.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				nw.Type = &typeVar
			}
		}
	}

	return nil
}

// NotebookWorkspaceConnectionInfoResult the connection info for the given notebook workspace
type NotebookWorkspaceConnectionInfoResult struct {
	autorest.Response `json:"-"`
	// AuthToken - READ-ONLY; Specifies auth token used for connecting to Notebook server (uses token-based auth).
	AuthToken *string `json:"authToken,omitempty"`
	// NotebookServerEndpoint - READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty"`
}

// NotebookWorkspaceCreateUpdateParameters parameters to create a notebook workspace resource
type NotebookWorkspaceCreateUpdateParameters struct {
	// ID - READ-ONLY; The unique resource identifier of the database account.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the database account.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
}

// NotebookWorkspaceListResult a list of notebook workspace resources
type NotebookWorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of notebook workspace resources
	Value *[]NotebookWorkspace `json:"value,omitempty"`
}

// NotebookWorkspaceProperties properties of a notebook workspace resource.
type NotebookWorkspaceProperties struct {
	// NotebookServerEndpoint - READ-ONLY; Specifies the endpoint of Notebook server.
	NotebookServerEndpoint *string `json:"notebookServerEndpoint,omitempty"`
	// Status - READ-ONLY; Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
	Status *string `json:"status,omitempty"`
}

// NotebookWorkspacesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NotebookWorkspacesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (NotebookWorkspace, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesCreateOrUpdateFuture.Result.
func (future *NotebookWorkspacesCreateOrUpdateFuture) result(client NotebookWorkspacesClient) (nw NotebookWorkspace, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if nw.Response.Response, err = future.GetResult(sender); err == nil && nw.Response.Response.StatusCode != http.StatusNoContent {
		nw, err = client.CreateOrUpdateResponder(nw.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesCreateOrUpdateFuture", "Result", nw.Response.Response, "Failure responding to request")
		}
	}
	return
}

// NotebookWorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type NotebookWorkspacesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesDeleteFuture.Result.
func (future *NotebookWorkspacesDeleteFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NotebookWorkspacesRegenerateAuthTokenFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type NotebookWorkspacesRegenerateAuthTokenFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesRegenerateAuthTokenFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesRegenerateAuthTokenFuture.Result.
func (future *NotebookWorkspacesRegenerateAuthTokenFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesRegenerateAuthTokenFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesRegenerateAuthTokenFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// NotebookWorkspacesStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type NotebookWorkspacesStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(NotebookWorkspacesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *NotebookWorkspacesStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for NotebookWorkspacesStartFuture.Result.
func (future *NotebookWorkspacesStartFuture) result(client NotebookWorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.NotebookWorkspacesStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.NotebookWorkspacesStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.ResourceProvider
	Provider *string `json:"Provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"Resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"Operation,omitempty"`
	// Description - Description of operation
	Description *string `json:"Description,omitempty"`
}

// OperationListResult result of the request to list Resource Provider operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Resource Provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PartitionMetric the metric values for a single partition.
type PartitionMetric struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the metric values.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the metric values.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The metric values for the specified time window and timestep.
	MetricValues *[]MetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for PartitionMetric.
func (pm PartitionMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.Unit != "" {
		objectMap["unit"] = pm.Unit
	}
	return json.Marshal(objectMap)
}

// PartitionMetricListResult the response to a list partition metrics request.
type PartitionMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level metrics for the account.
	Value *[]PartitionMetric `json:"value,omitempty"`
}

// PartitionUsage the partition level usage data for a usage request.
type PartitionUsage struct {
	// PartitionID - READ-ONLY; The partition id (GUID identifier) of the usages.
	PartitionID *string `json:"partitionId,omitempty"`
	// PartitionKeyRangeID - READ-ONLY; The partition key range id (integer identifier) of the usages.
	PartitionKeyRangeID *string `json:"partitionKeyRangeId,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// MarshalJSON is the custom marshaler for PartitionUsage.
func (pu PartitionUsage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pu.Unit != "" {
		objectMap["unit"] = pu.Unit
	}
	return json.Marshal(objectMap)
}

// PartitionUsagesResult the response to a list partition level usage request.
type PartitionUsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of partition-level usages for the database. A usage is a point in time metric
	Value *[]PartitionUsage `json:"value,omitempty"`
}

// PercentileMetric percentile Metric data
type PercentileMetric struct {
	// StartTime - READ-ONLY; The start time for the metric (ISO-8601 format).
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time for the metric (ISO-8601 format).
	EndTime *date.Time `json:"endTime,omitempty"`
	// TimeGrain - READ-ONLY; The time grain to be used to summarize the metric values.
	TimeGrain *string `json:"timeGrain,omitempty"`
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// MetricValues - READ-ONLY; The percentile metric values for the specified time window and timestep.
	MetricValues *[]PercentileMetricValue `json:"metricValues,omitempty"`
}

// MarshalJSON is the custom marshaler for PercentileMetric.
func (pm PercentileMetric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pm.Unit != "" {
		objectMap["unit"] = pm.Unit
	}
	return json.Marshal(objectMap)
}

// PercentileMetricListResult the response to a list percentile metrics request.
type PercentileMetricListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of percentile metrics for the account.
	Value *[]PercentileMetric `json:"value,omitempty"`
}

// PercentileMetricValue represents percentile metrics values.
type PercentileMetricValue struct {
	// P10 - READ-ONLY; The 10th percentile value for the metric.
	P10 *float64 `json:"P10,omitempty"`
	// P25 - READ-ONLY; The 25th percentile value for the metric.
	P25 *float64 `json:"P25,omitempty"`
	// P50 - READ-ONLY; The 50th percentile value for the metric.
	P50 *float64 `json:"P50,omitempty"`
	// P75 - READ-ONLY; The 75th percentile value for the metric.
	P75 *float64 `json:"P75,omitempty"`
	// P90 - READ-ONLY; The 90th percentile value for the metric.
	P90 *float64 `json:"P90,omitempty"`
	// P95 - READ-ONLY; The 95th percentile value for the metric.
	P95 *float64 `json:"P95,omitempty"`
	// P99 - READ-ONLY; The 99th percentile value for the metric.
	P99 *float64 `json:"P99,omitempty"`
	// Count - READ-ONLY; The number of values for the metric.
	Count *float64 `json:"_count,omitempty"`
	// Average - READ-ONLY; The average value of the metric.
	Average *float64 `json:"average,omitempty"`
	// Maximum - READ-ONLY; The max value of the metric.
	Maximum *float64 `json:"maximum,omitempty"`
	// Minimum - READ-ONLY; The min value of the metric.
	Minimum *float64 `json:"minimum,omitempty"`
	// Timestamp - READ-ONLY; The metric timestamp (ISO-8601 format).
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Total - READ-ONLY; The total value of the metric.
	Total *float64 `json:"total,omitempty"`
}

// RegionForOnlineOffline cosmos DB region to online or offline.
type RegionForOnlineOffline struct {
	// Region - Cosmos DB region, with spaces between words and each word capitalized.
	Region *string `json:"region,omitempty"`
}

// SpatialSpec ...
type SpatialSpec struct {
	// Path - The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
	Path *string `json:"path,omitempty"`
	// Types - List of path's spatial type
	Types *[]SpatialType `json:"types,omitempty"`
}

// SQLContainerCreateUpdateParameters parameters to create and update Cosmos DB container.
type SQLContainerCreateUpdateParameters struct {
	// SQLContainerCreateUpdateProperties - Properties to create and update Azure Cosmos DB container.
	*SQLContainerCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLContainerCreateUpdateParameters.
func (sccup SQLContainerCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccup.SQLContainerCreateUpdateProperties != nil {
		objectMap["properties"] = sccup.SQLContainerCreateUpdateProperties
	}
	if sccup.Location != nil {
		objectMap["location"] = sccup.Location
	}
	if sccup.Tags != nil {
		objectMap["tags"] = sccup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainerCreateUpdateParameters struct.
func (sccup *SQLContainerCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerCreateUpdateProperties SQLContainerCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLContainerCreateUpdateProperties)
				if err != nil {
					return err
				}
				sccup.SQLContainerCreateUpdateProperties = &SQLContainerCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sccup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sccup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sccup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sccup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sccup.Tags = tags
			}
		}
	}

	return nil
}

// SQLContainerCreateUpdateProperties properties to create and update Azure Cosmos DB container.
type SQLContainerCreateUpdateProperties struct {
	// Resource - The standard JSON format of a container
	Resource *SQLContainerResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLContainerCreateUpdateProperties.
func (sccup SQLContainerCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sccup.Resource != nil {
		objectMap["resource"] = sccup.Resource
	}
	if sccup.Options != nil {
		objectMap["options"] = sccup.Options
	}
	return json.Marshal(objectMap)
}

// SQLContainerGetProperties the properties of an Azure Cosmos DB container
type SQLContainerGetProperties struct {
	Resource *SQLContainerGetPropertiesResource `json:"resource,omitempty"`
}

// SQLContainerGetPropertiesResource ...
type SQLContainerGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLContainerGetPropertiesResource.
func (scgp SQLContainerGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scgp.ID != nil {
		objectMap["id"] = scgp.ID
	}
	if scgp.IndexingPolicy != nil {
		objectMap["indexingPolicy"] = scgp.IndexingPolicy
	}
	if scgp.PartitionKey != nil {
		objectMap["partitionKey"] = scgp.PartitionKey
	}
	if scgp.DefaultTTL != nil {
		objectMap["defaultTtl"] = scgp.DefaultTTL
	}
	if scgp.UniqueKeyPolicy != nil {
		objectMap["uniqueKeyPolicy"] = scgp.UniqueKeyPolicy
	}
	if scgp.ConflictResolutionPolicy != nil {
		objectMap["conflictResolutionPolicy"] = scgp.ConflictResolutionPolicy
	}
	return json.Marshal(objectMap)
}

// SQLContainerGetResults an Azure Cosmos DB container.
type SQLContainerGetResults struct {
	autorest.Response `json:"-"`
	// SQLContainerGetProperties - The properties of an Azure Cosmos DB container
	*SQLContainerGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLContainerGetResults.
func (scgr SQLContainerGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scgr.SQLContainerGetProperties != nil {
		objectMap["properties"] = scgr.SQLContainerGetProperties
	}
	if scgr.Location != nil {
		objectMap["location"] = scgr.Location
	}
	if scgr.Tags != nil {
		objectMap["tags"] = scgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLContainerGetResults struct.
func (scgr *SQLContainerGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLContainerGetProperties SQLContainerGetProperties
				err = json.Unmarshal(*v, &SQLContainerGetProperties)
				if err != nil {
					return err
				}
				scgr.SQLContainerGetProperties = &SQLContainerGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				scgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				scgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				scgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				scgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				scgr.Tags = tags
			}
		}
	}

	return nil
}

// SQLContainerListResult the List operation response, that contains the containers and their properties.
type SQLContainerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of containers and their properties.
	Value *[]SQLContainerGetResults `json:"value,omitempty"`
}

// SQLContainerResource cosmos DB SQL container resource object
type SQLContainerResource struct {
	// ID - Name of the Cosmos DB SQL container
	ID *string `json:"id,omitempty"`
	// IndexingPolicy - The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the container
	IndexingPolicy *IndexingPolicy `json:"indexingPolicy,omitempty"`
	// PartitionKey - The configuration of the partition key to be used for partitioning data into multiple partitions
	PartitionKey *ContainerPartitionKey `json:"partitionKey,omitempty"`
	// DefaultTTL - Default time to live
	DefaultTTL *int32 `json:"defaultTtl,omitempty"`
	// UniqueKeyPolicy - The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
	UniqueKeyPolicy *UniqueKeyPolicy `json:"uniqueKeyPolicy,omitempty"`
	// ConflictResolutionPolicy - The conflict resolution policy for the container.
	ConflictResolutionPolicy *ConflictResolutionPolicy `json:"conflictResolutionPolicy,omitempty"`
}

// SQLDatabaseCreateUpdateParameters parameters to create and update Cosmos DB SQL database.
type SQLDatabaseCreateUpdateParameters struct {
	// SQLDatabaseCreateUpdateProperties - Properties to create and update Azure Cosmos DB SQL database.
	*SQLDatabaseCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseCreateUpdateParameters.
func (sdcup SQLDatabaseCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcup.SQLDatabaseCreateUpdateProperties != nil {
		objectMap["properties"] = sdcup.SQLDatabaseCreateUpdateProperties
	}
	if sdcup.Location != nil {
		objectMap["location"] = sdcup.Location
	}
	if sdcup.Tags != nil {
		objectMap["tags"] = sdcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabaseCreateUpdateParameters struct.
func (sdcup *SQLDatabaseCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseCreateUpdateProperties SQLDatabaseCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLDatabaseCreateUpdateProperties)
				if err != nil {
					return err
				}
				sdcup.SQLDatabaseCreateUpdateProperties = &SQLDatabaseCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sdcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sdcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sdcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sdcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sdcup.Tags = tags
			}
		}
	}

	return nil
}

// SQLDatabaseCreateUpdateProperties properties to create and update Azure Cosmos DB SQL database.
type SQLDatabaseCreateUpdateProperties struct {
	// Resource - The standard JSON format of a SQL database
	Resource *SQLDatabaseResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseCreateUpdateProperties.
func (sdcup SQLDatabaseCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdcup.Resource != nil {
		objectMap["resource"] = sdcup.Resource
	}
	if sdcup.Options != nil {
		objectMap["options"] = sdcup.Options
	}
	return json.Marshal(objectMap)
}

// SQLDatabaseGetProperties the properties of an Azure Cosmos DB SQL database
type SQLDatabaseGetProperties struct {
	Resource *SQLDatabaseGetPropertiesResource `json:"resource,omitempty"`
}

// SQLDatabaseGetPropertiesResource ...
type SQLDatabaseGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
	// Colls - A system generated property that specified the addressable path of the collections resource.
	Colls *string `json:"_colls,omitempty"`
	// Users - A system generated property that specifies the addressable path of the users resource.
	Users *string `json:"_users,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseGetPropertiesResource.
func (sdgp SQLDatabaseGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdgp.ID != nil {
		objectMap["id"] = sdgp.ID
	}
	if sdgp.Colls != nil {
		objectMap["_colls"] = sdgp.Colls
	}
	if sdgp.Users != nil {
		objectMap["_users"] = sdgp.Users
	}
	return json.Marshal(objectMap)
}

// SQLDatabaseGetResults an Azure Cosmos DB SQL database.
type SQLDatabaseGetResults struct {
	autorest.Response `json:"-"`
	// SQLDatabaseGetProperties - The properties of an Azure Cosmos DB SQL database
	*SQLDatabaseGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseGetResults.
func (sdgr SQLDatabaseGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sdgr.SQLDatabaseGetProperties != nil {
		objectMap["properties"] = sdgr.SQLDatabaseGetProperties
	}
	if sdgr.Location != nil {
		objectMap["location"] = sdgr.Location
	}
	if sdgr.Tags != nil {
		objectMap["tags"] = sdgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLDatabaseGetResults struct.
func (sdgr *SQLDatabaseGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLDatabaseGetProperties SQLDatabaseGetProperties
				err = json.Unmarshal(*v, &SQLDatabaseGetProperties)
				if err != nil {
					return err
				}
				sdgr.SQLDatabaseGetProperties = &SQLDatabaseGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sdgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sdgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sdgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sdgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sdgr.Tags = tags
			}
		}
	}

	return nil
}

// SQLDatabaseListResult the List operation response, that contains the SQL databases and their properties.
type SQLDatabaseListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of SQL databases and their properties.
	Value *[]SQLDatabaseGetResults `json:"value,omitempty"`
}

// SQLDatabaseResource cosmos DB SQL database resource object
type SQLDatabaseResource struct {
	// ID - Name of the Cosmos DB SQL database
	ID *string `json:"id,omitempty"`
}

// SQLResourcesCreateUpdateSQLContainerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLContainerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLContainerGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLContainerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLContainerFuture.Result.
func (future *SQLResourcesCreateUpdateSQLContainerFuture) result(client SQLResourcesClient) (scgr SQLContainerGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLContainerFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if scgr.Response.Response, err = future.GetResult(sender); err == nil && scgr.Response.Response.StatusCode != http.StatusNoContent {
		scgr, err = client.CreateUpdateSQLContainerResponder(scgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLContainerFuture", "Result", scgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLDatabaseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLDatabaseGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLDatabaseFuture.Result.
func (future *SQLResourcesCreateUpdateSQLDatabaseFuture) result(client SQLResourcesClient) (sdgr SQLDatabaseGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sdgr.Response.Response, err = future.GetResult(sender); err == nil && sdgr.Response.Response.StatusCode != http.StatusNoContent {
		sdgr, err = client.CreateUpdateSQLDatabaseResponder(sdgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLDatabaseFuture", "Result", sdgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLStoredProcedureFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLResourcesCreateUpdateSQLStoredProcedureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLStoredProcedureGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLStoredProcedureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLStoredProcedureFuture.Result.
func (future *SQLResourcesCreateUpdateSQLStoredProcedureFuture) result(client SQLResourcesClient) (sspgr SQLStoredProcedureGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sspgr.Response.Response, err = future.GetResult(sender); err == nil && sspgr.Response.Response.StatusCode != http.StatusNoContent {
		sspgr, err = client.CreateUpdateSQLStoredProcedureResponder(sspgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLStoredProcedureFuture", "Result", sspgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLTriggerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesCreateUpdateSQLTriggerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLTriggerGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLTriggerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLTriggerFuture.Result.
func (future *SQLResourcesCreateUpdateSQLTriggerFuture) result(client SQLResourcesClient) (stgr SQLTriggerGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLTriggerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLTriggerFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if stgr.Response.Response, err = future.GetResult(sender); err == nil && stgr.Response.Response.StatusCode != http.StatusNoContent {
		stgr, err = client.CreateUpdateSQLTriggerResponder(stgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLTriggerFuture", "Result", stgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (SQLUserDefinedFunctionGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture.Result.
func (future *SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture) result(client SQLResourcesClient) (sudfgr SQLUserDefinedFunctionGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sudfgr.Response.Response, err = future.GetResult(sender); err == nil && sudfgr.Response.Response.StatusCode != http.StatusNoContent {
		sudfgr, err = client.CreateUpdateSQLUserDefinedFunctionResponder(sudfgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesCreateUpdateSQLUserDefinedFunctionFuture", "Result", sudfgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesDeleteSQLContainerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLContainerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLContainerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLContainerFuture.Result.
func (future *SQLResourcesDeleteSQLContainerFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLContainerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLContainerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLDatabaseFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLDatabaseFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLDatabaseFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLDatabaseFuture.Result.
func (future *SQLResourcesDeleteSQLDatabaseFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLDatabaseFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLDatabaseFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLStoredProcedureFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLStoredProcedureFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLStoredProcedureFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLStoredProcedureFuture.Result.
func (future *SQLResourcesDeleteSQLStoredProcedureFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLStoredProcedureFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLStoredProcedureFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLTriggerFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type SQLResourcesDeleteSQLTriggerFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLTriggerFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLTriggerFuture.Result.
func (future *SQLResourcesDeleteSQLTriggerFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLTriggerFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLTriggerFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesDeleteSQLUserDefinedFunctionFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesDeleteSQLUserDefinedFunctionFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesDeleteSQLUserDefinedFunctionFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesDeleteSQLUserDefinedFunctionFuture.Result.
func (future *SQLResourcesDeleteSQLUserDefinedFunctionFuture) result(client SQLResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesDeleteSQLUserDefinedFunctionFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesDeleteSQLUserDefinedFunctionFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// SQLResourcesUpdateSQLContainerThroughputFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesUpdateSQLContainerThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesUpdateSQLContainerThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesUpdateSQLContainerThroughputFuture.Result.
func (future *SQLResourcesUpdateSQLContainerThroughputFuture) result(client SQLResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLContainerThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesUpdateSQLContainerThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateSQLContainerThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLContainerThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLResourcesUpdateSQLDatabaseThroughputFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type SQLResourcesUpdateSQLDatabaseThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(SQLResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *SQLResourcesUpdateSQLDatabaseThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for SQLResourcesUpdateSQLDatabaseThroughputFuture.Result.
func (future *SQLResourcesUpdateSQLDatabaseThroughputFuture) result(client SQLResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateSQLDatabaseThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.SQLResourcesUpdateSQLDatabaseThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// SQLStoredProcedureCreateUpdateParameters parameters to create and update Cosmos DB storedProcedure.
type SQLStoredProcedureCreateUpdateParameters struct {
	// SQLStoredProcedureCreateUpdateProperties - Properties to create and update Azure Cosmos DB storedProcedure.
	*SQLStoredProcedureCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureCreateUpdateParameters.
func (sspcup SQLStoredProcedureCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspcup.SQLStoredProcedureCreateUpdateProperties != nil {
		objectMap["properties"] = sspcup.SQLStoredProcedureCreateUpdateProperties
	}
	if sspcup.Location != nil {
		objectMap["location"] = sspcup.Location
	}
	if sspcup.Tags != nil {
		objectMap["tags"] = sspcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLStoredProcedureCreateUpdateParameters struct.
func (sspcup *SQLStoredProcedureCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLStoredProcedureCreateUpdateProperties SQLStoredProcedureCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLStoredProcedureCreateUpdateProperties)
				if err != nil {
					return err
				}
				sspcup.SQLStoredProcedureCreateUpdateProperties = &SQLStoredProcedureCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sspcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sspcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sspcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sspcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sspcup.Tags = tags
			}
		}
	}

	return nil
}

// SQLStoredProcedureCreateUpdateProperties properties to create and update Azure Cosmos DB
// storedProcedure.
type SQLStoredProcedureCreateUpdateProperties struct {
	// Resource - The standard JSON format of a storedProcedure
	Resource *SQLStoredProcedureResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureCreateUpdateProperties.
func (sspcup SQLStoredProcedureCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspcup.Resource != nil {
		objectMap["resource"] = sspcup.Resource
	}
	if sspcup.Options != nil {
		objectMap["options"] = sspcup.Options
	}
	return json.Marshal(objectMap)
}

// SQLStoredProcedureGetProperties the properties of an Azure Cosmos DB StoredProcedure
type SQLStoredProcedureGetProperties struct {
	Resource *SQLStoredProcedureGetPropertiesResource `json:"resource,omitempty"`
}

// SQLStoredProcedureGetPropertiesResource ...
type SQLStoredProcedureGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`
	// Body - Body of the Stored Procedure
	Body *string `json:"body,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureGetPropertiesResource.
func (sspgp SQLStoredProcedureGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspgp.ID != nil {
		objectMap["id"] = sspgp.ID
	}
	if sspgp.Body != nil {
		objectMap["body"] = sspgp.Body
	}
	return json.Marshal(objectMap)
}

// SQLStoredProcedureGetResults an Azure Cosmos DB storedProcedure.
type SQLStoredProcedureGetResults struct {
	autorest.Response `json:"-"`
	// SQLStoredProcedureGetProperties - The properties of an Azure Cosmos DB storedProcedure
	*SQLStoredProcedureGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLStoredProcedureGetResults.
func (sspgr SQLStoredProcedureGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sspgr.SQLStoredProcedureGetProperties != nil {
		objectMap["properties"] = sspgr.SQLStoredProcedureGetProperties
	}
	if sspgr.Location != nil {
		objectMap["location"] = sspgr.Location
	}
	if sspgr.Tags != nil {
		objectMap["tags"] = sspgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLStoredProcedureGetResults struct.
func (sspgr *SQLStoredProcedureGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLStoredProcedureGetProperties SQLStoredProcedureGetProperties
				err = json.Unmarshal(*v, &SQLStoredProcedureGetProperties)
				if err != nil {
					return err
				}
				sspgr.SQLStoredProcedureGetProperties = &SQLStoredProcedureGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sspgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sspgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sspgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sspgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sspgr.Tags = tags
			}
		}
	}

	return nil
}

// SQLStoredProcedureListResult the List operation response, that contains the storedProcedures and their
// properties.
type SQLStoredProcedureListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of storedProcedures and their properties.
	Value *[]SQLStoredProcedureGetResults `json:"value,omitempty"`
}

// SQLStoredProcedureResource cosmos DB SQL storedProcedure resource object
type SQLStoredProcedureResource struct {
	// ID - Name of the Cosmos DB SQL storedProcedure
	ID *string `json:"id,omitempty"`
	// Body - Body of the Stored Procedure
	Body *string `json:"body,omitempty"`
}

// SQLTriggerCreateUpdateParameters parameters to create and update Cosmos DB trigger.
type SQLTriggerCreateUpdateParameters struct {
	// SQLTriggerCreateUpdateProperties - Properties to create and update Azure Cosmos DB trigger.
	*SQLTriggerCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLTriggerCreateUpdateParameters.
func (stcup SQLTriggerCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stcup.SQLTriggerCreateUpdateProperties != nil {
		objectMap["properties"] = stcup.SQLTriggerCreateUpdateProperties
	}
	if stcup.Location != nil {
		objectMap["location"] = stcup.Location
	}
	if stcup.Tags != nil {
		objectMap["tags"] = stcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLTriggerCreateUpdateParameters struct.
func (stcup *SQLTriggerCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLTriggerCreateUpdateProperties SQLTriggerCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLTriggerCreateUpdateProperties)
				if err != nil {
					return err
				}
				stcup.SQLTriggerCreateUpdateProperties = &SQLTriggerCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				stcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				stcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				stcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				stcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				stcup.Tags = tags
			}
		}
	}

	return nil
}

// SQLTriggerCreateUpdateProperties properties to create and update Azure Cosmos DB trigger.
type SQLTriggerCreateUpdateProperties struct {
	// Resource - The standard JSON format of a trigger
	Resource *SQLTriggerResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLTriggerCreateUpdateProperties.
func (stcup SQLTriggerCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stcup.Resource != nil {
		objectMap["resource"] = stcup.Resource
	}
	if stcup.Options != nil {
		objectMap["options"] = stcup.Options
	}
	return json.Marshal(objectMap)
}

// SQLTriggerGetProperties the properties of an Azure Cosmos DB trigger
type SQLTriggerGetProperties struct {
	Resource *SQLTriggerGetPropertiesResource `json:"resource,omitempty"`
}

// SQLTriggerGetPropertiesResource ...
type SQLTriggerGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`
	// Body - Body of the Trigger
	Body *string `json:"body,omitempty"`
	// TriggerType - Type of the Trigger. Possible values include: 'Pre', 'Post'
	TriggerType TriggerType `json:"triggerType,omitempty"`
	// TriggerOperation - The operation the trigger is associated with. Possible values include: 'All', 'Create', 'Update', 'Delete', 'Replace'
	TriggerOperation TriggerOperation `json:"triggerOperation,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLTriggerGetPropertiesResource.
func (stgp SQLTriggerGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stgp.ID != nil {
		objectMap["id"] = stgp.ID
	}
	if stgp.Body != nil {
		objectMap["body"] = stgp.Body
	}
	if stgp.TriggerType != "" {
		objectMap["triggerType"] = stgp.TriggerType
	}
	if stgp.TriggerOperation != "" {
		objectMap["triggerOperation"] = stgp.TriggerOperation
	}
	return json.Marshal(objectMap)
}

// SQLTriggerGetResults an Azure Cosmos DB trigger.
type SQLTriggerGetResults struct {
	autorest.Response `json:"-"`
	// SQLTriggerGetProperties - The properties of an Azure Cosmos DB trigger
	*SQLTriggerGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLTriggerGetResults.
func (stgr SQLTriggerGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if stgr.SQLTriggerGetProperties != nil {
		objectMap["properties"] = stgr.SQLTriggerGetProperties
	}
	if stgr.Location != nil {
		objectMap["location"] = stgr.Location
	}
	if stgr.Tags != nil {
		objectMap["tags"] = stgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLTriggerGetResults struct.
func (stgr *SQLTriggerGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLTriggerGetProperties SQLTriggerGetProperties
				err = json.Unmarshal(*v, &SQLTriggerGetProperties)
				if err != nil {
					return err
				}
				stgr.SQLTriggerGetProperties = &SQLTriggerGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				stgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				stgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				stgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				stgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				stgr.Tags = tags
			}
		}
	}

	return nil
}

// SQLTriggerListResult the List operation response, that contains the triggers and their properties.
type SQLTriggerListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of triggers and their properties.
	Value *[]SQLTriggerGetResults `json:"value,omitempty"`
}

// SQLTriggerResource cosmos DB SQL trigger resource object
type SQLTriggerResource struct {
	// ID - Name of the Cosmos DB SQL trigger
	ID *string `json:"id,omitempty"`
	// Body - Body of the Trigger
	Body *string `json:"body,omitempty"`
	// TriggerType - Type of the Trigger. Possible values include: 'Pre', 'Post'
	TriggerType TriggerType `json:"triggerType,omitempty"`
	// TriggerOperation - The operation the trigger is associated with. Possible values include: 'All', 'Create', 'Update', 'Delete', 'Replace'
	TriggerOperation TriggerOperation `json:"triggerOperation,omitempty"`
}

// SQLUserDefinedFunctionCreateUpdateParameters parameters to create and update Cosmos DB
// userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateParameters struct {
	// SQLUserDefinedFunctionCreateUpdateProperties - Properties to create and update Azure Cosmos DB userDefinedFunction.
	*SQLUserDefinedFunctionCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionCreateUpdateParameters.
func (sudfcup SQLUserDefinedFunctionCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfcup.SQLUserDefinedFunctionCreateUpdateProperties != nil {
		objectMap["properties"] = sudfcup.SQLUserDefinedFunctionCreateUpdateProperties
	}
	if sudfcup.Location != nil {
		objectMap["location"] = sudfcup.Location
	}
	if sudfcup.Tags != nil {
		objectMap["tags"] = sudfcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLUserDefinedFunctionCreateUpdateParameters struct.
func (sudfcup *SQLUserDefinedFunctionCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLUserDefinedFunctionCreateUpdateProperties SQLUserDefinedFunctionCreateUpdateProperties
				err = json.Unmarshal(*v, &SQLUserDefinedFunctionCreateUpdateProperties)
				if err != nil {
					return err
				}
				sudfcup.SQLUserDefinedFunctionCreateUpdateProperties = &SQLUserDefinedFunctionCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sudfcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sudfcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sudfcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sudfcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sudfcup.Tags = tags
			}
		}
	}

	return nil
}

// SQLUserDefinedFunctionCreateUpdateProperties properties to create and update Azure Cosmos DB
// userDefinedFunction.
type SQLUserDefinedFunctionCreateUpdateProperties struct {
	// Resource - The standard JSON format of a userDefinedFunction
	Resource *SQLUserDefinedFunctionResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionCreateUpdateProperties.
func (sudfcup SQLUserDefinedFunctionCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfcup.Resource != nil {
		objectMap["resource"] = sudfcup.Resource
	}
	if sudfcup.Options != nil {
		objectMap["options"] = sudfcup.Options
	}
	return json.Marshal(objectMap)
}

// SQLUserDefinedFunctionGetProperties the properties of an Azure Cosmos DB userDefinedFunction
type SQLUserDefinedFunctionGetProperties struct {
	Resource *SQLUserDefinedFunctionGetPropertiesResource `json:"resource,omitempty"`
}

// SQLUserDefinedFunctionGetPropertiesResource ...
type SQLUserDefinedFunctionGetPropertiesResource struct {
	// ID - Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`
	// Body - Body of the User Defined Function
	Body *string `json:"body,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionGetPropertiesResource.
func (sudfgp SQLUserDefinedFunctionGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfgp.ID != nil {
		objectMap["id"] = sudfgp.ID
	}
	if sudfgp.Body != nil {
		objectMap["body"] = sudfgp.Body
	}
	return json.Marshal(objectMap)
}

// SQLUserDefinedFunctionGetResults an Azure Cosmos DB userDefinedFunction.
type SQLUserDefinedFunctionGetResults struct {
	autorest.Response `json:"-"`
	// SQLUserDefinedFunctionGetProperties - The properties of an Azure Cosmos DB userDefinedFunction
	*SQLUserDefinedFunctionGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for SQLUserDefinedFunctionGetResults.
func (sudfgr SQLUserDefinedFunctionGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sudfgr.SQLUserDefinedFunctionGetProperties != nil {
		objectMap["properties"] = sudfgr.SQLUserDefinedFunctionGetProperties
	}
	if sudfgr.Location != nil {
		objectMap["location"] = sudfgr.Location
	}
	if sudfgr.Tags != nil {
		objectMap["tags"] = sudfgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for SQLUserDefinedFunctionGetResults struct.
func (sudfgr *SQLUserDefinedFunctionGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var SQLUserDefinedFunctionGetProperties SQLUserDefinedFunctionGetProperties
				err = json.Unmarshal(*v, &SQLUserDefinedFunctionGetProperties)
				if err != nil {
					return err
				}
				sudfgr.SQLUserDefinedFunctionGetProperties = &SQLUserDefinedFunctionGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sudfgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sudfgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sudfgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				sudfgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				sudfgr.Tags = tags
			}
		}
	}

	return nil
}

// SQLUserDefinedFunctionListResult the List operation response, that contains the userDefinedFunctions and
// their properties.
type SQLUserDefinedFunctionListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of userDefinedFunctions and their properties.
	Value *[]SQLUserDefinedFunctionGetResults `json:"value,omitempty"`
}

// SQLUserDefinedFunctionResource cosmos DB SQL userDefinedFunction resource object
type SQLUserDefinedFunctionResource struct {
	// ID - Name of the Cosmos DB SQL userDefinedFunction
	ID *string `json:"id,omitempty"`
	// Body - Body of the User Defined Function
	Body *string `json:"body,omitempty"`
}

// TableCreateUpdateParameters parameters to create and update Cosmos DB Table.
type TableCreateUpdateParameters struct {
	// TableCreateUpdateProperties - Properties to create and update Azure Cosmos DB Table.
	*TableCreateUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TableCreateUpdateParameters.
func (tcup TableCreateUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.TableCreateUpdateProperties != nil {
		objectMap["properties"] = tcup.TableCreateUpdateProperties
	}
	if tcup.Location != nil {
		objectMap["location"] = tcup.Location
	}
	if tcup.Tags != nil {
		objectMap["tags"] = tcup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableCreateUpdateParameters struct.
func (tcup *TableCreateUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableCreateUpdateProperties TableCreateUpdateProperties
				err = json.Unmarshal(*v, &tableCreateUpdateProperties)
				if err != nil {
					return err
				}
				tcup.TableCreateUpdateProperties = &tableCreateUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tcup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tcup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tcup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tcup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tcup.Tags = tags
			}
		}
	}

	return nil
}

// TableCreateUpdateProperties properties to create and update Azure Cosmos DB Table.
type TableCreateUpdateProperties struct {
	// Resource - The standard JSON format of a Table
	Resource *TableResource `json:"resource,omitempty"`
	// Options - A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
	Options map[string]*string `json:"options"`
}

// MarshalJSON is the custom marshaler for TableCreateUpdateProperties.
func (tcup TableCreateUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tcup.Resource != nil {
		objectMap["resource"] = tcup.Resource
	}
	if tcup.Options != nil {
		objectMap["options"] = tcup.Options
	}
	return json.Marshal(objectMap)
}

// TableGetProperties the properties of an Azure Cosmos Table
type TableGetProperties struct {
	Resource *TableGetPropertiesResource `json:"resource,omitempty"`
}

// TableGetPropertiesResource ...
type TableGetPropertiesResource struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for TableGetPropertiesResource.
func (tgp TableGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tgp.ID != nil {
		objectMap["id"] = tgp.ID
	}
	return json.Marshal(objectMap)
}

// TableGetResults an Azure Cosmos DB Table.
type TableGetResults struct {
	autorest.Response `json:"-"`
	// TableGetProperties - The properties of an Azure Cosmos DB Table
	*TableGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TableGetResults.
func (tgr TableGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tgr.TableGetProperties != nil {
		objectMap["properties"] = tgr.TableGetProperties
	}
	if tgr.Location != nil {
		objectMap["location"] = tgr.Location
	}
	if tgr.Tags != nil {
		objectMap["tags"] = tgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TableGetResults struct.
func (tgr *TableGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tableGetProperties TableGetProperties
				err = json.Unmarshal(*v, &tableGetProperties)
				if err != nil {
					return err
				}
				tgr.TableGetProperties = &tableGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tgr.Tags = tags
			}
		}
	}

	return nil
}

// TableListResult the List operation response, that contains the Table and their properties.
type TableListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Table and their properties.
	Value *[]TableGetResults `json:"value,omitempty"`
}

// TableResource cosmos DB table resource object
type TableResource struct {
	// ID - Name of the Cosmos DB table
	ID *string `json:"id,omitempty"`
}

// TableResourcesCreateUpdateTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesCreateUpdateTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (TableGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesCreateUpdateTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesCreateUpdateTableFuture.Result.
func (future *TableResourcesCreateUpdateTableFuture) result(client TableResourcesClient) (tgr TableGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesCreateUpdateTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesCreateUpdateTableFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tgr.Response.Response, err = future.GetResult(sender); err == nil && tgr.Response.Response.StatusCode != http.StatusNoContent {
		tgr, err = client.CreateUpdateTableResponder(tgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.TableResourcesCreateUpdateTableFuture", "Result", tgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TableResourcesDeleteTableFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesDeleteTableFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesDeleteTableFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesDeleteTableFuture.Result.
func (future *TableResourcesDeleteTableFuture) result(client TableResourcesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesDeleteTableFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesDeleteTableFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TableResourcesUpdateTableThroughputFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type TableResourcesUpdateTableThroughputFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TableResourcesClient) (ThroughputSettingsGetResults, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TableResourcesUpdateTableThroughputFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TableResourcesUpdateTableThroughputFuture.Result.
func (future *TableResourcesUpdateTableThroughputFuture) result(client TableResourcesClient) (tsgr ThroughputSettingsGetResults, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "documentdb.TableResourcesUpdateTableThroughputFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("documentdb.TableResourcesUpdateTableThroughputFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tsgr.Response.Response, err = future.GetResult(sender); err == nil && tsgr.Response.Response.StatusCode != http.StatusNoContent {
		tsgr, err = client.UpdateTableThroughputResponder(tsgr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "documentdb.TableResourcesUpdateTableThroughputFuture", "Result", tsgr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ThroughputSettingsGetProperties the properties of an Azure Cosmos DB resource throughput
type ThroughputSettingsGetProperties struct {
	Resource *ThroughputSettingsGetPropertiesResource `json:"resource,omitempty"`
}

// ThroughputSettingsGetPropertiesResource ...
type ThroughputSettingsGetPropertiesResource struct {
	// Throughput - Value of the Cosmos DB resource throughput
	Throughput *int32 `json:"throughput,omitempty"`
	// MinimumThroughput - READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty"`
	// OfferReplacePending - READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty"`
	// Rid - READ-ONLY; A system generated property. A unique identifier.
	Rid *string `json:"_rid,omitempty"`
	// Ts - READ-ONLY; A system generated property that denotes the last updated timestamp of the resource.
	Ts interface{} `json:"_ts,omitempty"`
	// Etag - READ-ONLY; A system generated property representing the resource etag required for optimistic concurrency control.
	Etag *string `json:"_etag,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsGetPropertiesResource.
func (tsgp ThroughputSettingsGetPropertiesResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsgp.Throughput != nil {
		objectMap["throughput"] = tsgp.Throughput
	}
	return json.Marshal(objectMap)
}

// ThroughputSettingsGetResults an Azure Cosmos DB resource throughput.
type ThroughputSettingsGetResults struct {
	autorest.Response `json:"-"`
	// ThroughputSettingsGetProperties - The properties of an Azure Cosmos DB resource throughput
	*ThroughputSettingsGetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsGetResults.
func (tsgr ThroughputSettingsGetResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsgr.ThroughputSettingsGetProperties != nil {
		objectMap["properties"] = tsgr.ThroughputSettingsGetProperties
	}
	if tsgr.Location != nil {
		objectMap["location"] = tsgr.Location
	}
	if tsgr.Tags != nil {
		objectMap["tags"] = tsgr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThroughputSettingsGetResults struct.
func (tsgr *ThroughputSettingsGetResults) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputSettingsGetProperties ThroughputSettingsGetProperties
				err = json.Unmarshal(*v, &throughputSettingsGetProperties)
				if err != nil {
					return err
				}
				tsgr.ThroughputSettingsGetProperties = &throughputSettingsGetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsgr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsgr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsgr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tsgr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tsgr.Tags = tags
			}
		}
	}

	return nil
}

// ThroughputSettingsResource cosmos DB resource throughput object
type ThroughputSettingsResource struct {
	// Throughput - Value of the Cosmos DB resource throughput
	Throughput *int32 `json:"throughput,omitempty"`
	// MinimumThroughput - READ-ONLY; The minimum throughput of the resource
	MinimumThroughput *string `json:"minimumThroughput,omitempty"`
	// OfferReplacePending - READ-ONLY; The throughput replace is pending
	OfferReplacePending *string `json:"offerReplacePending,omitempty"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsResource.
func (tsr ThroughputSettingsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsr.Throughput != nil {
		objectMap["throughput"] = tsr.Throughput
	}
	return json.Marshal(objectMap)
}

// ThroughputSettingsUpdateParameters parameters to update Cosmos DB resource throughput.
type ThroughputSettingsUpdateParameters struct {
	// ThroughputSettingsUpdateProperties - Properties to update Azure Cosmos DB resource throughput.
	*ThroughputSettingsUpdateProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The unique resource identifier of the ARM resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the ARM resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of Azure resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource group to which the resource belongs.
	Location *string            `json:"location,omitempty"`
	Tags     map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ThroughputSettingsUpdateParameters.
func (tsup ThroughputSettingsUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tsup.ThroughputSettingsUpdateProperties != nil {
		objectMap["properties"] = tsup.ThroughputSettingsUpdateProperties
	}
	if tsup.Location != nil {
		objectMap["location"] = tsup.Location
	}
	if tsup.Tags != nil {
		objectMap["tags"] = tsup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ThroughputSettingsUpdateParameters struct.
func (tsup *ThroughputSettingsUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var throughputSettingsUpdateProperties ThroughputSettingsUpdateProperties
				err = json.Unmarshal(*v, &throughputSettingsUpdateProperties)
				if err != nil {
					return err
				}
				tsup.ThroughputSettingsUpdateProperties = &throughputSettingsUpdateProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tsup.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tsup.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tsup.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tsup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tsup.Tags = tags
			}
		}
	}

	return nil
}

// ThroughputSettingsUpdateProperties properties to update Azure Cosmos DB resource throughput.
type ThroughputSettingsUpdateProperties struct {
	// Resource - The standard JSON format of a resource throughput
	Resource *ThroughputSettingsResource `json:"resource,omitempty"`
}

// UniqueKey the unique key on that enforces uniqueness constraint on documents in the collection in the
// Azure Cosmos DB service.
type UniqueKey struct {
	// Paths - List of paths must be unique for each document in the Azure Cosmos DB service
	Paths *[]string `json:"paths,omitempty"`
}

// UniqueKeyPolicy the unique key policy configuration for specifying uniqueness constraints on documents
// in the collection in the Azure Cosmos DB service.
type UniqueKeyPolicy struct {
	// UniqueKeys - List of unique keys on that enforces uniqueness constraint on documents in the collection in the Azure Cosmos DB service.
	UniqueKeys *[]UniqueKey `json:"uniqueKeys,omitempty"`
}

// Usage the usage data for a usage request.
type Usage struct {
	// Unit - The unit of the metric. Possible values include: 'Count', 'Bytes', 'Seconds', 'Percent', 'CountPerSecond', 'BytesPerSecond', 'Milliseconds'
	Unit UnitType `json:"unit,omitempty"`
	// Name - READ-ONLY; The name information for the metric.
	Name *MetricName `json:"name,omitempty"`
	// QuotaPeriod - READ-ONLY; The quota period used to summarize the usage values.
	QuotaPeriod *string `json:"quotaPeriod,omitempty"`
	// Limit - READ-ONLY; Maximum value for this metric
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - READ-ONLY; Current value for this metric
	CurrentValue *int64 `json:"currentValue,omitempty"`
}

// MarshalJSON is the custom marshaler for Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if u.Unit != "" {
		objectMap["unit"] = u.Unit
	}
	return json.Marshal(objectMap)
}

// UsagesResult the response to a list usage request.
type UsagesResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of usages for the database. A usage is a point in time metric
	Value *[]Usage `json:"value,omitempty"`
}

// VirtualNetworkRule virtual Network ACL Rule object
type VirtualNetworkRule struct {
	// ID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}.
	ID *string `json:"id,omitempty"`
	// IgnoreMissingVNetServiceEndpoint - Create firewall rule before the virtual network has vnet service endpoint enabled.
	IgnoreMissingVNetServiceEndpoint *bool `json:"ignoreMissingVNetServiceEndpoint,omitempty"`
}
