package media

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/mediaservices/mgmt/2020-05-01/media"

// AacAudio describes Advanced Audio Codec (AAC) audio encoding settings.
type AacAudio struct {
	// Profile - The encoding profile to be used when encoding audio with AAC. Possible values include: 'AacLc', 'HeAacV1', 'HeAacV2'
	Profile AacAudioProfile `json:"profile,omitempty"`
	// Channels - The number of channels in the audio.
	Channels *int32 `json:"channels,omitempty"`
	// SamplingRate - The sampling rate to use for encoding in hertz.
	SamplingRate *int32 `json:"samplingRate,omitempty"`
	// Bitrate - The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for AacAudio.
func (aa AacAudio) MarshalJSON() ([]byte, error) {
	aa.OdataType = OdataTypeMicrosoftMediaAacAudio
	objectMap := make(map[string]interface{})
	if aa.Profile != "" {
		objectMap["profile"] = aa.Profile
	}
	if aa.Channels != nil {
		objectMap["channels"] = aa.Channels
	}
	if aa.SamplingRate != nil {
		objectMap["samplingRate"] = aa.SamplingRate
	}
	if aa.Bitrate != nil {
		objectMap["bitrate"] = aa.Bitrate
	}
	if aa.Label != nil {
		objectMap["label"] = aa.Label
	}
	if aa.OdataType != "" {
		objectMap["@odata.type"] = aa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsBasicAudio() (BasicAudio, bool) {
	return &aa, true
}

// AsAacAudio is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsAacAudio() (*AacAudio, bool) {
	return &aa, true
}

// AsVideo is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsBasicVideo() (BasicVideo, bool) {
	return nil, false
}

// AsH265Video is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for AacAudio.
func (aa AacAudio) AsBasicCodec() (BasicCodec, bool) {
	return &aa, true
}

// AbsoluteClipTime specifies the clip time as an absolute time position in the media file.  The absolute
// time can point to a different position depending on whether the media file starts from a timestamp of
// zero or not.
type AbsoluteClipTime struct {
	// Time - The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S for 30 seconds.
	Time *string `json:"time,omitempty"`
	// OdataType - Possible values include: 'OdataTypeClipTime', 'OdataTypeMicrosoftMediaAbsoluteClipTime', 'OdataTypeMicrosoftMediaUtcClipTime'
	OdataType OdataTypeBasicClipTime `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for AbsoluteClipTime.
func (act AbsoluteClipTime) MarshalJSON() ([]byte, error) {
	act.OdataType = OdataTypeMicrosoftMediaAbsoluteClipTime
	objectMap := make(map[string]interface{})
	if act.Time != nil {
		objectMap["time"] = act.Time
	}
	if act.OdataType != "" {
		objectMap["@odata.type"] = act.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAbsoluteClipTime is the BasicClipTime implementation for AbsoluteClipTime.
func (act AbsoluteClipTime) AsAbsoluteClipTime() (*AbsoluteClipTime, bool) {
	return &act, true
}

// AsUtcClipTime is the BasicClipTime implementation for AbsoluteClipTime.
func (act AbsoluteClipTime) AsUtcClipTime() (*UtcClipTime, bool) {
	return nil, false
}

// AsClipTime is the BasicClipTime implementation for AbsoluteClipTime.
func (act AbsoluteClipTime) AsClipTime() (*ClipTime, bool) {
	return nil, false
}

// AsBasicClipTime is the BasicClipTime implementation for AbsoluteClipTime.
func (act AbsoluteClipTime) AsBasicClipTime() (BasicClipTime, bool) {
	return &act, true
}

// AccountEncryption ...
type AccountEncryption struct {
	// Type - The type of key used to encrypt the Account Key. Possible values include: 'SystemKey', 'CustomerKey'
	Type AccountEncryptionKeyType `json:"type,omitempty"`
	// KeyVaultProperties - The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// AccountFilter an Account Filter.
type AccountFilter struct {
	autorest.Response `json:"-"`
	*FilterProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AccountFilter.
func (af AccountFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if af.FilterProperties != nil {
		objectMap["properties"] = af.FilterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AccountFilter struct.
func (af *AccountFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var filterProperties FilterProperties
				err = json.Unmarshal(*v, &filterProperties)
				if err != nil {
					return err
				}
				af.FilterProperties = &filterProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				af.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				af.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				af.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = &typeVar
			}
		}
	}

	return nil
}

// AccountFilterCollection a collection of AccountFilter items.
type AccountFilterCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of AccountFilter items.
	Value *[]AccountFilter `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// AccountFilterCollectionIterator provides access to a complete listing of AccountFilter values.
type AccountFilterCollectionIterator struct {
	i    int
	page AccountFilterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AccountFilterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountFilterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AccountFilterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AccountFilterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AccountFilterCollectionIterator) Response() AccountFilterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AccountFilterCollectionIterator) Value() AccountFilter {
	if !iter.page.NotDone() {
		return AccountFilter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AccountFilterCollectionIterator type.
func NewAccountFilterCollectionIterator(page AccountFilterCollectionPage) AccountFilterCollectionIterator {
	return AccountFilterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (afc AccountFilterCollection) IsEmpty() bool {
	return afc.Value == nil || len(*afc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (afc AccountFilterCollection) hasNextLink() bool {
	return afc.OdataNextLink != nil && len(*afc.OdataNextLink) != 0
}

// accountFilterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (afc AccountFilterCollection) accountFilterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !afc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(afc.OdataNextLink)))
}

// AccountFilterCollectionPage contains a page of AccountFilter values.
type AccountFilterCollectionPage struct {
	fn  func(context.Context, AccountFilterCollection) (AccountFilterCollection, error)
	afc AccountFilterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AccountFilterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AccountFilterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.afc)
		if err != nil {
			return err
		}
		page.afc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AccountFilterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AccountFilterCollectionPage) NotDone() bool {
	return !page.afc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AccountFilterCollectionPage) Response() AccountFilterCollection {
	return page.afc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AccountFilterCollectionPage) Values() []AccountFilter {
	if page.afc.IsEmpty() {
		return nil
	}
	return *page.afc.Value
}

// Creates a new instance of the AccountFilterCollectionPage type.
func NewAccountFilterCollectionPage(cur AccountFilterCollection, getNextPage func(context.Context, AccountFilterCollection) (AccountFilterCollection, error)) AccountFilterCollectionPage {
	return AccountFilterCollectionPage{
		fn:  getNextPage,
		afc: cur,
	}
}

// AkamaiAccessControl akamai access control
type AkamaiAccessControl struct {
	// AkamaiSignatureHeaderAuthenticationKeyList - authentication key list
	AkamaiSignatureHeaderAuthenticationKeyList *[]AkamaiSignatureHeaderAuthenticationKey `json:"akamaiSignatureHeaderAuthenticationKeyList,omitempty"`
}

// AkamaiSignatureHeaderAuthenticationKey akamai Signature Header authentication key.
type AkamaiSignatureHeaderAuthenticationKey struct {
	// Identifier - identifier of the key
	Identifier *string `json:"identifier,omitempty"`
	// Base64Key - authentication key
	Base64Key *string `json:"base64Key,omitempty"`
	// Expiration - The expiration time of the authentication key.
	Expiration *date.Time `json:"expiration,omitempty"`
}

// APIError the API error.
type APIError struct {
	// Error - The error properties.
	Error *ODataError `json:"error,omitempty"`
}

// Asset an Asset.
type Asset struct {
	autorest.Response `json:"-"`
	// AssetProperties - The resource properties.
	*AssetProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Asset.
func (a Asset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.AssetProperties != nil {
		objectMap["properties"] = a.AssetProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Asset struct.
func (a *Asset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var assetProperties AssetProperties
				err = json.Unmarshal(*v, &assetProperties)
				if err != nil {
					return err
				}
				a.AssetProperties = &assetProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				a.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		}
	}

	return nil
}

// AssetCollection a collection of Asset items.
type AssetCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Asset items.
	Value *[]Asset `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// AssetCollectionIterator provides access to a complete listing of Asset values.
type AssetCollectionIterator struct {
	i    int
	page AssetCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssetCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssetCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssetCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssetCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssetCollectionIterator) Response() AssetCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssetCollectionIterator) Value() Asset {
	if !iter.page.NotDone() {
		return Asset{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssetCollectionIterator type.
func NewAssetCollectionIterator(page AssetCollectionPage) AssetCollectionIterator {
	return AssetCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ac AssetCollection) IsEmpty() bool {
	return ac.Value == nil || len(*ac.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ac AssetCollection) hasNextLink() bool {
	return ac.OdataNextLink != nil && len(*ac.OdataNextLink) != 0
}

// assetCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ac AssetCollection) assetCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ac.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ac.OdataNextLink)))
}

// AssetCollectionPage contains a page of Asset values.
type AssetCollectionPage struct {
	fn func(context.Context, AssetCollection) (AssetCollection, error)
	ac AssetCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssetCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssetCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ac)
		if err != nil {
			return err
		}
		page.ac = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssetCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssetCollectionPage) NotDone() bool {
	return !page.ac.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssetCollectionPage) Response() AssetCollection {
	return page.ac
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssetCollectionPage) Values() []Asset {
	if page.ac.IsEmpty() {
		return nil
	}
	return *page.ac.Value
}

// Creates a new instance of the AssetCollectionPage type.
func NewAssetCollectionPage(cur AssetCollection, getNextPage func(context.Context, AssetCollection) (AssetCollection, error)) AssetCollectionPage {
	return AssetCollectionPage{
		fn: getNextPage,
		ac: cur,
	}
}

// AssetContainerSas the Asset Storage container SAS URLs.
type AssetContainerSas struct {
	autorest.Response `json:"-"`
	// AssetContainerSasUrls - The list of Asset container SAS URLs.
	AssetContainerSasUrls *[]string `json:"assetContainerSasUrls,omitempty"`
}

// AssetFileEncryptionMetadata the Asset File Storage encryption metadata.
type AssetFileEncryptionMetadata struct {
	// InitializationVector - The Asset File initialization vector.
	InitializationVector *string `json:"initializationVector,omitempty"`
	// AssetFileName - The Asset File name.
	AssetFileName *string `json:"assetFileName,omitempty"`
	// AssetFileID - The Asset File Id.
	AssetFileID *uuid.UUID `json:"assetFileId,omitempty"`
}

// AssetFilter an Asset Filter.
type AssetFilter struct {
	autorest.Response `json:"-"`
	*FilterProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AssetFilter.
func (af AssetFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if af.FilterProperties != nil {
		objectMap["properties"] = af.FilterProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AssetFilter struct.
func (af *AssetFilter) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var filterProperties FilterProperties
				err = json.Unmarshal(*v, &filterProperties)
				if err != nil {
					return err
				}
				af.FilterProperties = &filterProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				af.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				af.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				af.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				af.Type = &typeVar
			}
		}
	}

	return nil
}

// AssetFilterCollection a collection of AssetFilter items.
type AssetFilterCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of AssetFilter items.
	Value *[]AssetFilter `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// AssetFilterCollectionIterator provides access to a complete listing of AssetFilter values.
type AssetFilterCollectionIterator struct {
	i    int
	page AssetFilterCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AssetFilterCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssetFilterCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AssetFilterCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AssetFilterCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AssetFilterCollectionIterator) Response() AssetFilterCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AssetFilterCollectionIterator) Value() AssetFilter {
	if !iter.page.NotDone() {
		return AssetFilter{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AssetFilterCollectionIterator type.
func NewAssetFilterCollectionIterator(page AssetFilterCollectionPage) AssetFilterCollectionIterator {
	return AssetFilterCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (afc AssetFilterCollection) IsEmpty() bool {
	return afc.Value == nil || len(*afc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (afc AssetFilterCollection) hasNextLink() bool {
	return afc.OdataNextLink != nil && len(*afc.OdataNextLink) != 0
}

// assetFilterCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (afc AssetFilterCollection) assetFilterCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !afc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(afc.OdataNextLink)))
}

// AssetFilterCollectionPage contains a page of AssetFilter values.
type AssetFilterCollectionPage struct {
	fn  func(context.Context, AssetFilterCollection) (AssetFilterCollection, error)
	afc AssetFilterCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AssetFilterCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AssetFilterCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.afc)
		if err != nil {
			return err
		}
		page.afc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AssetFilterCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AssetFilterCollectionPage) NotDone() bool {
	return !page.afc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AssetFilterCollectionPage) Response() AssetFilterCollection {
	return page.afc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AssetFilterCollectionPage) Values() []AssetFilter {
	if page.afc.IsEmpty() {
		return nil
	}
	return *page.afc.Value
}

// Creates a new instance of the AssetFilterCollectionPage type.
func NewAssetFilterCollectionPage(cur AssetFilterCollection, getNextPage func(context.Context, AssetFilterCollection) (AssetFilterCollection, error)) AssetFilterCollectionPage {
	return AssetFilterCollectionPage{
		fn:  getNextPage,
		afc: cur,
	}
}

// AssetProperties the Asset properties.
type AssetProperties struct {
	// AssetID - READ-ONLY; The Asset ID.
	AssetID *uuid.UUID `json:"assetId,omitempty"`
	// Created - READ-ONLY; The creation date of the Asset.
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The last modified date of the Asset.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// AlternateID - The alternate ID of the Asset.
	AlternateID *string `json:"alternateId,omitempty"`
	// Description - The Asset description.
	Description *string `json:"description,omitempty"`
	// Container - The name of the asset blob container.
	Container *string `json:"container,omitempty"`
	// StorageAccountName - The name of the storage account.
	StorageAccountName *string `json:"storageAccountName,omitempty"`
	// StorageEncryptionFormat - READ-ONLY; The Asset encryption format. One of None or MediaStorageEncryption. Possible values include: 'None', 'MediaStorageClientEncryption'
	StorageEncryptionFormat AssetStorageEncryptionFormat `json:"storageEncryptionFormat,omitempty"`
}

// MarshalJSON is the custom marshaler for AssetProperties.
func (ap AssetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AlternateID != nil {
		objectMap["alternateId"] = ap.AlternateID
	}
	if ap.Description != nil {
		objectMap["description"] = ap.Description
	}
	if ap.Container != nil {
		objectMap["container"] = ap.Container
	}
	if ap.StorageAccountName != nil {
		objectMap["storageAccountName"] = ap.StorageAccountName
	}
	return json.Marshal(objectMap)
}

// AssetStreamingLocator properties of the Streaming Locator.
type AssetStreamingLocator struct {
	// Name - READ-ONLY; Streaming Locator name.
	Name *string `json:"name,omitempty"`
	// AssetName - READ-ONLY; Asset Name.
	AssetName *string `json:"assetName,omitempty"`
	// Created - READ-ONLY; The creation time of the Streaming Locator.
	Created *date.Time `json:"created,omitempty"`
	// StartTime - READ-ONLY; The start time of the Streaming Locator.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The end time of the Streaming Locator.
	EndTime *date.Time `json:"endTime,omitempty"`
	// StreamingLocatorID - READ-ONLY; StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *uuid.UUID `json:"streamingLocatorId,omitempty"`
	// StreamingPolicyName - READ-ONLY; Name of the Streaming Policy used by this Streaming Locator.
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty"`
	// DefaultContentKeyPolicyName - READ-ONLY; Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty"`
}

// BasicAudio defines the common properties for all audio codecs.
type BasicAudio interface {
	AsAacAudio() (*AacAudio, bool)
	AsAudio() (*Audio, bool)
}

// Audio defines the common properties for all audio codecs.
type Audio struct {
	// Channels - The number of channels in the audio.
	Channels *int32 `json:"channels,omitempty"`
	// SamplingRate - The sampling rate to use for encoding in hertz.
	SamplingRate *int32 `json:"samplingRate,omitempty"`
	// Bitrate - The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

func unmarshalBasicAudio(body []byte) (BasicAudio, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaAacAudio):
		var aa AacAudio
		err := json.Unmarshal(body, &aa)
		return aa, err
	default:
		var a Audio
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicAudioArray(body []byte) ([]BasicAudio, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAudio, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAudio(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Audio.
func (a Audio) MarshalJSON() ([]byte, error) {
	a.OdataType = OdataTypeMicrosoftMediaAudio
	objectMap := make(map[string]interface{})
	if a.Channels != nil {
		objectMap["channels"] = a.Channels
	}
	if a.SamplingRate != nil {
		objectMap["samplingRate"] = a.SamplingRate
	}
	if a.Bitrate != nil {
		objectMap["bitrate"] = a.Bitrate
	}
	if a.Label != nil {
		objectMap["label"] = a.Label
	}
	if a.OdataType != "" {
		objectMap["@odata.type"] = a.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for Audio.
func (a Audio) AsAudio() (*Audio, bool) {
	return &a, true
}

// AsBasicAudio is the BasicCodec implementation for Audio.
func (a Audio) AsBasicAudio() (BasicAudio, bool) {
	return &a, true
}

// AsAacAudio is the BasicCodec implementation for Audio.
func (a Audio) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for Audio.
func (a Audio) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for Audio.
func (a Audio) AsBasicVideo() (BasicVideo, bool) {
	return nil, false
}

// AsH265Video is the BasicCodec implementation for Audio.
func (a Audio) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for Audio.
func (a Audio) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for Audio.
func (a Audio) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for Audio.
func (a Audio) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for Audio.
func (a Audio) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for Audio.
func (a Audio) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for Audio.
func (a Audio) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for Audio.
func (a Audio) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for Audio.
func (a Audio) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for Audio.
func (a Audio) AsBasicCodec() (BasicCodec, bool) {
	return &a, true
}

// BasicAudioAnalyzerPreset the Audio Analyzer preset applies a pre-defined set of AI-based analysis operations,
// including speech transcription. Currently, the preset supports processing of content with a single audio track.
type BasicAudioAnalyzerPreset interface {
	AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool)
	AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool)
}

// AudioAnalyzerPreset the Audio Analyzer preset applies a pre-defined set of AI-based analysis operations,
// including speech transcription. Currently, the preset supports processing of content with a single audio
// track.
type AudioAnalyzerPreset struct {
	// AudioLanguage - The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string `json:"audioLanguage,omitempty"`
	// Mode - Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen. Possible values include: 'Standard', 'Basic'
	Mode AudioAnalysisMode `json:"mode,omitempty"`
	// ExperimentalOptions - Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions"`
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

func unmarshalBasicAudioAnalyzerPreset(body []byte) (BasicAudioAnalyzerPreset, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaVideoAnalyzerPreset):
		var vap VideoAnalyzerPreset
		err := json.Unmarshal(body, &vap)
		return vap, err
	default:
		var aap AudioAnalyzerPreset
		err := json.Unmarshal(body, &aap)
		return aap, err
	}
}
func unmarshalBasicAudioAnalyzerPresetArray(body []byte) ([]BasicAudioAnalyzerPreset, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aapArray := make([]BasicAudioAnalyzerPreset, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aap, err := unmarshalBasicAudioAnalyzerPreset(*rawMessage)
		if err != nil {
			return nil, err
		}
		aapArray[index] = aap
	}
	return aapArray, nil
}

// MarshalJSON is the custom marshaler for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) MarshalJSON() ([]byte, error) {
	aap.OdataType = OdataTypeMicrosoftMediaAudioAnalyzerPreset
	objectMap := make(map[string]interface{})
	if aap.AudioLanguage != nil {
		objectMap["audioLanguage"] = aap.AudioLanguage
	}
	if aap.Mode != "" {
		objectMap["mode"] = aap.Mode
	}
	if aap.ExperimentalOptions != nil {
		objectMap["experimentalOptions"] = aap.ExperimentalOptions
	}
	if aap.OdataType != "" {
		objectMap["@odata.type"] = aap.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return nil, false
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return &aap, true
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return &aap, true
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return nil, false
}

// AsStandardEncoderPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return nil, false
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return nil, false
}

// AsPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsPreset() (*Preset, bool) {
	return nil, false
}

// AsBasicPreset is the BasicPreset implementation for AudioAnalyzerPreset.
func (aap AudioAnalyzerPreset) AsBasicPreset() (BasicPreset, bool) {
	return &aap, true
}

// AudioOverlay describes the properties of an audio overlay.
type AudioOverlay struct {
	// InputLabel - The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
	InputLabel *string `json:"inputLabel,omitempty"`
	// Start - The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
	// End - The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`
	// FadeInDuration - The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`
	// FadeOutDuration - The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`
	// AudioGainLevel - The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`
	// OdataType - Possible values include: 'OdataTypeOverlay', 'OdataTypeMicrosoftMediaAudioOverlay', 'OdataTypeMicrosoftMediaVideoOverlay'
	OdataType OdataTypeBasicOverlay `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for AudioOverlay.
func (ao AudioOverlay) MarshalJSON() ([]byte, error) {
	ao.OdataType = OdataTypeMicrosoftMediaAudioOverlay
	objectMap := make(map[string]interface{})
	if ao.InputLabel != nil {
		objectMap["inputLabel"] = ao.InputLabel
	}
	if ao.Start != nil {
		objectMap["start"] = ao.Start
	}
	if ao.End != nil {
		objectMap["end"] = ao.End
	}
	if ao.FadeInDuration != nil {
		objectMap["fadeInDuration"] = ao.FadeInDuration
	}
	if ao.FadeOutDuration != nil {
		objectMap["fadeOutDuration"] = ao.FadeOutDuration
	}
	if ao.AudioGainLevel != nil {
		objectMap["audioGainLevel"] = ao.AudioGainLevel
	}
	if ao.OdataType != "" {
		objectMap["@odata.type"] = ao.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioOverlay is the BasicOverlay implementation for AudioOverlay.
func (ao AudioOverlay) AsAudioOverlay() (*AudioOverlay, bool) {
	return &ao, true
}

// AsVideoOverlay is the BasicOverlay implementation for AudioOverlay.
func (ao AudioOverlay) AsVideoOverlay() (*VideoOverlay, bool) {
	return nil, false
}

// AsOverlay is the BasicOverlay implementation for AudioOverlay.
func (ao AudioOverlay) AsOverlay() (*Overlay, bool) {
	return nil, false
}

// AsBasicOverlay is the BasicOverlay implementation for AudioOverlay.
func (ao AudioOverlay) AsBasicOverlay() (BasicOverlay, bool) {
	return &ao, true
}

// BasicAudioTrackDescriptor a TrackSelection to select audio tracks.
type BasicAudioTrackDescriptor interface {
	AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool)
	AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool)
	AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool)
}

// AudioTrackDescriptor a TrackSelection to select audio tracks.
type AudioTrackDescriptor struct {
	// ChannelMapping - Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks. Possible values include: 'FrontLeft', 'FrontRight', 'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft', 'StereoRight'
	ChannelMapping ChannelMapping `json:"channelMapping,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

func unmarshalBasicAudioTrackDescriptor(body []byte) (BasicAudioTrackDescriptor, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaSelectAudioTrackByAttribute):
		var satba SelectAudioTrackByAttribute
		err := json.Unmarshal(body, &satba)
		return satba, err
	case string(OdataTypeMicrosoftMediaSelectAudioTrackByID):
		var satbi SelectAudioTrackByID
		err := json.Unmarshal(body, &satbi)
		return satbi, err
	default:
		var atd AudioTrackDescriptor
		err := json.Unmarshal(body, &atd)
		return atd, err
	}
}
func unmarshalBasicAudioTrackDescriptorArray(body []byte) ([]BasicAudioTrackDescriptor, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	atdArray := make([]BasicAudioTrackDescriptor, len(rawMessages))

	for index, rawMessage := range rawMessages {
		atd, err := unmarshalBasicAudioTrackDescriptor(*rawMessage)
		if err != nil {
			return nil, err
		}
		atdArray[index] = atd
	}
	return atdArray, nil
}

// MarshalJSON is the custom marshaler for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) MarshalJSON() ([]byte, error) {
	atd.OdataType = OdataTypeMicrosoftMediaAudioTrackDescriptor
	objectMap := make(map[string]interface{})
	if atd.ChannelMapping != "" {
		objectMap["channelMapping"] = atd.ChannelMapping
	}
	if atd.OdataType != "" {
		objectMap["@odata.type"] = atd.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return &atd, true
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return &atd, true
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return nil, false
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for AudioTrackDescriptor.
func (atd AudioTrackDescriptor) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &atd, true
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// BuiltInStandardEncoderPreset describes a built-in preset for encoding the input video with the Standard
// Encoder.
type BuiltInStandardEncoderPreset struct {
	// PresetName - The built-in preset to be used for encoding videos. Possible values include: 'H264SingleBitrateSD', 'H264SingleBitrate720p', 'H264SingleBitrate1080p', 'AdaptiveStreaming', 'AACGoodQualityAudio', 'ContentAwareEncodingExperimental', 'ContentAwareEncoding', 'CopyAllBitrateNonInterleaved', 'H264MultipleBitrate1080p', 'H264MultipleBitrate720p', 'H264MultipleBitrateSD', 'H265ContentAwareEncoding', 'H265AdaptiveStreaming', 'H265SingleBitrate720p', 'H265SingleBitrate1080p', 'H265SingleBitrate4K'
	PresetName EncoderNamedPreset `json:"presetName,omitempty"`
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) MarshalJSON() ([]byte, error) {
	bisep.OdataType = OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset
	objectMap := make(map[string]interface{})
	if bisep.PresetName != "" {
		objectMap["presetName"] = bisep.PresetName
	}
	if bisep.OdataType != "" {
		objectMap["@odata.type"] = bisep.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return nil, false
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return &bisep, true
}

// AsStandardEncoderPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return nil, false
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return nil, false
}

// AsPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsPreset() (*Preset, bool) {
	return nil, false
}

// AsBasicPreset is the BasicPreset implementation for BuiltInStandardEncoderPreset.
func (bisep BuiltInStandardEncoderPreset) AsBasicPreset() (BasicPreset, bool) {
	return &bisep, true
}

// CbcsDrmConfiguration class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming
// Policy
type CbcsDrmConfiguration struct {
	// FairPlay - FairPlay configurations
	FairPlay *StreamingPolicyFairPlayConfiguration `json:"fairPlay,omitempty"`
	// PlayReady - PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration `json:"playReady,omitempty"`
	// Widevine - Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration `json:"widevine,omitempty"`
}

// CencDrmConfiguration class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming
// Policy
type CencDrmConfiguration struct {
	// PlayReady - PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration `json:"playReady,omitempty"`
	// Widevine - Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration `json:"widevine,omitempty"`
}

// CheckNameAvailabilityInput the input to the check name availability request.
type CheckNameAvailabilityInput struct {
	// Name - The account name.
	Name *string `json:"name,omitempty"`
	// Type - The account type. For a Media Services account, this should be 'MediaServices'.
	Type *string `json:"type,omitempty"`
}

// BasicClipTime base class for specifying a clip time. Use sub classes of this class to specify the time position in
// the media.
type BasicClipTime interface {
	AsAbsoluteClipTime() (*AbsoluteClipTime, bool)
	AsUtcClipTime() (*UtcClipTime, bool)
	AsClipTime() (*ClipTime, bool)
}

// ClipTime base class for specifying a clip time. Use sub classes of this class to specify the time position
// in the media.
type ClipTime struct {
	// OdataType - Possible values include: 'OdataTypeClipTime', 'OdataTypeMicrosoftMediaAbsoluteClipTime', 'OdataTypeMicrosoftMediaUtcClipTime'
	OdataType OdataTypeBasicClipTime `json:"@odata.type,omitempty"`
}

func unmarshalBasicClipTime(body []byte) (BasicClipTime, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaAbsoluteClipTime):
		var act AbsoluteClipTime
		err := json.Unmarshal(body, &act)
		return act, err
	case string(OdataTypeMicrosoftMediaUtcClipTime):
		var uct UtcClipTime
		err := json.Unmarshal(body, &uct)
		return uct, err
	default:
		var ct ClipTime
		err := json.Unmarshal(body, &ct)
		return ct, err
	}
}
func unmarshalBasicClipTimeArray(body []byte) ([]BasicClipTime, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ctArray := make([]BasicClipTime, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ct, err := unmarshalBasicClipTime(*rawMessage)
		if err != nil {
			return nil, err
		}
		ctArray[index] = ct
	}
	return ctArray, nil
}

// MarshalJSON is the custom marshaler for ClipTime.
func (ct ClipTime) MarshalJSON() ([]byte, error) {
	ct.OdataType = OdataTypeClipTime
	objectMap := make(map[string]interface{})
	if ct.OdataType != "" {
		objectMap["@odata.type"] = ct.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAbsoluteClipTime is the BasicClipTime implementation for ClipTime.
func (ct ClipTime) AsAbsoluteClipTime() (*AbsoluteClipTime, bool) {
	return nil, false
}

// AsUtcClipTime is the BasicClipTime implementation for ClipTime.
func (ct ClipTime) AsUtcClipTime() (*UtcClipTime, bool) {
	return nil, false
}

// AsClipTime is the BasicClipTime implementation for ClipTime.
func (ct ClipTime) AsClipTime() (*ClipTime, bool) {
	return &ct, true
}

// AsBasicClipTime is the BasicClipTime implementation for ClipTime.
func (ct ClipTime) AsBasicClipTime() (BasicClipTime, bool) {
	return &ct, true
}

// BasicCodec describes the basic properties of all codecs.
type BasicCodec interface {
	AsAudio() (*Audio, bool)
	AsBasicAudio() (BasicAudio, bool)
	AsAacAudio() (*AacAudio, bool)
	AsVideo() (*Video, bool)
	AsBasicVideo() (BasicVideo, bool)
	AsH265Video() (*H265Video, bool)
	AsCopyVideo() (*CopyVideo, bool)
	AsImage() (*Image, bool)
	AsBasicImage() (BasicImage, bool)
	AsCopyAudio() (*CopyAudio, bool)
	AsH264Video() (*H264Video, bool)
	AsJpgImage() (*JpgImage, bool)
	AsPngImage() (*PngImage, bool)
	AsCodec() (*Codec, bool)
}

// Codec describes the basic properties of all codecs.
type Codec struct {
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

func unmarshalBasicCodec(body []byte) (BasicCodec, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaAudio):
		var a Audio
		err := json.Unmarshal(body, &a)
		return a, err
	case string(OdataTypeMicrosoftMediaAacAudio):
		var aa AacAudio
		err := json.Unmarshal(body, &aa)
		return aa, err
	case string(OdataTypeMicrosoftMediaVideo):
		var vVar Video
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	case string(OdataTypeMicrosoftMediaH265Video):
		var hv H265Video
		err := json.Unmarshal(body, &hv)
		return hv, err
	case string(OdataTypeMicrosoftMediaCopyVideo):
		var cv CopyVideo
		err := json.Unmarshal(body, &cv)
		return cv, err
	case string(OdataTypeMicrosoftMediaImage):
		var i Image
		err := json.Unmarshal(body, &i)
		return i, err
	case string(OdataTypeMicrosoftMediaCopyAudio):
		var ca CopyAudio
		err := json.Unmarshal(body, &ca)
		return ca, err
	case string(OdataTypeMicrosoftMediaH264Video):
		var hv H264Video
		err := json.Unmarshal(body, &hv)
		return hv, err
	case string(OdataTypeMicrosoftMediaJpgImage):
		var ji JpgImage
		err := json.Unmarshal(body, &ji)
		return ji, err
	case string(OdataTypeMicrosoftMediaPngImage):
		var pi PngImage
		err := json.Unmarshal(body, &pi)
		return pi, err
	default:
		var c Codec
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicCodecArray(body []byte) ([]BasicCodec, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicCodec, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicCodec(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Codec.
func (c Codec) MarshalJSON() ([]byte, error) {
	c.OdataType = OdataTypeCodec
	objectMap := make(map[string]interface{})
	if c.Label != nil {
		objectMap["label"] = c.Label
	}
	if c.OdataType != "" {
		objectMap["@odata.type"] = c.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for Codec.
func (c Codec) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for Codec.
func (c Codec) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for Codec.
func (c Codec) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for Codec.
func (c Codec) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for Codec.
func (c Codec) AsBasicVideo() (BasicVideo, bool) {
	return nil, false
}

// AsH265Video is the BasicCodec implementation for Codec.
func (c Codec) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for Codec.
func (c Codec) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for Codec.
func (c Codec) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for Codec.
func (c Codec) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for Codec.
func (c Codec) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for Codec.
func (c Codec) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for Codec.
func (c Codec) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for Codec.
func (c Codec) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for Codec.
func (c Codec) AsCodec() (*Codec, bool) {
	return &c, true
}

// AsBasicCodec is the BasicCodec implementation for Codec.
func (c Codec) AsBasicCodec() (BasicCodec, bool) {
	return &c, true
}

// CommonEncryptionCbcs class for CommonEncryptionCbcs encryption scheme
type CommonEncryptionCbcs struct {
	// EnabledProtocols - Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
	// ClearTracks - Representing which tracks should not be encrypted
	ClearTracks *[]TrackSelection `json:"clearTracks,omitempty"`
	// ContentKeys - Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`
	// Drm - Configuration of DRMs for current encryption scheme
	Drm *CbcsDrmConfiguration `json:"drm,omitempty"`
}

// CommonEncryptionCenc class for envelope encryption scheme
type CommonEncryptionCenc struct {
	// EnabledProtocols - Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
	// ClearTracks - Representing which tracks should not be encrypted
	ClearTracks *[]TrackSelection `json:"clearTracks,omitempty"`
	// ContentKeys - Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`
	// Drm - Configuration of DRMs for CommonEncryptionCenc encryption scheme
	Drm *CencDrmConfiguration `json:"drm,omitempty"`
}

// ContentKeyPolicy a Content Key Policy resource.
type ContentKeyPolicy struct {
	autorest.Response           `json:"-"`
	*ContentKeyPolicyProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicy.
func (ckp ContentKeyPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckp.ContentKeyPolicyProperties != nil {
		objectMap["properties"] = ckp.ContentKeyPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContentKeyPolicy struct.
func (ckp *ContentKeyPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var contentKeyPolicyProperties ContentKeyPolicyProperties
				err = json.Unmarshal(*v, &contentKeyPolicyProperties)
				if err != nil {
					return err
				}
				ckp.ContentKeyPolicyProperties = &contentKeyPolicyProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ckp.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ckp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ckp.Type = &typeVar
			}
		}
	}

	return nil
}

// ContentKeyPolicyClearKeyConfiguration represents a configuration for non-DRM keys.
type ContentKeyPolicyClearKeyConfiguration struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) MarshalJSON() ([]byte, error) {
	ckpckc.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration
	objectMap := make(map[string]interface{})
	if ckpckc.OdataType != "" {
		objectMap["@odata.type"] = ckpckc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return &ckpckc, true
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyClearKeyConfiguration.
func (ckpckc ContentKeyPolicyClearKeyConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpckc, true
}

// ContentKeyPolicyCollection a collection of ContentKeyPolicy items.
type ContentKeyPolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of ContentKeyPolicy items.
	Value *[]ContentKeyPolicy `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// ContentKeyPolicyCollectionIterator provides access to a complete listing of ContentKeyPolicy values.
type ContentKeyPolicyCollectionIterator struct {
	i    int
	page ContentKeyPolicyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ContentKeyPolicyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContentKeyPolicyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ContentKeyPolicyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ContentKeyPolicyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ContentKeyPolicyCollectionIterator) Response() ContentKeyPolicyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ContentKeyPolicyCollectionIterator) Value() ContentKeyPolicy {
	if !iter.page.NotDone() {
		return ContentKeyPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ContentKeyPolicyCollectionIterator type.
func NewContentKeyPolicyCollectionIterator(page ContentKeyPolicyCollectionPage) ContentKeyPolicyCollectionIterator {
	return ContentKeyPolicyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ckpc ContentKeyPolicyCollection) IsEmpty() bool {
	return ckpc.Value == nil || len(*ckpc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ckpc ContentKeyPolicyCollection) hasNextLink() bool {
	return ckpc.OdataNextLink != nil && len(*ckpc.OdataNextLink) != 0
}

// contentKeyPolicyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ckpc ContentKeyPolicyCollection) contentKeyPolicyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !ckpc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ckpc.OdataNextLink)))
}

// ContentKeyPolicyCollectionPage contains a page of ContentKeyPolicy values.
type ContentKeyPolicyCollectionPage struct {
	fn   func(context.Context, ContentKeyPolicyCollection) (ContentKeyPolicyCollection, error)
	ckpc ContentKeyPolicyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ContentKeyPolicyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ContentKeyPolicyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ckpc)
		if err != nil {
			return err
		}
		page.ckpc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ContentKeyPolicyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ContentKeyPolicyCollectionPage) NotDone() bool {
	return !page.ckpc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ContentKeyPolicyCollectionPage) Response() ContentKeyPolicyCollection {
	return page.ckpc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ContentKeyPolicyCollectionPage) Values() []ContentKeyPolicy {
	if page.ckpc.IsEmpty() {
		return nil
	}
	return *page.ckpc.Value
}

// Creates a new instance of the ContentKeyPolicyCollectionPage type.
func NewContentKeyPolicyCollectionPage(cur ContentKeyPolicyCollection, getNextPage func(context.Context, ContentKeyPolicyCollection) (ContentKeyPolicyCollection, error)) ContentKeyPolicyCollectionPage {
	return ContentKeyPolicyCollectionPage{
		fn:   getNextPage,
		ckpc: cur,
	}
}

// BasicContentKeyPolicyConfiguration base class for Content Key Policy configuration. A derived class must be used to
// create a configuration.
type BasicContentKeyPolicyConfiguration interface {
	AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool)
	AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool)
	AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool)
	AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool)
	AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool)
	AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool)
}

// ContentKeyPolicyConfiguration base class for Content Key Policy configuration. A derived class must be used
// to create a configuration.
type ContentKeyPolicyConfiguration struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

func unmarshalBasicContentKeyPolicyConfiguration(body []byte) (BasicContentKeyPolicyConfiguration, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration):
		var ckpckc ContentKeyPolicyClearKeyConfiguration
		err := json.Unmarshal(body, &ckpckc)
		return ckpckc, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration):
		var ckpuc ContentKeyPolicyUnknownConfiguration
		err := json.Unmarshal(body, &ckpuc)
		return ckpuc, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration):
		var ckpwc ContentKeyPolicyWidevineConfiguration
		err := json.Unmarshal(body, &ckpwc)
		return ckpwc, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration):
		var ckpprc ContentKeyPolicyPlayReadyConfiguration
		err := json.Unmarshal(body, &ckpprc)
		return ckpprc, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration):
		var ckpfpc ContentKeyPolicyFairPlayConfiguration
		err := json.Unmarshal(body, &ckpfpc)
		return ckpfpc, err
	default:
		var ckpc ContentKeyPolicyConfiguration
		err := json.Unmarshal(body, &ckpc)
		return ckpc, err
	}
}
func unmarshalBasicContentKeyPolicyConfigurationArray(body []byte) ([]BasicContentKeyPolicyConfiguration, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ckpcArray := make([]BasicContentKeyPolicyConfiguration, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ckpc, err := unmarshalBasicContentKeyPolicyConfiguration(*rawMessage)
		if err != nil {
			return nil, err
		}
		ckpcArray[index] = ckpc
	}
	return ckpcArray, nil
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) MarshalJSON() ([]byte, error) {
	ckpc.OdataType = OdataTypeContentKeyPolicyConfiguration
	objectMap := make(map[string]interface{})
	if ckpc.OdataType != "" {
		objectMap["@odata.type"] = ckpc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return &ckpc, true
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyConfiguration.
func (ckpc ContentKeyPolicyConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpc, true
}

// ContentKeyPolicyFairPlayConfiguration specifies a configuration for FairPlay licenses.
type ContentKeyPolicyFairPlayConfiguration struct {
	// Ask - The key that must be used as FairPlay Application Secret key.
	Ask *[]byte `json:"ask,omitempty"`
	// FairPlayPfxPassword - The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
	FairPlayPfxPassword *string `json:"fairPlayPfxPassword,omitempty"`
	// FairPlayPfx - The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
	FairPlayPfx *string `json:"fairPlayPfx,omitempty"`
	// RentalAndLeaseKeyType - The rental and lease key type. Possible values include: 'Unknown', 'Undefined', 'DualExpiry', 'PersistentUnlimited', 'PersistentLimited'
	RentalAndLeaseKeyType ContentKeyPolicyFairPlayRentalAndLeaseKeyType `json:"rentalAndLeaseKeyType,omitempty"`
	// RentalDuration - The rental duration. Must be greater than or equal to 0.
	RentalDuration *int64 `json:"rentalDuration,omitempty"`
	// OfflineRentalConfiguration - Offline rental policy
	OfflineRentalConfiguration *ContentKeyPolicyFairPlayOfflineRentalConfiguration `json:"offlineRentalConfiguration,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) MarshalJSON() ([]byte, error) {
	ckpfpc.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration
	objectMap := make(map[string]interface{})
	if ckpfpc.Ask != nil {
		objectMap["ask"] = ckpfpc.Ask
	}
	if ckpfpc.FairPlayPfxPassword != nil {
		objectMap["fairPlayPfxPassword"] = ckpfpc.FairPlayPfxPassword
	}
	if ckpfpc.FairPlayPfx != nil {
		objectMap["fairPlayPfx"] = ckpfpc.FairPlayPfx
	}
	if ckpfpc.RentalAndLeaseKeyType != "" {
		objectMap["rentalAndLeaseKeyType"] = ckpfpc.RentalAndLeaseKeyType
	}
	if ckpfpc.RentalDuration != nil {
		objectMap["rentalDuration"] = ckpfpc.RentalDuration
	}
	if ckpfpc.OfflineRentalConfiguration != nil {
		objectMap["offlineRentalConfiguration"] = ckpfpc.OfflineRentalConfiguration
	}
	if ckpfpc.OdataType != "" {
		objectMap["@odata.type"] = ckpfpc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return &ckpfpc, true
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyFairPlayConfiguration.
func (ckpfpc ContentKeyPolicyFairPlayConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpfpc, true
}

// ContentKeyPolicyFairPlayOfflineRentalConfiguration ...
type ContentKeyPolicyFairPlayOfflineRentalConfiguration struct {
	// PlaybackDurationSeconds - Playback duration
	PlaybackDurationSeconds *int64 `json:"playbackDurationSeconds,omitempty"`
	// StorageDurationSeconds - Storage duration
	StorageDurationSeconds *int64 `json:"storageDurationSeconds,omitempty"`
}

// ContentKeyPolicyOpenRestriction represents an open restriction. License or key will be delivered on
// every request.
type ContentKeyPolicyOpenRestriction struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction'
	OdataType OdataTypeBasicContentKeyPolicyRestriction `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) MarshalJSON() ([]byte, error) {
	ckpor.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction
	objectMap := make(map[string]interface{})
	if ckpor.OdataType != "" {
		objectMap["@odata.type"] = ckpor.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyOpenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) AsContentKeyPolicyOpenRestriction() (*ContentKeyPolicyOpenRestriction, bool) {
	return &ckpor, true
}

// AsContentKeyPolicyUnknownRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) AsContentKeyPolicyUnknownRestriction() (*ContentKeyPolicyUnknownRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyTokenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) AsContentKeyPolicyTokenRestriction() (*ContentKeyPolicyTokenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) AsContentKeyPolicyRestriction() (*ContentKeyPolicyRestriction, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyOpenRestriction.
func (ckpor ContentKeyPolicyOpenRestriction) AsBasicContentKeyPolicyRestriction() (BasicContentKeyPolicyRestriction, bool) {
	return &ckpor, true
}

// ContentKeyPolicyOption represents a policy option.
type ContentKeyPolicyOption struct {
	// PolicyOptionID - READ-ONLY; The legacy Policy Option ID.
	PolicyOptionID *uuid.UUID `json:"policyOptionId,omitempty"`
	// Name - The Policy Option description.
	Name *string `json:"name,omitempty"`
	// Configuration - The key delivery configuration.
	Configuration BasicContentKeyPolicyConfiguration `json:"configuration,omitempty"`
	// Restriction - The requirements that must be met to deliver keys with this configuration
	Restriction BasicContentKeyPolicyRestriction `json:"restriction,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyOption.
func (ckpo ContentKeyPolicyOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckpo.Name != nil {
		objectMap["name"] = ckpo.Name
	}
	objectMap["configuration"] = ckpo.Configuration
	objectMap["restriction"] = ckpo.Restriction
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ContentKeyPolicyOption struct.
func (ckpo *ContentKeyPolicyOption) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "policyOptionId":
			if v != nil {
				var policyOptionID uuid.UUID
				err = json.Unmarshal(*v, &policyOptionID)
				if err != nil {
					return err
				}
				ckpo.PolicyOptionID = &policyOptionID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ckpo.Name = &name
			}
		case "configuration":
			if v != nil {
				configuration, err := unmarshalBasicContentKeyPolicyConfiguration(*v)
				if err != nil {
					return err
				}
				ckpo.Configuration = configuration
			}
		case "restriction":
			if v != nil {
				restriction, err := unmarshalBasicContentKeyPolicyRestriction(*v)
				if err != nil {
					return err
				}
				ckpo.Restriction = restriction
			}
		}
	}

	return nil
}

// ContentKeyPolicyPlayReadyConfiguration specifies a configuration for PlayReady licenses.
type ContentKeyPolicyPlayReadyConfiguration struct {
	// Licenses - The PlayReady licenses.
	Licenses *[]ContentKeyPolicyPlayReadyLicense `json:"licenses,omitempty"`
	// ResponseCustomData - The custom response data.
	ResponseCustomData *string `json:"responseCustomData,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) MarshalJSON() ([]byte, error) {
	ckpprc.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration
	objectMap := make(map[string]interface{})
	if ckpprc.Licenses != nil {
		objectMap["licenses"] = ckpprc.Licenses
	}
	if ckpprc.ResponseCustomData != nil {
		objectMap["responseCustomData"] = ckpprc.ResponseCustomData
	}
	if ckpprc.OdataType != "" {
		objectMap["@odata.type"] = ckpprc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return &ckpprc, true
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyPlayReadyConfiguration.
func (ckpprc ContentKeyPolicyPlayReadyConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpprc, true
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader specifies that the content key ID is in the
// PlayReady header.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyPlayReadyContentKeyLocation', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) MarshalJSON() ([]byte, error) {
	ckpprcekfh.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
	objectMap := make(map[string]interface{})
	if ckpprcekfh.OdataType != "" {
		objectMap["@odata.type"] = ckpprcekfh.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, bool) {
	return &ckpprcekfh, true
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) AsContentKeyPolicyPlayReadyContentKeyLocation() (*ContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) AsBasicContentKeyPolicyPlayReadyContentKeyLocation() (BasicContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return &ckpprcekfh, true
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier specifies that the content key ID is
// specified in the PlayReady configuration.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier struct {
	// KeyID - The content key ID.
	KeyID *uuid.UUID `json:"keyId,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyPlayReadyContentKeyLocation', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) MarshalJSON() ([]byte, error) {
	ckpprcekfki.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
	objectMap := make(map[string]interface{})
	if ckpprcekfki.KeyID != nil {
		objectMap["keyId"] = ckpprcekfki.KeyID
	}
	if ckpprcekfki.OdataType != "" {
		objectMap["@odata.type"] = ckpprcekfki.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier, bool) {
	return &ckpprcekfki, true
}

// AsContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) AsContentKeyPolicyPlayReadyContentKeyLocation() (*ContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) AsBasicContentKeyPolicyPlayReadyContentKeyLocation() (BasicContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return &ckpprcekfki, true
}

// BasicContentKeyPolicyPlayReadyContentKeyLocation base class for content key ID location. A derived class must be
// used to represent the location.
type BasicContentKeyPolicyPlayReadyContentKeyLocation interface {
	AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, bool)
	AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier, bool)
	AsContentKeyPolicyPlayReadyContentKeyLocation() (*ContentKeyPolicyPlayReadyContentKeyLocation, bool)
}

// ContentKeyPolicyPlayReadyContentKeyLocation base class for content key ID location. A derived class must be
// used to represent the location.
type ContentKeyPolicyPlayReadyContentKeyLocation struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyPlayReadyContentKeyLocation', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier'
	OdataType OdataType `json:"@odata.type,omitempty"`
}

func unmarshalBasicContentKeyPolicyPlayReadyContentKeyLocation(body []byte) (BasicContentKeyPolicyPlayReadyContentKeyLocation, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader):
		var ckpprcekfh ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader
		err := json.Unmarshal(body, &ckpprcekfh)
		return ckpprcekfh, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier):
		var ckpprcekfki ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier
		err := json.Unmarshal(body, &ckpprcekfki)
		return ckpprcekfki, err
	default:
		var ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation
		err := json.Unmarshal(body, &ckpprckl)
		return ckpprckl, err
	}
}
func unmarshalBasicContentKeyPolicyPlayReadyContentKeyLocationArray(body []byte) ([]BasicContentKeyPolicyPlayReadyContentKeyLocation, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ckpprcklArray := make([]BasicContentKeyPolicyPlayReadyContentKeyLocation, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ckpprckl, err := unmarshalBasicContentKeyPolicyPlayReadyContentKeyLocation(*rawMessage)
		if err != nil {
			return nil, err
		}
		ckpprcklArray[index] = ckpprckl
	}
	return ckpprcklArray, nil
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyPlayReadyContentKeyLocation.
func (ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation) MarshalJSON() ([]byte, error) {
	ckpprckl.OdataType = OdataTypeContentKeyPolicyPlayReadyContentKeyLocation
	objectMap := make(map[string]interface{})
	if ckpprckl.OdataType != "" {
		objectMap["@odata.type"] = ckpprckl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentKeyLocation.
func (ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentKeyLocation.
func (ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation) AsContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier() (*ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentKeyLocation.
func (ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation) AsContentKeyPolicyPlayReadyContentKeyLocation() (*ContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return &ckpprckl, true
}

// AsBasicContentKeyPolicyPlayReadyContentKeyLocation is the BasicContentKeyPolicyPlayReadyContentKeyLocation implementation for ContentKeyPolicyPlayReadyContentKeyLocation.
func (ckpprckl ContentKeyPolicyPlayReadyContentKeyLocation) AsBasicContentKeyPolicyPlayReadyContentKeyLocation() (BasicContentKeyPolicyPlayReadyContentKeyLocation, bool) {
	return &ckpprckl, true
}

// ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction configures the Explicit Analog Television
// Output Restriction control bits. For further details see the PlayReady Compliance Rules.
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction struct {
	// BestEffort - Indicates whether this restriction is enforced on a Best Effort basis.
	BestEffort *bool `json:"bestEffort,omitempty"`
	// ConfigurationData - Configures the restriction control bits. Must be between 0 and 3 inclusive.
	ConfigurationData *int32 `json:"configurationData,omitempty"`
}

// ContentKeyPolicyPlayReadyLicense the PlayReady license
type ContentKeyPolicyPlayReadyLicense struct {
	// AllowTestDevices - A flag indicating whether test devices can use the license.
	AllowTestDevices *bool `json:"allowTestDevices,omitempty"`
	// BeginDate - The begin date of license
	BeginDate *date.Time `json:"beginDate,omitempty"`
	// ExpirationDate - The expiration date of license.
	ExpirationDate *date.Time `json:"expirationDate,omitempty"`
	// RelativeBeginDate - The relative begin date of license.
	RelativeBeginDate *string `json:"relativeBeginDate,omitempty"`
	// RelativeExpirationDate - The relative expiration date of license.
	RelativeExpirationDate *string `json:"relativeExpirationDate,omitempty"`
	// GracePeriod - The grace period of license.
	GracePeriod *string `json:"gracePeriod,omitempty"`
	// PlayRight - The license PlayRight
	PlayRight *ContentKeyPolicyPlayReadyPlayRight `json:"playRight,omitempty"`
	// LicenseType - The license type. Possible values include: 'ContentKeyPolicyPlayReadyLicenseTypeUnknown', 'ContentKeyPolicyPlayReadyLicenseTypeNonPersistent', 'ContentKeyPolicyPlayReadyLicenseTypePersistent'
	LicenseType ContentKeyPolicyPlayReadyLicenseType `json:"licenseType,omitempty"`
	// ContentKeyLocation - The content key location.
	ContentKeyLocation BasicContentKeyPolicyPlayReadyContentKeyLocation `json:"contentKeyLocation,omitempty"`
	// ContentType - The PlayReady content type. Possible values include: 'ContentKeyPolicyPlayReadyContentTypeUnknown', 'ContentKeyPolicyPlayReadyContentTypeUnspecified', 'ContentKeyPolicyPlayReadyContentTypeUltraVioletDownload', 'ContentKeyPolicyPlayReadyContentTypeUltraVioletStreaming'
	ContentType ContentKeyPolicyPlayReadyContentType `json:"contentType,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ContentKeyPolicyPlayReadyLicense struct.
func (ckpprl *ContentKeyPolicyPlayReadyLicense) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "allowTestDevices":
			if v != nil {
				var allowTestDevices bool
				err = json.Unmarshal(*v, &allowTestDevices)
				if err != nil {
					return err
				}
				ckpprl.AllowTestDevices = &allowTestDevices
			}
		case "beginDate":
			if v != nil {
				var beginDate date.Time
				err = json.Unmarshal(*v, &beginDate)
				if err != nil {
					return err
				}
				ckpprl.BeginDate = &beginDate
			}
		case "expirationDate":
			if v != nil {
				var expirationDate date.Time
				err = json.Unmarshal(*v, &expirationDate)
				if err != nil {
					return err
				}
				ckpprl.ExpirationDate = &expirationDate
			}
		case "relativeBeginDate":
			if v != nil {
				var relativeBeginDate string
				err = json.Unmarshal(*v, &relativeBeginDate)
				if err != nil {
					return err
				}
				ckpprl.RelativeBeginDate = &relativeBeginDate
			}
		case "relativeExpirationDate":
			if v != nil {
				var relativeExpirationDate string
				err = json.Unmarshal(*v, &relativeExpirationDate)
				if err != nil {
					return err
				}
				ckpprl.RelativeExpirationDate = &relativeExpirationDate
			}
		case "gracePeriod":
			if v != nil {
				var gracePeriod string
				err = json.Unmarshal(*v, &gracePeriod)
				if err != nil {
					return err
				}
				ckpprl.GracePeriod = &gracePeriod
			}
		case "playRight":
			if v != nil {
				var playRight ContentKeyPolicyPlayReadyPlayRight
				err = json.Unmarshal(*v, &playRight)
				if err != nil {
					return err
				}
				ckpprl.PlayRight = &playRight
			}
		case "licenseType":
			if v != nil {
				var licenseType ContentKeyPolicyPlayReadyLicenseType
				err = json.Unmarshal(*v, &licenseType)
				if err != nil {
					return err
				}
				ckpprl.LicenseType = licenseType
			}
		case "contentKeyLocation":
			if v != nil {
				contentKeyLocation, err := unmarshalBasicContentKeyPolicyPlayReadyContentKeyLocation(*v)
				if err != nil {
					return err
				}
				ckpprl.ContentKeyLocation = contentKeyLocation
			}
		case "contentType":
			if v != nil {
				var contentType ContentKeyPolicyPlayReadyContentType
				err = json.Unmarshal(*v, &contentType)
				if err != nil {
					return err
				}
				ckpprl.ContentType = contentType
			}
		}
	}

	return nil
}

// ContentKeyPolicyPlayReadyPlayRight configures the Play Right in the PlayReady license.
type ContentKeyPolicyPlayReadyPlayRight struct {
	// FirstPlayExpiration - The amount of time that the license is valid after the license is first used to play content.
	FirstPlayExpiration *string `json:"firstPlayExpiration,omitempty"`
	// ScmsRestriction - Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
	ScmsRestriction *int32 `json:"scmsRestriction,omitempty"`
	// AgcAndColorStripeRestriction - Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
	AgcAndColorStripeRestriction *int32 `json:"agcAndColorStripeRestriction,omitempty"`
	// ExplicitAnalogTelevisionOutputRestriction - Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3 inclusive.
	ExplicitAnalogTelevisionOutputRestriction *ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction `json:"explicitAnalogTelevisionOutputRestriction,omitempty"`
	// DigitalVideoOnlyContentRestriction - Enables the Image Constraint For Analog Component Video Restriction in the license.
	DigitalVideoOnlyContentRestriction *bool `json:"digitalVideoOnlyContentRestriction,omitempty"`
	// ImageConstraintForAnalogComponentVideoRestriction - Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComponentVideoRestriction *bool `json:"imageConstraintForAnalogComponentVideoRestriction,omitempty"`
	// ImageConstraintForAnalogComputerMonitorRestriction - Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComputerMonitorRestriction *bool `json:"imageConstraintForAnalogComputerMonitorRestriction,omitempty"`
	// AllowPassingVideoContentToUnknownOutput - Configures Unknown output handling settings of the license. Possible values include: 'ContentKeyPolicyPlayReadyUnknownOutputPassingOptionUnknown', 'ContentKeyPolicyPlayReadyUnknownOutputPassingOptionNotAllowed', 'ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowed', 'ContentKeyPolicyPlayReadyUnknownOutputPassingOptionAllowedWithVideoConstriction'
	AllowPassingVideoContentToUnknownOutput ContentKeyPolicyPlayReadyUnknownOutputPassingOption `json:"allowPassingVideoContentToUnknownOutput,omitempty"`
	// UncompressedDigitalVideoOpl - Specifies the output protection level for uncompressed digital video.
	UncompressedDigitalVideoOpl *int32 `json:"uncompressedDigitalVideoOpl,omitempty"`
	// CompressedDigitalVideoOpl - Specifies the output protection level for compressed digital video.
	CompressedDigitalVideoOpl *int32 `json:"compressedDigitalVideoOpl,omitempty"`
	// AnalogVideoOpl - Specifies the output protection level for compressed digital audio.
	AnalogVideoOpl *int32 `json:"analogVideoOpl,omitempty"`
	// CompressedDigitalAudioOpl - Specifies the output protection level for compressed digital audio.
	CompressedDigitalAudioOpl *int32 `json:"compressedDigitalAudioOpl,omitempty"`
	// UncompressedDigitalAudioOpl - Specifies the output protection level for uncompressed digital audio.
	UncompressedDigitalAudioOpl *int32 `json:"uncompressedDigitalAudioOpl,omitempty"`
}

// ContentKeyPolicyProperties the properties of the Content Key Policy.
type ContentKeyPolicyProperties struct {
	autorest.Response `json:"-"`
	// PolicyID - READ-ONLY; The legacy Policy ID.
	PolicyID *uuid.UUID `json:"policyId,omitempty"`
	// Created - READ-ONLY; The creation date of the Policy
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The last modified date of the Policy
	LastModified *date.Time `json:"lastModified,omitempty"`
	// Description - A description for the Policy.
	Description *string `json:"description,omitempty"`
	// Options - The Key Policy options.
	Options *[]ContentKeyPolicyOption `json:"options,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyProperties.
func (ckpp ContentKeyPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ckpp.Description != nil {
		objectMap["description"] = ckpp.Description
	}
	if ckpp.Options != nil {
		objectMap["options"] = ckpp.Options
	}
	return json.Marshal(objectMap)
}

// BasicContentKeyPolicyRestriction base class for Content Key Policy restrictions. A derived class must be used to
// create a restriction.
type BasicContentKeyPolicyRestriction interface {
	AsContentKeyPolicyOpenRestriction() (*ContentKeyPolicyOpenRestriction, bool)
	AsContentKeyPolicyUnknownRestriction() (*ContentKeyPolicyUnknownRestriction, bool)
	AsContentKeyPolicyTokenRestriction() (*ContentKeyPolicyTokenRestriction, bool)
	AsContentKeyPolicyRestriction() (*ContentKeyPolicyRestriction, bool)
}

// ContentKeyPolicyRestriction base class for Content Key Policy restrictions. A derived class must be used to
// create a restriction.
type ContentKeyPolicyRestriction struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction'
	OdataType OdataTypeBasicContentKeyPolicyRestriction `json:"@odata.type,omitempty"`
}

func unmarshalBasicContentKeyPolicyRestriction(body []byte) (BasicContentKeyPolicyRestriction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction):
		var ckpor ContentKeyPolicyOpenRestriction
		err := json.Unmarshal(body, &ckpor)
		return ckpor, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction):
		var ckpur ContentKeyPolicyUnknownRestriction
		err := json.Unmarshal(body, &ckpur)
		return ckpur, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction):
		var ckptr ContentKeyPolicyTokenRestriction
		err := json.Unmarshal(body, &ckptr)
		return ckptr, err
	default:
		var ckpr ContentKeyPolicyRestriction
		err := json.Unmarshal(body, &ckpr)
		return ckpr, err
	}
}
func unmarshalBasicContentKeyPolicyRestrictionArray(body []byte) ([]BasicContentKeyPolicyRestriction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ckprArray := make([]BasicContentKeyPolicyRestriction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ckpr, err := unmarshalBasicContentKeyPolicyRestriction(*rawMessage)
		if err != nil {
			return nil, err
		}
		ckprArray[index] = ckpr
	}
	return ckprArray, nil
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) MarshalJSON() ([]byte, error) {
	ckpr.OdataType = OdataTypeContentKeyPolicyRestriction
	objectMap := make(map[string]interface{})
	if ckpr.OdataType != "" {
		objectMap["@odata.type"] = ckpr.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyOpenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) AsContentKeyPolicyOpenRestriction() (*ContentKeyPolicyOpenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) AsContentKeyPolicyUnknownRestriction() (*ContentKeyPolicyUnknownRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyTokenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) AsContentKeyPolicyTokenRestriction() (*ContentKeyPolicyTokenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) AsContentKeyPolicyRestriction() (*ContentKeyPolicyRestriction, bool) {
	return &ckpr, true
}

// AsBasicContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyRestriction.
func (ckpr ContentKeyPolicyRestriction) AsBasicContentKeyPolicyRestriction() (BasicContentKeyPolicyRestriction, bool) {
	return &ckpr, true
}

// BasicContentKeyPolicyRestrictionTokenKey base class for Content Key Policy key for token validation. A derived class
// must be used to create a token key.
type BasicContentKeyPolicyRestrictionTokenKey interface {
	AsContentKeyPolicySymmetricTokenKey() (*ContentKeyPolicySymmetricTokenKey, bool)
	AsContentKeyPolicyRsaTokenKey() (*ContentKeyPolicyRsaTokenKey, bool)
	AsContentKeyPolicyX509CertificateTokenKey() (*ContentKeyPolicyX509CertificateTokenKey, bool)
	AsContentKeyPolicyRestrictionTokenKey() (*ContentKeyPolicyRestrictionTokenKey, bool)
}

// ContentKeyPolicyRestrictionTokenKey base class for Content Key Policy key for token validation. A derived
// class must be used to create a token key.
type ContentKeyPolicyRestrictionTokenKey struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestrictionTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey'
	OdataType OdataTypeBasicContentKeyPolicyRestrictionTokenKey `json:"@odata.type,omitempty"`
}

func unmarshalBasicContentKeyPolicyRestrictionTokenKey(body []byte) (BasicContentKeyPolicyRestrictionTokenKey, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey):
		var ckpstk ContentKeyPolicySymmetricTokenKey
		err := json.Unmarshal(body, &ckpstk)
		return ckpstk, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey):
		var ckprtk ContentKeyPolicyRsaTokenKey
		err := json.Unmarshal(body, &ckprtk)
		return ckprtk, err
	case string(OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey):
		var ckpxctk ContentKeyPolicyX509CertificateTokenKey
		err := json.Unmarshal(body, &ckpxctk)
		return ckpxctk, err
	default:
		var ckprtk ContentKeyPolicyRestrictionTokenKey
		err := json.Unmarshal(body, &ckprtk)
		return ckprtk, err
	}
}
func unmarshalBasicContentKeyPolicyRestrictionTokenKeyArray(body []byte) ([]BasicContentKeyPolicyRestrictionTokenKey, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ckprtkArray := make([]BasicContentKeyPolicyRestrictionTokenKey, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ckprtk, err := unmarshalBasicContentKeyPolicyRestrictionTokenKey(*rawMessage)
		if err != nil {
			return nil, err
		}
		ckprtkArray[index] = ckprtk
	}
	return ckprtkArray, nil
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) MarshalJSON() ([]byte, error) {
	ckprtk.OdataType = OdataTypeContentKeyPolicyRestrictionTokenKey
	objectMap := make(map[string]interface{})
	if ckprtk.OdataType != "" {
		objectMap["@odata.type"] = ckprtk.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicySymmetricTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) AsContentKeyPolicySymmetricTokenKey() (*ContentKeyPolicySymmetricTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRsaTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) AsContentKeyPolicyRsaTokenKey() (*ContentKeyPolicyRsaTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyX509CertificateTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) AsContentKeyPolicyX509CertificateTokenKey() (*ContentKeyPolicyX509CertificateTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) AsContentKeyPolicyRestrictionTokenKey() (*ContentKeyPolicyRestrictionTokenKey, bool) {
	return &ckprtk, true
}

// AsBasicContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRestrictionTokenKey.
func (ckprtk ContentKeyPolicyRestrictionTokenKey) AsBasicContentKeyPolicyRestrictionTokenKey() (BasicContentKeyPolicyRestrictionTokenKey, bool) {
	return &ckprtk, true
}

// ContentKeyPolicyRsaTokenKey specifies a RSA key for token validation
type ContentKeyPolicyRsaTokenKey struct {
	// Exponent - The RSA Parameter exponent
	Exponent *[]byte `json:"exponent,omitempty"`
	// Modulus - The RSA Parameter modulus
	Modulus *[]byte `json:"modulus,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestrictionTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey'
	OdataType OdataTypeBasicContentKeyPolicyRestrictionTokenKey `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) MarshalJSON() ([]byte, error) {
	ckprtk.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey
	objectMap := make(map[string]interface{})
	if ckprtk.Exponent != nil {
		objectMap["exponent"] = ckprtk.Exponent
	}
	if ckprtk.Modulus != nil {
		objectMap["modulus"] = ckprtk.Modulus
	}
	if ckprtk.OdataType != "" {
		objectMap["@odata.type"] = ckprtk.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicySymmetricTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) AsContentKeyPolicySymmetricTokenKey() (*ContentKeyPolicySymmetricTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRsaTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) AsContentKeyPolicyRsaTokenKey() (*ContentKeyPolicyRsaTokenKey, bool) {
	return &ckprtk, true
}

// AsContentKeyPolicyX509CertificateTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) AsContentKeyPolicyX509CertificateTokenKey() (*ContentKeyPolicyX509CertificateTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) AsContentKeyPolicyRestrictionTokenKey() (*ContentKeyPolicyRestrictionTokenKey, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyRsaTokenKey.
func (ckprtk ContentKeyPolicyRsaTokenKey) AsBasicContentKeyPolicyRestrictionTokenKey() (BasicContentKeyPolicyRestrictionTokenKey, bool) {
	return &ckprtk, true
}

// ContentKeyPolicySymmetricTokenKey specifies a symmetric key for token validation.
type ContentKeyPolicySymmetricTokenKey struct {
	// KeyValue - The key value of the key
	KeyValue *[]byte `json:"keyValue,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestrictionTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey'
	OdataType OdataTypeBasicContentKeyPolicyRestrictionTokenKey `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) MarshalJSON() ([]byte, error) {
	ckpstk.OdataType = OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey
	objectMap := make(map[string]interface{})
	if ckpstk.KeyValue != nil {
		objectMap["keyValue"] = ckpstk.KeyValue
	}
	if ckpstk.OdataType != "" {
		objectMap["@odata.type"] = ckpstk.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicySymmetricTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) AsContentKeyPolicySymmetricTokenKey() (*ContentKeyPolicySymmetricTokenKey, bool) {
	return &ckpstk, true
}

// AsContentKeyPolicyRsaTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) AsContentKeyPolicyRsaTokenKey() (*ContentKeyPolicyRsaTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyX509CertificateTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) AsContentKeyPolicyX509CertificateTokenKey() (*ContentKeyPolicyX509CertificateTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) AsContentKeyPolicyRestrictionTokenKey() (*ContentKeyPolicyRestrictionTokenKey, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicySymmetricTokenKey.
func (ckpstk ContentKeyPolicySymmetricTokenKey) AsBasicContentKeyPolicyRestrictionTokenKey() (BasicContentKeyPolicyRestrictionTokenKey, bool) {
	return &ckpstk, true
}

// ContentKeyPolicyTokenClaim represents a token claim.
type ContentKeyPolicyTokenClaim struct {
	// ClaimType - Token claim type.
	ClaimType *string `json:"claimType,omitempty"`
	// ClaimValue - Token claim value.
	ClaimValue *string `json:"claimValue,omitempty"`
}

// ContentKeyPolicyTokenRestriction represents a token restriction. Provided token must match these
// requirements for successful license or key delivery.
type ContentKeyPolicyTokenRestriction struct {
	// Issuer - The token issuer.
	Issuer *string `json:"issuer,omitempty"`
	// Audience - The audience for the token.
	Audience *string `json:"audience,omitempty"`
	// PrimaryVerificationKey - The primary verification key.
	PrimaryVerificationKey BasicContentKeyPolicyRestrictionTokenKey `json:"primaryVerificationKey,omitempty"`
	// AlternateVerificationKeys - A list of alternative verification keys.
	AlternateVerificationKeys *[]BasicContentKeyPolicyRestrictionTokenKey `json:"alternateVerificationKeys,omitempty"`
	// RequiredClaims - A list of required token claims.
	RequiredClaims *[]ContentKeyPolicyTokenClaim `json:"requiredClaims,omitempty"`
	// RestrictionTokenType - The type of token. Possible values include: 'ContentKeyPolicyRestrictionTokenTypeUnknown', 'ContentKeyPolicyRestrictionTokenTypeSwt', 'ContentKeyPolicyRestrictionTokenTypeJwt'
	RestrictionTokenType ContentKeyPolicyRestrictionTokenType `json:"restrictionTokenType,omitempty"`
	// OpenIDConnectDiscoveryDocument - The OpenID connect discovery document.
	OpenIDConnectDiscoveryDocument *string `json:"openIdConnectDiscoveryDocument,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction'
	OdataType OdataTypeBasicContentKeyPolicyRestriction `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) MarshalJSON() ([]byte, error) {
	ckptr.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction
	objectMap := make(map[string]interface{})
	if ckptr.Issuer != nil {
		objectMap["issuer"] = ckptr.Issuer
	}
	if ckptr.Audience != nil {
		objectMap["audience"] = ckptr.Audience
	}
	objectMap["primaryVerificationKey"] = ckptr.PrimaryVerificationKey
	if ckptr.AlternateVerificationKeys != nil {
		objectMap["alternateVerificationKeys"] = ckptr.AlternateVerificationKeys
	}
	if ckptr.RequiredClaims != nil {
		objectMap["requiredClaims"] = ckptr.RequiredClaims
	}
	if ckptr.RestrictionTokenType != "" {
		objectMap["restrictionTokenType"] = ckptr.RestrictionTokenType
	}
	if ckptr.OpenIDConnectDiscoveryDocument != nil {
		objectMap["openIdConnectDiscoveryDocument"] = ckptr.OpenIDConnectDiscoveryDocument
	}
	if ckptr.OdataType != "" {
		objectMap["@odata.type"] = ckptr.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyOpenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) AsContentKeyPolicyOpenRestriction() (*ContentKeyPolicyOpenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) AsContentKeyPolicyUnknownRestriction() (*ContentKeyPolicyUnknownRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyTokenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) AsContentKeyPolicyTokenRestriction() (*ContentKeyPolicyTokenRestriction, bool) {
	return &ckptr, true
}

// AsContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) AsContentKeyPolicyRestriction() (*ContentKeyPolicyRestriction, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyTokenRestriction.
func (ckptr ContentKeyPolicyTokenRestriction) AsBasicContentKeyPolicyRestriction() (BasicContentKeyPolicyRestriction, bool) {
	return &ckptr, true
}

// UnmarshalJSON is the custom unmarshaler for ContentKeyPolicyTokenRestriction struct.
func (ckptr *ContentKeyPolicyTokenRestriction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "issuer":
			if v != nil {
				var issuer string
				err = json.Unmarshal(*v, &issuer)
				if err != nil {
					return err
				}
				ckptr.Issuer = &issuer
			}
		case "audience":
			if v != nil {
				var audience string
				err = json.Unmarshal(*v, &audience)
				if err != nil {
					return err
				}
				ckptr.Audience = &audience
			}
		case "primaryVerificationKey":
			if v != nil {
				primaryVerificationKey, err := unmarshalBasicContentKeyPolicyRestrictionTokenKey(*v)
				if err != nil {
					return err
				}
				ckptr.PrimaryVerificationKey = primaryVerificationKey
			}
		case "alternateVerificationKeys":
			if v != nil {
				alternateVerificationKeys, err := unmarshalBasicContentKeyPolicyRestrictionTokenKeyArray(*v)
				if err != nil {
					return err
				}
				ckptr.AlternateVerificationKeys = &alternateVerificationKeys
			}
		case "requiredClaims":
			if v != nil {
				var requiredClaims []ContentKeyPolicyTokenClaim
				err = json.Unmarshal(*v, &requiredClaims)
				if err != nil {
					return err
				}
				ckptr.RequiredClaims = &requiredClaims
			}
		case "restrictionTokenType":
			if v != nil {
				var restrictionTokenType ContentKeyPolicyRestrictionTokenType
				err = json.Unmarshal(*v, &restrictionTokenType)
				if err != nil {
					return err
				}
				ckptr.RestrictionTokenType = restrictionTokenType
			}
		case "openIdConnectDiscoveryDocument":
			if v != nil {
				var openIDConnectDiscoveryDocument string
				err = json.Unmarshal(*v, &openIDConnectDiscoveryDocument)
				if err != nil {
					return err
				}
				ckptr.OpenIDConnectDiscoveryDocument = &openIDConnectDiscoveryDocument
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicContentKeyPolicyRestriction
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ckptr.OdataType = odataType
			}
		}
	}

	return nil
}

// ContentKeyPolicyUnknownConfiguration represents a ContentKeyPolicyConfiguration that is unavailable in
// the current API version.
type ContentKeyPolicyUnknownConfiguration struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) MarshalJSON() ([]byte, error) {
	ckpuc.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration
	objectMap := make(map[string]interface{})
	if ckpuc.OdataType != "" {
		objectMap["@odata.type"] = ckpuc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return &ckpuc, true
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyUnknownConfiguration.
func (ckpuc ContentKeyPolicyUnknownConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpuc, true
}

// ContentKeyPolicyUnknownRestriction represents a ContentKeyPolicyRestriction that is unavailable in the
// current API version.
type ContentKeyPolicyUnknownRestriction struct {
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyOpenRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction', 'OdataTypeMicrosoftMediaContentKeyPolicyTokenRestriction'
	OdataType OdataTypeBasicContentKeyPolicyRestriction `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) MarshalJSON() ([]byte, error) {
	ckpur.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyUnknownRestriction
	objectMap := make(map[string]interface{})
	if ckpur.OdataType != "" {
		objectMap["@odata.type"] = ckpur.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyOpenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) AsContentKeyPolicyOpenRestriction() (*ContentKeyPolicyOpenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) AsContentKeyPolicyUnknownRestriction() (*ContentKeyPolicyUnknownRestriction, bool) {
	return &ckpur, true
}

// AsContentKeyPolicyTokenRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) AsContentKeyPolicyTokenRestriction() (*ContentKeyPolicyTokenRestriction, bool) {
	return nil, false
}

// AsContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) AsContentKeyPolicyRestriction() (*ContentKeyPolicyRestriction, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestriction is the BasicContentKeyPolicyRestriction implementation for ContentKeyPolicyUnknownRestriction.
func (ckpur ContentKeyPolicyUnknownRestriction) AsBasicContentKeyPolicyRestriction() (BasicContentKeyPolicyRestriction, bool) {
	return &ckpur, true
}

// ContentKeyPolicyWidevineConfiguration specifies a configuration for Widevine licenses.
type ContentKeyPolicyWidevineConfiguration struct {
	// WidevineTemplate - The Widevine template.
	WidevineTemplate *string `json:"widevineTemplate,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyClearKeyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyUnknownConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyPlayReadyConfiguration', 'OdataTypeMicrosoftMediaContentKeyPolicyFairPlayConfiguration'
	OdataType OdataTypeBasicContentKeyPolicyConfiguration `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) MarshalJSON() ([]byte, error) {
	ckpwc.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyWidevineConfiguration
	objectMap := make(map[string]interface{})
	if ckpwc.WidevineTemplate != nil {
		objectMap["widevineTemplate"] = ckpwc.WidevineTemplate
	}
	if ckpwc.OdataType != "" {
		objectMap["@odata.type"] = ckpwc.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicyClearKeyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyClearKeyConfiguration() (*ContentKeyPolicyClearKeyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyUnknownConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyUnknownConfiguration() (*ContentKeyPolicyUnknownConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyWidevineConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyWidevineConfiguration() (*ContentKeyPolicyWidevineConfiguration, bool) {
	return &ckpwc, true
}

// AsContentKeyPolicyPlayReadyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyPlayReadyConfiguration() (*ContentKeyPolicyPlayReadyConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyFairPlayConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyFairPlayConfiguration() (*ContentKeyPolicyFairPlayConfiguration, bool) {
	return nil, false
}

// AsContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsContentKeyPolicyConfiguration() (*ContentKeyPolicyConfiguration, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyConfiguration is the BasicContentKeyPolicyConfiguration implementation for ContentKeyPolicyWidevineConfiguration.
func (ckpwc ContentKeyPolicyWidevineConfiguration) AsBasicContentKeyPolicyConfiguration() (BasicContentKeyPolicyConfiguration, bool) {
	return &ckpwc, true
}

// ContentKeyPolicyX509CertificateTokenKey specifies a certificate for token validation.
type ContentKeyPolicyX509CertificateTokenKey struct {
	// RawBody - The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
	RawBody *[]byte `json:"rawBody,omitempty"`
	// OdataType - Possible values include: 'OdataTypeContentKeyPolicyRestrictionTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicySymmetricTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyRsaTokenKey', 'OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey'
	OdataType OdataTypeBasicContentKeyPolicyRestrictionTokenKey `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) MarshalJSON() ([]byte, error) {
	ckpxctk.OdataType = OdataTypeMicrosoftMediaContentKeyPolicyX509CertificateTokenKey
	objectMap := make(map[string]interface{})
	if ckpxctk.RawBody != nil {
		objectMap["rawBody"] = ckpxctk.RawBody
	}
	if ckpxctk.OdataType != "" {
		objectMap["@odata.type"] = ckpxctk.OdataType
	}
	return json.Marshal(objectMap)
}

// AsContentKeyPolicySymmetricTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) AsContentKeyPolicySymmetricTokenKey() (*ContentKeyPolicySymmetricTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyRsaTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) AsContentKeyPolicyRsaTokenKey() (*ContentKeyPolicyRsaTokenKey, bool) {
	return nil, false
}

// AsContentKeyPolicyX509CertificateTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) AsContentKeyPolicyX509CertificateTokenKey() (*ContentKeyPolicyX509CertificateTokenKey, bool) {
	return &ckpxctk, true
}

// AsContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) AsContentKeyPolicyRestrictionTokenKey() (*ContentKeyPolicyRestrictionTokenKey, bool) {
	return nil, false
}

// AsBasicContentKeyPolicyRestrictionTokenKey is the BasicContentKeyPolicyRestrictionTokenKey implementation for ContentKeyPolicyX509CertificateTokenKey.
func (ckpxctk ContentKeyPolicyX509CertificateTokenKey) AsBasicContentKeyPolicyRestrictionTokenKey() (BasicContentKeyPolicyRestrictionTokenKey, bool) {
	return &ckpxctk, true
}

// CopyAudio a codec flag, which tells the encoder to copy the input audio bitstream.
type CopyAudio struct {
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyAudio.
func (ca CopyAudio) MarshalJSON() ([]byte, error) {
	ca.OdataType = OdataTypeMicrosoftMediaCopyAudio
	objectMap := make(map[string]interface{})
	if ca.Label != nil {
		objectMap["label"] = ca.Label
	}
	if ca.OdataType != "" {
		objectMap["@odata.type"] = ca.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsBasicVideo() (BasicVideo, bool) {
	return nil, false
}

// AsH265Video is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsCopyAudio() (*CopyAudio, bool) {
	return &ca, true
}

// AsH264Video is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for CopyAudio.
func (ca CopyAudio) AsBasicCodec() (BasicCodec, bool) {
	return &ca, true
}

// CopyVideo a codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
type CopyVideo struct {
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for CopyVideo.
func (cv CopyVideo) MarshalJSON() ([]byte, error) {
	cv.OdataType = OdataTypeMicrosoftMediaCopyVideo
	objectMap := make(map[string]interface{})
	if cv.Label != nil {
		objectMap["label"] = cv.Label
	}
	if cv.OdataType != "" {
		objectMap["@odata.type"] = cv.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsBasicVideo() (BasicVideo, bool) {
	return nil, false
}

// AsH265Video is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsCopyVideo() (*CopyVideo, bool) {
	return &cv, true
}

// AsImage is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for CopyVideo.
func (cv CopyVideo) AsBasicCodec() (BasicCodec, bool) {
	return &cv, true
}

// CrossSiteAccessPolicies the client access policy.
type CrossSiteAccessPolicies struct {
	// ClientAccessPolicy - The content of clientaccesspolicy.xml used by Silverlight.
	ClientAccessPolicy *string `json:"clientAccessPolicy,omitempty"`
	// CrossDomainPolicy - The content of crossdomain.xml used by Silverlight.
	CrossDomainPolicy *string `json:"crossDomainPolicy,omitempty"`
}

// DefaultKey class to specify properties of default content key for each encryption scheme
type DefaultKey struct {
	// Label - Label can be used to specify Content Key when creating a Streaming Locator
	Label *string `json:"label,omitempty"`
	// PolicyName - Policy used by Default Key
	PolicyName *string `json:"policyName,omitempty"`
}

// Deinterlace describes the de-interlacing settings.
type Deinterlace struct {
	// Parity - The field parity for de-interlacing, defaults to Auto. Possible values include: 'Auto', 'TopFieldFirst', 'BottomFieldFirst'
	Parity DeinterlaceParity `json:"parity,omitempty"`
	// Mode - The deinterlacing mode. Defaults to AutoPixelAdaptive. Possible values include: 'Off', 'AutoPixelAdaptive'
	Mode DeinterlaceMode `json:"mode,omitempty"`
}

// EdgePolicies ...
type EdgePolicies struct {
	autorest.Response         `json:"-"`
	UsageDataCollectionPolicy *EdgeUsageDataCollectionPolicy `json:"usageDataCollectionPolicy,omitempty"`
}

// EdgeUsageDataCollectionPolicy ...
type EdgeUsageDataCollectionPolicy struct {
	// DataCollectionFrequency - Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataCollectionFrequency *string `json:"dataCollectionFrequency,omitempty"`
	// DataReportingFrequency - Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataReportingFrequency *string `json:"dataReportingFrequency,omitempty"`
	// MaxAllowedUnreportedUsageDuration - Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
	MaxAllowedUnreportedUsageDuration *string `json:"maxAllowedUnreportedUsageDuration,omitempty"`
	// EventHubDetails - Details of Event Hub where the usage will be reported.
	EventHubDetails *EdgeUsageDataEventHub `json:"eventHubDetails,omitempty"`
}

// EdgeUsageDataEventHub ...
type EdgeUsageDataEventHub struct {
	// Name - Name of the Event Hub where usage will be reported.
	Name *string `json:"name,omitempty"`
	// Namespace - Namespace of the Event Hub where usage will be reported.
	Namespace *string `json:"namespace,omitempty"`
	// Token - SAS token needed to interact with Event Hub.
	Token *string `json:"token,omitempty"`
}

// EnabledProtocols class to specify which protocols are enabled
type EnabledProtocols struct {
	// Download - Enable Download protocol or not
	Download *bool `json:"download,omitempty"`
	// Dash - Enable DASH protocol or not
	Dash *bool `json:"dash,omitempty"`
	// Hls - Enable HLS protocol or not
	Hls *bool `json:"hls,omitempty"`
	// SmoothStreaming - Enable SmoothStreaming protocol or not
	SmoothStreaming *bool `json:"smoothStreaming,omitempty"`
}

// EntityNameAvailabilityCheckOutput the response from the check name availability request.
type EntityNameAvailabilityCheckOutput struct {
	autorest.Response `json:"-"`
	// NameAvailable - Specifies if the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - Specifies the reason if the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - Specifies the detailed reason if the name is not available.
	Message *string `json:"message,omitempty"`
}

// EnvelopeEncryption class for EnvelopeEncryption encryption scheme
type EnvelopeEncryption struct {
	// EnabledProtocols - Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
	// ClearTracks - Representing which tracks should not be encrypted
	ClearTracks *[]TrackSelection `json:"clearTracks,omitempty"`
	// ContentKeys - Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys `json:"contentKeys,omitempty"`
	// CustomKeyAcquisitionURLTemplate - Template for the URL of the custom service delivering keys to end user players.  Not required when using Azure Media Services for issuing keys.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomKeyAcquisitionURLTemplate *string `json:"customKeyAcquisitionUrlTemplate,omitempty"`
}

// FaceDetectorPreset describes all the settings to be used when analyzing a video in order to detect (and
// optionally redact) all the faces present.
type FaceDetectorPreset struct {
	// Resolution - Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will keep the input video at its original resolution when analyzed. Using "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It will only resize if the video is of higher resolution. For example, a 1920x1080 input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to process high resolution video. It may also reduce the cost of using this component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces that end up being too small in the resized video may not be detected. Possible values include: 'SourceResolution', 'StandardDefinition'
	Resolution AnalysisResolution `json:"resolution,omitempty"`
	// Mode - This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates a metadata JSON file marking appearances of faces throughout the video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs) detected faces. 3) Redact - This enables a 2-pass process, allowing for selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the source video, and a user-selected subset of IDs that require redaction. Possible values include: 'Analyze', 'Redact', 'Combined'
	Mode FaceRedactorMode `json:"mode,omitempty"`
	// BlurType - Blur type. Possible values include: 'Box', 'Low', 'Med', 'High', 'Black'
	BlurType BlurType `json:"blurType,omitempty"`
	// ExperimentalOptions - Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions"`
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for FaceDetectorPreset.
func (fdp FaceDetectorPreset) MarshalJSON() ([]byte, error) {
	fdp.OdataType = OdataTypeMicrosoftMediaFaceDetectorPreset
	objectMap := make(map[string]interface{})
	if fdp.Resolution != "" {
		objectMap["resolution"] = fdp.Resolution
	}
	if fdp.Mode != "" {
		objectMap["mode"] = fdp.Mode
	}
	if fdp.BlurType != "" {
		objectMap["blurType"] = fdp.BlurType
	}
	if fdp.ExperimentalOptions != nil {
		objectMap["experimentalOptions"] = fdp.ExperimentalOptions
	}
	if fdp.OdataType != "" {
		objectMap["@odata.type"] = fdp.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return &fdp, true
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return nil, false
}

// AsStandardEncoderPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return nil, false
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return nil, false
}

// AsPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsPreset() (*Preset, bool) {
	return nil, false
}

// AsBasicPreset is the BasicPreset implementation for FaceDetectorPreset.
func (fdp FaceDetectorPreset) AsBasicPreset() (BasicPreset, bool) {
	return &fdp, true
}

// FilterProperties the Media Filter properties.
type FilterProperties struct {
	// PresentationTimeRange - The presentation time range.
	PresentationTimeRange *PresentationTimeRange `json:"presentationTimeRange,omitempty"`
	// FirstQuality - The first quality.
	FirstQuality *FirstQuality `json:"firstQuality,omitempty"`
	// Tracks - The tracks selection conditions.
	Tracks *[]FilterTrackSelection `json:"tracks,omitempty"`
}

// Filters describes all the filtering operations, such as de-interlacing, rotation etc. that are to be
// applied to the input media before encoding.
type Filters struct {
	// Deinterlace - The de-interlacing settings.
	Deinterlace *Deinterlace `json:"deinterlace,omitempty"`
	// Rotation - The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto. Possible values include: 'RotationAuto', 'RotationNone', 'RotationRotate0', 'RotationRotate90', 'RotationRotate180', 'RotationRotate270'
	Rotation Rotation `json:"rotation,omitempty"`
	// Crop - The parameters for the rectangular window with which to crop the input video.
	Crop *Rectangle `json:"crop,omitempty"`
	// Overlays - The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
	Overlays *[]BasicOverlay `json:"overlays,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Filters struct.
func (f *Filters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "deinterlace":
			if v != nil {
				var deinterlace Deinterlace
				err = json.Unmarshal(*v, &deinterlace)
				if err != nil {
					return err
				}
				f.Deinterlace = &deinterlace
			}
		case "rotation":
			if v != nil {
				var rotation Rotation
				err = json.Unmarshal(*v, &rotation)
				if err != nil {
					return err
				}
				f.Rotation = rotation
			}
		case "crop":
			if v != nil {
				var crop Rectangle
				err = json.Unmarshal(*v, &crop)
				if err != nil {
					return err
				}
				f.Crop = &crop
			}
		case "overlays":
			if v != nil {
				overlays, err := unmarshalBasicOverlayArray(*v)
				if err != nil {
					return err
				}
				f.Overlays = &overlays
			}
		}
	}

	return nil
}

// FilterTrackPropertyCondition the class to specify one track property condition.
type FilterTrackPropertyCondition struct {
	// Property - The track property type. Possible values include: 'FilterTrackPropertyTypeUnknown', 'FilterTrackPropertyTypeType', 'FilterTrackPropertyTypeName', 'FilterTrackPropertyTypeLanguage', 'FilterTrackPropertyTypeFourCC', 'FilterTrackPropertyTypeBitrate'
	Property FilterTrackPropertyType `json:"property,omitempty"`
	// Value - The track property value.
	Value *string `json:"value,omitempty"`
	// Operation - The track property condition operation. Possible values include: 'Equal', 'NotEqual'
	Operation FilterTrackPropertyCompareOperation `json:"operation,omitempty"`
}

// FilterTrackSelection representing a list of FilterTrackPropertyConditions to select a track.  The
// filters are combined using a logical AND operation.
type FilterTrackSelection struct {
	// TrackSelections - The track selections.
	TrackSelections *[]FilterTrackPropertyCondition `json:"trackSelections,omitempty"`
}

// FirstQuality filter First Quality
type FirstQuality struct {
	// Bitrate - The first quality bitrate.
	Bitrate *int32 `json:"bitrate,omitempty"`
}

// BasicFormat base class for output.
type BasicFormat interface {
	AsImageFormat() (*ImageFormat, bool)
	AsBasicImageFormat() (BasicImageFormat, bool)
	AsJpgFormat() (*JpgFormat, bool)
	AsPngFormat() (*PngFormat, bool)
	AsMultiBitrateFormat() (*MultiBitrateFormat, bool)
	AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool)
	AsMp4Format() (*Mp4Format, bool)
	AsTransportStreamFormat() (*TransportStreamFormat, bool)
	AsFormat() (*Format, bool)
}

// Format base class for output.
type Format struct {
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

func unmarshalBasicFormat(body []byte) (BasicFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaImageFormat):
		var ifVar ImageFormat
		err := json.Unmarshal(body, &ifVar)
		return ifVar, err
	case string(OdataTypeMicrosoftMediaJpgFormat):
		var jf JpgFormat
		err := json.Unmarshal(body, &jf)
		return jf, err
	case string(OdataTypeMicrosoftMediaPngFormat):
		var pf PngFormat
		err := json.Unmarshal(body, &pf)
		return pf, err
	case string(OdataTypeMicrosoftMediaMultiBitrateFormat):
		var mbf MultiBitrateFormat
		err := json.Unmarshal(body, &mbf)
		return mbf, err
	case string(OdataTypeMicrosoftMediaMp4Format):
		var m4f Mp4Format
		err := json.Unmarshal(body, &m4f)
		return m4f, err
	case string(OdataTypeMicrosoftMediaTransportStreamFormat):
		var tsf TransportStreamFormat
		err := json.Unmarshal(body, &tsf)
		return tsf, err
	default:
		var f Format
		err := json.Unmarshal(body, &f)
		return f, err
	}
}
func unmarshalBasicFormatArray(body []byte) ([]BasicFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	fArray := make([]BasicFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		f, err := unmarshalBasicFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

// MarshalJSON is the custom marshaler for Format.
func (f Format) MarshalJSON() ([]byte, error) {
	f.OdataType = OdataTypeFormat
	objectMap := make(map[string]interface{})
	if f.FilenamePattern != nil {
		objectMap["filenamePattern"] = f.FilenamePattern
	}
	if f.OdataType != "" {
		objectMap["@odata.type"] = f.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for Format.
func (f Format) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for Format.
func (f Format) AsBasicImageFormat() (BasicImageFormat, bool) {
	return nil, false
}

// AsJpgFormat is the BasicFormat implementation for Format.
func (f Format) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for Format.
func (f Format) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for Format.
func (f Format) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for Format.
func (f Format) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return nil, false
}

// AsMp4Format is the BasicFormat implementation for Format.
func (f Format) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for Format.
func (f Format) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for Format.
func (f Format) AsFormat() (*Format, bool) {
	return &f, true
}

// AsBasicFormat is the BasicFormat implementation for Format.
func (f Format) AsBasicFormat() (BasicFormat, bool) {
	return &f, true
}

// FromAllInputFile an InputDefinition that looks across all of the files provided to select tracks
// specified by the IncludedTracks property. Generally used with the AudioTrackByAttribute and
// VideoTrackByAttribute to allow selection of a single track across a set of input files.
type FromAllInputFile struct {
	// IncludedTracks - The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks *[]BasicTrackDescriptor `json:"includedTracks,omitempty"`
	// OdataType - Possible values include: 'OdataTypeInputDefinition', 'OdataTypeMicrosoftMediaFromAllInputFile', 'OdataTypeMicrosoftMediaFromEachInputFile', 'OdataTypeMicrosoftMediaInputFile'
	OdataType OdataTypeBasicInputDefinition `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for FromAllInputFile.
func (faif FromAllInputFile) MarshalJSON() ([]byte, error) {
	faif.OdataType = OdataTypeMicrosoftMediaFromAllInputFile
	objectMap := make(map[string]interface{})
	if faif.IncludedTracks != nil {
		objectMap["includedTracks"] = faif.IncludedTracks
	}
	if faif.OdataType != "" {
		objectMap["@odata.type"] = faif.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFromAllInputFile is the BasicInputDefinition implementation for FromAllInputFile.
func (faif FromAllInputFile) AsFromAllInputFile() (*FromAllInputFile, bool) {
	return &faif, true
}

// AsFromEachInputFile is the BasicInputDefinition implementation for FromAllInputFile.
func (faif FromAllInputFile) AsFromEachInputFile() (*FromEachInputFile, bool) {
	return nil, false
}

// AsInputFile is the BasicInputDefinition implementation for FromAllInputFile.
func (faif FromAllInputFile) AsInputFile() (*InputFile, bool) {
	return nil, false
}

// AsInputDefinition is the BasicInputDefinition implementation for FromAllInputFile.
func (faif FromAllInputFile) AsInputDefinition() (*InputDefinition, bool) {
	return nil, false
}

// AsBasicInputDefinition is the BasicInputDefinition implementation for FromAllInputFile.
func (faif FromAllInputFile) AsBasicInputDefinition() (BasicInputDefinition, bool) {
	return &faif, true
}

// UnmarshalJSON is the custom unmarshaler for FromAllInputFile struct.
func (faif *FromAllInputFile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "includedTracks":
			if v != nil {
				includedTracks, err := unmarshalBasicTrackDescriptorArray(*v)
				if err != nil {
					return err
				}
				faif.IncludedTracks = &includedTracks
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicInputDefinition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				faif.OdataType = odataType
			}
		}
	}

	return nil
}

// FromEachInputFile an InputDefinition that looks at each input file provided to select tracks specified
// by the IncludedTracks property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute
// to select tracks from each file given.
type FromEachInputFile struct {
	// IncludedTracks - The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks *[]BasicTrackDescriptor `json:"includedTracks,omitempty"`
	// OdataType - Possible values include: 'OdataTypeInputDefinition', 'OdataTypeMicrosoftMediaFromAllInputFile', 'OdataTypeMicrosoftMediaFromEachInputFile', 'OdataTypeMicrosoftMediaInputFile'
	OdataType OdataTypeBasicInputDefinition `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for FromEachInputFile.
func (feif FromEachInputFile) MarshalJSON() ([]byte, error) {
	feif.OdataType = OdataTypeMicrosoftMediaFromEachInputFile
	objectMap := make(map[string]interface{})
	if feif.IncludedTracks != nil {
		objectMap["includedTracks"] = feif.IncludedTracks
	}
	if feif.OdataType != "" {
		objectMap["@odata.type"] = feif.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFromAllInputFile is the BasicInputDefinition implementation for FromEachInputFile.
func (feif FromEachInputFile) AsFromAllInputFile() (*FromAllInputFile, bool) {
	return nil, false
}

// AsFromEachInputFile is the BasicInputDefinition implementation for FromEachInputFile.
func (feif FromEachInputFile) AsFromEachInputFile() (*FromEachInputFile, bool) {
	return &feif, true
}

// AsInputFile is the BasicInputDefinition implementation for FromEachInputFile.
func (feif FromEachInputFile) AsInputFile() (*InputFile, bool) {
	return nil, false
}

// AsInputDefinition is the BasicInputDefinition implementation for FromEachInputFile.
func (feif FromEachInputFile) AsInputDefinition() (*InputDefinition, bool) {
	return nil, false
}

// AsBasicInputDefinition is the BasicInputDefinition implementation for FromEachInputFile.
func (feif FromEachInputFile) AsBasicInputDefinition() (BasicInputDefinition, bool) {
	return &feif, true
}

// UnmarshalJSON is the custom unmarshaler for FromEachInputFile struct.
func (feif *FromEachInputFile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "includedTracks":
			if v != nil {
				includedTracks, err := unmarshalBasicTrackDescriptorArray(*v)
				if err != nil {
					return err
				}
				feif.IncludedTracks = &includedTracks
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicInputDefinition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				feif.OdataType = odataType
			}
		}
	}

	return nil
}

// H264Layer describes the settings to be used when encoding the input video into a desired output bitrate
// layer with the H.264 video codec.
type H264Layer struct {
	// Profile - We currently support Baseline, Main, High, High422, High444. Default is Auto. Possible values include: 'H264VideoProfileAuto', 'H264VideoProfileBaseline', 'H264VideoProfileMain', 'H264VideoProfileHigh', 'H264VideoProfileHigh422', 'H264VideoProfileHigh444'
	Profile H264VideoProfile `json:"profile,omitempty"`
	// Level - We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
	Level *string `json:"level,omitempty"`
	// BufferWindow - The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
	BufferWindow *string `json:"bufferWindow,omitempty"`
	// ReferenceFrames - The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
	ReferenceFrames *int32 `json:"referenceFrames,omitempty"`
	// EntropyMode - The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the profile and level. Possible values include: 'Cabac', 'Cavlc'
	EntropyMode EntropyMode `json:"entropyMode,omitempty"`
	// Bitrate - The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// MaxBitrate - The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`
	// BFrames - The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`
	// FrameRate - The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Slices - The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`
	// AdaptiveBFrame - Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for H264Layer.
func (hl H264Layer) MarshalJSON() ([]byte, error) {
	hl.OdataType = OdataTypeMicrosoftMediaH264Layer
	objectMap := make(map[string]interface{})
	if hl.Profile != "" {
		objectMap["profile"] = hl.Profile
	}
	if hl.Level != nil {
		objectMap["level"] = hl.Level
	}
	if hl.BufferWindow != nil {
		objectMap["bufferWindow"] = hl.BufferWindow
	}
	if hl.ReferenceFrames != nil {
		objectMap["referenceFrames"] = hl.ReferenceFrames
	}
	if hl.EntropyMode != "" {
		objectMap["entropyMode"] = hl.EntropyMode
	}
	if hl.Bitrate != nil {
		objectMap["bitrate"] = hl.Bitrate
	}
	if hl.MaxBitrate != nil {
		objectMap["maxBitrate"] = hl.MaxBitrate
	}
	if hl.BFrames != nil {
		objectMap["bFrames"] = hl.BFrames
	}
	if hl.FrameRate != nil {
		objectMap["frameRate"] = hl.FrameRate
	}
	if hl.Slices != nil {
		objectMap["slices"] = hl.Slices
	}
	if hl.AdaptiveBFrame != nil {
		objectMap["adaptiveBFrame"] = hl.AdaptiveBFrame
	}
	if hl.Width != nil {
		objectMap["width"] = hl.Width
	}
	if hl.Height != nil {
		objectMap["height"] = hl.Height
	}
	if hl.Label != nil {
		objectMap["label"] = hl.Label
	}
	if hl.OdataType != "" {
		objectMap["@odata.type"] = hl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return nil, false
}

// AsH265Layer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return &hl, true
}

// AsH264Layer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsH264Layer() (*H264Layer, bool) {
	return &hl, true
}

// AsJpgLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for H264Layer.
func (hl H264Layer) AsBasicLayer() (BasicLayer, bool) {
	return &hl, true
}

// H264Video describes all the properties for encoding a video with the H.264 codec.
type H264Video struct {
	// SceneChangeDetection - Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
	SceneChangeDetection *bool `json:"sceneChangeDetection,omitempty"`
	// Complexity - Tells the encoder how to choose its encoding settings. The default value is Balanced. Possible values include: 'Speed', 'Balanced', 'Quality'
	Complexity H264Complexity `json:"complexity,omitempty"`
	// Layers - The collection of output H.264 layers to be produced by the encoder.
	Layers *[]H264Layer `json:"layers,omitempty"`
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for H264Video.
func (hv H264Video) MarshalJSON() ([]byte, error) {
	hv.OdataType = OdataTypeMicrosoftMediaH264Video
	objectMap := make(map[string]interface{})
	if hv.SceneChangeDetection != nil {
		objectMap["sceneChangeDetection"] = hv.SceneChangeDetection
	}
	if hv.Complexity != "" {
		objectMap["complexity"] = hv.Complexity
	}
	if hv.Layers != nil {
		objectMap["layers"] = hv.Layers
	}
	if hv.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = hv.KeyFrameInterval
	}
	if hv.StretchMode != "" {
		objectMap["stretchMode"] = hv.StretchMode
	}
	if hv.SyncMode != "" {
		objectMap["syncMode"] = hv.SyncMode
	}
	if hv.Label != nil {
		objectMap["label"] = hv.Label
	}
	if hv.OdataType != "" {
		objectMap["@odata.type"] = hv.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for H264Video.
func (hv H264Video) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for H264Video.
func (hv H264Video) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for H264Video.
func (hv H264Video) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for H264Video.
func (hv H264Video) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for H264Video.
func (hv H264Video) AsBasicVideo() (BasicVideo, bool) {
	return &hv, true
}

// AsH265Video is the BasicCodec implementation for H264Video.
func (hv H264Video) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for H264Video.
func (hv H264Video) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for H264Video.
func (hv H264Video) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for H264Video.
func (hv H264Video) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for H264Video.
func (hv H264Video) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for H264Video.
func (hv H264Video) AsH264Video() (*H264Video, bool) {
	return &hv, true
}

// AsJpgImage is the BasicCodec implementation for H264Video.
func (hv H264Video) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for H264Video.
func (hv H264Video) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for H264Video.
func (hv H264Video) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for H264Video.
func (hv H264Video) AsBasicCodec() (BasicCodec, bool) {
	return &hv, true
}

// H265Layer describes the settings to be used when encoding the input video into a desired output bitrate
// layer with the H.265 video codec.
type H265Layer struct {
	// Profile - We currently support Main. Default is Auto. Possible values include: 'H265VideoProfileAuto', 'H265VideoProfileMain'
	Profile H265VideoProfile `json:"profile,omitempty"`
	// Level - We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified, the default is Auto, which lets the encoder choose the Level that is appropriate for this layer.
	Level *string `json:"level,omitempty"`
	// BufferWindow - The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds. The default is 5 seconds (for example, PT5S).
	BufferWindow *string `json:"bufferWindow,omitempty"`
	// ReferenceFrames - The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate number based on the encoder complexity setting.
	ReferenceFrames *int32 `json:"referenceFrames,omitempty"`
	// Bitrate - The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// MaxBitrate - The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`
	// BFrames - The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`
	// FrameRate - The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Slices - The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`
	// AdaptiveBFrame - Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for H265Layer.
func (hl H265Layer) MarshalJSON() ([]byte, error) {
	hl.OdataType = OdataTypeMicrosoftMediaH265Layer
	objectMap := make(map[string]interface{})
	if hl.Profile != "" {
		objectMap["profile"] = hl.Profile
	}
	if hl.Level != nil {
		objectMap["level"] = hl.Level
	}
	if hl.BufferWindow != nil {
		objectMap["bufferWindow"] = hl.BufferWindow
	}
	if hl.ReferenceFrames != nil {
		objectMap["referenceFrames"] = hl.ReferenceFrames
	}
	if hl.Bitrate != nil {
		objectMap["bitrate"] = hl.Bitrate
	}
	if hl.MaxBitrate != nil {
		objectMap["maxBitrate"] = hl.MaxBitrate
	}
	if hl.BFrames != nil {
		objectMap["bFrames"] = hl.BFrames
	}
	if hl.FrameRate != nil {
		objectMap["frameRate"] = hl.FrameRate
	}
	if hl.Slices != nil {
		objectMap["slices"] = hl.Slices
	}
	if hl.AdaptiveBFrame != nil {
		objectMap["adaptiveBFrame"] = hl.AdaptiveBFrame
	}
	if hl.Width != nil {
		objectMap["width"] = hl.Width
	}
	if hl.Height != nil {
		objectMap["height"] = hl.Height
	}
	if hl.Label != nil {
		objectMap["label"] = hl.Label
	}
	if hl.OdataType != "" {
		objectMap["@odata.type"] = hl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return &hl, true
}

// AsH265Layer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsH265Layer() (*H265Layer, bool) {
	return &hl, true
}

// AsVideoLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return nil, false
}

// AsH264Layer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for H265Layer.
func (hl H265Layer) AsBasicLayer() (BasicLayer, bool) {
	return &hl, true
}

// H265Video describes all the properties for encoding a video with the H.265 codec.
type H265Video struct {
	// SceneChangeDetection - Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag should be set to true only when the encoder is being configured to produce a single output video.
	SceneChangeDetection *bool `json:"sceneChangeDetection,omitempty"`
	// Complexity - Tells the encoder how to choose its encoding settings.  Quality will provide for a higher compression ratio but at a higher cost and longer compute time.  Speed will produce a relatively larger file but is faster and more economical. The default value is Balanced. Possible values include: 'H265ComplexitySpeed', 'H265ComplexityBalanced', 'H265ComplexityQuality'
	Complexity H265Complexity `json:"complexity,omitempty"`
	// Layers - The collection of output H.265 layers to be produced by the encoder.
	Layers *[]H265Layer `json:"layers,omitempty"`
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for H265Video.
func (hv H265Video) MarshalJSON() ([]byte, error) {
	hv.OdataType = OdataTypeMicrosoftMediaH265Video
	objectMap := make(map[string]interface{})
	if hv.SceneChangeDetection != nil {
		objectMap["sceneChangeDetection"] = hv.SceneChangeDetection
	}
	if hv.Complexity != "" {
		objectMap["complexity"] = hv.Complexity
	}
	if hv.Layers != nil {
		objectMap["layers"] = hv.Layers
	}
	if hv.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = hv.KeyFrameInterval
	}
	if hv.StretchMode != "" {
		objectMap["stretchMode"] = hv.StretchMode
	}
	if hv.SyncMode != "" {
		objectMap["syncMode"] = hv.SyncMode
	}
	if hv.Label != nil {
		objectMap["label"] = hv.Label
	}
	if hv.OdataType != "" {
		objectMap["@odata.type"] = hv.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for H265Video.
func (hv H265Video) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for H265Video.
func (hv H265Video) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for H265Video.
func (hv H265Video) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for H265Video.
func (hv H265Video) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for H265Video.
func (hv H265Video) AsBasicVideo() (BasicVideo, bool) {
	return &hv, true
}

// AsH265Video is the BasicCodec implementation for H265Video.
func (hv H265Video) AsH265Video() (*H265Video, bool) {
	return &hv, true
}

// AsCopyVideo is the BasicCodec implementation for H265Video.
func (hv H265Video) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for H265Video.
func (hv H265Video) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for H265Video.
func (hv H265Video) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for H265Video.
func (hv H265Video) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for H265Video.
func (hv H265Video) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for H265Video.
func (hv H265Video) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for H265Video.
func (hv H265Video) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for H265Video.
func (hv H265Video) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for H265Video.
func (hv H265Video) AsBasicCodec() (BasicCodec, bool) {
	return &hv, true
}

// BasicH265VideoLayer describes the settings to be used when encoding the input video into a desired output bitrate
// layer.
type BasicH265VideoLayer interface {
	AsH265Layer() (*H265Layer, bool)
	AsH265VideoLayer() (*H265VideoLayer, bool)
}

// H265VideoLayer describes the settings to be used when encoding the input video into a desired output bitrate
// layer.
type H265VideoLayer struct {
	// Bitrate - The average bitrate in bits per second at which to encode the input video when generating this layer. For example: a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// MaxBitrate - The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`
	// BFrames - The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`
	// FrameRate - The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Slices - The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`
	// AdaptiveBFrame - Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

func unmarshalBasicH265VideoLayer(body []byte) (BasicH265VideoLayer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaH265Layer):
		var hl H265Layer
		err := json.Unmarshal(body, &hl)
		return hl, err
	default:
		var hvl H265VideoLayer
		err := json.Unmarshal(body, &hvl)
		return hvl, err
	}
}
func unmarshalBasicH265VideoLayerArray(body []byte) ([]BasicH265VideoLayer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	hvlArray := make([]BasicH265VideoLayer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		hvl, err := unmarshalBasicH265VideoLayer(*rawMessage)
		if err != nil {
			return nil, err
		}
		hvlArray[index] = hvl
	}
	return hvlArray, nil
}

// MarshalJSON is the custom marshaler for H265VideoLayer.
func (hvl H265VideoLayer) MarshalJSON() ([]byte, error) {
	hvl.OdataType = OdataTypeMicrosoftMediaH265VideoLayer
	objectMap := make(map[string]interface{})
	if hvl.Bitrate != nil {
		objectMap["bitrate"] = hvl.Bitrate
	}
	if hvl.MaxBitrate != nil {
		objectMap["maxBitrate"] = hvl.MaxBitrate
	}
	if hvl.BFrames != nil {
		objectMap["bFrames"] = hvl.BFrames
	}
	if hvl.FrameRate != nil {
		objectMap["frameRate"] = hvl.FrameRate
	}
	if hvl.Slices != nil {
		objectMap["slices"] = hvl.Slices
	}
	if hvl.AdaptiveBFrame != nil {
		objectMap["adaptiveBFrame"] = hvl.AdaptiveBFrame
	}
	if hvl.Width != nil {
		objectMap["width"] = hvl.Width
	}
	if hvl.Height != nil {
		objectMap["height"] = hvl.Height
	}
	if hvl.Label != nil {
		objectMap["label"] = hvl.Label
	}
	if hvl.OdataType != "" {
		objectMap["@odata.type"] = hvl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return &hvl, true
}

// AsBasicH265VideoLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return &hvl, true
}

// AsH265Layer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return nil, false
}

// AsH264Layer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for H265VideoLayer.
func (hvl H265VideoLayer) AsBasicLayer() (BasicLayer, bool) {
	return &hvl, true
}

// Hls HTTP Live Streaming (HLS) packing setting for the live output.
type Hls struct {
	// FragmentsPerTsSegment - The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not affect the packing ratio for HLS CMAF output.
	FragmentsPerTsSegment *int32 `json:"fragmentsPerTsSegment,omitempty"`
}

// BasicImage describes the basic properties for generating thumbnails from the input video
type BasicImage interface {
	AsJpgImage() (*JpgImage, bool)
	AsPngImage() (*PngImage, bool)
	AsImage() (*Image, bool)
}

// Image describes the basic properties for generating thumbnails from the input video
type Image struct {
	// Start - The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`
	// Step - The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`
	// Range - The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

func unmarshalBasicImage(body []byte) (BasicImage, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJpgImage):
		var ji JpgImage
		err := json.Unmarshal(body, &ji)
		return ji, err
	case string(OdataTypeMicrosoftMediaPngImage):
		var pi PngImage
		err := json.Unmarshal(body, &pi)
		return pi, err
	default:
		var i Image
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicImageArray(body []byte) ([]BasicImage, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicImage, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicImage(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Image.
func (i Image) MarshalJSON() ([]byte, error) {
	i.OdataType = OdataTypeMicrosoftMediaImage
	objectMap := make(map[string]interface{})
	if i.Start != nil {
		objectMap["start"] = i.Start
	}
	if i.Step != nil {
		objectMap["step"] = i.Step
	}
	if i.Range != nil {
		objectMap["range"] = i.Range
	}
	if i.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = i.KeyFrameInterval
	}
	if i.StretchMode != "" {
		objectMap["stretchMode"] = i.StretchMode
	}
	if i.SyncMode != "" {
		objectMap["syncMode"] = i.SyncMode
	}
	if i.Label != nil {
		objectMap["label"] = i.Label
	}
	if i.OdataType != "" {
		objectMap["@odata.type"] = i.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for Image.
func (i Image) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for Image.
func (i Image) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for Image.
func (i Image) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for Image.
func (i Image) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for Image.
func (i Image) AsBasicVideo() (BasicVideo, bool) {
	return &i, true
}

// AsH265Video is the BasicCodec implementation for Image.
func (i Image) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for Image.
func (i Image) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for Image.
func (i Image) AsImage() (*Image, bool) {
	return &i, true
}

// AsBasicImage is the BasicCodec implementation for Image.
func (i Image) AsBasicImage() (BasicImage, bool) {
	return &i, true
}

// AsCopyAudio is the BasicCodec implementation for Image.
func (i Image) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for Image.
func (i Image) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for Image.
func (i Image) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for Image.
func (i Image) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for Image.
func (i Image) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for Image.
func (i Image) AsBasicCodec() (BasicCodec, bool) {
	return &i, true
}

// BasicImageFormat describes the properties for an output image file.
type BasicImageFormat interface {
	AsJpgFormat() (*JpgFormat, bool)
	AsPngFormat() (*PngFormat, bool)
	AsImageFormat() (*ImageFormat, bool)
}

// ImageFormat describes the properties for an output image file.
type ImageFormat struct {
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

func unmarshalBasicImageFormat(body []byte) (BasicImageFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJpgFormat):
		var jf JpgFormat
		err := json.Unmarshal(body, &jf)
		return jf, err
	case string(OdataTypeMicrosoftMediaPngFormat):
		var pf PngFormat
		err := json.Unmarshal(body, &pf)
		return pf, err
	default:
		var ifVar ImageFormat
		err := json.Unmarshal(body, &ifVar)
		return ifVar, err
	}
}
func unmarshalBasicImageFormatArray(body []byte) ([]BasicImageFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ifVarArray := make([]BasicImageFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ifVar, err := unmarshalBasicImageFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		ifVarArray[index] = ifVar
	}
	return ifVarArray, nil
}

// MarshalJSON is the custom marshaler for ImageFormat.
func (ifVar ImageFormat) MarshalJSON() ([]byte, error) {
	ifVar.OdataType = OdataTypeMicrosoftMediaImageFormat
	objectMap := make(map[string]interface{})
	if ifVar.FilenamePattern != nil {
		objectMap["filenamePattern"] = ifVar.FilenamePattern
	}
	if ifVar.OdataType != "" {
		objectMap["@odata.type"] = ifVar.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsImageFormat() (*ImageFormat, bool) {
	return &ifVar, true
}

// AsBasicImageFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsBasicImageFormat() (BasicImageFormat, bool) {
	return &ifVar, true
}

// AsJpgFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return nil, false
}

// AsMp4Format is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for ImageFormat.
func (ifVar ImageFormat) AsBasicFormat() (BasicFormat, bool) {
	return &ifVar, true
}

// BasicInputDefinition base class for defining an input. Use sub classes of this class to specify tracks selections
// and related metadata.
type BasicInputDefinition interface {
	AsFromAllInputFile() (*FromAllInputFile, bool)
	AsFromEachInputFile() (*FromEachInputFile, bool)
	AsInputFile() (*InputFile, bool)
	AsInputDefinition() (*InputDefinition, bool)
}

// InputDefinition base class for defining an input. Use sub classes of this class to specify tracks selections
// and related metadata.
type InputDefinition struct {
	// IncludedTracks - The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks *[]BasicTrackDescriptor `json:"includedTracks,omitempty"`
	// OdataType - Possible values include: 'OdataTypeInputDefinition', 'OdataTypeMicrosoftMediaFromAllInputFile', 'OdataTypeMicrosoftMediaFromEachInputFile', 'OdataTypeMicrosoftMediaInputFile'
	OdataType OdataTypeBasicInputDefinition `json:"@odata.type,omitempty"`
}

func unmarshalBasicInputDefinition(body []byte) (BasicInputDefinition, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaFromAllInputFile):
		var faif FromAllInputFile
		err := json.Unmarshal(body, &faif)
		return faif, err
	case string(OdataTypeMicrosoftMediaFromEachInputFile):
		var feif FromEachInputFile
		err := json.Unmarshal(body, &feif)
		return feif, err
	case string(OdataTypeMicrosoftMediaInputFile):
		var ifVar InputFile
		err := json.Unmarshal(body, &ifVar)
		return ifVar, err
	default:
		var ID InputDefinition
		err := json.Unmarshal(body, &ID)
		return ID, err
	}
}
func unmarshalBasicInputDefinitionArray(body []byte) ([]BasicInputDefinition, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	IDArray := make([]BasicInputDefinition, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ID, err := unmarshalBasicInputDefinition(*rawMessage)
		if err != nil {
			return nil, err
		}
		IDArray[index] = ID
	}
	return IDArray, nil
}

// MarshalJSON is the custom marshaler for InputDefinition.
func (ID InputDefinition) MarshalJSON() ([]byte, error) {
	ID.OdataType = OdataTypeInputDefinition
	objectMap := make(map[string]interface{})
	if ID.IncludedTracks != nil {
		objectMap["includedTracks"] = ID.IncludedTracks
	}
	if ID.OdataType != "" {
		objectMap["@odata.type"] = ID.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFromAllInputFile is the BasicInputDefinition implementation for InputDefinition.
func (ID InputDefinition) AsFromAllInputFile() (*FromAllInputFile, bool) {
	return nil, false
}

// AsFromEachInputFile is the BasicInputDefinition implementation for InputDefinition.
func (ID InputDefinition) AsFromEachInputFile() (*FromEachInputFile, bool) {
	return nil, false
}

// AsInputFile is the BasicInputDefinition implementation for InputDefinition.
func (ID InputDefinition) AsInputFile() (*InputFile, bool) {
	return nil, false
}

// AsInputDefinition is the BasicInputDefinition implementation for InputDefinition.
func (ID InputDefinition) AsInputDefinition() (*InputDefinition, bool) {
	return &ID, true
}

// AsBasicInputDefinition is the BasicInputDefinition implementation for InputDefinition.
func (ID InputDefinition) AsBasicInputDefinition() (BasicInputDefinition, bool) {
	return &ID, true
}

// UnmarshalJSON is the custom unmarshaler for InputDefinition struct.
func (ID *InputDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "includedTracks":
			if v != nil {
				includedTracks, err := unmarshalBasicTrackDescriptorArray(*v)
				if err != nil {
					return err
				}
				ID.IncludedTracks = &includedTracks
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicInputDefinition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ID.OdataType = odataType
			}
		}
	}

	return nil
}

// InputFile an InputDefinition for a single file.  TrackSelections are scoped to the file specified.
type InputFile struct {
	// Filename - Name of the file that this input definition applies to.
	Filename *string `json:"filename,omitempty"`
	// IncludedTracks - The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks *[]BasicTrackDescriptor `json:"includedTracks,omitempty"`
	// OdataType - Possible values include: 'OdataTypeInputDefinition', 'OdataTypeMicrosoftMediaFromAllInputFile', 'OdataTypeMicrosoftMediaFromEachInputFile', 'OdataTypeMicrosoftMediaInputFile'
	OdataType OdataTypeBasicInputDefinition `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for InputFile.
func (ifVar InputFile) MarshalJSON() ([]byte, error) {
	ifVar.OdataType = OdataTypeMicrosoftMediaInputFile
	objectMap := make(map[string]interface{})
	if ifVar.Filename != nil {
		objectMap["filename"] = ifVar.Filename
	}
	if ifVar.IncludedTracks != nil {
		objectMap["includedTracks"] = ifVar.IncludedTracks
	}
	if ifVar.OdataType != "" {
		objectMap["@odata.type"] = ifVar.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFromAllInputFile is the BasicInputDefinition implementation for InputFile.
func (ifVar InputFile) AsFromAllInputFile() (*FromAllInputFile, bool) {
	return nil, false
}

// AsFromEachInputFile is the BasicInputDefinition implementation for InputFile.
func (ifVar InputFile) AsFromEachInputFile() (*FromEachInputFile, bool) {
	return nil, false
}

// AsInputFile is the BasicInputDefinition implementation for InputFile.
func (ifVar InputFile) AsInputFile() (*InputFile, bool) {
	return &ifVar, true
}

// AsInputDefinition is the BasicInputDefinition implementation for InputFile.
func (ifVar InputFile) AsInputDefinition() (*InputDefinition, bool) {
	return nil, false
}

// AsBasicInputDefinition is the BasicInputDefinition implementation for InputFile.
func (ifVar InputFile) AsBasicInputDefinition() (BasicInputDefinition, bool) {
	return &ifVar, true
}

// UnmarshalJSON is the custom unmarshaler for InputFile struct.
func (ifVar *InputFile) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "filename":
			if v != nil {
				var filename string
				err = json.Unmarshal(*v, &filename)
				if err != nil {
					return err
				}
				ifVar.Filename = &filename
			}
		case "includedTracks":
			if v != nil {
				includedTracks, err := unmarshalBasicTrackDescriptorArray(*v)
				if err != nil {
					return err
				}
				ifVar.IncludedTracks = &includedTracks
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicInputDefinition
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ifVar.OdataType = odataType
			}
		}
	}

	return nil
}

// IPAccessControl the IP access control.
type IPAccessControl struct {
	// Allow - The IP allow list.
	Allow *[]IPRange `json:"allow,omitempty"`
}

// IPRange the IP address range in the CIDR scheme.
type IPRange struct {
	// Name - The friendly name for the IP address range.
	Name *string `json:"name,omitempty"`
	// Address - The IP address.
	Address *string `json:"address,omitempty"`
	// SubnetPrefixLength - The subnet mask prefix length (see CIDR notation).
	SubnetPrefixLength *int32 `json:"subnetPrefixLength,omitempty"`
}

// Job a Job resource type. The progress and state can be obtained by polling a Job or subscribing to
// events using EventGrid.
type Job struct {
	autorest.Response `json:"-"`
	// JobProperties - The resource properties.
	*JobProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if j.JobProperties != nil {
		objectMap["properties"] = j.JobProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Job struct.
func (j *Job) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var jobProperties JobProperties
				err = json.Unmarshal(*v, &jobProperties)
				if err != nil {
					return err
				}
				j.JobProperties = &jobProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				j.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				j.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				j.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				j.Type = &typeVar
			}
		}
	}

	return nil
}

// JobCollection a collection of Job items.
type JobCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Job items.
	Value *[]Job `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// JobCollectionIterator provides access to a complete listing of Job values.
type JobCollectionIterator struct {
	i    int
	page JobCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobCollectionIterator) Response() JobCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobCollectionIterator) Value() Job {
	if !iter.page.NotDone() {
		return Job{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobCollectionIterator type.
func NewJobCollectionIterator(page JobCollectionPage) JobCollectionIterator {
	return JobCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jc JobCollection) IsEmpty() bool {
	return jc.Value == nil || len(*jc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jc JobCollection) hasNextLink() bool {
	return jc.OdataNextLink != nil && len(*jc.OdataNextLink) != 0
}

// jobCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jc JobCollection) jobCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !jc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jc.OdataNextLink)))
}

// JobCollectionPage contains a page of Job values.
type JobCollectionPage struct {
	fn func(context.Context, JobCollection) (JobCollection, error)
	jc JobCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jc)
		if err != nil {
			return err
		}
		page.jc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobCollectionPage) NotDone() bool {
	return !page.jc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobCollectionPage) Response() JobCollection {
	return page.jc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobCollectionPage) Values() []Job {
	if page.jc.IsEmpty() {
		return nil
	}
	return *page.jc.Value
}

// Creates a new instance of the JobCollectionPage type.
func NewJobCollectionPage(cur JobCollection, getNextPage func(context.Context, JobCollection) (JobCollection, error)) JobCollectionPage {
	return JobCollectionPage{
		fn: getNextPage,
		jc: cur,
	}
}

// JobError details of JobOutput errors.
type JobError struct {
	// Code - READ-ONLY; Error code describing the error. Possible values include: 'ServiceError', 'ServiceTransientError', 'DownloadNotAccessible', 'DownloadTransientError', 'UploadNotAccessible', 'UploadTransientError', 'ConfigurationUnsupported', 'ContentMalformed', 'ContentUnsupported'
	Code JobErrorCode `json:"code,omitempty"`
	// Message - READ-ONLY; A human-readable language-dependent representation of the error.
	Message *string `json:"message,omitempty"`
	// Category - READ-ONLY; Helps with categorization of errors. Possible values include: 'JobErrorCategoryService', 'JobErrorCategoryDownload', 'JobErrorCategoryUpload', 'JobErrorCategoryConfiguration', 'JobErrorCategoryContent'
	Category JobErrorCategory `json:"category,omitempty"`
	// Retry - READ-ONLY; Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via Azure Portal. Possible values include: 'DoNotRetry', 'MayRetry'
	Retry JobRetry `json:"retry,omitempty"`
	// Details - READ-ONLY; An array of details about specific errors that led to this reported error.
	Details *[]JobErrorDetail `json:"details,omitempty"`
}

// JobErrorDetail details of JobOutput errors.
type JobErrorDetail struct {
	// Code - READ-ONLY; Code describing the error detail.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// BasicJobInput base class for inputs to a Job.
type BasicJobInput interface {
	AsJobInputClip() (*JobInputClip, bool)
	AsBasicJobInputClip() (BasicJobInputClip, bool)
	AsJobInputs() (*JobInputs, bool)
	AsJobInputAsset() (*JobInputAsset, bool)
	AsJobInputHTTP() (*JobInputHTTP, bool)
	AsJobInputSequence() (*JobInputSequence, bool)
	AsJobInput() (*JobInput, bool)
}

// JobInput base class for inputs to a Job.
type JobInput struct {
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

func unmarshalBasicJobInput(body []byte) (BasicJobInput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJobInputClip):
		var jic JobInputClip
		err := json.Unmarshal(body, &jic)
		return jic, err
	case string(OdataTypeMicrosoftMediaJobInputs):
		var ji JobInputs
		err := json.Unmarshal(body, &ji)
		return ji, err
	case string(OdataTypeMicrosoftMediaJobInputAsset):
		var jia JobInputAsset
		err := json.Unmarshal(body, &jia)
		return jia, err
	case string(OdataTypeMicrosoftMediaJobInputHTTP):
		var jih JobInputHTTP
		err := json.Unmarshal(body, &jih)
		return jih, err
	case string(OdataTypeMicrosoftMediaJobInputSequence):
		var jis JobInputSequence
		err := json.Unmarshal(body, &jis)
		return jis, err
	default:
		var ji JobInput
		err := json.Unmarshal(body, &ji)
		return ji, err
	}
}
func unmarshalBasicJobInputArray(body []byte) ([]BasicJobInput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jiArray := make([]BasicJobInput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ji, err := unmarshalBasicJobInput(*rawMessage)
		if err != nil {
			return nil, err
		}
		jiArray[index] = ji
	}
	return jiArray, nil
}

// MarshalJSON is the custom marshaler for JobInput.
func (ji JobInput) MarshalJSON() ([]byte, error) {
	ji.OdataType = OdataTypeJobInput
	objectMap := make(map[string]interface{})
	if ji.OdataType != "" {
		objectMap["@odata.type"] = ji.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInputClip() (*JobInputClip, bool) {
	return nil, false
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return nil, false
}

// AsJobInputs is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInputs() (*JobInputs, bool) {
	return nil, false
}

// AsJobInputAsset is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInputAsset() (*JobInputAsset, bool) {
	return nil, false
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return nil, false
}

// AsJobInputSequence is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInputSequence() (*JobInputSequence, bool) {
	return nil, false
}

// AsJobInput is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsJobInput() (*JobInput, bool) {
	return &ji, true
}

// AsBasicJobInput is the BasicJobInput implementation for JobInput.
func (ji JobInput) AsBasicJobInput() (BasicJobInput, bool) {
	return &ji, true
}

// JobInputAsset represents an Asset for input into a Job.
type JobInputAsset struct {
	// AssetName - The name of the input Asset.
	AssetName *string `json:"assetName,omitempty"`
	// Files - List of files. Required for JobInputHttp. Maximum of 4000 characters each.
	Files *[]string `json:"files,omitempty"`
	// Start - Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
	Start BasicClipTime `json:"start,omitempty"`
	// End - Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End BasicClipTime `json:"end,omitempty"`
	// Label - A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`
	// InputDefinitions - Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions *[]BasicInputDefinition `json:"inputDefinitions,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobInputAsset.
func (jia JobInputAsset) MarshalJSON() ([]byte, error) {
	jia.OdataType = OdataTypeMicrosoftMediaJobInputAsset
	objectMap := make(map[string]interface{})
	if jia.AssetName != nil {
		objectMap["assetName"] = jia.AssetName
	}
	if jia.Files != nil {
		objectMap["files"] = jia.Files
	}
	objectMap["start"] = jia.Start
	objectMap["end"] = jia.End
	if jia.Label != nil {
		objectMap["label"] = jia.Label
	}
	if jia.InputDefinitions != nil {
		objectMap["inputDefinitions"] = jia.InputDefinitions
	}
	if jia.OdataType != "" {
		objectMap["@odata.type"] = jia.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInputClip() (*JobInputClip, bool) {
	return nil, false
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return &jia, true
}

// AsJobInputs is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInputs() (*JobInputs, bool) {
	return nil, false
}

// AsJobInputAsset is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInputAsset() (*JobInputAsset, bool) {
	return &jia, true
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return nil, false
}

// AsJobInputSequence is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInputSequence() (*JobInputSequence, bool) {
	return nil, false
}

// AsJobInput is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsJobInput() (*JobInput, bool) {
	return nil, false
}

// AsBasicJobInput is the BasicJobInput implementation for JobInputAsset.
func (jia JobInputAsset) AsBasicJobInput() (BasicJobInput, bool) {
	return &jia, true
}

// UnmarshalJSON is the custom unmarshaler for JobInputAsset struct.
func (jia *JobInputAsset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "assetName":
			if v != nil {
				var assetName string
				err = json.Unmarshal(*v, &assetName)
				if err != nil {
					return err
				}
				jia.AssetName = &assetName
			}
		case "files":
			if v != nil {
				var files []string
				err = json.Unmarshal(*v, &files)
				if err != nil {
					return err
				}
				jia.Files = &files
			}
		case "start":
			if v != nil {
				start, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jia.Start = start
			}
		case "end":
			if v != nil {
				end, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jia.End = end
			}
		case "label":
			if v != nil {
				var label string
				err = json.Unmarshal(*v, &label)
				if err != nil {
					return err
				}
				jia.Label = &label
			}
		case "inputDefinitions":
			if v != nil {
				inputDefinitions, err := unmarshalBasicInputDefinitionArray(*v)
				if err != nil {
					return err
				}
				jia.InputDefinitions = &inputDefinitions
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicJobInput
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				jia.OdataType = odataType
			}
		}
	}

	return nil
}

// BasicJobInputClip represents input files for a Job.
type BasicJobInputClip interface {
	AsJobInputAsset() (*JobInputAsset, bool)
	AsJobInputHTTP() (*JobInputHTTP, bool)
	AsJobInputClip() (*JobInputClip, bool)
}

// JobInputClip represents input files for a Job.
type JobInputClip struct {
	// Files - List of files. Required for JobInputHttp. Maximum of 4000 characters each.
	Files *[]string `json:"files,omitempty"`
	// Start - Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
	Start BasicClipTime `json:"start,omitempty"`
	// End - Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End BasicClipTime `json:"end,omitempty"`
	// Label - A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`
	// InputDefinitions - Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions *[]BasicInputDefinition `json:"inputDefinitions,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

func unmarshalBasicJobInputClip(body []byte) (BasicJobInputClip, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJobInputAsset):
		var jia JobInputAsset
		err := json.Unmarshal(body, &jia)
		return jia, err
	case string(OdataTypeMicrosoftMediaJobInputHTTP):
		var jih JobInputHTTP
		err := json.Unmarshal(body, &jih)
		return jih, err
	default:
		var jic JobInputClip
		err := json.Unmarshal(body, &jic)
		return jic, err
	}
}
func unmarshalBasicJobInputClipArray(body []byte) ([]BasicJobInputClip, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jicArray := make([]BasicJobInputClip, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jic, err := unmarshalBasicJobInputClip(*rawMessage)
		if err != nil {
			return nil, err
		}
		jicArray[index] = jic
	}
	return jicArray, nil
}

// MarshalJSON is the custom marshaler for JobInputClip.
func (jic JobInputClip) MarshalJSON() ([]byte, error) {
	jic.OdataType = OdataTypeMicrosoftMediaJobInputClip
	objectMap := make(map[string]interface{})
	if jic.Files != nil {
		objectMap["files"] = jic.Files
	}
	objectMap["start"] = jic.Start
	objectMap["end"] = jic.End
	if jic.Label != nil {
		objectMap["label"] = jic.Label
	}
	if jic.InputDefinitions != nil {
		objectMap["inputDefinitions"] = jic.InputDefinitions
	}
	if jic.OdataType != "" {
		objectMap["@odata.type"] = jic.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInputClip() (*JobInputClip, bool) {
	return &jic, true
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return &jic, true
}

// AsJobInputs is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInputs() (*JobInputs, bool) {
	return nil, false
}

// AsJobInputAsset is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInputAsset() (*JobInputAsset, bool) {
	return nil, false
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return nil, false
}

// AsJobInputSequence is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInputSequence() (*JobInputSequence, bool) {
	return nil, false
}

// AsJobInput is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsJobInput() (*JobInput, bool) {
	return nil, false
}

// AsBasicJobInput is the BasicJobInput implementation for JobInputClip.
func (jic JobInputClip) AsBasicJobInput() (BasicJobInput, bool) {
	return &jic, true
}

// UnmarshalJSON is the custom unmarshaler for JobInputClip struct.
func (jic *JobInputClip) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "files":
			if v != nil {
				var files []string
				err = json.Unmarshal(*v, &files)
				if err != nil {
					return err
				}
				jic.Files = &files
			}
		case "start":
			if v != nil {
				start, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jic.Start = start
			}
		case "end":
			if v != nil {
				end, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jic.End = end
			}
		case "label":
			if v != nil {
				var label string
				err = json.Unmarshal(*v, &label)
				if err != nil {
					return err
				}
				jic.Label = &label
			}
		case "inputDefinitions":
			if v != nil {
				inputDefinitions, err := unmarshalBasicInputDefinitionArray(*v)
				if err != nil {
					return err
				}
				jic.InputDefinitions = &inputDefinitions
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicJobInput
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				jic.OdataType = odataType
			}
		}
	}

	return nil
}

// JobInputHTTP represents HTTPS job input.
type JobInputHTTP struct {
	// BaseURI - Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided file list is assumed to be fully qualified uris. Maximum length of 4000 characters.
	BaseURI *string `json:"baseUri,omitempty"`
	// Files - List of files. Required for JobInputHttp. Maximum of 4000 characters each.
	Files *[]string `json:"files,omitempty"`
	// Start - Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input media.
	Start BasicClipTime `json:"start,omitempty"`
	// End - Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End BasicClipTime `json:"end,omitempty"`
	// Label - A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform can be authored so as to take an image file with the label 'xyz' and apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should be the image file, and it should have the label 'xyz'.
	Label *string `json:"label,omitempty"`
	// InputDefinitions - Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions *[]BasicInputDefinition `json:"inputDefinitions,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobInputHTTP.
func (jih JobInputHTTP) MarshalJSON() ([]byte, error) {
	jih.OdataType = OdataTypeMicrosoftMediaJobInputHTTP
	objectMap := make(map[string]interface{})
	if jih.BaseURI != nil {
		objectMap["baseUri"] = jih.BaseURI
	}
	if jih.Files != nil {
		objectMap["files"] = jih.Files
	}
	objectMap["start"] = jih.Start
	objectMap["end"] = jih.End
	if jih.Label != nil {
		objectMap["label"] = jih.Label
	}
	if jih.InputDefinitions != nil {
		objectMap["inputDefinitions"] = jih.InputDefinitions
	}
	if jih.OdataType != "" {
		objectMap["@odata.type"] = jih.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInputClip() (*JobInputClip, bool) {
	return nil, false
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return &jih, true
}

// AsJobInputs is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInputs() (*JobInputs, bool) {
	return nil, false
}

// AsJobInputAsset is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInputAsset() (*JobInputAsset, bool) {
	return nil, false
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return &jih, true
}

// AsJobInputSequence is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInputSequence() (*JobInputSequence, bool) {
	return nil, false
}

// AsJobInput is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsJobInput() (*JobInput, bool) {
	return nil, false
}

// AsBasicJobInput is the BasicJobInput implementation for JobInputHTTP.
func (jih JobInputHTTP) AsBasicJobInput() (BasicJobInput, bool) {
	return &jih, true
}

// UnmarshalJSON is the custom unmarshaler for JobInputHTTP struct.
func (jih *JobInputHTTP) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "baseUri":
			if v != nil {
				var baseURI string
				err = json.Unmarshal(*v, &baseURI)
				if err != nil {
					return err
				}
				jih.BaseURI = &baseURI
			}
		case "files":
			if v != nil {
				var files []string
				err = json.Unmarshal(*v, &files)
				if err != nil {
					return err
				}
				jih.Files = &files
			}
		case "start":
			if v != nil {
				start, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jih.Start = start
			}
		case "end":
			if v != nil {
				end, err := unmarshalBasicClipTime(*v)
				if err != nil {
					return err
				}
				jih.End = end
			}
		case "label":
			if v != nil {
				var label string
				err = json.Unmarshal(*v, &label)
				if err != nil {
					return err
				}
				jih.Label = &label
			}
		case "inputDefinitions":
			if v != nil {
				inputDefinitions, err := unmarshalBasicInputDefinitionArray(*v)
				if err != nil {
					return err
				}
				jih.InputDefinitions = &inputDefinitions
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicJobInput
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				jih.OdataType = odataType
			}
		}
	}

	return nil
}

// JobInputs describes a list of inputs to a Job.
type JobInputs struct {
	// Inputs - List of inputs to a Job.
	Inputs *[]BasicJobInput `json:"inputs,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobInputs.
func (ji JobInputs) MarshalJSON() ([]byte, error) {
	ji.OdataType = OdataTypeMicrosoftMediaJobInputs
	objectMap := make(map[string]interface{})
	if ji.Inputs != nil {
		objectMap["inputs"] = ji.Inputs
	}
	if ji.OdataType != "" {
		objectMap["@odata.type"] = ji.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInputClip() (*JobInputClip, bool) {
	return nil, false
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return nil, false
}

// AsJobInputs is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInputs() (*JobInputs, bool) {
	return &ji, true
}

// AsJobInputAsset is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInputAsset() (*JobInputAsset, bool) {
	return nil, false
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return nil, false
}

// AsJobInputSequence is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInputSequence() (*JobInputSequence, bool) {
	return nil, false
}

// AsJobInput is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsJobInput() (*JobInput, bool) {
	return nil, false
}

// AsBasicJobInput is the BasicJobInput implementation for JobInputs.
func (ji JobInputs) AsBasicJobInput() (BasicJobInput, bool) {
	return &ji, true
}

// UnmarshalJSON is the custom unmarshaler for JobInputs struct.
func (ji *JobInputs) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "inputs":
			if v != nil {
				inputs, err := unmarshalBasicJobInputArray(*v)
				if err != nil {
					return err
				}
				ji.Inputs = &inputs
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicJobInput
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				ji.OdataType = odataType
			}
		}
	}

	return nil
}

// JobInputSequence a Sequence contains an ordered list of Clips where each clip is a JobInput.  The
// Sequence will be treated as a single input.
type JobInputSequence struct {
	// Inputs - JobInputs that make up the timeline.
	Inputs *[]BasicJobInputClip `json:"inputs,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobInput', 'OdataTypeMicrosoftMediaJobInputClip', 'OdataTypeMicrosoftMediaJobInputs', 'OdataTypeMicrosoftMediaJobInputAsset', 'OdataTypeMicrosoftMediaJobInputHTTP', 'OdataTypeMicrosoftMediaJobInputSequence'
	OdataType OdataTypeBasicJobInput `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobInputSequence.
func (jis JobInputSequence) MarshalJSON() ([]byte, error) {
	jis.OdataType = OdataTypeMicrosoftMediaJobInputSequence
	objectMap := make(map[string]interface{})
	if jis.Inputs != nil {
		objectMap["inputs"] = jis.Inputs
	}
	if jis.OdataType != "" {
		objectMap["@odata.type"] = jis.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobInputClip is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInputClip() (*JobInputClip, bool) {
	return nil, false
}

// AsBasicJobInputClip is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsBasicJobInputClip() (BasicJobInputClip, bool) {
	return nil, false
}

// AsJobInputs is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInputs() (*JobInputs, bool) {
	return nil, false
}

// AsJobInputAsset is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInputAsset() (*JobInputAsset, bool) {
	return nil, false
}

// AsJobInputHTTP is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInputHTTP() (*JobInputHTTP, bool) {
	return nil, false
}

// AsJobInputSequence is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInputSequence() (*JobInputSequence, bool) {
	return &jis, true
}

// AsJobInput is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsJobInput() (*JobInput, bool) {
	return nil, false
}

// AsBasicJobInput is the BasicJobInput implementation for JobInputSequence.
func (jis JobInputSequence) AsBasicJobInput() (BasicJobInput, bool) {
	return &jis, true
}

// UnmarshalJSON is the custom unmarshaler for JobInputSequence struct.
func (jis *JobInputSequence) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "inputs":
			if v != nil {
				inputs, err := unmarshalBasicJobInputClipArray(*v)
				if err != nil {
					return err
				}
				jis.Inputs = &inputs
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicJobInput
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				jis.OdataType = odataType
			}
		}
	}

	return nil
}

// BasicJobOutput describes all the properties of a JobOutput.
type BasicJobOutput interface {
	AsJobOutputAsset() (*JobOutputAsset, bool)
	AsJobOutput() (*JobOutput, bool)
}

// JobOutput describes all the properties of a JobOutput.
type JobOutput struct {
	// Error - READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError `json:"error,omitempty"`
	// State - READ-ONLY; Describes the state of the JobOutput. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State JobState `json:"state,omitempty"`
	// Progress - READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property.
	Progress *int32 `json:"progress,omitempty"`
	// Label - A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
	Label *string `json:"label,omitempty"`
	// StartTime - READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *date.Time `json:"endTime,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobOutput', 'OdataTypeMicrosoftMediaJobOutputAsset'
	OdataType OdataTypeBasicJobOutput `json:"@odata.type,omitempty"`
}

func unmarshalBasicJobOutput(body []byte) (BasicJobOutput, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaJobOutputAsset):
		var joa JobOutputAsset
		err := json.Unmarshal(body, &joa)
		return joa, err
	default:
		var jo JobOutput
		err := json.Unmarshal(body, &jo)
		return jo, err
	}
}
func unmarshalBasicJobOutputArray(body []byte) ([]BasicJobOutput, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	joArray := make([]BasicJobOutput, len(rawMessages))

	for index, rawMessage := range rawMessages {
		jo, err := unmarshalBasicJobOutput(*rawMessage)
		if err != nil {
			return nil, err
		}
		joArray[index] = jo
	}
	return joArray, nil
}

// MarshalJSON is the custom marshaler for JobOutput.
func (jo JobOutput) MarshalJSON() ([]byte, error) {
	jo.OdataType = OdataTypeJobOutput
	objectMap := make(map[string]interface{})
	if jo.Label != nil {
		objectMap["label"] = jo.Label
	}
	if jo.OdataType != "" {
		objectMap["@odata.type"] = jo.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobOutputAsset is the BasicJobOutput implementation for JobOutput.
func (jo JobOutput) AsJobOutputAsset() (*JobOutputAsset, bool) {
	return nil, false
}

// AsJobOutput is the BasicJobOutput implementation for JobOutput.
func (jo JobOutput) AsJobOutput() (*JobOutput, bool) {
	return &jo, true
}

// AsBasicJobOutput is the BasicJobOutput implementation for JobOutput.
func (jo JobOutput) AsBasicJobOutput() (BasicJobOutput, bool) {
	return &jo, true
}

// JobOutputAsset represents an Asset used as a JobOutput.
type JobOutputAsset struct {
	// AssetName - The name of the output Asset.
	AssetName *string `json:"assetName,omitempty"`
	// Error - READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError `json:"error,omitempty"`
	// State - READ-ONLY; Describes the state of the JobOutput. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State JobState `json:"state,omitempty"`
	// Progress - READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate and not intended to be used to predict Job completion times. To determine if the JobOutput is complete, use the State property.
	Progress *int32 `json:"progress,omitempty"`
	// Label - A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more than one TransformOutput, whereby your Job has more than one JobOutput. In such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the Transform. Subsequently, when you retrieve the Job, either through events or on a GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}' will be used, where the preset name is the name of the preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the Job. Note that this index is the same as the relative index of the corresponding TransformOutput within its Transform.
	Label *string `json:"label,omitempty"`
	// StartTime - READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *date.Time `json:"endTime,omitempty"`
	// OdataType - Possible values include: 'OdataTypeJobOutput', 'OdataTypeMicrosoftMediaJobOutputAsset'
	OdataType OdataTypeBasicJobOutput `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JobOutputAsset.
func (joa JobOutputAsset) MarshalJSON() ([]byte, error) {
	joa.OdataType = OdataTypeMicrosoftMediaJobOutputAsset
	objectMap := make(map[string]interface{})
	if joa.AssetName != nil {
		objectMap["assetName"] = joa.AssetName
	}
	if joa.Label != nil {
		objectMap["label"] = joa.Label
	}
	if joa.OdataType != "" {
		objectMap["@odata.type"] = joa.OdataType
	}
	return json.Marshal(objectMap)
}

// AsJobOutputAsset is the BasicJobOutput implementation for JobOutputAsset.
func (joa JobOutputAsset) AsJobOutputAsset() (*JobOutputAsset, bool) {
	return &joa, true
}

// AsJobOutput is the BasicJobOutput implementation for JobOutputAsset.
func (joa JobOutputAsset) AsJobOutput() (*JobOutput, bool) {
	return nil, false
}

// AsBasicJobOutput is the BasicJobOutput implementation for JobOutputAsset.
func (joa JobOutputAsset) AsBasicJobOutput() (BasicJobOutput, bool) {
	return &joa, true
}

// JobProperties properties of the Job.
type JobProperties struct {
	// Created - READ-ONLY; The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *date.Time `json:"created,omitempty"`
	// State - READ-ONLY; The current state of the job. Possible values include: 'Canceled', 'Canceling', 'Error', 'Finished', 'Processing', 'Queued', 'Scheduled'
	State JobState `json:"state,omitempty"`
	// Description - Optional customer supplied description of the Job.
	Description *string `json:"description,omitempty"`
	// Input - The inputs for the Job.
	Input BasicJobInput `json:"input,omitempty"`
	// LastModified - READ-ONLY; The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// Outputs - The outputs for the Job.
	Outputs *[]BasicJobOutput `json:"outputs,omitempty"`
	// Priority - Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not set, the default is normal. Possible values include: 'PriorityLow', 'PriorityNormal', 'PriorityHigh'
	Priority Priority `json:"priority,omitempty"`
	// CorrelationData - Customer provided key, value pairs that will be returned in Job and JobOutput state events.
	CorrelationData map[string]*string `json:"correlationData"`
	// StartTime - READ-ONLY; The UTC date and time at which this Job began processing.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; The UTC date and time at which this Job finished processing.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// MarshalJSON is the custom marshaler for JobProperties.
func (jp JobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if jp.Description != nil {
		objectMap["description"] = jp.Description
	}
	objectMap["input"] = jp.Input
	if jp.Outputs != nil {
		objectMap["outputs"] = jp.Outputs
	}
	if jp.Priority != "" {
		objectMap["priority"] = jp.Priority
	}
	if jp.CorrelationData != nil {
		objectMap["correlationData"] = jp.CorrelationData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobProperties struct.
func (jp *JobProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "created":
			if v != nil {
				var created date.Time
				err = json.Unmarshal(*v, &created)
				if err != nil {
					return err
				}
				jp.Created = &created
			}
		case "state":
			if v != nil {
				var state JobState
				err = json.Unmarshal(*v, &state)
				if err != nil {
					return err
				}
				jp.State = state
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				jp.Description = &description
			}
		case "input":
			if v != nil {
				input, err := unmarshalBasicJobInput(*v)
				if err != nil {
					return err
				}
				jp.Input = input
			}
		case "lastModified":
			if v != nil {
				var lastModified date.Time
				err = json.Unmarshal(*v, &lastModified)
				if err != nil {
					return err
				}
				jp.LastModified = &lastModified
			}
		case "outputs":
			if v != nil {
				outputs, err := unmarshalBasicJobOutputArray(*v)
				if err != nil {
					return err
				}
				jp.Outputs = &outputs
			}
		case "priority":
			if v != nil {
				var priority Priority
				err = json.Unmarshal(*v, &priority)
				if err != nil {
					return err
				}
				jp.Priority = priority
			}
		case "correlationData":
			if v != nil {
				var correlationData map[string]*string
				err = json.Unmarshal(*v, &correlationData)
				if err != nil {
					return err
				}
				jp.CorrelationData = correlationData
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				jp.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				jp.EndTime = &endTime
			}
		}
	}

	return nil
}

// JpgFormat describes the settings for producing JPEG thumbnails.
type JpgFormat struct {
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JpgFormat.
func (jf JpgFormat) MarshalJSON() ([]byte, error) {
	jf.OdataType = OdataTypeMicrosoftMediaJpgFormat
	objectMap := make(map[string]interface{})
	if jf.FilenamePattern != nil {
		objectMap["filenamePattern"] = jf.FilenamePattern
	}
	if jf.OdataType != "" {
		objectMap["@odata.type"] = jf.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsBasicImageFormat() (BasicImageFormat, bool) {
	return &jf, true
}

// AsJpgFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsJpgFormat() (*JpgFormat, bool) {
	return &jf, true
}

// AsPngFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return nil, false
}

// AsMp4Format is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for JpgFormat.
func (jf JpgFormat) AsBasicFormat() (BasicFormat, bool) {
	return &jf, true
}

// JpgImage describes the properties for producing a series of JPEG images from the input video.
type JpgImage struct {
	// Layers - A collection of output JPEG image layers to be produced by the encoder.
	Layers *[]JpgLayer `json:"layers,omitempty"`
	// SpriteColumn - Sets the number of columns used in thumbnail sprite image.  The number of rows are automatically calculated and a VTT file is generated with the coordinate mappings for each thumbnail in the sprite. Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will not go beyond JPEG maximum pixel resolution limit 65535x65535.
	SpriteColumn *int32 `json:"spriteColumn,omitempty"`
	// Start - The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`
	// Step - The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`
	// Range - The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JpgImage.
func (ji JpgImage) MarshalJSON() ([]byte, error) {
	ji.OdataType = OdataTypeMicrosoftMediaJpgImage
	objectMap := make(map[string]interface{})
	if ji.Layers != nil {
		objectMap["layers"] = ji.Layers
	}
	if ji.SpriteColumn != nil {
		objectMap["spriteColumn"] = ji.SpriteColumn
	}
	if ji.Start != nil {
		objectMap["start"] = ji.Start
	}
	if ji.Step != nil {
		objectMap["step"] = ji.Step
	}
	if ji.Range != nil {
		objectMap["range"] = ji.Range
	}
	if ji.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = ji.KeyFrameInterval
	}
	if ji.StretchMode != "" {
		objectMap["stretchMode"] = ji.StretchMode
	}
	if ji.SyncMode != "" {
		objectMap["syncMode"] = ji.SyncMode
	}
	if ji.Label != nil {
		objectMap["label"] = ji.Label
	}
	if ji.OdataType != "" {
		objectMap["@odata.type"] = ji.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsBasicVideo() (BasicVideo, bool) {
	return &ji, true
}

// AsH265Video is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsBasicImage() (BasicImage, bool) {
	return &ji, true
}

// AsCopyAudio is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsJpgImage() (*JpgImage, bool) {
	return &ji, true
}

// AsPngImage is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for JpgImage.
func (ji JpgImage) AsBasicCodec() (BasicCodec, bool) {
	return &ji, true
}

// JpgLayer describes the settings to produce a JPEG image from the input video.
type JpgLayer struct {
	// Quality - The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
	Quality *int32 `json:"quality,omitempty"`
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for JpgLayer.
func (jl JpgLayer) MarshalJSON() ([]byte, error) {
	jl.OdataType = OdataTypeMicrosoftMediaJpgLayer
	objectMap := make(map[string]interface{})
	if jl.Quality != nil {
		objectMap["quality"] = jl.Quality
	}
	if jl.Width != nil {
		objectMap["width"] = jl.Width
	}
	if jl.Height != nil {
		objectMap["height"] = jl.Height
	}
	if jl.Label != nil {
		objectMap["label"] = jl.Label
	}
	if jl.OdataType != "" {
		objectMap["@odata.type"] = jl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return nil, false
}

// AsH265Layer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return nil, false
}

// AsH264Layer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsJpgLayer() (*JpgLayer, bool) {
	return &jl, true
}

// AsPngLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for JpgLayer.
func (jl JpgLayer) AsBasicLayer() (BasicLayer, bool) {
	return &jl, true
}

// KeyVaultProperties ...
type KeyVaultProperties struct {
	// KeyIdentifier - The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1) or reference a key without a version (for example https://vault/keys/mykey).
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// CurrentKeyIdentifier - READ-ONLY; The current key used to encrypt the Media Services account, including the key version.
	CurrentKeyIdentifier *string `json:"currentKeyIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyIdentifier != nil {
		objectMap["keyIdentifier"] = kvp.KeyIdentifier
	}
	return json.Marshal(objectMap)
}

// BasicLayer the encoder can be configured to produce video and/or images (thumbnails) at different resolutions, by
// specifying a layer for each desired resolution. A layer represents the properties for the video or image at a
// resolution.
type BasicLayer interface {
	AsH265VideoLayer() (*H265VideoLayer, bool)
	AsBasicH265VideoLayer() (BasicH265VideoLayer, bool)
	AsH265Layer() (*H265Layer, bool)
	AsVideoLayer() (*VideoLayer, bool)
	AsBasicVideoLayer() (BasicVideoLayer, bool)
	AsH264Layer() (*H264Layer, bool)
	AsJpgLayer() (*JpgLayer, bool)
	AsPngLayer() (*PngLayer, bool)
	AsLayer() (*Layer, bool)
}

// Layer the encoder can be configured to produce video and/or images (thumbnails) at different resolutions, by
// specifying a layer for each desired resolution. A layer represents the properties for the video or image at
// a resolution.
type Layer struct {
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

func unmarshalBasicLayer(body []byte) (BasicLayer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaH265VideoLayer):
		var hvl H265VideoLayer
		err := json.Unmarshal(body, &hvl)
		return hvl, err
	case string(OdataTypeMicrosoftMediaH265Layer):
		var hl H265Layer
		err := json.Unmarshal(body, &hl)
		return hl, err
	case string(OdataTypeMicrosoftMediaVideoLayer):
		var vl VideoLayer
		err := json.Unmarshal(body, &vl)
		return vl, err
	case string(OdataTypeMicrosoftMediaH264Layer):
		var hl H264Layer
		err := json.Unmarshal(body, &hl)
		return hl, err
	case string(OdataTypeMicrosoftMediaJpgLayer):
		var jl JpgLayer
		err := json.Unmarshal(body, &jl)
		return jl, err
	case string(OdataTypeMicrosoftMediaPngLayer):
		var pl PngLayer
		err := json.Unmarshal(body, &pl)
		return pl, err
	default:
		var l Layer
		err := json.Unmarshal(body, &l)
		return l, err
	}
}
func unmarshalBasicLayerArray(body []byte) ([]BasicLayer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	lArray := make([]BasicLayer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		l, err := unmarshalBasicLayer(*rawMessage)
		if err != nil {
			return nil, err
		}
		lArray[index] = l
	}
	return lArray, nil
}

// MarshalJSON is the custom marshaler for Layer.
func (l Layer) MarshalJSON() ([]byte, error) {
	l.OdataType = OdataTypeLayer
	objectMap := make(map[string]interface{})
	if l.Width != nil {
		objectMap["width"] = l.Width
	}
	if l.Height != nil {
		objectMap["height"] = l.Height
	}
	if l.Label != nil {
		objectMap["label"] = l.Label
	}
	if l.OdataType != "" {
		objectMap["@odata.type"] = l.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for Layer.
func (l Layer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for Layer.
func (l Layer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return nil, false
}

// AsH265Layer is the BasicLayer implementation for Layer.
func (l Layer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for Layer.
func (l Layer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for Layer.
func (l Layer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return nil, false
}

// AsH264Layer is the BasicLayer implementation for Layer.
func (l Layer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for Layer.
func (l Layer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for Layer.
func (l Layer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for Layer.
func (l Layer) AsLayer() (*Layer, bool) {
	return &l, true
}

// AsBasicLayer is the BasicLayer implementation for Layer.
func (l Layer) AsBasicLayer() (BasicLayer, bool) {
	return &l, true
}

// ListContainerSasInput the parameters to the list SAS request.
type ListContainerSasInput struct {
	// Permissions - The permissions to set on the SAS URL. Possible values include: 'Read', 'ReadWrite', 'ReadWriteDelete'
	Permissions AssetContainerPermission `json:"permissions,omitempty"`
	// ExpiryTime - The SAS URL expiration time.  This must be less than 24 hours from the current time.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
}

// ListContentKeysResponse class of response for listContentKeys action
type ListContentKeysResponse struct {
	autorest.Response `json:"-"`
	// ContentKeys - ContentKeys used by current Streaming Locator
	ContentKeys *[]StreamingLocatorContentKey `json:"contentKeys,omitempty"`
}

// ListEdgePoliciesInput ...
type ListEdgePoliciesInput struct {
	// DeviceID - Unique identifier of the edge device.
	DeviceID *string `json:"deviceId,omitempty"`
}

// ListPathsResponse class of response for listPaths action
type ListPathsResponse struct {
	autorest.Response `json:"-"`
	// StreamingPaths - Streaming Paths supported by current Streaming Locator
	StreamingPaths *[]StreamingPath `json:"streamingPaths,omitempty"`
	// DownloadPaths - Download Paths supported by current Streaming Locator
	DownloadPaths *[]string `json:"downloadPaths,omitempty"`
}

// ListStreamingLocatorsResponse the Streaming Locators associated with this Asset.
type ListStreamingLocatorsResponse struct {
	autorest.Response `json:"-"`
	// StreamingLocators - READ-ONLY; The list of Streaming Locators.
	StreamingLocators *[]AssetStreamingLocator `json:"streamingLocators,omitempty"`
}

// LiveEvent the live event.
type LiveEvent struct {
	autorest.Response `json:"-"`
	// LiveEventProperties - The live event properties.
	*LiveEventProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LiveEvent.
func (le LiveEvent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if le.LiveEventProperties != nil {
		objectMap["properties"] = le.LiveEventProperties
	}
	if le.Tags != nil {
		objectMap["tags"] = le.Tags
	}
	if le.Location != nil {
		objectMap["location"] = le.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LiveEvent struct.
func (le *LiveEvent) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var liveEventProperties LiveEventProperties
				err = json.Unmarshal(*v, &liveEventProperties)
				if err != nil {
					return err
				}
				le.LiveEventProperties = &liveEventProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				le.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				le.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				le.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				le.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				le.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				le.Type = &typeVar
			}
		}
	}

	return nil
}

// LiveEventActionInput the LiveEvent action input parameter definition.
type LiveEventActionInput struct {
	// RemoveOutputsOnStop - The flag indicates whether live outputs are automatically deleted when live event is being stopped. Deleting live outputs do not delete the underlying assets.
	RemoveOutputsOnStop *bool `json:"removeOutputsOnStop,omitempty"`
}

// LiveEventEncoding specifies the live event type and optional encoding settings for encoding live events.
type LiveEventEncoding struct {
	// EncodingType - Live event type. When encodingType is set to None, the service simply passes through the incoming video and audio layer(s) to the output. When encodingType is set to Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101 for more information. This property cannot be modified after the live event is created. Possible values include: 'LiveEventEncodingTypeNone', 'LiveEventEncodingTypeStandard', 'LiveEventEncodingTypePremium1080p'
	EncodingType LiveEventEncodingType `json:"encodingType,omitempty"`
	// PresetName - The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot be updated. If the encodingType is set to Standard, then the default preset name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
	PresetName *string `json:"presetName,omitempty"`
	// StretchMode - Specifies how the input video will be resized to fit the desired output resolution(s). Default is None. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// KeyFrameInterval - Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks of an encoding live event. For example, use PT2S to indicate 2 seconds. For the video track it also defines the key frame interval, or the length of a GoP (group of pictures).   If this value is not set for an encoding live event, the fragment duration defaults to 2 seconds. The value cannot be set for pass-through live events.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
}

// LiveEventEndpoint the live event endpoint.
type LiveEventEndpoint struct {
	// Protocol - The endpoint protocol.
	Protocol *string `json:"protocol,omitempty"`
	// URL - The endpoint URL.
	URL *string `json:"url,omitempty"`
}

// LiveEventInput the live event input.
type LiveEventInput struct {
	// StreamingProtocol - The input protocol for the live event. This is specified at creation time and cannot be updated. Possible values include: 'FragmentedMP4', 'RTMP'
	StreamingProtocol LiveEventInputProtocol `json:"streamingProtocol,omitempty"`
	// AccessControl - Access control for live event input.
	AccessControl *LiveEventInputAccessControl `json:"accessControl,omitempty"`
	// KeyFrameIntervalDuration - ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the value empty for encoding live events.
	KeyFrameIntervalDuration *string `json:"keyFrameIntervalDuration,omitempty"`
	// AccessToken - A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If omitted, the service will generate a unique value.
	AccessToken *string `json:"accessToken,omitempty"`
	// Endpoints - The input endpoints for the live event.
	Endpoints *[]LiveEventEndpoint `json:"endpoints,omitempty"`
}

// LiveEventInputAccessControl the IP access control for live event input.
type LiveEventInputAccessControl struct {
	// IP - The IP access control properties.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// LiveEventInputTrackSelection a track selection condition. This property is reserved for future use, any
// value set on this property will be ignored.
type LiveEventInputTrackSelection struct {
	// Property - Property name to select. This property is reserved for future use, any value set on this property will be ignored.
	Property *string `json:"property,omitempty"`
	// Operation - Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
	Operation *string `json:"operation,omitempty"`
	// Value - Property value to select. This property is reserved for future use, any value set on this property will be ignored.
	Value *string `json:"value,omitempty"`
}

// LiveEventListResult the LiveEvent list result.
type LiveEventListResult struct {
	autorest.Response `json:"-"`
	// Value - The result of the List Live Event operation.
	Value *[]LiveEvent `json:"value,omitempty"`
	// OdataCount - The number of result.
	OdataCount *int32 `json:"@odata.count,omitempty"`
	// OdataNextLink - The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// LiveEventListResultIterator provides access to a complete listing of LiveEvent values.
type LiveEventListResultIterator struct {
	i    int
	page LiveEventListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LiveEventListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LiveEventListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LiveEventListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LiveEventListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LiveEventListResultIterator) Response() LiveEventListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LiveEventListResultIterator) Value() LiveEvent {
	if !iter.page.NotDone() {
		return LiveEvent{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LiveEventListResultIterator type.
func NewLiveEventListResultIterator(page LiveEventListResultPage) LiveEventListResultIterator {
	return LiveEventListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lelr LiveEventListResult) IsEmpty() bool {
	return lelr.Value == nil || len(*lelr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lelr LiveEventListResult) hasNextLink() bool {
	return lelr.OdataNextLink != nil && len(*lelr.OdataNextLink) != 0
}

// liveEventListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lelr LiveEventListResult) liveEventListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lelr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lelr.OdataNextLink)))
}

// LiveEventListResultPage contains a page of LiveEvent values.
type LiveEventListResultPage struct {
	fn   func(context.Context, LiveEventListResult) (LiveEventListResult, error)
	lelr LiveEventListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LiveEventListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LiveEventListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lelr)
		if err != nil {
			return err
		}
		page.lelr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LiveEventListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LiveEventListResultPage) NotDone() bool {
	return !page.lelr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LiveEventListResultPage) Response() LiveEventListResult {
	return page.lelr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LiveEventListResultPage) Values() []LiveEvent {
	if page.lelr.IsEmpty() {
		return nil
	}
	return *page.lelr.Value
}

// Creates a new instance of the LiveEventListResultPage type.
func NewLiveEventListResultPage(cur LiveEventListResult, getNextPage func(context.Context, LiveEventListResult) (LiveEventListResult, error)) LiveEventListResultPage {
	return LiveEventListResultPage{
		fn:   getNextPage,
		lelr: cur,
	}
}

// LiveEventOutputTranscriptionTrack describes a transcription track in the output of a live event,
// generated using speech-to-text transcription. This property is reserved for future use, any value set on
// this property will be ignored.
type LiveEventOutputTranscriptionTrack struct {
	// TrackName - The output track name. This property is reserved for future use, any value set on this property will be ignored.
	TrackName *string `json:"trackName,omitempty"`
}

// LiveEventPreview live event preview settings.
type LiveEventPreview struct {
	// Endpoints - The endpoints for preview. Do not share the preview URL with the live event audience.
	Endpoints *[]LiveEventEndpoint `json:"endpoints,omitempty"`
	// AccessControl - The access control for live event preview.
	AccessControl *LiveEventPreviewAccessControl `json:"accessControl,omitempty"`
	// PreviewLocator - The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview locator url before the event is created. If omitted, the service will generate a random identifier. This value cannot be updated once the live event is created.
	PreviewLocator *string `json:"previewLocator,omitempty"`
	// StreamingPolicyName - The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty"`
	// AlternativeMediaID - An alternative media identifier associated with the streaming locator created for the preview. This value is specified at creation time and cannot be updated. The identifier can be used in the CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName field.
	AlternativeMediaID *string `json:"alternativeMediaId,omitempty"`
}

// LiveEventPreviewAccessControl the IP access control for the live event preview endpoint.
type LiveEventPreviewAccessControl struct {
	// IP - The IP access control properties.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// LiveEventProperties the live event properties.
type LiveEventProperties struct {
	// Description - A description for the live event.
	Description *string `json:"description,omitempty"`
	// Input - Live event input settings. It defines how the live event receives input from a contribution encoder.
	Input *LiveEventInput `json:"input,omitempty"`
	// Preview - Live event preview settings. Preview allows live event producers to preview the live streaming content without creating any live output.
	Preview *LiveEventPreview `json:"preview,omitempty"`
	// Encoding - Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for the live encoder if it is used.
	Encoding *LiveEventEncoding `json:"encoding,omitempty"`
	// Transcriptions - Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature.
	Transcriptions *[]LiveEventTranscription `json:"transcriptions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the live event.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information. Possible values include: 'Stopped', 'Allocating', 'StandBy', 'Starting', 'Running', 'Stopping', 'Deleting'
	ResourceState LiveEventResourceState `json:"resourceState,omitempty"`
	// CrossSiteAccessPolicies - Live event cross site access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies `json:"crossSiteAccessPolicies,omitempty"`
	// UseStaticHostname - Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only be updated if the live event is in Standby state
	UseStaticHostname *bool `json:"useStaticHostname,omitempty"`
	// HostnamePrefix - When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live event preview and ingest endpoints. The final hostname would be a combination of this prefix, the media service account name and a short code for the Azure Media Services data center.
	HostnamePrefix *string `json:"hostnamePrefix,omitempty"`
	// StreamOptions - The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values for the array entry values are 'Default' and 'LowLatency'.
	StreamOptions *[]StreamOptionsFlag `json:"streamOptions,omitempty"`
	// Created - READ-ONLY; The creation time for the live event
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The last modified time of the live event.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for LiveEventProperties.
func (lep LiveEventProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lep.Description != nil {
		objectMap["description"] = lep.Description
	}
	if lep.Input != nil {
		objectMap["input"] = lep.Input
	}
	if lep.Preview != nil {
		objectMap["preview"] = lep.Preview
	}
	if lep.Encoding != nil {
		objectMap["encoding"] = lep.Encoding
	}
	if lep.Transcriptions != nil {
		objectMap["transcriptions"] = lep.Transcriptions
	}
	if lep.CrossSiteAccessPolicies != nil {
		objectMap["crossSiteAccessPolicies"] = lep.CrossSiteAccessPolicies
	}
	if lep.UseStaticHostname != nil {
		objectMap["useStaticHostname"] = lep.UseStaticHostname
	}
	if lep.HostnamePrefix != nil {
		objectMap["hostnamePrefix"] = lep.HostnamePrefix
	}
	if lep.StreamOptions != nil {
		objectMap["streamOptions"] = lep.StreamOptions
	}
	return json.Marshal(objectMap)
}

// LiveEventsAllocateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsAllocateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsAllocateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsAllocateFuture.Result.
func (future *LiveEventsAllocateFuture) result(client LiveEventsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsAllocateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsAllocateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LiveEventsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (LiveEvent, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsCreateFuture.Result.
func (future *LiveEventsCreateFuture) result(client LiveEventsClient) (le LiveEvent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if le.Response.Response, err = future.GetResult(sender); err == nil && le.Response.Response.StatusCode != http.StatusNoContent {
		le, err = client.CreateResponder(le.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "media.LiveEventsCreateFuture", "Result", le.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LiveEventsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsDeleteFuture.Result.
func (future *LiveEventsDeleteFuture) result(client LiveEventsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LiveEventsResetFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsResetFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsResetFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsResetFuture.Result.
func (future *LiveEventsResetFuture) result(client LiveEventsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsResetFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsResetFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LiveEventsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsStartFuture.Result.
func (future *LiveEventsStartFuture) result(client LiveEventsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LiveEventsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsStopFuture.Result.
func (future *LiveEventsStopFuture) result(client LiveEventsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// LiveEventsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveEventsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveEventsClient) (LiveEvent, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveEventsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveEventsUpdateFuture.Result.
func (future *LiveEventsUpdateFuture) result(client LiveEventsClient) (le LiveEvent, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveEventsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveEventsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if le.Response.Response, err = future.GetResult(sender); err == nil && le.Response.Response.StatusCode != http.StatusNoContent {
		le, err = client.UpdateResponder(le.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "media.LiveEventsUpdateFuture", "Result", le.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LiveEventTranscription describes the transcription tracks in the output of a live event, generated using
// speech-to-text transcription. This property is reserved for future use, any value set on this property
// will be ignored.
type LiveEventTranscription struct {
	// Language - Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the audio track. The value should be in BCP-47 format (e.g: 'en-US'). See https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list of supported languages.
	Language *string `json:"language,omitempty"`
	// InputTrackSelection - Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied. This property is reserved for future use, any value set on this property will be ignored.
	InputTrackSelection *[]LiveEventInputTrackSelection `json:"inputTrackSelection,omitempty"`
	// OutputTranscriptionTrack - Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property is reserved for future use, any value set on this property will be ignored.
	OutputTranscriptionTrack *LiveEventOutputTranscriptionTrack `json:"outputTranscriptionTrack,omitempty"`
}

// LiveOutput the Live Output.
type LiveOutput struct {
	autorest.Response `json:"-"`
	// LiveOutputProperties - Live output properties.
	*LiveOutputProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for LiveOutput.
func (lo LiveOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lo.LiveOutputProperties != nil {
		objectMap["properties"] = lo.LiveOutputProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LiveOutput struct.
func (lo *LiveOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var liveOutputProperties LiveOutputProperties
				err = json.Unmarshal(*v, &liveOutputProperties)
				if err != nil {
					return err
				}
				lo.LiveOutputProperties = &liveOutputProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				lo.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lo.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				lo.Type = &typeVar
			}
		}
	}

	return nil
}

// LiveOutputListResult the LiveOutput list result.
type LiveOutputListResult struct {
	autorest.Response `json:"-"`
	// Value - The result of the List LiveOutput operation.
	Value *[]LiveOutput `json:"value,omitempty"`
	// OdataCount - The number of result.
	OdataCount *int32 `json:"@odata.count,omitempty"`
	// OdataNextLink - The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// LiveOutputListResultIterator provides access to a complete listing of LiveOutput values.
type LiveOutputListResultIterator struct {
	i    int
	page LiveOutputListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LiveOutputListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LiveOutputListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LiveOutputListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LiveOutputListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LiveOutputListResultIterator) Response() LiveOutputListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LiveOutputListResultIterator) Value() LiveOutput {
	if !iter.page.NotDone() {
		return LiveOutput{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LiveOutputListResultIterator type.
func NewLiveOutputListResultIterator(page LiveOutputListResultPage) LiveOutputListResultIterator {
	return LiveOutputListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lolr LiveOutputListResult) IsEmpty() bool {
	return lolr.Value == nil || len(*lolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lolr LiveOutputListResult) hasNextLink() bool {
	return lolr.OdataNextLink != nil && len(*lolr.OdataNextLink) != 0
}

// liveOutputListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lolr LiveOutputListResult) liveOutputListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lolr.OdataNextLink)))
}

// LiveOutputListResultPage contains a page of LiveOutput values.
type LiveOutputListResultPage struct {
	fn   func(context.Context, LiveOutputListResult) (LiveOutputListResult, error)
	lolr LiveOutputListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LiveOutputListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LiveOutputListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lolr)
		if err != nil {
			return err
		}
		page.lolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LiveOutputListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LiveOutputListResultPage) NotDone() bool {
	return !page.lolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LiveOutputListResultPage) Response() LiveOutputListResult {
	return page.lolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LiveOutputListResultPage) Values() []LiveOutput {
	if page.lolr.IsEmpty() {
		return nil
	}
	return *page.lolr.Value
}

// Creates a new instance of the LiveOutputListResultPage type.
func NewLiveOutputListResultPage(cur LiveOutputListResult, getNextPage func(context.Context, LiveOutputListResult) (LiveOutputListResult, error)) LiveOutputListResultPage {
	return LiveOutputListResultPage{
		fn:   getNextPage,
		lolr: cur,
	}
}

// LiveOutputProperties the JSON object that contains the properties required to create a live output.
type LiveOutputProperties struct {
	// Description - The description of the live output.
	Description *string `json:"description,omitempty"`
	// AssetName - The asset that the live output will write to.
	AssetName *string `json:"assetName,omitempty"`
	// ArchiveWindowLength - ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the asset for this live output. This also sets the maximum content length for the rewind window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window.
	ArchiveWindowLength *string `json:"archiveWindowLength,omitempty"`
	// ManifestName - The manifest file name. If not provided, the service will generate one automatically.
	ManifestName *string `json:"manifestName,omitempty"`
	// Hls - HTTP Live Streaming (HLS) packing setting for the live output.
	Hls *Hls `json:"hls,omitempty"`
	// OutputSnapTime - The initial timestamp that the live output will start at, any content before this value will not be archived.
	OutputSnapTime *int64 `json:"outputSnapTime,omitempty"`
	// Created - READ-ONLY; The creation time the live output.
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The time the live output was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the live output.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; The resource state of the live output. Possible values include: 'LiveOutputResourceStateCreating', 'LiveOutputResourceStateRunning', 'LiveOutputResourceStateDeleting'
	ResourceState LiveOutputResourceState `json:"resourceState,omitempty"`
}

// MarshalJSON is the custom marshaler for LiveOutputProperties.
func (lop LiveOutputProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lop.Description != nil {
		objectMap["description"] = lop.Description
	}
	if lop.AssetName != nil {
		objectMap["assetName"] = lop.AssetName
	}
	if lop.ArchiveWindowLength != nil {
		objectMap["archiveWindowLength"] = lop.ArchiveWindowLength
	}
	if lop.ManifestName != nil {
		objectMap["manifestName"] = lop.ManifestName
	}
	if lop.Hls != nil {
		objectMap["hls"] = lop.Hls
	}
	if lop.OutputSnapTime != nil {
		objectMap["outputSnapTime"] = lop.OutputSnapTime
	}
	return json.Marshal(objectMap)
}

// LiveOutputsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveOutputsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveOutputsClient) (LiveOutput, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveOutputsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveOutputsCreateFuture.Result.
func (future *LiveOutputsCreateFuture) result(client LiveOutputsClient) (lo LiveOutput, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveOutputsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveOutputsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if lo.Response.Response, err = future.GetResult(sender); err == nil && lo.Response.Response.StatusCode != http.StatusNoContent {
		lo, err = client.CreateResponder(lo.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "media.LiveOutputsCreateFuture", "Result", lo.Response.Response, "Failure responding to request")
		}
	}
	return
}

// LiveOutputsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type LiveOutputsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(LiveOutputsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *LiveOutputsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for LiveOutputsDeleteFuture.Result.
func (future *LiveOutputsDeleteFuture) result(client LiveOutputsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.LiveOutputsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.LiveOutputsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Location ...
type Location struct {
	Name *string `json:"name,omitempty"`
}

// LogSpecification a diagnostic log emitted by service.
type LogSpecification struct {
	// Name - READ-ONLY; The diagnostic log category name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The diagnostic log category display name.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - READ-ONLY; The time range for requests in each blob.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// MetricDimension a metric dimension.
type MetricDimension struct {
	// Name - READ-ONLY; The metric dimension name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The display name for the dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// MetricSpecification a metric emitted by service.
type MetricSpecification struct {
	// Name - READ-ONLY; The metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - READ-ONLY; The metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - READ-ONLY; The metric display description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - READ-ONLY; The metric unit. Possible values include: 'MetricUnitBytes', 'MetricUnitCount', 'MetricUnitMilliseconds'
	Unit MetricUnit `json:"unit,omitempty"`
	// AggregationType - READ-ONLY; The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'
	AggregationType MetricAggregationType `json:"aggregationType,omitempty"`
	// LockAggregationType - READ-ONLY; The metric lock aggregation type. Possible values include: 'Average', 'Count', 'Total'
	LockAggregationType MetricAggregationType `json:"lockAggregationType,omitempty"`
	// SupportedAggregationTypes - Supported aggregation types.
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// Dimensions - READ-ONLY; The metric dimensions.
	Dimensions *[]MetricDimension `json:"dimensions,omitempty"`
}

// MarshalJSON is the custom marshaler for MetricSpecification.
func (ms MetricSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ms.SupportedAggregationTypes != nil {
		objectMap["supportedAggregationTypes"] = ms.SupportedAggregationTypes
	}
	return json.Marshal(objectMap)
}

// Mp4Format describes the properties for an output ISO MP4 file.
type Mp4Format struct {
	// OutputFiles - The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
	OutputFiles *[]OutputFile `json:"outputFiles,omitempty"`
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for Mp4Format.
func (m4f Mp4Format) MarshalJSON() ([]byte, error) {
	m4f.OdataType = OdataTypeMicrosoftMediaMp4Format
	objectMap := make(map[string]interface{})
	if m4f.OutputFiles != nil {
		objectMap["outputFiles"] = m4f.OutputFiles
	}
	if m4f.FilenamePattern != nil {
		objectMap["filenamePattern"] = m4f.FilenamePattern
	}
	if m4f.OdataType != "" {
		objectMap["@odata.type"] = m4f.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsBasicImageFormat() (BasicImageFormat, bool) {
	return nil, false
}

// AsJpgFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return &m4f, true
}

// AsMp4Format is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsMp4Format() (*Mp4Format, bool) {
	return &m4f, true
}

// AsTransportStreamFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for Mp4Format.
func (m4f Mp4Format) AsBasicFormat() (BasicFormat, bool) {
	return &m4f, true
}

// BasicMultiBitrateFormat describes the properties for producing a collection of GOP aligned multi-bitrate files. The
// default behavior is to produce one output file for each video layer which is muxed together with all the audios. The
// exact output files produced can be controlled by specifying the outputFiles collection.
type BasicMultiBitrateFormat interface {
	AsMp4Format() (*Mp4Format, bool)
	AsTransportStreamFormat() (*TransportStreamFormat, bool)
	AsMultiBitrateFormat() (*MultiBitrateFormat, bool)
}

// MultiBitrateFormat describes the properties for producing a collection of GOP aligned multi-bitrate files.
// The default behavior is to produce one output file for each video layer which is muxed together with all the
// audios. The exact output files produced can be controlled by specifying the outputFiles collection.
type MultiBitrateFormat struct {
	// OutputFiles - The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
	OutputFiles *[]OutputFile `json:"outputFiles,omitempty"`
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

func unmarshalBasicMultiBitrateFormat(body []byte) (BasicMultiBitrateFormat, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaMp4Format):
		var m4f Mp4Format
		err := json.Unmarshal(body, &m4f)
		return m4f, err
	case string(OdataTypeMicrosoftMediaTransportStreamFormat):
		var tsf TransportStreamFormat
		err := json.Unmarshal(body, &tsf)
		return tsf, err
	default:
		var mbf MultiBitrateFormat
		err := json.Unmarshal(body, &mbf)
		return mbf, err
	}
}
func unmarshalBasicMultiBitrateFormatArray(body []byte) ([]BasicMultiBitrateFormat, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	mbfArray := make([]BasicMultiBitrateFormat, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mbf, err := unmarshalBasicMultiBitrateFormat(*rawMessage)
		if err != nil {
			return nil, err
		}
		mbfArray[index] = mbf
	}
	return mbfArray, nil
}

// MarshalJSON is the custom marshaler for MultiBitrateFormat.
func (mbf MultiBitrateFormat) MarshalJSON() ([]byte, error) {
	mbf.OdataType = OdataTypeMicrosoftMediaMultiBitrateFormat
	objectMap := make(map[string]interface{})
	if mbf.OutputFiles != nil {
		objectMap["outputFiles"] = mbf.OutputFiles
	}
	if mbf.FilenamePattern != nil {
		objectMap["filenamePattern"] = mbf.FilenamePattern
	}
	if mbf.OdataType != "" {
		objectMap["@odata.type"] = mbf.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsBasicImageFormat() (BasicImageFormat, bool) {
	return nil, false
}

// AsJpgFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return &mbf, true
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return &mbf, true
}

// AsMp4Format is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for MultiBitrateFormat.
func (mbf MultiBitrateFormat) AsBasicFormat() (BasicFormat, bool) {
	return &mbf, true
}

// NoEncryption class for NoEncryption scheme
type NoEncryption struct {
	// EnabledProtocols - Representing supported protocols
	EnabledProtocols *EnabledProtocols `json:"enabledProtocols,omitempty"`
}

// ODataError information about an error.
type ODataError struct {
	// Code - A language-independent error name.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
	// Target - The target of the error (for example, the name of the property in error).
	Target *string `json:"target,omitempty"`
	// Details - The error details.
	Details *[]ODataError `json:"details,omitempty"`
}

// Operation an operation.
type Operation struct {
	// Name - The operation name.
	Name *string `json:"name,omitempty"`
	// Display - The operation display name.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - Origin of the operation.
	Origin *string `json:"origin,omitempty"`
	// Properties - Operation properties format.
	Properties *Properties `json:"properties,omitempty"`
}

// OperationCollection a collection of Operation items.
type OperationCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Operation items.
	Value *[]Operation `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// OperationCollectionIterator provides access to a complete listing of Operation values.
type OperationCollectionIterator struct {
	i    int
	page OperationCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationCollectionIterator) Response() OperationCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationCollectionIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationCollectionIterator type.
func NewOperationCollectionIterator(page OperationCollectionPage) OperationCollectionIterator {
	return OperationCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (oc OperationCollection) IsEmpty() bool {
	return oc.Value == nil || len(*oc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (oc OperationCollection) hasNextLink() bool {
	return oc.OdataNextLink != nil && len(*oc.OdataNextLink) != 0
}

// operationCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (oc OperationCollection) operationCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !oc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(oc.OdataNextLink)))
}

// OperationCollectionPage contains a page of Operation values.
type OperationCollectionPage struct {
	fn func(context.Context, OperationCollection) (OperationCollection, error)
	oc OperationCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.oc)
		if err != nil {
			return err
		}
		page.oc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationCollectionPage) NotDone() bool {
	return !page.oc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationCollectionPage) Response() OperationCollection {
	return page.oc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationCollectionPage) Values() []Operation {
	if page.oc.IsEmpty() {
		return nil
	}
	return *page.oc.Value
}

// Creates a new instance of the OperationCollectionPage type.
func NewOperationCollectionPage(cur OperationCollection, getNextPage func(context.Context, OperationCollection) (OperationCollection, error)) OperationCollectionPage {
	return OperationCollectionPage{
		fn: getNextPage,
		oc: cur,
	}
}

// OperationDisplay operation details.
type OperationDisplay struct {
	// Provider - The service provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type.
	Operation *string `json:"operation,omitempty"`
	// Description - The operation description.
	Description *string `json:"description,omitempty"`
}

// OutputFile represents an output file produced.
type OutputFile struct {
	// Labels - The list of labels that describe how the encoder should multiplex video and audio into an output file. For example, if the encoder is producing two video layers with labels v1 and v2, and one audio layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented by v1 and the audio track represented by a1.
	Labels *[]string `json:"labels,omitempty"`
}

// BasicOverlay base type for all overlays - image, audio or video.
type BasicOverlay interface {
	AsAudioOverlay() (*AudioOverlay, bool)
	AsVideoOverlay() (*VideoOverlay, bool)
	AsOverlay() (*Overlay, bool)
}

// Overlay base type for all overlays - image, audio or video.
type Overlay struct {
	// InputLabel - The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
	InputLabel *string `json:"inputLabel,omitempty"`
	// Start - The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
	// End - The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`
	// FadeInDuration - The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`
	// FadeOutDuration - The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`
	// AudioGainLevel - The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`
	// OdataType - Possible values include: 'OdataTypeOverlay', 'OdataTypeMicrosoftMediaAudioOverlay', 'OdataTypeMicrosoftMediaVideoOverlay'
	OdataType OdataTypeBasicOverlay `json:"@odata.type,omitempty"`
}

func unmarshalBasicOverlay(body []byte) (BasicOverlay, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaAudioOverlay):
		var ao AudioOverlay
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(OdataTypeMicrosoftMediaVideoOverlay):
		var vo VideoOverlay
		err := json.Unmarshal(body, &vo)
		return vo, err
	default:
		var o Overlay
		err := json.Unmarshal(body, &o)
		return o, err
	}
}
func unmarshalBasicOverlayArray(body []byte) ([]BasicOverlay, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oArray := make([]BasicOverlay, len(rawMessages))

	for index, rawMessage := range rawMessages {
		o, err := unmarshalBasicOverlay(*rawMessage)
		if err != nil {
			return nil, err
		}
		oArray[index] = o
	}
	return oArray, nil
}

// MarshalJSON is the custom marshaler for Overlay.
func (o Overlay) MarshalJSON() ([]byte, error) {
	o.OdataType = OdataTypeOverlay
	objectMap := make(map[string]interface{})
	if o.InputLabel != nil {
		objectMap["inputLabel"] = o.InputLabel
	}
	if o.Start != nil {
		objectMap["start"] = o.Start
	}
	if o.End != nil {
		objectMap["end"] = o.End
	}
	if o.FadeInDuration != nil {
		objectMap["fadeInDuration"] = o.FadeInDuration
	}
	if o.FadeOutDuration != nil {
		objectMap["fadeOutDuration"] = o.FadeOutDuration
	}
	if o.AudioGainLevel != nil {
		objectMap["audioGainLevel"] = o.AudioGainLevel
	}
	if o.OdataType != "" {
		objectMap["@odata.type"] = o.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioOverlay is the BasicOverlay implementation for Overlay.
func (o Overlay) AsAudioOverlay() (*AudioOverlay, bool) {
	return nil, false
}

// AsVideoOverlay is the BasicOverlay implementation for Overlay.
func (o Overlay) AsVideoOverlay() (*VideoOverlay, bool) {
	return nil, false
}

// AsOverlay is the BasicOverlay implementation for Overlay.
func (o Overlay) AsOverlay() (*Overlay, bool) {
	return &o, true
}

// AsBasicOverlay is the BasicOverlay implementation for Overlay.
func (o Overlay) AsBasicOverlay() (BasicOverlay, bool) {
	return &o, true
}

// PngFormat describes the settings for producing PNG thumbnails.
type PngFormat struct {
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for PngFormat.
func (pf PngFormat) MarshalJSON() ([]byte, error) {
	pf.OdataType = OdataTypeMicrosoftMediaPngFormat
	objectMap := make(map[string]interface{})
	if pf.FilenamePattern != nil {
		objectMap["filenamePattern"] = pf.FilenamePattern
	}
	if pf.OdataType != "" {
		objectMap["@odata.type"] = pf.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsBasicImageFormat() (BasicImageFormat, bool) {
	return &pf, true
}

// AsJpgFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsPngFormat() (*PngFormat, bool) {
	return &pf, true
}

// AsMultiBitrateFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return nil, false
}

// AsMp4Format is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return nil, false
}

// AsFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for PngFormat.
func (pf PngFormat) AsBasicFormat() (BasicFormat, bool) {
	return &pf, true
}

// PngImage describes the properties for producing a series of PNG images from the input video.
type PngImage struct {
	// Layers - A collection of output PNG image layers to be produced by the encoder.
	Layers *[]PngLayer `json:"layers,omitempty"`
	// Start - The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports a macro {Best}, which tells the encoder to select the best thumbnail from the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and Range. The default value is macro {Best}.
	Start *string `json:"start,omitempty"`
	// Step - The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image every 5 seconds), or a frame count (For example, 30 for one image every 30 frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step value will affect the first generated thumbnail, which may not be exactly the one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between start time and Step position from start time as the first output. As the default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one specified at start time. Try to select reasonable value for Step if the first thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string `json:"step,omitempty"`
	// Range - The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30 seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If this value is 1, it means only producing one thumbnail at start time), or a relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default value is 100%, which means to stop at the end of the stream.
	Range *string `json:"range,omitempty"`
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for PngImage.
func (pi PngImage) MarshalJSON() ([]byte, error) {
	pi.OdataType = OdataTypeMicrosoftMediaPngImage
	objectMap := make(map[string]interface{})
	if pi.Layers != nil {
		objectMap["layers"] = pi.Layers
	}
	if pi.Start != nil {
		objectMap["start"] = pi.Start
	}
	if pi.Step != nil {
		objectMap["step"] = pi.Step
	}
	if pi.Range != nil {
		objectMap["range"] = pi.Range
	}
	if pi.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = pi.KeyFrameInterval
	}
	if pi.StretchMode != "" {
		objectMap["stretchMode"] = pi.StretchMode
	}
	if pi.SyncMode != "" {
		objectMap["syncMode"] = pi.SyncMode
	}
	if pi.Label != nil {
		objectMap["label"] = pi.Label
	}
	if pi.OdataType != "" {
		objectMap["@odata.type"] = pi.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for PngImage.
func (pi PngImage) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for PngImage.
func (pi PngImage) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for PngImage.
func (pi PngImage) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for PngImage.
func (pi PngImage) AsVideo() (*Video, bool) {
	return nil, false
}

// AsBasicVideo is the BasicCodec implementation for PngImage.
func (pi PngImage) AsBasicVideo() (BasicVideo, bool) {
	return &pi, true
}

// AsH265Video is the BasicCodec implementation for PngImage.
func (pi PngImage) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for PngImage.
func (pi PngImage) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for PngImage.
func (pi PngImage) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for PngImage.
func (pi PngImage) AsBasicImage() (BasicImage, bool) {
	return &pi, true
}

// AsCopyAudio is the BasicCodec implementation for PngImage.
func (pi PngImage) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for PngImage.
func (pi PngImage) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for PngImage.
func (pi PngImage) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for PngImage.
func (pi PngImage) AsPngImage() (*PngImage, bool) {
	return &pi, true
}

// AsCodec is the BasicCodec implementation for PngImage.
func (pi PngImage) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for PngImage.
func (pi PngImage) AsBasicCodec() (BasicCodec, bool) {
	return &pi, true
}

// PngLayer describes the settings to produce a PNG image from the input video.
type PngLayer struct {
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for PngLayer.
func (pl PngLayer) MarshalJSON() ([]byte, error) {
	pl.OdataType = OdataTypeMicrosoftMediaPngLayer
	objectMap := make(map[string]interface{})
	if pl.Width != nil {
		objectMap["width"] = pl.Width
	}
	if pl.Height != nil {
		objectMap["height"] = pl.Height
	}
	if pl.Label != nil {
		objectMap["label"] = pl.Label
	}
	if pl.OdataType != "" {
		objectMap["@odata.type"] = pl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return nil, false
}

// AsH265Layer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsVideoLayer() (*VideoLayer, bool) {
	return nil, false
}

// AsBasicVideoLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return nil, false
}

// AsH264Layer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsPngLayer() (*PngLayer, bool) {
	return &pl, true
}

// AsLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for PngLayer.
func (pl PngLayer) AsBasicLayer() (BasicLayer, bool) {
	return &pl, true
}

// PresentationTimeRange the presentation time range, this is asset related and not recommended for Account
// Filter.
type PresentationTimeRange struct {
	// StartTimestamp - The absolute start time boundary.
	StartTimestamp *int64 `json:"startTimestamp,omitempty"`
	// EndTimestamp - The absolute end time boundary.
	EndTimestamp *int64 `json:"endTimestamp,omitempty"`
	// PresentationWindowDuration - The relative to end sliding window.
	PresentationWindowDuration *int64 `json:"presentationWindowDuration,omitempty"`
	// LiveBackoffDuration - The relative to end right edge.
	LiveBackoffDuration *int64 `json:"liveBackoffDuration,omitempty"`
	// Timescale - The time scale of time stamps.
	Timescale *int64 `json:"timescale,omitempty"`
	// ForceEndTimestamp - The indicator of forcing existing of end time stamp.
	ForceEndTimestamp *bool `json:"forceEndTimestamp,omitempty"`
}

// BasicPreset base type for all Presets, which define the recipe or instructions on how the input media files should
// be processed.
type BasicPreset interface {
	AsFaceDetectorPreset() (*FaceDetectorPreset, bool)
	AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool)
	AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool)
	AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool)
	AsStandardEncoderPreset() (*StandardEncoderPreset, bool)
	AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool)
	AsPreset() (*Preset, bool)
}

// Preset base type for all Presets, which define the recipe or instructions on how the input media files
// should be processed.
type Preset struct {
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

func unmarshalBasicPreset(body []byte) (BasicPreset, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaFaceDetectorPreset):
		var fdp FaceDetectorPreset
		err := json.Unmarshal(body, &fdp)
		return fdp, err
	case string(OdataTypeMicrosoftMediaAudioAnalyzerPreset):
		var aap AudioAnalyzerPreset
		err := json.Unmarshal(body, &aap)
		return aap, err
	case string(OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset):
		var bisep BuiltInStandardEncoderPreset
		err := json.Unmarshal(body, &bisep)
		return bisep, err
	case string(OdataTypeMicrosoftMediaStandardEncoderPreset):
		var sep StandardEncoderPreset
		err := json.Unmarshal(body, &sep)
		return sep, err
	case string(OdataTypeMicrosoftMediaVideoAnalyzerPreset):
		var vap VideoAnalyzerPreset
		err := json.Unmarshal(body, &vap)
		return vap, err
	default:
		var p Preset
		err := json.Unmarshal(body, &p)
		return p, err
	}
}
func unmarshalBasicPresetArray(body []byte) ([]BasicPreset, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pArray := make([]BasicPreset, len(rawMessages))

	for index, rawMessage := range rawMessages {
		p, err := unmarshalBasicPreset(*rawMessage)
		if err != nil {
			return nil, err
		}
		pArray[index] = p
	}
	return pArray, nil
}

// MarshalJSON is the custom marshaler for Preset.
func (p Preset) MarshalJSON() ([]byte, error) {
	p.OdataType = OdataTypePreset
	objectMap := make(map[string]interface{})
	if p.OdataType != "" {
		objectMap["@odata.type"] = p.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for Preset.
func (p Preset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return nil, false
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for Preset.
func (p Preset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for Preset.
func (p Preset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for Preset.
func (p Preset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return nil, false
}

// AsStandardEncoderPreset is the BasicPreset implementation for Preset.
func (p Preset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return nil, false
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for Preset.
func (p Preset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return nil, false
}

// AsPreset is the BasicPreset implementation for Preset.
func (p Preset) AsPreset() (*Preset, bool) {
	return &p, true
}

// AsBasicPreset is the BasicPreset implementation for Preset.
func (p Preset) AsBasicPreset() (BasicPreset, bool) {
	return &p, true
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - READ-ONLY; The ARM identifier for Private Endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection the Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connection associated with the specified
// storage account
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private endpoint connections
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private end point.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - The provisioning state of the private endpoint connection resource. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	autorest.Response `json:"-"`
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState a collection of information about the state of the connection between
// service consumer and provider.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service. Possible values include: 'Pending', 'Approved', 'Rejected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval/rejection of the connection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`
}

// Properties the service specification property.
type Properties struct {
	// ServiceSpecification - READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// Provider a resource provider.
type Provider struct {
	// ProviderName - The provider name.
	ProviderName *string `json:"providerName,omitempty"`
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// Rectangle describes the properties of a rectangular window applied to the input media before processing
// it.
type Rectangle struct {
	// Left - The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
	Left *string `json:"left,omitempty"`
	// Top - The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
	Top *string `json:"top,omitempty"`
	// Width - The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
	Width *string `json:"width,omitempty"`
	// Height - The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the video (For example, 50%).
	Height *string `json:"height,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// SelectAudioTrackByAttribute select audio tracks from the input by specifying an attribute and an
// attribute filter.
type SelectAudioTrackByAttribute struct {
	// Attribute - The TrackAttribute to filter the tracks by. Possible values include: 'Bitrate', 'Language'
	Attribute TrackAttribute `json:"attribute,omitempty"`
	// Filter - The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. Possible values include: 'All', 'Top', 'Bottom', 'ValueEquals'
	Filter AttributeFilter `json:"filter,omitempty"`
	// FilterValue - The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property.
	FilterValue *string `json:"filterValue,omitempty"`
	// ChannelMapping - Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks. Possible values include: 'FrontLeft', 'FrontRight', 'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft', 'StereoRight'
	ChannelMapping ChannelMapping `json:"channelMapping,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) MarshalJSON() ([]byte, error) {
	satba.OdataType = OdataTypeMicrosoftMediaSelectAudioTrackByAttribute
	objectMap := make(map[string]interface{})
	if satba.Attribute != "" {
		objectMap["attribute"] = satba.Attribute
	}
	if satba.Filter != "" {
		objectMap["filter"] = satba.Filter
	}
	if satba.FilterValue != nil {
		objectMap["filterValue"] = satba.FilterValue
	}
	if satba.ChannelMapping != "" {
		objectMap["channelMapping"] = satba.ChannelMapping
	}
	if satba.OdataType != "" {
		objectMap["@odata.type"] = satba.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return &satba, true
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return &satba, true
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return nil, false
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByAttribute.
func (satba SelectAudioTrackByAttribute) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &satba, true
}

// SelectAudioTrackByID select audio tracks from the input by specifying a track identifier.
type SelectAudioTrackByID struct {
	// TrackID - Track identifier to select
	TrackID *int64 `json:"trackId,omitempty"`
	// ChannelMapping - Optional designation for single channel audio tracks.  Can be used to combine the tracks into stereo or multi-channel audio tracks. Possible values include: 'FrontLeft', 'FrontRight', 'Center', 'LowFrequencyEffects', 'BackLeft', 'BackRight', 'StereoLeft', 'StereoRight'
	ChannelMapping ChannelMapping `json:"channelMapping,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) MarshalJSON() ([]byte, error) {
	satbi.OdataType = OdataTypeMicrosoftMediaSelectAudioTrackByID
	objectMap := make(map[string]interface{})
	if satbi.TrackID != nil {
		objectMap["trackId"] = satbi.TrackID
	}
	if satbi.ChannelMapping != "" {
		objectMap["channelMapping"] = satbi.ChannelMapping
	}
	if satbi.OdataType != "" {
		objectMap["@odata.type"] = satbi.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return &satbi, true
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return &satbi, true
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return nil, false
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for SelectAudioTrackByID.
func (satbi SelectAudioTrackByID) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &satbi, true
}

// SelectVideoTrackByAttribute select video tracks from the input by specifying an attribute and an
// attribute filter.
type SelectVideoTrackByAttribute struct {
	// Attribute - The TrackAttribute to filter the tracks by. Possible values include: 'Bitrate', 'Language'
	Attribute TrackAttribute `json:"attribute,omitempty"`
	// Filter - The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks. Possible values include: 'All', 'Top', 'Bottom', 'ValueEquals'
	Filter AttributeFilter `json:"filter,omitempty"`
	// FilterValue - The value to filter the tracks by.  Only used when AttributeFilter.ValueEquals is specified for the Filter property. For TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g: '1500000').  The TrackAttribute.Language is not supported for video tracks.
	FilterValue *string `json:"filterValue,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) MarshalJSON() ([]byte, error) {
	svtba.OdataType = OdataTypeMicrosoftMediaSelectVideoTrackByAttribute
	objectMap := make(map[string]interface{})
	if svtba.Attribute != "" {
		objectMap["attribute"] = svtba.Attribute
	}
	if svtba.Filter != "" {
		objectMap["filter"] = svtba.Filter
	}
	if svtba.FilterValue != nil {
		objectMap["filterValue"] = svtba.FilterValue
	}
	if svtba.OdataType != "" {
		objectMap["@odata.type"] = svtba.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return nil, false
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return &svtba, true
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return &svtba, true
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByAttribute.
func (svtba SelectVideoTrackByAttribute) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &svtba, true
}

// SelectVideoTrackByID select video tracks from the input by specifying a track identifier.
type SelectVideoTrackByID struct {
	// TrackID - Track identifier to select
	TrackID *int64 `json:"trackId,omitempty"`
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) MarshalJSON() ([]byte, error) {
	svtbi.OdataType = OdataTypeMicrosoftMediaSelectVideoTrackByID
	objectMap := make(map[string]interface{})
	if svtbi.TrackID != nil {
		objectMap["trackId"] = svtbi.TrackID
	}
	if svtbi.OdataType != "" {
		objectMap["@odata.type"] = svtbi.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return nil, false
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return &svtbi, true
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return &svtbi, true
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for SelectVideoTrackByID.
func (svtbi SelectVideoTrackByID) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &svtbi, true
}

// Service a Media Services account.
type Service struct {
	autorest.Response `json:"-"`
	// ServiceProperties - The resource properties.
	*ServiceProperties `json:"properties,omitempty"`
	// Identity - The Managed Identity for the Media Services account.
	Identity *ServiceIdentity `json:"identity,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Identity != nil {
		objectMap["identity"] = s.Identity
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "identity":
			if v != nil {
				var identity ServiceIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				s.Identity = &identity
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				s.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceCollection a collection of MediaService items.
type ServiceCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of MediaService items.
	Value *[]Service `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// ServiceCollectionIterator provides access to a complete listing of Service values.
type ServiceCollectionIterator struct {
	i    int
	page ServiceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceCollectionIterator) Response() ServiceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceCollectionIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceCollectionIterator type.
func NewServiceCollectionIterator(page ServiceCollectionPage) ServiceCollectionIterator {
	return ServiceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sc ServiceCollection) IsEmpty() bool {
	return sc.Value == nil || len(*sc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sc ServiceCollection) hasNextLink() bool {
	return sc.OdataNextLink != nil && len(*sc.OdataNextLink) != 0
}

// serviceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sc ServiceCollection) serviceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !sc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sc.OdataNextLink)))
}

// ServiceCollectionPage contains a page of Service values.
type ServiceCollectionPage struct {
	fn func(context.Context, ServiceCollection) (ServiceCollection, error)
	sc ServiceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sc)
		if err != nil {
			return err
		}
		page.sc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceCollectionPage) NotDone() bool {
	return !page.sc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceCollectionPage) Response() ServiceCollection {
	return page.sc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceCollectionPage) Values() []Service {
	if page.sc.IsEmpty() {
		return nil
	}
	return *page.sc.Value
}

// Creates a new instance of the ServiceCollectionPage type.
func NewServiceCollectionPage(cur ServiceCollection, getNextPage func(context.Context, ServiceCollection) (ServiceCollection, error)) ServiceCollectionPage {
	return ServiceCollectionPage{
		fn: getNextPage,
		sc: cur,
	}
}

// ServiceIdentity ...
type ServiceIdentity struct {
	// Type - The identity type. Possible values include: 'ManagedIdentityTypeSystemAssigned', 'ManagedIdentityTypeNone'
	Type ManagedIdentityType `json:"type,omitempty"`
	// PrincipalID - READ-ONLY; The Principal ID of the identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The Tenant ID of the identity.
	TenantID *string `json:"tenantId,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceIdentity.
func (si ServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if si.Type != "" {
		objectMap["type"] = si.Type
	}
	return json.Marshal(objectMap)
}

// ServiceProperties properties of the Media Services account.
type ServiceProperties struct {
	// MediaServiceID - READ-ONLY; The Media Services account ID.
	MediaServiceID *uuid.UUID `json:"mediaServiceId,omitempty"`
	// StorageAccounts - The storage accounts for this resource.
	StorageAccounts *[]StorageAccount `json:"storageAccounts,omitempty"`
	// StorageAuthentication - Possible values include: 'StorageAuthenticationSystem', 'StorageAuthenticationManagedIdentity'
	StorageAuthentication StorageAuthentication `json:"storageAuthentication,omitempty"`
	// Encryption - The account encryption properties.
	Encryption *AccountEncryption `json:"encryption,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.StorageAccounts != nil {
		objectMap["storageAccounts"] = sp.StorageAccounts
	}
	if sp.StorageAuthentication != "" {
		objectMap["storageAuthentication"] = sp.StorageAuthentication
	}
	if sp.Encryption != nil {
		objectMap["encryption"] = sp.Encryption
	}
	return json.Marshal(objectMap)
}

// ServiceSpecification the service metric specifications.
type ServiceSpecification struct {
	// LogSpecifications - READ-ONLY; List of log specifications.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - READ-ONLY; List of metric specifications.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// StandardEncoderPreset describes all the settings to be used when encoding the input video with the
// Standard Encoder.
type StandardEncoderPreset struct {
	// Filters - One or more filtering operations that are applied to the input media before encoding.
	Filters *Filters `json:"filters,omitempty"`
	// Codecs - The list of codecs to be used when encoding the input video.
	Codecs *[]BasicCodec `json:"codecs,omitempty"`
	// Formats - The list of outputs to be produced by the encoder.
	Formats *[]BasicFormat `json:"formats,omitempty"`
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for StandardEncoderPreset.
func (sep StandardEncoderPreset) MarshalJSON() ([]byte, error) {
	sep.OdataType = OdataTypeMicrosoftMediaStandardEncoderPreset
	objectMap := make(map[string]interface{})
	if sep.Filters != nil {
		objectMap["filters"] = sep.Filters
	}
	if sep.Codecs != nil {
		objectMap["codecs"] = sep.Codecs
	}
	if sep.Formats != nil {
		objectMap["formats"] = sep.Formats
	}
	if sep.OdataType != "" {
		objectMap["@odata.type"] = sep.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return nil, false
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return nil, false
}

// AsStandardEncoderPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return &sep, true
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return nil, false
}

// AsPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsPreset() (*Preset, bool) {
	return nil, false
}

// AsBasicPreset is the BasicPreset implementation for StandardEncoderPreset.
func (sep StandardEncoderPreset) AsBasicPreset() (BasicPreset, bool) {
	return &sep, true
}

// UnmarshalJSON is the custom unmarshaler for StandardEncoderPreset struct.
func (sep *StandardEncoderPreset) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "filters":
			if v != nil {
				var filters Filters
				err = json.Unmarshal(*v, &filters)
				if err != nil {
					return err
				}
				sep.Filters = &filters
			}
		case "codecs":
			if v != nil {
				codecs, err := unmarshalBasicCodecArray(*v)
				if err != nil {
					return err
				}
				sep.Codecs = &codecs
			}
		case "formats":
			if v != nil {
				formats, err := unmarshalBasicFormatArray(*v)
				if err != nil {
					return err
				}
				sep.Formats = &formats
			}
		case "@odata.type":
			if v != nil {
				var odataType OdataTypeBasicPreset
				err = json.Unmarshal(*v, &odataType)
				if err != nil {
					return err
				}
				sep.OdataType = odataType
			}
		}
	}

	return nil
}

// StorageAccount the storage account details.
type StorageAccount struct {
	// ID - The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage account must be a Standard Storage account (either Microsoft.ClassicStorage or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
	ID *string `json:"id,omitempty"`
	// Type - The type of the storage account. Possible values include: 'Primary', 'Secondary'
	Type StorageAccountType `json:"type,omitempty"`
}

// StorageEncryptedAssetDecryptionData data needed to decrypt asset files encrypted with legacy storage
// encryption.
type StorageEncryptedAssetDecryptionData struct {
	autorest.Response `json:"-"`
	// Key - The Asset File storage encryption key.
	Key *[]byte `json:"key,omitempty"`
	// AssetFileEncryptionMetadata - Asset File encryption metadata.
	AssetFileEncryptionMetadata *[]AssetFileEncryptionMetadata `json:"assetFileEncryptionMetadata,omitempty"`
}

// StreamingEndpoint the streaming endpoint.
type StreamingEndpoint struct {
	autorest.Response `json:"-"`
	// StreamingEndpointProperties - The streaming endpoint properties.
	*StreamingEndpointProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingEndpoint.
func (se StreamingEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if se.StreamingEndpointProperties != nil {
		objectMap["properties"] = se.StreamingEndpointProperties
	}
	if se.Tags != nil {
		objectMap["tags"] = se.Tags
	}
	if se.Location != nil {
		objectMap["location"] = se.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StreamingEndpoint struct.
func (se *StreamingEndpoint) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var streamingEndpointProperties StreamingEndpointProperties
				err = json.Unmarshal(*v, &streamingEndpointProperties)
				if err != nil {
					return err
				}
				se.StreamingEndpointProperties = &streamingEndpointProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				se.SystemData = &systemData
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				se.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				se.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				se.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				se.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				se.Type = &typeVar
			}
		}
	}

	return nil
}

// StreamingEndpointAccessControl streaming endpoint access control definition.
type StreamingEndpointAccessControl struct {
	// Akamai - The access control of Akamai
	Akamai *AkamaiAccessControl `json:"akamai,omitempty"`
	// IP - The IP access control of the streaming endpoint.
	IP *IPAccessControl `json:"ip,omitempty"`
}

// StreamingEndpointListResult the streaming endpoint list result.
type StreamingEndpointListResult struct {
	autorest.Response `json:"-"`
	// Value - The result of the List StreamingEndpoint operation.
	Value *[]StreamingEndpoint `json:"value,omitempty"`
	// OdataCount - The number of result.
	OdataCount *int32 `json:"@odata.count,omitempty"`
	// OdataNextLink - The link to the next set of results. Not empty if value contains incomplete list of streaming endpoints.
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// StreamingEndpointListResultIterator provides access to a complete listing of StreamingEndpoint values.
type StreamingEndpointListResultIterator struct {
	i    int
	page StreamingEndpointListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StreamingEndpointListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingEndpointListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StreamingEndpointListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StreamingEndpointListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StreamingEndpointListResultIterator) Response() StreamingEndpointListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StreamingEndpointListResultIterator) Value() StreamingEndpoint {
	if !iter.page.NotDone() {
		return StreamingEndpoint{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StreamingEndpointListResultIterator type.
func NewStreamingEndpointListResultIterator(page StreamingEndpointListResultPage) StreamingEndpointListResultIterator {
	return StreamingEndpointListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (selr StreamingEndpointListResult) IsEmpty() bool {
	return selr.Value == nil || len(*selr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (selr StreamingEndpointListResult) hasNextLink() bool {
	return selr.OdataNextLink != nil && len(*selr.OdataNextLink) != 0
}

// streamingEndpointListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (selr StreamingEndpointListResult) streamingEndpointListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !selr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(selr.OdataNextLink)))
}

// StreamingEndpointListResultPage contains a page of StreamingEndpoint values.
type StreamingEndpointListResultPage struct {
	fn   func(context.Context, StreamingEndpointListResult) (StreamingEndpointListResult, error)
	selr StreamingEndpointListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StreamingEndpointListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingEndpointListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.selr)
		if err != nil {
			return err
		}
		page.selr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StreamingEndpointListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StreamingEndpointListResultPage) NotDone() bool {
	return !page.selr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StreamingEndpointListResultPage) Response() StreamingEndpointListResult {
	return page.selr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StreamingEndpointListResultPage) Values() []StreamingEndpoint {
	if page.selr.IsEmpty() {
		return nil
	}
	return *page.selr.Value
}

// Creates a new instance of the StreamingEndpointListResultPage type.
func NewStreamingEndpointListResultPage(cur StreamingEndpointListResult, getNextPage func(context.Context, StreamingEndpointListResult) (StreamingEndpointListResult, error)) StreamingEndpointListResultPage {
	return StreamingEndpointListResultPage{
		fn:   getNextPage,
		selr: cur,
	}
}

// StreamingEndpointProperties the streaming endpoint properties.
type StreamingEndpointProperties struct {
	// Description - The streaming endpoint description.
	Description *string `json:"description,omitempty"`
	// ScaleUnits - The number of scale units. Use the Scale operation to adjust this value.
	ScaleUnits *int32 `json:"scaleUnits,omitempty"`
	// AvailabilitySetName - This feature is deprecated, do not set a value for this property.
	AvailabilitySetName *string `json:"availabilitySetName,omitempty"`
	// AccessControl - The access control definition of the streaming endpoint.
	AccessControl *StreamingEndpointAccessControl `json:"accessControl,omitempty"`
	// MaxCacheAge - Max cache age
	MaxCacheAge *int64 `json:"maxCacheAge,omitempty"`
	// CustomHostNames - The custom host names of the streaming endpoint
	CustomHostNames *[]string `json:"customHostNames,omitempty"`
	// HostName - READ-ONLY; The streaming endpoint host name.
	HostName *string `json:"hostName,omitempty"`
	// CdnEnabled - The CDN enabled flag.
	CdnEnabled *bool `json:"cdnEnabled,omitempty"`
	// CdnProvider - The CDN provider name.
	CdnProvider *string `json:"cdnProvider,omitempty"`
	// CdnProfile - The CDN profile name.
	CdnProfile *string `json:"cdnProfile,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the streaming endpoint.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ResourceState - READ-ONLY; The resource state of the streaming endpoint. Possible values include: 'StreamingEndpointResourceStateStopped', 'StreamingEndpointResourceStateStarting', 'StreamingEndpointResourceStateRunning', 'StreamingEndpointResourceStateStopping', 'StreamingEndpointResourceStateDeleting', 'StreamingEndpointResourceStateScaling'
	ResourceState StreamingEndpointResourceState `json:"resourceState,omitempty"`
	// CrossSiteAccessPolicies - The streaming endpoint access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies `json:"crossSiteAccessPolicies,omitempty"`
	// FreeTrialEndTime - READ-ONLY; The free trial expiration time.
	FreeTrialEndTime *date.Time `json:"freeTrialEndTime,omitempty"`
	// Created - READ-ONLY; The exact time the streaming endpoint was created.
	Created *date.Time `json:"created,omitempty"`
	// LastModified - READ-ONLY; The exact time the streaming endpoint was last modified.
	LastModified *date.Time `json:"lastModified,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingEndpointProperties.
func (sep StreamingEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sep.Description != nil {
		objectMap["description"] = sep.Description
	}
	if sep.ScaleUnits != nil {
		objectMap["scaleUnits"] = sep.ScaleUnits
	}
	if sep.AvailabilitySetName != nil {
		objectMap["availabilitySetName"] = sep.AvailabilitySetName
	}
	if sep.AccessControl != nil {
		objectMap["accessControl"] = sep.AccessControl
	}
	if sep.MaxCacheAge != nil {
		objectMap["maxCacheAge"] = sep.MaxCacheAge
	}
	if sep.CustomHostNames != nil {
		objectMap["customHostNames"] = sep.CustomHostNames
	}
	if sep.CdnEnabled != nil {
		objectMap["cdnEnabled"] = sep.CdnEnabled
	}
	if sep.CdnProvider != nil {
		objectMap["cdnProvider"] = sep.CdnProvider
	}
	if sep.CdnProfile != nil {
		objectMap["cdnProfile"] = sep.CdnProfile
	}
	if sep.CrossSiteAccessPolicies != nil {
		objectMap["crossSiteAccessPolicies"] = sep.CrossSiteAccessPolicies
	}
	return json.Marshal(objectMap)
}

// StreamingEndpointsCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StreamingEndpointsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (StreamingEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsCreateFuture.Result.
func (future *StreamingEndpointsCreateFuture) result(client StreamingEndpointsClient) (se StreamingEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if se.Response.Response, err = future.GetResult(sender); err == nil && se.Response.Response.StatusCode != http.StatusNoContent {
		se, err = client.CreateResponder(se.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "media.StreamingEndpointsCreateFuture", "Result", se.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StreamingEndpointsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StreamingEndpointsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsDeleteFuture.Result.
func (future *StreamingEndpointsDeleteFuture) result(client StreamingEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingEndpointsScaleFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingEndpointsScaleFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsScaleFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsScaleFuture.Result.
func (future *StreamingEndpointsScaleFuture) result(client StreamingEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsScaleFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsScaleFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingEndpointsStartFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingEndpointsStartFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsStartFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsStartFuture.Result.
func (future *StreamingEndpointsStartFuture) result(client StreamingEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsStartFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsStartFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingEndpointsStopFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type StreamingEndpointsStopFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsStopFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsStopFuture.Result.
func (future *StreamingEndpointsStopFuture) result(client StreamingEndpointsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsStopFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsStopFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// StreamingEndpointsUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type StreamingEndpointsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(StreamingEndpointsClient) (StreamingEndpoint, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *StreamingEndpointsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for StreamingEndpointsUpdateFuture.Result.
func (future *StreamingEndpointsUpdateFuture) result(client StreamingEndpointsClient) (se StreamingEndpoint, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "media.StreamingEndpointsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("media.StreamingEndpointsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if se.Response.Response, err = future.GetResult(sender); err == nil && se.Response.Response.StatusCode != http.StatusNoContent {
		se, err = client.UpdateResponder(se.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "media.StreamingEndpointsUpdateFuture", "Result", se.Response.Response, "Failure responding to request")
		}
	}
	return
}

// StreamingEntityScaleUnit scale units definition
type StreamingEntityScaleUnit struct {
	// ScaleUnit - The scale unit number of the streaming endpoint.
	ScaleUnit *int32 `json:"scaleUnit,omitempty"`
}

// StreamingLocator a Streaming Locator resource
type StreamingLocator struct {
	autorest.Response           `json:"-"`
	*StreamingLocatorProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingLocator.
func (sl StreamingLocator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.StreamingLocatorProperties != nil {
		objectMap["properties"] = sl.StreamingLocatorProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StreamingLocator struct.
func (sl *StreamingLocator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var streamingLocatorProperties StreamingLocatorProperties
				err = json.Unmarshal(*v, &streamingLocatorProperties)
				if err != nil {
					return err
				}
				sl.StreamingLocatorProperties = &streamingLocatorProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sl.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// StreamingLocatorCollection a collection of StreamingLocator items.
type StreamingLocatorCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of StreamingLocator items.
	Value *[]StreamingLocator `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// StreamingLocatorCollectionIterator provides access to a complete listing of StreamingLocator values.
type StreamingLocatorCollectionIterator struct {
	i    int
	page StreamingLocatorCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StreamingLocatorCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingLocatorCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StreamingLocatorCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StreamingLocatorCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StreamingLocatorCollectionIterator) Response() StreamingLocatorCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StreamingLocatorCollectionIterator) Value() StreamingLocator {
	if !iter.page.NotDone() {
		return StreamingLocator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StreamingLocatorCollectionIterator type.
func NewStreamingLocatorCollectionIterator(page StreamingLocatorCollectionPage) StreamingLocatorCollectionIterator {
	return StreamingLocatorCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slc StreamingLocatorCollection) IsEmpty() bool {
	return slc.Value == nil || len(*slc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slc StreamingLocatorCollection) hasNextLink() bool {
	return slc.OdataNextLink != nil && len(*slc.OdataNextLink) != 0
}

// streamingLocatorCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slc StreamingLocatorCollection) streamingLocatorCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !slc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slc.OdataNextLink)))
}

// StreamingLocatorCollectionPage contains a page of StreamingLocator values.
type StreamingLocatorCollectionPage struct {
	fn  func(context.Context, StreamingLocatorCollection) (StreamingLocatorCollection, error)
	slc StreamingLocatorCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StreamingLocatorCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingLocatorCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slc)
		if err != nil {
			return err
		}
		page.slc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StreamingLocatorCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StreamingLocatorCollectionPage) NotDone() bool {
	return !page.slc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StreamingLocatorCollectionPage) Response() StreamingLocatorCollection {
	return page.slc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StreamingLocatorCollectionPage) Values() []StreamingLocator {
	if page.slc.IsEmpty() {
		return nil
	}
	return *page.slc.Value
}

// Creates a new instance of the StreamingLocatorCollectionPage type.
func NewStreamingLocatorCollectionPage(cur StreamingLocatorCollection, getNextPage func(context.Context, StreamingLocatorCollection) (StreamingLocatorCollection, error)) StreamingLocatorCollectionPage {
	return StreamingLocatorCollectionPage{
		fn:  getNextPage,
		slc: cur,
	}
}

// StreamingLocatorContentKey class for content key in Streaming Locator
type StreamingLocatorContentKey struct {
	// ID - ID of Content Key
	ID *uuid.UUID `json:"id,omitempty"`
	// Type - READ-ONLY; Encryption type of Content Key. Possible values include: 'StreamingLocatorContentKeyTypeCommonEncryptionCenc', 'StreamingLocatorContentKeyTypeCommonEncryptionCbcs', 'StreamingLocatorContentKeyTypeEnvelopeEncryption'
	Type StreamingLocatorContentKeyType `json:"type,omitempty"`
	// LabelReferenceInStreamingPolicy - Label of Content Key as specified in the Streaming Policy
	LabelReferenceInStreamingPolicy *string `json:"labelReferenceInStreamingPolicy,omitempty"`
	// Value - Value of Content Key
	Value *string `json:"value,omitempty"`
	// PolicyName - READ-ONLY; ContentKeyPolicy used by Content Key
	PolicyName *string `json:"policyName,omitempty"`
	// Tracks - READ-ONLY; Tracks which use this Content Key
	Tracks *[]TrackSelection `json:"tracks,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingLocatorContentKey.
func (slck StreamingLocatorContentKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slck.ID != nil {
		objectMap["id"] = slck.ID
	}
	if slck.LabelReferenceInStreamingPolicy != nil {
		objectMap["labelReferenceInStreamingPolicy"] = slck.LabelReferenceInStreamingPolicy
	}
	if slck.Value != nil {
		objectMap["value"] = slck.Value
	}
	return json.Marshal(objectMap)
}

// StreamingLocatorProperties properties of the Streaming Locator.
type StreamingLocatorProperties struct {
	// AssetName - Asset Name
	AssetName *string `json:"assetName,omitempty"`
	// Created - READ-ONLY; The creation time of the Streaming Locator.
	Created *date.Time `json:"created,omitempty"`
	// StartTime - The start time of the Streaming Locator.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time of the Streaming Locator.
	EndTime *date.Time `json:"endTime,omitempty"`
	// StreamingLocatorID - The StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *uuid.UUID `json:"streamingLocatorId,omitempty"`
	// StreamingPolicyName - Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you created or use one of the predefined Streaming Policies. The predefined Streaming Policies available are: 'Predefined_DownloadOnly', 'Predefined_ClearStreamingOnly', 'Predefined_DownloadAndClearStreaming', 'Predefined_ClearKey', 'Predefined_MultiDrmCencStreaming' and 'Predefined_MultiDrmStreaming'
	StreamingPolicyName *string `json:"streamingPolicyName,omitempty"`
	// DefaultContentKeyPolicyName - Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty"`
	// ContentKeys - The ContentKeys used by this Streaming Locator.
	ContentKeys *[]StreamingLocatorContentKey `json:"contentKeys,omitempty"`
	// AlternativeMediaID - Alternative Media ID of this Streaming Locator
	AlternativeMediaID *string `json:"alternativeMediaId,omitempty"`
	// Filters - A list of asset or account filters which apply to this streaming locator
	Filters *[]string `json:"filters,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingLocatorProperties.
func (slp StreamingLocatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if slp.AssetName != nil {
		objectMap["assetName"] = slp.AssetName
	}
	if slp.StartTime != nil {
		objectMap["startTime"] = slp.StartTime
	}
	if slp.EndTime != nil {
		objectMap["endTime"] = slp.EndTime
	}
	if slp.StreamingLocatorID != nil {
		objectMap["streamingLocatorId"] = slp.StreamingLocatorID
	}
	if slp.StreamingPolicyName != nil {
		objectMap["streamingPolicyName"] = slp.StreamingPolicyName
	}
	if slp.DefaultContentKeyPolicyName != nil {
		objectMap["defaultContentKeyPolicyName"] = slp.DefaultContentKeyPolicyName
	}
	if slp.ContentKeys != nil {
		objectMap["contentKeys"] = slp.ContentKeys
	}
	if slp.AlternativeMediaID != nil {
		objectMap["alternativeMediaId"] = slp.AlternativeMediaID
	}
	if slp.Filters != nil {
		objectMap["filters"] = slp.Filters
	}
	return json.Marshal(objectMap)
}

// StreamingPath class of paths for streaming
type StreamingPath struct {
	// StreamingProtocol - Streaming protocol. Possible values include: 'StreamingPolicyStreamingProtocolHls', 'StreamingPolicyStreamingProtocolDash', 'StreamingPolicyStreamingProtocolSmoothStreaming', 'StreamingPolicyStreamingProtocolDownload'
	StreamingProtocol StreamingPolicyStreamingProtocol `json:"streamingProtocol,omitempty"`
	// EncryptionScheme - Encryption scheme. Possible values include: 'EncryptionSchemeNoEncryption', 'EncryptionSchemeEnvelopeEncryption', 'EncryptionSchemeCommonEncryptionCenc', 'EncryptionSchemeCommonEncryptionCbcs'
	EncryptionScheme EncryptionScheme `json:"encryptionScheme,omitempty"`
	// Paths - Streaming paths for each protocol and encryptionScheme pair
	Paths *[]string `json:"paths,omitempty"`
}

// StreamingPolicy a Streaming Policy resource
type StreamingPolicy struct {
	autorest.Response          `json:"-"`
	*StreamingPolicyProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingPolicy.
func (sp StreamingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.StreamingPolicyProperties != nil {
		objectMap["properties"] = sp.StreamingPolicyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for StreamingPolicy struct.
func (sp *StreamingPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var streamingPolicyProperties StreamingPolicyProperties
				err = json.Unmarshal(*v, &streamingPolicyProperties)
				if err != nil {
					return err
				}
				sp.StreamingPolicyProperties = &streamingPolicyProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sp.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// StreamingPolicyCollection a collection of StreamingPolicy items.
type StreamingPolicyCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of StreamingPolicy items.
	Value *[]StreamingPolicy `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// StreamingPolicyCollectionIterator provides access to a complete listing of StreamingPolicy values.
type StreamingPolicyCollectionIterator struct {
	i    int
	page StreamingPolicyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *StreamingPolicyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingPolicyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *StreamingPolicyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter StreamingPolicyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter StreamingPolicyCollectionIterator) Response() StreamingPolicyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter StreamingPolicyCollectionIterator) Value() StreamingPolicy {
	if !iter.page.NotDone() {
		return StreamingPolicy{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the StreamingPolicyCollectionIterator type.
func NewStreamingPolicyCollectionIterator(page StreamingPolicyCollectionPage) StreamingPolicyCollectionIterator {
	return StreamingPolicyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (spc StreamingPolicyCollection) IsEmpty() bool {
	return spc.Value == nil || len(*spc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (spc StreamingPolicyCollection) hasNextLink() bool {
	return spc.OdataNextLink != nil && len(*spc.OdataNextLink) != 0
}

// streamingPolicyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (spc StreamingPolicyCollection) streamingPolicyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !spc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(spc.OdataNextLink)))
}

// StreamingPolicyCollectionPage contains a page of StreamingPolicy values.
type StreamingPolicyCollectionPage struct {
	fn  func(context.Context, StreamingPolicyCollection) (StreamingPolicyCollection, error)
	spc StreamingPolicyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *StreamingPolicyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StreamingPolicyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.spc)
		if err != nil {
			return err
		}
		page.spc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *StreamingPolicyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page StreamingPolicyCollectionPage) NotDone() bool {
	return !page.spc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page StreamingPolicyCollectionPage) Response() StreamingPolicyCollection {
	return page.spc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page StreamingPolicyCollectionPage) Values() []StreamingPolicy {
	if page.spc.IsEmpty() {
		return nil
	}
	return *page.spc.Value
}

// Creates a new instance of the StreamingPolicyCollectionPage type.
func NewStreamingPolicyCollectionPage(cur StreamingPolicyCollection, getNextPage func(context.Context, StreamingPolicyCollection) (StreamingPolicyCollection, error)) StreamingPolicyCollectionPage {
	return StreamingPolicyCollectionPage{
		fn:  getNextPage,
		spc: cur,
	}
}

// StreamingPolicyContentKey class to specify properties of content key
type StreamingPolicyContentKey struct {
	// Label - Label can be used to specify Content Key when creating a Streaming Locator
	Label *string `json:"label,omitempty"`
	// PolicyName - Policy used by Content Key
	PolicyName *string `json:"policyName,omitempty"`
	// Tracks - Tracks which use this content key
	Tracks *[]TrackSelection `json:"tracks,omitempty"`
}

// StreamingPolicyContentKeys class to specify properties of all content keys in Streaming Policy
type StreamingPolicyContentKeys struct {
	// DefaultKey - Default content key for an encryption scheme
	DefaultKey *DefaultKey `json:"defaultKey,omitempty"`
	// KeyToTrackMappings - Representing tracks needs separate content key
	KeyToTrackMappings *[]StreamingPolicyContentKey `json:"keyToTrackMappings,omitempty"`
}

// StreamingPolicyFairPlayConfiguration class to specify configurations of FairPlay in Streaming Policy
type StreamingPolicyFairPlayConfiguration struct {
	// CustomLicenseAcquisitionURLTemplate - Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`
	// AllowPersistentLicense - All license to be persistent or not
	AllowPersistentLicense *bool `json:"allowPersistentLicense,omitempty"`
}

// StreamingPolicyPlayReadyConfiguration class to specify configurations of PlayReady in Streaming Policy
type StreamingPolicyPlayReadyConfiguration struct {
	// CustomLicenseAcquisitionURLTemplate - Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`
	// PlayReadyCustomAttributes - Custom attributes for PlayReady
	PlayReadyCustomAttributes *string `json:"playReadyCustomAttributes,omitempty"`
}

// StreamingPolicyProperties class to specify properties of Streaming Policy
type StreamingPolicyProperties struct {
	// Created - READ-ONLY; Creation time of Streaming Policy
	Created *date.Time `json:"created,omitempty"`
	// DefaultContentKeyPolicyName - Default ContentKey used by current Streaming Policy
	DefaultContentKeyPolicyName *string `json:"defaultContentKeyPolicyName,omitempty"`
	// EnvelopeEncryption - Configuration of EnvelopeEncryption
	EnvelopeEncryption *EnvelopeEncryption `json:"envelopeEncryption,omitempty"`
	// CommonEncryptionCenc - Configuration of CommonEncryptionCenc
	CommonEncryptionCenc *CommonEncryptionCenc `json:"commonEncryptionCenc,omitempty"`
	// CommonEncryptionCbcs - Configuration of CommonEncryptionCbcs
	CommonEncryptionCbcs *CommonEncryptionCbcs `json:"commonEncryptionCbcs,omitempty"`
	// NoEncryption - Configurations of NoEncryption
	NoEncryption *NoEncryption `json:"noEncryption,omitempty"`
}

// MarshalJSON is the custom marshaler for StreamingPolicyProperties.
func (spp StreamingPolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.DefaultContentKeyPolicyName != nil {
		objectMap["defaultContentKeyPolicyName"] = spp.DefaultContentKeyPolicyName
	}
	if spp.EnvelopeEncryption != nil {
		objectMap["envelopeEncryption"] = spp.EnvelopeEncryption
	}
	if spp.CommonEncryptionCenc != nil {
		objectMap["commonEncryptionCenc"] = spp.CommonEncryptionCenc
	}
	if spp.CommonEncryptionCbcs != nil {
		objectMap["commonEncryptionCbcs"] = spp.CommonEncryptionCbcs
	}
	if spp.NoEncryption != nil {
		objectMap["noEncryption"] = spp.NoEncryption
	}
	return json.Marshal(objectMap)
}

// StreamingPolicyWidevineConfiguration class to specify configurations of Widevine in Streaming Policy
type StreamingPolicyWidevineConfiguration struct {
	// CustomLicenseAcquisitionURLTemplate - Template for the URL of the custom service delivering licenses to end user players.  Not required when using Azure Media Services for issuing licenses.  The template supports replaceable tokens that the service will update at runtime with the value specific to the request.  The currently supported token values are {AlternativeMediaId}, which is replaced with the value of StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomLicenseAcquisitionURLTemplate *string `json:"customLicenseAcquisitionUrlTemplate,omitempty"`
}

// SyncStorageKeysInput the input to the sync storage keys request.
type SyncStorageKeysInput struct {
	// ID - The ID of the storage account resource.
	ID *string `json:"id,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// BasicTrackDescriptor base type for all TrackDescriptor types, which define the metadata and selection for tracks
// that should be processed by a Job
type BasicTrackDescriptor interface {
	AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool)
	AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool)
	AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool)
	AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool)
	AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool)
	AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool)
	AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool)
	AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool)
	AsTrackDescriptor() (*TrackDescriptor, bool)
}

// TrackDescriptor base type for all TrackDescriptor types, which define the metadata and selection for tracks
// that should be processed by a Job
type TrackDescriptor struct {
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

func unmarshalBasicTrackDescriptor(body []byte) (BasicTrackDescriptor, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaAudioTrackDescriptor):
		var atd AudioTrackDescriptor
		err := json.Unmarshal(body, &atd)
		return atd, err
	case string(OdataTypeMicrosoftMediaSelectAudioTrackByAttribute):
		var satba SelectAudioTrackByAttribute
		err := json.Unmarshal(body, &satba)
		return satba, err
	case string(OdataTypeMicrosoftMediaSelectAudioTrackByID):
		var satbi SelectAudioTrackByID
		err := json.Unmarshal(body, &satbi)
		return satbi, err
	case string(OdataTypeMicrosoftMediaVideoTrackDescriptor):
		var vtd VideoTrackDescriptor
		err := json.Unmarshal(body, &vtd)
		return vtd, err
	case string(OdataTypeMicrosoftMediaSelectVideoTrackByAttribute):
		var svtba SelectVideoTrackByAttribute
		err := json.Unmarshal(body, &svtba)
		return svtba, err
	case string(OdataTypeMicrosoftMediaSelectVideoTrackByID):
		var svtbi SelectVideoTrackByID
		err := json.Unmarshal(body, &svtbi)
		return svtbi, err
	default:
		var td TrackDescriptor
		err := json.Unmarshal(body, &td)
		return td, err
	}
}
func unmarshalBasicTrackDescriptorArray(body []byte) ([]BasicTrackDescriptor, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tdArray := make([]BasicTrackDescriptor, len(rawMessages))

	for index, rawMessage := range rawMessages {
		td, err := unmarshalBasicTrackDescriptor(*rawMessage)
		if err != nil {
			return nil, err
		}
		tdArray[index] = td
	}
	return tdArray, nil
}

// MarshalJSON is the custom marshaler for TrackDescriptor.
func (td TrackDescriptor) MarshalJSON() ([]byte, error) {
	td.OdataType = OdataTypeTrackDescriptor
	objectMap := make(map[string]interface{})
	if td.OdataType != "" {
		objectMap["@odata.type"] = td.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return nil, false
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return nil, false
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return nil, false
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return &td, true
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for TrackDescriptor.
func (td TrackDescriptor) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &td, true
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// TrackPropertyCondition class to specify one track property condition
type TrackPropertyCondition struct {
	// Property - Track property type. Possible values include: 'TrackPropertyTypeUnknown', 'TrackPropertyTypeFourCC'
	Property TrackPropertyType `json:"property,omitempty"`
	// Operation - Track property condition operation. Possible values include: 'TrackPropertyCompareOperationUnknown', 'TrackPropertyCompareOperationEqual'
	Operation TrackPropertyCompareOperation `json:"operation,omitempty"`
	// Value - Track property value
	Value *string `json:"value,omitempty"`
}

// TrackSelection class to select a track
type TrackSelection struct {
	// TrackSelections - TrackSelections is a track property condition list which can specify track(s)
	TrackSelections *[]TrackPropertyCondition `json:"trackSelections,omitempty"`
}

// Transform a Transform encapsulates the rules or instructions for generating desired outputs from input
// media, such as by transcoding or by extracting insights. After the Transform is created, it can be
// applied to input media by creating Jobs.
type Transform struct {
	autorest.Response `json:"-"`
	// TransformProperties - The resource properties.
	*TransformProperties `json:"properties,omitempty"`
	// SystemData - READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData `json:"systemData,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Transform.
func (t Transform) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TransformProperties != nil {
		objectMap["properties"] = t.TransformProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Transform struct.
func (t *Transform) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var transformProperties TransformProperties
				err = json.Unmarshal(*v, &transformProperties)
				if err != nil {
					return err
				}
				t.TransformProperties = &transformProperties
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				t.SystemData = &systemData
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		}
	}

	return nil
}

// TransformCollection a collection of Transform items.
type TransformCollection struct {
	autorest.Response `json:"-"`
	// Value - A collection of Transform items.
	Value *[]Transform `json:"value,omitempty"`
	// OdataNextLink - A link to the next page of the collection (when the collection contains too many results to return in one response).
	OdataNextLink *string `json:"@odata.nextLink,omitempty"`
}

// TransformCollectionIterator provides access to a complete listing of Transform values.
type TransformCollectionIterator struct {
	i    int
	page TransformCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TransformCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransformCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TransformCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TransformCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TransformCollectionIterator) Response() TransformCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TransformCollectionIterator) Value() Transform {
	if !iter.page.NotDone() {
		return Transform{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TransformCollectionIterator type.
func NewTransformCollectionIterator(page TransformCollectionPage) TransformCollectionIterator {
	return TransformCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tc TransformCollection) IsEmpty() bool {
	return tc.Value == nil || len(*tc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tc TransformCollection) hasNextLink() bool {
	return tc.OdataNextLink != nil && len(*tc.OdataNextLink) != 0
}

// transformCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tc TransformCollection) transformCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !tc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tc.OdataNextLink)))
}

// TransformCollectionPage contains a page of Transform values.
type TransformCollectionPage struct {
	fn func(context.Context, TransformCollection) (TransformCollection, error)
	tc TransformCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TransformCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TransformCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tc)
		if err != nil {
			return err
		}
		page.tc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TransformCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TransformCollectionPage) NotDone() bool {
	return !page.tc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TransformCollectionPage) Response() TransformCollection {
	return page.tc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TransformCollectionPage) Values() []Transform {
	if page.tc.IsEmpty() {
		return nil
	}
	return *page.tc.Value
}

// Creates a new instance of the TransformCollectionPage type.
func NewTransformCollectionPage(cur TransformCollection, getNextPage func(context.Context, TransformCollection) (TransformCollection, error)) TransformCollectionPage {
	return TransformCollectionPage{
		fn: getNextPage,
		tc: cur,
	}
}

// TransformOutput describes the properties of a TransformOutput, which are the rules to be applied while
// generating the desired output.
type TransformOutput struct {
	// OnError - A Transform can define more than one outputs. This property defines what the service should do when one output fails - either continue to produce other outputs, or, stop the other outputs. The overall Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'. Possible values include: 'StopProcessingJob', 'ContinueJob'
	OnError OnErrorType `json:"onError,omitempty"`
	// RelativePriority - Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for processing TransformOutputs. The default priority is Normal. Possible values include: 'PriorityLow', 'PriorityNormal', 'PriorityHigh'
	RelativePriority Priority `json:"relativePriority,omitempty"`
	// Preset - Preset that describes the operations that will be used to modify, transcode, or extract insights from the source file to generate the output.
	Preset BasicPreset `json:"preset,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TransformOutput struct.
func (toVar *TransformOutput) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "onError":
			if v != nil {
				var onError OnErrorType
				err = json.Unmarshal(*v, &onError)
				if err != nil {
					return err
				}
				toVar.OnError = onError
			}
		case "relativePriority":
			if v != nil {
				var relativePriority Priority
				err = json.Unmarshal(*v, &relativePriority)
				if err != nil {
					return err
				}
				toVar.RelativePriority = relativePriority
			}
		case "preset":
			if v != nil {
				preset, err := unmarshalBasicPreset(*v)
				if err != nil {
					return err
				}
				toVar.Preset = preset
			}
		}
	}

	return nil
}

// TransformProperties a Transform.
type TransformProperties struct {
	// Created - READ-ONLY; The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *date.Time `json:"created,omitempty"`
	// Description - An optional verbose description of the Transform.
	Description *string `json:"description,omitempty"`
	// LastModified - READ-ONLY; The UTC date and time when the Transform was last updated, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *date.Time `json:"lastModified,omitempty"`
	// Outputs - An array of one or more TransformOutputs that the Transform should generate.
	Outputs *[]TransformOutput `json:"outputs,omitempty"`
}

// MarshalJSON is the custom marshaler for TransformProperties.
func (tp TransformProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Description != nil {
		objectMap["description"] = tp.Description
	}
	if tp.Outputs != nil {
		objectMap["outputs"] = tp.Outputs
	}
	return json.Marshal(objectMap)
}

// TransportStreamFormat describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC
// 13818-1) output video file(s).
type TransportStreamFormat struct {
	// OutputFiles - The list of output files to produce.  Each entry in the list is a set of audio and video layer labels to be muxed together .
	OutputFiles *[]OutputFile `json:"outputFiles,omitempty"`
	// FilenamePattern - The pattern of the file names for the generated output files. The following macros are supported in the file name: {Basename} - An expansion macro that will use the name of the input video file. If the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of input video files will be used. If the length of base name of the input video file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate extension for this format. {Label} - The label assigned to the codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {Bitrate} - The audio/video bitrate. Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted macros will be collapsed and removed from the filename.
	FilenamePattern *string `json:"filenamePattern,omitempty"`
	// OdataType - Possible values include: 'OdataTypeFormat', 'OdataTypeMicrosoftMediaImageFormat', 'OdataTypeMicrosoftMediaJpgFormat', 'OdataTypeMicrosoftMediaPngFormat', 'OdataTypeMicrosoftMediaMultiBitrateFormat', 'OdataTypeMicrosoftMediaMp4Format', 'OdataTypeMicrosoftMediaTransportStreamFormat'
	OdataType OdataTypeBasicFormat `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for TransportStreamFormat.
func (tsf TransportStreamFormat) MarshalJSON() ([]byte, error) {
	tsf.OdataType = OdataTypeMicrosoftMediaTransportStreamFormat
	objectMap := make(map[string]interface{})
	if tsf.OutputFiles != nil {
		objectMap["outputFiles"] = tsf.OutputFiles
	}
	if tsf.FilenamePattern != nil {
		objectMap["filenamePattern"] = tsf.FilenamePattern
	}
	if tsf.OdataType != "" {
		objectMap["@odata.type"] = tsf.OdataType
	}
	return json.Marshal(objectMap)
}

// AsImageFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsImageFormat() (*ImageFormat, bool) {
	return nil, false
}

// AsBasicImageFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsBasicImageFormat() (BasicImageFormat, bool) {
	return nil, false
}

// AsJpgFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsJpgFormat() (*JpgFormat, bool) {
	return nil, false
}

// AsPngFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsPngFormat() (*PngFormat, bool) {
	return nil, false
}

// AsMultiBitrateFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsMultiBitrateFormat() (*MultiBitrateFormat, bool) {
	return nil, false
}

// AsBasicMultiBitrateFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsBasicMultiBitrateFormat() (BasicMultiBitrateFormat, bool) {
	return &tsf, true
}

// AsMp4Format is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsMp4Format() (*Mp4Format, bool) {
	return nil, false
}

// AsTransportStreamFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsTransportStreamFormat() (*TransportStreamFormat, bool) {
	return &tsf, true
}

// AsFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsFormat() (*Format, bool) {
	return nil, false
}

// AsBasicFormat is the BasicFormat implementation for TransportStreamFormat.
func (tsf TransportStreamFormat) AsBasicFormat() (BasicFormat, bool) {
	return &tsf, true
}

// UtcClipTime specifies the clip time as a Utc time position in the media file.  The Utc time can point to
// a different position depending on whether the media file starts from a timestamp of zero or not.
type UtcClipTime struct {
	// Time - The time position on the timeline of the input media based on Utc time.
	Time *date.Time `json:"time,omitempty"`
	// OdataType - Possible values include: 'OdataTypeClipTime', 'OdataTypeMicrosoftMediaAbsoluteClipTime', 'OdataTypeMicrosoftMediaUtcClipTime'
	OdataType OdataTypeBasicClipTime `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for UtcClipTime.
func (uct UtcClipTime) MarshalJSON() ([]byte, error) {
	uct.OdataType = OdataTypeMicrosoftMediaUtcClipTime
	objectMap := make(map[string]interface{})
	if uct.Time != nil {
		objectMap["time"] = uct.Time
	}
	if uct.OdataType != "" {
		objectMap["@odata.type"] = uct.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAbsoluteClipTime is the BasicClipTime implementation for UtcClipTime.
func (uct UtcClipTime) AsAbsoluteClipTime() (*AbsoluteClipTime, bool) {
	return nil, false
}

// AsUtcClipTime is the BasicClipTime implementation for UtcClipTime.
func (uct UtcClipTime) AsUtcClipTime() (*UtcClipTime, bool) {
	return &uct, true
}

// AsClipTime is the BasicClipTime implementation for UtcClipTime.
func (uct UtcClipTime) AsClipTime() (*ClipTime, bool) {
	return nil, false
}

// AsBasicClipTime is the BasicClipTime implementation for UtcClipTime.
func (uct UtcClipTime) AsBasicClipTime() (BasicClipTime, bool) {
	return &uct, true
}

// BasicVideo describes the basic properties for encoding the input video.
type BasicVideo interface {
	AsH265Video() (*H265Video, bool)
	AsImage() (*Image, bool)
	AsBasicImage() (BasicImage, bool)
	AsH264Video() (*H264Video, bool)
	AsJpgImage() (*JpgImage, bool)
	AsPngImage() (*PngImage, bool)
	AsVideo() (*Video, bool)
}

// Video describes the basic properties for encoding the input video.
type Video struct {
	// KeyFrameInterval - The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601 format. The default is 2 seconds(PT2S). Note that this setting is ignored if VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string `json:"keyFrameInterval,omitempty"`
	// StretchMode - The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize. Possible values include: 'StretchModeNone', 'StretchModeAutoSize', 'StretchModeAutoFit'
	StretchMode StretchMode `json:"stretchMode,omitempty"`
	// SyncMode - The Video Sync Mode. Possible values include: 'VideoSyncModeAuto', 'VideoSyncModePassthrough', 'VideoSyncModeCfr', 'VideoSyncModeVfr'
	SyncMode VideoSyncMode `json:"syncMode,omitempty"`
	// Label - An optional label for the codec. The label can be used to control muxing behavior.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeCodec', 'OdataTypeMicrosoftMediaAudio', 'OdataTypeMicrosoftMediaAacAudio', 'OdataTypeMicrosoftMediaVideo', 'OdataTypeMicrosoftMediaH265Video', 'OdataTypeMicrosoftMediaCopyVideo', 'OdataTypeMicrosoftMediaImage', 'OdataTypeMicrosoftMediaCopyAudio', 'OdataTypeMicrosoftMediaH264Video', 'OdataTypeMicrosoftMediaJpgImage', 'OdataTypeMicrosoftMediaPngImage'
	OdataType OdataTypeBasicCodec `json:"@odata.type,omitempty"`
}

func unmarshalBasicVideo(body []byte) (BasicVideo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaH265Video):
		var hv H265Video
		err := json.Unmarshal(body, &hv)
		return hv, err
	case string(OdataTypeMicrosoftMediaImage):
		var i Image
		err := json.Unmarshal(body, &i)
		return i, err
	case string(OdataTypeMicrosoftMediaH264Video):
		var hv H264Video
		err := json.Unmarshal(body, &hv)
		return hv, err
	case string(OdataTypeMicrosoftMediaJpgImage):
		var ji JpgImage
		err := json.Unmarshal(body, &ji)
		return ji, err
	case string(OdataTypeMicrosoftMediaPngImage):
		var pi PngImage
		err := json.Unmarshal(body, &pi)
		return pi, err
	default:
		var vVar Video
		err := json.Unmarshal(body, &vVar)
		return vVar, err
	}
}
func unmarshalBasicVideoArray(body []byte) ([]BasicVideo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vVarArray := make([]BasicVideo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vVar, err := unmarshalBasicVideo(*rawMessage)
		if err != nil {
			return nil, err
		}
		vVarArray[index] = vVar
	}
	return vVarArray, nil
}

// MarshalJSON is the custom marshaler for Video.
func (vVar Video) MarshalJSON() ([]byte, error) {
	vVar.OdataType = OdataTypeMicrosoftMediaVideo
	objectMap := make(map[string]interface{})
	if vVar.KeyFrameInterval != nil {
		objectMap["keyFrameInterval"] = vVar.KeyFrameInterval
	}
	if vVar.StretchMode != "" {
		objectMap["stretchMode"] = vVar.StretchMode
	}
	if vVar.SyncMode != "" {
		objectMap["syncMode"] = vVar.SyncMode
	}
	if vVar.Label != nil {
		objectMap["label"] = vVar.Label
	}
	if vVar.OdataType != "" {
		objectMap["@odata.type"] = vVar.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudio is the BasicCodec implementation for Video.
func (vVar Video) AsAudio() (*Audio, bool) {
	return nil, false
}

// AsBasicAudio is the BasicCodec implementation for Video.
func (vVar Video) AsBasicAudio() (BasicAudio, bool) {
	return nil, false
}

// AsAacAudio is the BasicCodec implementation for Video.
func (vVar Video) AsAacAudio() (*AacAudio, bool) {
	return nil, false
}

// AsVideo is the BasicCodec implementation for Video.
func (vVar Video) AsVideo() (*Video, bool) {
	return &vVar, true
}

// AsBasicVideo is the BasicCodec implementation for Video.
func (vVar Video) AsBasicVideo() (BasicVideo, bool) {
	return &vVar, true
}

// AsH265Video is the BasicCodec implementation for Video.
func (vVar Video) AsH265Video() (*H265Video, bool) {
	return nil, false
}

// AsCopyVideo is the BasicCodec implementation for Video.
func (vVar Video) AsCopyVideo() (*CopyVideo, bool) {
	return nil, false
}

// AsImage is the BasicCodec implementation for Video.
func (vVar Video) AsImage() (*Image, bool) {
	return nil, false
}

// AsBasicImage is the BasicCodec implementation for Video.
func (vVar Video) AsBasicImage() (BasicImage, bool) {
	return nil, false
}

// AsCopyAudio is the BasicCodec implementation for Video.
func (vVar Video) AsCopyAudio() (*CopyAudio, bool) {
	return nil, false
}

// AsH264Video is the BasicCodec implementation for Video.
func (vVar Video) AsH264Video() (*H264Video, bool) {
	return nil, false
}

// AsJpgImage is the BasicCodec implementation for Video.
func (vVar Video) AsJpgImage() (*JpgImage, bool) {
	return nil, false
}

// AsPngImage is the BasicCodec implementation for Video.
func (vVar Video) AsPngImage() (*PngImage, bool) {
	return nil, false
}

// AsCodec is the BasicCodec implementation for Video.
func (vVar Video) AsCodec() (*Codec, bool) {
	return nil, false
}

// AsBasicCodec is the BasicCodec implementation for Video.
func (vVar Video) AsBasicCodec() (BasicCodec, bool) {
	return &vVar, true
}

// VideoAnalyzerPreset a video analyzer preset that extracts insights (rich metadata) from both audio and
// video, and outputs a JSON format file.
type VideoAnalyzerPreset struct {
	// InsightsToExtract - Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly', and 'AllInsights'. The default is AllInsights. If you set this to AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only, then only video insights are generated. It is recommended that you not use AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your inputs to be audio only. Your Jobs in such conditions would error out. Possible values include: 'AudioInsightsOnly', 'VideoInsightsOnly', 'AllInsights'
	InsightsToExtract InsightsType `json:"insightsToExtract,omitempty"`
	// AudioLanguage - The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US').  If you know the language of your content, it is recommended that you specify it. The language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included in basic mode. If the language isn't specified or set to null, automatic language detection will choose the first language detected and process with the selected language for the duration of the file. It does not currently support dynamically switching between languages after the first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If automatic detection fails to find the language, transcription would fallback to 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string `json:"audioLanguage,omitempty"`
	// Mode - Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be chosen. Possible values include: 'Standard', 'Basic'
	Mode AudioAnalysisMode `json:"mode,omitempty"`
	// ExperimentalOptions - Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string `json:"experimentalOptions"`
	// OdataType - Possible values include: 'OdataTypePreset', 'OdataTypeMicrosoftMediaFaceDetectorPreset', 'OdataTypeMicrosoftMediaAudioAnalyzerPreset', 'OdataTypeMicrosoftMediaBuiltInStandardEncoderPreset', 'OdataTypeMicrosoftMediaStandardEncoderPreset', 'OdataTypeMicrosoftMediaVideoAnalyzerPreset'
	OdataType OdataTypeBasicPreset `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) MarshalJSON() ([]byte, error) {
	vap.OdataType = OdataTypeMicrosoftMediaVideoAnalyzerPreset
	objectMap := make(map[string]interface{})
	if vap.InsightsToExtract != "" {
		objectMap["insightsToExtract"] = vap.InsightsToExtract
	}
	if vap.AudioLanguage != nil {
		objectMap["audioLanguage"] = vap.AudioLanguage
	}
	if vap.Mode != "" {
		objectMap["mode"] = vap.Mode
	}
	if vap.ExperimentalOptions != nil {
		objectMap["experimentalOptions"] = vap.ExperimentalOptions
	}
	if vap.OdataType != "" {
		objectMap["@odata.type"] = vap.OdataType
	}
	return json.Marshal(objectMap)
}

// AsFaceDetectorPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsFaceDetectorPreset() (*FaceDetectorPreset, bool) {
	return nil, false
}

// AsAudioAnalyzerPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsAudioAnalyzerPreset() (*AudioAnalyzerPreset, bool) {
	return nil, false
}

// AsBasicAudioAnalyzerPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsBasicAudioAnalyzerPreset() (BasicAudioAnalyzerPreset, bool) {
	return &vap, true
}

// AsBuiltInStandardEncoderPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsBuiltInStandardEncoderPreset() (*BuiltInStandardEncoderPreset, bool) {
	return nil, false
}

// AsStandardEncoderPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsStandardEncoderPreset() (*StandardEncoderPreset, bool) {
	return nil, false
}

// AsVideoAnalyzerPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsVideoAnalyzerPreset() (*VideoAnalyzerPreset, bool) {
	return &vap, true
}

// AsPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsPreset() (*Preset, bool) {
	return nil, false
}

// AsBasicPreset is the BasicPreset implementation for VideoAnalyzerPreset.
func (vap VideoAnalyzerPreset) AsBasicPreset() (BasicPreset, bool) {
	return &vap, true
}

// BasicVideoLayer describes the settings to be used when encoding the input video into a desired output bitrate layer.
type BasicVideoLayer interface {
	AsH264Layer() (*H264Layer, bool)
	AsVideoLayer() (*VideoLayer, bool)
}

// VideoLayer describes the settings to be used when encoding the input video into a desired output bitrate
// layer.
type VideoLayer struct {
	// Bitrate - The average bitrate in bits per second at which to encode the input video when generating this layer. This is a required field.
	Bitrate *int32 `json:"bitrate,omitempty"`
	// MaxBitrate - The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults to the same value as bitrate.
	MaxBitrate *int32 `json:"maxBitrate,omitempty"`
	// BFrames - The number of B-frames to be used when encoding this layer.  If not specified, the encoder chooses an appropriate number based on the video profile and level.
	BFrames *int32 `json:"bFrames,omitempty"`
	// FrameRate - The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N are integers (For example, 30000/1001), or in the form of a number (For example, 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified, the encoder will use the same frame rate as the input video.
	FrameRate *string `json:"frameRate,omitempty"`
	// Slices - The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will use a single slice for each frame.
	Slices *int32 `json:"slices,omitempty"`
	// AdaptiveBFrame - Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool `json:"adaptiveBFrame,omitempty"`
	// Width - The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in width as the input.
	Width *string `json:"width,omitempty"`
	// Height - The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example 50% means the output video has half as many pixels in height as the input.
	Height *string `json:"height,omitempty"`
	// Label - The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming the output file.
	Label *string `json:"label,omitempty"`
	// OdataType - Possible values include: 'OdataTypeLayer', 'OdataTypeMicrosoftMediaH265VideoLayer', 'OdataTypeMicrosoftMediaH265Layer', 'OdataTypeMicrosoftMediaVideoLayer', 'OdataTypeMicrosoftMediaH264Layer', 'OdataTypeMicrosoftMediaJpgLayer', 'OdataTypeMicrosoftMediaPngLayer'
	OdataType OdataTypeBasicLayer `json:"@odata.type,omitempty"`
}

func unmarshalBasicVideoLayer(body []byte) (BasicVideoLayer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaH264Layer):
		var hl H264Layer
		err := json.Unmarshal(body, &hl)
		return hl, err
	default:
		var vl VideoLayer
		err := json.Unmarshal(body, &vl)
		return vl, err
	}
}
func unmarshalBasicVideoLayerArray(body []byte) ([]BasicVideoLayer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vlArray := make([]BasicVideoLayer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vl, err := unmarshalBasicVideoLayer(*rawMessage)
		if err != nil {
			return nil, err
		}
		vlArray[index] = vl
	}
	return vlArray, nil
}

// MarshalJSON is the custom marshaler for VideoLayer.
func (vl VideoLayer) MarshalJSON() ([]byte, error) {
	vl.OdataType = OdataTypeMicrosoftMediaVideoLayer
	objectMap := make(map[string]interface{})
	if vl.Bitrate != nil {
		objectMap["bitrate"] = vl.Bitrate
	}
	if vl.MaxBitrate != nil {
		objectMap["maxBitrate"] = vl.MaxBitrate
	}
	if vl.BFrames != nil {
		objectMap["bFrames"] = vl.BFrames
	}
	if vl.FrameRate != nil {
		objectMap["frameRate"] = vl.FrameRate
	}
	if vl.Slices != nil {
		objectMap["slices"] = vl.Slices
	}
	if vl.AdaptiveBFrame != nil {
		objectMap["adaptiveBFrame"] = vl.AdaptiveBFrame
	}
	if vl.Width != nil {
		objectMap["width"] = vl.Width
	}
	if vl.Height != nil {
		objectMap["height"] = vl.Height
	}
	if vl.Label != nil {
		objectMap["label"] = vl.Label
	}
	if vl.OdataType != "" {
		objectMap["@odata.type"] = vl.OdataType
	}
	return json.Marshal(objectMap)
}

// AsH265VideoLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsH265VideoLayer() (*H265VideoLayer, bool) {
	return nil, false
}

// AsBasicH265VideoLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsBasicH265VideoLayer() (BasicH265VideoLayer, bool) {
	return nil, false
}

// AsH265Layer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsH265Layer() (*H265Layer, bool) {
	return nil, false
}

// AsVideoLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsVideoLayer() (*VideoLayer, bool) {
	return &vl, true
}

// AsBasicVideoLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsBasicVideoLayer() (BasicVideoLayer, bool) {
	return &vl, true
}

// AsH264Layer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsH264Layer() (*H264Layer, bool) {
	return nil, false
}

// AsJpgLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsJpgLayer() (*JpgLayer, bool) {
	return nil, false
}

// AsPngLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsPngLayer() (*PngLayer, bool) {
	return nil, false
}

// AsLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsLayer() (*Layer, bool) {
	return nil, false
}

// AsBasicLayer is the BasicLayer implementation for VideoLayer.
func (vl VideoLayer) AsBasicLayer() (BasicLayer, bool) {
	return &vl, true
}

// VideoOverlay describes the properties of a video overlay.
type VideoOverlay struct {
	// Position - The location in the input video where the overlay is applied.
	Position *Rectangle `json:"position,omitempty"`
	// Opacity - The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
	Opacity *float64 `json:"opacity,omitempty"`
	// CropRectangle - An optional rectangular window used to crop the overlay image or video.
	CropRectangle *Rectangle `json:"cropRectangle,omitempty"`
	// InputLabel - The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV, MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video file formats.
	InputLabel *string `json:"inputLabel,omitempty"`
	// Start - The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format. For example, PT05S to start the overlay at 5 seconds into the input video. If not specified the overlay starts from the beginning of the input video.
	Start *string `json:"start,omitempty"`
	// End - The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format. For example, PT30S to end the overlay at 30 seconds into the input video. If not specified or the value is greater than the input video duration, the overlay will be applied until the end of the input video if the overlay media duration is greater than the input video duration, else the overlay will last as long as the overlay media duration.
	End *string `json:"end,omitempty"`
	// FadeInDuration - The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string `json:"fadeInDuration,omitempty"`
	// FadeOutDuration - The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string `json:"fadeOutDuration,omitempty"`
	// AudioGainLevel - The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64 `json:"audioGainLevel,omitempty"`
	// OdataType - Possible values include: 'OdataTypeOverlay', 'OdataTypeMicrosoftMediaAudioOverlay', 'OdataTypeMicrosoftMediaVideoOverlay'
	OdataType OdataTypeBasicOverlay `json:"@odata.type,omitempty"`
}

// MarshalJSON is the custom marshaler for VideoOverlay.
func (vo VideoOverlay) MarshalJSON() ([]byte, error) {
	vo.OdataType = OdataTypeMicrosoftMediaVideoOverlay
	objectMap := make(map[string]interface{})
	if vo.Position != nil {
		objectMap["position"] = vo.Position
	}
	if vo.Opacity != nil {
		objectMap["opacity"] = vo.Opacity
	}
	if vo.CropRectangle != nil {
		objectMap["cropRectangle"] = vo.CropRectangle
	}
	if vo.InputLabel != nil {
		objectMap["inputLabel"] = vo.InputLabel
	}
	if vo.Start != nil {
		objectMap["start"] = vo.Start
	}
	if vo.End != nil {
		objectMap["end"] = vo.End
	}
	if vo.FadeInDuration != nil {
		objectMap["fadeInDuration"] = vo.FadeInDuration
	}
	if vo.FadeOutDuration != nil {
		objectMap["fadeOutDuration"] = vo.FadeOutDuration
	}
	if vo.AudioGainLevel != nil {
		objectMap["audioGainLevel"] = vo.AudioGainLevel
	}
	if vo.OdataType != "" {
		objectMap["@odata.type"] = vo.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioOverlay is the BasicOverlay implementation for VideoOverlay.
func (vo VideoOverlay) AsAudioOverlay() (*AudioOverlay, bool) {
	return nil, false
}

// AsVideoOverlay is the BasicOverlay implementation for VideoOverlay.
func (vo VideoOverlay) AsVideoOverlay() (*VideoOverlay, bool) {
	return &vo, true
}

// AsOverlay is the BasicOverlay implementation for VideoOverlay.
func (vo VideoOverlay) AsOverlay() (*Overlay, bool) {
	return nil, false
}

// AsBasicOverlay is the BasicOverlay implementation for VideoOverlay.
func (vo VideoOverlay) AsBasicOverlay() (BasicOverlay, bool) {
	return &vo, true
}

// BasicVideoTrackDescriptor a TrackSelection to select video tracks.
type BasicVideoTrackDescriptor interface {
	AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool)
	AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool)
	AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool)
}

// VideoTrackDescriptor a TrackSelection to select video tracks.
type VideoTrackDescriptor struct {
	// OdataType - Possible values include: 'OdataTypeTrackDescriptor', 'OdataTypeMicrosoftMediaAudioTrackDescriptor', 'OdataTypeMicrosoftMediaSelectAudioTrackByAttribute', 'OdataTypeMicrosoftMediaSelectAudioTrackByID', 'OdataTypeMicrosoftMediaVideoTrackDescriptor', 'OdataTypeMicrosoftMediaSelectVideoTrackByAttribute', 'OdataTypeMicrosoftMediaSelectVideoTrackByID'
	OdataType OdataTypeBasicTrackDescriptor `json:"@odata.type,omitempty"`
}

func unmarshalBasicVideoTrackDescriptor(body []byte) (BasicVideoTrackDescriptor, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["@odata.type"] {
	case string(OdataTypeMicrosoftMediaSelectVideoTrackByAttribute):
		var svtba SelectVideoTrackByAttribute
		err := json.Unmarshal(body, &svtba)
		return svtba, err
	case string(OdataTypeMicrosoftMediaSelectVideoTrackByID):
		var svtbi SelectVideoTrackByID
		err := json.Unmarshal(body, &svtbi)
		return svtbi, err
	default:
		var vtd VideoTrackDescriptor
		err := json.Unmarshal(body, &vtd)
		return vtd, err
	}
}
func unmarshalBasicVideoTrackDescriptorArray(body []byte) ([]BasicVideoTrackDescriptor, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	vtdArray := make([]BasicVideoTrackDescriptor, len(rawMessages))

	for index, rawMessage := range rawMessages {
		vtd, err := unmarshalBasicVideoTrackDescriptor(*rawMessage)
		if err != nil {
			return nil, err
		}
		vtdArray[index] = vtd
	}
	return vtdArray, nil
}

// MarshalJSON is the custom marshaler for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) MarshalJSON() ([]byte, error) {
	vtd.OdataType = OdataTypeMicrosoftMediaVideoTrackDescriptor
	objectMap := make(map[string]interface{})
	if vtd.OdataType != "" {
		objectMap["@odata.type"] = vtd.OdataType
	}
	return json.Marshal(objectMap)
}

// AsAudioTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsAudioTrackDescriptor() (*AudioTrackDescriptor, bool) {
	return nil, false
}

// AsBasicAudioTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsBasicAudioTrackDescriptor() (BasicAudioTrackDescriptor, bool) {
	return nil, false
}

// AsSelectAudioTrackByAttribute is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsSelectAudioTrackByAttribute() (*SelectAudioTrackByAttribute, bool) {
	return nil, false
}

// AsSelectAudioTrackByID is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsSelectAudioTrackByID() (*SelectAudioTrackByID, bool) {
	return nil, false
}

// AsVideoTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsVideoTrackDescriptor() (*VideoTrackDescriptor, bool) {
	return &vtd, true
}

// AsBasicVideoTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsBasicVideoTrackDescriptor() (BasicVideoTrackDescriptor, bool) {
	return &vtd, true
}

// AsSelectVideoTrackByAttribute is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsSelectVideoTrackByAttribute() (*SelectVideoTrackByAttribute, bool) {
	return nil, false
}

// AsSelectVideoTrackByID is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsSelectVideoTrackByID() (*SelectVideoTrackByID, bool) {
	return nil, false
}

// AsTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsTrackDescriptor() (*TrackDescriptor, bool) {
	return nil, false
}

// AsBasicTrackDescriptor is the BasicTrackDescriptor implementation for VideoTrackDescriptor.
func (vtd VideoTrackDescriptor) AsBasicTrackDescriptor() (BasicTrackDescriptor, bool) {
	return &vtd, true
}
