package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/mgmt/2020-11-01-preview/containerregistry"

// ActivationProperties the activation properties of the connected registry.
type ActivationProperties struct {
	// Status - READ-ONLY; The activation status of the connected registry. Possible values include: 'Active', 'Inactive'
	Status ActivationStatus `json:"status,omitempty"`
}

// ActiveDirectoryObject the Active Directory Object that will be used for authenticating the token of a
// container registry.
type ActiveDirectoryObject struct {
	// ObjectID - The user/group/application object ID for Active Directory Object that will be used for authenticating the token of a container registry.
	ObjectID *string `json:"objectId,omitempty"`
	// TenantID - The tenant ID of user/group/application object Active Directory Object that will be used for authenticating the token of a container registry.
	TenantID *string `json:"tenantId,omitempty"`
}

// Actor the agent that initiated the event. For most situations, this could be from the authorization
// context of the request.
type Actor struct {
	// Name - The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// AgentPool the agentpool that has the ARM resource and properties.
// The agentpool will have all information to create an agent pool.
type AgentPool struct {
	autorest.Response `json:"-"`
	// AgentPoolProperties - The properties associated with the agent pool
	*AgentPoolProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPool.
func (ap AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AgentPoolProperties != nil {
		objectMap["properties"] = ap.AgentPoolProperties
	}
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPool struct.
func (ap *AgentPool) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var agentPoolProperties AgentPoolProperties
				err = json.Unmarshal(*v, &agentPoolProperties)
				if err != nil {
					return err
				}
				ap.AgentPoolProperties = &agentPoolProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ap.SystemData = &systemData
			}
		}
	}

	return nil
}

// AgentPoolListResult the collection of agent pools.
type AgentPoolListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]AgentPool `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// AgentPoolListResultIterator provides access to a complete listing of AgentPool values.
type AgentPoolListResultIterator struct {
	i    int
	page AgentPoolListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *AgentPoolListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *AgentPoolListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter AgentPoolListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter AgentPoolListResultIterator) Response() AgentPoolListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter AgentPoolListResultIterator) Value() AgentPool {
	if !iter.page.NotDone() {
		return AgentPool{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the AgentPoolListResultIterator type.
func NewAgentPoolListResultIterator(page AgentPoolListResultPage) AgentPoolListResultIterator {
	return AgentPoolListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (aplr AgentPoolListResult) IsEmpty() bool {
	return aplr.Value == nil || len(*aplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (aplr AgentPoolListResult) hasNextLink() bool {
	return aplr.NextLink != nil && len(*aplr.NextLink) != 0
}

// agentPoolListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (aplr AgentPoolListResult) agentPoolListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !aplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(aplr.NextLink)))
}

// AgentPoolListResultPage contains a page of AgentPool values.
type AgentPoolListResultPage struct {
	fn   func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)
	aplr AgentPoolListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *AgentPoolListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/AgentPoolListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.aplr)
		if err != nil {
			return err
		}
		page.aplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *AgentPoolListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page AgentPoolListResultPage) NotDone() bool {
	return !page.aplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page AgentPoolListResultPage) Response() AgentPoolListResult {
	return page.aplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page AgentPoolListResultPage) Values() []AgentPool {
	if page.aplr.IsEmpty() {
		return nil
	}
	return *page.aplr.Value
}

// Creates a new instance of the AgentPoolListResultPage type.
func NewAgentPoolListResultPage(cur AgentPoolListResult, getNextPage func(context.Context, AgentPoolListResult) (AgentPoolListResult, error)) AgentPoolListResultPage {
	return AgentPoolListResultPage{
		fn:   getNextPage,
		aplr: cur,
	}
}

// AgentPoolProperties the properties of agent pool.
type AgentPoolProperties struct {
	// Count - The count of agent machine
	Count *int32 `json:"count,omitempty"`
	// Tier - The Tier of agent machine
	Tier *string `json:"tier,omitempty"`
	// Os - The OS of agent machine. Possible values include: 'Windows', 'Linux'
	Os OS `json:"os,omitempty"`
	// VirtualNetworkSubnetResourceID - The Virtual Network Subnet Resource Id of the agent machine
	VirtualNetworkSubnetResourceID *string `json:"virtualNetworkSubnetResourceId,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of this agent pool. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for AgentPoolProperties.
func (app AgentPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if app.Count != nil {
		objectMap["count"] = app.Count
	}
	if app.Tier != nil {
		objectMap["tier"] = app.Tier
	}
	if app.Os != "" {
		objectMap["os"] = app.Os
	}
	if app.VirtualNetworkSubnetResourceID != nil {
		objectMap["virtualNetworkSubnetResourceId"] = app.VirtualNetworkSubnetResourceID
	}
	return json.Marshal(objectMap)
}

// AgentPoolPropertiesUpdateParameters ...
type AgentPoolPropertiesUpdateParameters struct {
	// Count - The count of agent machine
	Count *int32 `json:"count,omitempty"`
}

// AgentPoolQueueStatus the QueueStatus of Agent Pool
type AgentPoolQueueStatus struct {
	autorest.Response `json:"-"`
	// Count - The number of pending runs in the queue
	Count *int32 `json:"count,omitempty"`
}

// AgentPoolsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AgentPoolsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsCreateFuture.Result.
func (future *AgentPoolsCreateFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.AgentPoolsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.AgentPoolsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.CreateResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.AgentPoolsCreateFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AgentPoolsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsDeleteFuture.Result.
func (future *AgentPoolsDeleteFuture) result(client AgentPoolsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.AgentPoolsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.AgentPoolsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AgentPoolsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AgentPoolsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AgentPoolsClient) (AgentPool, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AgentPoolsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AgentPoolsUpdateFuture.Result.
func (future *AgentPoolsUpdateFuture) result(client AgentPoolsClient) (ap AgentPool, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.AgentPoolsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.AgentPoolsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ap.Response.Response, err = future.GetResult(sender); err == nil && ap.Response.Response.StatusCode != http.StatusNoContent {
		ap, err = client.UpdateResponder(ap.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.AgentPoolsUpdateFuture", "Result", ap.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AgentPoolUpdateParameters the parameters for updating an agent pool.
type AgentPoolUpdateParameters struct {
	// AgentPoolPropertiesUpdateParameters - The properties associated with the agent pool
	*AgentPoolPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AgentPoolUpdateParameters.
func (apup AgentPoolUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if apup.AgentPoolPropertiesUpdateParameters != nil {
		objectMap["properties"] = apup.AgentPoolPropertiesUpdateParameters
	}
	if apup.Tags != nil {
		objectMap["tags"] = apup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AgentPoolUpdateParameters struct.
func (apup *AgentPoolUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var agentPoolPropertiesUpdateParameters AgentPoolPropertiesUpdateParameters
				err = json.Unmarshal(*v, &agentPoolPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				apup.AgentPoolPropertiesUpdateParameters = &agentPoolPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				apup.Tags = tags
			}
		}
	}

	return nil
}

// AgentProperties the properties that determine the run agent configuration.
type AgentProperties struct {
	// CPU - The CPU configuration in terms of number of cores required for the run.
	CPU *int32 `json:"cpu,omitempty"`
}

// Argument the properties of a run argument.
type Argument struct {
	// Name - The name of the argument.
	Name *string `json:"name,omitempty"`
	// Value - The value of the argument.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the argument represents a secret and want to be removed from build logs.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// AuthInfo the authorization properties for accessing the source code repository.
type AuthInfo struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// AuthInfoUpdateParameters the authorization properties for accessing the source code repository.
type AuthInfoUpdateParameters struct {
	// TokenType - The type of Auth token. Possible values include: 'PAT', 'OAuth'
	TokenType TokenType `json:"tokenType,omitempty"`
	// Token - The access token used to access the source control provider.
	Token *string `json:"token,omitempty"`
	// RefreshToken - The refresh token used to refresh the access token.
	RefreshToken *string `json:"refreshToken,omitempty"`
	// Scope - The scope of the access token.
	Scope *string `json:"scope,omitempty"`
	// ExpiresIn - Time in seconds that the token remains valid
	ExpiresIn *int32 `json:"expiresIn,omitempty"`
}

// BaseImageDependency properties that describe a base image dependency.
type BaseImageDependency struct {
	// Type - The type of the base image dependency. Possible values include: 'BuildTime', 'RunTime'
	Type BaseImageDependencyType `json:"type,omitempty"`
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// BaseImageTrigger the trigger based on base image dependency.
type BaseImageTrigger struct {
	// BaseImageTriggerType - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime'
	BaseImageTriggerType BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`
	// UpdateTriggerEndpoint - The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string `json:"updateTriggerEndpoint,omitempty"`
	// UpdateTriggerPayloadType - Type of Payload body for Base image update triggers. Possible values include: 'UpdateTriggerPayloadTypeDefault', 'UpdateTriggerPayloadTypeToken'
	UpdateTriggerPayloadType UpdateTriggerPayloadType `json:"updateTriggerPayloadType,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// BaseImageTriggerUpdateParameters the properties for updating base image dependency trigger.
type BaseImageTriggerUpdateParameters struct {
	// BaseImageTriggerType - The type of the auto trigger for base image dependency updates. Possible values include: 'All', 'Runtime'
	BaseImageTriggerType BaseImageTriggerType `json:"baseImageTriggerType,omitempty"`
	// UpdateTriggerEndpoint - The endpoint URL for receiving update triggers.
	UpdateTriggerEndpoint *string `json:"updateTriggerEndpoint,omitempty"`
	// UpdateTriggerPayloadType - Type of Payload body for Base image update triggers. Possible values include: 'UpdateTriggerPayloadTypeDefault', 'UpdateTriggerPayloadTypeToken'
	UpdateTriggerPayloadType UpdateTriggerPayloadType `json:"updateTriggerPayloadType,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// CallbackConfig the configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	autorest.Response `json:"-"`
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
}

// MarshalJSON is the custom marshaler for CallbackConfig.
func (cc CallbackConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.ServiceURI != nil {
		objectMap["serviceUri"] = cc.ServiceURI
	}
	if cc.CustomHeaders != nil {
		objectMap["customHeaders"] = cc.CustomHeaders
	}
	return json.Marshal(objectMap)
}

// ConnectedRegistriesCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectedRegistriesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectedRegistriesClient) (ConnectedRegistry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectedRegistriesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectedRegistriesCreateFuture.Result.
func (future *ConnectedRegistriesCreateFuture) result(client ConnectedRegistriesClient) (cr ConnectedRegistry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ConnectedRegistriesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesCreateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectedRegistriesDeactivateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectedRegistriesDeactivateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectedRegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectedRegistriesDeactivateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectedRegistriesDeactivateFuture.Result.
func (future *ConnectedRegistriesDeactivateFuture) result(client ConnectedRegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesDeactivateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ConnectedRegistriesDeactivateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectedRegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectedRegistriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectedRegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectedRegistriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectedRegistriesDeleteFuture.Result.
func (future *ConnectedRegistriesDeleteFuture) result(client ConnectedRegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ConnectedRegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ConnectedRegistriesUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConnectedRegistriesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ConnectedRegistriesClient) (ConnectedRegistry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ConnectedRegistriesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ConnectedRegistriesUpdateFuture.Result.
func (future *ConnectedRegistriesUpdateFuture) result(client ConnectedRegistriesClient) (cr ConnectedRegistry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ConnectedRegistriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.UpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ConnectedRegistriesUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ConnectedRegistry an object that represents a connected registry for a container registry.
type ConnectedRegistry struct {
	autorest.Response `json:"-"`
	// ConnectedRegistryProperties - The properties of the connected registry.
	*ConnectedRegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectedRegistry.
func (cr ConnectedRegistry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.ConnectedRegistryProperties != nil {
		objectMap["properties"] = cr.ConnectedRegistryProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectedRegistry struct.
func (cr *ConnectedRegistry) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectedRegistryProperties ConnectedRegistryProperties
				err = json.Unmarshal(*v, &connectedRegistryProperties)
				if err != nil {
					return err
				}
				cr.ConnectedRegistryProperties = &connectedRegistryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				cr.SystemData = &systemData
			}
		}
	}

	return nil
}

// ConnectedRegistryListResult the result of a request to list connected registries for a container
// registry.
type ConnectedRegistryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of connected registries. Since this list may be incomplete, the nextLink field should be used to request the next list of connected registries.
	Value *[]ConnectedRegistry `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of connected registries.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConnectedRegistryListResultIterator provides access to a complete listing of ConnectedRegistry values.
type ConnectedRegistryListResultIterator struct {
	i    int
	page ConnectedRegistryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ConnectedRegistryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectedRegistryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ConnectedRegistryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ConnectedRegistryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ConnectedRegistryListResultIterator) Response() ConnectedRegistryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ConnectedRegistryListResultIterator) Value() ConnectedRegistry {
	if !iter.page.NotDone() {
		return ConnectedRegistry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ConnectedRegistryListResultIterator type.
func NewConnectedRegistryListResultIterator(page ConnectedRegistryListResultPage) ConnectedRegistryListResultIterator {
	return ConnectedRegistryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (crlr ConnectedRegistryListResult) IsEmpty() bool {
	return crlr.Value == nil || len(*crlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (crlr ConnectedRegistryListResult) hasNextLink() bool {
	return crlr.NextLink != nil && len(*crlr.NextLink) != 0
}

// connectedRegistryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (crlr ConnectedRegistryListResult) connectedRegistryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !crlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(crlr.NextLink)))
}

// ConnectedRegistryListResultPage contains a page of ConnectedRegistry values.
type ConnectedRegistryListResultPage struct {
	fn   func(context.Context, ConnectedRegistryListResult) (ConnectedRegistryListResult, error)
	crlr ConnectedRegistryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ConnectedRegistryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ConnectedRegistryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.crlr)
		if err != nil {
			return err
		}
		page.crlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ConnectedRegistryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ConnectedRegistryListResultPage) NotDone() bool {
	return !page.crlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ConnectedRegistryListResultPage) Response() ConnectedRegistryListResult {
	return page.crlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ConnectedRegistryListResultPage) Values() []ConnectedRegistry {
	if page.crlr.IsEmpty() {
		return nil
	}
	return *page.crlr.Value
}

// Creates a new instance of the ConnectedRegistryListResultPage type.
func NewConnectedRegistryListResultPage(cur ConnectedRegistryListResult, getNextPage func(context.Context, ConnectedRegistryListResult) (ConnectedRegistryListResult, error)) ConnectedRegistryListResultPage {
	return ConnectedRegistryListResultPage{
		fn:   getNextPage,
		crlr: cur,
	}
}

// ConnectedRegistryProperties the properties of a connected registry.
type ConnectedRegistryProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Mode - The mode of the connected registry resource that indicates the permissions of the registry. Possible values include: 'ConnectedRegistryModeRegistry', 'ConnectedRegistryModeMirror'
	Mode ConnectedRegistryMode `json:"mode,omitempty"`
	// Version - READ-ONLY; The current version of ACR runtime on the connected registry.
	Version *string `json:"version,omitempty"`
	// ConnectionState - READ-ONLY; The current connection state of the connected registry. Possible values include: 'Online', 'Offline', 'Syncing', 'Unhealthy'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// LastActivityTime - READ-ONLY; The last activity time of the connected registry.
	LastActivityTime *date.Time `json:"lastActivityTime,omitempty"`
	// Activation - READ-ONLY; The activation properties of the connected registry.
	Activation *ActivationProperties `json:"activation,omitempty"`
	// Parent - The parent of the connected registry.
	Parent *ParentProperties `json:"parent,omitempty"`
	// ClientTokenIds - The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIds *[]string `json:"clientTokenIds,omitempty"`
	// LoginServer - The login server properties of the connected registry.
	LoginServer *LoginServerProperties `json:"loginServer,omitempty"`
	// Logging - The logging properties of the connected registry.
	Logging *LoggingProperties `json:"logging,omitempty"`
	// StatusDetails - READ-ONLY; The list of current statuses of the connected registry.
	StatusDetails *[]StatusDetailProperties `json:"statusDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectedRegistryProperties.
func (crp ConnectedRegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crp.Mode != "" {
		objectMap["mode"] = crp.Mode
	}
	if crp.Parent != nil {
		objectMap["parent"] = crp.Parent
	}
	if crp.ClientTokenIds != nil {
		objectMap["clientTokenIds"] = crp.ClientTokenIds
	}
	if crp.LoginServer != nil {
		objectMap["loginServer"] = crp.LoginServer
	}
	if crp.Logging != nil {
		objectMap["logging"] = crp.Logging
	}
	return json.Marshal(objectMap)
}

// ConnectedRegistryUpdateParameters the parameters for updating a connected registry.
type ConnectedRegistryUpdateParameters struct {
	// ConnectedRegistryUpdateProperties - The properties of the connected registry update parameters.
	*ConnectedRegistryUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ConnectedRegistryUpdateParameters.
func (crup ConnectedRegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crup.ConnectedRegistryUpdateProperties != nil {
		objectMap["properties"] = crup.ConnectedRegistryUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ConnectedRegistryUpdateParameters struct.
func (crup *ConnectedRegistryUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var connectedRegistryUpdateProperties ConnectedRegistryUpdateProperties
				err = json.Unmarshal(*v, &connectedRegistryUpdateProperties)
				if err != nil {
					return err
				}
				crup.ConnectedRegistryUpdateProperties = &connectedRegistryUpdateProperties
			}
		}
	}

	return nil
}

// ConnectedRegistryUpdateProperties the parameters for updating token properties.
type ConnectedRegistryUpdateProperties struct {
	// SyncProperties - The sync properties of the connected registry with its parent.
	SyncProperties *SyncUpdateProperties `json:"syncProperties,omitempty"`
	// Logging - The logging properties of the connected registry.
	Logging *LoggingProperties `json:"logging,omitempty"`
	// ClientTokenIds - The list of the ACR token resource IDs used to authenticate clients to the connected registry.
	ClientTokenIds *[]string `json:"clientTokenIds,omitempty"`
}

// Credentials the parameters that describes a set of credentials that will be used when a run is invoked.
type Credentials struct {
	// SourceRegistry - Describes the credential parameters for accessing the source registry.
	SourceRegistry *SourceRegistryCredentials `json:"sourceRegistry,omitempty"`
	// CustomRegistries - Describes the credential parameters for accessing other custom registries. The key
	// for the dictionary item will be the registry login server (myregistry.azurecr.io) and
	// the value of the item will be the registry credentials for accessing the registry.
	CustomRegistries map[string]*CustomRegistryCredentials `json:"customRegistries"`
}

// MarshalJSON is the custom marshaler for Credentials.
func (c Credentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.SourceRegistry != nil {
		objectMap["sourceRegistry"] = c.SourceRegistry
	}
	if c.CustomRegistries != nil {
		objectMap["customRegistries"] = c.CustomRegistries
	}
	return json.Marshal(objectMap)
}

// CustomRegistryCredentials describes the credentials that will be used to access a custom registry during
// a run.
type CustomRegistryCredentials struct {
	// UserName - The username for logging into the custom registry.
	UserName *SecretObject `json:"userName,omitempty"`
	// Password - The password for logging into the custom registry. The password is a secret
	// object that allows multiple ways of providing the value for it.
	Password *SecretObject `json:"password,omitempty"`
	// Identity - Indicates the managed identity assigned to the custom credential. If a user-assigned identity
	// this value is the Client ID. If a system-assigned identity, the value will be `system`. In
	// the case of a system-assigned identity, the Client ID will be determined by the runner. This
	// identity may be used to authenticate to key vault to retrieve credentials or it may be the only
	// source of authentication used for accessing the registry.
	Identity *string `json:"identity,omitempty"`
}

// DockerBuildRequest the parameters for a docker quick build.
type DockerBuildRequest struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source location.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// Arguments - The collection of override arguments to be used when executing the run.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildRequest.
func (dbr DockerBuildRequest) MarshalJSON() ([]byte, error) {
	dbr.Type = TypeDockerBuildRequest
	objectMap := make(map[string]interface{})
	if dbr.ImageNames != nil {
		objectMap["imageNames"] = dbr.ImageNames
	}
	if dbr.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbr.IsPushEnabled
	}
	if dbr.NoCache != nil {
		objectMap["noCache"] = dbr.NoCache
	}
	if dbr.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbr.DockerFilePath
	}
	if dbr.Target != nil {
		objectMap["target"] = dbr.Target
	}
	if dbr.Arguments != nil {
		objectMap["arguments"] = dbr.Arguments
	}
	if dbr.Timeout != nil {
		objectMap["timeout"] = dbr.Timeout
	}
	if dbr.Platform != nil {
		objectMap["platform"] = dbr.Platform
	}
	if dbr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = dbr.AgentConfiguration
	}
	if dbr.SourceLocation != nil {
		objectMap["sourceLocation"] = dbr.SourceLocation
	}
	if dbr.Credentials != nil {
		objectMap["credentials"] = dbr.Credentials
	}
	if dbr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = dbr.IsArchiveEnabled
	}
	if dbr.AgentPoolName != nil {
		objectMap["agentPoolName"] = dbr.AgentPoolName
	}
	if dbr.LogTemplate != nil {
		objectMap["logTemplate"] = dbr.LogTemplate
	}
	if dbr.Type != "" {
		objectMap["type"] = dbr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return &dbr, true
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for DockerBuildRequest.
func (dbr DockerBuildRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &dbr, true
}

// DockerBuildStep the Docker build step.
type DockerBuildStep struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// Arguments - The collection of override arguments to be used when executing this build step.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStep.
func (dbs DockerBuildStep) MarshalJSON() ([]byte, error) {
	dbs.Type = TypeDocker
	objectMap := make(map[string]interface{})
	if dbs.ImageNames != nil {
		objectMap["imageNames"] = dbs.ImageNames
	}
	if dbs.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbs.IsPushEnabled
	}
	if dbs.NoCache != nil {
		objectMap["noCache"] = dbs.NoCache
	}
	if dbs.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbs.DockerFilePath
	}
	if dbs.Target != nil {
		objectMap["target"] = dbs.Target
	}
	if dbs.Arguments != nil {
		objectMap["arguments"] = dbs.Arguments
	}
	if dbs.ContextPath != nil {
		objectMap["contextPath"] = dbs.ContextPath
	}
	if dbs.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = dbs.ContextAccessToken
	}
	if dbs.Type != "" {
		objectMap["type"] = dbs.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return &dbs, true
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for DockerBuildStep.
func (dbs DockerBuildStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &dbs, true
}

// DockerBuildStepUpdateParameters the properties for updating a docker build step.
type DockerBuildStepUpdateParameters struct {
	// ImageNames - The fully qualified image names including the repository and tag.
	ImageNames *[]string `json:"imageNames,omitempty"`
	// IsPushEnabled - The value of this property indicates whether the image built should be pushed to the registry or not.
	IsPushEnabled *bool `json:"isPushEnabled,omitempty"`
	// NoCache - The value of this property indicates whether the image cache is enabled or not.
	NoCache *bool `json:"noCache,omitempty"`
	// DockerFilePath - The Docker file path relative to the source context.
	DockerFilePath *string `json:"dockerFilePath,omitempty"`
	// Arguments - The collection of override arguments to be used when executing this build step.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) MarshalJSON() ([]byte, error) {
	dbsup.Type = TypeBasicTaskStepUpdateParametersTypeDocker
	objectMap := make(map[string]interface{})
	if dbsup.ImageNames != nil {
		objectMap["imageNames"] = dbsup.ImageNames
	}
	if dbsup.IsPushEnabled != nil {
		objectMap["isPushEnabled"] = dbsup.IsPushEnabled
	}
	if dbsup.NoCache != nil {
		objectMap["noCache"] = dbsup.NoCache
	}
	if dbsup.DockerFilePath != nil {
		objectMap["dockerFilePath"] = dbsup.DockerFilePath
	}
	if dbsup.Arguments != nil {
		objectMap["arguments"] = dbsup.Arguments
	}
	if dbsup.Target != nil {
		objectMap["target"] = dbsup.Target
	}
	if dbsup.ContextPath != nil {
		objectMap["contextPath"] = dbsup.ContextPath
	}
	if dbsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = dbsup.ContextAccessToken
	}
	if dbsup.Type != "" {
		objectMap["type"] = dbsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return &dbsup, true
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for DockerBuildStepUpdateParameters.
func (dbsup DockerBuildStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &dbsup, true
}

// EncodedTaskRunRequest the parameters for a quick task run request.
type EncodedTaskRunRequest struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) MarshalJSON() ([]byte, error) {
	etrr.Type = TypeEncodedTaskRunRequest
	objectMap := make(map[string]interface{})
	if etrr.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = etrr.EncodedTaskContent
	}
	if etrr.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = etrr.EncodedValuesContent
	}
	if etrr.Values != nil {
		objectMap["values"] = etrr.Values
	}
	if etrr.Timeout != nil {
		objectMap["timeout"] = etrr.Timeout
	}
	if etrr.Platform != nil {
		objectMap["platform"] = etrr.Platform
	}
	if etrr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = etrr.AgentConfiguration
	}
	if etrr.SourceLocation != nil {
		objectMap["sourceLocation"] = etrr.SourceLocation
	}
	if etrr.Credentials != nil {
		objectMap["credentials"] = etrr.Credentials
	}
	if etrr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = etrr.IsArchiveEnabled
	}
	if etrr.AgentPoolName != nil {
		objectMap["agentPoolName"] = etrr.AgentPoolName
	}
	if etrr.LogTemplate != nil {
		objectMap["logTemplate"] = etrr.LogTemplate
	}
	if etrr.Type != "" {
		objectMap["type"] = etrr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return &etrr, true
}

// AsRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for EncodedTaskRunRequest.
func (etrr EncodedTaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &etrr, true
}

// EncodedTaskStep the properties of a encoded task step.
type EncodedTaskStep struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskStep.
func (ets EncodedTaskStep) MarshalJSON() ([]byte, error) {
	ets.Type = TypeEncodedTask
	objectMap := make(map[string]interface{})
	if ets.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = ets.EncodedTaskContent
	}
	if ets.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = ets.EncodedValuesContent
	}
	if ets.Values != nil {
		objectMap["values"] = ets.Values
	}
	if ets.ContextPath != nil {
		objectMap["contextPath"] = ets.ContextPath
	}
	if ets.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = ets.ContextAccessToken
	}
	if ets.Type != "" {
		objectMap["type"] = ets.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return &ets, true
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for EncodedTaskStep.
func (ets EncodedTaskStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &ets, true
}

// EncodedTaskStepUpdateParameters the properties for updating encoded task step.
type EncodedTaskStepUpdateParameters struct {
	// EncodedTaskContent - Base64 encoded value of the template/definition file content.
	EncodedTaskContent *string `json:"encodedTaskContent,omitempty"`
	// EncodedValuesContent - Base64 encoded value of the parameters/values file content.
	EncodedValuesContent *string `json:"encodedValuesContent,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	etsup.Type = TypeBasicTaskStepUpdateParametersTypeEncodedTask
	objectMap := make(map[string]interface{})
	if etsup.EncodedTaskContent != nil {
		objectMap["encodedTaskContent"] = etsup.EncodedTaskContent
	}
	if etsup.EncodedValuesContent != nil {
		objectMap["encodedValuesContent"] = etsup.EncodedValuesContent
	}
	if etsup.Values != nil {
		objectMap["values"] = etsup.Values
	}
	if etsup.ContextPath != nil {
		objectMap["contextPath"] = etsup.ContextPath
	}
	if etsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = etsup.ContextAccessToken
	}
	if etsup.Type != "" {
		objectMap["type"] = etsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return &etsup, true
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for EncodedTaskStepUpdateParameters.
func (etsup EncodedTaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &etsup, true
}

// EncryptionProperty ...
type EncryptionProperty struct {
	// Status - Indicates whether or not the encryption is enabled for container registry. Possible values include: 'EncryptionStatusEnabled', 'EncryptionStatusDisabled'
	Status EncryptionStatus `json:"status,omitempty"`
	// KeyVaultProperties - Key vault properties.
	KeyVaultProperties *KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ErrorResponse an error response from the Azure Container Registry service.
type ErrorResponse struct {
	// Error - Azure container registry build API error body.
	Error *ErrorResponseBody `json:"error,omitempty"`
}

// ErrorResponseBody an error response from the Azure Container Registry service.
type ErrorResponseBody struct {
	// Code - error code.
	Code *string `json:"code,omitempty"`
	// Message - error message.
	Message *string `json:"message,omitempty"`
	// Target - target of the particular error.
	Target *string `json:"target,omitempty"`
	// Details - an array of additional nested error response info objects, as described by this contract.
	Details *InnerErrorDescription `json:"details,omitempty"`
}

// Event the event for a webhook.
type Event struct {
	// EventRequestMessage - The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage `json:"eventRequestMessage,omitempty"`
	// EventResponseMessage - The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage `json:"eventResponseMessage,omitempty"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventContent the content of the event request message.
type EventContent struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *Target `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *Request `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *Source `json:"source,omitempty"`
}

// EventInfo the basic information of an event.
type EventInfo struct {
	autorest.Response `json:"-"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventListResult the result of a request to list events for a webhook.
type EventListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventListResultIterator provides access to a complete listing of Event values.
type EventListResultIterator struct {
	i    int
	page EventListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventListResultIterator) Response() EventListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventListResultIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventListResultIterator type.
func NewEventListResultIterator(page EventListResultPage) EventListResultIterator {
	return EventListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EventListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EventListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// eventListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EventListResult) eventListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EventListResultPage contains a page of Event values.
type EventListResultPage struct {
	fn  func(context.Context, EventListResult) (EventListResult, error)
	elr EventListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventListResultPage) Response() EventListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventListResultPage) Values() []Event {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EventListResultPage type.
func NewEventListResultPage(cur EventListResult, getNextPage func(context.Context, EventListResult) (EventListResult, error)) EventListResultPage {
	return EventListResultPage{
		fn:  getNextPage,
		elr: cur,
	}
}

// EventRequestMessage the event request message sent to the service URI.
type EventRequestMessage struct {
	// Content - The content of the event request message.
	Content *EventContent `json:"content,omitempty"`
	// Headers - The headers of the event request message.
	Headers map[string]*string `json:"headers"`
	// Method - The HTTP method used to send the event request message.
	Method *string `json:"method,omitempty"`
	// RequestURI - The URI used to send the event request message.
	RequestURI *string `json:"requestUri,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventRequestMessage.
func (erm EventRequestMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.Method != nil {
		objectMap["method"] = erm.Method
	}
	if erm.RequestURI != nil {
		objectMap["requestUri"] = erm.RequestURI
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// EventResponseMessage the event response message received from the service URI.
type EventResponseMessage struct {
	// Content - The content of the event response message.
	Content *string `json:"content,omitempty"`
	// Headers - The headers of the event response message.
	Headers map[string]*string `json:"headers"`
	// ReasonPhrase - The reason phrase of the event response message.
	ReasonPhrase *string `json:"reasonPhrase,omitempty"`
	// StatusCode - The status code of the event response message.
	StatusCode *string `json:"statusCode,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventResponseMessage.
func (erm EventResponseMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.ReasonPhrase != nil {
		objectMap["reasonPhrase"] = erm.ReasonPhrase
	}
	if erm.StatusCode != nil {
		objectMap["statusCode"] = erm.StatusCode
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// ExportPipeline an object that represents an export pipeline for a container registry.
type ExportPipeline struct {
	autorest.Response `json:"-"`
	// Location - The location of the export pipeline.
	Location *string `json:"location,omitempty"`
	// Identity - The identity of the export pipeline.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// ExportPipelineProperties - The properties of the export pipeline.
	*ExportPipelineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportPipeline.
func (ep ExportPipeline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.Location != nil {
		objectMap["location"] = ep.Location
	}
	if ep.Identity != nil {
		objectMap["identity"] = ep.Identity
	}
	if ep.ExportPipelineProperties != nil {
		objectMap["properties"] = ep.ExportPipelineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExportPipeline struct.
func (ep *ExportPipeline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ep.Location = &location
			}
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ep.Identity = &identity
			}
		case "properties":
			if v != nil {
				var exportPipelineProperties ExportPipelineProperties
				err = json.Unmarshal(*v, &exportPipelineProperties)
				if err != nil {
					return err
				}
				ep.ExportPipelineProperties = &exportPipelineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ep.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ep.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ep.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				ep.SystemData = &systemData
			}
		}
	}

	return nil
}

// ExportPipelineListResult the result of a request to list export pipelines for a container registry.
type ExportPipelineListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of export pipelines. Since this list may be incomplete, the nextLink field should be used to request the next list of export pipelines.
	Value *[]ExportPipeline `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ExportPipelineListResultIterator provides access to a complete listing of ExportPipeline values.
type ExportPipelineListResultIterator struct {
	i    int
	page ExportPipelineListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExportPipelineListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExportPipelineListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExportPipelineListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExportPipelineListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExportPipelineListResultIterator) Response() ExportPipelineListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExportPipelineListResultIterator) Value() ExportPipeline {
	if !iter.page.NotDone() {
		return ExportPipeline{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExportPipelineListResultIterator type.
func NewExportPipelineListResultIterator(page ExportPipelineListResultPage) ExportPipelineListResultIterator {
	return ExportPipelineListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (eplr ExportPipelineListResult) IsEmpty() bool {
	return eplr.Value == nil || len(*eplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (eplr ExportPipelineListResult) hasNextLink() bool {
	return eplr.NextLink != nil && len(*eplr.NextLink) != 0
}

// exportPipelineListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (eplr ExportPipelineListResult) exportPipelineListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !eplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(eplr.NextLink)))
}

// ExportPipelineListResultPage contains a page of ExportPipeline values.
type ExportPipelineListResultPage struct {
	fn   func(context.Context, ExportPipelineListResult) (ExportPipelineListResult, error)
	eplr ExportPipelineListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExportPipelineListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExportPipelineListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.eplr)
		if err != nil {
			return err
		}
		page.eplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExportPipelineListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExportPipelineListResultPage) NotDone() bool {
	return !page.eplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExportPipelineListResultPage) Response() ExportPipelineListResult {
	return page.eplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExportPipelineListResultPage) Values() []ExportPipeline {
	if page.eplr.IsEmpty() {
		return nil
	}
	return *page.eplr.Value
}

// Creates a new instance of the ExportPipelineListResultPage type.
func NewExportPipelineListResultPage(cur ExportPipelineListResult, getNextPage func(context.Context, ExportPipelineListResult) (ExportPipelineListResult, error)) ExportPipelineListResultPage {
	return ExportPipelineListResultPage{
		fn:   getNextPage,
		eplr: cur,
	}
}

// ExportPipelineProperties the properties of an export pipeline.
type ExportPipelineProperties struct {
	// Target - The target properties of the export pipeline.
	Target *ExportPipelineTargetProperties `json:"target,omitempty"`
	// Options - The list of all options configured for the pipeline.
	Options *[]PipelineOptions `json:"options,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the pipeline at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportPipelineProperties.
func (epp ExportPipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if epp.Target != nil {
		objectMap["target"] = epp.Target
	}
	if epp.Options != nil {
		objectMap["options"] = epp.Options
	}
	return json.Marshal(objectMap)
}

// ExportPipelinesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExportPipelinesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExportPipelinesClient) (ExportPipeline, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExportPipelinesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExportPipelinesCreateFuture.Result.
func (future *ExportPipelinesCreateFuture) result(client ExportPipelinesClient) (ep ExportPipeline, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ExportPipelinesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ExportPipelinesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ep.Response.Response, err = future.GetResult(sender); err == nil && ep.Response.Response.StatusCode != http.StatusNoContent {
		ep, err = client.CreateResponder(ep.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ExportPipelinesCreateFuture", "Result", ep.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExportPipelinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExportPipelinesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExportPipelinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExportPipelinesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExportPipelinesDeleteFuture.Result.
func (future *ExportPipelinesDeleteFuture) result(client ExportPipelinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ExportPipelinesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ExportPipelinesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExportPipelineTargetProperties the properties of the export pipeline target.
type ExportPipelineTargetProperties struct {
	// Type - The type of target for the export pipeline.
	Type *string `json:"type,omitempty"`
	// URI - The target uri of the export pipeline.
	// When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer':  "https://accountName.blob.core.windows.net/containerName"
	URI *string `json:"uri,omitempty"`
	// KeyVaultURI - They key vault secret uri to obtain the target storage SAS token.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
}

// FileTaskRunRequest the request parameters for a scheduling run against a task file.
type FileTaskRunRequest struct {
	// TaskFilePath - The template/definition file path relative to the source.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The values/parameters file path relative to the source.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceLocation - The URL(absolute or relative) of the source context. It can be an URL to a tar or git repository.
	// If it is relative URL, the relative path should be obtained from calling listBuildSourceUploadUrl API.
	SourceLocation *string `json:"sourceLocation,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) MarshalJSON() ([]byte, error) {
	ftrr.Type = TypeFileTaskRunRequest
	objectMap := make(map[string]interface{})
	if ftrr.TaskFilePath != nil {
		objectMap["taskFilePath"] = ftrr.TaskFilePath
	}
	if ftrr.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = ftrr.ValuesFilePath
	}
	if ftrr.Values != nil {
		objectMap["values"] = ftrr.Values
	}
	if ftrr.Timeout != nil {
		objectMap["timeout"] = ftrr.Timeout
	}
	if ftrr.Platform != nil {
		objectMap["platform"] = ftrr.Platform
	}
	if ftrr.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = ftrr.AgentConfiguration
	}
	if ftrr.SourceLocation != nil {
		objectMap["sourceLocation"] = ftrr.SourceLocation
	}
	if ftrr.Credentials != nil {
		objectMap["credentials"] = ftrr.Credentials
	}
	if ftrr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = ftrr.IsArchiveEnabled
	}
	if ftrr.AgentPoolName != nil {
		objectMap["agentPoolName"] = ftrr.AgentPoolName
	}
	if ftrr.LogTemplate != nil {
		objectMap["logTemplate"] = ftrr.LogTemplate
	}
	if ftrr.Type != "" {
		objectMap["type"] = ftrr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return &ftrr, true
}

// AsTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for FileTaskRunRequest.
func (ftrr FileTaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &ftrr, true
}

// FileTaskStep the properties of a task step.
type FileTaskStep struct {
	// TaskFilePath - The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The task values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskStep.
func (fts FileTaskStep) MarshalJSON() ([]byte, error) {
	fts.Type = TypeFileTask
	objectMap := make(map[string]interface{})
	if fts.TaskFilePath != nil {
		objectMap["taskFilePath"] = fts.TaskFilePath
	}
	if fts.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = fts.ValuesFilePath
	}
	if fts.Values != nil {
		objectMap["values"] = fts.Values
	}
	if fts.ContextPath != nil {
		objectMap["contextPath"] = fts.ContextPath
	}
	if fts.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = fts.ContextAccessToken
	}
	if fts.Type != "" {
		objectMap["type"] = fts.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsFileTaskStep() (*FileTaskStep, bool) {
	return &fts, true
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return nil, false
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for FileTaskStep.
func (fts FileTaskStep) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &fts, true
}

// FileTaskStepUpdateParameters the properties of updating a task step.
type FileTaskStepUpdateParameters struct {
	// TaskFilePath - The task template/definition file path relative to the source context.
	TaskFilePath *string `json:"taskFilePath,omitempty"`
	// ValuesFilePath - The values/parameters file path relative to the source context.
	ValuesFilePath *string `json:"valuesFilePath,omitempty"`
	// Values - The collection of overridable values that can be passed when running a task.
	Values *[]SetValue `json:"values,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	ftsup.Type = TypeBasicTaskStepUpdateParametersTypeFileTask
	objectMap := make(map[string]interface{})
	if ftsup.TaskFilePath != nil {
		objectMap["taskFilePath"] = ftsup.TaskFilePath
	}
	if ftsup.ValuesFilePath != nil {
		objectMap["valuesFilePath"] = ftsup.ValuesFilePath
	}
	if ftsup.Values != nil {
		objectMap["values"] = ftsup.Values
	}
	if ftsup.ContextPath != nil {
		objectMap["contextPath"] = ftsup.ContextPath
	}
	if ftsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = ftsup.ContextAccessToken
	}
	if ftsup.Type != "" {
		objectMap["type"] = ftsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return &ftsup, true
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return nil, false
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for FileTaskStepUpdateParameters.
func (ftsup FileTaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &ftsup, true
}

// GenerateCredentialsParameters the parameters used to generate credentials for a specified token or user
// of a container registry.
type GenerateCredentialsParameters struct {
	// TokenID - The resource ID of the token for which credentials have to be generated.
	TokenID *string `json:"tokenId,omitempty"`
	// Expiry - The expiry date of the generated credentials after which the credentials become invalid.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Name - Specifies name of the password which should be regenerated if any -- password1 or password2. Possible values include: 'TokenPasswordNamePassword1', 'TokenPasswordNamePassword2'
	Name TokenPasswordName `json:"name,omitempty"`
}

// GenerateCredentialsResult the response from the GenerateCredentials operation.
type GenerateCredentialsResult struct {
	autorest.Response `json:"-"`
	// Username - The username for a container registry.
	Username *string `json:"username,omitempty"`
	// Passwords - The list of passwords for a container registry.
	Passwords *[]TokenPassword `json:"passwords,omitempty"`
}

// IdentityProperties managed identity for the resource.
type IdentityProperties struct {
	// PrincipalID - The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity
	// dictionary key references will be ARM resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
	//     providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*UserIdentityProperties `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for IdentityProperties.
func (IP IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.PrincipalID != nil {
		objectMap["principalId"] = IP.PrincipalID
	}
	if IP.TenantID != nil {
		objectMap["tenantId"] = IP.TenantID
	}
	if IP.Type != "" {
		objectMap["type"] = IP.Type
	}
	if IP.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = IP.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// ImageDescriptor properties for a registry image.
type ImageDescriptor struct {
	// Registry - The registry login server.
	Registry *string `json:"registry,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Digest - The sha256-based digest of the image manifest.
	Digest *string `json:"digest,omitempty"`
}

// ImageUpdateTrigger the image update trigger that caused a build.
type ImageUpdateTrigger struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// Timestamp - The timestamp when the image update happened.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Images - The list of image updates that caused the build.
	Images *[]ImageDescriptor `json:"images,omitempty"`
}

// ImportImageParameters ...
type ImportImageParameters struct {
	// Source - The source of the image.
	Source *ImportSource `json:"source,omitempty"`
	// TargetTags - List of strings of the form repo[:tag]. When tag is omitted the source will be used (or 'latest' if source tag is also omitted).
	TargetTags *[]string `json:"targetTags,omitempty"`
	// UntaggedTargetRepositories - List of strings of repository names to do a manifest only copy. No tag will be created.
	UntaggedTargetRepositories *[]string `json:"untaggedTargetRepositories,omitempty"`
	// Mode - When Force, any existing target tags will be overwritten. When NoForce, any existing target tags will fail the operation before any copying begins. Possible values include: 'NoForce', 'Force'
	Mode ImportMode `json:"mode,omitempty"`
}

// ImportPipeline an object that represents an import pipeline for a container registry.
type ImportPipeline struct {
	autorest.Response `json:"-"`
	// Location - The location of the import pipeline.
	Location *string `json:"location,omitempty"`
	// Identity - The identity of the import pipeline.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// ImportPipelineProperties - The properties of the import pipeline.
	*ImportPipelineProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportPipeline.
func (IP ImportPipeline) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.Location != nil {
		objectMap["location"] = IP.Location
	}
	if IP.Identity != nil {
		objectMap["identity"] = IP.Identity
	}
	if IP.ImportPipelineProperties != nil {
		objectMap["properties"] = IP.ImportPipelineProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ImportPipeline struct.
func (IP *ImportPipeline) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				IP.Location = &location
			}
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				IP.Identity = &identity
			}
		case "properties":
			if v != nil {
				var importPipelineProperties ImportPipelineProperties
				err = json.Unmarshal(*v, &importPipelineProperties)
				if err != nil {
					return err
				}
				IP.ImportPipelineProperties = &importPipelineProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				IP.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				IP.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				IP.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				IP.SystemData = &systemData
			}
		}
	}

	return nil
}

// ImportPipelineListResult the result of a request to list import pipelines for a container registry.
type ImportPipelineListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of import pipelines. Since this list may be incomplete, the nextLink field should be used to request the next list of import pipelines.
	Value *[]ImportPipeline `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`
}

// ImportPipelineListResultIterator provides access to a complete listing of ImportPipeline values.
type ImportPipelineListResultIterator struct {
	i    int
	page ImportPipelineListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ImportPipelineListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImportPipelineListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ImportPipelineListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ImportPipelineListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ImportPipelineListResultIterator) Response() ImportPipelineListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ImportPipelineListResultIterator) Value() ImportPipeline {
	if !iter.page.NotDone() {
		return ImportPipeline{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ImportPipelineListResultIterator type.
func NewImportPipelineListResultIterator(page ImportPipelineListResultPage) ImportPipelineListResultIterator {
	return ImportPipelineListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (iplr ImportPipelineListResult) IsEmpty() bool {
	return iplr.Value == nil || len(*iplr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (iplr ImportPipelineListResult) hasNextLink() bool {
	return iplr.NextLink != nil && len(*iplr.NextLink) != 0
}

// importPipelineListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (iplr ImportPipelineListResult) importPipelineListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !iplr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(iplr.NextLink)))
}

// ImportPipelineListResultPage contains a page of ImportPipeline values.
type ImportPipelineListResultPage struct {
	fn   func(context.Context, ImportPipelineListResult) (ImportPipelineListResult, error)
	iplr ImportPipelineListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ImportPipelineListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ImportPipelineListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.iplr)
		if err != nil {
			return err
		}
		page.iplr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ImportPipelineListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ImportPipelineListResultPage) NotDone() bool {
	return !page.iplr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ImportPipelineListResultPage) Response() ImportPipelineListResult {
	return page.iplr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ImportPipelineListResultPage) Values() []ImportPipeline {
	if page.iplr.IsEmpty() {
		return nil
	}
	return *page.iplr.Value
}

// Creates a new instance of the ImportPipelineListResultPage type.
func NewImportPipelineListResultPage(cur ImportPipelineListResult, getNextPage func(context.Context, ImportPipelineListResult) (ImportPipelineListResult, error)) ImportPipelineListResultPage {
	return ImportPipelineListResultPage{
		fn:   getNextPage,
		iplr: cur,
	}
}

// ImportPipelineProperties the properties of an import pipeline.
type ImportPipelineProperties struct {
	// Source - The source properties of the import pipeline.
	Source *ImportPipelineSourceProperties `json:"source,omitempty"`
	// Trigger - The properties that describe the trigger of the import pipeline.
	Trigger *PipelineTriggerProperties `json:"trigger,omitempty"`
	// Options - The list of all options configured for the pipeline.
	Options *[]PipelineOptions `json:"options,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the pipeline at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ImportPipelineProperties.
func (ipp ImportPipelineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ipp.Source != nil {
		objectMap["source"] = ipp.Source
	}
	if ipp.Trigger != nil {
		objectMap["trigger"] = ipp.Trigger
	}
	if ipp.Options != nil {
		objectMap["options"] = ipp.Options
	}
	return json.Marshal(objectMap)
}

// ImportPipelinesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ImportPipelinesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ImportPipelinesClient) (ImportPipeline, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImportPipelinesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImportPipelinesCreateFuture.Result.
func (future *ImportPipelinesCreateFuture) result(client ImportPipelinesClient) (IP ImportPipeline, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ImportPipelinesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ImportPipelinesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if IP.Response.Response, err = future.GetResult(sender); err == nil && IP.Response.Response.StatusCode != http.StatusNoContent {
		IP, err = client.CreateResponder(IP.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ImportPipelinesCreateFuture", "Result", IP.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ImportPipelinesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ImportPipelinesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ImportPipelinesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ImportPipelinesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ImportPipelinesDeleteFuture.Result.
func (future *ImportPipelinesDeleteFuture) result(client ImportPipelinesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ImportPipelinesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ImportPipelinesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ImportPipelineSourceProperties the properties of the import pipeline source.
type ImportPipelineSourceProperties struct {
	// Type - The type of source for the import pipeline. Possible values include: 'AzureStorageBlobContainer'
	Type PipelineSourceType `json:"type,omitempty"`
	// URI - The source uri of the import pipeline.
	// When 'AzureStorageBlob': "https://accountName.blob.core.windows.net/containerName/blobName"
	// When 'AzureStorageBlobContainer': "https://accountName.blob.core.windows.net/containerName"
	URI *string `json:"uri,omitempty"`
	// KeyVaultURI - They key vault secret uri to obtain the source storage SAS token.
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`
}

// ImportSource ...
type ImportSource struct {
	// ResourceID - The resource identifier of the source Azure Container Registry.
	ResourceID *string `json:"resourceId,omitempty"`
	// RegistryURI - The address of the source registry (e.g. 'mcr.microsoft.com').
	RegistryURI *string `json:"registryUri,omitempty"`
	// Credentials - Credentials used when importing from a registry uri.
	Credentials *ImportSourceCredentials `json:"credentials,omitempty"`
	// SourceImage - Repository name of the source image.
	// Specify an image by repository ('hello-world'). This will use the 'latest' tag.
	// Specify an image by tag ('hello-world:latest').
	// Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
	SourceImage *string `json:"sourceImage,omitempty"`
}

// ImportSourceCredentials ...
type ImportSourceCredentials struct {
	// Username - The username to authenticate with the source registry.
	Username *string `json:"username,omitempty"`
	// Password - The password used to authenticate with the source registry.
	Password *string `json:"password,omitempty"`
}

// InnerErrorDescription inner error.
type InnerErrorDescription struct {
	// Code - error code.
	Code *string `json:"code,omitempty"`
	// Message - error message.
	Message *string `json:"message,omitempty"`
	// Target - target of the particular error.
	Target *string `json:"target,omitempty"`
}

// IPRule IP rule with specific IP or IP range in CIDR format.
type IPRule struct {
	// Action - The action of IP ACL rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// IPAddressOrRange - Specifies the IP or IP range in CIDR format. Only IPV4 address is allowed.
	IPAddressOrRange *string `json:"value,omitempty"`
}

// KeyVaultProperties ...
type KeyVaultProperties struct {
	// KeyIdentifier - Key vault uri to access the encryption key.
	KeyIdentifier *string `json:"keyIdentifier,omitempty"`
	// VersionedKeyIdentifier - READ-ONLY; The fully qualified key identifier that includes the version of the key that is actually used for encryption.
	VersionedKeyIdentifier *string `json:"versionedKeyIdentifier,omitempty"`
	// Identity - The client id of the identity which will be used to access key vault.
	Identity *string `json:"identity,omitempty"`
	// KeyRotationEnabled - READ-ONLY; Auto key rotation status for a CMK enabled registry.
	KeyRotationEnabled *bool `json:"keyRotationEnabled,omitempty"`
	// LastKeyRotationTimestamp - READ-ONLY; Timestamp of the last successful key rotation.
	LastKeyRotationTimestamp *date.Time `json:"lastKeyRotationTimestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultProperties.
func (kvp KeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kvp.KeyIdentifier != nil {
		objectMap["keyIdentifier"] = kvp.KeyIdentifier
	}
	if kvp.Identity != nil {
		objectMap["identity"] = kvp.Identity
	}
	return json.Marshal(objectMap)
}

// LoggingProperties the logging properties of the connected registry.
type LoggingProperties struct {
	// LogLevel - The verbosity of logs persisted on the connected registry. Possible values include: 'LogLevelDebug', 'LogLevelInformation', 'LogLevelWarning', 'LogLevelError', 'LogLevelNone'
	LogLevel LogLevel `json:"logLevel,omitempty"`
	// AuditLogStatus - Indicates whether audit logs are enabled on the connected registry. Possible values include: 'Enabled', 'Disabled'
	AuditLogStatus AuditLogStatus `json:"auditLogStatus,omitempty"`
}

// LoginServerProperties the login server properties of the connected registry.
type LoginServerProperties struct {
	// Host - READ-ONLY; The host of the connected registry. Can be FQDN or IP.
	Host *string `json:"host,omitempty"`
	// TLS - READ-ONLY; The TLS properties of the connected registry login server.
	TLS *TLSProperties `json:"tls,omitempty"`
}

// NetworkRuleSet the network rule set for a container registry.
type NetworkRuleSet struct {
	// DefaultAction - The default action of allow or deny when no other rules match. Possible values include: 'DefaultActionAllow', 'DefaultActionDeny'
	DefaultAction DefaultAction `json:"defaultAction,omitempty"`
	// VirtualNetworkRules - The virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
	// IPRules - The IP ACL rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
}

// OperationDefinition the definition of a container registry operation.
type OperationDefinition struct {
	// Origin - The origin information of the container registry operation.
	Origin *string `json:"origin,omitempty"`
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The display information for the container registry operation.
	Display *OperationDisplayDefinition `json:"display,omitempty"`
	// OperationPropertiesDefinition - The properties information for the container registry operation.
	*OperationPropertiesDefinition `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDefinition.
func (od OperationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if od.Origin != nil {
		objectMap["origin"] = od.Origin
	}
	if od.Name != nil {
		objectMap["name"] = od.Name
	}
	if od.Display != nil {
		objectMap["display"] = od.Display
	}
	if od.OperationPropertiesDefinition != nil {
		objectMap["properties"] = od.OperationPropertiesDefinition
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationDefinition struct.
func (od *OperationDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				od.Origin = &origin
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				od.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplayDefinition
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				od.Display = &display
			}
		case "properties":
			if v != nil {
				var operationPropertiesDefinition OperationPropertiesDefinition
				err = json.Unmarshal(*v, &operationPropertiesDefinition)
				if err != nil {
					return err
				}
				od.OperationPropertiesDefinition = &operationPropertiesDefinition
			}
		}
	}

	return nil
}

// OperationDisplayDefinition the display information for a container registry operation.
type OperationDisplayDefinition struct {
	// Provider - The resource provider name: Microsoft.ContainerRegistry.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the result of a request to list container registry operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request the next list of operations.
	Value *[]OperationDefinition `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registry operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationDefinition values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationDefinition {
	if !iter.page.NotDone() {
		return OperationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationDefinition values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationDefinition {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationMetricSpecificationDefinition the definition of Azure Monitoring metric.
type OperationMetricSpecificationDefinition struct {
	// Name - Metric name.
	Name *string `json:"name,omitempty"`
	// DisplayName - Metric display name.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Metric description.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - Metric unit.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - Metric aggregation type.
	AggregationType *string `json:"aggregationType,omitempty"`
	// InternalMetricName - Internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`
}

// OperationPropertiesDefinition the definition of Azure Monitoring properties.
type OperationPropertiesDefinition struct {
	// ServiceSpecification - The definition of Azure Monitoring service.
	ServiceSpecification *OperationServiceSpecificationDefinition `json:"serviceSpecification,omitempty"`
}

// OperationServiceSpecificationDefinition the definition of Azure Monitoring list.
type OperationServiceSpecificationDefinition struct {
	// MetricSpecifications - A list of Azure Monitoring metrics definition.
	MetricSpecifications *[]OperationMetricSpecificationDefinition `json:"metricSpecifications,omitempty"`
}

// OverrideTaskStepProperties ...
type OverrideTaskStepProperties struct {
	// ContextPath - The source context against which run has to be queued.
	ContextPath *string `json:"contextPath,omitempty"`
	// File - The file against which run has to be queued.
	File *string `json:"file,omitempty"`
	// Arguments - Gets or sets the collection of override arguments to be used when
	// executing a build step.
	Arguments *[]Argument `json:"arguments,omitempty"`
	// Target - The name of the target build stage for the docker build.
	Target *string `json:"target,omitempty"`
	// Values - The collection of overridable values that can be passed when running a Task.
	Values *[]SetValue `json:"values,omitempty"`
	// UpdateTriggerToken - Base64 encoded update trigger token that will be attached with the base image trigger webhook.
	UpdateTriggerToken *string `json:"updateTriggerToken,omitempty"`
}

// ParentProperties the properties of the connected registry parent.
type ParentProperties struct {
	// ID - The resource ID of the parent to which the connected registry will be associated.
	ID *string `json:"id,omitempty"`
	// SyncProperties - The sync properties of the connected registry with its parent.
	SyncProperties *SyncProperties `json:"syncProperties,omitempty"`
}

// PipelineRun an object that represents a pipeline run for a container registry.
type PipelineRun struct {
	autorest.Response `json:"-"`
	// PipelineRunProperties - The properties of a pipeline run.
	*PipelineRunProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineRun.
func (pr PipelineRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pr.PipelineRunProperties != nil {
		objectMap["properties"] = pr.PipelineRunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PipelineRun struct.
func (pr *PipelineRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var pipelineRunProperties PipelineRunProperties
				err = json.Unmarshal(*v, &pipelineRunProperties)
				if err != nil {
					return err
				}
				pr.PipelineRunProperties = &pipelineRunProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pr.SystemData = &systemData
			}
		}
	}

	return nil
}

// PipelineRunListResult the result of a request to list pipeline runs for a container registry.
type PipelineRunListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of pipeline runs. Since this list may be incomplete, the nextLink field should be used to request the next list of pipeline runs.
	Value *[]PipelineRun `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of pipeline runs.
	NextLink *string `json:"nextLink,omitempty"`
}

// PipelineRunListResultIterator provides access to a complete listing of PipelineRun values.
type PipelineRunListResultIterator struct {
	i    int
	page PipelineRunListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PipelineRunListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineRunListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PipelineRunListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PipelineRunListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PipelineRunListResultIterator) Response() PipelineRunListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PipelineRunListResultIterator) Value() PipelineRun {
	if !iter.page.NotDone() {
		return PipelineRun{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PipelineRunListResultIterator type.
func NewPipelineRunListResultIterator(page PipelineRunListResultPage) PipelineRunListResultIterator {
	return PipelineRunListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (prlr PipelineRunListResult) IsEmpty() bool {
	return prlr.Value == nil || len(*prlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (prlr PipelineRunListResult) hasNextLink() bool {
	return prlr.NextLink != nil && len(*prlr.NextLink) != 0
}

// pipelineRunListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (prlr PipelineRunListResult) pipelineRunListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !prlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(prlr.NextLink)))
}

// PipelineRunListResultPage contains a page of PipelineRun values.
type PipelineRunListResultPage struct {
	fn   func(context.Context, PipelineRunListResult) (PipelineRunListResult, error)
	prlr PipelineRunListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PipelineRunListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PipelineRunListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.prlr)
		if err != nil {
			return err
		}
		page.prlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PipelineRunListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PipelineRunListResultPage) NotDone() bool {
	return !page.prlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PipelineRunListResultPage) Response() PipelineRunListResult {
	return page.prlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PipelineRunListResultPage) Values() []PipelineRun {
	if page.prlr.IsEmpty() {
		return nil
	}
	return *page.prlr.Value
}

// Creates a new instance of the PipelineRunListResultPage type.
func NewPipelineRunListResultPage(cur PipelineRunListResult, getNextPage func(context.Context, PipelineRunListResult) (PipelineRunListResult, error)) PipelineRunListResultPage {
	return PipelineRunListResultPage{
		fn:   getNextPage,
		prlr: cur,
	}
}

// PipelineRunProperties the properties of a pipeline run.
type PipelineRunProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of a pipeline run. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Request - The request parameters for a pipeline run.
	Request *PipelineRunRequest `json:"request,omitempty"`
	// Response - READ-ONLY; The response of a pipeline run.
	Response *PipelineRunResponse `json:"response,omitempty"`
	// ForceUpdateTag - How the pipeline run should be forced to recreate even if the pipeline run configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
}

// MarshalJSON is the custom marshaler for PipelineRunProperties.
func (prp PipelineRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prp.Request != nil {
		objectMap["request"] = prp.Request
	}
	if prp.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = prp.ForceUpdateTag
	}
	return json.Marshal(objectMap)
}

// PipelineRunRequest the request properties provided for a pipeline run.
type PipelineRunRequest struct {
	// PipelineResourceID - The resource ID of the pipeline to run.
	PipelineResourceID *string `json:"pipelineResourceId,omitempty"`
	// Artifacts - List of source artifacts to be transferred by the pipeline.
	// Specify an image by repository ('hello-world'). This will use the 'latest' tag.
	// Specify an image by tag ('hello-world:latest').
	// Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
	Artifacts *[]string `json:"artifacts,omitempty"`
	// Source - The source properties of the pipeline run.
	Source *PipelineRunSourceProperties `json:"source,omitempty"`
	// Target - The target properties of the pipeline run.
	Target *PipelineRunTargetProperties `json:"target,omitempty"`
	// CatalogDigest - The digest of the tar used to transfer the artifacts.
	CatalogDigest *string `json:"catalogDigest,omitempty"`
}

// PipelineRunResponse the response properties returned for a pipeline run.
type PipelineRunResponse struct {
	// Status - The current status of the pipeline run.
	Status *string `json:"status,omitempty"`
	// ImportedArtifacts - The artifacts imported in the pipeline run.
	ImportedArtifacts *[]string `json:"importedArtifacts,omitempty"`
	// Progress - The current progress of the copy operation.
	Progress *ProgressProperties `json:"progress,omitempty"`
	// StartTime - The time the pipeline run started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// FinishTime - The time the pipeline run finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// Source - The source of the pipeline run.
	Source *ImportPipelineSourceProperties `json:"source,omitempty"`
	// Target - The target of the pipeline run.
	Target *ExportPipelineTargetProperties `json:"target,omitempty"`
	// CatalogDigest - The digest of the tar used to transfer the artifacts.
	CatalogDigest *string `json:"catalogDigest,omitempty"`
	// Trigger - The trigger that caused the pipeline run.
	Trigger *PipelineTriggerDescriptor `json:"trigger,omitempty"`
	// PipelineRunErrorMessage - The detailed error message for the pipeline run in the case of failure.
	PipelineRunErrorMessage *string `json:"pipelineRunErrorMessage,omitempty"`
}

// PipelineRunsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PipelineRunsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PipelineRunsClient) (PipelineRun, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PipelineRunsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PipelineRunsCreateFuture.Result.
func (future *PipelineRunsCreateFuture) result(client PipelineRunsClient) (pr PipelineRun, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.PipelineRunsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.PipelineRunsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pr.Response.Response, err = future.GetResult(sender); err == nil && pr.Response.Response.StatusCode != http.StatusNoContent {
		pr, err = client.CreateResponder(pr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.PipelineRunsCreateFuture", "Result", pr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PipelineRunsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type PipelineRunsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PipelineRunsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PipelineRunsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PipelineRunsDeleteFuture.Result.
func (future *PipelineRunsDeleteFuture) result(client PipelineRunsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.PipelineRunsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.PipelineRunsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PipelineRunSourceProperties ...
type PipelineRunSourceProperties struct {
	// Type - The type of the source. Possible values include: 'AzureStorageBlob'
	Type PipelineRunSourceType `json:"type,omitempty"`
	// Name - The name of the source.
	Name *string `json:"name,omitempty"`
}

// PipelineRunTargetProperties ...
type PipelineRunTargetProperties struct {
	// Type - The type of the target. Possible values include: 'PipelineRunTargetTypeAzureStorageBlob'
	Type PipelineRunTargetType `json:"type,omitempty"`
	// Name - The name of the target.
	Name *string `json:"name,omitempty"`
}

// PipelineSourceTriggerDescriptor ...
type PipelineSourceTriggerDescriptor struct {
	// Timestamp - The timestamp when the source update happened.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// PipelineSourceTriggerProperties ...
type PipelineSourceTriggerProperties struct {
	// Status - The current status of the source trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
}

// PipelineTriggerDescriptor ...
type PipelineTriggerDescriptor struct {
	// SourceTrigger - The source trigger that caused the pipeline run.
	SourceTrigger *PipelineSourceTriggerDescriptor `json:"sourceTrigger,omitempty"`
}

// PipelineTriggerProperties ...
type PipelineTriggerProperties struct {
	// SourceTrigger - The source trigger properties of the pipeline.
	SourceTrigger *PipelineSourceTriggerProperties `json:"sourceTrigger,omitempty"`
}

// PlatformProperties the platform properties against which the run has to happen.
type PlatformProperties struct {
	// Os - The operating system type required for the run. Possible values include: 'Windows', 'Linux'
	Os OS `json:"os,omitempty"`
	// Architecture - The OS architecture. Possible values include: 'Amd64', 'X86', 'ThreeEightSix', 'Arm', 'Arm64'
	Architecture Architecture `json:"architecture,omitempty"`
	// Variant - Variant of the CPU. Possible values include: 'V6', 'V7', 'V8'
	Variant Variant `json:"variant,omitempty"`
}

// PlatformUpdateParameters the properties for updating the platform configuration.
type PlatformUpdateParameters struct {
	// Os - The operating system type required for the run. Possible values include: 'Windows', 'Linux'
	Os OS `json:"os,omitempty"`
	// Architecture - The OS architecture. Possible values include: 'Amd64', 'X86', 'ThreeEightSix', 'Arm', 'Arm64'
	Architecture Architecture `json:"architecture,omitempty"`
	// Variant - Variant of the CPU. Possible values include: 'V6', 'V7', 'V8'
	Variant Variant `json:"variant,omitempty"`
}

// Policies the policies for a container registry.
type Policies struct {
	// QuarantinePolicy - The quarantine policy for a container registry.
	QuarantinePolicy *QuarantinePolicy `json:"quarantinePolicy,omitempty"`
	// TrustPolicy - The content trust policy for a container registry.
	TrustPolicy *TrustPolicy `json:"trustPolicy,omitempty"`
	// RetentionPolicy - The retention policy for a container registry.
	RetentionPolicy *RetentionPolicy `json:"retentionPolicy,omitempty"`
}

// PrivateEndpoint the Private Endpoint resource.
type PrivateEndpoint struct {
	// ID - This is private endpoint resource created with Microsoft.Network resource provider.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection an object that represents a private endpoint connection for a container
// registry.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - The properties of a private endpoint connection.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				pec.SystemData = &systemData
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult the result of a request to list private endpoint connections for a
// container registry.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of private endpoint connections. Since this list may be incomplete, the nextLink field should be used to request the next list of private endpoint connections.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of private endpoint connections.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties the properties of a private endpoint connection.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of private endpoint connection resource. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionProperties.
func (pecp PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pecp.PrivateEndpoint != nil {
		objectMap["privateEndpoint"] = pecp.PrivateEndpoint
	}
	if pecp.PrivateLinkServiceConnectionState != nil {
		objectMap["privateLinkServiceConnectionState"] = pecp.PrivateLinkServiceConnectionState
	}
	return json.Marshal(objectMap)
}

// PrivateEndpointConnectionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type PrivateEndpointConnectionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsCreateOrUpdateFuture.Result.
func (future *PrivateEndpointConnectionsCreateOrUpdateFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.PrivateEndpointConnectionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.CreateOrUpdateResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.PrivateEndpointConnectionsCreateOrUpdateFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// PrivateLinkResource a resource that supports private link capabilities.
type PrivateLinkResource struct {
	// Type - READ-ONLY; The resource type is private link resource.
	Type *string `json:"type,omitempty"`
	// ID - The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource.
	Name *string `json:"name,omitempty"`
	// PrivateLinkResourceProperties - A resource that supports private link capabilities.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.ID != nil {
		objectMap["id"] = plr.ID
	}
	if plr.Name != nil {
		objectMap["name"] = plr.Name
	}
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult the result of a request to list private link resources for a container
// registry.
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of private link resources. Since this list may be incomplete, the nextLink field should be used to request the next list of private link resources.
	Value *[]PrivateLinkResource `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of private link resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateLinkResourceListResultIterator provides access to a complete listing of PrivateLinkResource
// values.
type PrivateLinkResourceListResultIterator struct {
	i    int
	page PrivateLinkResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateLinkResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateLinkResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateLinkResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateLinkResourceListResultIterator) Response() PrivateLinkResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateLinkResourceListResultIterator) Value() PrivateLinkResource {
	if !iter.page.NotDone() {
		return PrivateLinkResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateLinkResourceListResultIterator type.
func NewPrivateLinkResourceListResultIterator(page PrivateLinkResourceListResultPage) PrivateLinkResourceListResultIterator {
	return PrivateLinkResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plrlr PrivateLinkResourceListResult) IsEmpty() bool {
	return plrlr.Value == nil || len(*plrlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plrlr PrivateLinkResourceListResult) hasNextLink() bool {
	return plrlr.NextLink != nil && len(*plrlr.NextLink) != 0
}

// privateLinkResourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plrlr PrivateLinkResourceListResult) privateLinkResourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plrlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plrlr.NextLink)))
}

// PrivateLinkResourceListResultPage contains a page of PrivateLinkResource values.
type PrivateLinkResourceListResultPage struct {
	fn    func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)
	plrlr PrivateLinkResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateLinkResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plrlr)
		if err != nil {
			return err
		}
		page.plrlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateLinkResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateLinkResourceListResultPage) NotDone() bool {
	return !page.plrlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateLinkResourceListResultPage) Response() PrivateLinkResourceListResult {
	return page.plrlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateLinkResourceListResultPage) Values() []PrivateLinkResource {
	if page.plrlr.IsEmpty() {
		return nil
	}
	return *page.plrlr.Value
}

// Creates a new instance of the PrivateLinkResourceListResultPage type.
func NewPrivateLinkResourceListResultPage(cur PrivateLinkResourceListResult, getNextPage func(context.Context, PrivateLinkResourceListResult) (PrivateLinkResourceListResult, error)) PrivateLinkResourceListResultPage {
	return PrivateLinkResourceListResultPage{
		fn:    getNextPage,
		plrlr: cur,
	}
}

// PrivateLinkResourceProperties the properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - The private link resource required member names.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - The private link resource Private link DNS zone name.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkServiceConnectionState the state of a private link service connection.
type PrivateLinkServiceConnectionState struct {
	// Status - The private link service connection status. Possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
	Status ConnectionStatus `json:"status,omitempty"`
	// Description - The description for connection status. For example if connection is rejected it can indicate reason for rejection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer. Possible values include: 'None', 'Recreate'
	ActionsRequired ActionsRequired `json:"actionsRequired,omitempty"`
}

// ProgressProperties ...
type ProgressProperties struct {
	// Percentage - The percentage complete of the copy operation.
	Percentage *string `json:"percentage,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags.
type ProxyResource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// QuarantinePolicy the quarantine policy for a container registry.
type QuarantinePolicy struct {
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// RegenerateCredentialParameters the parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// Name - Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
}

// RegistriesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesCreateFuture.Result.
func (future *RegistriesCreateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesDeleteFuture.Result.
func (future *RegistriesDeleteFuture) result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesGenerateCredentialsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type RegistriesGenerateCredentialsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (GenerateCredentialsResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesGenerateCredentialsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesGenerateCredentialsFuture.Result.
func (future *RegistriesGenerateCredentialsFuture) result(client RegistriesClient) (gcr GenerateCredentialsResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesGenerateCredentialsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesGenerateCredentialsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gcr.Response.Response, err = future.GetResult(sender); err == nil && gcr.Response.Response.StatusCode != http.StatusNoContent {
		gcr, err = client.GenerateCredentialsResponder(gcr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesGenerateCredentialsFuture", "Result", gcr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesImportImageFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesImportImageFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesImportImageFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesImportImageFuture.Result.
func (future *RegistriesImportImageFuture) result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesImportImageFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesImportImageFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesScheduleRunFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesScheduleRunFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Run, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesScheduleRunFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesScheduleRunFuture.Result.
func (future *RegistriesScheduleRunFuture) result(client RegistriesClient) (r Run, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesScheduleRunFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesScheduleRunFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.ScheduleRunResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesScheduleRunFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesUpdateFuture.Result.
func (future *RegistriesUpdateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Registry an object that represents a container registry.
type Registry struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the container registry.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// RegistryProperties - The properties of the container registry.
	*RegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Registry.
func (r Registry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	if r.RegistryProperties != nil {
		objectMap["properties"] = r.RegistryProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Registry struct.
func (r *Registry) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				r.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				r.Identity = &identity
			}
		case "properties":
			if v != nil {
				var registryProperties RegistryProperties
				err = json.Unmarshal(*v, &registryProperties)
				if err != nil {
					return err
				}
				r.RegistryProperties = &registryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// RegistryListCredentialsResult the response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	autorest.Response `json:"-"`
	// Username - The username for a container registry.
	Username *string `json:"username,omitempty"`
	// Passwords - The list of passwords for a container registry.
	Passwords *[]RegistryPassword `json:"passwords,omitempty"`
}

// RegistryListResult the result of a request to list container registries.
type RegistryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries.
	Value *[]Registry `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registries.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegistryListResultIterator provides access to a complete listing of Registry values.
type RegistryListResultIterator struct {
	i    int
	page RegistryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegistryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegistryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegistryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegistryListResultIterator) Response() RegistryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegistryListResultIterator) Value() Registry {
	if !iter.page.NotDone() {
		return Registry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegistryListResultIterator type.
func NewRegistryListResultIterator(page RegistryListResultPage) RegistryListResultIterator {
	return RegistryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RegistryListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RegistryListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// registryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RegistryListResult) registryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RegistryListResultPage contains a page of Registry values.
type RegistryListResultPage struct {
	fn  func(context.Context, RegistryListResult) (RegistryListResult, error)
	rlr RegistryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegistryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegistryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegistryListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegistryListResultPage) Response() RegistryListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegistryListResultPage) Values() []Registry {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RegistryListResultPage type.
func NewRegistryListResultPage(cur RegistryListResult, getNextPage func(context.Context, RegistryListResult) (RegistryListResult, error)) RegistryListResultPage {
	return RegistryListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RegistryNameCheckRequest a request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// Name - The name of the container registry.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	Type *string `json:"type,omitempty"`
}

// RegistryNameStatus the result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	autorest.Response `json:"-"`
	// NameAvailable - The value that indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - If any, the reason that the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - If any, the error message that provides more detail for the reason that the name is not available.
	Message *string `json:"message,omitempty"`
}

// RegistryPassword the login password for the container registry.
type RegistryPassword struct {
	// Name - The password name. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
	// Value - The password value.
	Value *string `json:"value,omitempty"`
}

// RegistryProperties the properties of a container registry.
type RegistryProperties struct {
	// LoginServer - READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string `json:"loginServer,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container registry at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status `json:"status,omitempty"`
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The properties of the storage account for the container registry. Only applicable to Classic SKU.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
	// Policies - The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`
	// Encryption - The encryption settings of container registry.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`
	// DataEndpointEnabled - Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool `json:"dataEndpointEnabled,omitempty"`
	// DataEndpointHostNames - READ-ONLY; List of host names that will serve data when dataEndpointEnabled is true.
	DataEndpointHostNames *[]string `json:"dataEndpointHostNames,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections for a container registry.
	PrivateEndpointConnections *[]PrivateEndpointConnection `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for the container registry. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// NetworkRuleBypassOptions - Whether to allow trusted Azure services to access a network restricted registry. Possible values include: 'NetworkRuleBypassOptionsAzureServices', 'NetworkRuleBypassOptionsNone'
	NetworkRuleBypassOptions NetworkRuleBypassOptions `json:"networkRuleBypassOptions,omitempty"`
	// ZoneRedundancy - Whether or not zone redundancy is enabled for this container registry. Possible values include: 'ZoneRedundancyEnabled', 'ZoneRedundancyDisabled'
	ZoneRedundancy ZoneRedundancy `json:"zoneRedundancy,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryProperties.
func (rp RegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.AdminUserEnabled != nil {
		objectMap["adminUserEnabled"] = rp.AdminUserEnabled
	}
	if rp.StorageAccount != nil {
		objectMap["storageAccount"] = rp.StorageAccount
	}
	if rp.NetworkRuleSet != nil {
		objectMap["networkRuleSet"] = rp.NetworkRuleSet
	}
	if rp.Policies != nil {
		objectMap["policies"] = rp.Policies
	}
	if rp.Encryption != nil {
		objectMap["encryption"] = rp.Encryption
	}
	if rp.DataEndpointEnabled != nil {
		objectMap["dataEndpointEnabled"] = rp.DataEndpointEnabled
	}
	if rp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = rp.PublicNetworkAccess
	}
	if rp.NetworkRuleBypassOptions != "" {
		objectMap["networkRuleBypassOptions"] = rp.NetworkRuleBypassOptions
	}
	if rp.ZoneRedundancy != "" {
		objectMap["zoneRedundancy"] = rp.ZoneRedundancy
	}
	return json.Marshal(objectMap)
}

// RegistryPropertiesUpdateParameters the parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// NetworkRuleSet - The network rule set for a container registry.
	NetworkRuleSet *NetworkRuleSet `json:"networkRuleSet,omitempty"`
	// Policies - The policies for a container registry.
	Policies *Policies `json:"policies,omitempty"`
	// Encryption - The encryption settings of container registry.
	Encryption *EncryptionProperty `json:"encryption,omitempty"`
	// DataEndpointEnabled - Enable a single data endpoint per region for serving data.
	DataEndpointEnabled *bool `json:"dataEndpointEnabled,omitempty"`
	// PublicNetworkAccess - Whether or not public network access is allowed for the container registry. Possible values include: 'PublicNetworkAccessEnabled', 'PublicNetworkAccessDisabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// NetworkRuleBypassOptions - Whether to allow trusted Azure services to access a network restricted registry. Possible values include: 'NetworkRuleBypassOptionsAzureServices', 'NetworkRuleBypassOptionsNone'
	NetworkRuleBypassOptions NetworkRuleBypassOptions `json:"networkRuleBypassOptions,omitempty"`
}

// RegistryUpdateParameters the parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// Tags - The tags for the container registry.
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the container registry.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// RegistryPropertiesUpdateParameters - The properties that the container registry will be updated with.
	*RegistryPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryUpdateParameters.
func (rup RegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	if rup.Sku != nil {
		objectMap["sku"] = rup.Sku
	}
	if rup.Identity != nil {
		objectMap["identity"] = rup.Identity
	}
	if rup.RegistryPropertiesUpdateParameters != nil {
		objectMap["properties"] = rup.RegistryPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegistryUpdateParameters struct.
func (rup *RegistryUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rup.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				rup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var registryPropertiesUpdateParameters RegistryPropertiesUpdateParameters
				err = json.Unmarshal(*v, &registryPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				rup.RegistryPropertiesUpdateParameters = &registryPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// RegistryUsage the quota usage for a container registry.
type RegistryUsage struct {
	// Name - The name of the usage.
	Name *string `json:"name,omitempty"`
	// Limit - The limit of the usage.
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Unit - The unit of measurement. Possible values include: 'Count', 'Bytes'
	Unit RegistryUsageUnit `json:"unit,omitempty"`
}

// RegistryUsageListResult the result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry quota usages.
	Value *[]RegistryUsage `json:"value,omitempty"`
}

// Replication an object that represents a replication for a container registry.
type Replication struct {
	autorest.Response `json:"-"`
	// ReplicationProperties - The properties of the replication.
	*ReplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReplicationProperties != nil {
		objectMap["properties"] = r.ReplicationProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Replication struct.
func (r *Replication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var replicationProperties ReplicationProperties
				err = json.Unmarshal(*v, &replicationProperties)
				if err != nil {
					return err
				}
				r.ReplicationProperties = &replicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// ReplicationListResult the result of a request to list replications for a container registry.
type ReplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list of replications.
	Value *[]Replication `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of replications.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationListResultIterator provides access to a complete listing of Replication values.
type ReplicationListResultIterator struct {
	i    int
	page ReplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationListResultIterator) Response() ReplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationListResultIterator) Value() Replication {
	if !iter.page.NotDone() {
		return Replication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationListResultIterator type.
func NewReplicationListResultIterator(page ReplicationListResultPage) ReplicationListResultIterator {
	return ReplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ReplicationListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ReplicationListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// replicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ReplicationListResult) replicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ReplicationListResultPage contains a page of Replication values.
type ReplicationListResultPage struct {
	fn  func(context.Context, ReplicationListResult) (ReplicationListResult, error)
	rlr ReplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationListResultPage) Response() ReplicationListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationListResultPage) Values() []Replication {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ReplicationListResultPage type.
func NewReplicationListResultPage(cur ReplicationListResult, getNextPage func(context.Context, ReplicationListResult) (ReplicationListResult, error)) ReplicationListResultPage {
	return ReplicationListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// ReplicationProperties the properties of a replication.
type ReplicationProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the replication at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status `json:"status,omitempty"`
	// RegionEndpointEnabled - Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
	RegionEndpointEnabled *bool `json:"regionEndpointEnabled,omitempty"`
	// ZoneRedundancy - Whether or not zone redundancy is enabled for this container registry replication. Possible values include: 'ZoneRedundancyEnabled', 'ZoneRedundancyDisabled'
	ZoneRedundancy ZoneRedundancy `json:"zoneRedundancy,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationProperties.
func (rp ReplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RegionEndpointEnabled != nil {
		objectMap["regionEndpointEnabled"] = rp.RegionEndpointEnabled
	}
	if rp.ZoneRedundancy != "" {
		objectMap["zoneRedundancy"] = rp.ZoneRedundancy
	}
	return json.Marshal(objectMap)
}

// ReplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsCreateFuture.Result.
func (future *ReplicationsCreateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsDeleteFuture.Result.
func (future *ReplicationsDeleteFuture) result(client ReplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsUpdateFuture.Result.
func (future *ReplicationsUpdateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationUpdateParameters the parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// Tags - The tags for the replication.
	Tags map[string]*string `json:"tags"`
	// ReplicationUpdateParametersProperties - The parameters for updating a replication's properties
	*ReplicationUpdateParametersProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationUpdateParameters.
func (rup ReplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	if rup.ReplicationUpdateParametersProperties != nil {
		objectMap["properties"] = rup.ReplicationUpdateParametersProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ReplicationUpdateParameters struct.
func (rup *ReplicationUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		case "properties":
			if v != nil {
				var replicationUpdateParametersProperties ReplicationUpdateParametersProperties
				err = json.Unmarshal(*v, &replicationUpdateParametersProperties)
				if err != nil {
					return err
				}
				rup.ReplicationUpdateParametersProperties = &replicationUpdateParametersProperties
			}
		}
	}

	return nil
}

// ReplicationUpdateParametersProperties ...
type ReplicationUpdateParametersProperties struct {
	// RegionEndpointEnabled - Specifies whether the replication's regional endpoint is enabled. Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue to be synced with other replications.
	RegionEndpointEnabled *bool `json:"regionEndpointEnabled,omitempty"`
}

// Request the request that generated the event.
type Request struct {
	// ID - The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`
	// Addr - The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
	Addr *string `json:"addr,omitempty"`
	// Host - The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`
	// Method - The request method that generated the event.
	Method *string `json:"method,omitempty"`
	// Useragent - The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RetentionPolicy the retention policy for a container registry.
type RetentionPolicy struct {
	// Days - The number of days to retain an untagged manifest after which it gets purged.
	Days *int32 `json:"days,omitempty"`
	// LastUpdatedTime - READ-ONLY; The timestamp when the policy was last updated.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for RetentionPolicy.
func (rp RetentionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.Days != nil {
		objectMap["days"] = rp.Days
	}
	if rp.Status != "" {
		objectMap["status"] = rp.Status
	}
	return json.Marshal(objectMap)
}

// Run run resource properties
type Run struct {
	autorest.Response `json:"-"`
	// RunProperties - The properties of a run.
	*RunProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Run.
func (r Run) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.RunProperties != nil {
		objectMap["properties"] = r.RunProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Run struct.
func (r *Run) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var runProperties RunProperties
				err = json.Unmarshal(*v, &runProperties)
				if err != nil {
					return err
				}
				r.RunProperties = &runProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				r.SystemData = &systemData
			}
		}
	}

	return nil
}

// RunFilter properties that are enabled for Odata querying on runs.
type RunFilter struct {
	// RunID - The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`
	// RunType - The type of run. Possible values include: 'QuickBuild', 'QuickRun', 'AutoBuild', 'AutoRun'
	RunType RunType `json:"runType,omitempty"`
	// Status - The current status of the run. Possible values include: 'RunStatusQueued', 'RunStatusStarted', 'RunStatusRunning', 'RunStatusSucceeded', 'RunStatusFailed', 'RunStatusCanceled', 'RunStatusError', 'RunStatusTimeout'
	Status RunStatus `json:"status,omitempty"`
	// CreateTime - The create time for a run.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// FinishTime - The time the run finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImageManifests - The list of comma-separated image manifests that were generated from the run. This is applicable if the run is of
	// build type.
	OutputImageManifests *string `json:"outputImageManifests,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// TaskName - The name of the task that the run corresponds to.
	TaskName *string `json:"taskName,omitempty"`
	// AgentPoolName - The name of the agent pool that the run corresponds to.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
}

// RunGetLogResult the result of get log link operation.
type RunGetLogResult struct {
	autorest.Response `json:"-"`
	// LogLink - The link to logs for a run on a azure container registry.
	LogLink *string `json:"logLink,omitempty"`
	// LogArtifactLink - The link to logs in registry for a run on a azure container registry.
	LogArtifactLink *string `json:"logArtifactLink,omitempty"`
}

// RunListResult collection of runs.
type RunListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Run `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// RunListResultIterator provides access to a complete listing of Run values.
type RunListResultIterator struct {
	i    int
	page RunListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RunListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RunListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RunListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RunListResultIterator) Response() RunListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RunListResultIterator) Value() Run {
	if !iter.page.NotDone() {
		return Run{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RunListResultIterator type.
func NewRunListResultIterator(page RunListResultPage) RunListResultIterator {
	return RunListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RunListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RunListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// runListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RunListResult) runListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RunListResultPage contains a page of Run values.
type RunListResultPage struct {
	fn  func(context.Context, RunListResult) (RunListResult, error)
	rlr RunListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RunListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RunListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RunListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RunListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RunListResultPage) Response() RunListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RunListResultPage) Values() []Run {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RunListResultPage type.
func NewRunListResultPage(cur RunListResult, getNextPage func(context.Context, RunListResult) (RunListResult, error)) RunListResultPage {
	return RunListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RunProperties the properties for a run.
type RunProperties struct {
	// RunID - The unique identifier for the run.
	RunID *string `json:"runId,omitempty"`
	// Status - The current status of the run. Possible values include: 'RunStatusQueued', 'RunStatusStarted', 'RunStatusRunning', 'RunStatusSucceeded', 'RunStatusFailed', 'RunStatusCanceled', 'RunStatusError', 'RunStatusTimeout'
	Status RunStatus `json:"status,omitempty"`
	// LastUpdatedTime - The last updated time for the run.
	LastUpdatedTime *date.Time `json:"lastUpdatedTime,omitempty"`
	// RunType - The type of run. Possible values include: 'QuickBuild', 'QuickRun', 'AutoBuild', 'AutoRun'
	RunType RunType `json:"runType,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// CreateTime - The time the run was scheduled.
	CreateTime *date.Time `json:"createTime,omitempty"`
	// StartTime - The time the run started.
	StartTime *date.Time `json:"startTime,omitempty"`
	// FinishTime - The time the run finished.
	FinishTime *date.Time `json:"finishTime,omitempty"`
	// OutputImages - The list of all images that were generated from the run. This is applicable if the run generates base image dependencies.
	OutputImages *[]ImageDescriptor `json:"outputImages,omitempty"`
	// Task - The task against which run was scheduled.
	Task *string `json:"task,omitempty"`
	// ImageUpdateTrigger - The image update trigger that caused the run. This is applicable if the task has base image trigger configured.
	ImageUpdateTrigger *ImageUpdateTrigger `json:"imageUpdateTrigger,omitempty"`
	// SourceTrigger - The source trigger that caused the run.
	SourceTrigger *SourceTriggerDescriptor `json:"sourceTrigger,omitempty"`
	// TimerTrigger - The timer trigger that caused the run.
	TimerTrigger *TimerTriggerDescriptor `json:"timerTrigger,omitempty"`
	// Platform - The platform properties against which the run will happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// SourceRegistryAuth - The scope of the credentials that were used to login to the source registry during this run.
	SourceRegistryAuth *string `json:"sourceRegistryAuth,omitempty"`
	// CustomRegistries - The list of custom registries that were logged in during this run.
	CustomRegistries *[]string `json:"customRegistries,omitempty"`
	// RunErrorMessage - READ-ONLY; The error message received from backend systems after the run is scheduled.
	RunErrorMessage *string `json:"runErrorMessage,omitempty"`
	// UpdateTriggerToken - The update trigger token passed for the Run.
	UpdateTriggerToken *string `json:"updateTriggerToken,omitempty"`
	// LogArtifact - READ-ONLY; The image description for the log artifact.
	LogArtifact *ImageDescriptor `json:"logArtifact,omitempty"`
	// ProvisioningState - The provisioning state of a run. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for RunProperties.
func (rp RunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.RunID != nil {
		objectMap["runId"] = rp.RunID
	}
	if rp.Status != "" {
		objectMap["status"] = rp.Status
	}
	if rp.LastUpdatedTime != nil {
		objectMap["lastUpdatedTime"] = rp.LastUpdatedTime
	}
	if rp.RunType != "" {
		objectMap["runType"] = rp.RunType
	}
	if rp.AgentPoolName != nil {
		objectMap["agentPoolName"] = rp.AgentPoolName
	}
	if rp.CreateTime != nil {
		objectMap["createTime"] = rp.CreateTime
	}
	if rp.StartTime != nil {
		objectMap["startTime"] = rp.StartTime
	}
	if rp.FinishTime != nil {
		objectMap["finishTime"] = rp.FinishTime
	}
	if rp.OutputImages != nil {
		objectMap["outputImages"] = rp.OutputImages
	}
	if rp.Task != nil {
		objectMap["task"] = rp.Task
	}
	if rp.ImageUpdateTrigger != nil {
		objectMap["imageUpdateTrigger"] = rp.ImageUpdateTrigger
	}
	if rp.SourceTrigger != nil {
		objectMap["sourceTrigger"] = rp.SourceTrigger
	}
	if rp.TimerTrigger != nil {
		objectMap["timerTrigger"] = rp.TimerTrigger
	}
	if rp.Platform != nil {
		objectMap["platform"] = rp.Platform
	}
	if rp.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = rp.AgentConfiguration
	}
	if rp.SourceRegistryAuth != nil {
		objectMap["sourceRegistryAuth"] = rp.SourceRegistryAuth
	}
	if rp.CustomRegistries != nil {
		objectMap["customRegistries"] = rp.CustomRegistries
	}
	if rp.UpdateTriggerToken != nil {
		objectMap["updateTriggerToken"] = rp.UpdateTriggerToken
	}
	if rp.ProvisioningState != "" {
		objectMap["provisioningState"] = rp.ProvisioningState
	}
	if rp.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = rp.IsArchiveEnabled
	}
	return json.Marshal(objectMap)
}

// BasicRunRequest the request parameters for scheduling a run.
type BasicRunRequest interface {
	AsDockerBuildRequest() (*DockerBuildRequest, bool)
	AsFileTaskRunRequest() (*FileTaskRunRequest, bool)
	AsTaskRunRequest() (*TaskRunRequest, bool)
	AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool)
	AsRunRequest() (*RunRequest, bool)
}

// RunRequest the request parameters for scheduling a run.
type RunRequest struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

func unmarshalBasicRunRequest(body []byte) (BasicRunRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDockerBuildRequest):
		var dbr DockerBuildRequest
		err := json.Unmarshal(body, &dbr)
		return dbr, err
	case string(TypeFileTaskRunRequest):
		var ftrr FileTaskRunRequest
		err := json.Unmarshal(body, &ftrr)
		return ftrr, err
	case string(TypeTaskRunRequest):
		var trr TaskRunRequest
		err := json.Unmarshal(body, &trr)
		return trr, err
	case string(TypeEncodedTaskRunRequest):
		var etrr EncodedTaskRunRequest
		err := json.Unmarshal(body, &etrr)
		return etrr, err
	default:
		var rr RunRequest
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicRunRequestArray(body []byte) ([]BasicRunRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicRunRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicRunRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for RunRequest.
func (rr RunRequest) MarshalJSON() ([]byte, error) {
	rr.Type = TypeRunRequest
	objectMap := make(map[string]interface{})
	if rr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = rr.IsArchiveEnabled
	}
	if rr.AgentPoolName != nil {
		objectMap["agentPoolName"] = rr.AgentPoolName
	}
	if rr.LogTemplate != nil {
		objectMap["logTemplate"] = rr.LogTemplate
	}
	if rr.Type != "" {
		objectMap["type"] = rr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return nil, false
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsRunRequest() (*RunRequest, bool) {
	return &rr, true
}

// AsBasicRunRequest is the BasicRunRequest implementation for RunRequest.
func (rr RunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &rr, true
}

// RunsCancelFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RunsCancelFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RunsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RunsCancelFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RunsCancelFuture.Result.
func (future *RunsCancelFuture) result(client RunsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RunsCancelFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RunsCancelFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RunsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type RunsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RunsClient) (Run, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RunsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RunsUpdateFuture.Result.
func (future *RunsUpdateFuture) result(client RunsClient) (r Run, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RunsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.RunsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RunsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RunUpdateParameters the set of run properties that can be updated.
type RunUpdateParameters struct {
	// IsArchiveEnabled - The value that indicates whether archiving is enabled or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
}

// ScopeMap an object that represents a scope map for a container registry.
type ScopeMap struct {
	autorest.Response `json:"-"`
	// ScopeMapProperties - The properties of the scope map.
	*ScopeMapProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeMap.
func (sm ScopeMap) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sm.ScopeMapProperties != nil {
		objectMap["properties"] = sm.ScopeMapProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopeMap struct.
func (sm *ScopeMap) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scopeMapProperties ScopeMapProperties
				err = json.Unmarshal(*v, &scopeMapProperties)
				if err != nil {
					return err
				}
				sm.ScopeMapProperties = &scopeMapProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sm.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sm.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sm.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				sm.SystemData = &systemData
			}
		}
	}

	return nil
}

// ScopeMapListResult the result of a request to list scope maps for a container registry.
type ScopeMapListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of scope maps. Since this list may be incomplete, the nextLink field should be used to request the next list of scope maps.
	Value *[]ScopeMap `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of scope maps.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScopeMapListResultIterator provides access to a complete listing of ScopeMap values.
type ScopeMapListResultIterator struct {
	i    int
	page ScopeMapListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScopeMapListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopeMapListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ScopeMapListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScopeMapListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScopeMapListResultIterator) Response() ScopeMapListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScopeMapListResultIterator) Value() ScopeMap {
	if !iter.page.NotDone() {
		return ScopeMap{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ScopeMapListResultIterator type.
func NewScopeMapListResultIterator(page ScopeMapListResultPage) ScopeMapListResultIterator {
	return ScopeMapListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (smlr ScopeMapListResult) IsEmpty() bool {
	return smlr.Value == nil || len(*smlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (smlr ScopeMapListResult) hasNextLink() bool {
	return smlr.NextLink != nil && len(*smlr.NextLink) != 0
}

// scopeMapListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (smlr ScopeMapListResult) scopeMapListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !smlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(smlr.NextLink)))
}

// ScopeMapListResultPage contains a page of ScopeMap values.
type ScopeMapListResultPage struct {
	fn   func(context.Context, ScopeMapListResult) (ScopeMapListResult, error)
	smlr ScopeMapListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScopeMapListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ScopeMapListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.smlr)
		if err != nil {
			return err
		}
		page.smlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ScopeMapListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScopeMapListResultPage) NotDone() bool {
	return !page.smlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScopeMapListResultPage) Response() ScopeMapListResult {
	return page.smlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScopeMapListResultPage) Values() []ScopeMap {
	if page.smlr.IsEmpty() {
		return nil
	}
	return *page.smlr.Value
}

// Creates a new instance of the ScopeMapListResultPage type.
func NewScopeMapListResultPage(cur ScopeMapListResult, getNextPage func(context.Context, ScopeMapListResult) (ScopeMapListResult, error)) ScopeMapListResultPage {
	return ScopeMapListResultPage{
		fn:   getNextPage,
		smlr: cur,
	}
}

// ScopeMapProperties the properties of a scope map.
type ScopeMapProperties struct {
	// Description - The user friendly description of the scope map.
	Description *string `json:"description,omitempty"`
	// Type - READ-ONLY; The type of the scope map. E.g. BuildIn scope map.
	Type *string `json:"type,omitempty"`
	// CreationDate - READ-ONLY; The creation date of scope map.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Actions - The list of scoped permissions for registry artifacts.
	// E.g. repositories/repository-name/content/read,
	// repositories/repository-name/metadata/write
	Actions *[]string `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeMapProperties.
func (smp ScopeMapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smp.Description != nil {
		objectMap["description"] = smp.Description
	}
	if smp.Actions != nil {
		objectMap["actions"] = smp.Actions
	}
	return json.Marshal(objectMap)
}

// ScopeMapPropertiesUpdateParameters the update parameters for scope map properties.
type ScopeMapPropertiesUpdateParameters struct {
	// Description - The user friendly description of the scope map.
	Description *string `json:"description,omitempty"`
	// Actions - The list of scope permissions for registry artifacts.
	// E.g. repositories/repository-name/pull,
	// repositories/repository-name/delete
	Actions *[]string `json:"actions,omitempty"`
}

// ScopeMapsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScopeMapsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScopeMapsClient) (ScopeMap, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScopeMapsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScopeMapsCreateFuture.Result.
func (future *ScopeMapsCreateFuture) result(client ScopeMapsClient) (sm ScopeMap, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ScopeMapsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ScopeMapsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.CreateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ScopeMapsCreateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ScopeMapsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScopeMapsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScopeMapsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScopeMapsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScopeMapsDeleteFuture.Result.
func (future *ScopeMapsDeleteFuture) result(client ScopeMapsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ScopeMapsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ScopeMapsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ScopeMapsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ScopeMapsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ScopeMapsClient) (ScopeMap, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ScopeMapsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ScopeMapsUpdateFuture.Result.
func (future *ScopeMapsUpdateFuture) result(client ScopeMapsClient) (sm ScopeMap, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ScopeMapsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.ScopeMapsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if sm.Response.Response, err = future.GetResult(sender); err == nil && sm.Response.Response.StatusCode != http.StatusNoContent {
		sm, err = client.UpdateResponder(sm.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ScopeMapsUpdateFuture", "Result", sm.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ScopeMapUpdateParameters the properties for updating the scope map.
type ScopeMapUpdateParameters struct {
	// ScopeMapPropertiesUpdateParameters - The update parameters for scope map properties.
	*ScopeMapPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ScopeMapUpdateParameters.
func (smup ScopeMapUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if smup.ScopeMapPropertiesUpdateParameters != nil {
		objectMap["properties"] = smup.ScopeMapPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ScopeMapUpdateParameters struct.
func (smup *ScopeMapUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var scopeMapPropertiesUpdateParameters ScopeMapPropertiesUpdateParameters
				err = json.Unmarshal(*v, &scopeMapPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				smup.ScopeMapPropertiesUpdateParameters = &scopeMapPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// SecretObject describes the properties of a secret object value.
type SecretObject struct {
	// Value - The value of the secret. The format of this value will be determined
	// based on the type of the secret object. If the type is Opaque, the value will be
	// used as is without any modification.
	Value *string `json:"value,omitempty"`
	// Type - The type of the secret object which determines how the value of the secret object has to be
	// interpreted. Possible values include: 'Opaque', 'Vaultsecret'
	Type SecretObjectType `json:"type,omitempty"`
}

// SetValue the properties of a overridable value that can be passed to a task template.
type SetValue struct {
	// Name - The name of the overridable value.
	Name *string `json:"name,omitempty"`
	// Value - The overridable value.
	Value *string `json:"value,omitempty"`
	// IsSecret - Flag to indicate whether the value represents a secret or not.
	IsSecret *bool `json:"isSecret,omitempty"`
}

// Sku the SKU of a container registry.
type Sku struct {
	// Name - The SKU name of the container registry. Required for registry creation. Possible values include: 'Classic', 'Basic', 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; The SKU tier based on the SKU name. Possible values include: 'SkuTierClassic', 'SkuTierBasic', 'SkuTierStandard', 'SkuTierPremium'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// Source the registry node that generated the event. Put differently, while the actor initiates the event,
// the source generates it.
type Source struct {
	// Addr - The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
	Addr *string `json:"addr,omitempty"`
	// InstanceID - The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// SourceProperties the properties of the source code repository.
type SourceProperties struct {
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The branch name of the source code.
	Branch *string `json:"branch,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository and to set up
	// webhooks for notifications.
	SourceControlAuthProperties *AuthInfo `json:"sourceControlAuthProperties,omitempty"`
}

// SourceRegistryCredentials describes the credential parameters for accessing the source registry.
type SourceRegistryCredentials struct {
	// LoginMode - The authentication mode which determines the source registry login scope. The credentials for the source registry
	// will be generated using the given scope. These credentials will be used to login to
	// the source registry during the run. Possible values include: 'SourceRegistryLoginModeNone', 'SourceRegistryLoginModeDefault'
	LoginMode SourceRegistryLoginMode `json:"loginMode,omitempty"`
}

// SourceTrigger the properties of a source based trigger.
type SourceTrigger struct {
	// SourceRepository - The properties that describes the source(code) for the task.
	SourceRepository *SourceProperties `json:"sourceRepository,omitempty"`
	// SourceTriggerEvents - The source event corresponding to the trigger.
	SourceTriggerEvents *[]SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// SourceTriggerDescriptor the source trigger that caused a run.
type SourceTriggerDescriptor struct {
	// ID - The unique ID of the trigger.
	ID *string `json:"id,omitempty"`
	// EventType - The event type of the trigger.
	EventType *string `json:"eventType,omitempty"`
	// CommitID - The unique ID that identifies a commit.
	CommitID *string `json:"commitId,omitempty"`
	// PullRequestID - The unique ID that identifies pull request.
	PullRequestID *string `json:"pullRequestId,omitempty"`
	// RepositoryURL - The repository URL.
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// BranchName - The branch name in the repository.
	BranchName *string `json:"branchName,omitempty"`
	// ProviderType - The source control provider type.
	ProviderType *string `json:"providerType,omitempty"`
}

// SourceTriggerUpdateParameters the properties for updating a source based trigger.
type SourceTriggerUpdateParameters struct {
	// SourceRepository - The properties that describes the source(code) for the task.
	SourceRepository *SourceUpdateParameters `json:"sourceRepository,omitempty"`
	// SourceTriggerEvents - The source event corresponding to the trigger.
	SourceTriggerEvents *[]SourceTriggerEvent `json:"sourceTriggerEvents,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// SourceUpdateParameters the properties for updating the source code repository.
type SourceUpdateParameters struct {
	// SourceControlType - The type of source control service. Possible values include: 'Github', 'VisualStudioTeamService'
	SourceControlType SourceControlType `json:"sourceControlType,omitempty"`
	// RepositoryURL - The full URL to the source code repository
	RepositoryURL *string `json:"repositoryUrl,omitempty"`
	// Branch - The branch name of the source code.
	Branch *string `json:"branch,omitempty"`
	// SourceControlAuthProperties - The authorization properties for accessing the source code repository and to set up
	// webhooks for notifications.
	SourceControlAuthProperties *AuthInfoUpdateParameters `json:"sourceControlAuthProperties,omitempty"`
}

// SourceUploadDefinition the properties of a response to source upload request.
type SourceUploadDefinition struct {
	autorest.Response `json:"-"`
	// UploadURL - The URL where the client can upload the source.
	UploadURL *string `json:"uploadUrl,omitempty"`
	// RelativePath - The relative path to the source. This is used to submit the subsequent queue build request.
	RelativePath *string `json:"relativePath,omitempty"`
}

// Status the status of an Azure resource at the time the operation was called.
type Status struct {
	// DisplayStatus - READ-ONLY; The short label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Timestamp - READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// StatusDetailProperties the status detail properties of the connected registry.
type StatusDetailProperties struct {
	// Type - READ-ONLY; The component of the connected registry corresponding to the status.
	Type *string `json:"type,omitempty"`
	// Code - READ-ONLY; The code of the status.
	Code *string `json:"code,omitempty"`
	// Description - READ-ONLY; The description of the status.
	Description *string `json:"description,omitempty"`
	// Timestamp - READ-ONLY; The timestamp of the status.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// CorrelationID - READ-ONLY; The correlation ID of the status.
	CorrelationID *string `json:"correlationId,omitempty"`
}

// StorageAccountProperties the properties of a storage account for a container registry. Only applicable
// to Classic SKU.
type StorageAccountProperties struct {
	// ID - The resource ID of the storage account.
	ID *string `json:"id,omitempty"`
}

// SyncProperties the sync properties of the connected registry with its parent.
type SyncProperties struct {
	// TokenID - The resource ID of the ACR token used to authenticate the connected registry to its parent during sync.
	TokenID *string `json:"tokenId,omitempty"`
	// Schedule - The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string `json:"schedule,omitempty"`
	// SyncWindow - The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	SyncWindow *string `json:"syncWindow,omitempty"`
	// MessageTTL - The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string `json:"messageTtl,omitempty"`
	// LastSyncTime - READ-ONLY; The last time a sync occurred between the connected registry and its parent.
	LastSyncTime *date.Time `json:"lastSyncTime,omitempty"`
	// GatewayEndpoint - READ-ONLY; The gateway endpoint used by the connected registry to communicate with its parent.
	GatewayEndpoint *string `json:"gatewayEndpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for SyncProperties.
func (sp SyncProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.TokenID != nil {
		objectMap["tokenId"] = sp.TokenID
	}
	if sp.Schedule != nil {
		objectMap["schedule"] = sp.Schedule
	}
	if sp.SyncWindow != nil {
		objectMap["syncWindow"] = sp.SyncWindow
	}
	if sp.MessageTTL != nil {
		objectMap["messageTtl"] = sp.MessageTTL
	}
	return json.Marshal(objectMap)
}

// SyncUpdateProperties the parameters for updating the sync properties of the connected registry with its
// parent.
type SyncUpdateProperties struct {
	// Schedule - The cron expression indicating the schedule that the connected registry will sync with its parent.
	Schedule *string `json:"schedule,omitempty"`
	// SyncWindow - The time window during which sync is enabled for each schedule occurrence. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	SyncWindow *string `json:"syncWindow,omitempty"`
	// MessageTTL - The period of time for which a message is available to sync before it is expired. Specify the duration using the format P[n]Y[n]M[n]DT[n]H[n]M[n]S as per ISO8601.
	MessageTTL *string `json:"messageTtl,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'LastModifiedByTypeUser', 'LastModifiedByTypeApplication', 'LastModifiedByTypeManagedIdentity', 'LastModifiedByTypeKey'
	LastModifiedByType LastModifiedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource modification (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Target the target of the event.
type Target struct {
	// MediaType - The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`
	// Length - The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// URL - The direct URL to the content.
	URL *string `json:"url,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
	// Name - The name of the artifact.
	Name *string `json:"name,omitempty"`
	// Version - The version of the artifact.
	Version *string `json:"version,omitempty"`
}

// Task the task that has the ARM resource and task properties.
// The task will have all information to schedule a run against it.
type Task struct {
	autorest.Response `json:"-"`
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskProperties - The properties of a task.
	*TaskProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Task.
func (t Task) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Identity != nil {
		objectMap["identity"] = t.Identity
	}
	if t.TaskProperties != nil {
		objectMap["properties"] = t.TaskProperties
	}
	if t.Location != nil {
		objectMap["location"] = t.Location
	}
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Task struct.
func (t *Task) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				t.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskProperties TaskProperties
				err = json.Unmarshal(*v, &taskProperties)
				if err != nil {
					return err
				}
				t.TaskProperties = &taskProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				t.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				t.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				t.SystemData = &systemData
			}
		}
	}

	return nil
}

// TaskListResult the collection of tasks.
type TaskListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]Task `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskListResultIterator provides access to a complete listing of Task values.
type TaskListResultIterator struct {
	i    int
	page TaskListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskListResultIterator) Response() TaskListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskListResultIterator) Value() Task {
	if !iter.page.NotDone() {
		return Task{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskListResultIterator type.
func NewTaskListResultIterator(page TaskListResultPage) TaskListResultIterator {
	return TaskListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TaskListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TaskListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// taskListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TaskListResult) taskListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TaskListResultPage contains a page of Task values.
type TaskListResultPage struct {
	fn  func(context.Context, TaskListResult) (TaskListResult, error)
	tlr TaskListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskListResultPage) Response() TaskListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskListResultPage) Values() []Task {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TaskListResultPage type.
func NewTaskListResultPage(cur TaskListResult, getNextPage func(context.Context, TaskListResult) (TaskListResult, error)) TaskListResultPage {
	return TaskListResultPage{
		fn:  getNextPage,
		tlr: cur,
	}
}

// TaskProperties the properties of a task.
type TaskProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the task. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CreationDate - READ-ONLY; The creation date of task.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// Status - The current status of task. Possible values include: 'TaskStatusDisabled', 'TaskStatusEnabled'
	Status TaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformProperties `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// AgentPoolName - The dedicated agent pool for the task.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Step - The properties of a task step.
	Step BasicTaskStepProperties `json:"step,omitempty"`
	// Trigger - The properties that describe all triggers for the task.
	Trigger *TriggerProperties `json:"trigger,omitempty"`
	// Credentials - The properties that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// IsSystemTask - The value of this property indicates whether the task resource is system task or not.
	IsSystemTask *bool `json:"isSystemTask,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskProperties.
func (tp TaskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.Status != "" {
		objectMap["status"] = tp.Status
	}
	if tp.Platform != nil {
		objectMap["platform"] = tp.Platform
	}
	if tp.AgentConfiguration != nil {
		objectMap["agentConfiguration"] = tp.AgentConfiguration
	}
	if tp.AgentPoolName != nil {
		objectMap["agentPoolName"] = tp.AgentPoolName
	}
	if tp.Timeout != nil {
		objectMap["timeout"] = tp.Timeout
	}
	objectMap["step"] = tp.Step
	if tp.Trigger != nil {
		objectMap["trigger"] = tp.Trigger
	}
	if tp.Credentials != nil {
		objectMap["credentials"] = tp.Credentials
	}
	if tp.LogTemplate != nil {
		objectMap["logTemplate"] = tp.LogTemplate
	}
	if tp.IsSystemTask != nil {
		objectMap["isSystemTask"] = tp.IsSystemTask
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskProperties struct.
func (tp *TaskProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				tp.ProvisioningState = provisioningState
			}
		case "creationDate":
			if v != nil {
				var creationDate date.Time
				err = json.Unmarshal(*v, &creationDate)
				if err != nil {
					return err
				}
				tp.CreationDate = &creationDate
			}
		case "status":
			if v != nil {
				var status TaskStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				tp.Status = status
			}
		case "platform":
			if v != nil {
				var platform PlatformProperties
				err = json.Unmarshal(*v, &platform)
				if err != nil {
					return err
				}
				tp.Platform = &platform
			}
		case "agentConfiguration":
			if v != nil {
				var agentConfiguration AgentProperties
				err = json.Unmarshal(*v, &agentConfiguration)
				if err != nil {
					return err
				}
				tp.AgentConfiguration = &agentConfiguration
			}
		case "agentPoolName":
			if v != nil {
				var agentPoolName string
				err = json.Unmarshal(*v, &agentPoolName)
				if err != nil {
					return err
				}
				tp.AgentPoolName = &agentPoolName
			}
		case "timeout":
			if v != nil {
				var timeout int32
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				tp.Timeout = &timeout
			}
		case "step":
			if v != nil {
				step, err := unmarshalBasicTaskStepProperties(*v)
				if err != nil {
					return err
				}
				tp.Step = step
			}
		case "trigger":
			if v != nil {
				var trigger TriggerProperties
				err = json.Unmarshal(*v, &trigger)
				if err != nil {
					return err
				}
				tp.Trigger = &trigger
			}
		case "credentials":
			if v != nil {
				var credentials Credentials
				err = json.Unmarshal(*v, &credentials)
				if err != nil {
					return err
				}
				tp.Credentials = &credentials
			}
		case "logTemplate":
			if v != nil {
				var logTemplate string
				err = json.Unmarshal(*v, &logTemplate)
				if err != nil {
					return err
				}
				tp.LogTemplate = &logTemplate
			}
		case "isSystemTask":
			if v != nil {
				var isSystemTask bool
				err = json.Unmarshal(*v, &isSystemTask)
				if err != nil {
					return err
				}
				tp.IsSystemTask = &isSystemTask
			}
		}
	}

	return nil
}

// TaskPropertiesUpdateParameters the properties for updating a task.
type TaskPropertiesUpdateParameters struct {
	// Status - The current status of task. Possible values include: 'TaskStatusDisabled', 'TaskStatusEnabled'
	Status TaskStatus `json:"status,omitempty"`
	// Platform - The platform properties against which the run has to happen.
	Platform *PlatformUpdateParameters `json:"platform,omitempty"`
	// AgentConfiguration - The machine configuration of the run agent.
	AgentConfiguration *AgentProperties `json:"agentConfiguration,omitempty"`
	// AgentPoolName - The dedicated agent pool for the task.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// Timeout - Run timeout in seconds.
	Timeout *int32 `json:"timeout,omitempty"`
	// Step - The properties for updating a task step.
	Step BasicTaskStepUpdateParameters `json:"step,omitempty"`
	// Trigger - The properties for updating trigger properties.
	Trigger *TriggerUpdateParameters `json:"trigger,omitempty"`
	// Credentials - The parameters that describes a set of credentials that will be used when this run is invoked.
	Credentials *Credentials `json:"credentials,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TaskPropertiesUpdateParameters struct.
func (tpup *TaskPropertiesUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status TaskStatus
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				tpup.Status = status
			}
		case "platform":
			if v != nil {
				var platform PlatformUpdateParameters
				err = json.Unmarshal(*v, &platform)
				if err != nil {
					return err
				}
				tpup.Platform = &platform
			}
		case "agentConfiguration":
			if v != nil {
				var agentConfiguration AgentProperties
				err = json.Unmarshal(*v, &agentConfiguration)
				if err != nil {
					return err
				}
				tpup.AgentConfiguration = &agentConfiguration
			}
		case "agentPoolName":
			if v != nil {
				var agentPoolName string
				err = json.Unmarshal(*v, &agentPoolName)
				if err != nil {
					return err
				}
				tpup.AgentPoolName = &agentPoolName
			}
		case "timeout":
			if v != nil {
				var timeout int32
				err = json.Unmarshal(*v, &timeout)
				if err != nil {
					return err
				}
				tpup.Timeout = &timeout
			}
		case "step":
			if v != nil {
				step, err := unmarshalBasicTaskStepUpdateParameters(*v)
				if err != nil {
					return err
				}
				tpup.Step = step
			}
		case "trigger":
			if v != nil {
				var trigger TriggerUpdateParameters
				err = json.Unmarshal(*v, &trigger)
				if err != nil {
					return err
				}
				tpup.Trigger = &trigger
			}
		case "credentials":
			if v != nil {
				var credentials Credentials
				err = json.Unmarshal(*v, &credentials)
				if err != nil {
					return err
				}
				tpup.Credentials = &credentials
			}
		case "logTemplate":
			if v != nil {
				var logTemplate string
				err = json.Unmarshal(*v, &logTemplate)
				if err != nil {
					return err
				}
				tpup.LogTemplate = &logTemplate
			}
		}
	}

	return nil
}

// TaskRun the task run that has the ARM resource and properties.
// The task run will have the information of request and result of a run.
type TaskRun struct {
	autorest.Response `json:"-"`
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskRunProperties - The properties associated with the task run, i.e., request and result of the run
	*TaskRunProperties `json:"properties,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskRun.
func (tr TaskRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Identity != nil {
		objectMap["identity"] = tr.Identity
	}
	if tr.TaskRunProperties != nil {
		objectMap["properties"] = tr.TaskRunProperties
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskRun struct.
func (tr *TaskRun) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tr.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskRunProperties TaskRunProperties
				err = json.Unmarshal(*v, &taskRunProperties)
				if err != nil {
					return err
				}
				tr.TaskRunProperties = &taskRunProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				tr.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				tr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				tr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				tr.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				tr.SystemData = &systemData
			}
		}
	}

	return nil
}

// TaskRunListResult the collection of task runs.
type TaskRunListResult struct {
	autorest.Response `json:"-"`
	// Value - The collection value.
	Value *[]TaskRun `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next set of paged results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TaskRunListResultIterator provides access to a complete listing of TaskRun values.
type TaskRunListResultIterator struct {
	i    int
	page TaskRunListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TaskRunListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskRunListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TaskRunListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TaskRunListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TaskRunListResultIterator) Response() TaskRunListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TaskRunListResultIterator) Value() TaskRun {
	if !iter.page.NotDone() {
		return TaskRun{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TaskRunListResultIterator type.
func NewTaskRunListResultIterator(page TaskRunListResultPage) TaskRunListResultIterator {
	return TaskRunListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (trlr TaskRunListResult) IsEmpty() bool {
	return trlr.Value == nil || len(*trlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (trlr TaskRunListResult) hasNextLink() bool {
	return trlr.NextLink != nil && len(*trlr.NextLink) != 0
}

// taskRunListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (trlr TaskRunListResult) taskRunListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !trlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(trlr.NextLink)))
}

// TaskRunListResultPage contains a page of TaskRun values.
type TaskRunListResultPage struct {
	fn   func(context.Context, TaskRunListResult) (TaskRunListResult, error)
	trlr TaskRunListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TaskRunListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TaskRunListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.trlr)
		if err != nil {
			return err
		}
		page.trlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TaskRunListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TaskRunListResultPage) NotDone() bool {
	return !page.trlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TaskRunListResultPage) Response() TaskRunListResult {
	return page.trlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TaskRunListResultPage) Values() []TaskRun {
	if page.trlr.IsEmpty() {
		return nil
	}
	return *page.trlr.Value
}

// Creates a new instance of the TaskRunListResultPage type.
func NewTaskRunListResultPage(cur TaskRunListResult, getNextPage func(context.Context, TaskRunListResult) (TaskRunListResult, error)) TaskRunListResultPage {
	return TaskRunListResultPage{
		fn:   getNextPage,
		trlr: cur,
	}
}

// TaskRunProperties the properties of task run.
type TaskRunProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of this task run. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// RunRequest - The request (parameters) for the run
	RunRequest BasicRunRequest `json:"runRequest,omitempty"`
	// RunResult - READ-ONLY; The result of this task run
	RunResult *Run `json:"runResult,omitempty"`
	// ForceUpdateTag - How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskRunProperties.
func (trp TaskRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["runRequest"] = trp.RunRequest
	if trp.ForceUpdateTag != nil {
		objectMap["forceUpdateTag"] = trp.ForceUpdateTag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskRunProperties struct.
func (trp *TaskRunProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				trp.ProvisioningState = provisioningState
			}
		case "runRequest":
			if v != nil {
				runRequest, err := unmarshalBasicRunRequest(*v)
				if err != nil {
					return err
				}
				trp.RunRequest = runRequest
			}
		case "runResult":
			if v != nil {
				var runResult Run
				err = json.Unmarshal(*v, &runResult)
				if err != nil {
					return err
				}
				trp.RunResult = &runResult
			}
		case "forceUpdateTag":
			if v != nil {
				var forceUpdateTag string
				err = json.Unmarshal(*v, &forceUpdateTag)
				if err != nil {
					return err
				}
				trp.ForceUpdateTag = &forceUpdateTag
			}
		}
	}

	return nil
}

// TaskRunPropertiesUpdateParameters the properties of a task run update parameters.
type TaskRunPropertiesUpdateParameters struct {
	// RunRequest - The request (parameters) for the new run
	RunRequest BasicRunRequest `json:"runRequest,omitempty"`
	// ForceUpdateTag - How the run should be forced to rerun even if the run request configuration has not changed
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for TaskRunPropertiesUpdateParameters struct.
func (trpup *TaskRunPropertiesUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "runRequest":
			if v != nil {
				runRequest, err := unmarshalBasicRunRequest(*v)
				if err != nil {
					return err
				}
				trpup.RunRequest = runRequest
			}
		case "forceUpdateTag":
			if v != nil {
				var forceUpdateTag string
				err = json.Unmarshal(*v, &forceUpdateTag)
				if err != nil {
					return err
				}
				trpup.ForceUpdateTag = &forceUpdateTag
			}
		}
	}

	return nil
}

// TaskRunRequest the parameters for a task run request.
type TaskRunRequest struct {
	// TaskID - The resource ID of task against which run has to be queued.
	TaskID *string `json:"taskId,omitempty"`
	// OverrideTaskStepProperties - Set of overridable parameters that can be passed when running a Task.
	OverrideTaskStepProperties *OverrideTaskStepProperties `json:"overrideTaskStepProperties,omitempty"`
	// IsArchiveEnabled - The value that indicates whether archiving is enabled for the run or not.
	IsArchiveEnabled *bool `json:"isArchiveEnabled,omitempty"`
	// AgentPoolName - The dedicated agent pool for the run.
	AgentPoolName *string `json:"agentPoolName,omitempty"`
	// LogTemplate - The template that describes the repository and tag information for run log artifact.
	LogTemplate *string `json:"logTemplate,omitempty"`
	// Type - Possible values include: 'TypeRunRequest', 'TypeDockerBuildRequest', 'TypeFileTaskRunRequest', 'TypeTaskRunRequest', 'TypeEncodedTaskRunRequest'
	Type Type `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TaskRunRequest.
func (trr TaskRunRequest) MarshalJSON() ([]byte, error) {
	trr.Type = TypeTaskRunRequest
	objectMap := make(map[string]interface{})
	if trr.TaskID != nil {
		objectMap["taskId"] = trr.TaskID
	}
	if trr.OverrideTaskStepProperties != nil {
		objectMap["overrideTaskStepProperties"] = trr.OverrideTaskStepProperties
	}
	if trr.IsArchiveEnabled != nil {
		objectMap["isArchiveEnabled"] = trr.IsArchiveEnabled
	}
	if trr.AgentPoolName != nil {
		objectMap["agentPoolName"] = trr.AgentPoolName
	}
	if trr.LogTemplate != nil {
		objectMap["logTemplate"] = trr.LogTemplate
	}
	if trr.Type != "" {
		objectMap["type"] = trr.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsDockerBuildRequest() (*DockerBuildRequest, bool) {
	return nil, false
}

// AsFileTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsFileTaskRunRequest() (*FileTaskRunRequest, bool) {
	return nil, false
}

// AsTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsTaskRunRequest() (*TaskRunRequest, bool) {
	return &trr, true
}

// AsEncodedTaskRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsEncodedTaskRunRequest() (*EncodedTaskRunRequest, bool) {
	return nil, false
}

// AsRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsRunRequest() (*RunRequest, bool) {
	return nil, false
}

// AsBasicRunRequest is the BasicRunRequest implementation for TaskRunRequest.
func (trr TaskRunRequest) AsBasicRunRequest() (BasicRunRequest, bool) {
	return &trr, true
}

// TaskRunsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TaskRunsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TaskRunsClient) (TaskRun, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TaskRunsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TaskRunsCreateFuture.Result.
func (future *TaskRunsCreateFuture) result(client TaskRunsClient) (tr TaskRun, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TaskRunsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TaskRunsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tr.Response.Response, err = future.GetResult(sender); err == nil && tr.Response.Response.StatusCode != http.StatusNoContent {
		tr, err = client.CreateResponder(tr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TaskRunsCreateFuture", "Result", tr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TaskRunsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TaskRunsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TaskRunsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TaskRunsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TaskRunsDeleteFuture.Result.
func (future *TaskRunsDeleteFuture) result(client TaskRunsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TaskRunsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TaskRunsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TaskRunsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type TaskRunsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TaskRunsClient) (TaskRun, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TaskRunsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TaskRunsUpdateFuture.Result.
func (future *TaskRunsUpdateFuture) result(client TaskRunsClient) (tr TaskRun, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TaskRunsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TaskRunsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if tr.Response.Response, err = future.GetResult(sender); err == nil && tr.Response.Response.StatusCode != http.StatusNoContent {
		tr, err = client.UpdateResponder(tr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TaskRunsUpdateFuture", "Result", tr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TaskRunUpdateParameters the parameters for updating a task run.
type TaskRunUpdateParameters struct {
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskRunPropertiesUpdateParameters - The properties for updating a task run.
	*TaskRunPropertiesUpdateParameters `json:"properties,omitempty"`
	// Location - The location of the resource
	Location *string `json:"location,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TaskRunUpdateParameters.
func (trup TaskRunUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if trup.Identity != nil {
		objectMap["identity"] = trup.Identity
	}
	if trup.TaskRunPropertiesUpdateParameters != nil {
		objectMap["properties"] = trup.TaskRunPropertiesUpdateParameters
	}
	if trup.Location != nil {
		objectMap["location"] = trup.Location
	}
	if trup.Tags != nil {
		objectMap["tags"] = trup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskRunUpdateParameters struct.
func (trup *TaskRunUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				trup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskRunPropertiesUpdateParameters TaskRunPropertiesUpdateParameters
				err = json.Unmarshal(*v, &taskRunPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				trup.TaskRunPropertiesUpdateParameters = &taskRunPropertiesUpdateParameters
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				trup.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				trup.Tags = tags
			}
		}
	}

	return nil
}

// TasksCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TasksClient) (Task, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TasksCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TasksCreateFuture.Result.
func (future *TasksCreateFuture) result(client TasksClient) (t Task, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TasksCreateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TasksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TasksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TasksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TasksDeleteFuture.Result.
func (future *TasksDeleteFuture) result(client TasksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// BasicTaskStepProperties base properties for any task step.
type BasicTaskStepProperties interface {
	AsDockerBuildStep() (*DockerBuildStep, bool)
	AsFileTaskStep() (*FileTaskStep, bool)
	AsEncodedTaskStep() (*EncodedTaskStep, bool)
	AsTaskStepProperties() (*TaskStepProperties, bool)
}

// TaskStepProperties base properties for any task step.
type TaskStepProperties struct {
	// BaseImageDependencies - READ-ONLY; List of base image dependencies for a step.
	BaseImageDependencies *[]BaseImageDependency `json:"baseImageDependencies,omitempty"`
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeTaskStepProperties', 'TypeDocker', 'TypeFileTask', 'TypeEncodedTask'
	Type TypeBasicTaskStepProperties `json:"type,omitempty"`
}

func unmarshalBasicTaskStepProperties(body []byte) (BasicTaskStepProperties, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeDocker):
		var dbs DockerBuildStep
		err := json.Unmarshal(body, &dbs)
		return dbs, err
	case string(TypeFileTask):
		var fts FileTaskStep
		err := json.Unmarshal(body, &fts)
		return fts, err
	case string(TypeEncodedTask):
		var ets EncodedTaskStep
		err := json.Unmarshal(body, &ets)
		return ets, err
	default:
		var tsp TaskStepProperties
		err := json.Unmarshal(body, &tsp)
		return tsp, err
	}
}
func unmarshalBasicTaskStepPropertiesArray(body []byte) ([]BasicTaskStepProperties, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tspArray := make([]BasicTaskStepProperties, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tsp, err := unmarshalBasicTaskStepProperties(*rawMessage)
		if err != nil {
			return nil, err
		}
		tspArray[index] = tsp
	}
	return tspArray, nil
}

// MarshalJSON is the custom marshaler for TaskStepProperties.
func (tsp TaskStepProperties) MarshalJSON() ([]byte, error) {
	tsp.Type = TypeTaskStepProperties
	objectMap := make(map[string]interface{})
	if tsp.ContextPath != nil {
		objectMap["contextPath"] = tsp.ContextPath
	}
	if tsp.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = tsp.ContextAccessToken
	}
	if tsp.Type != "" {
		objectMap["type"] = tsp.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsDockerBuildStep() (*DockerBuildStep, bool) {
	return nil, false
}

// AsFileTaskStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsFileTaskStep() (*FileTaskStep, bool) {
	return nil, false
}

// AsEncodedTaskStep is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsEncodedTaskStep() (*EncodedTaskStep, bool) {
	return nil, false
}

// AsTaskStepProperties is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsTaskStepProperties() (*TaskStepProperties, bool) {
	return &tsp, true
}

// AsBasicTaskStepProperties is the BasicTaskStepProperties implementation for TaskStepProperties.
func (tsp TaskStepProperties) AsBasicTaskStepProperties() (BasicTaskStepProperties, bool) {
	return &tsp, true
}

// BasicTaskStepUpdateParameters base properties for updating any task step.
type BasicTaskStepUpdateParameters interface {
	AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool)
	AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool)
	AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool)
	AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool)
}

// TaskStepUpdateParameters base properties for updating any task step.
type TaskStepUpdateParameters struct {
	// ContextPath - The URL(absolute or relative) of the source context for the task step.
	ContextPath *string `json:"contextPath,omitempty"`
	// ContextAccessToken - The token (git PAT or SAS token of storage account blob) associated with the context for a step.
	ContextAccessToken *string `json:"contextAccessToken,omitempty"`
	// Type - Possible values include: 'TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters', 'TypeBasicTaskStepUpdateParametersTypeDocker', 'TypeBasicTaskStepUpdateParametersTypeFileTask', 'TypeBasicTaskStepUpdateParametersTypeEncodedTask'
	Type TypeBasicTaskStepUpdateParameters `json:"type,omitempty"`
}

func unmarshalBasicTaskStepUpdateParameters(body []byte) (BasicTaskStepUpdateParameters, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["type"] {
	case string(TypeBasicTaskStepUpdateParametersTypeDocker):
		var dbsup DockerBuildStepUpdateParameters
		err := json.Unmarshal(body, &dbsup)
		return dbsup, err
	case string(TypeBasicTaskStepUpdateParametersTypeFileTask):
		var ftsup FileTaskStepUpdateParameters
		err := json.Unmarshal(body, &ftsup)
		return ftsup, err
	case string(TypeBasicTaskStepUpdateParametersTypeEncodedTask):
		var etsup EncodedTaskStepUpdateParameters
		err := json.Unmarshal(body, &etsup)
		return etsup, err
	default:
		var tsup TaskStepUpdateParameters
		err := json.Unmarshal(body, &tsup)
		return tsup, err
	}
}
func unmarshalBasicTaskStepUpdateParametersArray(body []byte) ([]BasicTaskStepUpdateParameters, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tsupArray := make([]BasicTaskStepUpdateParameters, len(rawMessages))

	for index, rawMessage := range rawMessages {
		tsup, err := unmarshalBasicTaskStepUpdateParameters(*rawMessage)
		if err != nil {
			return nil, err
		}
		tsupArray[index] = tsup
	}
	return tsupArray, nil
}

// MarshalJSON is the custom marshaler for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) MarshalJSON() ([]byte, error) {
	tsup.Type = TypeBasicTaskStepUpdateParametersTypeTaskStepUpdateParameters
	objectMap := make(map[string]interface{})
	if tsup.ContextPath != nil {
		objectMap["contextPath"] = tsup.ContextPath
	}
	if tsup.ContextAccessToken != nil {
		objectMap["contextAccessToken"] = tsup.ContextAccessToken
	}
	if tsup.Type != "" {
		objectMap["type"] = tsup.Type
	}
	return json.Marshal(objectMap)
}

// AsDockerBuildStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsDockerBuildStepUpdateParameters() (*DockerBuildStepUpdateParameters, bool) {
	return nil, false
}

// AsFileTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsFileTaskStepUpdateParameters() (*FileTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsEncodedTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsEncodedTaskStepUpdateParameters() (*EncodedTaskStepUpdateParameters, bool) {
	return nil, false
}

// AsTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsTaskStepUpdateParameters() (*TaskStepUpdateParameters, bool) {
	return &tsup, true
}

// AsBasicTaskStepUpdateParameters is the BasicTaskStepUpdateParameters implementation for TaskStepUpdateParameters.
func (tsup TaskStepUpdateParameters) AsBasicTaskStepUpdateParameters() (BasicTaskStepUpdateParameters, bool) {
	return &tsup, true
}

// TasksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TasksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TasksClient) (Task, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TasksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TasksUpdateFuture.Result.
func (future *TasksUpdateFuture) result(client TasksClient) (t Task, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TasksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TasksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TasksUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TaskUpdateParameters the parameters for updating a task.
type TaskUpdateParameters struct {
	// Identity - Identity for the resource.
	Identity *IdentityProperties `json:"identity,omitempty"`
	// TaskPropertiesUpdateParameters - The properties for updating a task.
	*TaskPropertiesUpdateParameters `json:"properties,omitempty"`
	// Tags - The ARM resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for TaskUpdateParameters.
func (tup TaskUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.Identity != nil {
		objectMap["identity"] = tup.Identity
	}
	if tup.TaskPropertiesUpdateParameters != nil {
		objectMap["properties"] = tup.TaskPropertiesUpdateParameters
	}
	if tup.Tags != nil {
		objectMap["tags"] = tup.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TaskUpdateParameters struct.
func (tup *TaskUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "identity":
			if v != nil {
				var identity IdentityProperties
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				tup.Identity = &identity
			}
		case "properties":
			if v != nil {
				var taskPropertiesUpdateParameters TaskPropertiesUpdateParameters
				err = json.Unmarshal(*v, &taskPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				tup.TaskPropertiesUpdateParameters = &taskPropertiesUpdateParameters
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				tup.Tags = tags
			}
		}
	}

	return nil
}

// TimerTrigger the properties of a timer trigger.
type TimerTrigger struct {
	// Schedule - The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// TimerTriggerDescriptor ...
type TimerTriggerDescriptor struct {
	// TimerTriggerName - The timer trigger name that caused the run.
	TimerTriggerName *string `json:"timerTriggerName,omitempty"`
	// ScheduleOccurrence - The occurrence that triggered the run.
	ScheduleOccurrence *string `json:"scheduleOccurrence,omitempty"`
}

// TimerTriggerUpdateParameters the properties for updating a timer trigger.
type TimerTriggerUpdateParameters struct {
	// Schedule - The CRON expression for the task schedule
	Schedule *string `json:"schedule,omitempty"`
	// Status - The current status of trigger. Possible values include: 'TriggerStatusEnabled', 'TriggerStatusDisabled'
	Status TriggerStatus `json:"status,omitempty"`
	// Name - The name of the trigger.
	Name *string `json:"name,omitempty"`
}

// TLSCertificateProperties the TLS certificate properties of the connected registry login server.
type TLSCertificateProperties struct {
	// Type - READ-ONLY; The type of certificate location. Possible values include: 'LocalDirectory'
	Type CertificateType `json:"type,omitempty"`
	// Location - READ-ONLY; Indicates the location of the certificates.
	Location *string `json:"location,omitempty"`
}

// TLSProperties the TLS properties of the connected registry login server.
type TLSProperties struct {
	// Status - READ-ONLY; Indicates whether HTTPS is enabled for the login server. Possible values include: 'TLSStatusEnabled', 'TLSStatusDisabled'
	Status TLSStatus `json:"status,omitempty"`
	// Certificate - READ-ONLY; The certificate used to configure HTTPS for the login server.
	Certificate *TLSCertificateProperties `json:"certificate,omitempty"`
}

// Token an object that represents a token for a container registry.
type Token struct {
	autorest.Response `json:"-"`
	// TokenProperties - The properties of the token.
	*TokenProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Token.
func (t Token) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.TokenProperties != nil {
		objectMap["properties"] = t.TokenProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Token struct.
func (t *Token) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tokenProperties TokenProperties
				err = json.Unmarshal(*v, &tokenProperties)
				if err != nil {
					return err
				}
				t.TokenProperties = &tokenProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				t.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				t.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				t.Type = &typeVar
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				t.SystemData = &systemData
			}
		}
	}

	return nil
}

// TokenCertificate the properties of a certificate used for authenticating a token.
type TokenCertificate struct {
	// Name - Possible values include: 'Certificate1', 'Certificate2'
	Name TokenCertificateName `json:"name,omitempty"`
	// Expiry - The expiry datetime of the certificate.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Thumbprint - The thumbprint of the certificate.
	Thumbprint *string `json:"thumbprint,omitempty"`
	// EncodedPemCertificate - Base 64 encoded string of the public certificate1 in PEM format that will be used for authenticating the token.
	EncodedPemCertificate *string `json:"encodedPemCertificate,omitempty"`
}

// TokenCredentialsProperties the properties of the credentials that can be used for authenticating the
// token.
type TokenCredentialsProperties struct {
	Certificates *[]TokenCertificate `json:"certificates,omitempty"`
	Passwords    *[]TokenPassword    `json:"passwords,omitempty"`
}

// TokenListResult the result of a request to list tokens for a container registry.
type TokenListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of tokens. Since this list may be incomplete, the nextLink field should be used to request the next list of tokens.
	Value *[]Token `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of tokens.
	NextLink *string `json:"nextLink,omitempty"`
}

// TokenListResultIterator provides access to a complete listing of Token values.
type TokenListResultIterator struct {
	i    int
	page TokenListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TokenListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TokenListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TokenListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TokenListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TokenListResultIterator) Response() TokenListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TokenListResultIterator) Value() Token {
	if !iter.page.NotDone() {
		return Token{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TokenListResultIterator type.
func NewTokenListResultIterator(page TokenListResultPage) TokenListResultIterator {
	return TokenListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TokenListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TokenListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// tokenListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TokenListResult) tokenListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TokenListResultPage contains a page of Token values.
type TokenListResultPage struct {
	fn  func(context.Context, TokenListResult) (TokenListResult, error)
	tlr TokenListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TokenListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TokenListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TokenListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TokenListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TokenListResultPage) Response() TokenListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TokenListResultPage) Values() []Token {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TokenListResultPage type.
func NewTokenListResultPage(cur TokenListResult, getNextPage func(context.Context, TokenListResult) (TokenListResult, error)) TokenListResultPage {
	return TokenListResultPage{
		fn:  getNextPage,
		tlr: cur,
	}
}

// TokenPassword the password that will be used for authenticating the token of a container registry.
type TokenPassword struct {
	// CreationTime - The creation datetime of the password.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// Expiry - The expiry datetime of the password.
	Expiry *date.Time `json:"expiry,omitempty"`
	// Name - The password name "password1" or "password2". Possible values include: 'TokenPasswordNamePassword1', 'TokenPasswordNamePassword2'
	Name TokenPasswordName `json:"name,omitempty"`
	// Value - READ-ONLY; The password value.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for TokenPassword.
func (tp TokenPassword) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.CreationTime != nil {
		objectMap["creationTime"] = tp.CreationTime
	}
	if tp.Expiry != nil {
		objectMap["expiry"] = tp.Expiry
	}
	if tp.Name != "" {
		objectMap["name"] = tp.Name
	}
	return json.Marshal(objectMap)
}

// TokenProperties the properties of a token.
type TokenProperties struct {
	// CreationDate - READ-ONLY; The creation date of scope map.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state of the resource. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ScopeMapID - The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string `json:"scopeMapId,omitempty"`
	// Credentials - The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties `json:"credentials,omitempty"`
	// Status - The status of the token example enabled or disabled. Possible values include: 'TokenStatusEnabled', 'TokenStatusDisabled'
	Status TokenStatus `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for TokenProperties.
func (tp TokenProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tp.ScopeMapID != nil {
		objectMap["scopeMapId"] = tp.ScopeMapID
	}
	if tp.Credentials != nil {
		objectMap["credentials"] = tp.Credentials
	}
	if tp.Status != "" {
		objectMap["status"] = tp.Status
	}
	return json.Marshal(objectMap)
}

// TokensCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TokensCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TokensClient) (Token, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TokensCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TokensCreateFuture.Result.
func (future *TokensCreateFuture) result(client TokensClient) (t Token, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TokensCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TokensCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.CreateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TokensCreateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TokensDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TokensDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TokensClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TokensDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TokensDeleteFuture.Result.
func (future *TokensDeleteFuture) result(client TokensClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TokensDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TokensDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// TokensUpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type TokensUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(TokensClient) (Token, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *TokensUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for TokensUpdateFuture.Result.
func (future *TokensUpdateFuture) result(client TokensClient) (t Token, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.TokensUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.TokensUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if t.Response.Response, err = future.GetResult(sender); err == nil && t.Response.Response.StatusCode != http.StatusNoContent {
		t, err = client.UpdateResponder(t.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.TokensUpdateFuture", "Result", t.Response.Response, "Failure responding to request")
		}
	}
	return
}

// TokenUpdateParameters the parameters for updating a token.
type TokenUpdateParameters struct {
	// TokenUpdateProperties - The properties of the token update parameters.
	*TokenUpdateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TokenUpdateParameters.
func (tup TokenUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tup.TokenUpdateProperties != nil {
		objectMap["properties"] = tup.TokenUpdateProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for TokenUpdateParameters struct.
func (tup *TokenUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var tokenUpdateProperties TokenUpdateProperties
				err = json.Unmarshal(*v, &tokenUpdateProperties)
				if err != nil {
					return err
				}
				tup.TokenUpdateProperties = &tokenUpdateProperties
			}
		}
	}

	return nil
}

// TokenUpdateProperties the parameters for updating token properties.
type TokenUpdateProperties struct {
	// ScopeMapID - The resource ID of the scope map to which the token will be associated with.
	ScopeMapID *string `json:"scopeMapId,omitempty"`
	// Status - The status of the token example enabled or disabled. Possible values include: 'TokenStatusEnabled', 'TokenStatusDisabled'
	Status TokenStatus `json:"status,omitempty"`
	// Credentials - The credentials that can be used for authenticating the token.
	Credentials *TokenCredentialsProperties `json:"credentials,omitempty"`
}

// TriggerProperties the properties of a trigger.
type TriggerProperties struct {
	// TimerTriggers - The collection of timer triggers.
	TimerTriggers *[]TimerTrigger `json:"timerTriggers,omitempty"`
	// SourceTriggers - The collection of triggers based on source code repository.
	SourceTriggers *[]SourceTrigger `json:"sourceTriggers,omitempty"`
	// BaseImageTrigger - The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTrigger `json:"baseImageTrigger,omitempty"`
}

// TriggerUpdateParameters the properties for updating triggers.
type TriggerUpdateParameters struct {
	// TimerTriggers - The collection of timer triggers.
	TimerTriggers *[]TimerTriggerUpdateParameters `json:"timerTriggers,omitempty"`
	// SourceTriggers - The collection of triggers based on source code repository.
	SourceTriggers *[]SourceTriggerUpdateParameters `json:"sourceTriggers,omitempty"`
	// BaseImageTrigger - The trigger based on base image dependencies.
	BaseImageTrigger *BaseImageTriggerUpdateParameters `json:"baseImageTrigger,omitempty"`
}

// TrustPolicy the content trust policy for a container registry.
type TrustPolicy struct {
	// Type - The type of trust policy. Possible values include: 'Notary'
	Type TrustPolicyType `json:"type,omitempty"`
	// Status - The value that indicates whether the policy is enabled or not. Possible values include: 'PolicyStatusEnabled', 'PolicyStatusDisabled'
	Status PolicyStatus `json:"status,omitempty"`
}

// UserIdentityProperties ...
type UserIdentityProperties struct {
	// PrincipalID - The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// VirtualNetworkRule virtual network rule.
type VirtualNetworkRule struct {
	// Action - The action of virtual network rule. Possible values include: 'Allow'
	Action Action `json:"action,omitempty"`
	// VirtualNetworkResourceID - Resource ID of a subnet, for example: /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
	VirtualNetworkResourceID *string `json:"id,omitempty"`
}

// Webhook an object that represents a webhook for a container registry.
type Webhook struct {
	autorest.Response `json:"-"`
	// WebhookProperties - The properties of the webhook.
	*WebhookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WebhookProperties != nil {
		objectMap["properties"] = w.WebhookProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				w.SystemData = &systemData
			}
		}
	}

	return nil
}

// WebhookCreateParameters the parameters for creating a webhook.
type WebhookCreateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// Location - The location of the webhook. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// WebhookPropertiesCreateParameters - The properties that the webhook will be created with.
	*WebhookPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateParameters.
func (wcp WebhookCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.WebhookPropertiesCreateParameters != nil {
		objectMap["properties"] = wcp.WebhookPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateParameters struct.
func (wcp *WebhookCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wcp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wcp.Location = &location
			}
		case "properties":
			if v != nil {
				var webhookPropertiesCreateParameters WebhookPropertiesCreateParameters
				err = json.Unmarshal(*v, &webhookPropertiesCreateParameters)
				if err != nil {
					return err
				}
				wcp.WebhookPropertiesCreateParameters = &webhookPropertiesCreateParameters
			}
		}
	}

	return nil
}

// WebhookListResult the result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of webhooks.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebhookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebhookListResultIterator type.
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return WebhookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WebhookListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(context.Context, WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebhookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WebhookListResultPage type.
func NewWebhookListResultPage(cur WebhookListResult, getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return WebhookListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WebhookProperties the properties of a webhook.
type WebhookProperties struct {
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the webhook at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Status != "" {
		objectMap["status"] = wp.Status
	}
	if wp.Scope != nil {
		objectMap["scope"] = wp.Scope
	}
	if wp.Actions != nil {
		objectMap["actions"] = wp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesCreateParameters the parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesCreateParameters.
func (wpcp WebhookPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpcp.ServiceURI != nil {
		objectMap["serviceUri"] = wpcp.ServiceURI
	}
	if wpcp.CustomHeaders != nil {
		objectMap["customHeaders"] = wpcp.CustomHeaders
	}
	if wpcp.Status != "" {
		objectMap["status"] = wpcp.Status
	}
	if wpcp.Scope != nil {
		objectMap["scope"] = wpcp.Scope
	}
	if wpcp.Actions != nil {
		objectMap["actions"] = wpcp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesUpdateParameters the parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'WebhookStatusEnabled', 'WebhookStatusDisabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesUpdateParameters.
func (wpup WebhookPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpup.ServiceURI != nil {
		objectMap["serviceUri"] = wpup.ServiceURI
	}
	if wpup.CustomHeaders != nil {
		objectMap["customHeaders"] = wpup.CustomHeaders
	}
	if wpup.Status != "" {
		objectMap["status"] = wpup.Status
	}
	if wpup.Scope != nil {
		objectMap["scope"] = wpup.Scope
	}
	if wpup.Actions != nil {
		objectMap["actions"] = wpup.Actions
	}
	return json.Marshal(objectMap)
}

// WebhooksCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksCreateFuture.Result.
func (future *WebhooksCreateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhooksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksDeleteFuture.Result.
func (future *WebhooksDeleteFuture) result(client WebhooksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WebhooksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksUpdateFuture.Result.
func (future *WebhooksUpdateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhookUpdateParameters the parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// WebhookPropertiesUpdateParameters - The properties that the webhook will be updated with.
	*WebhookPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateParameters.
func (wup WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WebhookPropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WebhookPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var webhookPropertiesUpdateParameters WebhookPropertiesUpdateParameters
				err = json.Unmarshal(*v, &webhookPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WebhookPropertiesUpdateParameters = &webhookPropertiesUpdateParameters
			}
		}
	}

	return nil
}
