package managedapplications

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2016-09-01-preview/managedapplications"

// Appliance information about appliance.
type Appliance struct {
	autorest.Response `json:"-"`
	// ApplianceProperties - The appliance properties.
	*ApplianceProperties `json:"properties,omitempty"`
	// Plan - The plan information.
	Plan *Plan `json:"plan,omitempty"`
	// Kind - The kind of the appliance. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Appliance.
func (a Appliance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.ApplianceProperties != nil {
		objectMap["properties"] = a.ApplianceProperties
	}
	if a.Plan != nil {
		objectMap["plan"] = a.Plan
	}
	if a.Kind != nil {
		objectMap["kind"] = a.Kind
	}
	if a.ManagedBy != nil {
		objectMap["managedBy"] = a.ManagedBy
	}
	if a.Sku != nil {
		objectMap["sku"] = a.Sku
	}
	if a.Identity != nil {
		objectMap["identity"] = a.Identity
	}
	if a.Location != nil {
		objectMap["location"] = a.Location
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Appliance struct.
func (a *Appliance) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applianceProperties ApplianceProperties
				err = json.Unmarshal(*v, &applianceProperties)
				if err != nil {
					return err
				}
				a.ApplianceProperties = &applianceProperties
			}
		case "plan":
			if v != nil {
				var plan Plan
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				a.Plan = &plan
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				a.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				a.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				a.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				a.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				a.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				a.Tags = tags
			}
		}
	}

	return nil
}

// ApplianceArtifact appliance artifact.
type ApplianceArtifact struct {
	// Name - The appliance artifact name.
	Name *string `json:"name,omitempty"`
	// URI - The appliance artifact blob uri.
	URI *string `json:"uri,omitempty"`
	// Type - The appliance artifact type. Possible values include: 'Template', 'Custom'
	Type ApplianceArtifactType `json:"type,omitempty"`
}

// ApplianceDefinition information about appliance definition.
type ApplianceDefinition struct {
	autorest.Response `json:"-"`
	// ApplianceDefinitionProperties - The appliance definition properties.
	*ApplianceDefinitionProperties `json:"properties,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ApplianceDefinition.
func (ad ApplianceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ad.ApplianceDefinitionProperties != nil {
		objectMap["properties"] = ad.ApplianceDefinitionProperties
	}
	if ad.ManagedBy != nil {
		objectMap["managedBy"] = ad.ManagedBy
	}
	if ad.Sku != nil {
		objectMap["sku"] = ad.Sku
	}
	if ad.Identity != nil {
		objectMap["identity"] = ad.Identity
	}
	if ad.Location != nil {
		objectMap["location"] = ad.Location
	}
	if ad.Tags != nil {
		objectMap["tags"] = ad.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ApplianceDefinition struct.
func (ad *ApplianceDefinition) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var applianceDefinitionProperties ApplianceDefinitionProperties
				err = json.Unmarshal(*v, &applianceDefinitionProperties)
				if err != nil {
					return err
				}
				ad.ApplianceDefinitionProperties = &applianceDefinitionProperties
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				ad.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ad.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ad.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ad.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ad.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ad.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ad.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ad.Tags = tags
			}
		}
	}

	return nil
}

// ApplianceDefinitionListResult list of appliance definitions.
type ApplianceDefinitionListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of appliance definitions.
	Value *[]ApplianceDefinition `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplianceDefinitionListResultIterator provides access to a complete listing of ApplianceDefinition
// values.
type ApplianceDefinitionListResultIterator struct {
	i    int
	page ApplianceDefinitionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplianceDefinitionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceDefinitionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplianceDefinitionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplianceDefinitionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplianceDefinitionListResultIterator) Response() ApplianceDefinitionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplianceDefinitionListResultIterator) Value() ApplianceDefinition {
	if !iter.page.NotDone() {
		return ApplianceDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplianceDefinitionListResultIterator type.
func NewApplianceDefinitionListResultIterator(page ApplianceDefinitionListResultPage) ApplianceDefinitionListResultIterator {
	return ApplianceDefinitionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (adlr ApplianceDefinitionListResult) IsEmpty() bool {
	return adlr.Value == nil || len(*adlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (adlr ApplianceDefinitionListResult) hasNextLink() bool {
	return adlr.NextLink != nil && len(*adlr.NextLink) != 0
}

// applianceDefinitionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (adlr ApplianceDefinitionListResult) applianceDefinitionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !adlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(adlr.NextLink)))
}

// ApplianceDefinitionListResultPage contains a page of ApplianceDefinition values.
type ApplianceDefinitionListResultPage struct {
	fn   func(context.Context, ApplianceDefinitionListResult) (ApplianceDefinitionListResult, error)
	adlr ApplianceDefinitionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplianceDefinitionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceDefinitionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.adlr)
		if err != nil {
			return err
		}
		page.adlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplianceDefinitionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplianceDefinitionListResultPage) NotDone() bool {
	return !page.adlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplianceDefinitionListResultPage) Response() ApplianceDefinitionListResult {
	return page.adlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplianceDefinitionListResultPage) Values() []ApplianceDefinition {
	if page.adlr.IsEmpty() {
		return nil
	}
	return *page.adlr.Value
}

// Creates a new instance of the ApplianceDefinitionListResultPage type.
func NewApplianceDefinitionListResultPage(cur ApplianceDefinitionListResult, getNextPage func(context.Context, ApplianceDefinitionListResult) (ApplianceDefinitionListResult, error)) ApplianceDefinitionListResultPage {
	return ApplianceDefinitionListResultPage{
		fn:   getNextPage,
		adlr: cur,
	}
}

// ApplianceDefinitionProperties the appliance definition properties.
type ApplianceDefinitionProperties struct {
	// LockLevel - The appliance lock level. Possible values include: 'CanNotDelete', 'ReadOnly', 'None'
	LockLevel ApplianceLockLevel `json:"lockLevel,omitempty"`
	// DisplayName - The appliance definition display name.
	DisplayName *string `json:"displayName,omitempty"`
	// Authorizations - The appliance provider authorizations.
	Authorizations *[]ApplianceProviderAuthorization `json:"authorizations,omitempty"`
	// Artifacts - The collection of appliance artifacts. The portal will use the files specified as artifacts to construct the user experience of creating an appliance from an appliance definition.
	Artifacts *[]ApplianceArtifact `json:"artifacts,omitempty"`
	// Description - The appliance definition description.
	Description *string `json:"description,omitempty"`
	// PackageFileURI - The appliance definition package file Uri.
	PackageFileURI *string `json:"packageFileUri,omitempty"`
}

// ApplianceDefinitionsCreateOrUpdateByIDFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type ApplianceDefinitionsCreateOrUpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplianceDefinitionsClient) (ApplianceDefinition, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplianceDefinitionsCreateOrUpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplianceDefinitionsCreateOrUpdateByIDFuture.Result.
func (future *ApplianceDefinitionsCreateOrUpdateByIDFuture) result(client ApplianceDefinitionsClient) (ad ApplianceDefinition, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsCreateOrUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplianceDefinitionsCreateOrUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ad.Response.Response, err = future.GetResult(sender); err == nil && ad.Response.Response.StatusCode != http.StatusNoContent {
		ad, err = client.CreateOrUpdateByIDResponder(ad.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsCreateOrUpdateByIDFuture", "Result", ad.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplianceDefinitionsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplianceDefinitionsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplianceDefinitionsClient) (ApplianceDefinition, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplianceDefinitionsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplianceDefinitionsCreateOrUpdateFuture.Result.
func (future *ApplianceDefinitionsCreateOrUpdateFuture) result(client ApplianceDefinitionsClient) (ad ApplianceDefinition, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplianceDefinitionsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ad.Response.Response, err = future.GetResult(sender); err == nil && ad.Response.Response.StatusCode != http.StatusNoContent {
		ad, err = client.CreateOrUpdateResponder(ad.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsCreateOrUpdateFuture", "Result", ad.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ApplianceDefinitionsDeleteByIDFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplianceDefinitionsDeleteByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplianceDefinitionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplianceDefinitionsDeleteByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplianceDefinitionsDeleteByIDFuture.Result.
func (future *ApplianceDefinitionsDeleteByIDFuture) result(client ApplianceDefinitionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsDeleteByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplianceDefinitionsDeleteByIDFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplianceDefinitionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ApplianceDefinitionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ApplianceDefinitionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ApplianceDefinitionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ApplianceDefinitionsDeleteFuture.Result.
func (future *ApplianceDefinitionsDeleteFuture) result(client ApplianceDefinitionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.ApplianceDefinitionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.ApplianceDefinitionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ApplianceListResult list of appliances.
type ApplianceListResult struct {
	autorest.Response `json:"-"`
	// Value - The array of appliances.
	Value *[]Appliance `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplianceListResultIterator provides access to a complete listing of Appliance values.
type ApplianceListResultIterator struct {
	i    int
	page ApplianceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplianceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ApplianceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplianceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplianceListResultIterator) Response() ApplianceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplianceListResultIterator) Value() Appliance {
	if !iter.page.NotDone() {
		return Appliance{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ApplianceListResultIterator type.
func NewApplianceListResultIterator(page ApplianceListResultPage) ApplianceListResultIterator {
	return ApplianceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplianceListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (alr ApplianceListResult) hasNextLink() bool {
	return alr.NextLink != nil && len(*alr.NextLink) != 0
}

// applianceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplianceListResult) applianceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !alr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplianceListResultPage contains a page of Appliance values.
type ApplianceListResultPage struct {
	fn  func(context.Context, ApplianceListResult) (ApplianceListResult, error)
	alr ApplianceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplianceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ApplianceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.alr)
		if err != nil {
			return err
		}
		page.alr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ApplianceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplianceListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplianceListResultPage) Response() ApplianceListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplianceListResultPage) Values() []Appliance {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// Creates a new instance of the ApplianceListResultPage type.
func NewApplianceListResultPage(cur ApplianceListResult, getNextPage func(context.Context, ApplianceListResult) (ApplianceListResult, error)) ApplianceListResultPage {
	return ApplianceListResultPage{
		fn:  getNextPage,
		alr: cur,
	}
}

// AppliancePatchable information about appliance.
type AppliancePatchable struct {
	// AppliancePropertiesPatchable - The appliance properties.
	*AppliancePropertiesPatchable `json:"properties,omitempty"`
	// Plan - The plan information.
	Plan *PlanPatchable `json:"plan,omitempty"`
	// Kind - The kind of the appliance. Allowed values are MarketPlace and ServiceCatalog.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for AppliancePatchable.
func (ap AppliancePatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.AppliancePropertiesPatchable != nil {
		objectMap["properties"] = ap.AppliancePropertiesPatchable
	}
	if ap.Plan != nil {
		objectMap["plan"] = ap.Plan
	}
	if ap.Kind != nil {
		objectMap["kind"] = ap.Kind
	}
	if ap.ManagedBy != nil {
		objectMap["managedBy"] = ap.ManagedBy
	}
	if ap.Sku != nil {
		objectMap["sku"] = ap.Sku
	}
	if ap.Identity != nil {
		objectMap["identity"] = ap.Identity
	}
	if ap.Location != nil {
		objectMap["location"] = ap.Location
	}
	if ap.Tags != nil {
		objectMap["tags"] = ap.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for AppliancePatchable struct.
func (ap *AppliancePatchable) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var appliancePropertiesPatchable AppliancePropertiesPatchable
				err = json.Unmarshal(*v, &appliancePropertiesPatchable)
				if err != nil {
					return err
				}
				ap.AppliancePropertiesPatchable = &appliancePropertiesPatchable
			}
		case "plan":
			if v != nil {
				var plan PlanPatchable
				err = json.Unmarshal(*v, &plan)
				if err != nil {
					return err
				}
				ap.Plan = &plan
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				ap.Kind = &kind
			}
		case "managedBy":
			if v != nil {
				var managedBy string
				err = json.Unmarshal(*v, &managedBy)
				if err != nil {
					return err
				}
				ap.ManagedBy = &managedBy
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				ap.Sku = &sku
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				ap.Identity = &identity
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ap.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ap.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ap.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ap.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ap.Tags = tags
			}
		}
	}

	return nil
}

// ApplianceProperties the appliance properties.
type ApplianceProperties struct {
	// ManagedResourceGroupID - The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`
	// ApplianceDefinitionID - The fully qualified path of appliance definition Id.
	ApplianceDefinitionID *string `json:"applianceDefinitionId,omitempty"`
	// Parameters - Name and value pairs that define the appliance parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// Outputs - READ-ONLY; Name and value pairs that define the appliance outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// ProvisioningState - READ-ONLY; The appliance provisioning state. Possible values include: 'Accepted', 'Running', 'Ready', 'Creating', 'Created', 'Deleting', 'Deleted', 'Canceled', 'Failed', 'Succeeded', 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// UIDefinitionURI - The blob URI where the UI definition file is located.
	UIDefinitionURI *string `json:"uiDefinitionUri,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplianceProperties.
func (ap ApplianceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.ManagedResourceGroupID != nil {
		objectMap["managedResourceGroupId"] = ap.ManagedResourceGroupID
	}
	if ap.ApplianceDefinitionID != nil {
		objectMap["applianceDefinitionId"] = ap.ApplianceDefinitionID
	}
	if ap.Parameters != nil {
		objectMap["parameters"] = ap.Parameters
	}
	if ap.UIDefinitionURI != nil {
		objectMap["uiDefinitionUri"] = ap.UIDefinitionURI
	}
	return json.Marshal(objectMap)
}

// AppliancePropertiesPatchable the appliance properties.
type AppliancePropertiesPatchable struct {
	// ManagedResourceGroupID - The managed resource group Id.
	ManagedResourceGroupID *string `json:"managedResourceGroupId,omitempty"`
	// ApplianceDefinitionID - The fully qualified path of appliance definition Id.
	ApplianceDefinitionID *string `json:"applianceDefinitionId,omitempty"`
	// Parameters - Name and value pairs that define the appliance parameters. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// Outputs - READ-ONLY; Name and value pairs that define the appliance outputs.
	Outputs interface{} `json:"outputs,omitempty"`
	// ProvisioningState - READ-ONLY; The appliance provisioning state. Possible values include: 'Accepted', 'Running', 'Ready', 'Creating', 'Created', 'Deleting', 'Deleted', 'Canceled', 'Failed', 'Succeeded', 'Updating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// UIDefinitionURI - The blob URI where the UI definition file is located.
	UIDefinitionURI *string `json:"uiDefinitionUri,omitempty"`
}

// MarshalJSON is the custom marshaler for AppliancePropertiesPatchable.
func (app AppliancePropertiesPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if app.ManagedResourceGroupID != nil {
		objectMap["managedResourceGroupId"] = app.ManagedResourceGroupID
	}
	if app.ApplianceDefinitionID != nil {
		objectMap["applianceDefinitionId"] = app.ApplianceDefinitionID
	}
	if app.Parameters != nil {
		objectMap["parameters"] = app.Parameters
	}
	if app.UIDefinitionURI != nil {
		objectMap["uiDefinitionUri"] = app.UIDefinitionURI
	}
	return json.Marshal(objectMap)
}

// ApplianceProviderAuthorization the appliance provider authorization.
type ApplianceProviderAuthorization struct {
	// PrincipalID - The provider's principal identifier. This is the identity that the provider will use to call ARM to manage the appliance resources.
	PrincipalID *string `json:"principalId,omitempty"`
	// RoleDefinitionID - The provider's role definition identifier. This role will define all the permissions that the provider must have on the appliance's container resource group. This role definition cannot have permission to delete the resource group.
	RoleDefinitionID *string `json:"roleDefinitionId,omitempty"`
}

// AppliancesCreateOrUpdateByIDFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppliancesCreateOrUpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (Appliance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesCreateOrUpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesCreateOrUpdateByIDFuture.Result.
func (future *AppliancesCreateOrUpdateByIDFuture) result(client AppliancesClient) (a Appliance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.AppliancesCreateOrUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.AppliancesCreateOrUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateByIDResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.AppliancesCreateOrUpdateByIDFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppliancesCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type AppliancesCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (Appliance, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesCreateOrUpdateFuture.Result.
func (future *AppliancesCreateOrUpdateFuture) result(client AppliancesClient) (a Appliance, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.AppliancesCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.AppliancesCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if a.Response.Response, err = future.GetResult(sender); err == nil && a.Response.Response.StatusCode != http.StatusNoContent {
		a, err = client.CreateOrUpdateResponder(a.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "managedapplications.AppliancesCreateOrUpdateFuture", "Result", a.Response.Response, "Failure responding to request")
		}
	}
	return
}

// AppliancesDeleteByIDFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppliancesDeleteByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesDeleteByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesDeleteByIDFuture.Result.
func (future *AppliancesDeleteByIDFuture) result(client AppliancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.AppliancesDeleteByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.AppliancesDeleteByIDFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// AppliancesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type AppliancesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(AppliancesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *AppliancesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for AppliancesDeleteFuture.Result.
func (future *AppliancesDeleteFuture) result(client AppliancesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "managedapplications.AppliancesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("managedapplications.AppliancesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorResponse error response indicates ARM appliance is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// HTTPStatus - Http status code.
	HTTPStatus *string `json:"httpStatus,omitempty"`
	// ErrorCode - Error code.
	ErrorCode *string `json:"errorCode,omitempty"`
	// ErrorMessage - Error message indicating why the operation failed.
	ErrorMessage *string `json:"errorMessage,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.ManagedBy != nil {
		objectMap["managedBy"] = gr.ManagedBy
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.Identity != nil {
		objectMap["identity"] = gr.Identity
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// Operation microsoft.Solutions operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Solutions
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list Microsoft.Solutions operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Microsoft.Solutions operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Plan plan for the appliance.
type Plan struct {
	// Name - The plan name.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product code.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// PlanPatchable plan for the appliance.
type PlanPatchable struct {
	// Name - The plan name.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The product code.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// Resource resource information.
type Resource struct {
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku SKU for the resource.
type Sku struct {
	// Name - The SKU name.
	Name *string `json:"name,omitempty"`
	// Tier - The SKU tier.
	Tier *string `json:"tier,omitempty"`
	// Size - The SKU size.
	Size *string `json:"size,omitempty"`
	// Family - The SKU family.
	Family *string `json:"family,omitempty"`
	// Model - The SKU model.
	Model *string `json:"model,omitempty"`
	// Capacity - The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}
