package resourcemover

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resourcemover/mgmt/2021-01-01/resourcemover"

// AffectedMoveResource the RP custom operation error info.
type AffectedMoveResource struct {
	// ID - READ-ONLY; The affected move resource id.
	ID *string `json:"id,omitempty"`
	// SourceID - READ-ONLY; The affected move resource source id.
	SourceID *string `json:"sourceId,omitempty"`
	// MoveResources - READ-ONLY; The affected move resources.
	MoveResources *[]AffectedMoveResource `json:"moveResources,omitempty"`
}

// AutomaticResolutionProperties defines the properties for automatic resolution.
type AutomaticResolutionProperties struct {
	// MoveResourceID - Gets the MoveResource ARM ID of
	// the dependent resource if the resolution type is Automatic.
	MoveResourceID *string `json:"moveResourceId,omitempty"`
}

// AvailabilitySetResourceSettings gets or sets the availability set resource settings.
type AvailabilitySetResourceSettings struct {
	// FaultDomain - Gets or sets the target fault domain.
	FaultDomain *int32 `json:"faultDomain,omitempty"`
	// UpdateDomain - Gets or sets the target update domain.
	UpdateDomain *int32 `json:"updateDomain,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) MarshalJSON() ([]byte, error) {
	asrs.ResourceType = ResourceTypeMicrosoftComputeavailabilitySets
	objectMap := make(map[string]interface{})
	if asrs.FaultDomain != nil {
		objectMap["faultDomain"] = asrs.FaultDomain
	}
	if asrs.UpdateDomain != nil {
		objectMap["updateDomain"] = asrs.UpdateDomain
	}
	if asrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = asrs.TargetResourceName
	}
	if asrs.ResourceType != "" {
		objectMap["resourceType"] = asrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return &asrs, true
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for AvailabilitySetResourceSettings.
func (asrs AvailabilitySetResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &asrs, true
}

// AzureResourceReference defines reference to an Azure resource.
type AzureResourceReference struct {
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// BulkRemoveRequest defines the request body for bulk remove of move resources operation.
type BulkRemoveRequest struct {
	// ValidateOnly - Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
	// MoveResources - Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via moveResourceInputType property.
	MoveResources *[]string `json:"moveResources,omitempty"`
	// MoveResourceInputType - Possible values include: 'MoveResourceID', 'MoveResourceSourceID'
	MoveResourceInputType MoveResourceInputType `json:"moveResourceInputType,omitempty"`
}

// CloudError an error response from the service.
type CloudError struct {
	// Error - Cloud error body.
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from the service.
type CloudErrorBody struct {
	// Code - An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - A list of additional details about the error.
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CommitRequest defines the request body for commit operation.
type CommitRequest struct {
	// ValidateOnly - Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
	// MoveResources - Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via moveResourceInputType property.
	MoveResources *[]string `json:"moveResources,omitempty"`
	// MoveResourceInputType - Possible values include: 'MoveResourceID', 'MoveResourceSourceID'
	MoveResourceInputType MoveResourceInputType `json:"moveResourceInputType,omitempty"`
}

// DiscardRequest defines the request body for discard operation.
type DiscardRequest struct {
	// ValidateOnly - Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
	// MoveResources - Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via moveResourceInputType property.
	MoveResources *[]string `json:"moveResources,omitempty"`
	// MoveResourceInputType - Possible values include: 'MoveResourceID', 'MoveResourceSourceID'
	MoveResourceInputType MoveResourceInputType `json:"moveResourceInputType,omitempty"`
}

// DiskEncryptionSetResourceSettings defines the disk encryption set resource settings.
type DiskEncryptionSetResourceSettings struct {
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) MarshalJSON() ([]byte, error) {
	desrs.ResourceType = ResourceTypeMicrosoftComputediskEncryptionSets
	objectMap := make(map[string]interface{})
	if desrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = desrs.TargetResourceName
	}
	if desrs.ResourceType != "" {
		objectMap["resourceType"] = desrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return &desrs, true
}

// AsResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for DiskEncryptionSetResourceSettings.
func (desrs DiskEncryptionSetResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &desrs, true
}

// Display contains the localized display information for this particular operation / action. These
// value will be used by several clients for
// (1) custom role definitions for RBAC;
// (2) complex query filters for the event service; and
// (3) audit history / records for management operations.
type Display struct {
	// Provider - Gets or sets the provider.
	// The localized friendly form of the resource provider name – it is expected to also
	// include the publisher/company responsible.
	// It should use Title Casing and begin with "Microsoft" for 1st party services.
	// e.g. "Microsoft Monitoring Insights" or "Microsoft Compute.".
	Provider *string `json:"provider,omitempty"`
	// Resource - Gets or sets the resource.
	// The localized friendly form of the resource related to this action/operation – it
	// should match the public documentation for the resource provider.
	// It should use Title Casing.
	// This value should be unique for a particular URL type (e.g. nested types should *not*
	// reuse their parent’s display.resource field)
	// e.g. "Virtual Machines" or "Scheduler Job Collections", or "Virtual Machine VM Sizes"
	// or "Scheduler Jobs".
	Resource *string `json:"resource,omitempty"`
	// Operation - Gets or sets the operation.
	// The localized friendly name for the operation, as it should be shown to the user.
	// It should be concise (to fit in drop downs) but clear (i.e. self-documenting).
	// It should use Title Casing.
	// Prescriptive guidance: Read Create or Update Delete 'ActionName'.
	Operation *string `json:"operation,omitempty"`
	// Description - Gets or sets the description.
	// The localized friendly description for the operation, as it should be shown to the
	// user.
	// It should be thorough, yet concise – it will be used in tool tips and detailed views.
	// Prescriptive guidance for namespace:
	// Read any 'display.provider'  resource
	// Create or Update any  'display.provider'  resource
	// Delete any  'display.provider'  resource
	// Perform any other action on any  'display.provider'  resource
	// Prescriptive guidance for namespace:
	// Read any 'display.resource' Create or Update any  'display.resource' Delete any
	//  'display.resource' 'ActionName' any 'display.resources'.
	Description *string `json:"description,omitempty"`
}

// Identity defines the MSI properties of the Move Collection.
type Identity struct {
	// Type - Possible values include: 'None', 'SystemAssigned', 'UserAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
	// PrincipalID - Gets or sets the principal id.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - Gets or sets the tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// JobStatus defines the job status.
type JobStatus struct {
	// JobName - Possible values include: 'InitialSync'
	JobName JobName `json:"jobName,omitempty"`
	// JobProgress - READ-ONLY; Gets or sets the monitoring job percentage.
	JobProgress *string `json:"jobProgress,omitempty"`
}

// MarshalJSON is the custom marshaler for JobStatus.
func (js JobStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if js.JobName != "" {
		objectMap["jobName"] = js.JobName
	}
	return json.Marshal(objectMap)
}

// KeyVaultResourceSettings defines the key vault resource settings.
type KeyVaultResourceSettings struct {
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) MarshalJSON() ([]byte, error) {
	kvrs.ResourceType = ResourceTypeMicrosoftKeyVaultvaults
	objectMap := make(map[string]interface{})
	if kvrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = kvrs.TargetResourceName
	}
	if kvrs.ResourceType != "" {
		objectMap["resourceType"] = kvrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return &kvrs, true
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for KeyVaultResourceSettings.
func (kvrs KeyVaultResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &kvrs, true
}

// LBBackendAddressPoolResourceSettings defines load balancer backend address pool properties.
type LBBackendAddressPoolResourceSettings struct {
	// Name - Gets or sets the backend address pool name.
	Name *string `json:"name,omitempty"`
}

// LBFrontendIPConfigurationResourceSettings defines load balancer frontend IP configuration properties.
type LBFrontendIPConfigurationResourceSettings struct {
	// Name - Gets or sets the frontend IP configuration name.
	Name *string `json:"name,omitempty"`
	// PrivateIPAddress - Gets or sets the IP address of the Load Balancer.This is only specified if a specific
	// private IP address shall be allocated from the subnet specified in subnetRef.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets PrivateIP allocation method (Static/Dynamic).
	PrivateIPAllocationMethod *string          `json:"privateIpAllocationMethod,omitempty"`
	Subnet                    *SubnetReference `json:"subnet,omitempty"`
	// Zones - Gets or sets the csv list of zones.
	Zones *string `json:"zones,omitempty"`
}

// LoadBalancerBackendAddressPoolReference defines reference to load balancer backend address pools.
type LoadBalancerBackendAddressPoolReference struct {
	// Name - Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// LoadBalancerNatRuleReference defines reference to load balancer NAT rules.
type LoadBalancerNatRuleReference struct {
	// Name - Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// LoadBalancerResourceSettings defines the load balancer resource settings.
type LoadBalancerResourceSettings struct {
	// Sku - Gets or sets load balancer sku (Basic/Standard).
	Sku *string `json:"sku,omitempty"`
	// FrontendIPConfigurations - Gets or sets the frontend IP configurations of the load balancer.
	FrontendIPConfigurations *[]LBFrontendIPConfigurationResourceSettings `json:"frontendIPConfigurations,omitempty"`
	// BackendAddressPools - Gets or sets the backend address pools of the load balancer.
	BackendAddressPools *[]LBBackendAddressPoolResourceSettings `json:"backendAddressPools,omitempty"`
	// Zones - Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
	//  precedence only if frontend IP configurations settings are not present.
	Zones *string `json:"zones,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) MarshalJSON() ([]byte, error) {
	lbrs.ResourceType = ResourceTypeMicrosoftNetworkloadBalancers
	objectMap := make(map[string]interface{})
	if lbrs.Sku != nil {
		objectMap["sku"] = lbrs.Sku
	}
	if lbrs.FrontendIPConfigurations != nil {
		objectMap["frontendIPConfigurations"] = lbrs.FrontendIPConfigurations
	}
	if lbrs.BackendAddressPools != nil {
		objectMap["backendAddressPools"] = lbrs.BackendAddressPools
	}
	if lbrs.Zones != nil {
		objectMap["zones"] = lbrs.Zones
	}
	if lbrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = lbrs.TargetResourceName
	}
	if lbrs.ResourceType != "" {
		objectMap["resourceType"] = lbrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return &lbrs, true
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for LoadBalancerResourceSettings.
func (lbrs LoadBalancerResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &lbrs, true
}

// ManualResolutionProperties defines the properties for manual resolution.
type ManualResolutionProperties struct {
	// TargetID - Gets or sets the target resource ARM ID of the dependent resource if the resource type is Manual.
	TargetID *string `json:"targetId,omitempty"`
}

// MoveCollection define the move collection.
type MoveCollection struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Etag - READ-ONLY; The etag of the resource.
	Etag *string `json:"etag,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives.
	Location   *string                   `json:"location,omitempty"`
	Identity   *Identity                 `json:"identity,omitempty"`
	Properties *MoveCollectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MoveCollection.
func (mc MoveCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mc.Tags != nil {
		objectMap["tags"] = mc.Tags
	}
	if mc.Location != nil {
		objectMap["location"] = mc.Location
	}
	if mc.Identity != nil {
		objectMap["identity"] = mc.Identity
	}
	if mc.Properties != nil {
		objectMap["properties"] = mc.Properties
	}
	return json.Marshal(objectMap)
}

// MoveCollectionProperties defines the move collection properties.
type MoveCollectionProperties struct {
	// SourceRegion - Gets or sets the source region.
	SourceRegion *string `json:"sourceRegion,omitempty"`
	// TargetRegion - Gets or sets the target region.
	TargetRegion *string `json:"targetRegion,omitempty"`
	// ProvisioningState - Possible values include: 'Succeeded', 'Updating', 'Creating', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Errors - READ-ONLY; Defines the move collection errors.
	Errors *MoveCollectionPropertiesErrors `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for MoveCollectionProperties.
func (mcp MoveCollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mcp.SourceRegion != nil {
		objectMap["sourceRegion"] = mcp.SourceRegion
	}
	if mcp.TargetRegion != nil {
		objectMap["targetRegion"] = mcp.TargetRegion
	}
	if mcp.ProvisioningState != "" {
		objectMap["provisioningState"] = mcp.ProvisioningState
	}
	return json.Marshal(objectMap)
}

// MoveCollectionPropertiesErrors defines the move collection errors.
type MoveCollectionPropertiesErrors struct {
	// Properties - The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveCollectionResultList defines the collection of move collections.
type MoveCollectionResultList struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of move collections.
	Value *[]MoveCollection `json:"value,omitempty"`
	// NextLink - Gets the value of  next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// MoveCollectionResultListIterator provides access to a complete listing of MoveCollection values.
type MoveCollectionResultListIterator struct {
	i    int
	page MoveCollectionResultListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MoveCollectionResultListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionResultListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MoveCollectionResultListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MoveCollectionResultListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MoveCollectionResultListIterator) Response() MoveCollectionResultList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MoveCollectionResultListIterator) Value() MoveCollection {
	if !iter.page.NotDone() {
		return MoveCollection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MoveCollectionResultListIterator type.
func NewMoveCollectionResultListIterator(page MoveCollectionResultListPage) MoveCollectionResultListIterator {
	return MoveCollectionResultListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mcrl MoveCollectionResultList) IsEmpty() bool {
	return mcrl.Value == nil || len(*mcrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mcrl MoveCollectionResultList) hasNextLink() bool {
	return mcrl.NextLink != nil && len(*mcrl.NextLink) != 0
}

// moveCollectionResultListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mcrl MoveCollectionResultList) moveCollectionResultListPreparer(ctx context.Context) (*http.Request, error) {
	if !mcrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mcrl.NextLink)))
}

// MoveCollectionResultListPage contains a page of MoveCollection values.
type MoveCollectionResultListPage struct {
	fn   func(context.Context, MoveCollectionResultList) (MoveCollectionResultList, error)
	mcrl MoveCollectionResultList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MoveCollectionResultListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveCollectionResultListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mcrl)
		if err != nil {
			return err
		}
		page.mcrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MoveCollectionResultListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MoveCollectionResultListPage) NotDone() bool {
	return !page.mcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MoveCollectionResultListPage) Response() MoveCollectionResultList {
	return page.mcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MoveCollectionResultListPage) Values() []MoveCollection {
	if page.mcrl.IsEmpty() {
		return nil
	}
	return *page.mcrl.Value
}

// Creates a new instance of the MoveCollectionResultListPage type.
func NewMoveCollectionResultListPage(cur MoveCollectionResultList, getNextPage func(context.Context, MoveCollectionResultList) (MoveCollectionResultList, error)) MoveCollectionResultListPage {
	return MoveCollectionResultListPage{
		fn:   getNextPage,
		mcrl: cur,
	}
}

// MoveCollectionsBulkRemoveFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MoveCollectionsBulkRemoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsBulkRemoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsBulkRemoveFuture.Result.
func (future *MoveCollectionsBulkRemoveFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsBulkRemoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsBulkRemoveFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.BulkRemoveResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsBulkRemoveFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsCommitFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveCollectionsCommitFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsCommitFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsCommitFuture.Result.
func (future *MoveCollectionsCommitFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsCommitFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsCommitFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.CommitResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsCommitFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveCollectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsDeleteFuture.Result.
func (future *MoveCollectionsDeleteFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.DeleteResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsDeleteFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsDiscardFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveCollectionsDiscardFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsDiscardFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsDiscardFuture.Result.
func (future *MoveCollectionsDiscardFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsDiscardFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsDiscardFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.DiscardResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsDiscardFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsInitiateMoveFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MoveCollectionsInitiateMoveFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsInitiateMoveFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsInitiateMoveFuture.Result.
func (future *MoveCollectionsInitiateMoveFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsInitiateMoveFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsInitiateMoveFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.InitiateMoveResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsInitiateMoveFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsPrepareFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveCollectionsPrepareFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsPrepareFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsPrepareFuture.Result.
func (future *MoveCollectionsPrepareFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsPrepareFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsPrepareFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.PrepareResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsPrepareFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveCollectionsResolveDependenciesFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MoveCollectionsResolveDependenciesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveCollectionsClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveCollectionsResolveDependenciesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveCollectionsResolveDependenciesFuture.Result.
func (future *MoveCollectionsResolveDependenciesFuture) result(client MoveCollectionsClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsResolveDependenciesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveCollectionsResolveDependenciesFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.ResolveDependenciesResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveCollectionsResolveDependenciesFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveErrorInfo the move custom error info.
type MoveErrorInfo struct {
	// MoveResources - READ-ONLY; The affected move resources.
	MoveResources *[]AffectedMoveResource `json:"moveResources,omitempty"`
}

// MoveResource defines the move resource.
type MoveResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type       *string                 `json:"type,omitempty"`
	Properties *MoveResourceProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MoveResource.
func (mr MoveResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mr.Properties != nil {
		objectMap["properties"] = mr.Properties
	}
	return json.Marshal(objectMap)
}

// MoveResourceCollection defines the collection of move resources.
type MoveResourceCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets the list of move resources.
	Value *[]MoveResource `json:"value,omitempty"`
	// NextLink - Gets the value of  next link.
	NextLink *string `json:"nextLink,omitempty"`
	// SummaryCollection - Gets or sets the list of summary items and the field on which summary is done.
	SummaryCollection *SummaryCollection `json:"summaryCollection,omitempty"`
	// TotalCount - READ-ONLY; Gets the total count.
	TotalCount *int64 `json:"totalCount,omitempty"`
}

// MarshalJSON is the custom marshaler for MoveResourceCollection.
func (mrc MoveResourceCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrc.Value != nil {
		objectMap["value"] = mrc.Value
	}
	if mrc.NextLink != nil {
		objectMap["nextLink"] = mrc.NextLink
	}
	if mrc.SummaryCollection != nil {
		objectMap["summaryCollection"] = mrc.SummaryCollection
	}
	return json.Marshal(objectMap)
}

// MoveResourceCollectionIterator provides access to a complete listing of MoveResource values.
type MoveResourceCollectionIterator struct {
	i    int
	page MoveResourceCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MoveResourceCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveResourceCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MoveResourceCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MoveResourceCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MoveResourceCollectionIterator) Response() MoveResourceCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MoveResourceCollectionIterator) Value() MoveResource {
	if !iter.page.NotDone() {
		return MoveResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MoveResourceCollectionIterator type.
func NewMoveResourceCollectionIterator(page MoveResourceCollectionPage) MoveResourceCollectionIterator {
	return MoveResourceCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mrc MoveResourceCollection) IsEmpty() bool {
	return mrc.Value == nil || len(*mrc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mrc MoveResourceCollection) hasNextLink() bool {
	return mrc.NextLink != nil && len(*mrc.NextLink) != 0
}

// moveResourceCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mrc MoveResourceCollection) moveResourceCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !mrc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mrc.NextLink)))
}

// MoveResourceCollectionPage contains a page of MoveResource values.
type MoveResourceCollectionPage struct {
	fn  func(context.Context, MoveResourceCollection) (MoveResourceCollection, error)
	mrc MoveResourceCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MoveResourceCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MoveResourceCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mrc)
		if err != nil {
			return err
		}
		page.mrc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MoveResourceCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MoveResourceCollectionPage) NotDone() bool {
	return !page.mrc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MoveResourceCollectionPage) Response() MoveResourceCollection {
	return page.mrc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MoveResourceCollectionPage) Values() []MoveResource {
	if page.mrc.IsEmpty() {
		return nil
	}
	return *page.mrc.Value
}

// Creates a new instance of the MoveResourceCollectionPage type.
func NewMoveResourceCollectionPage(cur MoveResourceCollection, getNextPage func(context.Context, MoveResourceCollection) (MoveResourceCollection, error)) MoveResourceCollectionPage {
	return MoveResourceCollectionPage{
		fn:  getNextPage,
		mrc: cur,
	}
}

// MoveResourceDependency defines the dependency of the move resource.
type MoveResourceDependency struct {
	// ID - Gets the source ARM ID of the dependent resource.
	ID *string `json:"id,omitempty"`
	// ResolutionStatus - Gets the dependency resolution status.
	ResolutionStatus *string `json:"resolutionStatus,omitempty"`
	// ResolutionType - Possible values include: 'Manual', 'Automatic'
	ResolutionType ResolutionType `json:"resolutionType,omitempty"`
	// DependencyType - Possible values include: 'RequiredForPrepare', 'RequiredForMove'
	DependencyType      DependencyType                 `json:"dependencyType,omitempty"`
	ManualResolution    *ManualResolutionProperties    `json:"manualResolution,omitempty"`
	AutomaticResolution *AutomaticResolutionProperties `json:"automaticResolution,omitempty"`
	// IsOptional - Gets or sets a value indicating whether the dependency is optional.
	IsOptional *string `json:"isOptional,omitempty"`
}

// MoveResourceDependencyOverride defines the dependency override of the move resource.
type MoveResourceDependencyOverride struct {
	// ID - Gets or sets the ARM ID of the dependent resource.
	ID *string `json:"id,omitempty"`
	// TargetID - Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
	// the dependent resource.
	TargetID *string `json:"targetId,omitempty"`
}

// MoveResourceError an error response from the azure resource mover service.
type MoveResourceError struct {
	// Properties - The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveResourceErrorBody an error response from the Azure Migrate service.
type MoveResourceErrorBody struct {
	// Code - READ-ONLY; An identifier for the error. Codes are invariant and are intended to be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; A message describing the error, intended to be suitable for display in a user interface.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error. For example, the name of the property in error.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; A list of additional details about the error.
	Details *[]MoveResourceErrorBody `json:"details,omitempty"`
}

// MoveResourceFilter move resource filter.
type MoveResourceFilter struct {
	Properties *MoveResourceFilterProperties `json:"properties,omitempty"`
}

// MoveResourceFilterProperties ...
type MoveResourceFilterProperties struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MoveResourceProperties defines the move resource properties.
type MoveResourceProperties struct {
	// ProvisioningState - Possible values include: 'Succeeded', 'Updating', 'Creating', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// SourceID - Gets or sets the Source ARM Id of the resource.
	SourceID *string `json:"sourceId,omitempty"`
	// TargetID - READ-ONLY; Gets or sets the Target ARM Id of the resource.
	TargetID *string `json:"targetId,omitempty"`
	// ExistingTargetID - Gets or sets the existing target ARM Id of the resource.
	ExistingTargetID *string `json:"existingTargetId,omitempty"`
	// ResourceSettings - Gets or sets the resource settings.
	ResourceSettings BasicResourceSettings `json:"resourceSettings,omitempty"`
	// SourceResourceSettings - READ-ONLY; Gets or sets the source resource settings.
	SourceResourceSettings BasicResourceSettings `json:"sourceResourceSettings,omitempty"`
	// MoveStatus - READ-ONLY; Defines the move resource status.
	MoveStatus *MoveResourcePropertiesMoveStatus `json:"moveStatus,omitempty"`
	// DependsOn - READ-ONLY; Gets or sets the move resource dependencies.
	DependsOn *[]MoveResourceDependency `json:"dependsOn,omitempty"`
	// DependsOnOverrides - Gets or sets the move resource dependencies overrides.
	DependsOnOverrides *[]MoveResourceDependencyOverride `json:"dependsOnOverrides,omitempty"`
	// IsResolveRequired - READ-ONLY; Gets a value indicating whether the resolve action is required over the move collection.
	IsResolveRequired *bool `json:"isResolveRequired,omitempty"`
	// Errors - READ-ONLY; Defines the move resource errors.
	Errors *MoveResourcePropertiesErrors `json:"errors,omitempty"`
}

// MarshalJSON is the custom marshaler for MoveResourceProperties.
func (mrp MoveResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mrp.ProvisioningState != "" {
		objectMap["provisioningState"] = mrp.ProvisioningState
	}
	if mrp.SourceID != nil {
		objectMap["sourceId"] = mrp.SourceID
	}
	if mrp.ExistingTargetID != nil {
		objectMap["existingTargetId"] = mrp.ExistingTargetID
	}
	objectMap["resourceSettings"] = mrp.ResourceSettings
	if mrp.DependsOnOverrides != nil {
		objectMap["dependsOnOverrides"] = mrp.DependsOnOverrides
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MoveResourceProperties struct.
func (mrp *MoveResourceProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				mrp.ProvisioningState = provisioningState
			}
		case "sourceId":
			if v != nil {
				var sourceID string
				err = json.Unmarshal(*v, &sourceID)
				if err != nil {
					return err
				}
				mrp.SourceID = &sourceID
			}
		case "targetId":
			if v != nil {
				var targetID string
				err = json.Unmarshal(*v, &targetID)
				if err != nil {
					return err
				}
				mrp.TargetID = &targetID
			}
		case "existingTargetId":
			if v != nil {
				var existingTargetID string
				err = json.Unmarshal(*v, &existingTargetID)
				if err != nil {
					return err
				}
				mrp.ExistingTargetID = &existingTargetID
			}
		case "resourceSettings":
			if v != nil {
				resourceSettings, err := unmarshalBasicResourceSettings(*v)
				if err != nil {
					return err
				}
				mrp.ResourceSettings = resourceSettings
			}
		case "sourceResourceSettings":
			if v != nil {
				sourceResourceSettings, err := unmarshalBasicResourceSettings(*v)
				if err != nil {
					return err
				}
				mrp.SourceResourceSettings = sourceResourceSettings
			}
		case "moveStatus":
			if v != nil {
				var moveStatus MoveResourcePropertiesMoveStatus
				err = json.Unmarshal(*v, &moveStatus)
				if err != nil {
					return err
				}
				mrp.MoveStatus = &moveStatus
			}
		case "dependsOn":
			if v != nil {
				var dependsOn []MoveResourceDependency
				err = json.Unmarshal(*v, &dependsOn)
				if err != nil {
					return err
				}
				mrp.DependsOn = &dependsOn
			}
		case "dependsOnOverrides":
			if v != nil {
				var dependsOnOverrides []MoveResourceDependencyOverride
				err = json.Unmarshal(*v, &dependsOnOverrides)
				if err != nil {
					return err
				}
				mrp.DependsOnOverrides = &dependsOnOverrides
			}
		case "isResolveRequired":
			if v != nil {
				var isResolveRequired bool
				err = json.Unmarshal(*v, &isResolveRequired)
				if err != nil {
					return err
				}
				mrp.IsResolveRequired = &isResolveRequired
			}
		case "errors":
			if v != nil {
				var errorsVar MoveResourcePropertiesErrors
				err = json.Unmarshal(*v, &errorsVar)
				if err != nil {
					return err
				}
				mrp.Errors = &errorsVar
			}
		}
	}

	return nil
}

// MoveResourcePropertiesErrors defines the move resource errors.
type MoveResourcePropertiesErrors struct {
	// Properties - The move resource error body.
	Properties *MoveResourceErrorBody `json:"properties,omitempty"`
}

// MoveResourcePropertiesMoveStatus defines the move resource status.
type MoveResourcePropertiesMoveStatus struct {
	// MoveState - Possible values include: 'AssignmentPending', 'PreparePending', 'PrepareInProgress', 'PrepareFailed', 'MovePending', 'MoveInProgress', 'MoveFailed', 'DiscardInProgress', 'DiscardFailed', 'CommitPending', 'CommitInProgress', 'CommitFailed', 'Committed', 'DeleteSourcePending', 'ResourceMoveCompleted'
	MoveState MoveState          `json:"moveState,omitempty"`
	JobStatus *JobStatus         `json:"jobStatus,omitempty"`
	Errors    *MoveResourceError `json:"errors,omitempty"`
}

// MoveResourcesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveResourcesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveResourcesClient) (MoveResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveResourcesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveResourcesCreateFuture.Result.
func (future *MoveResourcesCreateFuture) result(client MoveResourcesClient) (mr MoveResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveResourcesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveResourcesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mr.Response.Response, err = future.GetResult(sender); err == nil && mr.Response.Response.StatusCode != http.StatusNoContent {
		mr, err = client.CreateResponder(mr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveResourcesCreateFuture", "Result", mr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveResourcesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveResourcesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MoveResourcesClient) (OperationStatus, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveResourcesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveResourcesDeleteFuture.Result.
func (future *MoveResourcesDeleteFuture) result(client MoveResourcesClient) (osVar OperationStatus, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resourcemover.MoveResourcesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resourcemover.MoveResourcesDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if osVar.Response.Response, err = future.GetResult(sender); err == nil && osVar.Response.Response.StatusCode != http.StatusNoContent {
		osVar, err = client.DeleteResponder(osVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resourcemover.MoveResourcesDeleteFuture", "Result", osVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MoveResourceStatus defines the move resource status.
type MoveResourceStatus struct {
	// MoveState - Possible values include: 'AssignmentPending', 'PreparePending', 'PrepareInProgress', 'PrepareFailed', 'MovePending', 'MoveInProgress', 'MoveFailed', 'DiscardInProgress', 'DiscardFailed', 'CommitPending', 'CommitInProgress', 'CommitFailed', 'Committed', 'DeleteSourcePending', 'ResourceMoveCompleted'
	MoveState MoveState          `json:"moveState,omitempty"`
	JobStatus *JobStatus         `json:"jobStatus,omitempty"`
	Errors    *MoveResourceError `json:"errors,omitempty"`
}

// NetworkInterfaceResourceSettings defines the network interface resource settings.
type NetworkInterfaceResourceSettings struct {
	// IPConfigurations - Gets or sets the IP configurations of the NIC.
	IPConfigurations *[]NicIPConfigurationResourceSettings `json:"ipConfigurations,omitempty"`
	// EnableAcceleratedNetworking - Gets or sets a value indicating whether accelerated networking is enabled.
	EnableAcceleratedNetworking *bool `json:"enableAcceleratedNetworking,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) MarshalJSON() ([]byte, error) {
	nirs.ResourceType = ResourceTypeMicrosoftNetworknetworkInterfaces
	objectMap := make(map[string]interface{})
	if nirs.IPConfigurations != nil {
		objectMap["ipConfigurations"] = nirs.IPConfigurations
	}
	if nirs.EnableAcceleratedNetworking != nil {
		objectMap["enableAcceleratedNetworking"] = nirs.EnableAcceleratedNetworking
	}
	if nirs.TargetResourceName != nil {
		objectMap["targetResourceName"] = nirs.TargetResourceName
	}
	if nirs.ResourceType != "" {
		objectMap["resourceType"] = nirs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return &nirs, true
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for NetworkInterfaceResourceSettings.
func (nirs NetworkInterfaceResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &nirs, true
}

// NetworkSecurityGroupResourceSettings defines the NSG resource settings.
type NetworkSecurityGroupResourceSettings struct {
	// SecurityRules - Gets or sets Security rules of network security group.
	SecurityRules *[]NsgSecurityRule `json:"securityRules,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) MarshalJSON() ([]byte, error) {
	nsgrs.ResourceType = ResourceTypeMicrosoftNetworknetworkSecurityGroups
	objectMap := make(map[string]interface{})
	if nsgrs.SecurityRules != nil {
		objectMap["securityRules"] = nsgrs.SecurityRules
	}
	if nsgrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = nsgrs.TargetResourceName
	}
	if nsgrs.ResourceType != "" {
		objectMap["resourceType"] = nsgrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return &nsgrs, true
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for NetworkSecurityGroupResourceSettings.
func (nsgrs NetworkSecurityGroupResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &nsgrs, true
}

// NicIPConfigurationResourceSettings defines NIC IP configuration properties.
type NicIPConfigurationResourceSettings struct {
	// Name - Gets or sets the IP configuration name.
	Name *string `json:"name,omitempty"`
	// PrivateIPAddress - Gets or sets the private IP address of the network interface IP Configuration.
	PrivateIPAddress *string `json:"privateIpAddress,omitempty"`
	// PrivateIPAllocationMethod - Gets or sets the private IP address allocation method.
	PrivateIPAllocationMethod *string          `json:"privateIpAllocationMethod,omitempty"`
	Subnet                    *SubnetReference `json:"subnet,omitempty"`
	// Primary - Gets or sets a value indicating whether this IP configuration is the primary.
	Primary *bool `json:"primary,omitempty"`
	// LoadBalancerBackendAddressPools - Gets or sets the references of the load balancer backend address pools.
	LoadBalancerBackendAddressPools *[]LoadBalancerBackendAddressPoolReference `json:"loadBalancerBackendAddressPools,omitempty"`
	// LoadBalancerNatRules - Gets or sets the references of the load balancer NAT rules.
	LoadBalancerNatRules *[]LoadBalancerNatRuleReference `json:"loadBalancerNatRules,omitempty"`
	PublicIP             *PublicIPReference              `json:"publicIp,omitempty"`
}

// NsgReference defines reference to NSG.
type NsgReference struct {
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// NsgSecurityRule security Rule data model for Network Security Groups.
type NsgSecurityRule struct {
	// Name - Gets or sets the Security rule name.
	Name *string `json:"name,omitempty"`
	// Access - Gets or sets whether network traffic is allowed or denied.
	// Possible values are “Allow” and “Deny”.
	Access *string `json:"access,omitempty"`
	// Description - Gets or sets a description for this rule. Restricted to 140 chars.
	Description *string `json:"description,omitempty"`
	// DestinationAddressPrefix - Gets or sets destination address prefix. CIDR or source IP range.
	//  A “*” can also be used to match all source IPs. Default tags such
	// as ‘VirtualNetwork’, ‘AzureLoadBalancer’ and ‘Internet’ can also be used.
	DestinationAddressPrefix *string `json:"destinationAddressPrefix,omitempty"`
	// DestinationPortRange - Gets or sets Destination Port or Range. Integer or range between
	// 0 and 65535. A “*” can also be used to match all ports.
	DestinationPortRange *string `json:"destinationPortRange,omitempty"`
	// Direction - Gets or sets the direction of the rule.InBound or Outbound. The
	// direction specifies if rule will be evaluated on incoming or outgoing traffic.
	Direction *string `json:"direction,omitempty"`
	// Priority - Gets or sets the priority of the rule. The value can be between
	// 100 and 4096. The priority number must be unique for each rule in the collection.
	// The lower the priority number, the higher the priority of the rule.
	Priority *int32 `json:"priority,omitempty"`
	// Protocol - Gets or sets Network protocol this rule applies to. Can be Tcp, Udp or All(*).
	Protocol *string `json:"protocol,omitempty"`
	// SourceAddressPrefix - Gets or sets source address prefix. CIDR or source IP range. A
	// “*” can also be used to match all source IPs.  Default tags such as ‘VirtualNetwork’,
	// ‘AzureLoadBalancer’ and ‘Internet’ can also be used. If this is an ingress
	// rule, specifies where network traffic originates from.
	SourceAddressPrefix *string `json:"sourceAddressPrefix,omitempty"`
	// SourcePortRange - Gets or sets Source Port or Range. Integer or range between 0 and
	// 65535. A “*” can also be used to match all ports.
	SourcePortRange *string `json:"sourcePortRange,omitempty"`
}

// OperationErrorAdditionalInfo the operation error info.
type OperationErrorAdditionalInfo struct {
	// Type - READ-ONLY; The error type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The operation error info.
	Info *MoveErrorInfo `json:"info,omitempty"`
}

// OperationsDiscovery operations discovery class.
type OperationsDiscovery struct {
	// Name - Gets or sets Name of the API.
	// The name of the operation being performed on this particular object. It should
	// match the action name that appears in RBAC / the event service.
	// Examples of operations include:
	// * Microsoft.Compute/virtualMachine/capture/action
	// * Microsoft.Compute/virtualMachine/restart/action
	// * Microsoft.Compute/virtualMachine/write
	// * Microsoft.Compute/virtualMachine/read
	// * Microsoft.Compute/virtualMachine/delete
	// Each action should include, in order:
	// (1) Resource Provider Namespace
	// (2) Type hierarchy for which the action applies (e.g. server/databases for a SQL
	// Azure database)
	// (3) Read, Write, Action or Delete indicating which type applies. If it is a PUT/PATCH
	// on a collection or named value, Write should be used.
	// If it is a GET, Read should be used. If it is a DELETE, Delete should be used. If it
	// is a POST, Action should be used.
	// As a note: all resource providers would need to include the "{Resource Provider
	// Namespace}/register/action" operation in their response.
	// This API is used to register for their service, and should include details about the
	// operation (e.g. a localized name for the resource provider + any special
	// considerations like PII release).
	Name *string `json:"name,omitempty"`
	// IsDataAction - Indicates whether the operation is a data action
	IsDataAction *bool    `json:"isDataAction,omitempty"`
	Display      *Display `json:"display,omitempty"`
	// Origin - Gets or sets Origin.
	// The intended executor of the operation; governs the display of the operation in the
	// RBAC UX and the audit logs UX.
	// Default value is "user,system".
	Origin     *string     `json:"origin,omitempty"`
	Properties interface{} `json:"properties,omitempty"`
}

// OperationsDiscoveryCollection collection of ClientDiscovery details.
type OperationsDiscoveryCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the ClientDiscovery details.
	Value *[]OperationsDiscovery `json:"value,omitempty"`
	// NextLink - Gets or sets the value of next link.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationStatus operation status REST resource.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Operation name.
	Name *string `json:"name,omitempty"`
	// Status - READ-ONLY; Status of the operation. ARM expects the terminal status to be one of Succeeded/ Failed/ Canceled. All other values imply that the operation is still running.
	Status *string `json:"status,omitempty"`
	// StartTime - READ-ONLY; Start time.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - READ-ONLY; End time.
	EndTime *string `json:"endTime,omitempty"`
	// Error - READ-ONLY; Error stating all error details for the operation.
	Error *OperationStatusError `json:"error,omitempty"`
	// Properties - READ-ONLY; Custom data.
	Properties interface{} `json:"properties,omitempty"`
}

// OperationStatusError class for operation status errors.
type OperationStatusError struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]OperationStatusError `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The additional info.
	AdditionalInfo *[]OperationErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// PrepareRequest defines the request body for initiate prepare operation.
type PrepareRequest struct {
	// ValidateOnly - Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
	// MoveResources - Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via moveResourceInputType property.
	MoveResources *[]string `json:"moveResources,omitempty"`
	// MoveResourceInputType - Possible values include: 'MoveResourceID', 'MoveResourceSourceID'
	MoveResourceInputType MoveResourceInputType `json:"moveResourceInputType,omitempty"`
}

// ProxyResourceReference defines reference to a proxy resource.
type ProxyResourceReference struct {
	// Name - Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// PublicIPAddressResourceSettings defines the public IP address resource settings.
type PublicIPAddressResourceSettings struct {
	// DomainNameLabel - Gets or sets the domain name label.
	DomainNameLabel *string `json:"domainNameLabel,omitempty"`
	// Fqdn - Gets or sets the fully qualified domain name.
	Fqdn *string `json:"fqdn,omitempty"`
	// PublicIPAllocationMethod - Gets or sets public IP allocation method.
	PublicIPAllocationMethod *string `json:"publicIpAllocationMethod,omitempty"`
	// Sku - Gets or sets public IP sku.
	Sku *string `json:"sku,omitempty"`
	// Zones - Gets or sets public IP zones.
	Zones *string `json:"zones,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) MarshalJSON() ([]byte, error) {
	piars.ResourceType = ResourceTypeMicrosoftNetworkpublicIPAddresses
	objectMap := make(map[string]interface{})
	if piars.DomainNameLabel != nil {
		objectMap["domainNameLabel"] = piars.DomainNameLabel
	}
	if piars.Fqdn != nil {
		objectMap["fqdn"] = piars.Fqdn
	}
	if piars.PublicIPAllocationMethod != nil {
		objectMap["publicIpAllocationMethod"] = piars.PublicIPAllocationMethod
	}
	if piars.Sku != nil {
		objectMap["sku"] = piars.Sku
	}
	if piars.Zones != nil {
		objectMap["zones"] = piars.Zones
	}
	if piars.TargetResourceName != nil {
		objectMap["targetResourceName"] = piars.TargetResourceName
	}
	if piars.ResourceType != "" {
		objectMap["resourceType"] = piars.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return &piars, true
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for PublicIPAddressResourceSettings.
func (piars PublicIPAddressResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &piars, true
}

// PublicIPReference defines reference to a public IP.
type PublicIPReference struct {
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// RequiredForResourcesCollection required for resources collection.
type RequiredForResourcesCollection struct {
	autorest.Response `json:"-"`
	// SourceIds - Gets or sets the list of source Ids for which the input resource is required.
	SourceIds *[]string `json:"sourceIds,omitempty"`
}

// ResourceGroupResourceSettings defines the resource group resource settings.
type ResourceGroupResourceSettings struct {
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) MarshalJSON() ([]byte, error) {
	rgrs.ResourceType = ResourceTypeResourceGroups
	objectMap := make(map[string]interface{})
	if rgrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = rgrs.TargetResourceName
	}
	if rgrs.ResourceType != "" {
		objectMap["resourceType"] = rgrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return &rgrs, true
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for ResourceGroupResourceSettings.
func (rgrs ResourceGroupResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &rgrs, true
}

// ResourceMoveRequestType defines the request body for resource move operation.
type ResourceMoveRequestType struct {
	// ValidateOnly - Gets or sets a value indicating whether the operation needs to only run pre-requisite.
	ValidateOnly *bool `json:"validateOnly,omitempty"`
	// MoveResources - Gets or sets the list of resource Id's, by default it accepts move resource id's unless the input type is switched via moveResourceInputType property.
	MoveResources *[]string `json:"moveResources,omitempty"`
	// MoveResourceInputType - Possible values include: 'MoveResourceID', 'MoveResourceSourceID'
	MoveResourceInputType MoveResourceInputType `json:"moveResourceInputType,omitempty"`
}

// BasicResourceSettings gets or sets the resource settings.
type BasicResourceSettings interface {
	AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool)
	AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool)
	AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool)
	AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool)
	AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool)
	AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool)
	AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool)
	AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool)
	AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool)
	AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool)
	AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool)
	AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool)
	AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool)
	AsResourceSettings() (*ResourceSettings, bool)
}

// ResourceSettings gets or sets the resource settings.
type ResourceSettings struct {
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

func unmarshalBasicResourceSettings(body []byte) (BasicResourceSettings, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["resourceType"] {
	case string(ResourceTypeMicrosoftComputevirtualMachines):
		var vmrs VirtualMachineResourceSettings
		err := json.Unmarshal(body, &vmrs)
		return vmrs, err
	case string(ResourceTypeMicrosoftComputeavailabilitySets):
		var asrs AvailabilitySetResourceSettings
		err := json.Unmarshal(body, &asrs)
		return asrs, err
	case string(ResourceTypeMicrosoftNetworkvirtualNetworks):
		var vnrs VirtualNetworkResourceSettings
		err := json.Unmarshal(body, &vnrs)
		return vnrs, err
	case string(ResourceTypeMicrosoftNetworknetworkInterfaces):
		var nirs NetworkInterfaceResourceSettings
		err := json.Unmarshal(body, &nirs)
		return nirs, err
	case string(ResourceTypeMicrosoftNetworknetworkSecurityGroups):
		var nsgrs NetworkSecurityGroupResourceSettings
		err := json.Unmarshal(body, &nsgrs)
		return nsgrs, err
	case string(ResourceTypeMicrosoftNetworkloadBalancers):
		var lbrs LoadBalancerResourceSettings
		err := json.Unmarshal(body, &lbrs)
		return lbrs, err
	case string(ResourceTypeMicrosoftSqlservers):
		var ssrs SQLServerResourceSettings
		err := json.Unmarshal(body, &ssrs)
		return ssrs, err
	case string(ResourceTypeMicrosoftSqlserverselasticPools):
		var seprs SQLElasticPoolResourceSettings
		err := json.Unmarshal(body, &seprs)
		return seprs, err
	case string(ResourceTypeMicrosoftSqlserversdatabases):
		var sdrs SQLDatabaseResourceSettings
		err := json.Unmarshal(body, &sdrs)
		return sdrs, err
	case string(ResourceTypeResourceGroups):
		var rgrs ResourceGroupResourceSettings
		err := json.Unmarshal(body, &rgrs)
		return rgrs, err
	case string(ResourceTypeMicrosoftNetworkpublicIPAddresses):
		var piars PublicIPAddressResourceSettings
		err := json.Unmarshal(body, &piars)
		return piars, err
	case string(ResourceTypeMicrosoftKeyVaultvaults):
		var kvrs KeyVaultResourceSettings
		err := json.Unmarshal(body, &kvrs)
		return kvrs, err
	case string(ResourceTypeMicrosoftComputediskEncryptionSets):
		var desrs DiskEncryptionSetResourceSettings
		err := json.Unmarshal(body, &desrs)
		return desrs, err
	default:
		var rs ResourceSettings
		err := json.Unmarshal(body, &rs)
		return rs, err
	}
}
func unmarshalBasicResourceSettingsArray(body []byte) ([]BasicResourceSettings, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rsArray := make([]BasicResourceSettings, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rs, err := unmarshalBasicResourceSettings(*rawMessage)
		if err != nil {
			return nil, err
		}
		rsArray[index] = rs
	}
	return rsArray, nil
}

// MarshalJSON is the custom marshaler for ResourceSettings.
func (rs ResourceSettings) MarshalJSON() ([]byte, error) {
	rs.ResourceType = ResourceTypeResourceSettings
	objectMap := make(map[string]interface{})
	if rs.TargetResourceName != nil {
		objectMap["targetResourceName"] = rs.TargetResourceName
	}
	if rs.ResourceType != "" {
		objectMap["resourceType"] = rs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return &rs, true
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for ResourceSettings.
func (rs ResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &rs, true
}

// SQLDatabaseResourceSettings defines the Sql Database resource settings.
type SQLDatabaseResourceSettings struct {
	// ZoneRedundant - Possible values include: 'Enable', 'Disable'
	ZoneRedundant ZoneRedundant `json:"zoneRedundant,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) MarshalJSON() ([]byte, error) {
	sdrs.ResourceType = ResourceTypeMicrosoftSqlserversdatabases
	objectMap := make(map[string]interface{})
	if sdrs.ZoneRedundant != "" {
		objectMap["zoneRedundant"] = sdrs.ZoneRedundant
	}
	if sdrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = sdrs.TargetResourceName
	}
	if sdrs.ResourceType != "" {
		objectMap["resourceType"] = sdrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return &sdrs, true
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for SQLDatabaseResourceSettings.
func (sdrs SQLDatabaseResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &sdrs, true
}

// SQLElasticPoolResourceSettings defines the Sql ElasticPool resource settings.
type SQLElasticPoolResourceSettings struct {
	// ZoneRedundant - Possible values include: 'Enable', 'Disable'
	ZoneRedundant ZoneRedundant `json:"zoneRedundant,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) MarshalJSON() ([]byte, error) {
	seprs.ResourceType = ResourceTypeMicrosoftSqlserverselasticPools
	objectMap := make(map[string]interface{})
	if seprs.ZoneRedundant != "" {
		objectMap["zoneRedundant"] = seprs.ZoneRedundant
	}
	if seprs.TargetResourceName != nil {
		objectMap["targetResourceName"] = seprs.TargetResourceName
	}
	if seprs.ResourceType != "" {
		objectMap["resourceType"] = seprs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return &seprs, true
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for SQLElasticPoolResourceSettings.
func (seprs SQLElasticPoolResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &seprs, true
}

// SQLServerResourceSettings defines the SQL Server resource settings.
type SQLServerResourceSettings struct {
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) MarshalJSON() ([]byte, error) {
	ssrs.ResourceType = ResourceTypeMicrosoftSqlservers
	objectMap := make(map[string]interface{})
	if ssrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = ssrs.TargetResourceName
	}
	if ssrs.ResourceType != "" {
		objectMap["resourceType"] = ssrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return &ssrs, true
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for SQLServerResourceSettings.
func (ssrs SQLServerResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &ssrs, true
}

// SubnetReference defines reference to subnet.
type SubnetReference struct {
	// Name - Gets the name of the proxy resource on the target side.
	Name *string `json:"name,omitempty"`
	// SourceArmResourceID - Gets the ARM resource ID of the tracked resource being referenced.
	SourceArmResourceID *string `json:"sourceArmResourceId,omitempty"`
}

// SubnetResourceSettings defines the virtual network subnets resource settings.
type SubnetResourceSettings struct {
	// Name - Gets or sets the Subnet name.
	Name *string `json:"name,omitempty"`
	// AddressPrefix - Gets or sets address prefix for the subnet.
	AddressPrefix        *string       `json:"addressPrefix,omitempty"`
	NetworkSecurityGroup *NsgReference `json:"networkSecurityGroup,omitempty"`
}

// Summary summary item.
type Summary struct {
	// Count - Gets the count.
	Count *int32 `json:"count,omitempty"`
	// Item - Gets the item.
	Item *string `json:"item,omitempty"`
}

// SummaryCollection summary Collection.
type SummaryCollection struct {
	// FieldName - Gets or sets the field name on which summary is done.
	FieldName *string `json:"fieldName,omitempty"`
	// Summary - Gets or sets the list of summary items.
	Summary *[]Summary `json:"summary,omitempty"`
}

// UnresolvedDependenciesFilter unresolved dependencies contract.
type UnresolvedDependenciesFilter struct {
	Properties *UnresolvedDependenciesFilterProperties `json:"properties,omitempty"`
}

// UnresolvedDependenciesFilterProperties ...
type UnresolvedDependenciesFilterProperties struct {
	// Count - The count of the resource.
	Count *int32 `json:"count,omitempty"`
}

// UnresolvedDependency unresolved dependency.
type UnresolvedDependency struct {
	// Count - Gets or sets the count.
	Count *int32 `json:"count,omitempty"`
	// ID - Gets or sets the arm id of the dependency.
	ID *string `json:"id,omitempty"`
}

// UnresolvedDependencyCollection unresolved dependency collection.
type UnresolvedDependencyCollection struct {
	autorest.Response `json:"-"`
	// Value - Gets or sets the list of unresolved dependencies.
	Value *[]UnresolvedDependency `json:"value,omitempty"`
	// NextLink - Gets or sets the value of  next link.
	NextLink *string `json:"nextLink,omitempty"`
	// SummaryCollection - READ-ONLY; Gets or sets the list of summary items and the field on which summary is done.
	SummaryCollection *SummaryCollection `json:"summaryCollection,omitempty"`
	// TotalCount - READ-ONLY; Gets the total count.
	TotalCount *int64 `json:"totalCount,omitempty"`
}

// MarshalJSON is the custom marshaler for UnresolvedDependencyCollection.
func (udc UnresolvedDependencyCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if udc.Value != nil {
		objectMap["value"] = udc.Value
	}
	if udc.NextLink != nil {
		objectMap["nextLink"] = udc.NextLink
	}
	return json.Marshal(objectMap)
}

// UnresolvedDependencyCollectionIterator provides access to a complete listing of UnresolvedDependency
// values.
type UnresolvedDependencyCollectionIterator struct {
	i    int
	page UnresolvedDependencyCollectionPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UnresolvedDependencyCollectionIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UnresolvedDependencyCollectionIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *UnresolvedDependencyCollectionIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UnresolvedDependencyCollectionIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UnresolvedDependencyCollectionIterator) Response() UnresolvedDependencyCollection {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UnresolvedDependencyCollectionIterator) Value() UnresolvedDependency {
	if !iter.page.NotDone() {
		return UnresolvedDependency{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the UnresolvedDependencyCollectionIterator type.
func NewUnresolvedDependencyCollectionIterator(page UnresolvedDependencyCollectionPage) UnresolvedDependencyCollectionIterator {
	return UnresolvedDependencyCollectionIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (udc UnresolvedDependencyCollection) IsEmpty() bool {
	return udc.Value == nil || len(*udc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (udc UnresolvedDependencyCollection) hasNextLink() bool {
	return udc.NextLink != nil && len(*udc.NextLink) != 0
}

// unresolvedDependencyCollectionPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (udc UnresolvedDependencyCollection) unresolvedDependencyCollectionPreparer(ctx context.Context) (*http.Request, error) {
	if !udc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(udc.NextLink)))
}

// UnresolvedDependencyCollectionPage contains a page of UnresolvedDependency values.
type UnresolvedDependencyCollectionPage struct {
	fn  func(context.Context, UnresolvedDependencyCollection) (UnresolvedDependencyCollection, error)
	udc UnresolvedDependencyCollection
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UnresolvedDependencyCollectionPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/UnresolvedDependencyCollectionPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.udc)
		if err != nil {
			return err
		}
		page.udc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *UnresolvedDependencyCollectionPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UnresolvedDependencyCollectionPage) NotDone() bool {
	return !page.udc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UnresolvedDependencyCollectionPage) Response() UnresolvedDependencyCollection {
	return page.udc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UnresolvedDependencyCollectionPage) Values() []UnresolvedDependency {
	if page.udc.IsEmpty() {
		return nil
	}
	return *page.udc.Value
}

// Creates a new instance of the UnresolvedDependencyCollectionPage type.
func NewUnresolvedDependencyCollectionPage(cur UnresolvedDependencyCollection, getNextPage func(context.Context, UnresolvedDependencyCollection) (UnresolvedDependencyCollection, error)) UnresolvedDependencyCollectionPage {
	return UnresolvedDependencyCollectionPage{
		fn:  getNextPage,
		udc: cur,
	}
}

// UpdateMoveCollectionRequest defines the request body for updating move collection.
type UpdateMoveCollectionRequest struct {
	// Tags - Gets or sets the Resource tags.
	Tags     map[string]*string `json:"tags"`
	Identity *Identity          `json:"identity,omitempty"`
}

// MarshalJSON is the custom marshaler for UpdateMoveCollectionRequest.
func (umcr UpdateMoveCollectionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if umcr.Tags != nil {
		objectMap["tags"] = umcr.Tags
	}
	if umcr.Identity != nil {
		objectMap["identity"] = umcr.Identity
	}
	return json.Marshal(objectMap)
}

// VirtualMachineResourceSettings gets or sets the virtual machine resource settings.
type VirtualMachineResourceSettings struct {
	// TargetAvailabilityZone - Gets or sets the target availability zone. Possible values include: 'One', 'Two', 'Three', 'NA'
	TargetAvailabilityZone TargetAvailabilityZone `json:"targetAvailabilityZone,omitempty"`
	// TargetVMSize - Gets or sets the target virtual machine size.
	TargetVMSize *string `json:"targetVmSize,omitempty"`
	// TargetAvailabilitySetID - Gets or sets the target availability set id for virtual machines not in an availability set at source.
	TargetAvailabilitySetID *string `json:"targetAvailabilitySetId,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) MarshalJSON() ([]byte, error) {
	vmrs.ResourceType = ResourceTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if vmrs.TargetAvailabilityZone != "" {
		objectMap["targetAvailabilityZone"] = vmrs.TargetAvailabilityZone
	}
	if vmrs.TargetVMSize != nil {
		objectMap["targetVmSize"] = vmrs.TargetVMSize
	}
	if vmrs.TargetAvailabilitySetID != nil {
		objectMap["targetAvailabilitySetId"] = vmrs.TargetAvailabilitySetID
	}
	if vmrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = vmrs.TargetResourceName
	}
	if vmrs.ResourceType != "" {
		objectMap["resourceType"] = vmrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return &vmrs, true
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return nil, false
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for VirtualMachineResourceSettings.
func (vmrs VirtualMachineResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &vmrs, true
}

// VirtualNetworkResourceSettings defines the virtual network resource settings.
type VirtualNetworkResourceSettings struct {
	// EnableDdosProtection - Gets or sets a value indicating whether gets or sets whether the
	// DDOS protection should be switched on.
	EnableDdosProtection *bool `json:"enableDdosProtection,omitempty"`
	// AddressSpace - Gets or sets the address prefixes for the virtual network.
	AddressSpace *[]string `json:"addressSpace,omitempty"`
	// DNSServers - Gets or sets DHCPOptions that contains an array of DNS servers available to VMs
	// deployed in the virtual network.
	DNSServers *[]string `json:"dnsServers,omitempty"`
	// Subnets - Gets or sets List of subnets in a VirtualNetwork.
	Subnets *[]SubnetResourceSettings `json:"subnets,omitempty"`
	// TargetResourceName - Gets or sets the target Resource name.
	TargetResourceName *string `json:"targetResourceName,omitempty"`
	// ResourceType - Possible values include: 'ResourceTypeResourceSettings', 'ResourceTypeMicrosoftComputevirtualMachines', 'ResourceTypeMicrosoftComputeavailabilitySets', 'ResourceTypeMicrosoftNetworkvirtualNetworks', 'ResourceTypeMicrosoftNetworknetworkInterfaces', 'ResourceTypeMicrosoftNetworknetworkSecurityGroups', 'ResourceTypeMicrosoftNetworkloadBalancers', 'ResourceTypeMicrosoftSqlservers', 'ResourceTypeMicrosoftSqlserverselasticPools', 'ResourceTypeMicrosoftSqlserversdatabases', 'ResourceTypeResourceGroups', 'ResourceTypeMicrosoftNetworkpublicIPAddresses', 'ResourceTypeMicrosoftKeyVaultvaults', 'ResourceTypeMicrosoftComputediskEncryptionSets'
	ResourceType ResourceType `json:"resourceType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) MarshalJSON() ([]byte, error) {
	vnrs.ResourceType = ResourceTypeMicrosoftNetworkvirtualNetworks
	objectMap := make(map[string]interface{})
	if vnrs.EnableDdosProtection != nil {
		objectMap["enableDdosProtection"] = vnrs.EnableDdosProtection
	}
	if vnrs.AddressSpace != nil {
		objectMap["addressSpace"] = vnrs.AddressSpace
	}
	if vnrs.DNSServers != nil {
		objectMap["dnsServers"] = vnrs.DNSServers
	}
	if vnrs.Subnets != nil {
		objectMap["subnets"] = vnrs.Subnets
	}
	if vnrs.TargetResourceName != nil {
		objectMap["targetResourceName"] = vnrs.TargetResourceName
	}
	if vnrs.ResourceType != "" {
		objectMap["resourceType"] = vnrs.ResourceType
	}
	return json.Marshal(objectMap)
}

// AsVirtualMachineResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsVirtualMachineResourceSettings() (*VirtualMachineResourceSettings, bool) {
	return nil, false
}

// AsAvailabilitySetResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsAvailabilitySetResourceSettings() (*AvailabilitySetResourceSettings, bool) {
	return nil, false
}

// AsVirtualNetworkResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsVirtualNetworkResourceSettings() (*VirtualNetworkResourceSettings, bool) {
	return &vnrs, true
}

// AsNetworkInterfaceResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsNetworkInterfaceResourceSettings() (*NetworkInterfaceResourceSettings, bool) {
	return nil, false
}

// AsNetworkSecurityGroupResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsNetworkSecurityGroupResourceSettings() (*NetworkSecurityGroupResourceSettings, bool) {
	return nil, false
}

// AsLoadBalancerResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsLoadBalancerResourceSettings() (*LoadBalancerResourceSettings, bool) {
	return nil, false
}

// AsSQLServerResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsSQLServerResourceSettings() (*SQLServerResourceSettings, bool) {
	return nil, false
}

// AsSQLElasticPoolResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsSQLElasticPoolResourceSettings() (*SQLElasticPoolResourceSettings, bool) {
	return nil, false
}

// AsSQLDatabaseResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsSQLDatabaseResourceSettings() (*SQLDatabaseResourceSettings, bool) {
	return nil, false
}

// AsResourceGroupResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsResourceGroupResourceSettings() (*ResourceGroupResourceSettings, bool) {
	return nil, false
}

// AsPublicIPAddressResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsPublicIPAddressResourceSettings() (*PublicIPAddressResourceSettings, bool) {
	return nil, false
}

// AsKeyVaultResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsKeyVaultResourceSettings() (*KeyVaultResourceSettings, bool) {
	return nil, false
}

// AsDiskEncryptionSetResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsDiskEncryptionSetResourceSettings() (*DiskEncryptionSetResourceSettings, bool) {
	return nil, false
}

// AsResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsResourceSettings() (*ResourceSettings, bool) {
	return nil, false
}

// AsBasicResourceSettings is the BasicResourceSettings implementation for VirtualNetworkResourceSettings.
func (vnrs VirtualNetworkResourceSettings) AsBasicResourceSettings() (BasicResourceSettings, bool) {
	return &vnrs, true
}
