package delegatednetwork

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/delegatednetwork/mgmt/2021-03-15/delegatednetwork"

// ControllerCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ControllerCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ControllerClient) (DelegatedController, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ControllerCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ControllerCreateFuture.Result.
func (future *ControllerCreateFuture) result(client ControllerClient) (dc DelegatedController, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.ControllerCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.ControllerCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dc.Response.Response, err = future.GetResult(sender); err == nil && dc.Response.Response.StatusCode != http.StatusNoContent {
		dc, err = client.CreateResponder(dc.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "delegatednetwork.ControllerCreateFuture", "Result", dc.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ControllerDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ControllerDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ControllerClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ControllerDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ControllerDeleteFuture.Result.
func (future *ControllerDeleteFuture) result(client ControllerClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.ControllerDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.ControllerDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ControllerDetails controller details
type ControllerDetails struct {
	// ID - controller arm resource id
	ID *string `json:"id,omitempty"`
}

// ControllerResource represents an instance of a resource.
type ControllerResource struct {
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ControllerResource.
func (cr ControllerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	return json.Marshal(objectMap)
}

// ControllerResourceUpdateParameters parameters for updating a resource.
type ControllerResourceUpdateParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ControllerResourceUpdateParameters.
func (crup ControllerResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crup.Tags != nil {
		objectMap["tags"] = crup.Tags
	}
	return json.Marshal(objectMap)
}

// DelegatedController represents an instance of a DNC controller.
type DelegatedController struct {
	autorest.Response `json:"-"`
	// DelegatedControllerProperties - READ-ONLY; Properties of the provision operation request.
	*DelegatedControllerProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DelegatedController.
func (dc DelegatedController) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.Location != nil {
		objectMap["location"] = dc.Location
	}
	if dc.Tags != nil {
		objectMap["tags"] = dc.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DelegatedController struct.
func (dc *DelegatedController) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var delegatedControllerProperties DelegatedControllerProperties
				err = json.Unmarshal(*v, &delegatedControllerProperties)
				if err != nil {
					return err
				}
				dc.DelegatedControllerProperties = &delegatedControllerProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				dc.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				dc.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				dc.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				dc.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				dc.Tags = tags
			}
		}
	}

	return nil
}

// DelegatedControllerProperties properties of Delegated controller resource.
type DelegatedControllerProperties struct {
	// ResourceGUID - READ-ONLY; Resource guid.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The current state of dnc controller resource. Possible values include: 'Deleting', 'Succeeded', 'Failed', 'Provisioning'
	ProvisioningState ControllerState `json:"provisioningState,omitempty"`
	// DncAppID - READ-ONLY; dnc application id should be used by customer to authenticate with dnc gateway.
	DncAppID *string `json:"dncAppId,omitempty"`
	// DncTenantID - READ-ONLY; tenant id of dnc application id
	DncTenantID *string `json:"dncTenantId,omitempty"`
	// DncEndpoint - READ-ONLY; dnc endpoint url that customers can use to connect to
	DncEndpoint *string `json:"dncEndpoint,omitempty"`
}

// DelegatedControllers an array of Delegated controller resources.
type DelegatedControllers struct {
	autorest.Response `json:"-"`
	// Value - An array of Delegated controller resources.
	Value *[]DelegatedController `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of controllers.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DelegatedControllers.
func (dc DelegatedControllers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.Value != nil {
		objectMap["value"] = dc.Value
	}
	return json.Marshal(objectMap)
}

// DelegatedControllersIterator provides access to a complete listing of DelegatedController values.
type DelegatedControllersIterator struct {
	i    int
	page DelegatedControllersPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DelegatedControllersIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DelegatedControllersIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DelegatedControllersIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DelegatedControllersIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DelegatedControllersIterator) Response() DelegatedControllers {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DelegatedControllersIterator) Value() DelegatedController {
	if !iter.page.NotDone() {
		return DelegatedController{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DelegatedControllersIterator type.
func NewDelegatedControllersIterator(page DelegatedControllersPage) DelegatedControllersIterator {
	return DelegatedControllersIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dc DelegatedControllers) IsEmpty() bool {
	return dc.Value == nil || len(*dc.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dc DelegatedControllers) hasNextLink() bool {
	return dc.NextLink != nil && len(*dc.NextLink) != 0
}

// delegatedControllersPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dc DelegatedControllers) delegatedControllersPreparer(ctx context.Context) (*http.Request, error) {
	if !dc.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dc.NextLink)))
}

// DelegatedControllersPage contains a page of DelegatedController values.
type DelegatedControllersPage struct {
	fn func(context.Context, DelegatedControllers) (DelegatedControllers, error)
	dc DelegatedControllers
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DelegatedControllersPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DelegatedControllersPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dc)
		if err != nil {
			return err
		}
		page.dc = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DelegatedControllersPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DelegatedControllersPage) NotDone() bool {
	return !page.dc.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DelegatedControllersPage) Response() DelegatedControllers {
	return page.dc
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DelegatedControllersPage) Values() []DelegatedController {
	if page.dc.IsEmpty() {
		return nil
	}
	return *page.dc.Value
}

// Creates a new instance of the DelegatedControllersPage type.
func NewDelegatedControllersPage(cur DelegatedControllers, getNextPage func(context.Context, DelegatedControllers) (DelegatedControllers, error)) DelegatedControllersPage {
	return DelegatedControllersPage{
		fn: getNextPage,
		dc: cur,
	}
}

// DelegatedSubnet represents an instance of a orchestrator.
type DelegatedSubnet struct {
	autorest.Response `json:"-"`
	// DelegatedSubnetProperties - READ-ONLY; Properties of the provision operation request.
	*DelegatedSubnetProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DelegatedSubnet.
func (ds DelegatedSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Location != nil {
		objectMap["location"] = ds.Location
	}
	if ds.Tags != nil {
		objectMap["tags"] = ds.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for DelegatedSubnet struct.
func (ds *DelegatedSubnet) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var delegatedSubnetProperties DelegatedSubnetProperties
				err = json.Unmarshal(*v, &delegatedSubnetProperties)
				if err != nil {
					return err
				}
				ds.DelegatedSubnetProperties = &delegatedSubnetProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ds.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ds.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ds.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ds.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ds.Tags = tags
			}
		}
	}

	return nil
}

// DelegatedSubnetProperties properties of delegated subnet
type DelegatedSubnetProperties struct {
	// ResourceGUID - READ-ONLY; Resource guid.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The current state of dnc delegated subnet resource. Possible values include: 'DelegatedSubnetStateDeleting', 'DelegatedSubnetStateSucceeded', 'DelegatedSubnetStateFailed', 'DelegatedSubnetStateProvisioning'
	ProvisioningState DelegatedSubnetState `json:"provisioningState,omitempty"`
	// SubnetDetails - subnet details
	SubnetDetails *SubnetDetails `json:"subnetDetails,omitempty"`
	// ControllerDetails - Properties of the controller.
	ControllerDetails *ControllerDetails `json:"controllerDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for DelegatedSubnetProperties.
func (dsp DelegatedSubnetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsp.SubnetDetails != nil {
		objectMap["subnetDetails"] = dsp.SubnetDetails
	}
	if dsp.ControllerDetails != nil {
		objectMap["controllerDetails"] = dsp.ControllerDetails
	}
	return json.Marshal(objectMap)
}

// DelegatedSubnetResource represents an instance of a resource.
type DelegatedSubnetResource struct {
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DelegatedSubnetResource.
func (dsr DelegatedSubnetResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dsr.Location != nil {
		objectMap["location"] = dsr.Location
	}
	if dsr.Tags != nil {
		objectMap["tags"] = dsr.Tags
	}
	return json.Marshal(objectMap)
}

// DelegatedSubnets an array of DelegatedSubnet resources.
type DelegatedSubnets struct {
	autorest.Response `json:"-"`
	// Value - An array of DelegatedSubnet resources.
	Value *[]DelegatedSubnet `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of DelegatedSubnet resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DelegatedSubnets.
func (ds DelegatedSubnets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ds.Value != nil {
		objectMap["value"] = ds.Value
	}
	return json.Marshal(objectMap)
}

// DelegatedSubnetServiceDeleteDetailsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DelegatedSubnetServiceDeleteDetailsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DelegatedSubnetServiceClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DelegatedSubnetServiceDeleteDetailsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DelegatedSubnetServiceDeleteDetailsFuture.Result.
func (future *DelegatedSubnetServiceDeleteDetailsFuture) result(client DelegatedSubnetServiceClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.DelegatedSubnetServiceDeleteDetailsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.DelegatedSubnetServiceDeleteDetailsFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DelegatedSubnetServicePatchDetailsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DelegatedSubnetServicePatchDetailsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DelegatedSubnetServiceClient) (DelegatedSubnet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DelegatedSubnetServicePatchDetailsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DelegatedSubnetServicePatchDetailsFuture.Result.
func (future *DelegatedSubnetServicePatchDetailsFuture) result(client DelegatedSubnetServiceClient) (ds DelegatedSubnet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.DelegatedSubnetServicePatchDetailsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.DelegatedSubnetServicePatchDetailsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.PatchDetailsResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "delegatednetwork.DelegatedSubnetServicePatchDetailsFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DelegatedSubnetServicePutDetailsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DelegatedSubnetServicePutDetailsFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DelegatedSubnetServiceClient) (DelegatedSubnet, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DelegatedSubnetServicePutDetailsFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DelegatedSubnetServicePutDetailsFuture.Result.
func (future *DelegatedSubnetServicePutDetailsFuture) result(client DelegatedSubnetServiceClient) (ds DelegatedSubnet, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.DelegatedSubnetServicePutDetailsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.DelegatedSubnetServicePutDetailsFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ds.Response.Response, err = future.GetResult(sender); err == nil && ds.Response.Response.StatusCode != http.StatusNoContent {
		ds, err = client.PutDetailsResponder(ds.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "delegatednetwork.DelegatedSubnetServicePutDetailsFuture", "Result", ds.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DelegatedSubnetsIterator provides access to a complete listing of DelegatedSubnet values.
type DelegatedSubnetsIterator struct {
	i    int
	page DelegatedSubnetsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DelegatedSubnetsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DelegatedSubnetsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DelegatedSubnetsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DelegatedSubnetsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DelegatedSubnetsIterator) Response() DelegatedSubnets {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DelegatedSubnetsIterator) Value() DelegatedSubnet {
	if !iter.page.NotDone() {
		return DelegatedSubnet{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DelegatedSubnetsIterator type.
func NewDelegatedSubnetsIterator(page DelegatedSubnetsPage) DelegatedSubnetsIterator {
	return DelegatedSubnetsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ds DelegatedSubnets) IsEmpty() bool {
	return ds.Value == nil || len(*ds.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ds DelegatedSubnets) hasNextLink() bool {
	return ds.NextLink != nil && len(*ds.NextLink) != 0
}

// delegatedSubnetsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ds DelegatedSubnets) delegatedSubnetsPreparer(ctx context.Context) (*http.Request, error) {
	if !ds.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ds.NextLink)))
}

// DelegatedSubnetsPage contains a page of DelegatedSubnet values.
type DelegatedSubnetsPage struct {
	fn func(context.Context, DelegatedSubnets) (DelegatedSubnets, error)
	ds DelegatedSubnets
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DelegatedSubnetsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DelegatedSubnetsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ds)
		if err != nil {
			return err
		}
		page.ds = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DelegatedSubnetsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DelegatedSubnetsPage) NotDone() bool {
	return !page.ds.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DelegatedSubnetsPage) Response() DelegatedSubnets {
	return page.ds
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DelegatedSubnetsPage) Values() []DelegatedSubnet {
	if page.ds.IsEmpty() {
		return nil
	}
	return *page.ds.Value
}

// Creates a new instance of the DelegatedSubnetsPage type.
func NewDelegatedSubnetsPage(cur DelegatedSubnets, getNextPage func(context.Context, DelegatedSubnets) (DelegatedSubnets, error)) DelegatedSubnetsPage {
	return DelegatedSubnetsPage{
		fn: getNextPage,
		ds: cur,
	}
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'User', 'System', 'Usersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'Internal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Orchestrator represents an instance of a orchestrator.
type Orchestrator struct {
	autorest.Response `json:"-"`
	// OrchestratorResourceProperties - Properties of the provision operation request.
	*OrchestratorResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Kind - The kind of workbook. Choices are user and shared.
	Kind *string `json:"kind,omitempty"`
	// Identity - The identity of the orchestrator
	Identity *OrchestratorIdentity `json:"identity,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Orchestrator.
func (o Orchestrator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.OrchestratorResourceProperties != nil {
		objectMap["properties"] = o.OrchestratorResourceProperties
	}
	if o.Location != nil {
		objectMap["location"] = o.Location
	}
	if o.Kind != nil {
		objectMap["kind"] = o.Kind
	}
	if o.Identity != nil {
		objectMap["identity"] = o.Identity
	}
	if o.Tags != nil {
		objectMap["tags"] = o.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Orchestrator struct.
func (o *Orchestrator) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var orchestratorResourceProperties OrchestratorResourceProperties
				err = json.Unmarshal(*v, &orchestratorResourceProperties)
				if err != nil {
					return err
				}
				o.OrchestratorResourceProperties = &orchestratorResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				o.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				o.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				o.Location = &location
			}
		case "kind":
			if v != nil {
				var kind string
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				o.Kind = &kind
			}
		case "identity":
			if v != nil {
				var identity OrchestratorIdentity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				o.Identity = &identity
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				o.Tags = tags
			}
		}
	}

	return nil
}

// OrchestratorIdentity ...
type OrchestratorIdentity struct {
	// PrincipalID - READ-ONLY; The principal id of the system assigned identity which is used by orchestrator.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant id of the system assigned identity which is used by orchestrator.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters. Possible values include: 'SystemAssigned', 'None'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for OrchestratorIdentity.
func (oi OrchestratorIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oi.Type != "" {
		objectMap["type"] = oi.Type
	}
	return json.Marshal(objectMap)
}

// OrchestratorInstanceServiceCreateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OrchestratorInstanceServiceCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrchestratorInstanceServiceClient) (Orchestrator, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrchestratorInstanceServiceCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrchestratorInstanceServiceCreateFuture.Result.
func (future *OrchestratorInstanceServiceCreateFuture) result(client OrchestratorInstanceServiceClient) (o Orchestrator, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.OrchestratorInstanceServiceCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.OrchestratorInstanceServiceCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if o.Response.Response, err = future.GetResult(sender); err == nil && o.Response.Response.StatusCode != http.StatusNoContent {
		o, err = client.CreateResponder(o.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "delegatednetwork.OrchestratorInstanceServiceCreateFuture", "Result", o.Response.Response, "Failure responding to request")
		}
	}
	return
}

// OrchestratorInstanceServiceDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type OrchestratorInstanceServiceDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(OrchestratorInstanceServiceClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *OrchestratorInstanceServiceDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for OrchestratorInstanceServiceDeleteFuture.Result.
func (future *OrchestratorInstanceServiceDeleteFuture) result(client OrchestratorInstanceServiceClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "delegatednetwork.OrchestratorInstanceServiceDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("delegatednetwork.OrchestratorInstanceServiceDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OrchestratorResource represents an instance of a resource.
type OrchestratorResource struct {
	// ID - READ-ONLY; An identifier that represents the resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location of the resource.
	Location *string `json:"location,omitempty"`
	// Kind - The kind of workbook. Choices are user and shared.
	Kind *string `json:"kind,omitempty"`
	// Identity - The identity of the orchestrator
	Identity *OrchestratorIdentity `json:"identity,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for OrchestratorResource.
func (or OrchestratorResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if or.Location != nil {
		objectMap["location"] = or.Location
	}
	if or.Kind != nil {
		objectMap["kind"] = or.Kind
	}
	if or.Identity != nil {
		objectMap["identity"] = or.Identity
	}
	if or.Tags != nil {
		objectMap["tags"] = or.Tags
	}
	return json.Marshal(objectMap)
}

// OrchestratorResourceProperties properties of orchestrator
type OrchestratorResourceProperties struct {
	// ResourceGUID - READ-ONLY; Resource guid.
	ResourceGUID *string `json:"resourceGuid,omitempty"`
	// ProvisioningState - READ-ONLY; The current state of orchestratorInstance resource. Possible values include: 'OrchestratorInstanceStateDeleting', 'OrchestratorInstanceStateSucceeded', 'OrchestratorInstanceStateFailed', 'OrchestratorInstanceStateProvisioning'
	ProvisioningState OrchestratorInstanceState `json:"provisioningState,omitempty"`
	// OrchestratorAppID - AAD ID used with apiserver
	OrchestratorAppID *string `json:"orchestratorAppId,omitempty"`
	// OrchestratorTenantID - TenantID of server App ID
	OrchestratorTenantID *string `json:"orchestratorTenantId,omitempty"`
	// ClusterRootCA - RootCA certificate of kubernetes cluster base64 encoded
	ClusterRootCA *string `json:"clusterRootCA,omitempty"`
	// APIServerEndpoint - K8s APIServer url. Either one of apiServerEndpoint or privateLinkResourceId can be specified
	APIServerEndpoint *string `json:"apiServerEndpoint,omitempty"`
	// PrivateLinkResourceID - private link arm resource id. Either one of apiServerEndpoint or privateLinkResourceId can be specified
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`
	// ControllerDetails - Properties of the controller.
	ControllerDetails *ControllerDetails `json:"controllerDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for OrchestratorResourceProperties.
func (orp OrchestratorResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orp.OrchestratorAppID != nil {
		objectMap["orchestratorAppId"] = orp.OrchestratorAppID
	}
	if orp.OrchestratorTenantID != nil {
		objectMap["orchestratorTenantId"] = orp.OrchestratorTenantID
	}
	if orp.ClusterRootCA != nil {
		objectMap["clusterRootCA"] = orp.ClusterRootCA
	}
	if orp.APIServerEndpoint != nil {
		objectMap["apiServerEndpoint"] = orp.APIServerEndpoint
	}
	if orp.PrivateLinkResourceID != nil {
		objectMap["privateLinkResourceId"] = orp.PrivateLinkResourceID
	}
	if orp.ControllerDetails != nil {
		objectMap["controllerDetails"] = orp.ControllerDetails
	}
	return json.Marshal(objectMap)
}

// OrchestratorResourceUpdateParameters parameters for updating a resource.
type OrchestratorResourceUpdateParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for OrchestratorResourceUpdateParameters.
func (orup OrchestratorResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if orup.Tags != nil {
		objectMap["tags"] = orup.Tags
	}
	return json.Marshal(objectMap)
}

// Orchestrators an array of OrchestratorInstance resources.
type Orchestrators struct {
	autorest.Response `json:"-"`
	// Value - An array of OrchestratorInstance resources.
	Value *[]Orchestrator `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to get the next set of orchestrators.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for Orchestrators.
func (o Orchestrators) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Value != nil {
		objectMap["value"] = o.Value
	}
	return json.Marshal(objectMap)
}

// OrchestratorsIterator provides access to a complete listing of Orchestrator values.
type OrchestratorsIterator struct {
	i    int
	page OrchestratorsPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OrchestratorsIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrchestratorsIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OrchestratorsIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OrchestratorsIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OrchestratorsIterator) Response() Orchestrators {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OrchestratorsIterator) Value() Orchestrator {
	if !iter.page.NotDone() {
		return Orchestrator{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OrchestratorsIterator type.
func NewOrchestratorsIterator(page OrchestratorsPage) OrchestratorsIterator {
	return OrchestratorsIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (o Orchestrators) IsEmpty() bool {
	return o.Value == nil || len(*o.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (o Orchestrators) hasNextLink() bool {
	return o.NextLink != nil && len(*o.NextLink) != 0
}

// orchestratorsPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (o Orchestrators) orchestratorsPreparer(ctx context.Context) (*http.Request, error) {
	if !o.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(o.NextLink)))
}

// OrchestratorsPage contains a page of Orchestrator values.
type OrchestratorsPage struct {
	fn func(context.Context, Orchestrators) (Orchestrators, error)
	o  Orchestrators
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OrchestratorsPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OrchestratorsPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.o)
		if err != nil {
			return err
		}
		page.o = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OrchestratorsPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OrchestratorsPage) NotDone() bool {
	return !page.o.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OrchestratorsPage) Response() Orchestrators {
	return page.o
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OrchestratorsPage) Values() []Orchestrator {
	if page.o.IsEmpty() {
		return nil
	}
	return *page.o.Value
}

// Creates a new instance of the OrchestratorsPage type.
func NewOrchestratorsPage(cur Orchestrators, getNextPage func(context.Context, Orchestrators) (Orchestrators, error)) OrchestratorsPage {
	return OrchestratorsPage{
		fn: getNextPage,
		o:  cur,
	}
}

// ResourceUpdateParameters parameters for updating a resource.
type ResourceUpdateParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceUpdateParameters.
func (rup ResourceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// SubnetDetails properties of orchestrator
type SubnetDetails struct {
	// ID - subnet arm resource id
	ID *string `json:"id,omitempty"`
}
