package webservices

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AssetType enumerates the values for asset type.
type AssetType string

const (
	// AssetTypeModule ...
	AssetTypeModule AssetType = "Module"
	// AssetTypeResource ...
	AssetTypeResource AssetType = "Resource"
)

// PossibleAssetTypeValues returns an array of possible values for the AssetType const type.
func PossibleAssetTypeValues() []AssetType {
	return []AssetType{AssetTypeModule, AssetTypeResource}
}

// ColumnFormat enumerates the values for column format.
type ColumnFormat string

const (
	// Byte ...
	Byte ColumnFormat = "Byte"
	// Char ...
	Char ColumnFormat = "Char"
	// Complex128 ...
	Complex128 ColumnFormat = "Complex128"
	// Complex64 ...
	Complex64 ColumnFormat = "Complex64"
	// DateTime ...
	DateTime ColumnFormat = "Date-time"
	// DateTimeOffset ...
	DateTimeOffset ColumnFormat = "Date-timeOffset"
	// Double ...
	Double ColumnFormat = "Double"
	// Duration ...
	Duration ColumnFormat = "Duration"
	// Float ...
	Float ColumnFormat = "Float"
	// Int16 ...
	Int16 ColumnFormat = "Int16"
	// Int32 ...
	Int32 ColumnFormat = "Int32"
	// Int64 ...
	Int64 ColumnFormat = "Int64"
	// Int8 ...
	Int8 ColumnFormat = "Int8"
	// Uint16 ...
	Uint16 ColumnFormat = "Uint16"
	// Uint32 ...
	Uint32 ColumnFormat = "Uint32"
	// Uint64 ...
	Uint64 ColumnFormat = "Uint64"
	// Uint8 ...
	Uint8 ColumnFormat = "Uint8"
)

// PossibleColumnFormatValues returns an array of possible values for the ColumnFormat const type.
func PossibleColumnFormatValues() []ColumnFormat {
	return []ColumnFormat{Byte, Char, Complex128, Complex64, DateTime, DateTimeOffset, Double, Duration, Float, Int16, Int32, Int64, Int8, Uint16, Uint32, Uint64, Uint8}
}

// ColumnType enumerates the values for column type.
type ColumnType string

const (
	// Boolean ...
	Boolean ColumnType = "Boolean"
	// Integer ...
	Integer ColumnType = "Integer"
	// Number ...
	Number ColumnType = "Number"
	// String ...
	String ColumnType = "String"
)

// PossibleColumnTypeValues returns an array of possible values for the ColumnType const type.
func PossibleColumnTypeValues() []ColumnType {
	return []ColumnType{Boolean, Integer, Number, String}
}

// DiagnosticsLevel enumerates the values for diagnostics level.
type DiagnosticsLevel string

const (
	// All ...
	All DiagnosticsLevel = "All"
	// Error ...
	Error DiagnosticsLevel = "Error"
	// None ...
	None DiagnosticsLevel = "None"
)

// PossibleDiagnosticsLevelValues returns an array of possible values for the DiagnosticsLevel const type.
func PossibleDiagnosticsLevelValues() []DiagnosticsLevel {
	return []DiagnosticsLevel{All, Error, None}
}

// InputPortType enumerates the values for input port type.
type InputPortType string

const (
	// Dataset ...
	Dataset InputPortType = "Dataset"
)

// PossibleInputPortTypeValues returns an array of possible values for the InputPortType const type.
func PossibleInputPortTypeValues() []InputPortType {
	return []InputPortType{Dataset}
}

// OutputPortType enumerates the values for output port type.
type OutputPortType string

const (
	// OutputPortTypeDataset ...
	OutputPortTypeDataset OutputPortType = "Dataset"
)

// PossibleOutputPortTypeValues returns an array of possible values for the OutputPortType const type.
func PossibleOutputPortTypeValues() []OutputPortType {
	return []OutputPortType{OutputPortTypeDataset}
}

// PackageType enumerates the values for package type.
type PackageType string

const (
	// PackageTypeGraph ...
	PackageTypeGraph PackageType = "Graph"
	// PackageTypeWebServiceProperties ...
	PackageTypeWebServiceProperties PackageType = "WebServiceProperties"
)

// PossiblePackageTypeValues returns an array of possible values for the PackageType const type.
func PossiblePackageTypeValues() []PackageType {
	return []PackageType{PackageTypeGraph, PackageTypeWebServiceProperties}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeBoolean ...
	ParameterTypeBoolean ParameterType = "Boolean"
	// ParameterTypeColumnPicker ...
	ParameterTypeColumnPicker ParameterType = "ColumnPicker"
	// ParameterTypeCredential ...
	ParameterTypeCredential ParameterType = "Credential"
	// ParameterTypeDataGatewayName ...
	ParameterTypeDataGatewayName ParameterType = "DataGatewayName"
	// ParameterTypeDouble ...
	ParameterTypeDouble ParameterType = "Double"
	// ParameterTypeEnumerated ...
	ParameterTypeEnumerated ParameterType = "Enumerated"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeMode ...
	ParameterTypeMode ParameterType = "Mode"
	// ParameterTypeParameterRange ...
	ParameterTypeParameterRange ParameterType = "ParameterRange"
	// ParameterTypeScript ...
	ParameterTypeScript ParameterType = "Script"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeBoolean, ParameterTypeColumnPicker, ParameterTypeCredential, ParameterTypeDataGatewayName, ParameterTypeDouble, ParameterTypeEnumerated, ParameterTypeFloat, ParameterTypeInt, ParameterTypeMode, ParameterTypeParameterRange, ParameterTypeScript, ParameterTypeString}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Provisioning ...
	Provisioning ProvisioningState = "Provisioning"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Unknown ...
	Unknown ProvisioningState = "Unknown"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Failed, Provisioning, Succeeded, Unknown}
}
